/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

import java.awt.Image;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;

public class SystemUtilities {
    public static URL getURL(String path) {
        class ClassLoaderReference {
            ClassLoaderReference() {
            }

            public ClassLoader getClassLoader() {
                ClassLoader cl = this.getClass().getClassLoader();
                return cl;
            }
        }
        ClassLoaderReference clr = new ClassLoaderReference();
        ClassLoader cl = clr.getClassLoader();
        return cl.getResource(path);
    }

    public static String getFile(String path) {
        URL t = SystemUtilities.getURL(path);
        return SystemUtilities.getURL(path).getFile();
    }

    public static boolean isMacOS() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Mac OS");
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    public static void configureMacOSApplication(String appName) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
    }

    public static void configureMacOSApplication(String appName, String dockImagePath) {
        SystemUtilities.configureMacOSApplication(appName);
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", null);
            Object application = method.invoke(null, null);
            Method method2 = application.getClass().getMethod("setDockIconImage", Image.class);
            URL dockImageURL = "".getClass().getResource(dockImagePath);
            Image dockImage = new ImageIcon(dockImageURL).getImage();
            method2.invoke(application, dockImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openBrowserWithURL(URL url) {
        String osName = System.getProperty("os.name");
        try {
            if (SystemUtilities.isMacOS()) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url.toExternalForm());
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"chrome", "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count2 = 0; count2 < browsers.length && browser == null; ++count2) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count2]}).waitFor() != 0) continue;
                    browser = browsers[count2];
                }
                if (browser == null) {
                    throw new RuntimeException("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url.toExternalForm()});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open web browser", e);
        }
    }

    public static String findJarForClass(Class clazz) {
        String name = clazz.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        String jar = clazz.getResource(name + ".class").toString();
        return jar.substring(0, jar.indexOf(33));
    }
}

