/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;
import org.mbari.swing.JImageCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JImageUrlCanvas
extends JImageCanvas {
    private static final long serialVersionUID = -6750506357985486937L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private URL url;
    public static final String PROP_URL = "url";
    private volatile BufferedImage noImage;

    public JImageUrlCanvas() {
    }

    public JImageUrlCanvas(Image image) {
        super(image);
    }

    public JImageUrlCanvas(String strImageURL) throws MalformedURLException {
        this(new URL(strImageURL));
    }

    public JImageUrlCanvas(URL url) {
        this.setUrl(url);
    }

    public URL getUrl() {
        return this.url;
    }

    private BufferedImage getNoImage() {
        if (this.noImage == null) {
            URL noImageUrl = this.getClass().getResource("/images/no_image.jpg");
            try {
                this.noImage = ImageIO.read(noImageUrl);
            }
            catch (IOException e) {
                this.noImage = new BufferedImage(500, 500, 1);
                Graphics2D g = (Graphics2D)this.noImage.getGraphics();
                g.setPaint(this.getBackground());
                g.fillRect(0, 0, this.noImage.getWidth(), this.noImage.getHeight());
                g.setPaint(this.getForeground());
                g.drawString("NO IMAGE " + this.url, 1, 100);
                g.dispose();
            }
        }
        return this.noImage;
    }

    public void setUrl(URL newUrl) {
        if (newUrl == null || !newUrl.equals(this.url)) {
            if (newUrl == null) {
                this.url = null;
                this.setImage(this.getNoImage());
            } else {
                this.url = newUrl;
                new ImageLoader().execute();
            }
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            super.setImage(this.getNoImage());
        } else {
            super.setImage(image);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageLoader
    extends SwingWorker<BufferedImage, Object> {
        private ImageLoader() {
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            BufferedImage bufferedImage = null;
            if (JImageUrlCanvas.this.url != null) {
                JImageUrlCanvas.this.log.debug("Reading image from " + JImageUrlCanvas.this.url);
                bufferedImage = ImageIO.read(JImageUrlCanvas.this.url);
            }
            return bufferedImage;
        }

        @Override
        protected void done() {
            try {
                Image newImage = (Image)this.get();
                JImageUrlCanvas.this.log.debug("Image " + JImageUrlCanvas.this.url + " [" + newImage.getWidth(JImageUrlCanvas.this) + " x " + newImage.getHeight(JImageUrlCanvas.this) + " pixels] has been loaded");
                JImageUrlCanvas.this.setImage(newImage);
            }
            catch (Exception e) {
                BufferedImage image = new BufferedImage(800, 200, 1);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(JImageUrlCanvas.this.getBackground());
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.setPaint(JImageUrlCanvas.this.getForeground());
                g.drawString("Failed to read: " + JImageUrlCanvas.this.url, 1, 100);
                g.dispose();
                JImageUrlCanvas.this.setImage(image);
                JImageUrlCanvas.this.log.debug("Failed to read image", e);
            }
        }
    }
}

