/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;
import org.mbari.swing.AnimatedIcon;

public abstract class AbstractAnimatedIcon
extends AnimatedIcon {
    private static final int DEFAULT_INTERVAL = 41;
    private int frame;
    private int frameCount;
    private int repaintInterval;
    private Timer timer;

    protected AbstractAnimatedIcon() {
        this(0);
    }

    protected AbstractAnimatedIcon(int frameCount) {
        this(frameCount, 41);
    }

    protected AbstractAnimatedIcon(int frameCount, int interval) {
        this.frameCount = frameCount;
        this.setFrameInterval(interval);
    }

    protected void finalize() {
        this.timer.stop();
    }

    public int getFrame() {
        return this.frame;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrameInterval() {
        return this.repaintInterval;
    }

    public abstract int getIconHeight();

    public abstract int getIconWidth();

    public void nextFrame() {
        this.setFrame(this.getFrame() + 1);
    }

    protected abstract void paintFrame(Component var1, Graphics var2, int var3, int var4);

    protected synchronized void registerRepaintArea(Component c, int x, int y, int w, int h) {
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
        super.registerRepaintArea(c, x, y, w, h);
    }

    public void setFrame(int f) {
        this.frame = f;
        if (this.frameCount != 0) {
            this.frame %= this.frameCount;
        }
        this.repaint();
    }

    public void setFrameInterval(int interval) {
        this.repaintInterval = interval;
        if (interval != 0) {
            if (this.timer == null) {
                this.timer = new Timer(interval, new AnimationUpdater(this));
                this.timer.setRepeats(true);
            } else {
                this.timer.setDelay(interval);
            }
        } else if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private static class AnimationUpdater
    implements ActionListener {
        private WeakReference ref;

        public AnimationUpdater(AbstractAnimatedIcon icon) {
            this.ref = new WeakReference<AbstractAnimatedIcon>(icon);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractAnimatedIcon icon = (AbstractAnimatedIcon)this.ref.get();
            if (icon != null) {
                icon.nextFrame();
            }
        }
    }
}

