/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.gis;

import org.mbari.geometry.Envelope;
import org.mbari.geometry.Point2D;
import org.mbari.gis.DEMAccess;
import org.mbari.math.Matlib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEMRasterGrid
implements DEMAccess {
    private double[] x;
    private double[] y;
    private float[][] z;
    private Envelope<Double> envelope;

    public DEMRasterGrid(double[] y, double[] x, float[][] z) {
        if (x.length != z[0].length || y.length != z.length) {
            throw new RuntimeException("Dimensions of z do not match the length of the x and y axes!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBounds();
    }

    private void setBounds() {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        if (this.x[0] < this.x[this.x.length - 1]) {
            xMin = this.x[0];
            xMax = this.x[this.x.length - 1];
        } else {
            xMin = this.x[this.x.length - 1];
            xMax = this.x[0];
        }
        if (this.y[0] < this.y[this.y.length - 1]) {
            yMin = this.y[0];
            yMax = this.y[this.y.length - 1];
        } else {
            yMin = this.y[this.y.length - 1];
            yMax = this.y[0];
        }
        Point2D<Double> lowerLeftCorner = new Point2D<Double>(xMin, yMin);
        Point2D<Double> upperRightCorner = new Point2D<Double>(xMax, yMax);
        this.envelope = new Envelope<Double>(lowerLeftCorner, upperRightCorner);
    }

    @Override
    public Envelope<Double> getEnvelope() {
        return this.envelope;
    }

    @Override
    public double[] getX() {
        return this.x;
    }

    @Override
    public double[] getY() {
        return this.y;
    }

    @Override
    public float getZ(double xa, double ya) {
        Integer ix = Matlib.nearInclusive(this.x, xa);
        Integer iy = null;
        float za = Float.NaN;
        if (ix != null && (iy = Matlib.nearInclusive(this.y, ya)) != null) {
            za = this.z[iy][ix];
        }
        return za;
    }

    public float getZ(int ix, int iy) {
        return this.z[iy][ix];
    }
}

