/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.geometry;

import org.mbari.geometry.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point3D<T extends Number>
extends Point2D<T> {
    private final T z;

    public Point3D(T x, T y, T z) {
        super(x, y);
        this.z = z;
    }

    public T getZ() {
        return this.z;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point3D other = (Point3D)obj;
        return super.equals(obj) || this.z == other.z || this.z != null && this.z.equals(other.z);
    }

    @Override
    public int hashCode() {
        int hash = 7 + super.hashCode();
        hash = 53 * hash + (this.z != null ? this.z.hashCode() : 0);
        return hash;
    }

    public Double getDistance(Point3D<? extends Number> that) {
        double x1 = ((Number)that.getX()).doubleValue();
        double y1 = ((Number)that.getY()).doubleValue();
        double z1 = that.getZ().doubleValue();
        double x0 = ((Number)this.getX()).doubleValue();
        double y0 = ((Number)this.getY()).doubleValue();
        double z0 = ((Number)this.getZ()).doubleValue();
        double dx = Math.pow(x1 - x0, 2.0);
        double dy = Math.pow(y1 - y0, 2.0);
        double dz = Math.pow(z1 - z0, 2.0);
        return Math.sqrt(dx + dy + dz);
    }

    @Override
    public String toString() {
        return this.getX() + "," + this.getY() + "," + this.getZ();
    }
}

