/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.awt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;

public class WrappingFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = 1613933502134990283L;
    private Dimension preferredLayoutSize;

    public WrappingFlowLayout() {
    }

    public WrappingFlowLayout(int align) {
        super(align);
    }

    public WrappingFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    private void addRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    public void layoutContainer(final Container target) {
        super.layoutContainer(target);
        Dimension size2 = this.preferredLayoutSize(target);
        if (!size2.equals(this.preferredLayoutSize)) {
            this.preferredLayoutSize = size2;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    target.invalidate();
                    target.getParent().validate();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxWidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Dimension d;
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension dimension = d = preferred ? m.getPreferredSize() : new Dimension(20, 20);
                if (rowWidth + d.width > maxWidth) {
                    this.addRow(dim, rowWidth, rowHeight);
                    rowWidth = 0;
                    rowHeight = 0;
                }
                if (rowWidth > 0) {
                    rowWidth += this.getHgap();
                }
                rowWidth += d.width;
                rowHeight = Math.max(rowHeight, d.height);
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += insets.left + insets.right + this.getHgap() * 2;
            dim.height += insets.top + insets.bottom + this.getVgap() * 2;
            return dim;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }
}

