/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import javax.swing.SwingUtilities;

public class WaitCursorEventQueue
extends EventQueue {
    private int delay;
    private WaitCursorTimer waitTimer;

    public WaitCursorEventQueue(int delay) {
        this.delay = delay;
        this.waitTimer = new WaitCursorTimer();
        this.waitTimer.setDaemon(true);
        this.waitTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent event) {
        this.waitTimer.startTimer(event.getSource());
        try {
            super.dispatchEvent(event);
        }
        finally {
            this.waitTimer.stopTimer();
        }
    }

    private class WaitCursorTimer
    extends Thread {
        private Component parent;
        private Object source;

        private WaitCursorTimer() {
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        MenuContainer mParent;
                        this.wait();
                        this.wait(WaitCursorEventQueue.this.delay);
                        if (this.source instanceof Component) {
                            this.parent = SwingUtilities.getRoot((Component)this.source);
                        } else if (this.source instanceof MenuComponent && (mParent = ((MenuComponent)this.source).getParent()) instanceof Component) {
                            this.parent = SwingUtilities.getRoot((Component)mParent);
                        }
                        if (this.parent == null || !this.parent.isShowing()) continue;
                        this.parent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        synchronized void startTimer(Object source) {
            this.source = source;
            this.notify();
        }

        synchronized void stopTimer() {
            if (this.parent == null) {
                this.interrupt();
            } else {
                this.parent.setCursor(null);
                this.parent = null;
            }
        }
    }
}

