/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.TileCodecUtils;
import java.awt.image.SampleModel;
import java.io.InputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.tilecodec.JaiI18N;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoder;

public abstract class TileDecoderImpl
implements TileDecoder {
    protected String formatName;
    protected InputStream inputStream;
    protected TileCodecParameterList paramList;

    public TileDecoderImpl(String formatName, InputStream input2, TileCodecParameterList param2) {
        if (formatName == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileCodecDescriptorImpl0"));
        }
        if (input2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl0"));
        }
        TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileDecoder", formatName);
        if (param2 == null) {
            param2 = tcd.getDefaultParameters("tileDecoder");
        }
        if (param2 != null) {
            if (!param2.getFormatName().equalsIgnoreCase(formatName)) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl1"));
            }
            if (!param2.isValidForMode("tileDecoder")) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl2"));
            }
            if (!param2.getParameterListDescriptor().equals(tcd.getParameterListDescriptor("tileDecoder"))) {
                throw new IllegalArgumentException(JaiI18N.getString("TileCodec0"));
            }
            SampleModel sm = null;
            if (!tcd.includesSampleModelInfo()) {
                try {
                    sm = (SampleModel)param2.getObjectParameter("sampleModel");
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl3"));
                }
                if ((sm == null || sm == ParameterListDescriptor.NO_PARAMETER_DEFAULT) && tcd.getParameterListDescriptor("tileDecoder").getParamDefaultValue("sampleModel") == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl4"));
                }
            }
        } else {
            ParameterListDescriptor pld = tcd.getParameterListDescriptor("tileDecoder");
            if (!tcd.includesSampleModelInfo()) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl5"));
            }
            if (pld != null && pld.getNumParameters() != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl6"));
            }
        }
        this.formatName = formatName;
        this.inputStream = input2;
        this.paramList = param2;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public TileCodecParameterList getDecodeParameterList() {
        return this.paramList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

