/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();

    public static String escapeTags(String input2) {
        if (input2 == null || input2.length() == 0 || input2.indexOf("<") == -1 && input2.indexOf(">") == -1) {
            return input2;
        }
        StringBuffer buf = new StringBuffer(input2);
        return Transform.escapeTags(buf);
    }

    public static String escapeTags(StringBuffer buf) {
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ch == '<') {
                buf.replace(i, i + 1, "&lt;");
                continue;
            }
            if (ch != '>') continue;
            buf.replace(i, i + 1, "&gt;");
        }
        return buf.toString();
    }

    public static void appendEscapingCDATA(StringBuilder output, String str) {
        if (str == null) {
            return;
        }
        int end = str.indexOf(CDATA_END);
        if (end < 0) {
            output.append(str);
            return;
        }
        int start = 0;
        while (end > -1) {
            output.append(str.substring(start, end));
            output.append(CDATA_EMBEDED_END);
            start = end + CDATA_END_LEN;
            if (start < str.length()) {
                end = str.indexOf(CDATA_END, start);
                continue;
            }
            return;
        }
        output.append(str.substring(start));
    }
}

