/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import org.mbari.vcr4j.VideoIndex;

public class VideoIndexAsString {
    private final String string;

    public VideoIndexAsString(VideoIndex index) {
        StringBuilder sb = new StringBuilder("{name:'VideoIndex',class:'").append(index.getClass().getName()).append("'");
        index.getElapsedTime().ifPresent(duration -> {
            double minutes = (double)duration.toMillis() / 1000.0 / 60.0;
            sb.append(",elapsed_time_minutes:").append(minutes);
        });
        index.getTimecode().ifPresent(timecode -> sb.append(",timecode:'").append(timecode.toString()).append("'"));
        index.getTimestamp().ifPresent(instant -> sb.append(",timestamp:'").append(instant).append("'"));
        sb.append("}");
        this.string = sb.toString();
    }

    public String toString() {
        return this.string;
    }
}

