/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.Decorator;

public class SchedulerVideoIO<S extends VideoState, E extends VideoError>
implements VideoIO<S, E>,
Decorator {
    private final VideoIO io;
    private final Observable<E> errorObservable;
    private final Observable<S> stateObservable;
    private final Observable<VideoIndex> indexObservable;
    private final CommandQueue commandQueue = new CommandQueue();
    private final Subject<VideoCommand> commandSubject;
    private final Scheduler scheduler;
    private final Observer<VideoCommand> commandObserver;
    private final List<Disposable> disposables = new ArrayList<Disposable>();

    public SchedulerVideoIO(VideoIO<S, E> io, Executor executor) {
        this(io, Schedulers.from((Executor)executor));
    }

    public SchedulerVideoIO(final VideoIO<S, E> io, Scheduler scheduler) {
        this.io = io;
        this.scheduler = scheduler;
        this.errorObservable = io.getErrorObservable().observeOn(scheduler);
        this.stateObservable = io.getStateObservable().observeOn(scheduler);
        this.indexObservable = io.getIndexObservable().observeOn(scheduler);
        this.commandObserver = new Observer<VideoCommand>(){

            public void onComplete() {
                io.getCommandSubject().onComplete();
            }

            public void onError(Throwable throwable) {
                io.getCommandSubject().onError(throwable);
            }

            public void onNext(VideoCommand videoCommand) {
                SchedulerVideoIO.this.commandQueue.send(videoCommand);
            }

            public void onSubscribe(Disposable disposable) {
                SchedulerVideoIO.this.disposables.add(disposable);
            }
        };
        PublishSubject subject = PublishSubject.create();
        this.commandSubject = subject.toSerialized();
        this.commandSubject.subscribe(this.commandObserver);
    }

    @Override
    public void unsubscribe() {
        this.disposables.forEach(Disposable::dispose);
        this.errorObservable.unsubscribeOn(this.scheduler);
        this.stateObservable.unsubscribeOn(this.scheduler);
        this.indexObservable.unsubscribeOn(this.scheduler);
        this.commandQueue.kill();
    }

    @Override
    public void send(VideoCommand videoCommand) {
        this.commandSubject.onNext((Object)videoCommand);
    }

    @Override
    public Subject<VideoCommand> getCommandSubject() {
        return this.commandSubject;
    }

    @Override
    public String getConnectionID() {
        return this.io.getConnectionID();
    }

    @Override
    public void close() {
        this.unsubscribe();
        this.io.close();
    }

    @Override
    public Observable<E> getErrorObservable() {
        return this.errorObservable;
    }

    @Override
    public Observable<S> getStateObservable() {
        return this.stateObservable;
    }

    @Override
    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    private class CommandQueue {
        final BlockingQueue<VideoCommand> pendingQueue = new LinkedBlockingQueue<VideoCommand>();
        final Thread thread;
        AtomicBoolean isRunning = new AtomicBoolean(true);
        final Runnable runnable = () -> {
            while (this.isRunning.get()) {
                VideoCommand videoCommand = null;
                try {
                    videoCommand = this.pendingQueue.poll(3600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (videoCommand == null) continue;
                SchedulerVideoIO.this.io.getCommandSubject().onNext((Object)videoCommand);
            }
        };

        void kill() {
            this.isRunning.set(false);
        }

        void send(VideoCommand videoCommand) {
            this.pendingQueue.offer(videoCommand);
        }

        public CommandQueue() {
            this.thread = new Thread(this.runnable, SchedulerVideoIO.this.getClass().getSimpleName());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }
}

