/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.decorators;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.decorators.VideoCommandAsString;
import org.mbari.vcr4j.decorators.VideoErrorAsString;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.decorators.VideoStateAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDecorator<S extends VideoState, E extends VideoError>
implements Decorator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    List<Disposable> disposables = new ArrayList<Disposable>();
    protected final Observer<E> errorSubscriber = new Observer<E>(){

        public void onComplete() {
            LoggingDecorator.this.log.debug("Error observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the error observable", throwable);
        }

        public void onNext(E error) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoErrorAsString((VideoError)error).toString());
            }
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<VideoIndex> indexSubscriber = new Observer<VideoIndex>(){

        public void onComplete() {
            LoggingDecorator.this.log.debug("Index observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the index observable", throwable);
        }

        public void onNext(VideoIndex index) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoIndexAsString(index).toString());
            }
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<S> stateSubscriber = new Observer<S>(){

        public void onComplete() {
            LoggingDecorator.this.log.debug("State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the state observable", throwable);
        }

        public void onNext(S state) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Received: " + new VideoStateAsString((VideoState)state).toString());
            }
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };
    protected final Observer<VideoCommand> commandSubscriber = new Observer<VideoCommand>(){

        public void onComplete() {
            LoggingDecorator.this.log.debug("State observable is closed");
        }

        public void onError(Throwable throwable) {
            LoggingDecorator.this.log.debug("An error occurred in the state observable", throwable);
        }

        public void onNext(VideoCommand command) {
            if (LoggingDecorator.this.log.isDebugEnabled()) {
                LoggingDecorator.this.log.debug("Sending: " + new VideoCommandAsString(command).toString());
            }
        }

        public void onSubscribe(Disposable disposable) {
            LoggingDecorator.this.disposables.add(disposable);
        }
    };

    public LoggingDecorator(VideoIO<S, E> io) {
        io.getCommandSubject().subscribe(this.commandSubscriber);
        io.getErrorObservable().subscribe(this.errorSubscriber);
        io.getStateObservable().subscribe(this.stateSubscriber);
        io.getIndexObservable().subscribe(this.indexSubscriber);
    }

    @Override
    public void unsubscribe() {
        this.disposables.forEach(Disposable::dispose);
    }
}

