/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j;

import io.reactivex.Observable;
import java.time.Duration;
import java.time.Instant;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.SeekTimestampCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.time.Timecode;

public class VideoController<S extends VideoState, E extends VideoError> {
    private final VideoIO<S, E> io;

    public VideoController(VideoIO<S, E> io) {
        this.io = io;
    }

    public void fastForward() {
        this.io.send(VideoCommands.FAST_FORWARD);
    }

    public void play() {
        this.io.send(VideoCommands.PLAY);
    }

    public void rewind() {
        this.io.send(VideoCommands.REWIND);
    }

    public void requestIndex() {
        this.io.send(VideoCommands.REQUEST_INDEX);
    }

    public void requestElapsedTime() {
        this.io.send(VideoCommands.REQUEST_ELAPSED_TIME);
    }

    public void requestStatus() {
        this.io.send(VideoCommands.REQUEST_STATUS);
    }

    public void requestTimestamp() {
        this.io.send(VideoCommands.REQUEST_TIMESTAMP);
    }

    public void requestTimecode() {
        this.io.send(VideoCommands.REQUEST_TIMECODE);
    }

    public void seek(Duration elapsedTime) {
        this.io.send(new SeekElapsedTimeCmd(elapsedTime));
    }

    public void seek(Instant timestamp) {
        this.io.send(new SeekTimestampCmd(timestamp));
    }

    public void seek(Timecode timecode) {
        this.io.send(new SeekTimecodeCmd(timecode));
    }

    public <A extends VideoCommand> void send(A command) {
        this.io.send(command);
    }

    public void shuttle(double rate) {
        this.io.send(new ShuttleCmd(rate));
    }

    public void stop() {
        this.io.send(VideoCommands.STOP);
    }

    public Observable<E> getErrorObservable() {
        return this.io.getErrorObservable();
    }

    public Observable<S> getStateObservable() {
        return this.io.getStateObservable();
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.io.getIndexObservable();
    }

    public VideoIO<S, E> getVideoIO() {
        return this.io;
    }
}

