/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.util.ArrayList;
import java.util.List;
import org.docopt.DocoptExitException;
import org.docopt.DocoptLanguageError;
import org.docopt.Python;

final class Tokens
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Throwable> error;

    public static Tokens withExitException(List<String> source) {
        return new Tokens(source, DocoptExitException.class);
    }

    public static Tokens withLanguageError(List<String> source) {
        return new Tokens(source, DocoptLanguageError.class);
    }

    public Tokens(List<String> source, Class<? extends Throwable> error) {
        this.addAll(source);
        this.error = error;
    }

    public static Tokens fromPattern(String source) {
        source = Python.Re.sub("([\\[\\]\\(\\)\\|]|\\.\\.\\.)", " $1 ", source);
        List<String> $source = Python.list();
        for (String s : Python.Re.split("\\s+|(\\S*<.*?>)", source)) {
            if (!Python.bool(s)) continue;
            $source.add(s);
        }
        return Tokens.withLanguageError($source);
    }

    public String move() {
        String result = this.isEmpty() ? null : (String)this.remove(0);
        return result;
    }

    public String current() {
        String result = this.isEmpty() ? null : (String)this.get(0);
        return result;
    }

    public Class<? extends Throwable> getError() {
        return this.error;
    }

    public IllegalStateException error(String format, Object ... args) {
        String message = String.format(format, args);
        if (this.error == DocoptLanguageError.class) {
            throw new DocoptLanguageError(message);
        }
        if (this.error == DocoptExitException.class) {
            throw new DocoptExitException(1, message, true);
        }
        return new IllegalStateException("Unexpected exception: " + this.error.getClass().getName());
    }
}

