/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.util.List;
import org.docopt.LeafPattern;
import org.docopt.Python;

final class Option
extends LeafPattern {
    private final String $short;
    private final String $long;
    private final int argCount;

    public Option(String $short, String $long, int argCount, Object value) {
        super($long != null ? $long : $short, Boolean.FALSE.equals(value) && argCount != 0 ? null : value);
        assert (argCount == 0 || argCount == 1);
        this.$short = $short;
        this.$long = $long;
        this.argCount = argCount;
    }

    public Option(String $short, String $long, int argCount) {
        this($short, $long, argCount, false);
    }

    public Option(String $short, String $long) {
        this($short, $long, 0);
    }

    public static Option parse(String optionDescription) {
        String $short = null;
        String $long = null;
        int argCount = 0;
        Boolean value = false;
        String[] a = Python.partition(optionDescription.trim(), "  ");
        String options = a[0];
        String description = a[2];
        options = options.replaceAll(",", " ").replaceAll("=", " ");
        for (String s : Python.split(options)) {
            if (s.startsWith("--")) {
                $long = s;
                continue;
            }
            if (s.startsWith("-")) {
                $short = s;
                continue;
            }
            argCount = 1;
        }
        if (argCount != 0) {
            List<String> matched = Python.Re.findAll("\\[default: (.*)\\]", description, 2);
            value = Python.bool(matched) ? matched.get(0) : null;
        }
        return new Option($short, $long, argCount, value);
    }

    @Override
    protected LeafPattern.SingleMatchResult singleMatch(List<LeafPattern> left) {
        for (int n = 0; n < left.size(); ++n) {
            LeafPattern pattern = left.get(n);
            if (!this.getName().equals(pattern.getName())) continue;
            return new LeafPattern.SingleMatchResult(n, pattern);
        }
        return new LeafPattern.SingleMatchResult(null, null);
    }

    public String getShort() {
        return this.$short;
    }

    public String getLong() {
        return this.$long;
    }

    public int getArgCount() {
        return this.argCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.$long == null ? 0 : this.$long.hashCode());
        result = 31 * result + (this.$short == null ? 0 : this.$short.hashCode());
        result = 31 * result + this.argCount;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (this.$long == null ? other.$long != null : !this.$long.equals(other.$long)) {
            return false;
        }
        if (this.$short == null ? other.$short != null : !this.$short.equals(other.$short)) {
            return false;
        }
        return this.argCount == other.argCount;
    }

    @Override
    public String toString() {
        return String.format("%s(%s, %s, %s, %s)", this.getClass().getSimpleName(), Python.repr(this.$short), Python.repr(this.$long), Python.repr(this.argCount), Python.repr(this.getValue()));
    }
}

