/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;
import spire.math.prime.Siever;

public final class package$ {
    public static package$ MODULE$;
    private final Random srand;
    private final int SieveSize;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(40);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject((Number)((Object)n0), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        if (BoxesRunTime.equalsNumNum((Number)((Object)n), (Number)((Object)SafeLong$.MODULE$.one()))) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n;
        Tuple2<SafeLong, Object> tuple2 = this.findPowers(n, SafeLong$.MODULE$.apply(2L));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n2 = tuple2._2$mcI$sp();
        Object object = tuple2._1();
        SafeLong x1 = (SafeLong)((Object)object);
        if (n2 > 0) {
            facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)n2));
            x = x1;
        }
        SafeLong limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
        SafeLong index$macro$540 = SafeLong$.MODULE$.apply(3L);
        while (index$macro$540.$less$eq((Object)limit) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple22 = this.findPowers(x, index$macro$540);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int n3 = tuple22._2$mcI$sp();
            Object object2 = tuple22._1();
            SafeLong x2 = (SafeLong)((Object)object2);
            if (n3 > 0) {
                facts.update((Object)index$macro$540, (Object)BoxesRunTime.boxToInteger((int)n3));
                x = x2;
                limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
            }
            index$macro$540 = index$macro$540.$plus(2L);
        }
        if (x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
        }
        return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject((Number)((Object)n0), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)1))) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n;
        Tuple2<SafeLong, Object> tuple2 = this.findPowers(n, SafeLong$.MODULE$.apply(2L));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n2 = tuple2._2$mcI$sp();
        Object object = tuple2._1();
        SafeLong x1 = (SafeLong)((Object)object);
        if (n2 > 0) {
            facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)n2));
            x = x1;
        }
        SafeLong index$macro$541 = SafeLong$.MODULE$.apply(3L);
        while (index$macro$541.$less((Object)SafeLong$.MODULE$.apply(30L)) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple22 = this.findPowers(x, index$macro$541);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int n3 = tuple22._2$mcI$sp();
            Object object2 = tuple22._1();
            SafeLong x2 = (SafeLong)((Object)object2);
            if (n3 > 0) {
                facts.update((Object)index$macro$541, (Object)BoxesRunTime.boxToInteger((int)n3));
                x = x2;
            }
            index$macro$541 = index$macro$541.$plus(2L);
        }
        SafeLong limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
        SafeLong b = SafeLong$.MODULE$.apply(31L);
        int i = 0;
        int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
        while (b.$less$eq((Object)limit) && x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple23 = this.findPowers(x, b);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            int n4 = tuple23._2$mcI$sp();
            Object object3 = tuple23._1();
            SafeLong x2 = (SafeLong)((Object)object3);
            if (n4 > 0) {
                facts.update((Object)b, (Object)BoxesRunTime.boxToInteger((int)n4));
                x = x2;
                limit = (SafeLong)((Object)SafeLong$.MODULE$.SafeLongAlgebra().sqrt((Object)x));
            }
            b = b.$plus(offsets[i]);
            i = (i + 1) % 10;
        }
        if (x.$greater((Object)SafeLong$.MODULE$.apply(1L))) {
            facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
        }
        return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
    }

    public Factors factorPollardRho(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject((Number)((Object)n0), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)1))) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        if (n0.$less((Object)SafeLong$.MODULE$.apply(0L))) {
            return this.factor$1(n).unary_$minus();
        }
        return this.factor$1(n);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits = n.bitLength();
        BigInteger x = new BigInteger(bits, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater((Object)SafeLong$.MODULE$.apply(1L)) && BoxesRunTime.equalsNumObject((Number)((Object)x.$percent(b)), (Object)BoxesRunTime.boxToInteger((int)0))) {
            ++e;
            x = x.$div(b);
        }
        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)e));
    }

    private int SieveSize() {
        return this.SieveSize;
    }

    public Siever sieverUpToNth(long n) {
        double upper = (double)n * spire.math.package$.MODULE$.log(n) + (double)n * spire.math.package$.MODULE$.log(spire.math.package$.MODULE$.log((double)n - 0.9385));
        long cutoff = spire.math.package$.MODULE$.max(1000L, (long)(spire.math.package$.MODULE$.sqrt(upper) + (double)512L));
        return new Siever(this.SieveSize(), SafeLong$.MODULE$.apply(cutoff));
    }

    public SafeLong nth(long n) {
        return this.sieverUpToNth(n).nth(n);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] fill(int n) {
        void var3_3;
        if (n <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        }
        if (n == 1) {
            return (SafeLong[])((Object[])new SafeLong[]{SafeLong$.MODULE$.two()});
        }
        Siever siever = this.sieverUpToNth(n);
        SafeLong[] arr = new SafeLong[n];
        arr[0] = SafeLong$.MODULE$.two();
        arr[1] = SafeLong$.MODULE$.three();
        this.loop$1(2, SafeLong$.MODULE$.three(), siever, arr);
        return var3_3;
    }

    public SafeLong[] fill(int start, int limit) {
        if (start == 0) {
            return this.fill(limit);
        }
        Siever siever = this.sieverUpToNth(start + limit);
        return this.loop$2(1, SafeLong$.MODULE$.three(), start, limit, siever);
    }

    public Stream<SafeLong> stream() {
        return this.stream(this.SieveSize(), SafeLong$.MODULE$.apply(1000000L));
    }

    /*
     * WARNING - void declaration
     */
    public Stream<SafeLong> stream(int chunkSize, SafeLong cutoff) {
        void consWrapper_stream;
        SafeLong safeLong = SafeLong$.MODULE$.two();
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            void consWrapper_stream;
            SafeLong safeLong = SafeLong$.MODULE$.three();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> new Siever(chunkSize, cutoff).streamAfter(SafeLong$.MODULE$.three());
            if (Stream$.MODULE$ == null) {
                throw null;
            }
            return new Stream.ConsWrapper((Function0)consWrapper_stream).$hash$colon$colon((Object)safeLong);
        };
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        return new Stream.ConsWrapper((Function0)consWrapper_stream).$hash$colon$colon((Object)safeLong);
    }

    private static final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$542 = 0;
            while (r.$greater((Object)SafeLong$.MODULE$.apply(index$macro$542))) {
                y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                ++index$macro$542;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater((Object)k) && BoxesRunTime.equalsNumObject((Number)((Object)g), (Object)BoxesRunTime.boxToInteger((int)1))) {
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$543 = 0;
                while (limit.$greater((Object)SafeLong$.MODULE$.apply(index$macro$543))) {
                    y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$543;
                }
                g = BoxesRunTime.equalsNumObject((Number)((Object)q), (Object)BoxesRunTime.boxToInteger((int)0)) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            if (!BoxesRunTime.equalsNumObject((Number)((Object)g), (Object)BoxesRunTime.boxToInteger((int)1))) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        if (BoxesRunTime.equalsNumNum((Number)((Object)g), (Number)((Object)n$1))) {
            return this.slowRho$1(x, ys, n$1, c$1);
        }
        return g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong safeLong;
        SafeLong g;
        while (BoxesRunTime.equalsNumObject((Number)((Object)(g = n$1.gcd(x.$minus(safeLong = ys.$times(ys).$percent(n$1).$plus(c$1).$percent(n$1)).abs()))), (Object)BoxesRunTime.boxToInteger((int)1))) {
            ys = safeLong;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)1))) {
            return Factors$.MODULE$.one();
        }
        if (this.isPrime(n)) {
            return new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)n, (Object)BoxesRunTime.boxToInteger((int)1))}))), Sign$Positive$.MODULE$);
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)n.$percent(2L)), (Object)BoxesRunTime.boxToInteger((int)0))) {
            SafeLong x = n.$div(2L);
            int e = 1;
            while (BoxesRunTime.equalsNumObject((Number)((Object)x.$percent(2L)), (Object)BoxesRunTime.boxToInteger((int)0))) {
                x = x.$div(2L);
                ++e;
            }
            return new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)e))}))), Sign$Positive$.MODULE$).$times(this.factor$1(x));
        }
        SafeLong divisor = this.rho$1(n, this.rand(n));
        while (BoxesRunTime.equalsNumNum((Number)((Object)divisor), (Number)((Object)n))) {
            divisor = this.rho$1(n, this.rand(n));
        }
        return this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
    }

    private final void loop$1(int i, SafeLong last, Siever siever$1, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            SafeLong p;
            arr$1[i] = p = siever$1.nextAfter(last);
            last = p;
            ++i;
        }
    }

    private final SafeLong[] loop$2(int i, SafeLong p, int start$1, int limit$1, Siever siever$2) {
        while (i < start$1) {
            p = siever$2.nextAfter(p);
            ++i;
        }
        return siever$2.arrayAt(p, limit$1);
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
        this.SieveSize = 9600000;
    }
}

