/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.io.Serializable;
import java.math.BigDecimal;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import spire.math.Interval;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.poly.RootIsolator;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;
import spire.std.package$bigInt$;

public final class Roots$ {
    public static Roots$ MODULE$;

    static {
        new Roots$();
    }

    public final <A> Vector<Interval<Rational>> isolateRoots(Polynomial<A> poly, RootIsolator<A> isolator) {
        return isolator.isolateRoots(poly);
    }

    /*
     * WARNING - void declaration
     */
    public final Polynomial<BigInt> removeFractions(Polynomial<Rational> poly) {
        void foldLeft_foldLeft$_foldLeft_foldl_end;
        void foldLeft_z;
        Rational[] coeffs = (Rational[])poly.coeffsArray(Rational$.MODULE$.RationalAlgebra());
        BigInt bigInt = scala.package$.MODULE$.BigInt().apply(1);
        ArrayOps.ofRef foldLeft_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coeffs));
        void var9_5 = foldLeft_z;
        int n = foldLeft_this.length();
        for (int foldLeft_foldLeft$_foldLeft_foldl_start = 0; foldLeft_foldLeft$_foldLeft_foldl_start != foldLeft_foldLeft$_foldLeft_foldl_end; ++foldLeft_foldLeft$_foldLeft_foldl_start) {
            BigInt foldLeft_foldLeft$_foldLeft_foldl_z;
            foldLeft_foldLeft$_foldLeft_foldl_z = Roots$.$anonfun$removeFractions$1(foldLeft_foldLeft$_foldLeft_foldl_z, (Rational)((Object)foldLeft_this.apply(foldLeft_foldLeft$_foldLeft_foldl_start)));
        }
        void factors = var9_5;
        BigInt[] zCoeffs = (BigInt[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coeffs)), arg_0 -> Roots$.$anonfun$removeFractions$2((BigInt)factors, arg_0), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BigInt.class)));
        return Polynomial$.MODULE$.dense(zCoeffs, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
    }

    /*
     * WARNING - void declaration
     */
    public final Polynomial<BigInt> removeDecimal(Polynomial<scala.math.BigDecimal> poly) {
        Object object;
        void map_bf;
        Object object2;
        void map_bf2;
        Object object3;
        void map_bf3;
        Polynomial<scala.math.BigDecimal> polynomial = poly;
        Polynomial<scala.math.BigDecimal> polynomial2 = Polynomial$.MODULE$.zero(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class));
        if (!(polynomial != null ? !((Object)polynomial).equals(polynomial2) : polynomial2 != null)) {
            return Polynomial$.MODULE$.zero(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        }
        List<Term<scala.math.BigDecimal>> list = poly.terms(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(x0$1);
            }
            Term<BigDecimal> term = new Term<BigDecimal>(((scala.math.BigDecimal)x0$1.coeff()).bigDecimal().stripTrailingZeros(), x0$1.exp());
            return term;
        };
        if (list == null) {
            throw null;
        }
        List<Term<scala.math.BigDecimal>> map_this = list;
        if (map_bf3 == List$.MODULE$.ReusableCBF()) {
            if (map_this == Nil$.MODULE$) {
                object3 = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)Roots$.$anonfun$removeDecimal$1((Term)map_this.head()), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)Roots$.$anonfun$removeDecimal$1((Term)map_rest.head()), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object3 = map_h;
            }
        } else {
            void map_f;
            object3 = TraversableLike.map$(map_this, (Function1)map_f, (CanBuildFrom)map_bf3);
        }
        List terms = (List)object3;
        CanBuildFrom canBuildFrom2 = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Roots$.$anonfun$removeDecimal$2(x$1));
        if (terms == null) {
            throw null;
        }
        if (map_bf2 == List$.MODULE$.ReusableCBF()) {
            if (terms == Nil$.MODULE$) {
                object2 = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Roots$.$anonfun$removeDecimal$2((Term)terms.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)terms.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Roots$.$anonfun$removeDecimal$2((Term)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object2 = map_h;
            }
        } else {
            void map_f;
            object2 = TraversableLike.map$((TraversableLike)terms, (Function1)map_f, (CanBuildFrom)map_bf2);
        }
        int maxScale = BoxesRunTime.unboxToInt((Object)((TraversableOnce)object2).max((Ordering)Ordering.Int$.MODULE$));
        CanBuildFrom canBuildFrom3 = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable map_f = (Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(x0$2);
            }
            BigInt c0 = scala.package$.MODULE$.BigInt().apply(((BigDecimal)x0$2.coeff()).movePointRight(maxScale).unscaledValue());
            Term<BigInt> term = new Term<BigInt>(c0, x0$2.exp());
            return term;
        };
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (terms == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                Term term = (Term)terms.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)Roots$.$anonfun$removeDecimal$3(maxScale, term), (List)Nil$.MODULE$);
                for (List map_rest = (List)terms.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    term = (Term)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)Roots$.$anonfun$removeDecimal$3(maxScale, term), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            object = TraversableLike.map$((TraversableLike)terms, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        return Polynomial$.MODULE$.apply((TraversableOnce)object, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
    }

    public final int upperBound(Polynomial<BigInt> p) {
        int lgLastCoeff = p.maxOrderTermCoeff(package$bigInt$.MODULE$.BigIntAlgebra()).abs().bitLength();
        int n = p.degree();
        DoubleRef maxBound = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        p.foreachNonZero((Function2 & Serializable & scala.Serializable)(k, coeff) -> {
            Roots$.$anonfun$upperBound$1(lgLastCoeff, n, maxBound, BoxesRunTime.unboxToInt((Object)k), coeff);
            return BoxedUnit.UNIT;
        }, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra());
        double d = maxBound.elem;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (RichDouble$.MODULE$.isValidInt$extension(d)) {
            return (int)maxBound.elem;
        }
        throw new ArithmeticException("bound too large");
    }

    public int lowerBound(Polynomial<BigInt> p) {
        return -this.upperBound(p.reciprocal(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra()));
    }

    public static final /* synthetic */ BigInt $anonfun$removeFractions$1(BigInt acc, Rational coeff) {
        BigInt d = coeff.denominator().toBigInt();
        return acc.$times(d.$div(acc.gcd(d)));
    }

    public static final /* synthetic */ BigInt $anonfun$removeFractions$2(BigInt factors$1, Rational n) {
        return n.numerator().$times(SafeLong$.MODULE$.apply(factors$1).$div(n.denominator())).toBigInt();
    }

    public static final /* synthetic */ int $anonfun$removeDecimal$2(Term x$1) {
        return ((BigDecimal)x$1.coeff()).scale();
    }

    public static final /* synthetic */ void $anonfun$upperBound$1(int lgLastCoeff$1, int n$1, DoubleRef maxBound$1, int k, BigInt coeff) {
        if (k != n$1) {
            int i = n$1 - k;
            int bound = (coeff.abs().bitLength() - lgLastCoeff$1 + 1) / i + 2;
            maxBound$1.elem = package$.MODULE$.max(maxBound$1.elem, (double)bound);
        }
    }

    private Roots$() {
        MODULE$ = this;
    }
}

