/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spire.math.Algebraic$;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.Real$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots;
import spire.math.poly.Roots$;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0001\u0005!\u0011aBR5yK\u0012\u0014V-\u00197S_>$8O\u0003\u0002\u0004\t\u0005!\u0001o\u001c7z\u0015\t)a!\u0001\u0003nCRD'\"A\u0004\u0002\u000bM\u0004\u0018N]3\u0014\u0007\u0001Iq\u0002\u0005\u0002\u000b\u001b5\t1BC\u0001\r\u0003\u0015\u00198-\u00197b\u0013\tq1B\u0001\u0004B]f\u0014VM\u001a\t\u0004!E\u0019R\"\u0001\u0002\n\u0005I\u0011!!\u0002*p_R\u001c\bC\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005\u0011\u0011V-\u00197\t\u0011\r\u0001!Q1A\u0005\u0002e\u0019\u0001!F\u0001\u001b!\r!2dE\u0005\u00039\u0011\u0011!\u0002U8ms:|W.[1m\u0011!q\u0002A!A!\u0002\u0013Q\u0012!\u00029pYf\u0004\u0003\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0002#GA\u0011\u0001\u0003\u0001\u0005\u0006\u0007}\u0001\rA\u0007\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003\u0015Q\bo\u001c7z+\u00059\u0003c\u0001\u000b\u001cQA\u0011\u0011&\r\b\u0003U=r!a\u000b\u0018\u000e\u00031R!!\f\r\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u0019\f\u0003\u001d\u0001\u0018mY6bO\u0016L!AM\u001a\u0003\r\tKw-\u00138u\u0015\t\u00014\u0002\u0003\u00046\u0001\u0001\u0006IaJ\u0001\u0007uB|G.\u001f\u0011\t\u000f]\u0002!\u0019!C\u0005q\u0005A\u0011n]8mCR,G-F\u0001:!\rI#\bP\u0005\u0003wM\u0012aAV3di>\u0014\bc\u0001\u000b>\u007f%\u0011a\b\u0002\u0002\t\u0013:$XM\u001d<bYB\u0011A\u0003Q\u0005\u0003\u0003\u0012\u0011\u0001BU1uS>t\u0017\r\u001c\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001d\u0002\u0013%\u001cx\u000e\\1uK\u0012\u0004\u0003\"B#\u0001\t\u00031\u0015!B2pk:$X#A$\u0011\u0005)A\u0015BA%\f\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0004O\u0016$HCA\nN\u0011\u0015q%\n1\u0001H\u0003\u0005I\u0007")
public class FixedRealRoots
implements Roots<Real> {
    private final Polynomial<Real> poly;
    private final Polynomial<BigInt> zpoly;
    private final Vector<Interval<Rational>> isolated;

    @Override
    public Iterator<Real> iterator() {
        return Roots.iterator$(this);
    }

    @Override
    public int size() {
        return Roots.size$(this);
    }

    @Override
    public String toString() {
        return Roots.toString$(this);
    }

    public GenericCompanion<Iterable> companion() {
        return Iterable.companion$((Iterable)this);
    }

    public Iterable<Real> seq() {
        return Iterable.seq$((Iterable)this);
    }

    public Iterable<Real> thisCollection() {
        return IterableLike.thisCollection$((IterableLike)this);
    }

    public Iterable toCollection(Object repr) {
        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
    }

    public <U> void foreach(Function1<Real, U> f) {
        this.iterator().foreach(f);
    }

    public boolean forall(Function1<Real, Object> p) {
        return this.iterator().forall(p);
    }

    public boolean exists(Function1<Real, Object> p) {
        return this.iterator().exists(p);
    }

    public Option<Real> find(Function1<Real, Object> p) {
        return this.iterator().find(p);
    }

    public boolean isEmpty() {
        return IterableLike.isEmpty$((IterableLike)this);
    }

    public <B> B foldRight(B z, Function2<Real, B, B> op) {
        return (B)this.iterator().foldRight(z, op);
    }

    public <B> B reduceRight(Function2<Real, B, B> op) {
        return (B)this.iterator().reduceRight(op);
    }

    public Iterable<Real> toIterable() {
        return IterableLike.toIterable$((IterableLike)this);
    }

    public Iterator<Real> toIterator() {
        return IterableLike.toIterator$((IterableLike)this);
    }

    public Object head() {
        return IterableLike.head$((IterableLike)this);
    }

    public Object slice(int from, int until) {
        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
    }

    public Object take(int n) {
        return IterableLike.take$((IterableLike)this, (int)n);
    }

    public Object drop(int n) {
        return IterableLike.drop$((IterableLike)this, (int)n);
    }

    public Object takeWhile(Function1 p) {
        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
    }

    public Iterator<Iterable<Real>> grouped(int size) {
        return IterableLike.grouped$((IterableLike)this, (int)size);
    }

    public Iterator<Iterable<Real>> sliding(int size) {
        return IterableLike.sliding$((IterableLike)this, (int)size);
    }

    public Iterator<Iterable<Real>> sliding(int size, int step) {
        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
    }

    public Object takeRight(int n) {
        return IterableLike.takeRight$((IterableLike)this, (int)n);
    }

    public Object dropRight(int n) {
        return IterableLike.dropRight$((IterableLike)this, (int)n);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
    }

    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zip$((IterableLike)this, that, bf);
    }

    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
    }

    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<Real>, Tuple2<A1, Object>, That> bf) {
        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
    }

    public <B> boolean sameElements(GenIterable<B> that) {
        return IterableLike.sameElements$((IterableLike)this, that);
    }

    public Stream<Real> toStream() {
        return IterableLike.toStream$((IterableLike)this);
    }

    public boolean canEqual(Object that) {
        return IterableLike.canEqual$((IterableLike)this, (Object)that);
    }

    public IterableView<Real, Iterable<Real>> view() {
        return IterableLike.view$((IterableLike)this);
    }

    public IterableView<Real, Iterable<Real>> view(int from, int until) {
        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
    }

    public Builder<Real, Iterable<Real>> newBuilder() {
        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
    }

    public <B> Builder<B, Iterable<B>> genericBuilder() {
        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Real, Tuple2<A1, A2>> asPair) {
        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
    }

    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Real, Tuple3<A1, A2, A3>> asTriple) {
        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
    }

    public GenTraversable flatten(Function1 asTraversable) {
        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public GenTraversable transpose(Function1 asTraversable) {
        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public Object repr() {
        return TraversableLike.repr$((TraversableLike)this);
    }

    public final boolean isTraversableAgain() {
        return TraversableLike.isTraversableAgain$((TraversableLike)this);
    }

    public Combiner<Real, ParIterable<Real>> parCombiner() {
        return TraversableLike.parCombiner$((TraversableLike)this);
    }

    public boolean hasDefiniteSize() {
        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
    }

    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
    }

    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    public <B, That> That map(Function1<Real, B> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
    }

    public <B, That> That flatMap(Function1<Real, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
    }

    public Object filterImpl(Function1 p, boolean isFlipped) {
        Builder filterImpl$_filterImpl_b = this.newBuilder();
        this.foreach(arg_0 -> TraversableLike.$anonfun$filterImpl$1((Function1)p, (boolean)isFlipped, (Builder)filterImpl$_filterImpl_b, arg_0));
        return filterImpl$_filterImpl_b.result();
    }

    public Object filter(Function1 p) {
        return this.filterImpl(p, false);
    }

    public Object filterNot(Function1 p) {
        return this.filterImpl(p, true);
    }

    public <B, That> That collect(PartialFunction<Real, B> pf, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> partition(Function1<Real, Object> p) {
        Builder partition$_partition_l = this.newBuilder();
        Builder partition$_partition_r = this.newBuilder();
        this.foreach(arg_0 -> TraversableLike.$anonfun$partition$1(p, (Builder)partition$_partition_l, (Builder)partition$_partition_r, arg_0));
        return new Tuple2(partition$_partition_l.result(), partition$_partition_r.result());
    }

    public <K> Map<K, Iterable<Real>> groupBy(Function1<Real, K> f) {
        scala.collection.mutable.Map groupBy$_groupBy_m = Map$.MODULE$.empty();
        this.foreach(arg_0 -> TraversableLike.$anonfun$groupBy$1((TraversableLike)this, f, (scala.collection.mutable.Map)groupBy$_groupBy_m, arg_0));
        Builder groupBy$_groupBy_b = scala.collection.immutable.Map$.MODULE$.newBuilder();
        groupBy$_groupBy_m.withFilter(TraversableLike::$anonfun$groupBy$3$adapted).foreach(arg_0 -> TraversableLike.$anonfun$groupBy$4((Builder)groupBy$_groupBy_b, arg_0));
        return (Map)groupBy$_groupBy_b.result();
    }

    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<Real>, B, That> cbf) {
        return (That)this.scanLeft(z, op, cbf);
    }

    public <B, That> That scanLeft(B z, Function2<B, Real, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
    }

    public <B, That> That scanRight(B z, Function2<Real, B, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
    }

    public Option<Real> headOption() {
        return TraversableLike.headOption$((TraversableLike)this);
    }

    public Object tail() {
        return TraversableLike.tail$((TraversableLike)this);
    }

    public Object last() {
        return TraversableLike.last$((TraversableLike)this);
    }

    public Option<Real> lastOption() {
        return TraversableLike.lastOption$((TraversableLike)this);
    }

    public Object init() {
        return TraversableLike.init$((TraversableLike)this);
    }

    public Object sliceWithKnownDelta(int from, int until, int delta) {
        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
    }

    public Object sliceWithKnownBound(int from, int until) {
        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
    }

    public Object dropWhile(Function1 p) {
        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> span(Function1<Real, Object> p) {
        return TraversableLike.span$((TraversableLike)this, p);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> splitAt(int n) {
        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
    }

    public Iterator<Iterable<Real>> tails() {
        return TraversableLike.tails$((TraversableLike)this);
    }

    public Iterator<Iterable<Real>> inits() {
        return TraversableLike.inits$((TraversableLike)this);
    }

    public Traversable<Real> toTraversable() {
        return TraversableLike.toTraversable$((TraversableLike)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, Real, Col> cbf) {
        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
    }

    public String stringPrefix() {
        return TraversableLike.stringPrefix$((TraversableLike)this);
    }

    public FilterMonadic<Real, Iterable<Real>> withFilter(Function1<Real, Object> p) {
        return new TraversableLike.WithFilter((TraversableLike)this, p);
    }

    public Parallel par() {
        return Parallelizable.par$((Parallelizable)this);
    }

    public List<Real> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<Real, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<Real, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, Real, B> op) {
        return (B)this.foldLeft(z, op);
    }

    public <B> B $colon$bslash(B z, Function2<Real, B, B> op) {
        return (B)this.foldRight(z, op);
    }

    public <B> B foldLeft(B z, Function2<B, Real, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, Real, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, Real, B> op) {
        Object object = this.isEmpty() ? None$.MODULE$ : new Some(this.reduceLeft(op));
        return object;
    }

    public <B> Option<B> reduceRightOption(Function2<Real, B, B> op) {
        Object object = this.isEmpty() ? None$.MODULE$ : new Some(this.reduceRight(op));
        return object;
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)this.reduceLeft(op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return this.reduceLeftOption(op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)this.foldLeft(z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, Real, B> seqop, Function2<B, B, B> combop) {
        return (B)this.foldLeft(z.apply(), seqop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.min");
        }
        return this.reduceLeft((arg_0, arg_1) -> TraversableOnce.$anonfun$min$1((Ordering)cmp, arg_0, arg_1));
    }

    public Object max(Ordering cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.max");
        }
        return this.reduceLeft((arg_0, arg_1) -> TraversableOnce.$anonfun$max$1((Ordering)cmp, arg_0, arg_1));
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<Real> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Seq<Real> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<Real> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<Real> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Real, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    @Override
    public Polynomial<Real> poly() {
        return this.poly;
    }

    private Polynomial<BigInt> zpoly() {
        return this.zpoly;
    }

    private Vector<Interval<Rational>> isolated() {
        return this.isolated;
    }

    @Override
    public int count() {
        return this.isolated().size();
    }

    @Override
    public Real get(int i) {
        Real real;
        if (i < 0 || i >= this.count()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        }
        Interval interval = (Interval)this.isolated().apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            real = Real$.MODULE$.apply((Rational)((Object)point.value()));
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            real = Real$.MODULE$.apply(Algebraic$.MODULE$.unsafeRoot(this.zpoly(), i, (Rational)((Object)bounded.lower()), (Rational)((Object)bounded.upper())).toBigDecimal(new MathContext(Real$.MODULE$.digits(), RoundingMode.HALF_EVEN)));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return real;
    }

    public FixedRealRoots(Polynomial<Real> poly) {
        this.poly = poly;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Parallelizable.$init$((Parallelizable)this);
        TraversableLike.$init$((TraversableLike)this);
        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
        GenTraversable.$init$((GenTraversable)this);
        Traversable.$init$((Traversable)this);
        GenIterable.$init$((GenIterable)this);
        IterableLike.$init$((IterableLike)this);
        Iterable.$init$((Iterable)this);
        Roots.$init$(this);
        this.zpoly = Roots$.MODULE$.removeFractions(poly.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toRational(), Rational$.MODULE$.RationalAlgebra(), Rational$.MODULE$.RationalAlgebra(), ClassTag$.MODULE$.apply(Rational.class), Real$.MODULE$.algebra(), Real$.MODULE$.algebra()));
        this.isolated = Roots$.MODULE$.isolateRoots(this.zpoly(), RootIsolator$.MODULE$.BigIntRootIsolator());
    }
}

