/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import spire.algebra.MappedOrder;
import spire.algebra.Order;
import spire.algebra.ReversedOrder;
import spire.math.Algebraic;
import spire.math.AlgebraicAlgebra;
import spire.math.AlgebraicInstances;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.NumberTag;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.package$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots$;

public final class Algebraic$
implements AlgebraicInstances,
scala.Serializable {
    public static Algebraic$ MODULE$;
    private final Algebraic Zero;
    private final Algebraic One;
    private final double bits2dec;
    private final Order<java.math.BigDecimal> JBigDecimalOrder;
    private final BigInteger spire$math$Algebraic$$MaxIntValue;
    private final BigInteger spire$math$Algebraic$$MinIntValue;
    private final BigInteger spire$math$Algebraic$$MaxLongValue;
    private final BigInteger spire$math$Algebraic$$MinLongValue;
    private final AlgebraicAlgebra AlgebraicAlgebra;
    private final NumberTag.LargeTag<Algebraic> AlgebraicTag;

    static {
        new Algebraic$();
    }

    @Override
    public final AlgebraicAlgebra AlgebraicAlgebra() {
        return this.AlgebraicAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Algebraic> AlgebraicTag() {
        return this.AlgebraicTag;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicAlgebra_$eq(AlgebraicAlgebra x$1) {
        this.AlgebraicAlgebra = x$1;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicTag_$eq(NumberTag.LargeTag<Algebraic> x$1) {
        this.AlgebraicTag = x$1;
    }

    public Algebraic Zero() {
        return this.Zero;
    }

    public Algebraic One() {
        return this.One;
    }

    public Algebraic apply(int n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(long n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(float n) {
        return this.apply((double)n);
    }

    public Algebraic apply(double n) {
        if (Double.isInfinite(n)) {
            throw new IllegalArgumentException("cannot construct inifinite Algebraic");
        }
        if (Double.isNaN(n)) {
            throw new IllegalArgumentException("cannot construct Algebraic from NaN");
        }
        return new Algebraic(new Algebraic.Expr.ConstantDouble(n));
    }

    public Algebraic apply(BigInt n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(scala.package$.MODULE$.BigDecimal().apply(n)));
    }

    public Algebraic apply(BigDecimal n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(n));
    }

    public Algebraic apply(Rational n) {
        return new Algebraic(new Algebraic.Expr.ConstantRational(n));
    }

    public Algebraic root(Polynomial<Rational> poly, int i) {
        Algebraic algebraic;
        if (i < 0) {
            throw new ArithmeticException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid real root index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
        }
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        if (i >= intervals.size()) {
            throw new ArithmeticException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot extract root ", ", there are only ", " roots"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)intervals.size())})));
        }
        Interval interval = (Interval)intervals.apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)((Object)point.value())));
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, (Rational)((Object)bounded.lower()), (Rational)((Object)bounded.upper())));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return algebraic;
    }

    public Vector<Algebraic> roots(Polynomial<Rational> poly) {
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        return (Vector)((TraversableLike)Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator()).zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Algebraic algebraic;
            if (x0$1 != null && x0$1._1() instanceof Point) {
                Point point = (Point)x0$1._1();
                algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)((Object)((Object)point.value()))));
            } else if (x0$1 != null && x0$1._1() instanceof Bounded) {
                Bounded bounded = (Bounded)x0$1._1();
                algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, x0$1._2$mcI$sp(), (Rational)((Object)((Object)bounded.lower())), (Rational)((Object)((Object)bounded.upper()))));
            } else {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid isolated root interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x0$1})));
            }
            return algebraic;
        }, Vector$.MODULE$.canBuildFrom());
    }

    public Algebraic unsafeRoot(Polynomial<BigInt> poly, int i, Rational lb, Rational ub) {
        return new Algebraic(new Algebraic.Expr.ConstantRoot(poly, i, lb, ub));
    }

    public Algebraic apply(String n) {
        return this.apply(scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(n)));
    }

    public final java.math.BigDecimal nrootApprox(java.math.BigDecimal x, int n) {
        int k = package$.MODULE$.min(n, 306);
        int width = (int)(package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * package$.MODULE$.log(2.0) / package$.MODULE$.log(10.0)) - 1.0);
        int safeWidth = width + (x.scale() - width) % k;
        double approx = new java.math.BigDecimal(x.unscaledValue().abs(), safeWidth).doubleValue();
        return new java.math.BigDecimal((double)x.signum() * package$.MODULE$.pow(approx, 1.0 / (double)k)).scaleByPowerOfTen(-(x.scale() - safeWidth) / k).round(MathContext.DECIMAL64);
    }

    /*
     * WARNING - void declaration
     */
    private final java.math.BigDecimal nroot(java.math.BigDecimal signedValue, int k, Function1<java.math.BigDecimal, Object> getEps) {
        void var6_8;
        if (signedValue.compareTo(java.math.BigDecimal.ZERO) == 0) {
            return java.math.BigDecimal.ZERO;
        }
        java.math.BigDecimal value = signedValue.abs();
        java.math.BigDecimal n = new java.math.BigDecimal(k);
        java.math.BigDecimal bigDecimal = java.math.BigDecimal.ZERO;
        int n2 = Integer.MIN_VALUE;
        java.math.BigDecimal loop$2_prev = this.nrootApprox(value, k);
        while (true) {
            void loop$2_prevEps;
            int loop$2_prevDigits;
            int loop$2_digits;
            void loop$2_eps = (loop$2_digits = BoxesRunTime.unboxToInt((Object)getEps.apply((Object)loop$2_prev))) == loop$2_prevDigits ? loop$2_prevEps : java.math.BigDecimal.ONE.movePointLeft(loop$2_digits);
            java.math.BigDecimal loop$2_prevExp = loop$2_prev.pow(k - 1);
            java.math.BigDecimal loop$2_delta = value.divide(loop$2_prevExp, loop$2_digits, RoundingMode.HALF_UP).subtract(loop$2_prev).divide(n, loop$2_digits, RoundingMode.HALF_UP);
            if (loop$2_delta.abs().compareTo((java.math.BigDecimal)loop$2_eps) <= 0) break;
            loop$2_prevEps = loop$2_eps;
            loop$2_prevDigits = loop$2_digits;
            loop$2_prev = loop$2_prev.add(loop$2_delta);
        }
        if (signedValue.signum() < 0) {
            return var6_8.negate();
        }
        return var6_8;
    }

    private double bits2dec() {
        return this.bits2dec;
    }

    /*
     * WARNING - void declaration
     */
    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, MathContext mc) {
        java.math.BigDecimal bigDecimal;
        if (value.compareTo(java.math.BigDecimal.ZERO) == 0) {
            bigDecimal = java.math.BigDecimal.ZERO;
        } else {
            void var6_9;
            java.math.BigDecimal nroot_value = value.abs();
            java.math.BigDecimal nroot_n = new java.math.BigDecimal(n);
            java.math.BigDecimal bigDecimal2 = java.math.BigDecimal.ZERO;
            int n2 = Integer.MIN_VALUE;
            java.math.BigDecimal nroot_loop$2_prev = this.nrootApprox(nroot_value, n);
            while (true) {
                void nroot_loop$2_prevEps;
                int nroot_loop$2_prevDigits;
                java.math.BigDecimal bigDecimal3;
                int n3;
                void nroot_loop$2_eps = (n3 = Algebraic$.$anonfun$nroot$1(this, mc, bigDecimal3 = nroot_loop$2_prev)) == nroot_loop$2_prevDigits ? nroot_loop$2_prevEps : java.math.BigDecimal.ONE.movePointLeft(n3);
                java.math.BigDecimal nroot_loop$2_prevExp = nroot_loop$2_prev.pow(n - 1);
                java.math.BigDecimal nroot_loop$2_delta = nroot_value.divide(nroot_loop$2_prevExp, n3, RoundingMode.HALF_UP).subtract(nroot_loop$2_prev).divide(nroot_n, n3, RoundingMode.HALF_UP);
                if (nroot_loop$2_delta.abs().compareTo((java.math.BigDecimal)nroot_loop$2_eps) <= 0) break;
                nroot_loop$2_prevEps = nroot_loop$2_eps;
                nroot_loop$2_prevDigits = n3;
                nroot_loop$2_prev = nroot_loop$2_prev.add(nroot_loop$2_delta);
            }
            bigDecimal = value.signum() < 0 ? var6_9.negate() : var6_9;
        }
        return bigDecimal.round(mc);
    }

    /*
     * WARNING - void declaration
     */
    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, int scale, RoundingMode roundingMode) {
        java.math.BigDecimal bigDecimal;
        if (value.compareTo(java.math.BigDecimal.ZERO) == 0) {
            bigDecimal = java.math.BigDecimal.ZERO;
        } else {
            void var7_10;
            java.math.BigDecimal nroot_value = value.abs();
            java.math.BigDecimal nroot_n = new java.math.BigDecimal(n);
            java.math.BigDecimal bigDecimal2 = java.math.BigDecimal.ZERO;
            int n2 = Integer.MIN_VALUE;
            java.math.BigDecimal nroot_loop$2_prev = this.nrootApprox(nroot_value, n);
            while (true) {
                void nroot_loop$2_prevEps;
                int nroot_loop$2_prevDigits;
                java.math.BigDecimal bigDecimal3;
                int n3;
                void nroot_loop$2_eps = (n3 = Algebraic$.$anonfun$nroot$2(scale, bigDecimal3 = nroot_loop$2_prev)) == nroot_loop$2_prevDigits ? nroot_loop$2_prevEps : java.math.BigDecimal.ONE.movePointLeft(n3);
                java.math.BigDecimal nroot_loop$2_prevExp = nroot_loop$2_prev.pow(n - 1);
                java.math.BigDecimal nroot_loop$2_delta = nroot_value.divide(nroot_loop$2_prevExp, n3, RoundingMode.HALF_UP).subtract(nroot_loop$2_prev).divide(nroot_n, n3, RoundingMode.HALF_UP);
                if (nroot_loop$2_delta.abs().compareTo((java.math.BigDecimal)nroot_loop$2_eps) <= 0) break;
                nroot_loop$2_prevEps = nroot_loop$2_eps;
                nroot_loop$2_prevDigits = n3;
                nroot_loop$2_prev = nroot_loop$2_prev.add(nroot_loop$2_delta);
            }
            bigDecimal = value.signum() < 0 ? var7_10.negate() : var7_10;
        }
        return bigDecimal.setScale(scale, roundingMode);
    }

    private Order<java.math.BigDecimal> JBigDecimalOrder() {
        return this.JBigDecimalOrder;
    }

    public java.math.BigDecimal spire$math$Algebraic$$roundExact(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        if (approx.signum() == 0) {
            java.math.BigDecimal bigDecimal;
            boolean bl = ((Object)((Object)RoundingMode.UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode);
            if (bl && exact.signum() > 0) {
                bigDecimal = new java.math.BigDecimal(BigInteger.ONE, scale);
            } else {
                boolean bl2 = ((Object)((Object)RoundingMode.UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode);
                bigDecimal = bl2 && exact.signum() < 0 ? new java.math.BigDecimal(BigInteger.ONE.negate(), scale) : approx.setScale(scale, RoundingMode.DOWN);
            }
            return bigDecimal;
        }
        if (approx.signum() > 0) {
            return this.roundPositive(exact, approx, scale, mode);
        }
        RoundingMode roundingMode = ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode) ? RoundingMode.FLOOR : (((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode) ? RoundingMode.CEILING : mode);
        return this.roundPositive(exact.unary_$minus(), approx.abs(), scale, roundingMode).negate();
    }

    /*
     * WARNING - void declaration
     */
    private java.math.BigDecimal roundPositive(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        void var16_10;
        void var15_9;
        int cutoff;
        while (true) {
            if ((cutoff = approx.scale() - scale) == 0) {
                return approx;
            }
            if (cutoff < 0) {
                return approx.setScale(scale, RoundingMode.DOWN);
            }
            if (cutoff <= 18) break;
            java.math.BigDecimal bigDecimal2 = approx.setScale(scale + 18, RoundingMode.DOWN);
            approx = bigDecimal2;
        }
        long unscale = package$.MODULE$.pow(10L, cutoff);
        BigInteger[] bigIntegerArray = approx.unscaledValue().divideAndRemainder(BigInteger.valueOf(unscale));
        Option option = Array$.MODULE$.unapplySeq((Object)bigIntegerArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)bigIntegerArray);
        }
        BigInteger truncatedUnscaledValue = (BigInteger)((SeqLike)option.get()).apply(0);
        BigInteger bigRemainder = (BigInteger)((SeqLike)option.get()).apply(1);
        void truncatedUnscaledValue2 = var15_9;
        void bigRemainder2 = var16_10;
        java.math.BigDecimal truncated = new java.math.BigDecimal((BigInteger)truncatedUnscaledValue2, scale);
        long remainder = bigRemainder2.longValue();
        if (((Object)((Object)RoundingMode.UNNECESSARY)).equals((Object)mode)) {
            bigDecimal = truncated;
        } else {
            boolean bl = ((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)mode) ? true : (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)mode));
            if (bl) {
                java.math.BigDecimal bigDecimal3;
                long dangerZoneStart = unscale / 2L - 1L;
                long dangerZoneStop = dangerZoneStart + 2L;
                if (remainder >= dangerZoneStart && remainder <= dangerZoneStop) {
                    boolean bl2;
                    BigDecimal splitter = scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(truncatedUnscaledValue2.multiply(BigInteger.TEN).add(BigInteger.valueOf(5L)), scale + 1));
                    int cmp = exact.compare(this.apply(splitter));
                    if (((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)mode)) {
                        bl2 = cmp > 0;
                    } else if (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)mode)) {
                        bl2 = cmp >= 0;
                    } else if (((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)mode)) {
                        bl2 = cmp > 0 || cmp == 0 && truncatedUnscaledValue2.testBit(0);
                    } else {
                        throw new MatchError((Object)mode);
                    }
                    bigDecimal3 = bl2 ? truncated.add(Algebraic$.epsilon$1(scale)) : truncated;
                } else {
                    bigDecimal3 = remainder < dangerZoneStart ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                }
                bigDecimal = bigDecimal3;
            } else {
                boolean bl3 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.UP)).equals((Object)mode);
                if (bl3) {
                    bigDecimal = remainder <= 1L && exact.$less$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                } else {
                    boolean bl4 = ((Object)((Object)RoundingMode.FLOOR)).equals((Object)mode) ? true : ((Object)((Object)RoundingMode.DOWN)).equals((Object)mode);
                    if (bl4) {
                        java.math.BigDecimal bigDecimal4;
                        if (remainder <= 0L) {
                            bigDecimal4 = exact.$less(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated.subtract(Algebraic$.epsilon$1(scale)) : truncated;
                        } else if (remainder >= unscale - 1L) {
                            java.math.BigDecimal roundedUp = truncated.add(Algebraic$.epsilon$1(scale));
                            bigDecimal4 = exact.$greater$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(roundedUp))) ? roundedUp : truncated;
                        } else {
                            bigDecimal4 = truncated;
                        }
                        bigDecimal = bigDecimal4;
                    } else {
                        throw new MatchError((Object)mode);
                    }
                }
            }
        }
        return bigDecimal;
    }

    public BigInteger spire$math$Algebraic$$MaxIntValue() {
        return this.spire$math$Algebraic$$MaxIntValue;
    }

    public BigInteger spire$math$Algebraic$$MinIntValue() {
        return this.spire$math$Algebraic$$MinIntValue;
    }

    public BigInteger spire$math$Algebraic$$MaxLongValue() {
        return this.spire$math$Algebraic$$MaxLongValue;
    }

    public BigInteger spire$math$Algebraic$$MinLongValue() {
        return this.spire$math$Algebraic$$MinLongValue;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final java.math.BigDecimal loop$2(java.math.BigDecimal prev, int prevDigits, java.math.BigDecimal prevEps, int k$1, Function1 getEps$1, java.math.BigDecimal value$1, java.math.BigDecimal n$1) {
        while (true) {
            int digits;
            java.math.BigDecimal eps = (digits = BoxesRunTime.unboxToInt((Object)getEps$1.apply((Object)prev))) == prevDigits ? prevEps : java.math.BigDecimal.ONE.movePointLeft(digits);
            java.math.BigDecimal prevExp = prev.pow(k$1 - 1);
            java.math.BigDecimal delta = value$1.divide(prevExp, digits, RoundingMode.HALF_UP).subtract(prev).divide(n$1, digits, RoundingMode.HALF_UP);
            if (delta.abs().compareTo(eps) <= 0) {
                return prev;
            }
            prevEps = eps;
            prevDigits = digits;
            prev = prev.add(delta);
        }
    }

    public static final /* synthetic */ int $anonfun$nroot$1(Algebraic$ $this, MathContext mc$1, java.math.BigDecimal x) {
        return x.scale() - (int)package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * $this.bits2dec()) + mc$1.getPrecision() + 1;
    }

    public static final /* synthetic */ int $anonfun$nroot$2(int scale$1, java.math.BigDecimal x$4) {
        return scale$1 + 1;
    }

    private static final java.math.BigDecimal epsilon$1(int scale$2) {
        return new java.math.BigDecimal(BigInteger.ONE, scale$2);
    }

    private Algebraic$() {
        MODULE$ = this;
        AlgebraicInstances.$init$(this);
        this.Zero = new Algebraic(new Algebraic.Expr.ConstantLong(0L));
        this.One = new Algebraic(new Algebraic.Expr.ConstantLong(1L));
        this.bits2dec = package$.MODULE$.log(2.0, 10);
        this.JBigDecimalOrder = new Order<java.math.BigDecimal>(){

            public double partialCompare(Object x, Object y) {
                return this.compare(x, y);
            }

            public double partialCompare$mcZ$sp(boolean x, boolean y) {
                return this.partialCompare(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public double partialCompare$mcB$sp(byte x, byte y) {
                return this.partialCompare(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public double partialCompare$mcC$sp(char x, char y) {
                return this.partialCompare(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public double partialCompare$mcD$sp(double x, double y) {
                return this.partialCompare(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public double partialCompare$mcF$sp(float x, float y) {
                return this.partialCompare(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public double partialCompare$mcI$sp(int x, int y) {
                return this.partialCompare(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public double partialCompare$mcJ$sp(long x, long y) {
                return this.partialCompare(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public double partialCompare$mcS$sp(short x, short y) {
                return this.partialCompare(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public double partialCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.partialCompare(x, y);
            }

            public boolean eqv(Object x, Object y) {
                return this.compare(x, y) == 0;
            }

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return this.eqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return this.eqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return this.eqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return this.eqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return this.eqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return this.eqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return this.eqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return this.eqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.eqv(x, y);
            }

            public boolean gt(Object x, Object y) {
                return this.compare(x, y) > 0;
            }

            public boolean gt$mcZ$sp(boolean x, boolean y) {
                return this.gt(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean gt$mcB$sp(byte x, byte y) {
                return this.gt(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean gt$mcC$sp(char x, char y) {
                return this.gt(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean gt$mcD$sp(double x, double y) {
                return this.gt(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean gt$mcF$sp(float x, float y) {
                return this.gt(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean gt$mcI$sp(int x, int y) {
                return this.gt(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean gt$mcJ$sp(long x, long y) {
                return this.gt(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean gt$mcS$sp(short x, short y) {
                return this.gt(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean gt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.gt(x, y);
            }

            public boolean lt(Object x, Object y) {
                return this.compare(x, y) < 0;
            }

            public boolean lt$mcZ$sp(boolean x, boolean y) {
                return this.lt(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean lt$mcB$sp(byte x, byte y) {
                return this.lt(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean lt$mcC$sp(char x, char y) {
                return this.lt(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean lt$mcD$sp(double x, double y) {
                return this.lt(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean lt$mcF$sp(float x, float y) {
                return this.lt(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean lt$mcI$sp(int x, int y) {
                return this.lt(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean lt$mcJ$sp(long x, long y) {
                return this.lt(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean lt$mcS$sp(short x, short y) {
                return this.lt(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean lt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.lt(x, y);
            }

            public boolean gteqv(Object x, Object y) {
                return this.compare(x, y) >= 0;
            }

            public boolean gteqv$mcZ$sp(boolean x, boolean y) {
                return this.gteqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean gteqv$mcB$sp(byte x, byte y) {
                return this.gteqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean gteqv$mcC$sp(char x, char y) {
                return this.gteqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean gteqv$mcD$sp(double x, double y) {
                return this.gteqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean gteqv$mcF$sp(float x, float y) {
                return this.gteqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean gteqv$mcI$sp(int x, int y) {
                return this.gteqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean gteqv$mcJ$sp(long x, long y) {
                return this.gteqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean gteqv$mcS$sp(short x, short y) {
                return this.gteqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean gteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.gteqv(x, y);
            }

            public boolean lteqv(Object x, Object y) {
                return this.compare(x, y) <= 0;
            }

            public boolean lteqv$mcZ$sp(boolean x, boolean y) {
                return this.lteqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean lteqv$mcB$sp(byte x, byte y) {
                return this.lteqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean lteqv$mcC$sp(char x, char y) {
                return this.lteqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean lteqv$mcD$sp(double x, double y) {
                return this.lteqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean lteqv$mcF$sp(float x, float y) {
                return this.lteqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean lteqv$mcI$sp(int x, int y) {
                return this.lteqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean lteqv$mcJ$sp(long x, long y) {
                return this.lteqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean lteqv$mcS$sp(short x, short y) {
                return this.lteqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean lteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.lteqv(x, y);
            }

            public Object min(Object x, Object y) {
                if (this.lt(x, y)) {
                    return x;
                }
                return y;
            }

            public boolean min$mcZ$sp(boolean x, boolean y) {
                return BoxesRunTime.unboxToBoolean((Object)this.min(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y)));
            }

            public byte min$mcB$sp(byte x, byte y) {
                return BoxesRunTime.unboxToByte((Object)this.min(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y)));
            }

            public char min$mcC$sp(char x, char y) {
                return BoxesRunTime.unboxToChar((Object)this.min(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y)));
            }

            public double min$mcD$sp(double x, double y) {
                return BoxesRunTime.unboxToDouble((Object)this.min(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)));
            }

            public float min$mcF$sp(float x, float y) {
                return BoxesRunTime.unboxToFloat((Object)this.min(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y)));
            }

            public int min$mcI$sp(int x, int y) {
                return BoxesRunTime.unboxToInt((Object)this.min(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y)));
            }

            public long min$mcJ$sp(long x, long y) {
                return BoxesRunTime.unboxToLong((Object)this.min(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y)));
            }

            public short min$mcS$sp(short x, short y) {
                return BoxesRunTime.unboxToShort((Object)this.min(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y)));
            }

            public void min$mcV$sp(BoxedUnit x, BoxedUnit y) {
                this.min(x, y);
            }

            public Object max(Object x, Object y) {
                if (this.gt(x, y)) {
                    return x;
                }
                return y;
            }

            public boolean max$mcZ$sp(boolean x, boolean y) {
                return BoxesRunTime.unboxToBoolean((Object)this.max(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y)));
            }

            public byte max$mcB$sp(byte x, byte y) {
                return BoxesRunTime.unboxToByte((Object)this.max(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y)));
            }

            public char max$mcC$sp(char x, char y) {
                return BoxesRunTime.unboxToChar((Object)this.max(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y)));
            }

            public double max$mcD$sp(double x, double y) {
                return BoxesRunTime.unboxToDouble((Object)this.max(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)));
            }

            public float max$mcF$sp(float x, float y) {
                return BoxesRunTime.unboxToFloat((Object)this.max(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y)));
            }

            public int max$mcI$sp(int x, int y) {
                return BoxesRunTime.unboxToInt((Object)this.max(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y)));
            }

            public long max$mcJ$sp(long x, long y) {
                return BoxesRunTime.unboxToLong((Object)this.max(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y)));
            }

            public short max$mcS$sp(short x, short y) {
                return BoxesRunTime.unboxToShort((Object)this.max(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y)));
            }

            public void max$mcV$sp(BoxedUnit x, BoxedUnit y) {
                this.max(x, y);
            }

            public int compare$mcZ$sp(boolean x, boolean y) {
                return this.compare(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public int compare$mcB$sp(byte x, byte y) {
                return this.compare(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public int compare$mcC$sp(char x, char y) {
                return this.compare(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public int compare$mcD$sp(double x, double y) {
                return this.compare(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public int compare$mcF$sp(float x, float y) {
                return this.compare(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public int compare$mcI$sp(int x, int y) {
                return this.compare(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public int compare$mcJ$sp(long x, long y) {
                return this.compare(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public int compare$mcS$sp(short x, short y) {
                return this.compare(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public int compare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.compare(x, y);
            }

            public <B> Order<B> on(Function1<B, java.math.BigDecimal> f) {
                return new MappedOrder<B, java.math.BigDecimal>(this, f);
            }

            public <B> Order<B> on$mcZ$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcB$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcC$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcD$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcF$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcI$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcJ$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcS$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Order<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return this.on(f);
            }

            public Order<Object> on$mZc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mZc$sp(f);
            }

            public Order<Object> on$mBc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mBc$sp(f);
            }

            public Order<Object> on$mCc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mCc$sp(f);
            }

            public Order<Object> on$mDc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mDc$sp(f);
            }

            public Order<Object> on$mFc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mFc$sp(f);
            }

            public Order<Object> on$mIc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mIc$sp(f);
            }

            public Order<Object> on$mJc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mJc$sp(f);
            }

            public Order<Object> on$mSc$sp(Function1<Object, java.math.BigDecimal> f) {
                return new MappedOrder<Object, java.math.BigDecimal>(this, f);
            }

            public Order<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScB$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScC$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScD$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScF$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScI$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScS$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Order<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mSc$sp(f);
            }

            public Order<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, java.math.BigDecimal> f) {
                return new MappedOrder<BoxedUnit, java.math.BigDecimal>(this, f);
            }

            public Order<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Order<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return this.on$mVc$sp(f);
            }

            public Order<java.math.BigDecimal> reverse() {
                return new ReversedOrder<java.math.BigDecimal>(this);
            }

            public Order<Object> reverse$mcZ$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcB$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcC$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcD$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcF$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcI$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcJ$sp() {
                return this.reverse();
            }

            public Order<Object> reverse$mcS$sp() {
                return this.reverse();
            }

            public Order<BoxedUnit> reverse$mcV$sp() {
                return this.reverse();
            }

            public Option tryCompare(Object x, Object y) {
                double tryCompare$_tryCompare_c = this.partialCompare(x, y);
                if (Predef$.MODULE$.double2Double(tryCompare$_tryCompare_c).isNaN()) {
                    return None$.MODULE$;
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new Some((Object)BoxesRunTime.boxToInteger((int)RichDouble$.MODULE$.signum$extension(tryCompare$_tryCompare_c)));
            }

            public Option<Object> tryCompare$mcZ$sp(boolean x, boolean y) {
                return this.tryCompare(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public Option<Object> tryCompare$mcB$sp(byte x, byte y) {
                return this.tryCompare(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public Option<Object> tryCompare$mcC$sp(char x, char y) {
                return this.tryCompare(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public Option<Object> tryCompare$mcD$sp(double x, double y) {
                return this.tryCompare(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public Option<Object> tryCompare$mcF$sp(float x, float y) {
                return this.tryCompare(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public Option<Object> tryCompare$mcI$sp(int x, int y) {
                return this.tryCompare(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public Option<Object> tryCompare$mcJ$sp(long x, long y) {
                return this.tryCompare(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public Option<Object> tryCompare$mcS$sp(short x, short y) {
                return this.tryCompare(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public Option<Object> tryCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.tryCompare(x, y);
            }

            public Option pmin(Object x, Object y) {
                double pmin$_pmin_c = this.partialCompare(x, y);
                if (pmin$_pmin_c <= 0.0) {
                    return new Some(x);
                }
                if (pmin$_pmin_c > 0.0) {
                    return new Some(y);
                }
                return None$.MODULE$;
            }

            public Option<Object> pmin$mcZ$sp(boolean x, boolean y) {
                return this.pmin(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public Option<Object> pmin$mcB$sp(byte x, byte y) {
                return this.pmin(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public Option<Object> pmin$mcC$sp(char x, char y) {
                return this.pmin(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public Option<Object> pmin$mcD$sp(double x, double y) {
                return this.pmin(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public Option<Object> pmin$mcF$sp(float x, float y) {
                return this.pmin(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public Option<Object> pmin$mcI$sp(int x, int y) {
                return this.pmin(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public Option<Object> pmin$mcJ$sp(long x, long y) {
                return this.pmin(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public Option<Object> pmin$mcS$sp(short x, short y) {
                return this.pmin(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public Option<BoxedUnit> pmin$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.pmin(x, y);
            }

            public Option pmax(Object x, Object y) {
                double pmax$_pmax_c = this.partialCompare(x, y);
                if (pmax$_pmax_c >= 0.0) {
                    return new Some(x);
                }
                if (pmax$_pmax_c < 0.0) {
                    return new Some(y);
                }
                return None$.MODULE$;
            }

            public Option<Object> pmax$mcZ$sp(boolean x, boolean y) {
                return this.pmax(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public Option<Object> pmax$mcB$sp(byte x, byte y) {
                return this.pmax(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public Option<Object> pmax$mcC$sp(char x, char y) {
                return this.pmax(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public Option<Object> pmax$mcD$sp(double x, double y) {
                return this.pmax(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public Option<Object> pmax$mcF$sp(float x, float y) {
                return this.pmax(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public Option<Object> pmax$mcI$sp(int x, int y) {
                return this.pmax(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public Option<Object> pmax$mcJ$sp(long x, long y) {
                return this.pmax(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public Option<Object> pmax$mcS$sp(short x, short y) {
                return this.pmax(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public Option<BoxedUnit> pmax$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.pmax(x, y);
            }

            public boolean neqv(Object x, Object y) {
                return !this.eqv(x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return this.neqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return this.neqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return this.neqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return this.neqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return this.neqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return this.neqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return this.neqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return this.neqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.neqv(x, y);
            }

            public int compare(java.math.BigDecimal x, java.math.BigDecimal y) {
                return x.compareTo(y);
            }
        };
        this.spire$math$Algebraic$$MaxIntValue = BigInteger.valueOf(Integer.MAX_VALUE);
        this.spire$math$Algebraic$$MinIntValue = BigInteger.valueOf(Integer.MIN_VALUE);
        this.spire$math$Algebraic$$MaxLongValue = BigInteger.valueOf(Long.MAX_VALUE);
        this.spire$math$Algebraic$$MinLongValue = BigInteger.valueOf(Long.MIN_VALUE);
    }

    public static final /* synthetic */ Object $anonfun$nroot$1$adapted(Algebraic$ $this, MathContext mc$1, java.math.BigDecimal x) {
        return BoxesRunTime.boxToInteger((int)Algebraic$.$anonfun$nroot$1($this, mc$1, x));
    }

    public static final /* synthetic */ Object $anonfun$nroot$2$adapted(int scale$1, java.math.BigDecimal x$4) {
        return BoxesRunTime.boxToInteger((int)Algebraic$.$anonfun$nroot$2(scale$1, x$4));
    }
}

