/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveFramegrabsAction
extends ActionAdapter {
    private static final long serialVersionUID = -2264478482293981201L;
    public static final String ACTION_NAME = "Download Images";
    private static final Logger log = LoggerFactory.getLogger(SaveFramegrabsAction.class);
    private ProgressMonitor progressMonitor;
    private File saveLocation;
    private URL[] urls;

    public SaveFramegrabsAction() {
        super(ACTION_NAME);
    }

    public static void copy(URL src, File dst) throws IOException {
        if (src != null && dst != null) {
            boolean success = true;
            File parent = dst.getParentFile();
            if (!parent.exists()) {
                success = parent.mkdirs();
            }
            if (success) {
                int len;
                InputStream in = src.openStream();
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    public void doAction() {
        if (this.urls != null && this.saveLocation != null) {
            for (int i = 0; i < this.urls.length; ++i) {
                File file;
                URL url = this.urls[i];
                if (this.progressMonitor != null) {
                    if (this.progressMonitor.isCanceled()) break;
                    SwingUtilities.invokeLater(new UpdateProgressMonitor(i, url.toExternalForm()));
                }
                if (!SaveFramegrabsAction.doesImageExist(url) || (file = this.urlToLocalPath(url)).exists()) continue;
                try {
                    SaveFramegrabsAction.copy(url, file);
                    continue;
                }
                catch (IOException e) {
                    log.error("Unable to copy " + url + " to " + file.getAbsolutePath(), (Throwable)e);
                }
            }
            if (this.progressMonitor != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveFramegrabsAction.this.progressMonitor.close();
                    }
                });
            }
        }
    }

    public static boolean doesImageExist(URL url) {
        boolean exists = false;
        try {
            InputStream in = url.openStream();
            in.read();
            in.close();
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setSaveLocation(File saveLocation) {
        this.saveLocation = saveLocation;
    }

    public void setUrls(URL[] urls) {
        this.urls = urls;
    }

    private File urlToLocalPath(URL url) {
        String[] parts = url.toExternalForm().replace("%20", " ").split("/");
        int idx = 0;
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (!s.equalsIgnoreCase("framegrabs")) continue;
            idx = i + 1;
            break;
        }
        File f = this.saveLocation;
        for (int i = idx; i < parts.length; ++i) {
            String s = parts[i];
            if (s.equalsIgnoreCase("http:") || s.equals("")) continue;
            f = new File(f, parts[i]);
        }
        return f;
    }

    private class UpdateProgressMonitor
    implements Runnable {
        private final int i;
        private final String note;

        public UpdateProgressMonitor(int i, String note) {
            this.i = i;
            this.note = note;
        }

        @Override
        public void run() {
            SaveFramegrabsAction.this.progressMonitor.setNote(this.note);
            SaveFramegrabsAction.this.progressMonitor.setProgress(this.i);
        }
    }
}

