/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.mbari.swing.FlashDecorator;
import org.mbari.swing.JImageFrame;

public class SwingUtils {
    public static void centerFrame(JFrame frame) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int w = Math.max(bounds.width / 2, Math.min(frame.getWidth(), bounds.width));
        int h = Math.max(bounds.height / 2, Math.min(frame.getHeight(), bounds.height));
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        frame.setBounds(x, y, w, h);
        if (w == bounds.width && h == bounds.height) {
            frame.setExtendedState(6);
        }
        frame.validate();
    }

    public static void flashJComponent(JComponent component, int numFlashes) {
        int delay = 300;
        int duration = 300 * numFlashes * 2;
        FlashDecorator.flash(component, 300, duration);
    }

    public static String getKeyString(KeyStroke key) {
        StringBuffer s = new StringBuffer(50);
        int m = key.getModifiers();
        if ((m & 0x41) != 0) {
            s.append("shift+");
        }
        if ((m & 0x82) != 0) {
            s.append("ctrl+");
        }
        if ((m & 0x104) != 0) {
            s.append("meta+");
        }
        if ((m & 0x208) != 0) {
            s.append("alt+");
        }
        s.append(SwingUtils.getKeyText(key.getKeyCode()));
        return s.toString();
    }

    public static String getKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        switch (keyCode) {
            case 44: {
                return "COMMA";
            }
            case 46: {
                return "PERIOD";
            }
            case 47: {
                return "SLASH";
            }
            case 59: {
                return "SEMICOLON";
            }
            case 61: {
                return "EQUALS";
            }
            case 91: {
                return "OPEN_BRACKET";
            }
            case 92: {
                return "BACK_SLASH";
            }
            case 93: {
                return "CLOSE_BRACKET";
            }
            case 10: {
                return "ENTER";
            }
            case 8: {
                return "BACK_SPACE";
            }
            case 9: {
                return "TAB";
            }
            case 3: {
                return "CANCEL";
            }
            case 12: {
                return "CLEAR";
            }
            case 16: {
                return "SHIFT";
            }
            case 17: {
                return "CONTROL";
            }
            case 18: {
                return "ALT";
            }
            case 19: {
                return "PAUSE";
            }
            case 20: {
                return "CAPS_LOCK";
            }
            case 27: {
                return "ESCAPE";
            }
            case 32: {
                return "SPACE";
            }
            case 33: {
                return "PAGE_UP";
            }
            case 34: {
                return "PAGE_DOWN";
            }
            case 35: {
                return "END";
            }
            case 36: {
                return "HOME";
            }
            case 37: {
                return "LEFT";
            }
            case 38: {
                return "UP";
            }
            case 39: {
                return "RIGHT";
            }
            case 40: {
                return "DOWN";
            }
            case 106: {
                return "MULTIPLY";
            }
            case 107: {
                return "ADD";
            }
            case 108: {
                return "SEPARATOR";
            }
            case 109: {
                return "SUBTRACT";
            }
            case 110: {
                return "DECIMAL";
            }
            case 111: {
                return "DIVIDE";
            }
            case 127: {
                return "DELETE";
            }
            case 144: {
                return "NUM_LOCK";
            }
            case 145: {
                return "SCROLL_LOCK";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 154: {
                return "PRINTSCREEN";
            }
            case 155: {
                return "INSERT";
            }
            case 156: {
                return "HELP";
            }
            case 157: {
                return "META";
            }
            case 192: {
                return "BACK_QUOTE";
            }
            case 222: {
                return "QUOTE";
            }
            case 224: {
                return "KP_UP";
            }
            case 225: {
                return "KP_DOWN";
            }
            case 226: {
                return "KP_LEFT";
            }
            case 227: {
                return "KP_RIGHT";
            }
            case 128: {
                return "DEAD_GRAVE";
            }
            case 129: {
                return "DEAD_ACUTE";
            }
            case 130: {
                return "DEAD_CIRCUMFLEX";
            }
            case 131: {
                return "DEAD_TILDE";
            }
            case 132: {
                return "DEAD_MACRON";
            }
            case 133: {
                return "DEAD_BREVE";
            }
            case 134: {
                return "DEAD_ABOVEDOT";
            }
            case 135: {
                return "DEAD_DIAERESIS";
            }
            case 136: {
                return "DEAD_ABOVERING";
            }
            case 137: {
                return "DEAD_DOUBLEACUTE";
            }
            case 138: {
                return "DEAD_CARON";
            }
            case 139: {
                return "DEAD_CEDILLA";
            }
            case 140: {
                return "DEAD_OGONEK";
            }
            case 141: {
                return "DEAD_IOTA";
            }
            case 142: {
                return "DEAD_VOICED_SOUND";
            }
            case 143: {
                return "DEAD_SEMIVOICED_SOUND";
            }
            case 150: {
                return "AMPERSAND";
            }
            case 151: {
                return "ASTERISK";
            }
            case 152: {
                return "QUOTEDBL";
            }
            case 153: {
                return "LESS";
            }
            case 160: {
                return "GREATER";
            }
            case 161: {
                return "BRACELEFT";
            }
            case 162: {
                return "BRACERIGHT";
            }
            case 512: {
                return "AT";
            }
            case 513: {
                return "COLON";
            }
            case 514: {
                return "CIRCUMFLEX";
            }
            case 515: {
                return "DOLLAR";
            }
            case 516: {
                return "EURO_SIGN";
            }
            case 517: {
                return "EXCLAMATION_MARK";
            }
            case 518: {
                return "INVERTED_EXCLAMATION_MARK";
            }
            case 519: {
                return "LEFT_PARENTHESIS";
            }
            case 520: {
                return "NUMBER_SIGN";
            }
            case 45: {
                return "MINUS";
            }
            case 521: {
                return "PLUS";
            }
            case 522: {
                return "RIGHT_PARENTHESIS";
            }
            case 523: {
                return "UNDERSCORE";
            }
            case 24: {
                return "FINAL";
            }
            case 28: {
                return "CONVERT";
            }
            case 29: {
                return "NONCONVERT";
            }
            case 30: {
                return "ACCEPT";
            }
            case 31: {
                return "MODECHANGE";
            }
            case 21: {
                return "KANA";
            }
            case 25: {
                return "KANJI";
            }
            case 240: {
                return "ALPHANUMERIC";
            }
            case 241: {
                return "KATAKANA";
            }
            case 242: {
                return "HIRAGANA";
            }
            case 243: {
                return "FULL_WIDTH";
            }
            case 244: {
                return "HALF_WIDTH";
            }
            case 245: {
                return "ROMAN_CHARACTERS";
            }
            case 256: {
                return "ALL_CANDIDATES";
            }
            case 257: {
                return "PREVIOUS_CANDIDATE";
            }
            case 258: {
                return "CODE_INPUT";
            }
            case 259: {
                return "JAPANESE_KATAKANA";
            }
            case 260: {
                return "JAPANESE_HIRAGANA";
            }
            case 261: {
                return "JAPANESE_ROMAN";
            }
            case 262: {
                return "KANA_LOCK";
            }
            case 263: {
                return "INPUT_METHOD_ON_OFF";
            }
            case 65481: {
                return "AGAIN";
            }
            case 65483: {
                return "UNDO";
            }
            case 65485: {
                return "COPY";
            }
            case 65487: {
                return "PASTE";
            }
            case 65489: {
                return "CUT";
            }
            case 65488: {
                return "FIND";
            }
            case 65482: {
                return "PROPS";
            }
            case 65480: {
                return "STOP";
            }
            case 65312: {
                return "COMPOSE";
            }
            case 65406: {
                return "ALT_GRAPH";
            }
        }
        if (keyCode >= 96 && keyCode <= 105) {
            char c = (char)(keyCode - 96 + 48);
            return "NUMPAD" + c;
        }
        return "unknown(0x" + Integer.toString(keyCode, 16) + ")";
    }

    public static String keyStrokeToString(KeyStroke key) {
        StringBuffer s = new StringBuffer(50);
        int m = key.getModifiers();
        if ((m & 0x41) != 0) {
            s.append("shift ");
        }
        if ((m & 0x82) != 0) {
            s.append("ctrl ");
        }
        if ((m & 0x104) != 0) {
            s.append("meta ");
        }
        if ((m & 0x208) != 0) {
            s.append("alt ");
        }
        if ((m & 0x410) != 0) {
            s.append("button1 ");
        }
        if ((m & 0x808) != 0) {
            s.append("button2 ");
        }
        if ((m & 0x1004) != 0) {
            s.append("button3 ");
        }
        switch (key.getKeyEventType()) {
            case 400: {
                s.append("typed ");
                s.append(key.getKeyChar() + " ");
                break;
            }
            case 401: {
                s.append("pressed ");
                s.append(SwingUtils.getKeyText(key.getKeyCode()) + " ");
                break;
            }
            case 402: {
                s.append("released ");
                s.append(SwingUtils.getKeyText(key.getKeyCode()) + " ");
                break;
            }
            default: {
                s.append("unknown-event-type ");
            }
        }
        return s.toString();
    }

    public static void smartSetBounds(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 500;
        int height = 500;
        height = screenSize.height <= 600 ? (int)((double)screenSize.height * 0.95) : (screenSize.height <= 1000 ? (int)((double)screenSize.height * 0.9) : (screenSize.height <= 1200 ? (int)((double)screenSize.height * 0.85) : (int)((double)screenSize.height * 0.8)));
        width = screenSize.width <= 1000 ? (int)((double)screenSize.width * 0.95) : (screenSize.width <= 1200 ? (int)((double)screenSize.width * 0.9) : (screenSize.width <= 1600 ? (int)((double)screenSize.width * 0.85) : (int)((double)screenSize.width * 0.8)));
        frame.setBounds(0, 0, width, height);
    }

    public static JImageFrame namedWindow(String name, BufferedImage image) {
        JImageFrame window = new JImageFrame(image);
        window.setTitle(name);
        window.setDefaultCloseOperation(2);
        return window;
    }
}

