/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.JFancyButton;

public class PropertyPanel
extends JPanel {
    private static ImageIcon editIcon = null;
    private static ImageIcon icon = null;
    private static final long serialVersionUID = -5075241110598362410L;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    private ActionAdapter action;
    private JButton editButton;
    private boolean editable = false;
    private JLabel iconLabel = null;
    private JLabel nameLabel = null;
    private JTextField valueField = null;

    public PropertyPanel() {
        this.initialize();
    }

    public PropertyPanel(Object name, Object value) {
        this();
        this.setProperty(name, value);
    }

    public JButton getEditButton() {
        if (this.editButton == null && this.action != null) {
            this.editButton = new JFancyButton();
            this.editButton.setAction(this.action);
            this.editButton.setText("edit");
            this.editButton.setRolloverEnabled(true);
        }
        return this.editButton;
    }

    private ImageIcon getEditIcon() {
        if (editIcon == null) {
            editIcon = new ImageIcon(this.getClass().getResource("/images/arrow_right_green.png"));
        }
        return editIcon;
    }

    private ImageIcon getIcon() {
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/images/arrow_right_red.png"));
        }
        return icon;
    }

    private JLabel getIconLabel() {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setText("");
            this.iconLabel.setIcon(this.getIcon());
        }
        return this.iconLabel;
    }

    private JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setText("name");
            this.nameLabel.setHorizontalTextPosition(10);
            this.nameLabel.setPreferredSize(new Dimension(180, 20));
            this.nameLabel.setHorizontalAlignment(2);
        }
        return this.nameLabel;
    }

    public JTextField getValueField() {
        if (this.valueField == null) {
            this.valueField = new JTextField();
            this.valueField.setPreferredSize(new Dimension(180, 20));
            this.valueField.setEditable(false);
        }
        return this.valueField;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(10));
        this.add((Component)this.getNameLabel(), null);
        this.add(Box.createHorizontalGlue());
        this.add((Component)this.getIconLabel(), null);
        this.add(Box.createHorizontalStrut(10));
        this.add((Component)this.getValueField(), null);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditAction(ActionAdapter action) {
        this.action = action;
        this.add(Box.createHorizontalStrut(10));
        this.add(this.getEditButton());
        this.add(Box.createHorizontalStrut(10));
        this.getValueField().setEditable(true);
        this.getValueField().setEnabled(false);
        this.setEditable(true);
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.getValueField().setEditable(b);
        if (b) {
            this.getIconLabel().setIcon(this.getEditIcon());
        } else {
            this.getIconLabel().setIcon(this.getIcon());
        }
    }

    public void setProperty(Object name, Object value) {
        this.getNameLabel().setText(name.toString());
        String s = value.toString();
        if (value instanceof Date) {
            s = dateFormat.format(value);
        }
        this.getValueField().setText(s);
    }
}

