/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.mbari.swing.JImageCanvas;

public class JImageFrame
extends JFrame {
    private final JImageCanvas imageCanvas = new JImageCanvas();
    private boolean autosized = true;

    public JImageFrame() {
        this.initialize();
    }

    public JImageFrame(Image image) {
        this();
        this.setImage(image);
    }

    public Image getImage() {
        return this.imageCanvas.getImage();
    }

    public JComponent getImageDisplayComponent() {
        return this.imageCanvas;
    }

    public double getImageScale() {
        return this.imageCanvas.getImageScale();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.imageCanvas, "Center");
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JImageFrame.this.dispose();
            }
        });
    }

    public boolean isAutosized() {
        return this.autosized;
    }

    private void layoutFrame() {
        if (this.autosized && this.isVisible()) {
            double scaleY;
            double scaleX;
            int imageWidth = this.imageCanvas.getImageWidth();
            int imageHeight = this.imageCanvas.getImageHeight();
            Dimension screenSize = this.getToolkit().getScreenSize();
            Point locationOnScreen = this.getLocationOnScreen();
            Insets insets = this.getInsets();
            int preferredWidth = screenSize.width - (locationOnScreen.x + insets.left + insets.right);
            int preferredHeight = screenSize.height - (locationOnScreen.y + insets.top + insets.bottom);
            int actualFrameWidth = imageWidth + insets.left + insets.right;
            int actualFrameHeight = imageHeight + insets.top + insets.bottom;
            Dimension size = null;
            size = actualFrameWidth <= preferredWidth && actualFrameHeight <= preferredHeight ? new Dimension(actualFrameWidth, actualFrameHeight) : ((scaleX = (double)preferredWidth / (double)imageWidth) <= (scaleY = (double)preferredHeight / (double)imageWidth) ? new Dimension(preferredWidth, (int)Math.round((double)imageHeight * scaleX)) : new Dimension((int)Math.round((double)imageWidth * scaleY), preferredHeight));
            this.setSize(size);
            this.validate();
        }
        this.repaint();
    }

    public static void main(String[] args) throws Exception {
        final BufferedImage image1 = ImageIO.read(args.getClass().getResource("/images/BrianSchlining.jpg"));
        final BufferedImage image2 = ImageIO.read(args.getClass().getResource("/images/no_image.jpg"));
        final JImageFrame imageFrame = new JImageFrame(image1);
        imageFrame.setDefaultCloseOperation(3);
        imageFrame.setVisible(true);
        Thread swapThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (imageFrame.isVisible()) {
                    try {
                        Thread.sleep(3000L);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                imageFrame.setImage(image2);
                            }
                        });
                        Thread.sleep(3000L);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                imageFrame.setImage(image1);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        System.exit(0);
                    }
                }
            }
        });
        swapThread.setDaemon(true);
        swapThread.start();
    }

    public void setAutosized(boolean autosize) {
        this.autosized = autosize;
    }

    public void setImage(Image image) {
        this.imageCanvas.setImage(image);
        this.layoutFrame();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.layoutFrame();
    }
}

