/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.solar;

import java.io.IOException;
import org.mbari.math.Matlib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolarUtil {
    private static final Logger log = LoggerFactory.getLogger(SolarUtil.class);
    public static final double EARTH_ORBIT_ECCENTRICITY = 0.0167;
    static double[][] DOBSON_TABLE = new double[35][12];
    private static final double[] OZONE_LAMBDA = new double[]{350.0, 351.0, 352.0, 353.0, 354.0, 355.0, 356.0, 357.0, 358.0, 359.0, 360.0, 361.0, 362.0, 363.0, 364.0, 365.0, 366.0, 367.0, 368.0, 369.0, 370.0, 371.0, 372.0, 373.0, 374.0, 375.0, 376.0, 377.0, 378.0, 379.0, 380.0, 381.0, 382.0, 383.0, 384.0, 385.0, 386.0, 387.0, 388.0, 389.0, 390.0, 391.0, 392.0, 393.0, 394.0, 395.0, 396.0, 397.0, 398.0, 399.0, 400.0, 401.0, 402.0, 403.0, 404.0, 405.0, 406.0, 407.0, 408.0, 409.0, 410.0, 411.0, 412.0, 413.0, 414.0, 415.0, 416.0, 417.0, 418.0, 419.0, 420.0, 421.0, 422.0, 423.0, 424.0, 425.0, 426.0, 427.0, 428.0, 429.0, 430.0, 431.0, 432.0, 433.0, 434.0, 435.0, 436.0, 437.0, 438.0, 439.0, 440.0, 441.0, 442.0, 443.0, 444.0, 445.0, 446.0, 447.0, 448.0, 449.0, 450.0, 451.0, 452.0, 453.0, 454.0, 455.0, 456.0, 457.0, 458.0, 459.0, 460.0, 461.0, 462.0, 463.0, 464.0, 465.0, 466.0, 467.0, 468.0, 469.0, 470.0, 471.0, 472.0, 473.0, 474.0, 475.0, 476.0, 477.0, 478.0, 479.0, 480.0, 481.0, 482.0, 483.0, 484.0, 485.0, 486.0, 487.0, 488.0, 489.0, 490.0, 491.0, 492.0, 493.0, 494.0, 495.0, 496.0, 497.0, 498.0, 499.0, 500.0, 501.0, 502.0, 503.0, 504.0, 505.0, 506.0, 507.0, 508.0, 509.0, 510.0, 511.0, 512.0, 513.0, 514.0, 515.0, 516.0, 517.0, 518.0, 519.0, 520.0, 521.0, 522.0, 523.0, 524.0, 525.0, 526.0, 527.0, 528.0, 529.0, 530.0, 531.0, 532.0, 533.0, 534.0, 535.0, 536.0, 537.0, 538.0, 539.0, 540.0, 541.0, 542.0, 543.0, 544.0, 545.0, 546.0, 547.0, 548.0, 549.0, 550.0, 551.0, 552.0, 553.0, 554.0, 555.0, 556.0, 557.0, 558.0, 559.0, 560.0, 561.0, 562.0, 563.0, 564.0, 565.0, 566.0, 567.0, 568.0, 569.0, 570.0, 571.0, 572.0, 573.0, 574.0, 575.0, 576.0, 577.0, 578.0, 579.0, 580.0, 581.0, 582.0, 583.0, 584.0, 585.0, 586.0, 587.0, 588.0, 589.0, 590.0, 591.0, 592.0, 593.0, 594.0, 595.0, 596.0, 597.0, 598.0, 599.0, 600.0, 601.0, 602.0, 603.0, 604.0, 605.0, 606.0, 607.0, 608.0, 609.0, 610.0, 611.0, 612.0, 613.0, 614.0, 615.0, 616.0, 617.0, 618.0, 619.0, 620.0, 621.0, 622.0, 623.0, 624.0, 625.0, 626.0, 627.0, 628.0, 629.0, 630.0, 631.0, 632.0, 633.0, 634.0, 635.0, 636.0, 637.0, 638.0, 639.0, 640.0, 641.0, 642.0, 643.0, 644.0, 645.0, 646.0, 647.0, 648.0, 649.0, 650.0, 651.0, 652.0, 653.0, 654.0, 655.0, 656.0, 657.0, 658.0, 659.0, 660.0, 661.0, 662.0, 663.0, 664.0, 665.0, 666.0, 667.0, 668.0, 669.0, 670.0, 671.0, 672.0, 673.0, 674.0, 675.0, 676.0, 677.0, 678.0, 679.0, 680.0, 681.0, 682.0, 683.0, 684.0, 685.0, 686.0, 687.0, 688.0, 689.0, 690.0, 691.0, 692.0, 693.0, 694.0, 695.0, 696.0, 697.0, 698.0, 699.0, 700.0, 701.0, 702.0, 703.0, 704.0, 705.0, 706.0, 707.0, 708.0, 709.0, 710.0, 711.0, 712.0, 713.0, 714.0, 715.0, 716.0, 717.0, 718.0, 719.0, 720.0, 721.0, 722.0, 723.0, 724.0, 725.0, 726.0, 727.0, 728.0, 729.0, 730.0, 731.0, 732.0, 733.0, 734.0, 735.0, 736.0, 737.0, 738.0, 739.0, 740.0, 741.0, 742.0, 743.0, 744.0, 745.0, 746.0, 747.0, 748.0, 749.0, 750.0, 751.0, 752.0, 753.0, 754.0, 755.0, 756.0, 757.0, 758.0, 759.0, 760.0, 761.0, 762.0, 763.0, 764.0, 765.0, 766.0, 767.0, 768.0, 769.0, 770.0, 771.0, 772.0, 773.0, 774.0, 775.0, 776.0, 777.0, 778.0, 779.0, 780.0, 781.0, 782.0, 783.0, 784.0, 785.0, 786.0, 787.0, 788.0, 789.0, 790.0, 791.0, 792.0, 793.0, 794.0, 795.0, 796.0, 797.0, 798.0, 799.0, 800.0, 801.0, 802.0, 803.0, 804.0, 805.0, 806.0, 807.0, 808.0, 809.0, 810.0, 811.0, 812.0, 813.0, 814.0, 815.0, 816.0, 817.0, 818.0, 819.0, 820.0, 821.0, 822.0, 823.0, 824.0, 825.0, 826.0, 827.0, 828.0, 829.0, 830.0, 831.0, 832.0, 833.0, 834.0, 835.0, 836.0, 837.0, 838.0, 839.0, 840.0, 841.0, 842.0, 843.0, 844.0, 845.0, 846.0, 847.0, 848.0, 849.0, 850.0, 851.0, 852.0, 853.0, 854.0, 855.0, 856.0, 857.0, 858.0, 859.0, 860.0, 861.0, 862.0, 863.0, 864.0, 865.0, 866.0, 867.0, 868.0, 869.0, 870.0, 871.0, 872.0, 873.0, 874.0, 875.0, 876.0, 877.0, 878.0, 879.0, 880.0, 881.0, 882.0, 883.0, 884.0, 885.0, 886.0, 887.0, 888.0, 889.0, 890.0, 891.0, 892.0, 893.0, 894.0, 895.0, 896.0, 897.0, 898.0, 899.0, 900.0, 901.0, 902.0, 903.0, 904.0, 905.0, 906.0, 907.0, 908.0, 909.0, 910.0, 911.0, 912.0, 913.0, 914.0, 915.0, 916.0, 917.0, 918.0, 919.0, 920.0, 921.0, 922.0, 923.0, 924.0, 925.0, 926.0, 927.0, 928.0, 929.0, 930.0, 931.0, 932.0, 933.0, 934.0, 935.0, 936.0, 937.0, 938.0, 939.0, 940.0, 941.0, 942.0, 943.0, 944.0, 945.0, 946.0, 947.0, 948.0, 949.0, 950.0, 951.0, 952.0, 953.0, 954.0, 955.0, 956.0, 957.0, 958.0, 959.0, 960.0, 961.0, 962.0, 963.0, 964.0, 965.0, 966.0, 967.0, 968.0, 969.0, 970.0, 971.0, 972.0, 973.0, 974.0, 975.0, 976.0, 977.0, 978.0, 979.0, 980.0, 981.0, 982.0, 983.0, 984.0, 985.0, 986.0, 987.0, 988.0, 989.0, 990.0, 991.0, 992.0, 993.0, 994.0, 995.0, 996.0, 997.0, 998.0, 999.0, 1000.0};
    private static final double[] OZONE_ABSORPTION = new double[]{0.0089999996, 0.0119999992, 0.0089999996, 0.0059999996, 0.0039999997, 0.0019999999, 0.0019999999, 9.999999E-4, 9.999999E-4, 9.999999E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.999999E-4, 9.999999E-4, 9.999999E-4, 9.999999E-4, 9.999999E-4, 0.0019999999, 0.0019999999, 0.0019999999, 0.0019999999, 0.0019999999, 0.0019999999, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0029999998, 0.0039999997, 0.0039999997, 0.0049999999, 0.0049999999, 0.0059999996, 0.0069999998, 0.0069999998, 0.0079999994, 0.0079999994, 0.0089999996, 0.0089999996, 0.0089999996, 0.0089999996, 0.0079999994, 0.0079999994, 0.0069999998, 0.0069999998, 0.0069999998, 0.0069999998, 0.0079999994, 0.0089999996, 0.0099999998, 0.0109999999, 0.0119999992, 0.0129999993, 0.0139999995, 0.0149999997, 0.0169999991, 0.0179999992, 0.0189999994, 0.0199999996, 0.0199999996, 0.0209999997, 0.0199999996, 0.0199999996, 0.0189999994, 0.0189999994, 0.0179999992, 0.0179999992, 0.0189999994, 0.0189999994, 0.0199999996, 0.0209999997, 0.0219999999, 0.0229999982, 0.0239999983, 0.0249999985, 0.0259999987, 0.027999999, 0.0299999993, 0.0319999978, 0.0339999981, 0.0359999985, 0.0379999988, 0.0389999971, 0.0409999974, 0.0409999974, 0.0409999974, 0.0399999991, 0.0389999971, 0.0379999988, 0.0369999968, 0.0369999968, 0.0379999988, 0.0389999971, 0.0409999974, 0.0419999994, 0.0439999998, 0.0449999981, 0.0469999984, 0.0489999987, 0.050999999, 0.0519999973, 0.0539999977, 0.055999998, 0.0579999983, 0.0589999966, 0.060999997, 0.0629999936, 0.0639999956, 0.0659999996, 0.0679999962, 0.0689999983, 0.0699999928, 0.0709999949, 0.0719999969, 0.0719999969, 0.0719999969, 0.0719999969, 0.0729999989, 0.0739999935, 0.0749999955, 0.0759999976, 0.0769999996, 0.0789999962, 0.0799999982, 0.0809999928, 0.0829999968, 0.0839999989, 0.0849999934, 0.0859999955, 0.0869999975, 0.0879999995, 0.0889999941, 0.0899999961, 0.0909999982, 0.0919999927, 0.0939999968, 0.0959999934, 0.0979999974, 0.099999994, 0.1029999927, 0.1049999967, 0.1069999933, 0.1089999974, 0.111999996, 0.112999998, 0.1149999946, 0.1159999967, 0.1169999987, 0.1179999933, 0.1189999953, 0.1189999953, 0.1189999953, 0.1189999953, 0.1189999953, 0.1189999953, 0.1179999933, 0.1169999987, 0.1159999967, 0.1149999946, 0.1139999926, 0.111999996, 0.110999994, 0.1099999994, 0.1089999974, 0.1089999974, 0.1079999954, 0.1079999954, 0.1089999974, 0.1099999994, 0.111999996, 0.112999998, 0.1149999946, 0.1169999987, 0.1189999953, 0.1209999993, 0.1219999939, 0.123999998, 0.125, 0.125, 0.125, 0.125, 0.123999998, 0.1229999959, 0.1219999939, 0.1199999973, 0.1189999953, 0.1179999933, 0.1159999967, 0.1149999946, 0.1139999926, 0.111999996, 0.110999994, 0.1099999994, 0.1079999954, 0.1069999933, 0.1049999967, 0.1039999947, 0.1029999927, 0.1009999961, 0.099999994, 0.0989999995, 0.0969999954, 0.0959999934, 0.0939999968, 0.0929999948, 0.0919999927, 0.0899999961, 0.0889999941, 0.0879999995, 0.0859999955, 0.0849999934, 0.0829999968, 0.0819999948, 0.0809999928, 0.0789999962, 0.0779999942, 0.0769999996, 0.0749999955, 0.0739999935, 0.0729999989, 0.0709999949, 0.0699999928, 0.0679999962, 0.0669999942, 0.0659999996, 0.0649999976, 0.0639999956, 0.0629999936, 0.061999999, 0.060999997, 0.0599999987, 0.0589999966, 0.0579999983, 0.0569999963, 0.055999998, 0.055999998, 0.0549999997, 0.0539999977, 0.0529999994, 0.0519999973, 0.050999999, 0.050999999, 0.049999997, 0.0489999987, 0.0479999967, 0.0469999984, 0.0459999964, 0.0449999981, 0.0449999981, 0.0439999998, 0.0429999977, 0.0419999994, 0.0409999974, 0.0399999991, 0.0399999991, 0.0389999971, 0.0379999988, 0.0369999968, 0.0359999985, 0.0349999964, 0.0339999981, 0.0339999981, 0.0329999998, 0.0319999978, 0.0309999995, 0.0299999993, 0.0299999993, 0.0289999992, 0.027999999, 0.0269999988, 0.0259999987, 0.0249999985, 0.0239999983, 0.0239999983, 0.0229999982, 0.0219999999, 0.0219999999, 0.0209873207, 0.020338269, 0.0197092891, 0.0190997627, 0.0185090862, 0.0179366767, 0.0173819698, 0.016844416, 0.0163234882, 0.0158186704, 0.0153294643, 0.0148553876, 0.0143959718, 0.0139507642, 0.0135193244, 0.0131012276, 0.0126960604, 0.0123034241, 0.0119229294, 0.011554203, 0.0111968787, 0.0108506056, 0.0105150416, 0.0101898545, 0.0098747239, 0.0095693395, 0.0092733996, 0.0089866119, 0.0087086931, 0.0084393686, 0.0081783738, 0.0079254508, 0.0076803495, 0.0074428283, 0.0072126519, 0.0069895945, 0.006773435, 0.006563961, 0.0063609648, 0.0061642462, 0.0059736115, 0.0057888725, 0.0056098467, 0.0054363571, 0.0052682329, 0.0051053083, 0.0049474221, 0.0047944188, 0.0046461471, 0.0045024613, 0.0043632188, 0.0042282823, 0.004097519, 0.0039707995, 0.0038479993, 0.0037289965, 0.0036136741, 0.0035019182, 0.0033936182, 0.0032886676, 0.0031869628, 0.003088403, 0.0029928915, 0.0029003338, 0.0028106384, 0.0027237169, 0.0026394837, 0.0025578553, 0.0024787514, 0.002402094, 0.002327807, 0.0022558176, 0.0021860544, 0.0021184487, 0.0020529339, 0.0019894452, 0.0019279199, 0.0018682973, 0.0018105186, 0.0017545267, 0.0017002665, 0.0016476843, 0.0015967281, 0.001547348, 0.0014994949, 0.0014531217, 0.0014081827, 0.0013646333, 0.0013224309, 0.0012815335, 0.001241901, 0.0012034941, 0.001166275, 0.001130207, 0.0010952543, 0.0010613826, 0.0010285585, 9.967494E-4, 9.659241E-4, 9.36052E-4, 9.071038E-4, 8.790508E-4, 8.518654E-4, 8.255207E-4, 7.999908E-4, 7.752504E-4, 7.512751E-4, 7.280412E-4, 7.055259E-4, 6.83707E-4, 6.625627E-4, 6.420724E-4, 6.222157E-4, 6.029732E-4, 5.843257E-4, 5.662549E-4, 5.48743E-4, 5.317726E-4, 5.153271E-4, 4.993902E-4, 4.839461E-4, 4.689796E-4, 4.54476E-4, 4.40421E-4, 4.268006E-4, 4.136014E-4, 4.008104E-4, 3.88415E-4, 3.764029E-4, 3.647623E-4, 3.534817E-4, 3.4255E-4, 3.319563E-4, 3.216903E-4, 3.117418E-4, 3.021009E-4, 2.927581E-4, 2.837043E-4, 2.749305E-4, 2.664281E-4, 2.581885E-4, 2.502039E-4, 2.424661E-4, 2.349676E-4, 2.27701E-4, 2.206592E-4, 2.138351E-4, 2.072221E-4, 2.008135E-4, 1.946032E-4, 1.885849E-4, 1.827528E-4, 1.77101E-4, 1.71624E-4, 1.663164E-4, 1.611729E-4, 1.561885E-4, 1.513582E-4, 1.466773E-4, 1.421412E-4, 1.377454E-4, 1.334855E-4, 1.293573E-4, 1.253568E-4, 1.214801E-4, 1.177232E-4, 1.140825E-4, 1.105544E-4, 1.071354E-4, 1.038221E-4, 1.006114E-4, 9.74999E-5, 9.44846E-5, 9.15626E-5, 8.87309E-5, 8.59868E-5, 8.33276E-5, 8.07506E-5, 7.82534E-5, 7.58333E-5, 7.34881E-5, 7.12154E-5, 6.9013E-5, 6.68787E-5, 6.48104E-5, 6.28061E-5, 6.08638E-5, 5.89815E-5, 5.71575E-5, 5.53898E-5, 5.36768E-5, 5.20168E-5, 5.04082E-5, 4.88493E-5, 4.73386E-5, 4.58746E-5, 4.44559E-5, 4.3081E-5, 4.17487E-5, 4.04576E-5, 3.92064E-5, 3.79939E-5, 3.68189E-5, 3.56803E-5, 3.45768E-5, 3.35075E-5, 3.24712E-5, 3.1467E-5, 3.04939E-5, 2.95509E-5, 2.8637E-5, 2.77513E-5, 2.68931E-5, 2.60614E-5, 2.52554E-5, 2.44744E-5, 2.37175E-5, 2.2984E-5, 2.22732E-5, 2.15844E-5, 2.09169E-5, 2.027E-5, 1.96431E-5, 1.90357E-5, 1.8447E-5, 1.78765E-5, 1.73236E-5, 1.67879E-5, 1.62687E-5, 1.57656E-5, 1.5278E-5, 1.48055E-5, 1.43477E-5, 1.39039E-5, 1.3474E-5, 1.30573E-5, 1.26535E-5, 1.22621E-5, 1.18829E-5, 1.15154E-5, 1.11593E-5, 1.08142E-5, 1.04798E-5, 1.01557E-5, 9.8416E-6, 9.5372E-6, 9.2423E-6, 8.9565E-6, 8.6795E-6, 8.411E-6, 8.1509E-6, 7.8989E-6, 7.6546E-6, 7.4178E-6, 7.1884E-6, 6.9661E-6, 6.7507E-6, 6.5419E-6, 6.3396E-6, 6.1436E-6, 5.9536E-6, 5.7694E-6, 5.591E-6, 5.4181E-6, 5.2506E-6, 5.0882E-6, 4.9308E-6, 4.7783E-6, 4.6306E-6, 4.4874E-6, 4.3486E-6, 4.2141E-6, 4.0838E-6, 3.9575E-6, 3.8351E-6, 3.7165E-6, 3.6015E-6, 3.4902E-6, 3.3822E-6, 3.2776E-6, 3.1763E-6, 3.078E-6, 2.9828E-6, 2.8906E-6, 2.8012E-6, 2.7146E-6, 2.6306E-6, 2.5493E-6, 2.4704E-6, 2.394E-6, 2.32E-6, 2.2482E-6, 2.1787E-6, 2.1113E-6, 2.046E-6, 1.9828E-6, 1.9214E-6, 1.862E-6, 1.8044E-6, 1.7486E-6};
    private static final double[] LAMBDA = new double[]{329.8, 331.8, 333.8, 335.9, 337.9, 339.8, 341.9, 343.8, 345.8, 347.9, 349.8, 351.9, 353.9, 355.9, 357.9, 360.0, 362.0, 364.1, 366.1, 367.8, 369.8, 371.9, 373.7, 375.5, 377.5, 379.4, 381.4, 383.4, 385.4, 387.4, 389.4, 391.2, 393.2, 395.0, 396.9, 398.9, 400.1, 402.0, 404.0, 406.0, 407.9, 409.9, 411.7, 413.7, 415.6, 417.6, 419.1, 421.1, 423.1, 424.8, 426.8, 428.6, 430.6, 432.6, 434.0, 435.9, 437.2, 439.2, 440.9, 442.8, 444.7, 446.4, 448.3, 450.3, 452.4, 454.4, 456.4, 458.4, 460.4, 462.4, 464.4, 466.4, 468.4, 470.4, 472.3, 474.3, 476.3, 478.3, 480.3, 482.3, 484.3, 486.3, 488.3, 489.3, 491.3, 493.3, 495.1, 497.1, 498.9, 500.9, 502.9, 504.9, 506.8, 508.8, 510.8, 512.8, 514.8, 516.8, 518.8, 520.0, 521.9, 523.9, 525.8, 527.8, 529.8, 531.6, 533.5, 535.4, 537.2, 539.2, 541.0, 543.0, 545.0, 547.0, 549.0, 550.8, 552.7, 554.7, 556.7, 558.7, 560.7, 562.7, 564.6, 566.6, 568.6, 570.6, 572.6, 574.6, 576.6, 578.5, 580.5, 582.5, 584.5, 586.5, 588.4, 590.4, 592.3, 594.3, 596.3, 598.3, 600.3, 602.3, 604.3, 606.3, 608.0, 610.0, 612.0, 614.0, 616.0, 618.0, 620.0, 622.0, 623.9, 625.9, 627.9, 629.9, 631.9, 633.9, 635.9, 637.9, 639.9, 641.9, 643.9, 645.9, 647.9, 649.9, 651.9, 653.9, 655.9, 662.1, 666.3, 679.0, 709.0};
    private static final double[] E0 = new double[]{107.65, 98.7, 95.0, 91.0, 88.95, 100.85, 95.75, 87.85, 94.4, 95.4, 98.4, 97.3, 115.55, 108.0, 76.3, 108.85, 106.9, 101.6, 128.8, 117.85, 123.05, 119.0, 98.45, 104.7, 139.0, 122.95, 114.8, 74.9, 103.05, 99.9, 117.3, 129.95, 76.55, 130.1, 88.65, 160.6, 170.15, 178.55, 162.2, 164.55, 169.15, 166.0, 181.35, 173.3, 178.85, 169.25, 165.6, 181.85, 165.0, 175.1, 162.0, 164.9, 123.0, 179.35, 173.65, 185.55, 184.35, 167.35, 179.35, 195.55, 194.8, 185.15, 202.0, 213.0, 199.65, 201.3, 205.9, 201.6, 202.15, 209.45, 199.45, 195.65, 201.1, 194.3, 201.85, 203.2, 197.2, 205.05, 206.4, 204.15, 201.2, 171.5, 187.75, 193.95, 188.4, 193.5, 198.9, 199.35, 192.1, 182.35, 192.2, 191.55, 196.7, 192.75, 193.2, 189.5, 185.25, 169.2, 173.3, 181.8, 188.1, 191.35, 183.15, 180.8, 194.1, 193.4, 184.35, 193.75, 184.95, 184.25, 180.5, 185.45, 188.75, 184.35, 186.75, 185.8, 185.35, 188.1, 180.05, 179.95, 180.4, 185.35, 182.9, 182.2, 133.7, 178.9, 187.25, 184.25, 184.15, 180.25, 184.0, 184.4, 183.3, 178.95, 174.5, 173.85, 177.65, 178.7, 179.6, 173.15, 172.45, 170.55, 175.85, 173.7, 173.0, 172.0, 173.8, 169.95, 166.9, 172.5, 171.5, 169.05, 165.7, 165.8, 168.15, 164.0, 165.0, 164.15, 165.7, 166.25, 162.05, 160.95, 162.0, 161.2, 161.2, 156.45, 160.2, 159.05, 137.3, 157.45, 155.0, 146.95, 138.0};

    public static final double[] getNeckelLabWavelengths() {
        double[] lambda = new double[LAMBDA.length];
        System.arraycopy(LAMBDA, 0, lambda, 0, LAMBDA.length);
        return lambda;
    }

    public static final double[] getNeckelLabIrradiance(double[] lambda) {
        return Matlib.interpolate(SolarUtil.getNeckelLabWavelengths(), SolarUtil.getNeckelLabIrradiance(), lambda);
    }

    public static final double[] getNeckelLabIrradiance() {
        double[] e0 = new double[E0.length];
        System.arraycopy(E0, 0, e0, 0, E0.length);
        return e0;
    }

    public static final double[] getOzoneWavelengths() throws IOException {
        double[] lambda = new double[OZONE_LAMBDA.length];
        System.arraycopy(OZONE_LAMBDA, 0, lambda, 0, OZONE_LAMBDA.length);
        return lambda;
    }

    public static final double[] getOzoneAbsorption() throws IOException {
        double[] e0 = new double[OZONE_ABSORPTION.length];
        System.arraycopy(OZONE_ABSORPTION, 0, e0, 0, OZONE_ABSORPTION.length);
        return e0;
    }

    public static final double[] getOzoneAbsorption(double[] lambda) throws IOException {
        return Matlib.interpolate(SolarUtil.getOzoneWavelengths(), SolarUtil.getOzoneAbsorption(), lambda);
    }

    public static double getEarthSunIrradianceCorrectionLP(int dayOfYear) {
        double e = 0.0167;
        return Math.pow(1.0 + e * Math.cos(Math.PI * 2 * ((double)dayOfYear - 3.0) / 365.0), 2.0);
    }

    public static double getEarthSunDistanceLP(int dayOfYear) {
        return 1.0 / SolarUtil.getEarthSunIrradianceCorrectionLP(dayOfYear);
    }

    public static double[] getCorrectedETIrradiance(double[] lambda, int dayOfYear) {
        double[] e0 = SolarUtil.getNeckelLabIrradiance(lambda);
        double earthSunDistance = SolarUtil.getEarthSunIrradianceCorrectionLP(dayOfYear);
        double[] Es = new double[e0.length];
        for (int i = 0; i < e0.length; ++i) {
            Es[i] = e0[i] * earthSunDistance;
        }
        return Es;
    }

    public static double estimateDobson(int month, double lat) {
        double dobson;
        --month;
        if (lat >= 85.0) {
            dobson = DOBSON_TABLE[0][month];
        } else if (lat <= -85.0) {
            dobson = DOBSON_TABLE[34][month];
        } else if (lat >= 0.0) {
            int i1 = 17 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (DOBSON_TABLE[i2][month] - DOBSON_TABLE[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            dobson = DOBSON_TABLE[i1][month] + fac * diffLat;
        } else {
            int i1 = 18 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (DOBSON_TABLE[i2][month] - DOBSON_TABLE[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            dobson = DOBSON_TABLE[i1][month] + fac * diffLat;
        }
        return dobson;
    }

    static {
        double[] dobsonTmp = new double[]{395.0, 395.0, 395.0, 395.0, 395.0, 392.0, 390.0, 387.0, 376.0, 354.0, 322.0, 292.0, 269.0, 254.0, 248.0, 246.0, 247.0, 251.0, 255.0, 260.0, 266.0, 271.0, 277.0, 286.0, 295.0, 306.0, 319.0, 334.0, 344.0, 344.0, 338.0, 331.0, 324.0, 320.0, 316.0, 433.0, 433.0, 433.0, 436.0, 432.0, 428.0, 426.0, 418.0, 402.0, 374.0, 338.0, 303.0, 278.0, 261.0, 251.0, 246.0, 248.0, 250.0, 254.0, 258.0, 262.0, 265.0, 270.0, 278.0, 286.0, 294.0, 303.0, 313.0, 322.0, 325.0, 324.0, 317.0, 306.0, 299.0, 294.0, 467.0, 470.0, 460.0, 459.0, 451.0, 441.0, 433.0, 420.0, 401.0, 377.0, 347.0, 316.0, 291.0, 271.0, 260.0, 254.0, 254.0, 255.0, 257.0, 259.0, 261.0, 264.0, 269.0, 277.0, 284.0, 289.0, 296.0, 305.0, 312.0, 315.0, 317.0, 312.0, 305.0, 299.0, 295.0, 467.0, 465.0, 462.0, 455.0, 444.0, 431.0, 421.0, 410.0, 395.0, 373.0, 348.0, 325.0, 304.0, 287.0, 275.0, 267.0, 261.0, 259.0, 258.0, 259.0, 260.0, 263.0, 271.0, 278.0, 284.0, 289.0, 297.0, 306.0, 314.0, 318.0, 319.0, 313.0, 302.0, 302.0, 302.0, 411.0, 414.0, 416.0, 415.0, 410.0, 406.0, 402.0, 394.0, 382.0, 363.0, 342.0, 324.0, 307.0, 291.0, 279.0, 271.0, 264.0, 260.0, 258.0, 257.0, 258.0, 264.0, 271.0, 281.0, 291.0, 303.0, 312.0, 318.0, 322.0, 323.0, 322.0, 322.0, 322.0, 322.0, 322.0, 371.0, 371.0, 370.0, 368.0, 367.0, 372.0, 375.0, 372.0, 360.0, 341.0, 323.0, 311.0, 301.0, 290.0, 282.0, 275.0, 268.0, 263.0, 259.0, 256.0, 258.0, 264.0, 273.0, 289.0, 306.0, 319.0, 327.0, 328.0, 328.0, 337.0, 337.0, 337.0, 337.0, 337.0, 337.0, 333.0, 332.0, 332.0, 334.0, 338.0, 346.0, 350.0, 346.0, 335.0, 321.0, 310.0, 302.0, 296.0, 289.0, 284.0, 280.0, 274.0, 268.0, 262.0, 259.0, 261.0, 268.0, 279.0, 295.0, 315.0, 331.0, 340.0, 342.0, 338.0, 344.0, 340.0, 340.0, 340.0, 340.0, 340.0, 311.0, 308.0, 308.0, 313.0, 320.0, 327.0, 330.0, 326.0, 319.0, 310.0, 303.0, 298.0, 291.0, 286.0, 283.0, 281.0, 277.0, 273.0, 268.0, 264.0, 266.0, 274.0, 288.0, 306.0, 327.0, 343.0, 353.0, 355.0, 351.0, 339.0, 325.0, 307.0, 294.0, 294.0, 294.0, 283.0, 291.0, 302.0, 308.0, 312.0, 317.0, 318.0, 313.0, 307.0, 300.0, 295.0, 290.0, 284.0, 279.0, 279.0, 279.0, 278.0, 276.0, 272.0, 270.0, 273.0, 282.0, 295.0, 313.0, 333.0, 348.0, 360.0, 367.0, 368.0, 353.0, 324.0, 291.0, 267.0, 253.0, 230.0, 299.0, 299.0, 299.0, 309.0, 315.0, 317.0, 317.0, 312.0, 302.0, 291.0, 283.0, 280.0, 275.0, 270.0, 268.0, 267.0, 263.0, 263.0, 265.0, 269.0, 277.0, 287.0, 301.0, 317.0, 336.0, 354.0, 371.0, 387.0, 402.0, 402.0, 374.0, 333.0, 294.0, 274.0, 259.0, 314.0, 314.0, 314.0, 314.0, 332.0, 332.0, 327.0, 322.0, 311.0, 297.0, 284.0, 276.0, 270.0, 263.0, 261.0, 260.0, 258.0, 259.0, 264.0, 270.0, 278.0, 286.0, 298.0, 311.0, 323.0, 335.0, 350.0, 366.0, 381.0, 390.0, 388.0, 376.0, 357.0, 346.0, 341.0, 358.0, 358.0, 358.0, 358.0, 358.0, 358.0, 353.0, 349.0, 338.0, 320.0, 299.0, 281.0, 267.0, 256.0, 252.0, 251.0, 251.0, 253.0, 257.0, 264.0, 272.0, 279.0, 287.0, 297.0, 307.0, 318.0, 332.0, 347.0, 358.0, 365.0, 366.0, 364.0, 358.0, 356.0, 353.0};
        int n = -1;
        for (int c = 0; c < 12; ++c) {
            for (int r = 0; r < 35; ++r) {
                SolarUtil.DOBSON_TABLE[r][c] = dobsonTmp[++n];
            }
        }
    }
}

