/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.math;

import java.util.Arrays;
import org.mbari.math.DoubleMath;
import org.mbari.math.Matlib;

public class Statlib {
    public static strictfp double correlationCoefficient(double[] I, double[] R) {
        double k = I.length;
        double meanI = Statlib.mean(I);
        double meanR = Statlib.mean(R);
        double varR = Statlib.variance(R);
        double sumI2 = 0.0;
        double sumIR = 0.0;
        int i = 0;
        while ((double)i < k) {
            double id = I[i];
            sumI2 += id * id;
            sumIR += id * R[i];
            ++i;
        }
        return (sumIR - k * meanI * meanR) / (Math.sqrt(sumI2 - k * meanI * meanI) * varR);
    }

    public static strictfp double crossCorrelation(double[] v1, double[] v2) {
        throw new UnsupportedOperationException("Still working on this");
    }

    public static strictfp double[] deviationFromMean(double[] values) {
        double mean = Statlib.mean(values);
        double[] deviation = new double[values.length];
        for (int i = 0; i < deviation.length; ++i) {
            deviation[i] = values[i] - mean;
        }
        return deviation;
    }

    public static strictfp double mean(double[] values) {
        return Matlib.sum(values) / (double)values.length;
    }

    public static double median(double[] values) {
        double[] v = new double[values.length];
        double median = Double.NaN;
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("The data array either is null or does not contain any data.");
        }
        if (v.length == 1) {
            median = v[0];
        } else {
            System.arraycopy(values, 0, v, 0, values.length);
            Arrays.sort(v);
            if (DoubleMath.isEven(v.length)) {
                int i = (int)Math.ceil((double)v.length / 2.0);
                double n1 = v[i];
                double n0 = v[i - 1];
                median = (n0 + n1) / 2.0;
            } else {
                median = v[v.length / 2];
            }
        }
        return median;
    }

    public static strictfp double pearsonsCorrelation(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The double arrays must be the same length!!! " + x.length + " != " + y.length);
        }
        double N = y.length;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = x[0];
        double mean_y = y[0];
        int i = 2;
        while ((double)i <= N) {
            double sweep = ((double)i - 1.0) / (double)i;
            double delta_x = x[i - 1] - mean_x;
            double delta_y = y[i - 1] - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
            ++i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / N);
        double pop_sd_y = Math.sqrt(sum_sq_y / N);
        double cov_x_y = sum_coproduct / N;
        return cov_x_y / (pop_sd_x * pop_sd_y);
    }

    public static strictfp double populationStandardDeviation(double[] values) {
        double mean = Statlib.mean(values);
        double n = values.length;
        double dv = 0.0;
        for (double d : values) {
            double dm = d - mean;
            dv += dm * dm;
        }
        return Math.sqrt(dv / n);
    }

    public static double populationVariance(double[] values) {
        double stdP = Statlib.populationStandardDeviation(values);
        return stdP * stdP;
    }

    public static double quartile(double[] values, double lowerPercent) {
        return Statlib.percentile(values, lowerPercent / 100.0);
    }

    public static double percentile(double[] values, double percent) {
        if (percent < 0.0 || percent > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1, found was " + percent);
        }
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("The data array either is null or does not contain any data.");
        }
        double[] v = new double[values.length];
        System.arraycopy(values, 0, v, 0, values.length);
        Arrays.sort(v);
        int n = (int)Math.round((double)v.length * percent) - 1;
        if (n < 0) {
            n = 0;
        } else if (n > values.length - 1) {
            n = values.length - 1;
        }
        return v[n];
    }

    public static strictfp double standardDeviation(double[] values) {
        double mean = Statlib.mean(values);
        double dv = 0.0;
        for (double d : values) {
            double dm = d - mean;
            dv += dm * dm;
        }
        return Math.sqrt(dv / (double)(values.length - 1));
    }

    public static double variance(double[] values) {
        double std = Statlib.standardDeviation(values);
        return std * std;
    }

    public static double[] hist(double[] data, double[] centers, boolean inclusive) {
        double[] histogram = new double[centers.length];
        for (double datum : data) {
            int n = Matlib.near(centers, datum, inclusive);
            if (n < 0) continue;
            histogram[n] = histogram[n] + 1.0;
        }
        return histogram;
    }

    public static double[] histc(double[] data, double[] edges) {
        double[] histogram = new double[edges.length];
        for (double datum : data) {
            int idx = Arrays.binarySearch(edges, datum);
            if (idx < 0) {
                idx = (idx = -idx - 1) <= 0 || idx >= edges.length ? -1 : (idx > edges.length - 2 ? edges.length - 2 : (idx <= 0 ? 0 : --idx));
            }
            if (idx < 0) continue;
            histogram[idx] = histogram[idx] + 1.0;
        }
        return histogram;
    }
}

