/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mbari.geometry.Point2D;
import org.mbari.geometry.XComparator;
import org.mbari.geometry.YComparator;

public class PointUtilities {
    private static final Point2D<Double> ORIGIN = new Point2D<Double>(0.0, 0.0);

    public static Point2D<Double> centroid(Collection<? extends Point2D> points) {
        double x = 0.0;
        double y = 0.0;
        for (Point2D point2D : points) {
            x += ((Number)point2D.getX()).doubleValue();
            y += ((Number)point2D.getY()).doubleValue();
        }
        return new Point2D<Double>(x /= (double)points.size(), y /= (double)points.size());
    }

    public static Point2D maximum(Collection<? extends Point2D> points) {
        Point2D maxX = Collections.max(points, new XComparator());
        Point2D maxY = Collections.max(points, new YComparator());
        return new Point2D(maxX.getX(), maxY.getY());
    }

    public static Point2D minimum(Collection<? extends Point2D> points) {
        Point2D minX = Collections.min(points, new XComparator());
        Point2D minY = Collections.min(points, new YComparator());
        return new Point2D(minX.getX(), minY.getY());
    }

    public static List<Point2D<Double>> rotate(List<? extends Point2D> points, double angleRadians, Point2D pivot) {
        double pivotX = ((Number)pivot.getX()).doubleValue();
        double pivotY = ((Number)pivot.getY()).doubleValue();
        List<Point2D<Double>> translatedPoints = PointUtilities.translate(points, -pivotX, -pivotY);
        ArrayList<Point2D<Double>> rotatedAndTranslatedPoints = new ArrayList<Point2D<Double>>();
        for (Point2D<Double> p : translatedPoints) {
            double newX = p.getX() * Math.cos(angleRadians) - p.getY() * Math.sin(angleRadians);
            double newY = p.getX() * Math.sin(angleRadians) + p.getY() * Math.cos(angleRadians);
            rotatedAndTranslatedPoints.add(new Point2D<Double>(newX, newY));
        }
        return PointUtilities.translate(rotatedAndTranslatedPoints, pivotX, pivotY);
    }

    public static List<Point2D<Double>> rotate(List<? extends Point2D> points, double angleRadians) {
        return PointUtilities.rotate(points, angleRadians, ORIGIN);
    }

    public static List<Point2D<Double>> scale(List<? extends Point2D> points, Double scale, Point2D center) {
        double centerX = ((Number)center.getX()).doubleValue();
        double centerY = ((Number)center.getY()).doubleValue();
        List<Point2D<Double>> translatedPoints = PointUtilities.translate(points, -centerX, -centerY);
        ArrayList<Point2D<Double>> scaledPoints = new ArrayList<Point2D<Double>>(translatedPoints.size());
        for (Point2D<Double> p : translatedPoints) {
            scaledPoints.add(new Point2D<Double>(p.getX() * scale, p.getY() * scale));
        }
        return PointUtilities.translate(scaledPoints, centerX, centerY);
    }

    public static List<Point2D<Double>> scale(List<? extends Point2D> points, Double scale) {
        return PointUtilities.scale(points, scale, ORIGIN);
    }

    public static List<Point2D<Double>> translate(List<? extends Point2D> points, double x, double y) {
        ArrayList<Point2D<Double>> translatedPoints = new ArrayList<Point2D<Double>>(points.size());
        for (Point2D point2D : points) {
            translatedPoints.add(new Point2D<Double>(((Number)point2D.getX()).doubleValue() + x, ((Number)point2D.getY()).doubleValue() + y));
        }
        return translatedPoints;
    }
}

