/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.geometry;

import java.awt.geom.Point2D;

public class Point2D<T extends Number> {
    private final T x;
    private final T y;

    public Point2D(T x, T y) {
        this.x = x;
        this.y = y;
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public java.awt.geom.Point2D toJavaPoint2D() {
        return new Point2D.Double(((Number)this.x).doubleValue(), ((Number)this.y).doubleValue());
    }

    public static Point2D<Double> fromJavaPoint2D(java.awt.geom.Point2D p) {
        return new Point2D<Double>(p.getX(), p.getY());
    }

    public Double direction(Point2D<? extends Number> that) {
        double x1 = that.getX().doubleValue();
        double y1 = that.getY().doubleValue();
        double x0 = ((Number)this.getX()).doubleValue();
        double y0 = ((Number)this.getY()).doubleValue();
        return Math.atan2(y1 - y0, x1 - x0);
    }

    public Double distance(Point2D<? extends Number> that) {
        double x1 = that.getX().doubleValue();
        double y1 = that.getY().doubleValue();
        double x0 = ((Number)this.getX()).doubleValue();
        double y0 = ((Number)this.getY()).doubleValue();
        double dx = Math.pow(x1 - x0, 2.0);
        double dy = Math.pow(y1 - y0, 2.0);
        return Math.sqrt(dx + dy);
    }

    public String toString() {
        return this.getX() + "," + this.getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point2D point2D = (Point2D)o;
        if (this.x != null ? !this.x.equals(point2D.x) : point2D.x != null) {
            return false;
        }
        return !(this.y != null ? !this.y.equals(point2D.y) : point2D.y != null);
    }

    public int hashCode() {
        int result = this.x != null ? this.x.hashCode() : 0;
        result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }
}

