/*
 * Decompiled with CFR 0.152.
 */
package scilube.view3d.canadiangrid;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scilube.geometry.Point2D;
import scilube.geometry.Point2D$;
import scilube.view3d.canadiangrid.Camera;
import scilube.view3d.canadiangrid.Pixel$;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0013\t)\u0001+\u001b=fY*\u00111\u0001B\u0001\rG\u0006t\u0017\rZ5b]\u001e\u0014\u0018\u000e\u001a\u0006\u0003\u000b\u0019\taA^5foN\"'\"A\u0004\u0002\u000fM\u001c\u0017\u000e\\;cK\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001BC\u0002\u0013\u0005!#\u0001\u0004dC6,'/Y\u000b\u0002'A\u0011A#F\u0007\u0002\u0005%\u0011aC\u0001\u0002\u0007\u0007\u0006lWM]1\t\u0011a\u0001!\u0011!Q\u0001\nM\tqaY1nKJ\f\u0007\u0005\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\u00159\u0018\u000e\u001a;i+\u0005a\u0002CA\u0006\u001e\u0013\tqBBA\u0002J]RD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0007o&$G\u000f\u001b\u0011\t\u0011\t\u0002!Q1A\u0005\u0002m\ta\u0001[3jO\"$\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f!,\u0017n\u001a5uA!Aa\u0005\u0001BC\u0002\u0013\u00051$A\u0001y\u0011!A\u0003A!A!\u0002\u0013a\u0012A\u0001=!\u0011!Q\u0003A!b\u0001\n\u0003Y\u0012!A=\t\u00111\u0002!\u0011!Q\u0001\nq\t!!\u001f\u0011\t\u000b9\u0002A\u0011A\u0018\u0002\rqJg.\u001b;?)\u0019\u0001\u0014GM\u001a5kA\u0011A\u0003\u0001\u0005\u0006#5\u0002\ra\u0005\u0005\u000655\u0002\r\u0001\b\u0005\u0006E5\u0002\r\u0001\b\u0005\u0006M5\u0002\r\u0001\b\u0005\u0006U5\u0002\r\u0001\b\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0003\u0015\tG\u000e\u001d5b+\u0005I\u0004CA\u0006;\u0013\tYDB\u0001\u0004E_V\u0014G.\u001a\u0005\u0007{\u0001\u0001\u000b\u0011B\u001d\u0002\r\u0005d\u0007\u000f[1!\u0011\u001dy\u0004A1A\u0005\u0002a\nAAY3uC\"1\u0011\t\u0001Q\u0001\ne\nQAY3uC\u0002Bqa\u0011\u0001C\u0002\u0013\u0005\u0001(A\u0005y\t&\u001cH/\u00198dK\"1Q\t\u0001Q\u0001\ne\n!\u0002\u001f#jgR\fgnY3!\u0011\u001d9\u0005A1A\u0005\u0002a\n\u0011\"\u001f#jgR\fgnY3\t\r%\u0003\u0001\u0015!\u0003:\u0003)IH)[:uC:\u001cW\r\t\u0005\t\u0017\u0002A)\u0019!C\u0001\u0019\u0006)\u0001o\\5oiV\tQ\nE\u0002O#fj\u0011a\u0014\u0006\u0003!\u001a\t\u0001bZ3p[\u0016$(/_\u0005\u0003%>\u0013q\u0001U8j]R\u0014DiB\u0003U\u0005!\u0005Q+A\u0003QSb,G\u000e\u0005\u0002\u0015-\u001a)\u0011A\u0001E\u0001/N\u0011aK\u0003\u0005\u0006]Y#\t!\u0017\u000b\u0002+\")1L\u0016C\u00019\u0006a\u0011.\\1hK\u000e{'O\\3sgR!Q,\u001b6l!\rqf\r\r\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!A\u0019\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA3\r\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001a5\u0003\t1K7\u000f\u001e\u0006\u0003K2AQ!\u0005.A\u0002MAQA\u0007.A\u0002qAQA\t.A\u0002q\u0001")
public class Pixel {
    private Point2D<Object> point;
    private final Camera camera;
    private final int width;
    private final int height;
    private final int x;
    private final int y;
    private final double alpha;
    private final double beta;
    private final double xDistance;
    private final double yDistance;
    private volatile boolean bitmap$0;

    public static List<Pixel> imageCorners(Camera camera, int n, int n2) {
        return Pixel$.MODULE$.imageCorners(camera, n, n2);
    }

    public Camera camera() {
        return this.camera;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    public double xDistance() {
        return this.xDistance;
    }

    public double yDistance() {
        return this.yDistance;
    }

    private Point2D<Object> point$lzycompute() {
        Pixel pixel = this;
        synchronized (pixel) {
            if (!this.bitmap$0) {
                this.point = Point2D$.MODULE$.apply(this.xDistance(), this.yDistance());
                this.bitmap$0 = true;
            }
        }
        return this.point;
    }

    public Point2D<Object> point() {
        return !this.bitmap$0 ? this.point$lzycompute() : this.point;
    }

    public Pixel(Camera camera, int width, int height, int x, int y) {
        this.camera = camera;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        Predef$.MODULE$.require(x >= 0 && x < width, (Function0 & java.io.Serializable & Serializable)() -> "x must be between 0 and " + (this.width() - 1) + ". You supplied " + this.x());
        Predef$.MODULE$.require(y >= 0 && y < width, (Function0 & java.io.Serializable & Serializable)() -> "y must be between 0 and " + (this.height() - 1) + ". You supplied " + this.x());
        double bp = (double)height / 2.0;
        double ip = bp - (double)y;
        this.alpha = package$.MODULE$.atan(ip * package$.MODULE$.tan(camera.alpha() / 2.0) / bp);
        int gp = width / 2;
        int ip2 = gp - x;
        this.beta = package$.MODULE$.atan((double)ip2 * package$.MODULE$.tan(camera.beta() / 2.0) / (double)gp) * (double)-1;
        double oiDistance = camera.height() / package$.MODULE$.sin(camera.theta() - this.alpha());
        this.xDistance = oiDistance * package$.MODULE$.tan(this.beta());
        this.yDistance = camera.height() / package$.MODULE$.tan(camera.theta() - this.alpha());
    }
}

