/*
 * Decompiled with CFR 0.152.
 */
package scilube.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scilube.jdbc.DatabaseParams;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000f\tAA)\u0019;bE\u0006\u001cXM\u0003\u0002\u0004\t\u0005!!\u000e\u001a2d\u0015\u0005)\u0011aB:dS2,(-Z\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011\t\u0011)A\u0005!\u0005\u0019QO\u001d7\u0011\u0005EAbB\u0001\n\u0017!\t\u0019\"\"D\u0001\u0015\u0015\t)b!\u0001\u0004=e>|GOP\u0005\u0003/)\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011qC\u0003\u0005\t9\u0001\u0011\t\u0011)A\u0005!\u0005AQo]3s]\u0006lW\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0011\u0003!\u0001\u0018m]:x_J$\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0003#I\u00152\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\b \u0001\u0004\u0001\u0002\"\u0002\u000f \u0001\u0004\u0001\u0002\"\u0002\u0010 \u0001\u0004\u0001\u0002\"\u0002\u0011\u0001\t\u0003ACC\u0001\u0012*\u0011\u0015Qs\u00051\u0001,\u0003\u0019\u0001\u0018M]1ngB\u00111\u0005L\u0005\u0003[\t\u0011a\u0002R1uC\n\f7/\u001a)be\u0006l7\u000f\u0003\u00040\u0001\u0001\u0006I\u0001M\u0001\u0004Y><\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0014aA8sO&\u0011qG\r\u0002\u0007\u0019><w-\u001a:\t\u000be\u0002A\u0011\u0001\u001e\u0002\u0015\r|gN\\3di&|g.F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(A\u0002tc2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000b\u0011\u0003A\u0011A#\u0002\u001b%tGK]1og\u0006\u001cG/[8o+\t1E\n\u0006\u0002H+B\u0019\u0011\u0002\u0013&\n\u0005%S!AB(qi&|g\u000e\u0005\u0002L\u00192\u0001A!B'D\u0005\u0004q%!A!\u0012\u0005=\u0013\u0006CA\u0005Q\u0013\t\t&BA\u0004O_RD\u0017N\\4\u0011\u0005%\u0019\u0016B\u0001+\u000b\u0005\r\te.\u001f\u0005\u0006-\u000e\u0003\raV\u0001\u0005E>$\u0017\u0010\u0005\u0003\n1nR\u0015BA-\u000b\u0005%1UO\\2uS>t\u0017\u0007")
public class Database {
    private final String url;
    private final String username;
    private final String password;
    private final Logger log;

    public Connection connection() {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public <A> Option<A> inTransaction(Function1<Connection, A> body) {
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_3;
            Connection c = this.connection();
            c.setAutoCommit(false);
            Object a = body.apply((Object)c);
            c.commit();
            c.close();
            return var3_3;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object a = success.value();
            option = Option$.MODULE$.apply(a);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.log.info("Failed to execute transaction.", e);
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return option;
    }

    public Database(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public Database(DatabaseParams params) {
        this(params.url(), params.username(), params.password());
    }
}

