/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import org.mbari.vars.queryparsing.DataArray$;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.videolab.Functions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class UniqueAnnotationsApp$ {
    public static UniqueAnnotationsApp$ MODULE$;

    static {
        new UniqueAnnotationsApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program filters out rows with duplicate identity-references. Only\n        | the first occurence is retained.\n        |\n        | Usage:\n        |   java -cp java -cp ../lib/*.jar org.mbari.vars.queryparsing.videolab.UniqueAnnotationsApp [queryfile]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process\n        |\n        | Output:\n        |   The output is dumpted to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on the file\n        |     - Rows that represent the same organism/observation will be removed. Only\n        |       the first occurence will be retained.\n        |\n        | Example:\n        |   unique-annotations-app query.txt > query-without-duplicates.txt\n        ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        TextParser textParser = new TextParser(source);
        DataFrame frame = this.apply(textParser);
        Predef$.MODULE$.println((Object)frame.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(42).append("# ").append(Instant.now()).append(" - Duplicate identity-references removed").toString());
        Predef$.MODULE$.println((Object)frame.columns().mkString("\t"));
        frame.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.values()[r])).mkString("\t")));
    }

    public DataFrame apply(DataFrame frame) {
        Predef$.MODULE$.require(frame != null, (Function0 & Serializable & scala.Serializable)() -> "Whoops! We can't use a null DataFrame");
        Seq<String> idRefs = Functions$.MODULE$.toIdentityReferences(frame);
        Seq distinctRefs = (Seq)idRefs.distinct();
        IndexedSeq idx = (IndexedSeq)distinctRefs.indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> idRefs.indexOf(distinctRefs.apply(i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq uniqueRows = (IndexedSeq)idx.map((Function1 & Serializable & scala.Serializable)i -> UniqueAnnotationsApp$.$anonfun$apply$3(frame, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return DataArray$.MODULE$.apply(frame, (String[][])uniqueRows.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
    }

    public static final /* synthetic */ String[] $anonfun$apply$3(DataFrame frame$2, int i) {
        return frame$2.values()[i];
    }

    private UniqueAnnotationsApp$() {
        MODULE$ = this;
    }
}

