/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.Link;
import org.mbari.vars.queryparsing.Links$;
import org.mbari.vars.queryparsing.Measurement;
import org.mbari.vars.queryparsing.Measurement$;
import org.mbari.vars.queryparsing.TextParser;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class ExtractDistanceApp$ {
    public static ExtractDistanceApp$ MODULE$;

    static {
        new ExtractDistanceApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program calculates pixel distance from measurements.\n        |\n        | Usage:\n        |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.videolab.ExtractDistanceApp [queryfile]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process\n        |\n        | Output:\n        |   The output is dumpted to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on your data\n        |     - Additional columns of 'dX (pixels)', 'dY (pixels)', 'Distance (pixels)',\n        |       and Comments will be added\n        | Example:\n        |   extract-distances-app query.txt > query-with-measurements.txt\n        |\n      ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        TextParser textParser = new TextParser(source);
        Seq<Seq<Measurement>> measurements = this.apply(textParser);
        int n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)measurements.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("# ").append(Instant.now()).append(" - Converted measurements to pixel distances").toString());
        Predef$.MODULE$.print((Object)textParser.columns().mkString("\t"));
        IndexedSeq measColHeaders = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)i -> ExtractDistanceApp$.$anonfun$main$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)measColHeaders.mkString("\t"));
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            Predef$.MODULE$.print((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[r])).mkString("\t"));
            Seq ms = (Seq)measurements.apply(r);
            Seq dx = (Seq)ms.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.dx()), Seq$.MODULE$.canBuildFrom());
            Seq dy = (Seq)ms.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.dy()), Seq$.MODULE$.canBuildFrom());
            Seq d = (Seq)ms.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.distance()), Seq$.MODULE$.canBuildFrom());
            Seq cmt = (Seq)ms.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
            IndexedSeq measCol = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)i -> ExtractDistanceApp$.$anonfun$main$9(ms, dx, dy, d, cmt, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println((Object)measCol.mkString("\t"));
        });
    }

    public Seq<Seq<Measurement>> apply(DataFrame frame) {
        int associationColIdx = ((GenSeqLike)frame.columns().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"ASSOCIATIONS");
        return (Seq)frame.rows().indices().map((Function1 & Serializable & scala.Serializable)row -> ExtractDistanceApp$.$anonfun$apply$2(frame, associationColIdx, BoxesRunTime.unboxToInt((Object)row)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$main$2(int i) {
        return new StringBuilder(46).append("\tdX_pixels").append(i).append("'\tdY_pixels").append(i).append("\tDistance_pixels").append(i).append("\tComments").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$main$9(Seq ms$1, Seq dx$1, Seq dy$1, Seq d$1, Seq cmt$1, int i) {
        return ms$1.size() > i ? new StringBuilder(4).append("\t").append(dx$1.apply(i)).append("\t").append(dy$1.apply(i)).append("\t").append(d$1.apply(i)).append("\t").append(cmt$1.apply(i)).toString() : "\t\t\t\t";
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Link x$7) {
        String string = x$7.name();
        String string2 = Measurement$.MODULE$.MEASUREMENT_LINKNAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$apply$2(DataFrame frame$1, int associationColIdx$1, int row) {
        Nil$ nil$;
        try {
            Seq<Link> links = Links$.MODULE$.from(frame$1.apply(row, associationColIdx$1));
            nil$ = (Seq)((TraversableLike)links.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ExtractDistanceApp$.$anonfun$apply$3(x$7)))).map((Function1 & Serializable & scala.Serializable)link -> Measurement$.MODULE$.from((Link)link), Seq$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Nil$ nil$2 = Nil$.MODULE$;
            nil$ = nil$2;
        }
        return nil$;
    }

    private ExtractDistanceApp$() {
        MODULE$ = this;
    }
}

