/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import org.docopt.Docopt;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.Functions$;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vcr4j.time.Timecode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class AddRuntimeApp$ {
    public static AddRuntimeApp$ MODULE$;

    static {
        new AddRuntimeApp$();
    }

    public void main(String[] args) {
        String prog = this.getClass().getName();
        String doc = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(690).append("\n      |Parses  the tape timecode and converts it to elapsed time based on a starting timecode\n      |that you provide.\n      |\n      |Usage: ").append(prog).append(" <queryfile> <starttimecode> [options]\n      |\n      |Arguments:\n      |  <queryfile> The VARS query text file\n      |  <starttimecode> The starting timecode of a file as HH:MM:SS:FF\n      |\n      |Options:\n      |  -a, --alternate  Use AlternateTimecode column instead of TapeTimecode\n      |  -d, --drop  Drop rows that have negative runtimes (e.g. when working with subclips of tapes)\n      |  -f FRAME_RATE, --framerate FRAME_RATE  The framerate to use for runtime calculation. [default: 29.97]\n      |  -h, --help\n      |  -v, --version\n      ").toString())).stripMargin().trim();
        Map opts = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new Docopt(doc).withVersion(Functions$.MODULE$.VERSION()).parse(args)).asScala();
        String file = opts.apply((Object)"<queryfile>").toString();
        String start = opts.apply((Object)"<starttimecode>").toString();
        double framerate = new StringOps(Predef$.MODULE$.augmentString(opts.apply((Object)"--framerate").toString())).toDouble();
        boolean dropNegative = BoxesRunTime.unboxToBoolean((Object)opts.apply((Object)"--drop"));
        boolean useAlternateTimecode = BoxesRunTime.unboxToBoolean((Object)opts.apply((Object)"--alternate"));
        Timecode timecode = new Timecode(start, framerate);
        Predef$.MODULE$.require(timecode.isComplete(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append(timecode).append(" is not a valid timecode;the format should be hh:mm:ss:ff and the framerate (").append(framerate).append(") should be > 0").toString());
        File source = new File(file);
        DataFrame frame = Functions$.MODULE$.sortByColumn(new TextParser(source), "TapeTimeCode", Functions$.MODULE$.sortByColumn$default$3());
        Seq<Object> elapsedTimes = this.apply(frame, timecode, useAlternateTimecode);
        String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.column("VIDEOARCHIVENAME"))).distinct();
        String warning = names.length == 1 ? "" : new StringBuilder(112).append(" WARNING: ").append(names.length).append(" video-archives were found in this dataset; runtime calculations will only be correct for one of them.").toString();
        String dropMsg = dropNegative ? " Rows with negative runtimes have been dropped." : "";
        String altMsg = useAlternateTimecode ? " Using AlternateTimecode column instead of tapetimecode." : "";
        Predef$.MODULE$.println((Object)frame.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(111).append("# ").append(Instant.now()).append(" - RUNTIME_MINUTES column was added using start timecode of ").append(timecode).append(" with framerate of ").append(framerate).append(". Rows sorted by tapetimecode.").append(altMsg).append(dropMsg).append(warning).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(16).append(frame.columns().mkString("\t")).append("\t").append("RUNTIME_MINUTES").toString());
        frame.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            if (!dropNegative || !(BoxesRunTime.unboxToDouble((Object)elapsedTimes.apply(r)) < 0.0)) {
                Predef$.MODULE$.println((Object)new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.values()[r])).mkString("\t")).append("\t").append(elapsedTimes.apply(r)).toString());
            }
        });
    }

    public Seq<Object> apply(DataFrame frame, Timecode timecode, boolean useAlternateTimecode) {
        Timecode badTimecode = new Timecode("--:--:--:--");
        double startMinutes = timecode.getSeconds() / 60.0;
        String columnName = useAlternateTimecode ? "ALTERNATETIMECODE" : "TAPETIMECODE";
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.column(columnName))).map((Function1 & Serializable & scala.Serializable)s -> AddRuntimeApp$.toTimecode$1(s, timecode, badTimecode), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timecode.class))))).map((Function1 & Serializable & scala.Serializable)tc -> BoxesRunTime.boxToDouble((double)AddRuntimeApp$.calcElapsedMinutes$1(tc, startMinutes)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public boolean apply$default$3() {
        return false;
    }

    private static final Timecode toTimecode$1(String s, Timecode timecode$2, Timecode badTimecode$1) {
        return (Timecode)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Timecode(s, timecode$2.getFrameRate())).getOrElse((Function0 & Serializable & scala.Serializable)() -> badTimecode$1);
    }

    private static final double calcElapsedMinutes$1(Timecode tc, double startMinutes$1) {
        return tc.isComplete() ? tc.getSeconds() / 60.0 - startMinutes$1 : -999.0;
    }

    private AddRuntimeApp$() {
        MODULE$ = this;
    }
}

