/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.TimeZone;
import org.docopt.Docopt;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.Functions$;
import org.mbari.vars.queryparsing.TextParser;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class AddLocalTimeApp$ {
    public static AddLocalTimeApp$ MODULE$;

    static {
        new AddLocalTimeApp$();
    }

    public void main(String[] args) {
        String prog = this.getClass().getName();
        String doc = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(337).append("\n      |Parses the recordeDate and converts it to a different timezone\n      |\n      |Usage: ").append(prog).append(" <queryfile> [options]\n      |\n      |Arguments:\n      |  <queryfile> The VARS query text file\n      |\n      |Options:\n      |  -t TIME_ZONE, --timezone TIME_ZONE The timezone to use. Default [").append(ZoneId.systemDefault()).append("]\n      |  -h, --help\n      |  -v, --version\n      ").toString())).stripMargin().trim();
        Map opts = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new Docopt(doc).withVersion(Functions$.MODULE$.VERSION()).parse(args)).asScala();
        String file = opts.apply((Object)"<queryfile>").toString();
        Option timezoneName = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> opts.apply((Object)"--timezone").toString()).toOption();
        ZoneId timezone = this.parseZone((Option<String>)timezoneName);
        File source = new File(file);
        TextParser frame = new TextParser(source);
        Seq<String> localTimes = this.apply(frame, timezone);
        Predef$.MODULE$.println((Object)frame.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("# ").append(Instant.now()).append(" - Added LOCAL_RECORDEDDATE column using timezone of ").append(timezone).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append(frame.columns().mkString("\t")).append("\t").append("LOCAL_RECORDEDDATE").toString());
        frame.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> Predef$.MODULE$.println((Object)new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.values()[r])).mkString("\t")).append("\t").append(localTimes.apply(r)).toString()));
    }

    public Seq<String> apply(DataFrame frame, ZoneId timezone) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.column("RecordedDate"))).map((Function1 & Serializable & scala.Serializable)s -> AddLocalTimeApp$.toLocalTime$1(s, timezone), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public ZoneId parseZone(Option<String> tz) {
        return (ZoneId)tz.map((Function1 & Serializable & scala.Serializable)x$1 -> TimeZone.getTimeZone(x$1)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toZoneId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ZoneId.systemDefault());
    }

    private static final String toLocalTime$1(String s, ZoneId timezone$1) {
        return (String)Functions$.MODULE$.parseDate(s).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.atZone(timezone$1)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private AddLocalTimeApp$() {
        MODULE$ = this;
    }
}

