/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.videolab.AddImageSizeApp;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class AddImageSizeApp$ {
    public static AddImageSizeApp$ MODULE$;

    static {
        new AddImageSizeApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program reads the image sizes and adds them to the data file.\n        |\n        | Usage:\n        |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.AddImageSizeApp [queryfile]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process\n        |\n        | Output:\n        |   The output is dumped to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on your data\n        |     - Additional columns of \"ImageWidth\" and \"ImageHeight\" will be added with the image\n        |       size for that row. The cells will be empty if no image is found or if the image can\n        |       not be read.\n        |\n        | Example:\n        |   add-image-size-app query.txt > query-with-image-sizes.txt\n        |\n      ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        TextParser textParser = new TextParser(source);
        int imageColIdx = ((GenSeqLike)textParser.columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"IMAGE");
        AddImageSizeApp imageSizer = new AddImageSizeApp();
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("# ").append(Instant.now()).append(" - Added ImageWidth and ImageHeight columns").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(23).append(textParser.columns().mkString("\t")).append("\tImageWidth\tImageHeight").toString());
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            Predef$.MODULE$.print((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[r])).mkString("\t"));
            try {
                URL url = new URL(textParser.values()[r][imageColIdx]);
                Tuple2<Object, Object> tuple2 = imageSizer.org$mbari$vars$queryparsing$videolab$AddImageSizeApp$$getImageWidthAndHeight(url);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int width = tuple2._1$mcI$sp();
                int height = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
                Tuple2.mcII.sp sp3 = sp2;
                int width2 = sp3._1$mcI$sp();
                int height2 = sp3._2$mcI$sp();
                Predef$.MODULE$.println((Object)new StringBuilder(2).append("\t").append(width2).append("\t").append(height2).toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Predef$.MODULE$.println((Object)"\t\t");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        });
    }

    private AddImageSizeApp$() {
        MODULE$ = this;
    }
}

