/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.videolab;

import java.io.File;
import java.time.Instant;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.videolab.Functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.java8.JFunction1;

public final class AddIdentityRefKeyApp$ {
    public static AddIdentityRefKeyApp$ MODULE$;

    static {
        new AddIdentityRefKeyApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program adds an identityRefKey column that can be used to aggregate \n        | annotations representing the same observed concept. Identical keys\n        | indicate that those rows represent the same organism siting.\n        |\n        | Usage:\n        |  java -cp java -cp ../lib/*.jar org.mbari.vars.queryparsing.videolab.AddIdentityRefKeyApp [queryfile]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process\n        |\n        | Output:\n        |   The output is dumpted to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on the file\n        |     - A new column, IdentityRefKey, will be added.\n        |\n        | Example:\n        |    add-identity-key-ref-app query.txt > query-with-idrefkey.txt\n        ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        TextParser frame = new TextParser(source);
        Seq<String> idRefs = Functions$.MODULE$.toIdentityReferences(frame);
        Predef$.MODULE$.println((Object)frame.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("# ").append(Instant.now()).append(" - IdentityRefKey column was added").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append(frame.columns().mkString("\t")).append("\tIdentityRefKey").toString());
        frame.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)r -> Predef$.MODULE$.println((Object)new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame.values()[r])).mkString("\t")).append("\t").append(idRefs.apply(r)).toString()));
    }

    private AddIdentityRefKeyApp$() {
        MODULE$ = this;
    }
}

