/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.smith;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import org.mbari.vars.queryparsing.AreaMeasurement;
import org.mbari.vars.queryparsing.AreaMeasurement$;
import org.mbari.vars.queryparsing.Link;
import org.mbari.vars.queryparsing.Links$;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.smith.TrimAreaMeasurementFn;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scilube.geometry.Point2D;
import scilube.geometry.Point2D$;

public final class TrimAreaMeasurementsApp$ {
    public static TrimAreaMeasurementsApp$ MODULE$;

    static {
        new TrimAreaMeasurementsApp$();
    }

    private Option<Link> doTrim(Function1<AreaMeasurement, Option<AreaMeasurement>> trim, Link link) {
        Option option;
        String string = link.name();
        String string2 = AreaMeasurement$.MODULE$.AREA_MEASUREMENT_LINKNAME();
        if (string == null ? string2 != null : !string.equals(string2)) {
            option = Option$.MODULE$.apply((Object)link);
        } else {
            try {
                None$ none$;
                Option trimmedAM;
                AreaMeasurement areaMeasurement = AreaMeasurement$.MODULE$.from(link);
                Option option2 = trimmedAM = (Option)trim.apply((Object)areaMeasurement);
                if (None$.MODULE$.equals(option2)) {
                    none$ = None$.MODULE$;
                } else if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    AreaMeasurement am = (AreaMeasurement)some.value();
                    none$ = Option$.MODULE$.apply((Object)am.toLink());
                } else {
                    throw new MatchError((Object)option2);
                }
                option = none$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                if (option3.isEmpty()) {
                    throw throwable;
                }
                Option option4 = Option$.MODULE$.apply((Object)link);
                option = option4;
            }
        }
        return option;
    }

    private Seq<Point2D<Object>> calculateBoundaries(int width, int height, double top, double bottom) {
        int minX = 0;
        int maxX = width;
        int minY = (int)((double)height * top);
        int maxY = (int)((double)height * bottom);
        return new .colon.colon((Object)Point2D$.MODULE$.apply(minX, minY), (List)new .colon.colon((Object)Point2D$.MODULE$.apply(maxX, minY), (List)new .colon.colon((Object)Point2D$.MODULE$.apply(maxX, maxY), (List)new .colon.colon((Object)Point2D$.MODULE$.apply(minX, maxY), (List)Nil$.MODULE$))));
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 3) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | This program modifies area measurements in a VARS query results text file so that they fit\n          | within an upper and lower bounds provided by a user.\n          |\n          | Usage:\n          |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.smith.TrimAreaMeasurementsApp [queryfile] [top%] [bottom%]\n          |\n          | Inputs:\n          |   queryfile = The path to the VARS query results to process\n          |   top% = The top bounds of the image (value should be between 0 and 1)\n          |   bottom% = The bottom bounds of the images (value should be between 0 and 1)\n          |\n          | Output:\n          |   The output is dumped to the console. It should be exactly the same as the original file except\n          |   for the following:\n          |     - A comment line is added to inform you that this program has been run on your data\n          |     - Area Measurement associations will be trimmed to fit within the bounds you provided.\n          |      The bounds are calculated by reading the first image in the data set and calculating a box\n          |      that where the left and right edges are the image edges, the top and bottom are from\n          |      (image height in pixels) * top%, (image height in pixels) * bottom%.\n          |\n          | Example:\n          |    # Keep only areas that fit between 25% from the top and 15% from the bottom of the images\n          |    trim-area-measurement-app query.txt 0.25 0.85 > query-trimmed.txt\n        ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        double topPercent = new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble();
        double bottomPercent = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        Predef$.MODULE$.require(topPercent >= 0.0 && topPercent < bottomPercent, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("topPercent must be > 0 and < ").append(bottomPercent).toString());
        Predef$.MODULE$.require(bottomPercent <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "bottomPercent must be less than 1");
        TextParser textParser = new TextParser(source);
        List cols = (List)textParser.columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), List$.MODULE$.canBuildFrom());
        int associationColIdx = cols.indexOf((Object)"ASSOCIATIONS");
        int widthColIdx = cols.indexOf((Object)"IMAGEWIDTH");
        int heightColIdx = cols.indexOf((Object)"IMAGEHEIGHT");
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            int width = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(textParser.values()[r][widthColIdx])).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            int height = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(textParser.values()[r][heightColIdx])).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            TrimAreaMeasurementFn trim = width < 0 || height < 0 ? am -> None$.MODULE$ : new TrimAreaMeasurementFn((Iterable<Point2D<Object>>)MODULE$.calculateBoundaries(width, height, topPercent, bottomPercent));
            Seq<Link> links = Links$.MODULE$.from(textParser.values()[r][associationColIdx]);
            Seq trimmedLinks = (Seq)links.map((Function1 & Serializable & scala.Serializable)l -> MODULE$.doTrim(trim, (Link)l), Seq$.MODULE$.canBuildFrom());
            textParser$1.values()[r][associationColIdx$1] = Links$.MODULE$.asString((Iterable<Link>)((Iterable)trimmedLinks.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))), Links$.MODULE$.asString$default$2());
        });
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)textParser.columns().mkString("\t"));
        Predef$.MODULE$.println((Object)new StringBuilder(69).append("# ").append(Instant.now()).append(" - Trimmed area measurements using top and bottom bounds of ").append(topPercent).append("% and ").append(bottomPercent).append("%").toString());
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[r])).mkString("\t")));
    }

    private TrimAreaMeasurementsApp$() {
        MODULE$ = this;
    }
}

