/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.smith;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import javax.imageio.ImageIO;
import org.mbari.vars.queryparsing.Measurement;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.smith.CanadianGridMeasurementApp;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class CanadianGridMeasurementApp$ {
    public static CanadianGridMeasurementApp$ MODULE$;

    static {
        new CanadianGridMeasurementApp$();
    }

    public Option<Object> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 5) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | This program calculates actual distance from distance measurements using a canadian grid.\n          |\n          | Usage:\n          |   canadian-grid-measurement-app [cameraHeight] [alpha] [beta] [theta] [queryfile]\n          |\n          | Inputs:\n          |   cameraHeight = The height of the camera above the bottom. The areas units will be the cameraHeights squared\n          |   alpha = The vertical view angle of the camera in degrees\n          |   beta  = The horizontal view angle of the camera in degrees\n          |   theta = The tilt of the camera in degrees (0 degree is parallel to the plane, 90 is pointed\n          |           directly at plane)\n          |   queryfile = The path to the VARS query results to process. It should have ImageWidth and ImageHeight columns\n          |\n          | Output:\n          |   The output is dumped to the console. Only rows with distance measurements will be printed\n          |   from the original file. In addition, these changes will be made:\n          |     - A comment line is added to inform you that this program has been run on your data\n          |     - Additional columns of \"MeasurementAssociation\" and \"Measurement\" will be added.\n          |       MeasurementAssociation is the association used to calculate the distance measurement.\n          |       Measurement is the distance for that association. If there are multiple measurements\n          |       in the source file, then each measurement will be in a new row in the output.\n          |\n          | Example:\n          |   canadian-grid-measurement-app 105 15 20 45 query.txt > query-with-measurements.txt\n          |\n      ")).stripMargin());
            return;
        }
        double cameraHeight = new StringOps(Predef$.MODULE$.augmentString(args[0])).toDouble();
        double alpha = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble());
        double beta = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
        double theta = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble());
        File source = new File(args[4]);
        TextParser textParser = new TextParser(source);
        List cols = (List)textParser.columns().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(), List$.MODULE$.canBuildFrom());
        int associationColIdx = cols.indexOf((Object)"ASSOCIATIONS");
        int imageColIdx = cols.indexOf((Object)"IMAGE");
        int imageWidthColIdx = cols.indexOf((Object)"IMAGEWIDTH");
        int imageHeightColIdx = cols.indexOf((Object)"IMAGEHEIGHT");
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.column(imageColIdx))).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CanadianGridMeasurementApp$.$anonfun$main$2(x$3))).map((Function1 & Serializable & scala.Serializable)img -> MODULE$.imageDimensions(new URL((String)img))).map((Function1 & Serializable & scala.Serializable)d -> new Tuple2((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)d._1$mcI$sp())), (Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)d._2$mcI$sp())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option imageWidth = (Option)tuple2._1();
        Option imageHeight = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)imageWidth, (Object)imageHeight);
        Tuple2 tuple23 = tuple22;
        Option imageWidth2 = (Option)tuple23._1();
        Option imageHeight2 = (Option)tuple23._2();
        CanadianGridMeasurementApp app = new CanadianGridMeasurementApp(cameraHeight, alpha, beta, theta, (Option<Object>)imageWidth2, (Option<Object>)imageHeight2);
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(83).append("# ").append(Instant.now()).append(" - Converted measurements to distances using cameraHeight=").append(cameraHeight).append(", alpha=").append(alpha).append(", beta=").append(beta).append(", theta=").append(theta).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(35).append(textParser.columns().mkString("\t")).append("\tMeasurementAssociation\tMeasurement").toString());
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            Seq<Tuple2<Measurement, Object>> measurements = app.toMeasurements(textParser, r, associationColIdx, imageWidthColIdx, imageHeightColIdx);
            String rowString = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[r])).mkString("\t");
            measurements.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CanadianGridMeasurementApp$.$anonfun$main$7(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                CanadianGridMeasurementApp$.$anonfun$main$8(textParser, r, x$5);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Tuple2<Object, Object> imageDimensions(URL image) {
        BufferedImage img = ImageIO.read(image);
        return new Tuple2.mcII.sp(img.getWidth(), img.getHeight());
    }

    public static final /* synthetic */ boolean $anonfun$main$2(String x$3) {
        return x$3.toLowerCase().startsWith("http");
    }

    public static final /* synthetic */ boolean $anonfun$main$7(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$main$8(TextParser textParser$2, int r$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Measurement m = (Measurement)tuple2._1();
        double d = tuple2._2$mcD$sp();
        Predef$.MODULE$.println((Object)new StringBuilder(0).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser$2.values()[r$1])).mkString("\t")).append(new StringBuilder(2).append("\t").append(m.toLink()).append("\t").append(d).toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CanadianGridMeasurementApp$() {
        MODULE$ = this;
    }
}

