/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.smith;

import java.io.File;
import java.time.Instant;
import org.mbari.vars.queryparsing.TextParser;
import org.mbari.vars.queryparsing.smith.CalculateActualAreasApp;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.java8.JFunction1;

public final class CalculateActualAreasApp$ {
    public static CalculateActualAreasApp$ MODULE$;

    static {
        new CalculateActualAreasApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 5) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program calculates area from area measurements using a canadian grid.\n        |\n        | Usage:\n        |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.CalculateActualAreasApp [cameraHeight] [alpha] [beta] [theta] [queryfile]\n        |\n        | Inputs:\n        |   cameraHeight = The height of the camera above the bottom. The areas units will be the cameraHeights squared\n        |   alpha = The vertical view angle of the camera in degrees\n        |   beta  = The horizontal view angle of the camera in degrees\n        |   theta = The tilt of the camera in degrees (0 degree is parallel to the plane, 90 is pointed\n        |           directly at plane)\n        |   queryfile = The path to the VARS query results to process. It should have ImageWidth and ImageHeight columns\n        |\n        | Output:\n        |   The output is dumpted to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on your data\n        |     - An additional column \"Areas\" will be added with the calculated area values. If an\n        |       observation has more than one area measurement association then this column will contain\n        |       a comma seperated string of values, one for each area measurement\n        |\n        | Example:\n        |   calculate-actual-areas-app 105 15 20 45 query.txt > query-with-areas.txt\n        |\n      ")).stripMargin());
            return;
        }
        double cameraHeight = new StringOps(Predef$.MODULE$.augmentString(args[0])).toDouble();
        double alpha = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble());
        double beta = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
        double theta = package$.MODULE$.toRadians(new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble());
        File source = new File(args[4]);
        CalculateActualAreasApp app = new CalculateActualAreasApp(cameraHeight, alpha, beta, theta);
        TextParser textParser = new TextParser(source);
        List cols = (List)textParser.columns().map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.toUpperCase(), List$.MODULE$.canBuildFrom());
        int associationColIdx = cols.indexOf((Object)"ASSOCIATIONS");
        int imageColIdx = cols.indexOf((Object)"IMAGE");
        int imageWidthColIdx = cols.indexOf((Object)"IMAGEWIDTH");
        int imageHeightColIdx = cols.indexOf((Object)"IMAGEHEIGHT");
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(84).append("# ").append(Instant.now()).append(" - Converted area measurements to areas using cameraHeight=").append(cameraHeight).append(", alpha=").append(alpha).append(", beta=").append(beta).append(", theta=").append(theta).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(6).append(textParser.columns().mkString("\t")).append("\tAreas").toString());
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)r -> {
            String area = app.toAreaString(textParser, r, imageColIdx, associationColIdx, imageWidthColIdx, imageHeightColIdx);
            Predef$.MODULE$.println((Object)new StringBuilder(0).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[r])).mkString("\t")).append(new StringBuilder(1).append("\t").append(area).toString()).toString());
        });
    }

    private CalculateActualAreasApp$() {
        MODULE$ = this;
    }
}

