/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.hurl;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import org.mbari.vars.queryparsing.Associations$;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.Functions$;
import org.mbari.vars.queryparsing.Link;
import org.mbari.vars.queryparsing.Links$;
import org.mbari.vars.queryparsing.TextParser;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class OrganizeSubstratesApp$ {
    public static OrganizeSubstratesApp$ MODULE$;

    static {
        new OrganizeSubstratesApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program extracts habiatat descriptions of the upon, habitat, primary (s1) and\n        | secondary (s2) substrate associations into distinct columns.\n        |\n        | Usage:\n        |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.hurl.OrganizeSubstratesApp [queryfile]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process\n        |\n        | Output:\n        |   The output is dumpted to the console. It will be exactly the same as the original file except\n        |   for the following:\n        |     - A comment line is added to inform you that this program has been run on your data\n        |     - Additional columns of 'S1' and 'S2' will be added\n        | Example:\n        |   organize-substrates-app query.txt > query-with-substrates.txt\n        |\n      ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        DataFrame textParser = Functions$.MODULE$.sortByRecordedDate(new TextParser(source));
        Seq<String> s1 = this.parseS1(textParser);
        Seq<String> s2 = this.parseS2(textParser);
        Seq<String> upon = this.parseUpon(textParser);
        Seq<String> habitat = this.parseHabitat(textParser);
        Seq<String> megahabitat = this.parseMegahabitat(textParser);
        Predef$.MODULE$.println((Object)textParser.header().mkString("\n"));
        Predef$.MODULE$.println((Object)new StringBuilder(54).append("# ").append(Instant.now()).append(" - Organized upon, s1 and s2 substrates into columns").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(31).append(textParser.columns().mkString("\t")).append("\tS1\tS2\tUPON\tHABITAT\tMEGAHABITAT").toString());
        textParser.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)row -> Predef$.MODULE$.println((Object)new StringBuilder(0).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])textParser.values()[row])).mkString("\t")).append(new StringBuilder(5).append("\t").append(s1.apply(row)).append("\t").append(s2.apply(row)).append("\t").append(upon.apply(row)).append("\t").append(habitat.apply(row)).append("\t").append(megahabitat.apply(row)).toString()).toString()));
    }

    public Seq<Seq<String>> parseToConcepts(DataFrame frame, String linkName) {
        int associationColIdx = ((GenSeqLike)frame.columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"ASSOCIATIONS");
        return (Seq)frame.rows().indices().map((Function1 & Serializable & scala.Serializable)row -> OrganizeSubstratesApp$.$anonfun$parseToConcepts$2(frame, associationColIdx, linkName, BoxesRunTime.unboxToInt((Object)row)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Seq<String> parseS1(DataFrame frame) {
        return (Seq)this.parseToConcepts(frame, Associations$.MODULE$.HURL_S1()).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.head(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> parseS2(DataFrame frame) {
        return (Seq)this.parseToConcepts(frame, Associations$.MODULE$.HURL_S2()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mkString(","), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> parseUpon(DataFrame frame) {
        return (Seq)this.parseToConcepts(frame, Associations$.MODULE$.UPON()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.mkString(","), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> parseHabitat(DataFrame frame) {
        return (Seq)this.parseToConcepts(frame, Associations$.MODULE$.HURL_HABITAT()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.mkString(","), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> parseMegahabitat(DataFrame frame) {
        Seq<Seq<String>> mh = this.parseToConcepts(frame, Associations$.MODULE$.HURL_MEGAHABITAT());
        Seq<String> diveIds = Functions$.MODULE$.extractDiveID(frame);
        LinkedHashMap lastMhSet = new LinkedHashMap();
        return (Seq)mh.indices().map((Function1 & Serializable & scala.Serializable)row -> OrganizeSubstratesApp$.$anonfun$parseMegahabitat$1(mh, diveIds, lastMhSet, BoxesRunTime.unboxToInt((Object)row)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$parseToConcepts$3(String linkName$1, Link x$2) {
        String string = x$2.name();
        String string2 = linkName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$parseToConcepts$2(DataFrame frame$1, int associationColIdx$1, String linkName$1, int row) {
        Seq seq;
        block4: {
            try {
                Seq links = (Seq)Links$.MODULE$.from(frame$1.apply(row, associationColIdx$1)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OrganizeSubstratesApp$.$anonfun$parseToConcepts$3(linkName$1, x$2)));
                if (links.isEmpty()) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
                    break block4;
                }
                seq = (Seq)links.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toConcept(), Seq$.MODULE$.canBuildFrom());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
                seq = seq2;
            }
        }
        return seq;
    }

    public static final /* synthetic */ String $anonfun$parseMegahabitat$1(Seq mh$1, Seq diveIds$1, LinkedHashMap lastMhSet$1, int row) {
        String dive;
        block0: {
            String m = (String)((IterableLike)mh$1.apply(row)).head();
            dive = (String)diveIds$1.apply(row);
            if (m.isEmpty()) break block0;
            lastMhSet$1.update((Object)dive, (Object)m);
        }
        return (String)lastMhSet$1.getOrElse((Object)dive, (Function0 & Serializable & scala.Serializable)() -> "");
    }

    private OrganizeSubstratesApp$() {
        MODULE$ = this;
    }
}

