/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.queryparsing.hurl;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.mbari.vars.queryparsing.DataFrame;
import org.mbari.vars.queryparsing.TextParser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeqLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FetchPngsApp$ {
    public static FetchPngsApp$ MODULE$;

    static {
        new FetchPngsApp$();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 2) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n        | This program fetchs the uncompressed PNG images from VARS and saves them to the\n        | directory that you specify.\n        |\n        | Usage:\n        |   java -cp ../lib/*.jar org.mbari.vars.queryparsing.hurl.FetchPngsApp [queryfile] [targetDir]\n        |\n        | Inputs:\n        |   queryfile = The path to the VARS query results to process. The queryFile must have the\n        |       following columns (case-insensitive) : IMAGES, ROVNAME, DIVENUMBER\n        |   targetDir = The directory to save the PNG's into. The PNG files will be names following\n        |       this convention: [ROVNAME]_[DIVENUMBER]_[PNGNAME].png\n        |\n        | Output:\n        |   The JPG URL's in the query file will be converted to the corresponding PNG. The\n        |   pngs will be dowloaded and saved into the directory that you have provided.\n        |\n        | Example:\n        |   fetch-pngs-app query.txt pngdirectory\n        |\n      ")).stripMargin());
            return;
        }
        File source = new File(args[0]);
        File targetDir = new File(args[1]);
        TextParser frame = new TextParser(source);
        Seq<Option<URL>> pngUrls = this.extractPngURLs(frame);
        Seq<Option<File>> pngFiles = this.urlToPath(targetDir, frame, pngUrls);
        frame.rows().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> ((Option)pngUrls.apply(r)).foreach((Function1 & Serializable & scala.Serializable)url -> {
            FetchPngsApp$.$anonfun$main$2(pngFiles, r, url);
            return BoxedUnit.UNIT;
        }));
    }

    public Seq<Option<URL>> extractPngURLs(DataFrame frame) {
        int imageColIdx = ((GenSeqLike)frame.columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"IMAGE");
        String[] jpgs = frame.column(imageColIdx);
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jpgs)).indices().map((Function1 & Serializable & scala.Serializable)r -> FetchPngsApp$.$anonfun$extractPngURLs$2(jpgs, BoxesRunTime.unboxToInt((Object)r)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Seq<Option<File>> urlToPath(File baseDir, DataFrame frame, Seq<Option<URL>> pngUrls) {
        int rovColIdx = ((GenSeqLike)frame.columns().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"ROVNAME");
        int diveColIdx = ((GenSeqLike)frame.columns().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toUpperCase(), List$.MODULE$.canBuildFrom())).indexOf((Object)"DIVENUMBER");
        Predef$.MODULE$.require(rovColIdx > -1, (Function0 & Serializable & scala.Serializable)() -> "There was no ROVNAME column in the query file. Rerun the query to return the ROVNAME");
        Predef$.MODULE$.require(diveColIdx > -1, (Function0 & Serializable & scala.Serializable)() -> "There was no DIVENUMBER column in the query file. Rerun the query to return the DIVENUMBER");
        return (Seq)pngUrls.indices().map((Function1 & Serializable & scala.Serializable)r -> FetchPngsApp$.$anonfun$urlToPath$5(pngUrls, frame, rovColIdx, diveColIdx, baseDir, BoxesRunTime.unboxToInt((Object)r)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public void save(URL url, File target) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.print((Object)new StringBuilder(12).append("Copying ").append(url).append(" to ").append(target).toString());
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InputStream in = url.openStream();
            File parent = target.getParentFile();
            Object object = !parent.exists() ? BoxesRunTime.boxToBoolean((boolean)target.mkdirs()) : BoxedUnit.UNIT;
            Files.copy(in, target.toPath(), new CopyOption[0]);
            in.close();
        });
        if (try_ instanceof Success) {
            Predef$.MODULE$.print((Object)" ... DONE\n");
            boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Predef$.MODULE$.println((Object)new StringBuilder(13).append(" ... FAILED: ").append(e).toString());
            boxedUnit = target.exists() ? BoxesRunTime.boxToBoolean((boolean)target.delete()) : BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        BoxedUnit foo = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$main$2(Seq pngFiles$1, int r$1, URL url) {
        ((Option)pngFiles$1.apply(r$1)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            FetchPngsApp$.MODULE$.save(url, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Option $anonfun$extractPngURLs$2(String[] jpgs$1, int r) {
        None$ none$;
        String jpg = jpgs$1[r];
        String lowerJpg = jpg.toLowerCase();
        if (lowerJpg.startsWith("http") && lowerJpg.endsWith(".jpg")) {
            String png = jpg.replace(".jpg", ".png");
            none$ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URL(png)).toOption();
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ Option $anonfun$urlToPath$5(Seq pngUrls$2, DataFrame frame$1, int rovColIdx$1, int diveColIdx$1, File baseDir$1, int r) {
        None$ none$;
        Option url = (Option)pngUrls$2.apply(r);
        Option option = url;
        if (option instanceof Some) {
            Some some = (Some)option;
            URL u = (URL)some.value();
            String pngBasename = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])u.toExternalForm().replace("%20", " ").split("/"))).last();
            String pngName = new StringBuilder(2).append(frame$1.apply(r, rovColIdx$1)).append("_").append(frame$1.apply(r, diveColIdx$1)).append("_").append(pngBasename).toString();
            none$ = Option$.MODULE$.apply((Object)new File(baseDir$1, pngName));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private FetchPngsApp$() {
        MODULE$ = this;
    }
}

