CREATE TABLE VideoArchiveSet (id BIGINT NOT NULL, EndDTG TIMESTAMP, FormatCode CHAR(2), PlatformName VARCHAR(32) NOT NULL, ShipName VARCHAR(32), StartDTG TIMESTAMP, TrackingNumber VARCHAR(7), LAST_UPDATED_TIME TIMESTAMP, PRIMARY KEY (id));;
CREATE INDEX idx_VideoArchiveSet_LUT ON VideoArchiveSet (LAST_UPDATED_TIME);;
CREATE TABLE CameraPlatformDeployment (id BIGINT NOT NULL, ChiefScientist VARCHAR(50), UsageEndDTG TIMESTAMP, SeqNumber INTEGER, UsageStartDTG TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP, VideoArchiveSetID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_CameraDeployment_FK1 ON CameraPlatformDeployment (VideoArchiveSetID_FK);;
CREATE INDEX idx_CameraDeployment_LUT ON CameraPlatformDeployment (LAST_UPDATED_TIME);;
CREATE TABLE VideoArchive (id BIGINT NOT NULL, VideoArchiveName VARCHAR(512) NOT NULL UNIQUE, StartTimeCode VARCHAR(11), LAST_UPDATED_TIME TIMESTAMP, VideoArchiveSetID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_VideoArchive_FK1 ON VideoArchive (VideoArchiveSetID_FK);;
CREATE INDEX idx_VideoArchive_name ON VideoArchive (VideoArchiveName);;
CREATE INDEX idx_VideoArchive_LUT ON VideoArchive (LAST_UPDATED_TIME);;
CREATE TABLE VideoFrame (id BIGINT NOT NULL, HDTimeCode VARCHAR(11) NOT NULL, inSequence SMALLINT, RecordedDTG TIMESTAMP, TapeTimeCode VARCHAR(11) NOT NULL, LAST_UPDATED_TIME TIMESTAMP, VideoArchiveID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_VideoFrame_FK1 ON VideoFrame (VideoArchiveID_FK);;
CREATE INDEX idx_VideoFrame_LUT ON VideoFrame (LAST_UPDATED_TIME);;
CREATE TABLE PhysicalData (id BIGINT NOT NULL, ALTITUDE FLOAT, DEPTH FLOAT, LATITUDE FLOAT, LIGHT FLOAT, LogDTG TIMESTAMP, LONGITUDE FLOAT, OXYGEN FLOAT, SALINITY FLOAT, TEMPERATURE FLOAT, LAST_UPDATED_TIME TIMESTAMP, VideoFrameID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_PhysicalData_FK1 ON PhysicalData (ObservationID_FK);;
CREATE INDEX idx_PhysicalData_LUT ON PhysicalData (LAST_UPDATED_TIME);;
CREATE TABLE CameraData (id BIGINT NOT NULL, Direction VARCHAR(50), FIELDWIDTH FLOAT, FOCUS INTEGER, HEADING FLOAT, StillImageUrl VARCHAR(1024), IRIS INTEGER, LogDTG TIMESTAMP, Name VARCHAR(50), PITCH FLOAT, ROLL FLOAT, LAST_UPDATED_TIME TIMESTAMP, VIEWHEIGHT FLOAT, VIEWUNITS VARCHAR(255), VIEWWIDTH FLOAT, X FLOAT, XYUNITS VARCHAR(255), Y FLOAT, Z FLOAT, ZUNITS VARCHAR(255), ZOOM INTEGER, VideoFrameID_FK BIGINT NOT NULL, PRIMARY KEY (id));;
CREATE INDEX idx_CameraData_FK1 ON CameraData (ObservationID_FK);;
CREATE INDEX idx_CameraData_LUT ON CameraData (LAST_UPDATED_TIME);;
CREATE TABLE Observation (id BIGINT NOT NULL, ConceptName VARCHAR(50) NOT NULL, Notes VARCHAR(200), ObservationDTG TIMESTAMP, Observer VARCHAR(50), LAST_UPDATED_TIME TIMESTAMP, X FLOAT, Y FLOAT, VideoFrameID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_Observation_FK1 ON Observation (VideoFrameID_FK);;
CREATE INDEX idx_Observation_concept ON Observation (ConceptName);;
CREATE INDEX idx_Observation_LUT ON Observation (LAST_UPDATED_TIME);;
CREATE TABLE Association (id BIGINT NOT NULL, LinkName VARCHAR(128) NOT NULL, LinkValue VARCHAR(1024) NOT NULL, ToConcept VARCHAR(128) NOT NULL, LAST_UPDATED_TIME TIMESTAMP, ObservationID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_Association_FK1 ON Association (ObservationID_FK);;
CREATE INDEX idx_Association_LUT ON Association (LAST_UPDATED_TIME);;
CREATE TABLE Artifact (id BIGINT NOT NULL, ArtifactId VARCHAR(256) NOT NULL, Caption VARCHAR(1024), Classifier VARCHAR(64), Credit VARCHAR(1024), CreationDate TIMESTAMP, Description VARCHAR(2048), GroupId VARCHAR(64) NOT NULL, MimeType VARCHAR(32), Reference VARCHAR(1024) NOT NULL, LAST_UPDATED_TIME TIMESTAMP, Version VARCHAR(64) NOT NULL, ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE TABLE Concept (id BIGINT NOT NULL, NodcCode VARCHAR(20), Originator VARCHAR(255), RankLevel VARCHAR(20), RankName VARCHAR(20), Reference VARCHAR(1024), StructureType VARCHAR(10), TaxonomyType VARCHAR(20), LAST_UPDATED_TIME TIMESTAMP, ParentConceptID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_Concept_FK1 ON Concept (ParentConceptID_FK);;
CREATE INDEX idx_Concept_LUT ON Concept (LAST_UPDATED_TIME);;
CREATE TABLE ConceptDelegate (id BIGINT NOT NULL, LAST_UPDATED_TIME TIMESTAMP, ConceptID_FK BIGINT NOT NULL, PRIMARY KEY (id));;
CREATE INDEX idx_ConceptDelegate_FK1 ON ConceptDelegate (ConceptID_FK);;
CREATE INDEX idx_ConceptDelegate_LUT ON ConceptDelegate (LAST_UPDATED_TIME);;
CREATE TABLE ConceptName (id BIGINT NOT NULL, Author VARCHAR(255), ConceptName VARCHAR(128) NOT NULL UNIQUE, NameType VARCHAR(10) NOT NULL, LAST_UPDATED_TIME TIMESTAMP, ConceptID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_ConceptName_name ON ConceptName (ConceptName);;
CREATE INDEX idx_ConceptName_FK1 ON ConceptName (ConceptID_FK);;
CREATE INDEX idx_ConceptName_LUT ON ConceptName (LAST_UPDATED_TIME);;
CREATE TABLE History (id BIGINT NOT NULL, Action VARCHAR(16), Approved SMALLINT, Comment VARCHAR(2048), CreationDTG TIMESTAMP NOT NULL, CreatorName VARCHAR(50) NOT NULL, Field VARCHAR(2048), NewValue VARCHAR(2048), OldValue VARCHAR(2048), ProcessedDTG TIMESTAMP, ProcessorName VARCHAR(50), LAST_UPDATED_TIME TIMESTAMP, ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_History_FK1 ON History (ConceptDelegateID_FK);;
CREATE INDEX idx_History_LUT ON History (LAST_UPDATED_TIME);;
CREATE TABLE LinkRealization (id BIGINT NOT NULL, LinkName VARCHAR(50), LinkValue VARCHAR(2048), ToConcept VARCHAR(128), LAST_UPDATED_TIME TIMESTAMP, ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_LinkRealization_FK1 ON LinkRealization (ConceptDelegateID_FK);;
CREATE INDEX idx_LinkRealization_LUT ON LinkRealization (LAST_UPDATED_TIME);;
CREATE TABLE LinkTemplate (id BIGINT NOT NULL, LinkName VARCHAR(50), LinkValue VARCHAR(2048), ToConcept VARCHAR(128), LAST_UPDATED_TIME TIMESTAMP, ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_LinkTemplate_FK1 ON LinkTemplate (ConceptDelegateID_FK);;
CREATE INDEX idx_LinkTemplate_LUT ON LinkTemplate (LAST_UPDATED_TIME);;
CREATE TABLE Media (id BIGINT NOT NULL, Caption VARCHAR(1000), Credit VARCHAR(255), PrimaryMedia SMALLINT DEFAULT 0, MediaType VARCHAR(5), LAST_UPDATED_TIME TIMESTAMP, Url VARCHAR(1024), ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE INDEX idx_Media_FK1 ON Media (ConceptDelegateID_FK);;
CREATE INDEX idx_Media_LUT ON Media (LAST_UPDATED_TIME);;
CREATE TABLE Usage (id BIGINT NOT NULL, EmbargoExpirationDate TIMESTAMP, Specification VARCHAR(1000), LAST_UPDATED_TIME TIMESTAMP, ConceptDelegateID_FK BIGINT, PRIMARY KEY (id));;
CREATE TABLE UserAccount (id BIGINT NOT NULL, Affiliation VARCHAR(512), Email VARCHAR(50), FirstName VARCHAR(50), LastName VARCHAR(50), Password VARCHAR(50) NOT NULL, Role VARCHAR(10) NOT NULL, LAST_UPDATED_TIME TIMESTAMP, UserName VARCHAR(50) NOT NULL UNIQUE, PRIMARY KEY (id));;
CREATE TABLE Prefs (NodeName VARCHAR(1024) NOT NULL, PrefKey VARCHAR(256) NOT NULL, PrefValue VARCHAR(256) NOT NULL, PRIMARY KEY (NodeName, PrefKey));;
ALTER TABLE CameraPlatformDeployment ADD CONSTRAINT CmrPltfVdrchvStDFK FOREIGN KEY (VideoArchiveSetID_FK) REFERENCES VideoArchiveSet (id);;
ALTER TABLE VideoArchive ADD CONSTRAINT VdrchvVdrchvStIDFK FOREIGN KEY (VideoArchiveSetID_FK) REFERENCES VideoArchiveSet (id);;
ALTER TABLE VideoFrame ADD CONSTRAINT VdFrmeVdrchiveIDFK FOREIGN KEY (VideoArchiveID_FK) REFERENCES VideoArchive (id);;
ALTER TABLE PhysicalData ADD CONSTRAINT PhysclDtaVdFrmIDFK FOREIGN KEY (VideoFrameID_FK) REFERENCES VideoFrame (id);;
ALTER TABLE CameraData ADD CONSTRAINT CmrDataVdFrameIDFK FOREIGN KEY (VideoFrameID_FK) REFERENCES VideoFrame (id);;
ALTER TABLE Observation ADD CONSTRAINT bsrvtionVdFrmeIDFK FOREIGN KEY (VideoFrameID_FK) REFERENCES VideoFrame (id);;
ALTER TABLE Association ADD CONSTRAINT ssctonbsrvtionIDFK FOREIGN KEY (ObservationID_FK) REFERENCES Observation (id);;
ALTER TABLE Artifact ADD CONSTRAINT rtfctCncptDlgtIDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
ALTER TABLE Concept ADD CONSTRAINT CncptPrntCncptIDFK FOREIGN KEY (ParentConceptID_FK) REFERENCES Concept (id);;
ALTER TABLE ConceptDelegate ADD CONSTRAINT CncptDlgteCncptDFK FOREIGN KEY (ConceptID_FK) REFERENCES Concept (id);;
ALTER TABLE ConceptName ADD CONSTRAINT CncptNameCncptIDFK FOREIGN KEY (ConceptID_FK) REFERENCES Concept (id);;
ALTER TABLE History ADD CONSTRAINT HstryCncptDlgtIDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
ALTER TABLE LinkRealization ADD CONSTRAINT LnkRlzCncptDlgtDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
ALTER TABLE LinkTemplate ADD CONSTRAINT LnkTmpCncptDlgtDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
ALTER TABLE Media ADD CONSTRAINT MdCncptDlegateIDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
ALTER TABLE Usage ADD CONSTRAINT sgCncptDlegateIDFK FOREIGN KEY (ConceptDelegateID_FK) REFERENCES ConceptDelegate (id);;
CREATE TABLE UniqueID (TableName VARCHAR(50) NOT NULL, NextID DECIMAL(15), PRIMARY KEY (TableName));;
INSERT INTO UniqueID(TableName, NextID) values ('Observation', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('LinkRealization', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('ConceptDelegate', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('History', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('Concept', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('CameraData', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('ConceptName', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('VideoFrame', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('CameraPlatformDeployment', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('LinkTemplate', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('VideoArchive', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('UserName', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('Usage', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('Artifact', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('Association', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('PhysicalData', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('VideoArchiveSet', 0);;
INSERT INTO UniqueID(TableName, NextID) values ('Media', 0);;
