--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: association; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE association (
    id bigint NOT NULL,
    observationid_fk bigint,
    linkname character varying(128),
    toconcept character varying(50),
    linkvalue character varying(1024),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.association OWNER TO varsuser;

--
-- Name: cameradata; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE cameradata (
    id bigint NOT NULL,
    videoframeid_fk bigint,
    name character varying(50),
    direction character varying(50),
    zoom integer,
    focus integer,
    iris integer,
    fieldwidth double precision,
    stillimageurl character varying(1024),
    logdtg timestamp without time zone,
    last_updated_time timestamp without time zone,
    x double precision,
    y double precision,
    z double precision,
    pitch double precision,
    roll double precision,
    xyunits character varying(50),
    zunits character varying(50),
    heading double precision,
    viewheight double precision,
    viewwidth double precision,
    viewunits character varying(50)
);


ALTER TABLE public.cameradata OWNER TO varsuser;

--
-- Name: cameraplatformdeployment; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE cameraplatformdeployment (
    id bigint NOT NULL,
    videoarchivesetid_fk bigint,
    seqnumber integer,
    chiefscientist character varying(50),
    usagestartdtg timestamp without time zone,
    usageenddtg timestamp without time zone,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.cameraplatformdeployment OWNER TO varsuser;

--
-- Name: expdmergestatus; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE expdmergestatus (
    videoarchivesetid_fk bigint NOT NULL,
    mergedate timestamp without time zone NOT NULL,
    isnavigationedited smallint NOT NULL,
    statusmessage character varying(512) NOT NULL,
    videoframecount integer NOT NULL,
    ismerged smallint NOT NULL,
    datesource character varying(4) NOT NULL
);


ALTER TABLE public.expdmergestatus OWNER TO varsuser;

--
-- Name: observation; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE observation (
    id bigint NOT NULL,
    videoframeid_fk bigint,
    observationdtg timestamp without time zone,
    observer character varying(50),
    conceptname character varying(50),
    notes character varying(200),
    last_updated_time timestamp without time zone,
    x double precision,
    y double precision
);


ALTER TABLE public.observation OWNER TO varsuser;

--
-- Name: physicaldata; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE physicaldata (
    id bigint NOT NULL,
    videoframeid_fk bigint,
    depth real,
    temperature real,
    salinity real,
    oxygen real,
    light real,
    latitude double precision,
    longitude double precision,
    logdtg timestamp without time zone,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.physicaldata OWNER TO varsuser;

--
-- Name: videoarchive; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE videoarchive (
    id bigint NOT NULL,
    videoarchivesetid_fk bigint,
    tapenumber smallint,
    starttimecode character varying(11),
    videoarchivename character varying(1024),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.videoarchive OWNER TO varsuser;

--
-- Name: videoarchiveset; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE videoarchiveset (
    id bigint NOT NULL,
    trackingnumber character varying(7),
    shipname character varying(32),
    platformname character varying(32),
    formatcode character varying(2),
    startdtg timestamp without time zone,
    enddtg timestamp without time zone,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.videoarchiveset OWNER TO varsuser;

--
-- Name: videoframe; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE videoframe (
    id bigint NOT NULL,
    recordeddtg timestamp without time zone,
    tapetimecode character varying(11),
    hdtimecode character varying(11),
    insequence smallint,
    displacer character varying(50),
    displacedtg timestamp without time zone,
    videoarchiveid_fk bigint,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.videoframe OWNER TO varsuser;

--
-- Name: annotations; Type: VIEW; Schema: public; Owner: varsuser
--

CREATE VIEW annotations AS
 SELECT obs.observationdtg AS observationdate,
    obs.observer,
    obs.conceptname,
    obs.notes,
    obs.x AS xpixelinimage,
    obs.y AS ypixelinimage,
    vf.tapetimecode,
    vf.recordeddtg AS recordeddate,
    va.videoarchivename,
    vas.trackingnumber,
    vas.shipname,
    vas.platformname AS rovname,
    vas.formatcode AS annotationmode,
    cpd.seqnumber AS divenumber,
    cpd.chiefscientist,
    cd.name AS cameraname,
    cd.direction AS cameradirection,
    cd.zoom,
    cd.focus,
    cd.iris,
    cd.fieldwidth,
    cd.stillimageurl AS image,
    cd.x AS camerax,
    cd.y AS cameray,
    cd.z AS cameraz,
    cd.pitch AS camerapitchradians,
    cd.roll AS camerarollradians,
    cd.heading AS cameraheadingradians,
    cd.xyunits AS cameraxyunits,
    cd.zunits AS camerazunits,
    cd.viewwidth AS cameraviewwidth,
    cd.viewheight AS cameraviewheight,
    cd.viewunits AS cameraviewunits,
    pd.depth,
    pd.temperature,
    pd.salinity,
    pd.oxygen,
    pd.light,
    pd.latitude,
    pd.longitude,
    obs.id AS observationid_fk,
    ass.id AS associationid_fk,
    ass.linkname,
    ass.toconcept,
    ass.linkvalue,
    (((((ass.linkname)::text || ' | '::text) || (ass.toconcept)::text) || ' | '::text) || (ass.linkvalue)::text) AS associations,
    vf.hdtimecode AS highdeftimecode,
    expd.isnavigationedited,
    vf.id AS videoframeid_fk,
    pd.id AS physicaldataid_fk,
    cd.id AS cameradataid_fk,
    va.id AS videoarchiveid_fk,
    vas.id AS videoarchivesetid_fk
   FROM ((((((((videoarchiveset vas
     LEFT JOIN cameraplatformdeployment cpd ON ((cpd.videoarchivesetid_fk = vas.id)))
     LEFT JOIN videoarchive va ON ((vas.id = va.videoarchivesetid_fk)))
     LEFT JOIN videoframe vf ON ((va.id = vf.videoarchiveid_fk)))
     LEFT JOIN cameradata cd ON ((cd.videoframeid_fk = vf.id)))
     LEFT JOIN physicaldata pd ON ((pd.videoframeid_fk = vf.id)))
     LEFT JOIN observation obs ON ((obs.videoframeid_fk = vf.id)))
     LEFT JOIN association ass ON ((ass.observationid_fk = obs.id)))
     LEFT JOIN expdmergestatus expd ON ((expd.videoarchivesetid_fk = vas.id)));


ALTER TABLE public.annotations OWNER TO varsuser;

--
-- Name: artifact; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE artifact (
    conceptdelegateid_fk bigint NOT NULL,
    groupid character varying(64) NOT NULL,
    artifactid character varying(256) NOT NULL,
    version character varying(64) NOT NULL,
    classifier character varying(64),
    description character varying(2048),
    mimetype character varying(32),
    caption character varying(1024),
    reference character varying(1024) NOT NULL,
    credit character varying(1024),
    id bigint NOT NULL,
    last_updated_time timestamp without time zone NOT NULL,
    creationdate timestamp without time zone
);


ALTER TABLE public.artifact OWNER TO varsuser;

--
-- Name: concept; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE concept (
    id bigint NOT NULL,
    primaryconceptnameid bigint,
    parentconceptid_fk bigint,
    originator character varying(255),
    structuretype character varying(10),
    reference character varying(1024),
    nodccode character varying(20),
    rankname character varying(20),
    ranklevel character varying(20),
    taxonomytype character varying(20),
    conceptdelegateid_fk bigint,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.concept OWNER TO varsuser;

--
-- Name: conceptdelegate; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE conceptdelegate (
    id bigint NOT NULL,
    conceptid_fk bigint NOT NULL,
    usageid_fk bigint,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.conceptdelegate OWNER TO varsuser;

--
-- Name: conceptname; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE conceptname (
    conceptname character varying(128),
    conceptid_fk bigint,
    author character varying(255),
    nametype character varying(10),
    id bigint NOT NULL,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.conceptname OWNER TO varsuser;

--
-- Name: history; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE history (
    id bigint NOT NULL,
    conceptdelegateid_fk bigint,
    processeddtg timestamp without time zone,
    creationdtg timestamp without time zone,
    description character varying(1000),
    creatorname character varying(50),
    processorname character varying(50),
    field character varying(50),
    oldvalue character varying(2048),
    newvalue character varying(2048),
    action character varying(16),
    comment character varying(2048),
    approved smallint NOT NULL,
    last_updated_time timestamp without time zone
);


ALTER TABLE public.history OWNER TO varsuser;

--
-- Name: linkrealization; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE linkrealization (
    id bigint NOT NULL,
    parentlinkrealization bigint,
    conceptdelegateid_fk bigint,
    linkname character varying(50),
    toconcept character varying(128),
    linkvalue character varying(2048),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.linkrealization OWNER TO varsuser;

--
-- Name: linktemplate; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE linktemplate (
    id bigint NOT NULL,
    conceptdelegateid_fk bigint,
    linkname character varying(50),
    toconcept character varying(128),
    linkvalue character varying(255),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.linktemplate OWNER TO varsuser;

--
-- Name: media; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE media (
    id bigint NOT NULL,
    conceptdelegateid_fk bigint,
    url character varying(1024),
    mediatype character(5),
    primarymedia bit(1),
    credit character varying(255),
    caption character varying(1000),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.media OWNER TO varsuser;

--
-- Name: prefs; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE prefs (
    nodename character varying(255) NOT NULL,
    prefkey character varying(50) NOT NULL,
    prefvalue character varying(255) NOT NULL
);


ALTER TABLE public.prefs OWNER TO varsuser;

--
-- Name: sectioninfo; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE sectioninfo (
    id bigint NOT NULL,
    conceptdelegateid_fk bigint NOT NULL,
    header character varying(30) NOT NULL,
    label character varying(50) NOT NULL,
    information character varying(5000)
);


ALTER TABLE public.sectioninfo OWNER TO varsuser;

--
-- Name: uniqueid; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE uniqueid (
    tablename character varying(200) NOT NULL,
    nextid bigint
);


ALTER TABLE public.uniqueid OWNER TO varsuser;

--
-- Name: usage; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE usage (
    id bigint NOT NULL,
    conceptdelegateid_fk bigint,
    embargoexpirationdate timestamp without time zone,
    specification character varying(1000),
    last_updated_time timestamp without time zone
);


ALTER TABLE public.usage OWNER TO varsuser;

--
-- Name: useraccount; Type: TABLE; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE TABLE useraccount (
    id bigint NOT NULL,
    username character varying(50) NOT NULL,
    password character varying(50),
    role character varying(10),
    last_updated_time timestamp without time zone,
    affiliation character varying(50),
    firstname character varying(50),
    lastname character varying(50),
    email character varying(50)
);


ALTER TABLE public.useraccount OWNER TO varsuser;

--
-- Data for Name: artifact; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY artifact (conceptdelegateid_fk, groupid, artifactid, version, classifier, description, mimetype, caption, reference, credit, id, last_updated_time, creationdate) FROM stdin;
\.


--
-- Data for Name: association; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY association (id, observationid_fk, linkname, toconcept, linkvalue, last_updated_time) FROM stdin;
\.


--
-- Data for Name: cameradata; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY cameradata (id, videoframeid_fk, name, direction, zoom, focus, iris, fieldwidth, stillimageurl, logdtg, last_updated_time, x, y, z, pitch, roll, xyunits, zunits, heading, viewheight, viewwidth, viewunits) FROM stdin;
\.


--
-- Data for Name: cameraplatformdeployment; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY cameraplatformdeployment (id, videoarchivesetid_fk, seqnumber, chiefscientist, usagestartdtg, usageenddtg, last_updated_time) FROM stdin;
\.


--
-- Data for Name: concept; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY concept (id, primaryconceptnameid, parentconceptid_fk, originator, structuretype, reference, nodccode, rankname, ranklevel, taxonomytype, conceptdelegateid_fk, last_updated_time) FROM stdin;
4739	6826	4706	lonny	\N	Anderson, M.E. and V.V. Fedorov, 2004. Family Zoarcidae Swainson 1839. Eelpouts. Calif. Acad. Sci. Annotated Checklists of Fishes (34):58.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4740	6827	4739	lonny	\N	Anderson, M.E. and V.V. Fedorov, 2004. Family Zoarcidae Swainson 1839. Eelpouts. Calif. Acad. Sci. Annotated Checklists of Fishes (34):58.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4741	6830	4696	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4742	6833	4741	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4743	6835	4742	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4744	6838	4741	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4745	6840	4744	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4746	6843	4741	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4747	6845	4746	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4748	6848	4741	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4749	6850	4748	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4750	6853	4696	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4751	6855	4750	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4752	6857	4751	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4753	6860	4696	jana	taxonomy	\N	884202	family	\N	\N	\N	2009-01-01 00:00:00
4754	6863	4753	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4755	6865	4754	jana	taxonomy	\N	8842020201	species	\N	\N	\N	2009-01-01 00:00:00
4756	6868	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4757	6870	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4758	6873	4757	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4759	6875	4758	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4760	6878	4757	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4761	6880	4760	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4762	6883	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4763	6886	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4764	6889	4763	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4765	6891	4764	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4766	6894	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4767	6897	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4768	6900	4767	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4769	6903	4767	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4770	6905	4756	jana	taxonomy	\N	883522	family	\N	\N	\N	2009-01-01 00:00:00
4771	6909	4770	nodc	taxonomy	\N	88352201	genus	\N	\N	\N	2009-01-01 00:00:00
4772	6911	4771	nodc	taxonomy	\N	8835220101	species	\N	\N	\N	2009-01-01 00:00:00
4773	6914	4756	jana	taxonomy	\N	883502	family	\N	\N	\N	2009-01-01 00:00:00
4774	6918	4773	lonny	taxonomy	www.itis.usda.gov, www.fishbase.org	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4775	6920	4773	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3734	4916	\N	vicki	taxonomy	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3735	4918	3734	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3736	4919	3734	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3737	4920	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3738	4921	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3739	4922	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3740	4923	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3741	4924	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3742	4925	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3743	4927	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3744	4928	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3745	4929	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3746	4930	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3747	4931	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3748	4932	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3749	4933	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3750	4934	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3751	4935	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3752	4936	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3753	4937	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3754	4938	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3755	4939	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3756	4940	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3757	4941	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3758	4942	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3759	4943	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3760	4944	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3761	4945	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3762	4946	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3763	4947	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3764	4948	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3765	4949	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3766	4950	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3767	4951	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3768	4952	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3769	4953	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3770	4954	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3771	4955	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3772	4956	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3773	4957	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3774	4958	3736	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3775	4959	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3776	4960	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3777	4961	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3778	4962	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3779	4963	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3780	4964	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3781	4965	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3782	4966	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3783	4967	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3784	4968	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3785	4969	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3786	4970	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3787	4971	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3788	4972	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3789	4973	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3790	4975	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3791	4976	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3792	4977	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3793	4978	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3794	4979	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3795	4980	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3796	4981	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3797	4982	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3798	4983	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3799	4984	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3800	4985	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3801	4986	3736	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3802	4987	3736	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3803	4988	3734	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3804	4989	3803	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3805	4992	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3806	4994	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3807	4996	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3808	4998	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3809	5000	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3810	5003	3804	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3811	5005	3803	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3812	5008	3811	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3813	5010	3811	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3814	5012	3811	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3815	5014	3811	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3816	5016	3811	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3817	5018	3803	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3818	5020	3803	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3819	5022	3803	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3820	5025	3819	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3821	5028	3819	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3822	5032	3819	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3823	5035	3734	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3824	5036	3734	jana	taxonomy	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3825	5038	3824	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3826	5040	3825	lonny	taxonomy	http://www.ncbi.nih.gov/	\N	kingdom	super	\N	\N	2009-01-01 00:00:00
3827	5041	3826	nodc	taxonomy	\N	02	phylum	\N	\N	\N	2009-01-01 00:00:00
3828	5042	3827	unknown	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
3829	5043	3828	nodc	taxonomy	\N	0211	order	\N	\N	\N	2009-01-01 00:00:00
3830	5044	3829	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3831	5045	3830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3832	5046	3830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3833	5047	3826	lonny	taxonomy	\N	\N	phylum	\N	\N	\N	2009-01-01 00:00:00
3834	5049	3833	lonny	taxonomy	http://www.ncbi.nlm.nih.gov/	\N	order	\N	\N	\N	2009-01-01 00:00:00
3835	5050	3834	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3836	5051	3835	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3837	5053	3825	jana	taxonomy	\N	\N	kingdom	super	\N	\N	2009-01-01 00:00:00
3838	5054	3837	jana	taxonomy	\N	\N	kingdom	\N	\N	\N	2009-01-01 00:00:00
3839	5055	3838	jana	taxonomy	\N	08	phylum	\N	\N	\N	2009-01-01 00:00:00
3840	5059	3839	nodc	taxonomy	\N	0801	class	\N	\N	\N	2009-01-01 00:00:00
3841	5061	3840	nodc	taxonomy	\N	080503	family	\N	\N	\N	2009-01-01 00:00:00
3842	5063	3841	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3843	5065	3841	nodc	taxonomy	\N	08050305	genus	\N	\N	\N	2009-01-01 00:00:00
3844	5067	3840	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3845	5069	3844	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3846	5071	3845	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3847	5073	3846	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3848	5075	3844	jana	taxonomy	\N	080903	family	\N	\N	\N	2009-01-01 00:00:00
3849	5077	3848	nodc	taxonomy	\N	08090301	genus	\N	\N	\N	2009-01-01 00:00:00
3850	5079	3838	jana	taxonomy	\N	16	phylum	\N	\N	\N	2009-01-01 00:00:00
3851	5083	3850	nodc	taxonomy	\N	1608	order	\N	\N	\N	2009-01-01 00:00:00
3852	5085	3851	nodc	taxonomy	\N	160810	family	\N	\N	\N	2009-01-01 00:00:00
3853	5087	3852	nodc	taxonomy	\N	16081002	genus	\N	\N	\N	2009-01-01 00:00:00
3854	5089	3853	nodc	taxonomy	\N	1608100201	species	\N	\N	\N	2009-01-01 00:00:00
3855	5091	3852	nodc	taxonomy	\N	16081003	genus	\N	\N	\N	2009-01-01 00:00:00
3856	5093	3855	nodc	taxonomy	\N	1608100303	species	\N	\N	\N	2009-01-01 00:00:00
3857	5095	3855	nodc	taxonomy	\N	1608100301	species	\N	\N	\N	2009-01-01 00:00:00
3858	5097	3851	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3859	5099	3858	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3860	5101	3851	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3861	5103	3860	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3862	5105	3861	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3863	5107	3850	nodc	taxonomy	\N	1610	order	\N	\N	\N	2009-01-01 00:00:00
3864	5109	3863	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3865	5111	3864	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3866	5113	3865	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3867	5115	3864	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3868	5117	3867	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3869	5119	3864	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3870	5121	3869	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3871	5123	3870	jana	taxonomy	\N	\N	variety	\N	\N	\N	2009-01-01 00:00:00
3872	5125	3869	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3873	5127	3864	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3874	5129	3873	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3875	5131	3863	nodc	taxonomy	\N	16100204	genus	\N	\N	\N	2009-01-01 00:00:00
3876	5133	3875	nodc	taxonomy	\N	1610020401	species	\N	\N	\N	2009-01-01 00:00:00
3877	5135	3850	nodc	taxonomy	\N	1603	order	\N	\N	\N	2009-01-01 00:00:00
3878	5137	3850	nodc	taxonomy	\N	1609	order	\N	\N	\N	2009-01-01 00:00:00
3879	5139	3878	nodc	taxonomy	\N	160907	family	\N	\N	\N	2009-01-01 00:00:00
3880	5142	3879	nodc	taxonomy	\N	16090715	genus	\N	\N	\N	2009-01-01 00:00:00
3881	5144	3880	nodc	taxonomy	\N	1609071501	species	\N	\N	\N	2009-01-01 00:00:00
3882	5146	3880	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3883	5148	3879	nodc	taxonomy	\N	16090707	genus	\N	\N	\N	2009-01-01 00:00:00
3884	5150	3879	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3885	5152	3879	nodc	taxonomy	\N	16090717	genus	\N	\N	\N	2009-01-01 00:00:00
3886	5154	3885	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3887	5156	3878	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3888	5158	3887	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3889	5160	3888	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3890	5162	3888	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3891	5164	3888	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3892	5166	3878	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3893	5168	3892	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3894	5170	3893	jana	taxonomy	name provided by Heather Spalding, no other reference available	\N	species	\N	\N	\N	2009-01-01 00:00:00
3895	5172	3893	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3896	5174	3878	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3897	5176	3896	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3898	5178	3897	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3899	5180	3897	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3900	5182	3850	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3901	5184	3900	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3902	5186	3901	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3903	5188	3901	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3904	5190	3903	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3905	5192	3901	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3906	5194	3905	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3907	5196	3838	jana	taxonomy	\N	\N	kingdom	\N	\N	\N	2009-01-01 00:00:00
3908	5199	3907	jana	taxonomy	\N	33	division	\N	\N	\N	2009-01-01 00:00:00
3909	5204	3908	nodc	taxonomy	\N	3306	order	\N	\N	\N	2009-01-01 00:00:00
3910	5206	3909	nodc	taxonomy	\N	330608	family	\N	\N	\N	2009-01-01 00:00:00
3911	5209	3910	nodc	taxonomy	\N	33060801	genus	\N	\N	\N	2009-01-01 00:00:00
3912	5212	3911	nodc	taxonomy	\N	3306080101	species	\N	\N	\N	2009-01-01 00:00:00
3913	5214	3911	nodc	taxonomy	\N	3306080102	species	\N	\N	\N	2009-01-01 00:00:00
3914	5216	3910	nodc	taxonomy	\N	33060802	genus	\N	\N	\N	2009-01-01 00:00:00
3915	5219	3914	nodc	taxonomy	\N	3306080201	species	\N	\N	\N	2009-01-01 00:00:00
3916	5221	3837	jana	taxonomy	\N	\N	kingdom	\N	\N	\N	2009-01-01 00:00:00
3917	5223	3916	nodc	taxonomy	\N	78	phylum	\N	\N	\N	2009-01-01 00:00:00
3918	5229	3917	nodc	taxonomy	\N	7801	class	\N	\N	\N	2009-01-01 00:00:00
3919	5232	3918	linda	\N	Clarke, A.; Johnston, N.M. (2003). Antarctic marine benthic diversity. Oceanogr. Mar. Biol. Ann. Rev. 41: 47-114 	\N	order	\N	\N	\N	2009-01-01 00:00:00
3920	5234	3919	jana	\N	http://www.marinespecies.org/aphia.php?p=taxdetails&id=196087	\N	order	sub	\N	\N	2009-01-01 00:00:00
3921	5235	3920	jana	\N	http://www.marinespecies.org/aphia.php?p=taxdetails&id=153674	\N	order	infra	\N	\N	2009-01-01 00:00:00
3922	5236	3921	jana	\N	Hayward, P.J.; Ryland, J.S. (1999). Cheilostomatous Bryozoa: part 2 Hippothooidea - Celleporoidea: notes for the identification of British species. 2nd ed.. Synopses of the British fauna (new series), 14. Field Studies Council: Shrewsbury, UK. ISBN 1-85153-263-3. vii, 416 pp. 	\N	family	super	\N	\N	2009-01-01 00:00:00
3923	5237	3922	linda	\N	Hayward, P.J. (2001). Bryozoa, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 325-333 	\N	family	\N	\N	\N	2009-01-01 00:00:00
3924	5238	3923	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3925	5239	3924	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3926	5240	3916	jana	taxonomy	\N	43	phylum	\N	\N	\N	2009-01-01 00:00:00
3927	5244	3926	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
3928	5246	3927	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3929	5248	3928	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
3930	5250	3929	jana	taxonomy	\N	430703	family	\N	\N	\N	2009-01-01 00:00:00
3931	5252	3930	nodc	taxonomy	\N	43070301	genus	\N	\N	\N	2009-01-01 00:00:00
3932	5254	3931	nodc	taxonomy	\N	4307030101	species	\N	\N	\N	2009-01-01 00:00:00
3933	5257	3926	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3934	5259	3933	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3935	5261	3916	jana	taxonomy	\N	72	phylum	\N	\N	\N	2009-01-01 00:00:00
3936	5266	3935	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3937	5267	3936	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3938	5268	3916	jana	taxonomy	\N	36	phylum	\N	\N	\N	2009-01-01 00:00:00
3939	5270	3938	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3940	5271	3938	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
3941	5272	3940	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
3942	5273	3941	linda	\N	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3943	5274	3942	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3944	5275	3943	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3945	5276	3944	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3946	5277	3944	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3947	5278	3940	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
3948	5279	3947	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3949	5280	3947	unknown	\N	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3950	5281	3949	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3951	5282	3950	nodc	taxonomy	\N	36321001	genus	\N	\N	\N	2009-01-01 00:00:00
3952	5283	3950	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3953	5284	3952	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3954	5285	3950	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3955	5286	3954	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3956	5287	3954	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3957	5288	3950	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3958	5289	3949	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3959	5291	3958	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3960	5292	3959	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3961	5294	3958	linda	\N	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
3962	5295	3961	lonny	taxonomy	Systema Naturae 2000, sn2000.taxonomy.nl	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3963	5296	3962	lonny	taxonomy	Caulophacus cyanae n.sp., a new hexactinellid sponge from hydrothermal vents. Biogeography of the genus Caulophacus Schulze, 1887. (PROCEEDINGS OF THE SYMPOSIUM HYDROTHERMAL VENTS OF THE EAST PACIFIC RISE. BIOLOGY AND ECOLOGY, PARIS 4-7 NOV 1985.)., ACTES DU COLLOQUE LES SOURCES HYDROTHERMALES DE LA RIDE DU PACIFIQUE ORIENTAL. BIOLOGIE ET ECOLOGIE, PARIS, 4-7 NOV 1985., 1988, pp. 51-60, Oceanologica acta. Paris [OCEANOL. ACTA.], vol. HS, no. 8 Boury-Esnault, N; de Vos, L	\N	species	\N	\N	\N	2009-01-01 00:00:00
3964	5297	3961	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3965	5298	3964	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3966	5299	3964	linda	\N	\N	\N	species	sub	\N	\N	2009-01-01 00:00:00
3967	5300	3964	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3968	5301	3947	unknown	\N	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
3969	5302	3968	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3970	5303	3969	jana	taxonomy	\N	36320302	genus	\N	\N	\N	2009-01-01 00:00:00
3971	5304	3969	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3972	5305	3971	unknown	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3973	5306	3968	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3974	5307	3973	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3975	5308	3974	jana	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3976	5310	3968	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3977	5311	3976	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3978	5313	3977	jana	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3979	5315	3968	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3980	5316	3979	unknown	\N	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
3981	5317	3980	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3982	5319	3940	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3983	5320	3940	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3984	5321	3940	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3985	5322	3940	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3986	5323	3940	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3987	5324	3938	nodc	taxonomy	Sollas, W.J. 1885b. A Classification of the Sponges. Annals and Magazine of Natural History (5) 16(95): 395.	3660	class	\N	\N	\N	2009-01-01 00:00:00
3988	5326	3987	nodc	taxonomy	\N	3663	order	\N	\N	\N	2009-01-01 00:00:00
3989	5327	3987	lonny	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
3990	5329	3987	lonny	taxonomy	\N	3664	order	\N	\N	\N	2009-01-01 00:00:00
3991	5330	3990	jana	\N	Hajdu, E.; Van Soest, R.W.M.; Hooper, J.N.A. 1994a. Proposal for a phylogenetic subordinal classification of poecilosclerid sponges. Pp. 123-139. In: van Soest, R.W.M., van Kempen, Th.M.G. & Braekman,J.-C. (Eds), Sponges in Time and Space. (Balkema: Rotterdam): 1-515.	\N	order	sub	\N	\N	2009-01-01 00:00:00
3992	5331	3991	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
3993	5332	3992	nodc	taxonomy	\N	36641701	genus	\N	\N	\N	2009-01-01 00:00:00
3994	5333	3993	nodc	taxonomy	\N	3664170103	species	\N	\N	\N	2009-01-01 00:00:00
3995	5334	3993	nodc	taxonomy	\N	3664170104	species	\N	\N	\N	2009-01-01 00:00:00
3996	5335	3993	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
3997	5336	3992	lonny	taxonomy	Thomson, C.W. 1873. The Depths of the Sea. (Macmillan and Co.: London): 1-527.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
3998	5337	3997	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
3999	5338	3997	linda	\N	New carnivorous sponges (Porifera, Poecilosclerida)collected from manned submersibles in the deep Pacific. Vacelet, J. 2006. Zoological Journal of the Linnean Society\nv148, 553–584. \n\n	\N	species	\N	\N	\N	2009-01-01 00:00:00
4000	5339	3992	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4001	5340	4000	unknown	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4002	5341	3992	jana	\N	Jean Vacelet (2008). A new genus of carnivorous sponges (Porifera: Poecilosclerida, Cladorhizidae) from the deep N-E Pacific, and remarks on the genus Neocladia. Zootaxa 1752: 57-65.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4003	5342	4002	jana	\N	Jean Vacelet (2008). A new genus of carnivorous sponges (Porifera: Poecilosclerida, Cladorhizidae) from the deep N-E Pacific, and remarks on the genus Neocladia. Zootaxa 1752: 57-65.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4004	5343	3987	nodc	taxonomy	\N	3666	order	\N	\N	\N	2009-01-01 00:00:00
4005	5344	4004	nodc	taxonomy	\N	366604	family	\N	\N	\N	2009-01-01 00:00:00
4006	5345	4005	nodc	taxonomy	\N	36660401	genus	\N	\N	\N	2009-01-01 00:00:00
4007	5346	4004	lonny	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4008	5347	4007	lonny	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4009	5348	3987	unknown	\N	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4010	5349	4009	unknown	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4011	5350	4010	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4012	5351	4011	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4013	5352	3987	jana	\N	Lévi, C. 1973. Systématique de la classe des Demospongiaria (Démosponges). Pp. 577-631. In: Grassé, P.-P. (Ed.), Traité de Zoologie. Anatomie, Systématique, Biologie. Spongiaires. 3(1). (Masson et Cie:Paris): 1-716.	\N	class	sub	\N	\N	2009-01-01 00:00:00
4014	5353	4013	unknown	\N	Dendy, A. 1905. Report on the sponges collected by Professor Herdman,at Ceylon, in 1902. Pp. 57-246, pls I-XVI. In: Herdman, W.A. (Ed.), Report to the Government of Ceylon on the Pearl Oyster Fisheries of the Gulf of Manaar. 3(Supplement 18). (Royal Society: London).	\N	order	\N	\N	\N	2009-01-01 00:00:00
4015	5355	3938	nodc	taxonomy	\N	3601	class	\N	\N	\N	2009-01-01 00:00:00
4016	5356	4015	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4017	5357	4016	nodc	taxonomy	\N	3607	order	\N	\N	\N	2009-01-01 00:00:00
4018	5358	4017	nodc	taxonomy	\N	360701	family	\N	\N	\N	2009-01-01 00:00:00
4019	5359	4018	nodc	taxonomy	\N	36070101	genus	\N	\N	\N	2009-01-01 00:00:00
4020	5360	4015	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4021	5361	3938	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4022	5362	3938	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4023	5363	3938	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4024	5364	3938	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4025	5365	3916	jana	taxonomy	\N	81	phylum	\N	\N	\N	2009-01-01 00:00:00
4026	5367	4025	nodc	taxonomy	\N	810801	family	\N	\N	\N	2009-01-01 00:00:00
4027	5368	4026	nodc	taxonomy	\N	81080101	genus	\N	\N	\N	2009-01-01 00:00:00
4028	5369	4027	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4029	5370	4025	nodc	taxonomy	\N	8136	class	\N	\N	\N	2009-01-01 00:00:00
4030	5373	4029	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4031	5374	4030	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4032	5375	4031	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4033	5377	4032	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4034	5378	4033	lonny	taxonomy	A. Agassiz y H. L. Clark.Mem. Mus. Comp. Zool. 34: 37, l·m. 9. 1907	\N	species	\N	\N	\N	2009-01-01 00:00:00
4035	5380	4029	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4036	5381	4035	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4037	5382	4036	jana	taxonomy	\N	8148	order	\N	\N	\N	2009-01-01 00:00:00
4038	5383	4037	nodc	taxonomy	\N	814802	family	\N	\N	\N	2009-01-01 00:00:00
4039	5384	4038	nodc	taxonomy	\N	81480201	genus	\N	\N	\N	2009-01-01 00:00:00
4040	5385	4039	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4041	5386	4036	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4042	5387	4041	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4043	5388	4042	jana	taxonomy	\N	81490301	genus	\N	\N	\N	2009-01-01 00:00:00
4044	5390	4043	nodc	taxonomy	\N	8149030101	species	\N	\N	\N	2009-01-01 00:00:00
4045	5392	4042	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4046	5393	4045	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4047	5394	4045	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4048	5395	4035	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4049	5396	4048	lonny	taxonomy	www.itis.usda.gov	\N	order	\N	\N	\N	2009-01-01 00:00:00
4050	5397	4049	lonny	taxonomy	www.itis.usda.gov	\N	order	sub	\N	\N	2009-01-01 00:00:00
4051	5398	4050	lonny	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
4052	5399	4051	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4053	5400	4052	lonny	taxonomy	www.itis.usda.gov, Mortensen, 1950, Mironov, 1973	\N	species	\N	\N	\N	2009-01-01 00:00:00
4054	5401	4051	lonny	taxonomy	Agassiz, 1904, Mooi, 1996	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4055	5402	4054	lonny	taxonomy	Agassiz, 1904, Mooi, 1996	\N	species	\N	\N	\N	2009-01-01 00:00:00
4056	5403	4051	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4057	5404	4056	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4058	5406	4048	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4059	5409	4058	jana	taxonomy	\N	8162	order	sub	\N	\N	2009-01-01 00:00:00
4060	5410	4059	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4061	5411	4060	jana	taxonomy	\N	81620401	genus	\N	\N	\N	2009-01-01 00:00:00
4062	5413	4061	jana	taxonomy	www.itis.usda.gov	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4063	5414	4058	jana	taxonomy	\N	8163	order	sub	\N	\N	2009-01-01 00:00:00
4064	5415	4063	nodc	taxonomy	\N	816303	family	\N	\N	\N	2009-01-01 00:00:00
4065	5416	4064	nodc	taxonomy	\N	81630302	genus	\N	\N	\N	2009-01-01 00:00:00
4066	5417	4065	nodc	taxonomy	\N	8163030201	species	\N	\N	\N	2009-01-01 00:00:00
4067	5418	4035	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4068	5419	4067	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4069	5420	4068	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4070	5421	4069	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4071	5422	4070	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4072	5423	4069	lonny	taxonomy	Mortensen, T. 1935. A monograph of the Echinoidea. Volume 2, Bothriocidaroida, Melonechinoida, Lepidocentroida and Stirodonta. C.A. Reitzel, Copenhagen.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4073	5424	4072	lonny	taxonomy	Mortensen, T. 1935. A monograph of the Echinoidea. Volume 2, Bothriocidaroida, Melonechinoida, Lepidocentroida and Stirodonta. C.A. Reitzel, Copenhagen.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4074	5425	4072	unknown	taxonomy	http://www.nhm.ac.uk/palaeontology/echinoids/ (Natural History Museum, UK)	\N	species	\N	\N	\N	2009-01-01 00:00:00
4075	5426	4072	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4076	5427	4069	lonny	\N	MORTENSEN, T. (1935): A Monograph of the Echinoidea, II, Bothriocidaroida, Melonechinoida, Lepidocentroida, Stirodonta. – 647 pp. – Copenhagen (C. A. Reitzel).	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4077	5428	4076	lonny	\N	MORTENSEN, T. (1935): A Monograph of the Echinoidea, II, Bothriocidaroida, Melonechinoida, Lepidocentroida, Stirodonta. – 647 pp. – Copenhagen (C. A. Reitzel).	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4078	5429	4029	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4079	5430	4025	nodc	taxonomy	\N	8170	class	\N	\N	\N	2009-01-01 00:00:00
4080	5433	4079	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4081	5434	4080	jana	taxonomy	\N	8179	order	\N	\N	\N	2009-01-01 00:00:00
4082	5435	4081	nodc	taxonomy	\N	817901	family	\N	\N	\N	2009-01-01 00:00:00
4083	5436	4082	nodc	taxonomy	\N	81790101	genus	\N	\N	\N	2009-01-01 00:00:00
4084	5438	4079	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4085	5439	4084	jana	taxonomy	\N	8176	order	\N	\N	\N	2009-01-01 00:00:00
4086	5440	4085	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4087	5441	4086	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4088	5443	4087	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4089	5445	4087	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4090	5447	4087	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4091	5449	4086	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4092	5451	4091	unknown	taxonomy	Taxonomist David Pawson (Smithsonian NMNH)	\N	species	\N	\N	\N	2009-01-01 00:00:00
4093	5453	4085	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4094	5454	4093	nodc	taxonomy	\N	81760201	genus	\N	\N	\N	2009-01-01 00:00:00
4095	5455	4094	nodc	taxonomy	\N	8176020101	species	\N	\N	\N	2009-01-01 00:00:00
4096	5457	4093	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4097	5458	4096	lonny	taxonomy	Maluf, Linda. 1988. Composition and Distribution of the Central Eastern Pacific Echinoderms. Natural History Museum of Los Angeles County.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4098	5459	4093	linda	\N	Hansson, H.G. (2001). Echinodermata, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 336-351	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4099	5460	4098	linda	\N	Hansson, H.G. (2001). Echinodermata, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 336-351 	\N	species	\N	\N	\N	2009-01-01 00:00:00
4100	5461	4085	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4101	5462	4100	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4102	5463	4101	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4103	5464	4085	jana	taxonomy	\N	817603	family	\N	\N	\N	2009-01-01 00:00:00
4104	5465	4103	nodc	taxonomy	\N	81760306	genus	\N	\N	\N	2009-01-01 00:00:00
4105	5466	4104	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4106	5467	4104	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4107	5468	4103	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4108	5469	4107	lonny	taxonomy	Pawson, DL & Foell, EJ. 1986. BULL.MAR.SCI. vol. 38, no. 2, pp. 293-299.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4109	5470	4107	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4110	5471	4103	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4111	5472	4110	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4112	5473	4085	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4113	5474	4112	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4114	5475	4084	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4115	5476	4114	jana	taxonomy	\N	817502	family	\N	\N	\N	2009-01-01 00:00:00
4116	5477	4115	nodc	taxonomy	\N	81750201	genus	\N	\N	\N	2009-01-01 00:00:00
4117	5478	4116	lonny	taxonomy	Lambert, P. 1986. Northeast Pacific holothurians of the genus Parastichopus with a description of a new species Parastichopus leukothele (Echinodermata). Can. J. Zool. 64: 2266-2272. Royal British Columbia Museum Handbook: Sea Cucumbers. Lambert, Philip 1997 UBC Press Taxonomic Atlas of the Benthic Fauna (Santa Barbara Basin and Western Santa Barbara Channel). SBMNH 1993.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4118	5479	4116	nodc	taxonomy	\N	8175020103	species	\N	\N	\N	2009-01-01 00:00:00
4119	5480	4116	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4120	5482	4115	nodc	taxonomy	\N	81750202	genus	\N	\N	\N	2009-01-01 00:00:00
4121	5483	4114	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4122	5484	4121	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4123	5485	4122	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4124	5486	4121	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4125	5487	4121	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4126	5488	4125	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4127	5489	4121	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4128	5490	4079	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4129	5491	4128	lonny	taxonomy	ITIS, www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
4130	5493	4129	lonny	taxonomy	itis.usda.gov, European Echinodermata Check-List European Echinodermata Check-List a draft for the European Register of Marine Species (part of `Species 2000`) compiled at TMBL (Tj‰rnˆ Marine Biological Laboratory) by: Hans G. Hansson January 1999 (revised 2 March 1999)	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4131	5495	4130	lonny	taxonomy	Theel, Hjalmar. 1886a. Report of the Scientific Results of the Voyage of H.M.S. `Challenger` 1873-1876 14(39):1-290.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4132	5497	4128	jana	taxonomy	\N	817203	family	\N	\N	\N	2009-01-01 00:00:00
4133	5499	4132	nodc	taxonomy	\N	81720302	genus	\N	\N	\N	2009-01-01 00:00:00
4134	5501	4133	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4135	5503	4133	nodc	taxonomy	\N	8172030207	species	\N	\N	\N	2009-01-01 00:00:00
4136	5505	4025	nodc	taxonomy	\N	8186	class	\N	\N	\N	2009-01-01 00:00:00
4137	5508	4136	jana	taxonomy	\N	8189	order	\N	\N	\N	2009-01-01 00:00:00
4138	5510	4137	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
4139	5511	4138	jana	taxonomy	\N	819101	family	\N	\N	\N	2009-01-01 00:00:00
4140	5512	4139	nodc	taxonomy	\N	81910102	genus	\N	\N	\N	2009-01-01 00:00:00
4141	5513	4140	nodc	taxonomy	\N	8191010201	species	\N	\N	\N	2009-01-01 00:00:00
4142	5514	4137	unknown	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4143	5515	4142	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4144	5516	4143	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4145	5517	4144	lonny	\N	Messing, CG. 2008. A new species of five-armed feather star, Pentametrocrinus paucispinulus n. sp., from the eastern Pacific (Echinodermata: Crinoidea: Comatulida). PROCEEDINGS OF THE BIOLOGICAL SOCIETY OF WASHINGTON 121(2):269–275.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4146	5518	4137	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4147	5519	4146	linda	\N	Station M faunal identifications	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4148	5520	4136	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4149	5521	4136	unknown	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4150	5522	4149	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4151	5523	4150	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4152	5524	4136	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4153	5525	4152	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4154	5526	4025	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4155	5527	4154	nodc	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4156	5529	4155	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4157	5530	4156	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4158	5532	4157	nodc	taxonomy	\N	811801	family	\N	\N	\N	2009-01-01 00:00:00
4159	5533	4158	nodc	taxonomy	\N	81180105	genus	\N	\N	\N	2009-01-01 00:00:00
4160	5534	4158	nodc	taxonomy	\N	81180104	genus	\N	\N	\N	2009-01-01 00:00:00
4161	5535	4160	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4162	5536	4158	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4163	5537	4162	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4164	5539	4157	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4165	5540	4164	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4166	5542	4155	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4167	5543	4166	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4168	5544	4166	unknown	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4169	5545	4168	jana	taxonomy	\N	811404	family	\N	\N	\N	2009-01-01 00:00:00
4170	5546	4169	nodc	taxonomy	\N	81140401	genus	\N	\N	\N	2009-01-01 00:00:00
4171	5547	4170	jana	taxonomy	Lambert, Philip. 2000. Royal British Columbia Museum. Sea Stars of British Columbia, Southeast Alaska and Puget Sound.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4172	5549	4170	jana	taxonomy	Malouf, LY 1988. Composition and distribution of the central eastern pacific echinoderms. Natural History Museum of Los Angeles County. techincal Report Number 2.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4173	5550	4170	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4174	5551	4170	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4175	5552	4169	nodc	taxonomy	\N	81140402	genus	\N	\N	\N	2009-01-01 00:00:00
4176	5553	4175	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4177	5555	4169	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4178	5556	4155	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4179	5557	4178	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4180	5559	4179	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4181	5561	4180	jana	taxonomy	\N	81140301	genus	\N	\N	\N	2009-01-01 00:00:00
4182	5564	4181	nodc	taxonomy	\N	8114030101	species	\N	\N	\N	2009-01-01 00:00:00
4183	5566	4179	jana	taxonomy	\N	811104	family	\N	\N	\N	2009-01-01 00:00:00
4184	5568	4183	nodc	taxonomy	\N	81110405	genus	\N	\N	\N	2009-01-01 00:00:00
4185	5570	4184	jana	taxonomy	Malouf, LY 1988. Composition and distribution of the central eastern pacific echinoderms. Natural History Museum of Los Angeles County. Techincal Report Number 2.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4186	5572	4184	nodc	taxonomy	\N	8111040504	species	\N	\N	\N	2009-01-01 00:00:00
4187	5574	4184	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4188	5576	4183	nodc	taxonomy	\N	81110404	genus	\N	\N	\N	2009-01-01 00:00:00
4189	5578	4188	nodc	taxonomy	\N	8111040403	species	\N	\N	\N	2009-01-01 00:00:00
4190	5580	4188	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4191	5582	4183	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4192	5584	4191	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4193	5586	4183	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4194	5588	4183	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4195	5590	4194	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4196	5592	4194	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4197	5594	4179	jana	taxonomy	\N	811401	family	\N	\N	\N	2009-01-01 00:00:00
4198	5596	4197	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4199	5598	4197	nodc	taxonomy	\N	81140101	genus	\N	\N	\N	2009-01-01 00:00:00
4200	5601	4199	nodc	taxonomy	\N	8114010101	species	\N	\N	\N	2009-01-01 00:00:00
4201	5604	4155	jana	taxonomy	\N	8117	order	\N	\N	\N	2009-01-01 00:00:00
4202	5605	4201	jana	taxonomy	www.itis.usda.gov	811702	family	\N	\N	\N	2009-01-01 00:00:00
4203	5607	4202	nodc	taxonomy	\N	81170202	genus	\N	\N	\N	2009-01-01 00:00:00
4204	5609	4203	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4205	5611	4203	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4206	5613	4202	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4207	5615	4206	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4208	5617	4206	linda	\N	Phylogeny of the Zoroasteridae (Zorocallina;\nForcipulatida): evolutionary events in deep-sea\nAsteroidea displaying Palaeozoic features.\n\nCHRISTOPHER MAH (ID from collected specimen May 30, 2007)\n\nZoological Journal of the Linnean Society\n, 2007,\n150\n, 177–210.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4209	5618	4201	jana	taxonomy	\N	811703	family	\N	\N	\N	2009-01-01 00:00:00
4210	5620	4209	nodc	taxonomy	\N	81170305	genus	\N	\N	\N	2009-01-01 00:00:00
4211	5622	4210	nodc	taxonomy	\N	8117030501	species	\N	\N	\N	2009-01-01 00:00:00
4212	5624	4210	nodc	taxonomy	\N	8117030502	species	\N	\N	\N	2009-01-01 00:00:00
4213	5626	4210	nodc	taxonomy	\N	8117030503	species	\N	\N	\N	2009-01-01 00:00:00
4214	5628	4209	nodc	taxonomy	\N	81170312	genus	\N	\N	\N	2009-01-01 00:00:00
4215	5630	4214	nodc	taxonomy	\N	8117031201	species	\N	\N	\N	2009-01-01 00:00:00
4216	5632	4209	nodc	taxonomy	\N	81170310	genus	\N	\N	\N	2009-01-01 00:00:00
4217	5634	4216	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4218	5636	4209	nodc	taxonomy	\N	81170311	genus	\N	\N	\N	2009-01-01 00:00:00
4219	5638	4218	nodc	taxonomy	\N	8117031101	species	\N	\N	\N	2009-01-01 00:00:00
4220	5640	4209	nodc	taxonomy	\N	81170303	genus	\N	\N	\N	2009-01-01 00:00:00
4221	5642	4220	nodc	taxonomy	\N	8117030302	species	\N	\N	\N	2009-01-01 00:00:00
4222	5644	4209	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4223	5646	4209	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4224	5648	4209	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4225	5650	4209	unknown	taxonomy	http://www.itis.usda.gov/	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4226	5652	4225	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4227	5654	4201	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4228	5656	4201	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4229	5658	4228	nodc	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4230	5660	4229	nodc	taxonomy	\N	8117032201	species	\N	\N	\N	2009-01-01 00:00:00
4231	5662	4201	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4232	5664	4231	nodc	taxonomy	\N	81170314	genus	\N	\N	\N	2009-01-01 00:00:00
4233	5666	4232	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4234	5668	4232	nodc	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4235	5670	4231	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4236	5672	4201	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4237	5674	4155	jana	taxonomy	\N	8106	order	\N	\N	\N	2009-01-01 00:00:00
4238	5675	4237	jana	taxonomy	\N	810702	family	\N	\N	\N	2009-01-01 00:00:00
4239	5677	4237	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4240	5679	4239	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4241	5681	4240	jana	taxonomy	\N	81070201	genus	\N	\N	\N	2009-01-01 00:00:00
4242	5683	4241	nodc	taxonomy	\N	8107020101	species	\N	\N	\N	2009-01-01 00:00:00
4243	5685	4237	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4244	5687	4243	jana	taxonomy	\N	810601	family	\N	\N	\N	2009-01-01 00:00:00
4245	5688	4244	nodc	taxonomy	\N	81060105	genus	\N	\N	\N	2009-01-01 00:00:00
4246	5690	4245	nodc	taxonomy	\N	8106010511	species	\N	\N	\N	2009-01-01 00:00:00
4247	5692	4244	lonny	\N	 Clark, Ailsa M., and Maureen E. Downey. 1992. Starfishes of the Atlantic. xxvi + 794. Chapman and Hall. New York, New York, USA	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4248	5693	4155	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4249	5694	4248	jana	taxonomy	\N	810301	family	\N	\N	\N	2009-01-01 00:00:00
4250	5696	4248	jana	taxonomy	\N	810501	family	\N	\N	\N	2009-01-01 00:00:00
4251	5698	4250	nodc	taxonomy	\N	81050101	genus	\N	\N	\N	2009-01-01 00:00:00
4252	5700	4251	nodc	taxonomy	\N	8105010101	species	\N	\N	\N	2009-01-01 00:00:00
4253	5702	4155	unknown	taxonomy	http://www.geology.uiuc.edu/~fossils/sclassif.html	\N	order	\N	\N	\N	2009-01-01 00:00:00
4254	5703	4253	jana	taxonomy	http://www.calacademy.org/research/izg/echinoderm/classify.htm	\N	family	\N	\N	\N	2009-01-01 00:00:00
4255	5705	4254	jana	taxonomy	\N	81130403	genus	\N	\N	\N	2009-01-01 00:00:00
4256	5708	4255	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4257	5710	4255	nodc	taxonomy	\N	8113040306	species	\N	\N	\N	2009-01-01 00:00:00
4258	5712	4254	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4259	5714	4258	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4260	5716	4253	jana	taxonomy	http://www.calacademy.org/research/izg/echinoderm/classify.htm	811301	family	\N	\N	\N	2009-01-01 00:00:00
4261	5718	4260	nodc	taxonomy	\N	81130102	genus	\N	\N	\N	2009-01-01 00:00:00
4262	5719	4261	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4263	5721	4260	nodc	taxonomy	\N	81130101	genus	\N	\N	\N	2009-01-01 00:00:00
4264	5722	4260	nodc	taxonomy	\N	81130103	genus	\N	\N	\N	2009-01-01 00:00:00
4265	5723	4264	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4266	5724	4264	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4267	5726	4264	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4268	5727	4264	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4269	5728	4253	unknown	taxonomy	http://www.calacademy.org/research/izg/echinoderm/classify.htm	\N	family	\N	\N	\N	2009-01-01 00:00:00
4270	5730	4269	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4271	5732	4270	unknown	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4272	5734	4253	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4273	5736	4272	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4274	5738	4154	nodc	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
4275	5740	4274	jana	taxonomy	\N	8123	order	\N	\N	\N	2009-01-01 00:00:00
4276	5743	4274	jana	taxonomy	\N	812903	family	\N	\N	\N	2009-01-01 00:00:00
4277	5745	4276	nodc	taxonomy	\N	81290310	genus	\N	\N	\N	2009-01-01 00:00:00
4278	5747	4277	nodc	taxonomy	\N	8129031003	species	\N	\N	\N	2009-01-01 00:00:00
4279	5749	4277	nodc	taxonomy	\N	8129031004	species	\N	\N	\N	2009-01-01 00:00:00
4280	5751	4274	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4281	5754	4280	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4282	5756	4281	jana	taxonomy	\N	812503	family	\N	\N	\N	2009-01-01 00:00:00
4283	5759	4282	nodc	taxonomy	\N	81250302	genus	\N	\N	\N	2009-01-01 00:00:00
4284	5761	4283	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4285	5764	4281	jana	taxonomy	\N	812501	family	\N	\N	\N	2009-01-01 00:00:00
4286	5766	4285	nodc	taxonomy	\N	81250101	genus	\N	\N	\N	2009-01-01 00:00:00
4287	5768	4286	nodc	taxonomy	\N	8125010101	species	\N	\N	\N	2009-01-01 00:00:00
4288	5770	4286	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4289	5772	4280	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4290	5774	4289	jana	taxonomy	\N	812801	family	\N	\N	\N	2009-01-01 00:00:00
4291	5776	4290	nodc	taxonomy	\N	81280110	genus	\N	\N	\N	2009-01-01 00:00:00
4292	5778	4291	nodc	taxonomy	\N	8128011005	species	\N	\N	\N	2009-01-01 00:00:00
4293	5781	4290	nodc	taxonomy	\N	81280109	genus	\N	\N	\N	2009-01-01 00:00:00
4294	5783	4293	nodc	taxonomy	\N	8128010904	species	\N	\N	\N	2009-01-01 00:00:00
4295	5786	4290	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4296	5788	4280	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4297	5790	4296	jana	taxonomy	\N	812701	family	\N	\N	\N	2009-01-01 00:00:00
4298	5792	4297	nodc	taxonomy	\N	81270104	genus	\N	\N	\N	2009-01-01 00:00:00
4299	5794	4298	nodc	taxonomy	\N	8127010404	species	\N	\N	\N	2009-01-01 00:00:00
4300	5796	4297	nodc	taxonomy	\N	81270106	genus	\N	\N	\N	2009-01-01 00:00:00
4301	5798	4300	nodc	taxonomy	\N	8127010606	species	\N	\N	\N	2009-01-01 00:00:00
4302	5800	3916	jana	taxonomy	\N	83	phylum	\N	\N	\N	2009-01-01 00:00:00
4303	5802	4302	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
4304	5803	4303	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4305	5804	4304	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4306	5805	4305	jana	taxonomy	\N	83080201	genus	\N	\N	\N	2009-01-01 00:00:00
4307	5806	4306	nodc	taxonomy	\N	8308020101	species	\N	\N	\N	2009-01-01 00:00:00
4308	5808	4304	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4309	5809	4308	jana	taxonomy	\N	83080104	genus	\N	\N	\N	2009-01-01 00:00:00
4310	5810	4309	nodc	taxonomy	\N	8308010401	species	\N	\N	\N	2009-01-01 00:00:00
4311	5812	4309	nodc	taxonomy	\N	8308010403	species	\N	\N	\N	2009-01-01 00:00:00
4312	5814	4308	jana	taxonomy	\N	83080103	genus	\N	\N	\N	2009-01-01 00:00:00
4313	5815	4312	nodc	taxonomy	\N	8308010301	species	\N	\N	\N	2009-01-01 00:00:00
4314	5818	4308	jana	taxonomy	\N	83080101	genus	\N	\N	\N	2009-01-01 00:00:00
4315	5819	4308	jana	taxonomy	\N	83080108	genus	\N	\N	\N	2009-01-01 00:00:00
4316	5820	4315	nodc	taxonomy	\N	8308010801	species	\N	\N	\N	2009-01-01 00:00:00
4317	5822	4315	nodc	taxonomy	\N	8308010803	species	\N	\N	\N	2009-01-01 00:00:00
4318	5824	4308	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4319	5825	4318	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4320	5826	4303	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4321	5827	4320	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4322	5828	4321	jana	taxonomy	\N	83060301	genus	\N	\N	\N	2009-01-01 00:00:00
4323	5829	4322	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4324	5830	4322	svonthun	\N	http://academic.evergreen.edu/t/thuesene/chaetognaths/chaetlist.htm	\N	species	\N	\N	\N	2009-01-01 00:00:00
4325	5831	4321	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4326	5832	4320	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=158686	\N	family	\N	\N	\N	2009-01-01 00:00:00
4327	5833	4326	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=158687	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4328	5834	3916	jana	taxonomy	\N	8388	phylum	\N	\N	\N	2009-01-01 00:00:00
4329	5835	4328	jana	\N	\N	\N	phylum	sub	\N	\N	2009-01-01 00:00:00
4330	5836	4329	jana	taxonomy	\N	86	class	\N	\N	\N	2009-01-01 00:00:00
4331	5838	4330	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
4332	5842	4331	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4333	5844	4332	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4334	5846	4333	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4335	5848	4334	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4336	5851	4335	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4337	5854	4330	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4338	5856	4337	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4339	5859	4338	jana	taxonomy	\N	86060101	genus	\N	\N	\N	2009-01-01 00:00:00
4340	5862	4339	nodc	taxonomy	\N	8606010101	species	\N	\N	\N	2009-01-01 00:00:00
4341	5865	4339	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4342	5868	4329	jana	taxonomy	\N	92	class	\N	\N	\N	2009-01-01 00:00:00
4343	5869	4342	nodc	taxonomy	\N	9217	class	sub	\N	\N	2009-01-01 00:00:00
4344	5872	4343	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4345	5874	4344	jana	taxonomy	\N	921802	family	\N	\N	\N	2009-01-01 00:00:00
4346	5876	4345	nodc	taxonomy	\N	92180218	genus	\N	\N	\N	2009-01-01 00:00:00
4347	5879	4346	nodc	taxonomy	\N	9218021802	species	\N	\N	\N	2009-01-01 00:00:00
4348	5880	4346	nodc	taxonomy	\N	9218021804	species	\N	\N	\N	2009-01-01 00:00:00
4349	5881	4346	nodc	taxonomy	\N	9218021803	species	\N	\N	\N	2009-01-01 00:00:00
4350	5882	4346	nodc	taxonomy	\N	9218021801	species	\N	\N	\N	2009-01-01 00:00:00
4351	5884	4345	rodgers	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4352	5885	4351	rodgers	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4353	5887	4345	nodc	taxonomy	\N	92180208	genus	\N	\N	\N	2009-01-01 00:00:00
4354	5888	4353	nodc	taxonomy	\N	9218020803	species	\N	\N	\N	2009-01-01 00:00:00
4355	5890	4345	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4356	5891	4355	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4357	5892	4345	nodc	taxonomy	\N	92180216	genus	\N	\N	\N	2009-01-01 00:00:00
4358	5893	4357	nodc	taxonomy	\N	9218021601	species	\N	\N	\N	2009-01-01 00:00:00
4359	5895	4344	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4360	5897	4359	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4361	5898	4360	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4362	5899	4343	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4363	5901	4362	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4364	5902	4363	jana	taxonomy	\N	92190101	genus	\N	\N	\N	2009-01-01 00:00:00
4365	5903	4364	nodc	taxonomy	\N	9219010101	species	\N	\N	\N	2009-01-01 00:00:00
4366	5906	4362	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4367	5907	4366	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4368	5908	4367	jana	taxonomy	\N	92190202	genus	\N	\N	\N	2009-01-01 00:00:00
4369	5909	4368	nodc	taxonomy	\N	9219020201	species	\N	\N	\N	2009-01-01 00:00:00
4370	5911	4366	jana	taxonomy	\N	92190201	genus	\N	\N	\N	2009-01-01 00:00:00
4371	5913	4370	nodc	taxonomy	\N	9219020105	species	\N	\N	\N	2009-01-01 00:00:00
4372	5915	4342	nodc	taxonomy	\N	9220	order	\N	\N	\N	2009-01-01 00:00:00
4373	5917	4372	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4374	5918	4373	jana	taxonomy	\N	92200201	genus	\N	\N	\N	2009-01-01 00:00:00
4375	5920	4374	nodc	taxonomy	\N	9220020101	species	\N	\N	\N	2009-01-01 00:00:00
4376	5921	4342	nodc	taxonomy	\N	9221	order	sub	\N	\N	2009-01-01 00:00:00
4377	5922	4376	nodc	taxonomy	\N	922103	family	\N	\N	\N	2009-01-01 00:00:00
4378	5925	4377	nodc	taxonomy	\N	92210310	genus	\N	\N	\N	2009-01-01 00:00:00
4379	5927	4378	nodc	taxonomy	\N	9221031001	species	\N	\N	\N	2009-01-01 00:00:00
4380	5928	4378	nodc	taxonomy	\N	9221031002	species	\N	\N	\N	2009-01-01 00:00:00
4381	5930	4377	nodc	taxonomy	\N	92210301	genus	\N	\N	\N	2009-01-01 00:00:00
4382	5933	4381	nodc	taxonomy	\N	9221030107	species	\N	\N	\N	2009-01-01 00:00:00
4383	5935	4376	nodc	taxonomy	\N	922101	family	\N	\N	\N	2009-01-01 00:00:00
4384	5938	4383	nodc	taxonomy	\N	92210103	genus	\N	\N	\N	2009-01-01 00:00:00
4385	5940	4384	nodc	taxonomy	\N	9221010301	species	\N	\N	\N	2009-01-01 00:00:00
4386	5941	4329	jana	taxonomy	\N	91	class	\N	\N	\N	2009-01-01 00:00:00
4387	5943	4386	nodc	taxonomy	\N	9109	order	\N	\N	\N	2009-01-01 00:00:00
4388	5946	4387	nodc	taxonomy	\N	910901	family	\N	\N	\N	2009-01-01 00:00:00
4389	5948	4388	nodc	taxonomy	\N	91090101	genus	\N	\N	\N	2009-01-01 00:00:00
4390	5951	4329	jana	taxonomy	\N	\N	class	super	\N	\N	2009-01-01 00:00:00
4391	5952	4390	jana	taxonomy	\N	\N	grade	\N	\N	\N	2009-01-01 00:00:00
4392	5953	4391	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
4393	5954	4392	rodgers	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4394	5957	4392	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
4395	5959	4394	jana	taxonomy	\N	\N	class	infra	\N	\N	2009-01-01 00:00:00
4396	5960	4395	jana	taxonomy	\N	\N	division	\N	\N	\N	2009-01-01 00:00:00
4397	5961	4396	jana	taxonomy	\N	\N	division	\N	\N	\N	2009-01-01 00:00:00
4398	5962	4397	jana	taxonomy	\N	8745	order	\N	\N	\N	2009-01-01 00:00:00
4399	5964	4398	jana	taxonomy	\N	874702	\N	\N	\N	\N	2009-01-01 00:00:00
4400	5967	4399	nodc	taxonomy	\N	87470201	genus	\N	\N	\N	2009-01-01 00:00:00
4401	5969	4400	nodc	taxonomy	\N	8747020101	species	\N	\N	\N	2009-01-01 00:00:00
4402	5972	4398	jana	taxonomy	\N	874701	family	\N	\N	\N	2009-01-01 00:00:00
4403	5975	4402	nodc	taxonomy	\N	87470103	genus	\N	\N	\N	2009-01-01 00:00:00
4404	5977	4403	nodc	taxonomy	\N	8747010301	species	\N	\N	\N	2009-01-01 00:00:00
4405	5982	4402	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4406	5984	4405	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4407	5987	4396	jana	taxonomy	\N	\N	division	\N	\N	\N	2009-01-01 00:00:00
4408	5988	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4409	5989	4408	jana	taxonomy	\N	8789	order	\N	\N	\N	2009-01-01 00:00:00
4410	5991	4409	jana	taxonomy	\N	879104	family	\N	\N	\N	2009-01-01 00:00:00
4411	5993	4410	nodc	taxonomy	\N	87910401	genus	\N	\N	\N	2009-01-01 00:00:00
4412	5995	4411	nodc	taxonomy	\N	8791040102	species	\N	\N	\N	2009-01-01 00:00:00
4413	5998	4409	jana	taxonomy	\N	879101	family	\N	\N	\N	2009-01-01 00:00:00
4414	6002	4413	nodc	taxonomy	\N	87910103	genus	\N	\N	\N	2009-01-01 00:00:00
4415	6004	4414	nodc	taxonomy	\N	8791010303	species	\N	\N	\N	2009-01-01 00:00:00
4416	6007	4413	nodc	taxonomy	\N	87910101	genus	\N	\N	\N	2009-01-01 00:00:00
4417	6008	4416	nodc	taxonomy	\N	8791010102	species	\N	\N	\N	2009-01-01 00:00:00
4418	6011	4413	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4419	6012	4409	nodc	taxonomy	\N	879103	family	\N	\N	\N	2009-01-01 00:00:00
4420	6016	4419	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4421	6019	4419	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4422	6021	4419	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4423	6023	4422	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4424	6026	4419	nodc	taxonomy	\N	87910306	genus	\N	\N	\N	2009-01-01 00:00:00
4425	6028	4424	nodc	taxonomy	\N	8791030601	species	\N	\N	\N	2009-01-01 00:00:00
4426	6031	4409	jana	taxonomy	\N	8794	order	sub	\N	\N	2009-01-01 00:00:00
4427	6032	4426	jana	taxonomy	\N	879401	family	\N	\N	\N	2009-01-01 00:00:00
4428	6035	4427	nodc	taxonomy	\N	87940108	genus	\N	\N	\N	2009-01-01 00:00:00
4429	6036	4428	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4430	6038	4428	nodc	taxonomy	\N	8794010807	species	\N	\N	\N	2009-01-01 00:00:00
4431	6040	4427	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4432	6041	4431	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4433	6043	4427	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4434	6044	4433	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4435	6046	4427	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4436	6047	4435	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4437	6050	4427	nodc	taxonomy	\N	87940101	genus	\N	\N	\N	2009-01-01 00:00:00
4438	6051	4437	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4439	6053	4437	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4440	6054	4437	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4441	6058	4437	nodc	taxonomy	\N	8794010101	species	\N	\N	\N	2009-01-01 00:00:00
4442	6062	4437	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4443	6063	4437	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4444	6065	4437	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4445	6066	4409	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4446	6068	4445	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4447	6070	4446	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4448	6073	4409	lonny	taxonomy	www.itis.usda.gov, www.calacademy.org	\N	family	\N	\N	\N	2009-01-01 00:00:00
4449	6075	4448	lonny	taxonomy	www.itis.usda.gov, www.calacademy.org	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4450	6077	4449	lonny	taxonomy	www.itis.usda.gov, www.calacademy.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4451	6079	4408	jana	taxonomy	\N	8783	order	\N	\N	\N	2009-01-01 00:00:00
4452	6081	4451	nodc	taxonomy	\N	878301	family	\N	\N	\N	2009-01-01 00:00:00
4453	6085	4452	nodc	taxonomy	\N	87830101	genus	\N	\N	\N	2009-01-01 00:00:00
4454	6087	4453	nodc	taxonomy	\N	8783010101	species	\N	\N	\N	2009-01-01 00:00:00
4455	6090	4408	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4456	6093	4455	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4457	6095	4456	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4458	6098	4457	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4459	6100	4458	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4460	6102	4455	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4461	6105	4460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4462	6108	4461	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4463	6110	4462	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4464	6112	4460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4465	6115	4464	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4466	6117	4464	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
4467	6119	4460	jana	taxonomy	\N	878804	family	\N	\N	\N	2009-01-01 00:00:00
4468	6122	4467	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4469	6124	4468	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4470	6127	4467	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4471	6129	4470	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4472	6131	4470	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4473	6133	4467	nodc	taxonomy	\N	87880402	genus	\N	\N	\N	2009-01-01 00:00:00
4474	6135	4473	nodc	taxonomy	\N	8788040201	species	\N	\N	\N	2009-01-01 00:00:00
4475	6140	4460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4476	6143	4475	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4477	6145	4476	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4478	6150	4475	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4479	6152	4478	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4480	6155	4455	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4481	6158	4480	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4482	6160	4481	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4483	6164	4481	schlin	\N	http://www.itis.gov	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4484	6165	4408	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4485	6166	4484	jana	taxonomy	California Academy of Sciences: Classification of fish families. www.calacademy.org	\N	family	\N	\N	\N	2009-01-01 00:00:00
4486	6171	4485	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4487	6173	4486	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4488	6175	4485	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4489	6177	4488	nodc	taxonomy	\N	8792012502	species	\N	\N	\N	2009-01-01 00:00:00
4490	6180	4485	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4491	6182	4485	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4492	6184	4491	nodc	taxonomy	\N	8792010101	species	\N	\N	\N	2009-01-01 00:00:00
4493	6187	4485	lonny	taxonomy	Cohen, D. M. 1963 (31 Dec.) A new genus and species of bathypelagic ophidioid fish from the western North Atlantic. Breviora No. 196: 1-8.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4494	6189	4493	lonny	taxonomy	Cohen, D. M. 1963 (31 Dec.) A new genus and species of bathypelagic ophidioid fish from the western North Atlantic. Breviora No. 196: 1-8.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4495	6191	4485	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4496	6193	4495	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4497	6196	4484	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4498	6197	4484	jana	taxonomy	\N	879201	family	\N	\N	\N	2009-01-01 00:00:00
4499	6199	4498	nodc	taxonomy	\N	87920133	genus	\N	\N	\N	2009-01-01 00:00:00
4500	6201	4499	nodc	taxonomy	\N	8792013301	species	\N	\N	\N	2009-01-01 00:00:00
4501	6204	4498	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4502	6206	4501	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4503	6209	4498	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4504	6211	4503	jana	taxonomy	MBARI video specimen identified by Daniel M. Cohen (Ophidiid expert).	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4505	6213	4503	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4506	6215	4503	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4507	6217	4506	jana	taxonomy	FAO Species Catalogue Vol. 18, Ophidiiformes 1999	\N	species	\N	\N	\N	2009-01-01 00:00:00
4508	6219	4498	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4509	6221	4508	jana	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4510	6224	4498	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4511	6226	4510	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4512	6229	4498	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4513	6231	4512	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4514	6235	4498	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4515	6236	4514	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4516	6237	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4517	6238	4516	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4518	6240	4517	jana	taxonomy	\N	875901	family	\N	\N	\N	2009-01-01 00:00:00
4519	6243	4518	nodc	taxonomy	\N	87590101	genus	\N	\N	\N	2009-01-01 00:00:00
4520	6245	4519	nodc	taxonomy	\N	8759010108	species	\N	\N	\N	2009-01-01 00:00:00
4521	6248	4519	nodc	taxonomy	\N	8759010104	species	\N	\N	\N	2009-01-01 00:00:00
4522	6251	4519	nodc	taxonomy	\N	8759010103	species	\N	\N	\N	2009-01-01 00:00:00
4523	6255	4517	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4524	6258	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4525	6261	4524	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4526	6263	4525	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4527	6265	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4528	6268	4527	jana	taxonomy	\N	87590801	genus	\N	\N	\N	2009-01-01 00:00:00
4529	6270	4528	nodc	taxonomy	\N	8759080102	species	\N	\N	\N	2009-01-01 00:00:00
4530	6273	4528	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4531	6277	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4532	6280	4531	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4533	6282	4532	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4534	6284	4531	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4535	6286	4534	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4536	6289	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4537	6293	4536	jana	taxonomy	\N	87590402	genus	\N	\N	\N	2009-01-01 00:00:00
4538	6295	4537	nodc	taxonomy	\N	8759040201	species	\N	\N	\N	2009-01-01 00:00:00
4539	6298	4537	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4540	6300	4536	jana	taxonomy	\N	87590403	genus	\N	\N	\N	2009-01-01 00:00:00
4541	6302	4540	nodc	taxonomy	\N	8759040301	species	\N	\N	\N	2009-01-01 00:00:00
4542	6305	4536	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4543	6307	4542	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4544	6310	4536	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4545	6312	4544	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4546	6315	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4547	6318	4546	jana	taxonomy	\N	87590601	genus	\N	\N	\N	2009-01-01 00:00:00
4548	6320	4547	nodc	taxonomy	\N	8759060101	species	\N	\N	\N	2009-01-01 00:00:00
4549	6323	4523	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4550	6326	4549	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4551	6328	4550	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4552	6331	4517	jana	taxonomy	\N	875902	family	\N	\N	\N	2009-01-01 00:00:00
4553	6335	4552	nodc	taxonomy	\N	87590203	genus	\N	\N	\N	2009-01-01 00:00:00
4554	6338	4553	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4555	6343	4553	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4556	6346	4552	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4557	6348	4556	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4558	6352	4552	nodc	taxonomy	\N	87590201	genus	\N	\N	\N	2009-01-01 00:00:00
4559	6355	4558	jana	taxonomy	\N	8759020101	species	\N	\N	\N	2009-01-01 00:00:00
4560	6359	4558	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4561	6363	4558	nodc	taxonomy	\N	8759020103	species	\N	\N	\N	2009-01-01 00:00:00
4562	6368	4558	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4563	6374	4517	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4564	6377	4563	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4565	6379	4564	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4566	6382	4563	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4567	6384	4566	lonny	taxonomy	www.itis.usda.gov, www.fishbase.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4568	6386	4566	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4569	6389	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4570	6390	4569	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4571	6392	4570	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4572	6395	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4573	6396	4572	jana	taxonomy	\N	8762	order	\N	\N	\N	2009-01-01 00:00:00
4574	6398	4573	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4575	6401	4574	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4576	6403	4575	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4577	6407	4574	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4578	6409	4577	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4579	6412	4573	nodc	taxonomy	\N	876214	family	\N	\N	\N	2009-01-01 00:00:00
4580	6415	4579	nodc	taxonomy	\N	87621402	genus	\N	\N	\N	2009-01-01 00:00:00
4581	6417	4580	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
4582	6420	4580	nodc	taxonomy	\N	8762140201	species	\N	\N	\N	2009-01-01 00:00:00
4583	6423	4580	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4584	6427	4580	lonny	taxonomy	www.calacademy.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4585	6429	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4586	6431	4585	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4587	6434	4585	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4588	6437	4579	nodc	taxonomy	\N	87621405	genus	\N	\N	\N	2009-01-01 00:00:00
4589	6439	4588	nodc	taxonomy	\N	8762140501	species	\N	\N	\N	2009-01-01 00:00:00
4590	6442	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4591	6444	4590	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4592	6447	4579	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4593	6451	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4594	6453	4593	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4595	6456	4579	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4596	6458	4595	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
4597	6461	4579	lonny	taxonomy	www.itis.usda.gov, www.calacademy.org	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4598	6463	4597	lonny	taxonomy	www.calacademy.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4599	6465	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4600	6467	4599	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4601	6470	4579	nodc	taxonomy	\N	87621410	genus	\N	\N	\N	2009-01-01 00:00:00
4602	6472	4601	nodc	taxonomy	\N	8762141001	species	\N	\N	\N	2009-01-01 00:00:00
4603	6476	4601	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4604	6479	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4605	6481	4579	nodc	taxonomy	\N	87621403	genus	\N	\N	\N	2009-01-01 00:00:00
4606	6483	4605	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4607	6486	4605	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4608	6488	4605	nodc	taxonomy	\N	8762140303	species	\N	\N	\N	2009-01-01 00:00:00
4609	6491	4605	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4610	6494	4605	nodc	taxonomy	\N	8762140302	species	\N	\N	\N	2009-01-01 00:00:00
4611	6497	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4612	6499	4611	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4613	6502	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4614	6504	4613	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4615	6508	4579	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4616	6511	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4617	6513	4579	nodc	taxonomy	\N	87621424	genus	\N	\N	\N	2009-01-01 00:00:00
4618	6515	4617	nodc	taxonomy	\N	8762142401	species	\N	\N	\N	2009-01-01 00:00:00
4619	6518	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4620	6520	4619	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4621	6523	4579	nodc	taxonomy	\N	87621407	genus	\N	\N	\N	2009-01-01 00:00:00
4622	6525	4621	nodc	taxonomy	\N	8762140701	species	\N	\N	\N	2009-01-01 00:00:00
4623	6528	4621	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4624	6530	4579	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4625	6532	4624	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4626	6535	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4627	6536	4626	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4628	6538	4627	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4629	6540	4628	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4630	6543	4626	jana	taxonomy	\N	8815	order	sub	\N	\N	2009-01-01 00:00:00
4631	6545	4630	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4632	6548	4631	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4633	6550	4632	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4634	6553	4631	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4635	6555	4634	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4636	6560	4630	nodc	taxonomy	\N	881502	family	\N	\N	\N	2009-01-01 00:00:00
4637	6563	4636	nodc	taxonomy	\N	88150201	genus	\N	\N	\N	2009-01-01 00:00:00
4638	6565	4637	nodc	taxonomy	\N	8815020101	species	\N	\N	\N	2009-01-01 00:00:00
4639	6568	4636	nodc	taxonomy	\N	88150202	genus	\N	\N	\N	2009-01-01 00:00:00
4640	6570	4639	nodc	taxonomy	\N	8815020202	species	\N	\N	\N	2009-01-01 00:00:00
4641	6573	4630	nodc	taxonomy	\N	881503	family	\N	\N	\N	2009-01-01 00:00:00
4642	6575	4641	nodc	taxonomy	\N	88150301	genus	\N	\N	\N	2009-01-01 00:00:00
4643	6577	4642	nodc	taxonomy	\N	8815030101	species	\N	\N	\N	2009-01-01 00:00:00
4644	6580	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4645	6581	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4646	6582	4645	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4647	6583	4646	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4648	6586	4647	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4649	6588	4648	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4650	6590	4646	jana	taxonomy	Catalog of Fishes, California Academy of Sciences; Fishbase	\N	family	\N	\N	\N	2009-01-01 00:00:00
4651	6591	4650	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4652	6593	4646	jana	taxonomy	\N	876202	family	\N	\N	\N	2009-01-01 00:00:00
4653	6596	4652	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4654	6598	4653	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4655	6601	4652	nodc	taxonomy	\N	87620201	genus	\N	\N	\N	2009-01-01 00:00:00
4656	6603	4655	nodc	taxonomy	\N	8762020103	species	\N	\N	\N	2009-01-01 00:00:00
4657	6606	4646	jana	taxonomy	\N	876209	family	\N	\N	\N	2009-01-01 00:00:00
4658	6608	4657	nodc	taxonomy	\N	87620901	genus	\N	\N	\N	2009-01-01 00:00:00
4659	6610	4658	nodc	taxonomy	\N	8762090102	species	\N	\N	\N	2009-01-01 00:00:00
4660	6613	4646	jana	taxonomy	\N	876207	family	\N	\N	\N	2009-01-01 00:00:00
4661	6616	4660	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4662	6618	4661	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4663	6622	4660	nodc	taxonomy	\N	87620701	genus	\N	\N	\N	2009-01-01 00:00:00
4664	6624	4660	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4665	6626	4664	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4666	6630	4660	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4667	6632	4666	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
4668	6635	4660	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4669	6637	4668	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4670	6640	4668	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4671	6644	4660	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4672	6646	4671	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4673	6649	4646	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4674	6652	4673	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4675	6654	4674	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4676	6658	4646	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4677	6662	4676	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4678	6664	4677	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4679	6667	4646	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4680	6668	4679	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4681	6670	4680	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4682	6673	4646	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4683	6676	4682	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4684	6678	4683	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4685	6681	4683	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4686	6684	4682	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4687	6686	4686	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4688	6690	4646	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4689	6694	4688	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4690	6697	4689	schlin	\N	http://www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4691	6699	4689	schlin	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4692	6701	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
4693	6702	4692	jana	taxonomy	\N	8834	order	\N	\N	\N	2009-01-01 00:00:00
4694	6705	4693	jana	taxonomy	\N	8842	order	sub	\N	\N	2009-01-01 00:00:00
4695	6707	4694	nodc	taxonomy	\N	884201	family	\N	\N	\N	2009-01-01 00:00:00
4696	6712	4693	jana	taxonomy	\N	8793	order	sub	\N	\N	2009-01-01 00:00:00
4697	6714	4696	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4698	6717	4697	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4699	6719	4698	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4700	6722	4698	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4701	6725	4696	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4702	6728	4701	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4703	6730	4702	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4704	6733	4701	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4705	6735	4704	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4706	6738	4696	nodc	taxonomy	\N	879301	family	\N	\N	\N	2009-01-01 00:00:00
4707	6742	4706	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4708	6744	4707	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4709	6747	4706	nodc	taxonomy	\N	87930118	genus	\N	\N	\N	2009-01-01 00:00:00
4710	6749	4706	nodc	taxonomy	\N	87930109	genus	\N	\N	\N	2009-01-01 00:00:00
4711	6751	4710	jana	taxonomy	\N	8793010901	species	\N	\N	\N	2009-01-01 00:00:00
4712	6754	4706	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4713	6756	4712	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4714	6759	4706	nodc	taxonomy	\N	87930102	genus	\N	\N	\N	2009-01-01 00:00:00
4715	6761	4714	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4716	6764	4714	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4717	6767	4706	nodc	taxonomy	\N	87930117	genus	\N	\N	\N	2009-01-01 00:00:00
4718	6769	4717	nodc	taxonomy	\N	8793011701	species	\N	\N	\N	2009-01-01 00:00:00
4719	6772	4706	nodc	taxonomy	\N	87930107	genus	\N	\N	\N	2009-01-01 00:00:00
4720	6774	4719	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4721	6777	4719	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4722	6781	4719	nodc	taxonomy	\N	8793010706	species	\N	\N	\N	2009-01-01 00:00:00
4723	6784	4719	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4724	6787	4706	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4725	6789	4706	nodc	taxonomy	\N	87930101	genus	\N	\N	\N	2009-01-01 00:00:00
4726	6791	4706	nodc	taxonomy	\N	87930108	genus	\N	\N	\N	2009-01-01 00:00:00
4727	6793	4706	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4728	6795	4727	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4729	6798	4727	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4730	6802	4727	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4731	6805	4706	nodc	taxonomy	\N	87930106	genus	\N	\N	\N	2009-01-01 00:00:00
4732	6807	4731	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4733	6810	4731	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4734	6813	4731	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4735	6815	4731	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4736	6819	4731	nodc	taxonomy	\N	8793010604	species	\N	\N	\N	2009-01-01 00:00:00
4737	6822	4706	lonny	taxonomy	Anderson, M.E., 1994. Systematics and osteology of the Zoarcidae (Teleostei: Perciformes).. Ichthyol. Bull. J.L.B. Smith Inst. Ichthyol. (60):1-120.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4738	6824	4737	lonny	taxonomy	Anderson, M.E., 1994. Systematics and osteology of the Zoarcidae (Teleostei: Perciformes).. Ichthyol. Bull. J.L.B. Smith Inst. Ichthyol. (60):1-120.	\N	species	\N	\N	\N	2009-01-01 00:00:00
4776	6922	4775	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4777	6925	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4778	6928	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4779	6933	4778	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4780	6935	4779	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4781	6939	4778	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4782	6941	4781	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4783	6944	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4784	6947	4783	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4785	6949	4784	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4786	6952	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4787	6955	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4788	6958	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4789	6961	4788	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4790	6963	4789	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4791	6965	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4792	6969	4791	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4793	6971	4792	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4794	6974	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4795	6977	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4796	6980	4795	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4797	6982	4796	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4798	6985	4756	jana	taxonomy	\N	883544	family	\N	\N	\N	2009-01-01 00:00:00
4799	6990	4798	nodc	taxonomy	\N	88354401	genus	\N	\N	\N	2009-01-01 00:00:00
4800	6994	4798	nodc	taxonomy	\N	88354402	genus	\N	\N	\N	2009-01-01 00:00:00
4801	6996	4800	nodc	taxonomy	\N	8835440201	species	\N	\N	\N	2009-01-01 00:00:00
4802	6999	4798	nodc	taxonomy	\N	88354429	genus	\N	\N	\N	2009-01-01 00:00:00
4803	7001	4802	nodc	taxonomy	\N	8835442901	species	\N	\N	\N	2009-01-01 00:00:00
4804	7005	4798	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4805	7007	4804	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4806	7011	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4807	7014	4806	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4808	7016	4807	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4809	7019	4806	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4810	7021	4809	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4811	7024	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4812	7027	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4813	7031	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4814	7034	4813	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4815	7036	4814	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4816	7039	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4817	7042	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4818	7045	4756	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4819	7049	4818	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4820	7051	4819	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4821	7054	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4822	7056	4821	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4823	7060	4821	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4824	7063	4823	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4825	7065	4824	lonny	taxonomy	fishBase, www.fishbase.org, ITIS, www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4826	7067	4821	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4827	7070	4826	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4828	7072	4827	lonny	taxonomy	Cal Academy Catalog of Fishes, www.calacademy.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4829	7075	4693	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4830	7077	4829	jana	taxonomy	\N	883560	family	\N	\N	\N	2009-01-01 00:00:00
4831	7080	4830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4832	7082	4830	jana	taxonomy	\N	88356011	genus	\N	\N	\N	2009-01-01 00:00:00
4833	7084	4832	nodc	taxonomy	\N	8835601101	species	\N	\N	\N	2009-01-01 00:00:00
4834	7087	4830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4835	7089	4830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4836	7091	4830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4837	7093	4830	nodc	taxonomy	\N	88356001	genus	\N	\N	\N	2009-01-01 00:00:00
4838	7095	4837	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4839	7098	4829	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4840	7101	4829	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4841	7105	4829	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4842	7108	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4843	7110	4842	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4844	7113	4843	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4845	7115	4842	jana	taxonomy	\N	885101	family	\N	\N	\N	2009-01-01 00:00:00
4846	7118	4845	nodc	taxonomy	\N	88510101	genus	\N	\N	\N	2009-01-01 00:00:00
4847	7120	4846	nodc	taxonomy	\N	8851010101	species	\N	\N	\N	2009-01-01 00:00:00
4848	7124	4842	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4849	7127	4848	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4850	7129	4849	lonny	taxonomy	ITIS, Fish Base	\N	species	\N	\N	\N	2009-01-01 00:00:00
4851	7132	4842	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4852	7135	4851	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4853	7137	4852	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4854	7141	4842	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4855	7145	4854	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4856	7147	4855	lonny	taxonomy	fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4857	7150	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4858	7152	4857	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4859	7155	4858	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4860	7157	4859	lonny	taxonomy	fishbase, itis	\N	species	\N	\N	\N	2009-01-01 00:00:00
4861	7160	4858	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4862	7162	4861	lonny	taxonomy	Cal Academy, Fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4863	7165	4858	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4864	7167	4863	lonny	taxonomy	FishBase, Cal Academy, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4865	7171	4858	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4866	7173	4865	lonny	taxonomy	fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4867	7176	4857	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4868	7179	4857	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4869	7183	4857	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4870	7188	4857	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4871	7191	4870	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4872	7193	4871	lonny	taxonomy	fishbase; itis	\N	species	\N	\N	\N	2009-01-01 00:00:00
4873	7196	4870	lonny	taxonomy	ITIS, Fish Base	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4874	7198	4870	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4875	7200	4874	lonny	taxonomy	fishbase, ITIS	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4876	7204	4870	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4877	7206	4876	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4878	7210	4876	lonny	taxonomy	ITIS, FishBase	\N	species	\N	\N	\N	2009-01-01 00:00:00
4879	7215	4870	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4880	7217	4870	lonny	taxonomy	fishbase, ITIS	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4881	7218	4880	lonny	taxonomy	FishBase; ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4882	7221	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4883	7223	4882	jana	taxonomy	\N	883701	family	\N	\N	\N	2009-01-01 00:00:00
4884	7226	4883	nodc	taxonomy	\N	88370101	genus	\N	\N	\N	2009-01-01 00:00:00
4885	7228	4884	nodc	taxonomy	\N	8837010101	species	\N	\N	\N	2009-01-01 00:00:00
4886	7232	4693	jana	taxonomy	\N	8847	order	sub	\N	\N	2009-01-01 00:00:00
4887	7234	4886	nodc	taxonomy	\N	884701	family	\N	\N	\N	2009-01-01 00:00:00
4888	7237	4887	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4889	7239	4888	lonny	taxonomy	ITIS, www.itis.usda.gov, fishBase, www.fishbase.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4890	7242	4887	nodc	taxonomy	\N	88470102	genus	\N	\N	\N	2009-01-01 00:00:00
4891	7244	4890	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4892	7247	4693	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4893	7249	4892	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4894	7251	4893	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4895	7253	4894	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4896	7256	4693	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4897	7258	4896	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4898	7261	4897	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4899	7263	4898	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4900	7266	4896	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4901	7269	4900	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4902	7271	4901	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4903	7274	4896	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4904	7277	4903	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4905	7279	4904	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4906	7282	4896	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4907	7285	4906	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4908	7287	4907	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4909	7290	4907	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4910	7293	4906	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4911	7295	4910	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4912	7298	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4913	7304	4912	nodc	taxonomy	\N	885704	family	\N	\N	\N	2009-01-01 00:00:00
4914	7309	4913	lonny	taxonomy	fishbase.org, www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4915	7311	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4916	7313	4915	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4917	7316	4913	nodc	taxonomy	\N	88570404	genus	\N	\N	\N	2009-01-01 00:00:00
4918	7318	4917	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4919	7321	4913	nodc	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4920	7323	4919	jana	taxonomy	Cooper, J. Andrew, and FranÁois Chapleau. 1998. Monophyly and intrarelationships of the family Pleuronectidae (Pleuronectiformes), with a revised classification. Fishery Bulletin, vol. 96, no. 4. 686-726.	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4921	7327	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4922	7329	4921	lonny	taxonomy	ITIS, Fish Base	\N	species	\N	\N	\N	2009-01-01 00:00:00
4923	7332	4921	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4924	7335	4921	lonny	taxonomy	fishbase, itis	\N	species	\N	\N	\N	2009-01-01 00:00:00
4925	7338	4921	lonny	taxonomy	fishbase.org, www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
4926	7342	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4927	7344	4926	lonny	taxonomy	fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4928	7347	4913	nodc	taxonomy	\N	88570401	genus	\N	\N	\N	2009-01-01 00:00:00
4929	7349	4928	jana	taxonomy	www.fishbase.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
4930	7354	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4931	7356	4930	lonny	taxonomy	fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4932	7359	4913	lonny	taxonomy	www.fishbase.org	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4933	7362	4932	lonny	taxonomy	Cooper and Chapleau, 1998	\N	species	\N	\N	\N	2009-01-01 00:00:00
4934	7365	4932	lonny	taxonomy	Cooper and Chapleau, 1998	\N	species	\N	\N	\N	2009-01-01 00:00:00
4935	7369	4913	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4936	7371	4935	lonny	taxonomy	Northeast Pacific Flatfishes, Kramer, et. al, Alaska Dept. of Fish and Game, www.fishbase.org, www.itis.usda.gov	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4937	7375	4913	nodc	taxonomy	\N	88570412	genus	\N	\N	\N	2009-01-01 00:00:00
4938	7376	4937	nodc	taxonomy	\N	8857041201	species	\N	\N	\N	2009-01-01 00:00:00
4939	7379	4937	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4940	7385	4913	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4941	7387	4940	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4942	7391	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4943	7393	4942	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4944	7396	4913	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4945	7398	4944	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4946	7401	4912	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4947	7404	4946	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4948	7406	4947	lonny	taxonomy	Fish Base	\N	species	\N	\N	\N	2009-01-01 00:00:00
4949	7409	4946	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4950	7411	4949	lonny	taxonomy	Fishbase, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4951	7414	4946	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4952	7416	4951	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4953	7419	4912	nodc	taxonomy	\N	885703	family	\N	\N	\N	2009-01-01 00:00:00
4954	7422	4953	nodc	taxonomy	\N	88570301	genus	\N	\N	\N	2009-01-01 00:00:00
4955	7425	4954	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
4956	7428	4954	nodc	taxonomy	\N	8857030101	species	\N	\N	\N	2009-01-01 00:00:00
4957	7431	4912	nodc	taxonomy	\N	885802	family	\N	\N	\N	2009-01-01 00:00:00
4958	7435	4957	nodc	taxonomy	\N	88580201	genus	\N	\N	\N	2009-01-01 00:00:00
4959	7437	4958	nodc	taxonomy	\N	8858020116	species	\N	\N	\N	2009-01-01 00:00:00
4960	7440	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4961	7442	4960	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4962	7445	4961	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4963	7447	4962	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4964	7449	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
4965	7451	4964	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4966	7454	4964	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4967	7457	4692	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4968	7459	4967	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4969	7462	4968	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4970	7464	4969	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4971	7467	4967	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4972	7471	4971	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
4973	7473	4972	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4974	7475	4973	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4975	7479	4967	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
4976	7481	4975	jana	taxonomy	\N	881004	family	\N	\N	\N	2009-01-01 00:00:00
4977	7484	4976	nodc	taxonomy	\N	88100401	genus	\N	\N	\N	2009-01-01 00:00:00
4978	7486	4977	nodc	taxonomy	\N	8810040101	species	\N	\N	\N	2009-01-01 00:00:00
4979	7490	4692	jana	taxonomy	\N	8825	order	\N	\N	\N	2009-01-01 00:00:00
4980	7493	4979	jana	taxonomy	\N	882703	family	\N	\N	\N	2009-01-01 00:00:00
4981	7495	4980	nodc	taxonomy	\N	88270301	genus	\N	\N	\N	2009-01-01 00:00:00
4982	7497	4981	nodc	taxonomy	\N	8827030102	species	\N	\N	\N	2009-01-01 00:00:00
4983	7500	4981	nodc	taxonomy	\N	8827030101	species	\N	\N	\N	2009-01-01 00:00:00
4984	7503	4979	jana	taxonomy	\N	8831	order	\N	\N	\N	2009-01-01 00:00:00
4985	7505	4984	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
4986	7507	4985	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
4987	7509	4986	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4988	7512	4984	jana	taxonomy	\N	883102	family	\N	\N	\N	2009-01-01 00:00:00
4989	7516	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4990	7518	4989	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4991	7521	4988	jana	taxonomy	\N	88310216	genus	\N	\N	\N	2009-01-01 00:00:00
4992	7523	4991	nodc	taxonomy	\N	8831021604	species	\N	\N	\N	2009-01-01 00:00:00
4993	7526	4991	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4994	7529	4991	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4995	7532	4991	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4996	7535	4991	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4997	7538	4991	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
4998	7541	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
4999	7543	4998	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5000	7546	4998	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5001	7549	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5002	7551	5001	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5003	7554	5001	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5004	7557	4988	jana	taxonomy	\N	88310231	genus	\N	\N	\N	2009-01-01 00:00:00
5005	7559	5004	nodc	taxonomy	\N	8831023101	species	\N	\N	\N	2009-01-01 00:00:00
5006	7562	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5007	7564	5006	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5008	7567	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5009	7569	5008	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5010	7572	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5011	7574	5010	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5012	7577	5010	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5013	7580	4988	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5014	7582	5013	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5015	7585	4984	lonny	taxonomy	Nelson, J.S., 1994. Fishes of the world. 3rd ed.. John Wiley & Sons, Inc. New York. 600 p.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5016	7590	5015	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5017	7592	5016	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5018	7595	5016	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5019	7598	5015	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5020	7600	5019	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5021	7602	5019	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5022	7605	5015	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5023	7607	5022	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5024	7610	5015	jana	taxonomy	\N	88310902	genus	\N	\N	\N	2009-01-01 00:00:00
5025	7612	5024	lonny	taxonomy	www.fishbase.org, Masuda, H., K. Amaoka, C. Araga, T. Uyeno and T. Yoshino, 1984. The fishes of the Japanese Archipelago.. Vol. 1 (text). Tokai University Press, Tokyo, Japan. 437 p. (text), 370 pls.	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5026	7614	5024	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5027	7617	5024	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5028	7620	5024	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5029	7624	5024	lonny	taxonomy	www.fishbase.org, Stein, D.L., 1978. A review of the deepwater Liparidae (Pisces) from the coast of Oregon and adjacent waters.. Proc. Cal. Acad. Sci. 127:55.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5030	7626	5024	nodc	taxonomy	\N	8831090215	species	\N	\N	\N	2009-01-01 00:00:00
5031	7629	5024	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5032	7632	5024	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5033	7634	5015	lonny	taxonomy	www.fishbase.org, Diagnoses of new genera and species of South African marine fishes. Ann. Mag. Nat. Hist. (Ser. 9) 66-79	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5034	7636	5033	lonny	taxonomy	www.fishbase.org, Chernova, N.V. and D.L. Stein, 2002. Ten new species of Psednos (Pisces, Scorpaeniformes: Liparidae) from the Pacific and North Atlantic oceans.. Copeia 2002(3):755-778.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5035	7638	5015	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5036	7640	5035	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5037	7642	5015	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5038	7644	5037	lonny	taxonomy	www.fishbase.org, Masuda, H., K. Amaoka, C. Araga, T. Uyeno and T. Yoshino, 1984. The fishes of the Japanese Archipelago.. Vol. 1 (text). Tokai University Press, Tokyo, Japan. 437 p. (text), 370 pls.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5039	7647	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5040	7650	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5041	7653	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5042	7656	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5043	7659	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5044	7662	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5045	7665	5037	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5046	7668	5037	lonny	taxonomy	www.fishbase.org, Stein, D.L., 1978. A review of the deepwater Liparidae (Pisces) from the coast of Oregon and adjacent waters.. Proc. Cal. Acad. Sci. 127:55.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5047	7670	5015	jana	taxonomy	\N	88310910	genus	\N	\N	\N	2009-01-01 00:00:00
5048	7672	5047	nodc	taxonomy	\N	8831091001	species	\N	\N	\N	2009-01-01 00:00:00
5049	7675	5015	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5050	7677	5049	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5051	7680	5049	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5052	7683	5015	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5053	7684	5015	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5054	7685	4984	nodc	taxonomy	\N	883108	family	\N	\N	\N	2009-01-01 00:00:00
5055	7690	5054	nodc	taxonomy	\N	88310810	genus	\N	\N	\N	2009-01-01 00:00:00
5056	7692	5055	nodc	taxonomy	\N	8831081001	species	\N	\N	\N	2009-01-01 00:00:00
5057	7695	5054	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5058	7697	5057	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5059	7701	5057	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5060	7704	5057	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5061	7708	5057	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5062	7712	5054	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5063	7714	5062	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5064	7717	5062	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5065	7720	5062	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5066	7723	5054	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5067	7725	5066	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5068	7728	5054	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5069	7730	5068	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5070	7733	5054	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5071	7735	5070	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5072	7738	5070	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5073	7741	4984	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5074	7744	5073	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5075	7746	5074	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5076	7749	4984	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5077	7751	5076	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5078	7753	5077	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5079	7756	5076	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5080	7758	5079	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5081	7761	4984	nodc	taxonomy	\N	883109	family	\N	\N	\N	2009-01-01 00:00:00
5082	7763	5081	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5083	7767	4979	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5084	7768	4979	nodc	taxonomy	\N	8826	order	sub	\N	\N	2009-01-01 00:00:00
5085	7769	5084	nodc	taxonomy	\N	882601	family	\N	\N	\N	2009-01-01 00:00:00
5086	7775	5085	nodc	taxonomy	\N	88260101	genus	\N	\N	\N	2009-01-01 00:00:00
5087	7780	5086	nodc	taxonomy	\N	8826010111	species	\N	\N	\N	2009-01-01 00:00:00
5088	7782	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5089	7785	5086	nodc	taxonomy	\N	8826010124	species	\N	\N	\N	2009-01-01 00:00:00
5090	7788	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5091	7791	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5092	7794	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5093	7797	5086	nodc	taxonomy	\N	8826010117	species	\N	\N	\N	2009-01-01 00:00:00
5094	7800	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5095	7803	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5096	7806	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5097	7809	5086	nodc	taxonomy	\N	8826010125	species	\N	\N	\N	2009-01-01 00:00:00
5098	7812	5086	nodc	taxonomy	\N	8826010102	species	\N	\N	\N	2009-01-01 00:00:00
5099	7814	5086	nodc	taxonomy	\N	8826010134	species	\N	\N	\N	2009-01-01 00:00:00
5100	7818	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5101	7821	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5102	7824	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5103	7827	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5104	7830	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5105	7833	5086	nodc	taxonomy	\N	8826010158	species	\N	\N	\N	2009-01-01 00:00:00
5106	7836	5086	nodc	taxonomy	\N	8826010127	species	\N	\N	\N	2009-01-01 00:00:00
5107	7839	5086	nodc	taxonomy	\N	8826010135	species	\N	\N	\N	2009-01-01 00:00:00
5108	7842	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5109	7845	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5110	7848	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5111	7851	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5112	7854	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5113	7857	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5114	7860	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5115	7863	5086	nodc	taxonomy	\N	8826010155	species	\N	\N	\N	2009-01-01 00:00:00
5116	7866	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5117	7869	5086	nodc	taxonomy	\N	8826010149	species	\N	\N	\N	2009-01-01 00:00:00
5118	7872	5086	nodc	taxonomy	\N	8826010104	species	\N	\N	\N	2009-01-01 00:00:00
5119	7875	5086	nodc	taxonomy	\N	8826010133	species	\N	\N	\N	2009-01-01 00:00:00
5120	7877	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5121	7880	5086	nodc	taxonomy	\N	8826010156	species	\N	\N	\N	2009-01-01 00:00:00
5122	7883	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5123	7886	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5124	7889	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5125	7892	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5126	7895	5086	lonny	taxonomy	Rocha-Olivares, A., R. H. Rosenblatt, and R. D. Vetter. 1999. Molecular evolution, systematics, and zoogeography of the rockfish subgenus Sebastomus (Sebastes, Scorpaenidae) based on mitochondrial cytochrome b and control region sequences. Mol. Phylogenet. Evol. 11(3):441-458.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5127	7897	5126	jana	taxonomy	\N	8826010132	species	\N	\N	\N	2009-01-01 00:00:00
5128	7900	5126	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5129	7903	5126	jana	taxonomy	www.fisbase.org, Love, M., Yoklavich, M., and Thorsteinson, L.. The rockfishes of the northeast pacific. University of California Press. Berkely, CA. 2002.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5130	7906	5126	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5131	7909	5126	jana	taxonomy	\N	8826010118	species	\N	\N	\N	2009-01-01 00:00:00
5132	7912	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5133	7915	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5134	7918	5086	nodc	taxonomy	\N	8826010122	species	\N	\N	\N	2009-01-01 00:00:00
5135	7921	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5136	7924	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5137	7927	5086	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5138	7930	5086	nodc	taxonomy	\N	8826010105	species	\N	\N	\N	2009-01-01 00:00:00
5139	7933	5086	nodc	taxonomy	\N	8826010110	species	\N	\N	\N	2009-01-01 00:00:00
5140	7936	5086	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5141	7937	5085	nodc	taxonomy	\N	88260102	genus	\N	\N	\N	2009-01-01 00:00:00
5142	7939	5141	nodc	taxonomy	\N	8826010202	species	\N	\N	\N	2009-01-01 00:00:00
5143	7941	5141	nodc	taxonomy	\N	8826010201	species	\N	\N	\N	2009-01-01 00:00:00
5144	7943	4979	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5145	7944	5144	jana	taxonomy	\N	882702	family	\N	\N	\N	2009-01-01 00:00:00
5146	7946	5145	nodc	taxonomy	\N	88270201	genus	\N	\N	\N	2009-01-01 00:00:00
5147	7948	5146	nodc	taxonomy	\N	8827020101	species	\N	\N	\N	2009-01-01 00:00:00
5148	7952	5145	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5149	7954	5148	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5150	7957	4979	nodc	taxonomy	\N	8827	order	sub	\N	\N	2009-01-01 00:00:00
5151	7958	5150	nodc	taxonomy	\N	882701	family	\N	\N	\N	2009-01-01 00:00:00
5152	7961	5151	nodc	taxonomy	\N	88270101	genus	\N	\N	\N	2009-01-01 00:00:00
5153	7963	5152	jana	taxonomy	\N	8827010101	species	\N	\N	\N	2009-01-01 00:00:00
5154	7966	5152	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5155	7969	5151	nodc	taxonomy	\N	88270103	genus	\N	\N	\N	2009-01-01 00:00:00
5156	7971	5155	nodc	taxonomy	\N	8827010301	species	\N	\N	\N	2009-01-01 00:00:00
5157	7975	5151	nodc	taxonomy	\N	88270102	genus	\N	\N	\N	2009-01-01 00:00:00
5158	7977	5157	nodc	taxonomy	\N	8827010201	species	\N	\N	\N	2009-01-01 00:00:00
5159	7980	4979	jana	\N	http://research.calacademy.org/research/ichthyology/catalog/classif.html	\N	order	sub	\N	\N	2009-01-01 00:00:00
5160	7981	5159	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5161	7983	5159	jana	\N	http://www.fishbase.org/Summary/FamilySummary.cfm?ID=581	\N	family	\N	\N	\N	2009-01-01 00:00:00
5162	7986	5161	schlin	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5163	7987	5162	schlin	\N	http://www.fishbase.org/Summary/speciesSummary.php?ID=24029&genusname=Satyrichthys&speciesname=hians	\N	species	\N	\N	\N	2009-01-01 00:00:00
5164	7988	4692	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5165	7990	5164	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5166	7994	5165	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5167	7996	5166	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5168	7999	5165	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5169	8001	5168	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5170	8004	5168	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5171	8007	5165	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5172	8009	5171	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5173	8012	5165	jana	taxonomy	\N	88080202	genus	\N	\N	\N	2009-01-01 00:00:00
5174	8014	5173	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5175	8018	5173	nodc	taxonomy	\N	8808020201	species	\N	\N	\N	2009-01-01 00:00:00
5176	8021	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5177	8023	5176	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5178	8025	5177	jana	taxonomy	\N	880301	family	\N	\N	\N	2009-01-01 00:00:00
5179	8029	5178	nodc	taxonomy	\N	88030101	genus	\N	\N	\N	2009-01-01 00:00:00
5180	8031	5179	nodc	taxonomy	\N	8803010107	species	\N	\N	\N	2009-01-01 00:00:00
5181	8034	5176	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5182	8037	5181	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5183	8039	5182	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5184	8042	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5185	8044	5184	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5186	8047	5185	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5187	8049	5186	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5188	8052	5184	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5189	8055	5188	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5190	8057	5189	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5191	8061	4692	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5192	8063	5191	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5193	8069	5192	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5194	8071	5193	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5195	8075	5191	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5196	8078	5195	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5197	8080	5196	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5198	8083	5191	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5199	8086	5198	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5200	8088	5199	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5201	8091	5191	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5202	8095	5201	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5203	8097	5202	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5204	8100	5201	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5205	8102	5204	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5206	8104	4692	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5207	8106	5206	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5208	8109	5206	jana	taxonomy	\N	886104	family	\N	\N	\N	2009-01-01 00:00:00
5209	8112	5208	nodc	taxonomy	\N	88610401	genus	\N	\N	\N	2009-01-01 00:00:00
5210	8114	5209	nodc	taxonomy	\N	8861040101	species	\N	\N	\N	2009-01-01 00:00:00
5211	8117	5206	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5212	8120	5206	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5213	8123	5212	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5214	8125	5213	lonny	taxonomy	Fish Base, ITIS	\N	species	\N	\N	\N	2009-01-01 00:00:00
5215	8128	5206	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5216	8132	4407	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5217	8133	5216	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5218	8135	5217	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5219	8137	5218	jana	taxonomy	\N	875601	family	\N	\N	\N	2009-01-01 00:00:00
5220	8141	5219	nodc	taxonomy	\N	87560102	genus	\N	\N	\N	2009-01-01 00:00:00
5221	8143	5220	nodc	taxonomy	\N	8756010206	species	\N	\N	\N	2009-01-01 00:00:00
5222	8146	5218	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5223	8148	5222	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5224	8150	5223	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5225	8153	5218	jana	taxonomy	\N	876001	family	\N	\N	\N	2009-01-01 00:00:00
5226	8157	5225	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5227	8159	5226	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5228	8162	5225	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5229	8164	5228	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5230	8167	5225	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5231	8169	5230	jana	taxonomy	\N	8760010306	species	\N	\N	\N	2009-01-01 00:00:00
5232	8172	5225	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5233	8174	5232	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5234	8178	5225	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5235	8180	5234	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5236	8185	5218	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5237	8189	5236	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5238	8191	5237	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5239	8194	5236	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5240	8196	5239	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5241	8200	5236	jana	taxonomy	\N	87600101	genus	\N	\N	\N	2009-01-01 00:00:00
5242	8202	5241	nodc	taxonomy	\N	8760010101	species	\N	\N	\N	2009-01-01 00:00:00
5243	8205	5236	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5244	8207	5243	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
5245	8210	5236	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5246	8212	5245	jana	taxonomy	Milton Love. www.id.ucsb.edu/lovelab/list.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
5247	8214	5218	jana	taxonomy	\N	875602	family	\N	\N	\N	2009-01-01 00:00:00
5248	8217	5247	nodc	taxonomy	\N	87560201	genus	\N	\N	\N	2009-01-01 00:00:00
5249	8219	5248	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5250	8223	5248	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5251	8225	5248	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5252	8228	5248	nodc	taxonomy	\N	8756020111	species	\N	\N	\N	2009-01-01 00:00:00
5253	8231	5248	nodc	taxonomy	\N	8756020104	species	\N	\N	\N	2009-01-01 00:00:00
5254	8235	5248	nodc	taxonomy	\N	8756020103	species	\N	\N	\N	2009-01-01 00:00:00
5255	8240	5247	nodc	taxonomy	\N	87560203	genus	\N	\N	\N	2009-01-01 00:00:00
5256	8242	5255	nodc	taxonomy	\N	8756020301	species	\N	\N	\N	2009-01-01 00:00:00
5257	8246	5218	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5258	8248	5257	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5259	8250	5258	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5260	8253	5258	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5261	8256	5257	jana	taxonomy	\N	87560202	genus	\N	\N	\N	2009-01-01 00:00:00
5262	8258	5261	nodc	taxonomy	\N	8756020201	species	\N	\N	\N	2009-01-01 00:00:00
5263	8261	5218	jana	taxonomy	\N	875603	family	\N	\N	\N	2009-01-01 00:00:00
5264	8265	5263	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5265	8267	5264	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5266	8270	5263	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5267	8272	5266	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5268	8275	5263	nodc	taxonomy	\N	87560301	genus	\N	\N	\N	2009-01-01 00:00:00
5269	8277	5268	nodc	taxonomy	\N	8756030101	species	\N	\N	\N	2009-01-01 00:00:00
5270	8280	5217	nodc	taxonomy	\N	8755	order	sub	\N	\N	2009-01-01 00:00:00
5271	8282	5270	nodc	taxonomy	\N	875501	family	\N	\N	\N	2009-01-01 00:00:00
5272	8285	5271	nodc	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5273	8289	5272	jana	taxonomy	\N	87550102	genus	\N	\N	\N	2009-01-01 00:00:00
5274	8292	5216	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5275	8294	5274	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5276	8296	5275	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5277	8299	5276	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5278	8301	5277	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5279	8304	5276	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5280	8306	5279	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5281	8309	4396	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5282	8310	4396	jana	taxonomy	\N	\N	division	\N	\N	\N	2009-01-01 00:00:00
5283	8311	5282	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5284	8312	5283	jana	taxonomy	\N	874201	family	\N	\N	\N	2009-01-01 00:00:00
5285	8315	5284	nodc	taxonomy	\N	87420101	genus	\N	\N	\N	2009-01-01 00:00:00
5286	8316	5285	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5287	8317	5285	nodc	taxonomy	\N	8742010101	species	\N	\N	\N	2009-01-01 00:00:00
5288	8319	5285	nodc	taxonomy	\N	8742010102	species	\N	\N	\N	2009-01-01 00:00:00
5289	8320	5285	nodc	taxonomy	\N	8742010103	species	\N	\N	\N	2009-01-01 00:00:00
5290	8321	5283	jana	taxonomy	\N	874202	family	\N	\N	\N	2009-01-01 00:00:00
5291	8323	5290	nodc	taxonomy	\N	87420201	genus	\N	\N	\N	2009-01-01 00:00:00
5292	8325	5291	nodc	taxonomy	\N	8742020101	species	\N	\N	\N	2009-01-01 00:00:00
5293	8329	5283	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5294	8332	5293	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5295	8334	5294	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5296	8337	5282	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5297	8338	5296	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5298	8340	5297	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5299	8341	5296	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5300	8343	5299	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5301	8344	5299	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5302	8345	5299	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5303	8346	5302	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5304	8348	5282	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5305	8349	5282	jana	taxonomy	\N	8740	order	\N	\N	\N	2009-01-01 00:00:00
5306	8351	5305	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5307	8353	5306	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5308	8355	5307	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5309	8358	5305	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5310	8359	5309	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5311	8362	5310	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5312	8364	5311	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5313	8366	5312	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5314	8368	5305	nodc	taxonomy	\N	8741	order	sub	\N	\N	2009-01-01 00:00:00
5315	8369	5305	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5316	8370	5315	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5317	8373	5315	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5318	8377	5317	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5319	8379	5318	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5320	8382	5315	jana	taxonomy	\N	874121	family	\N	\N	\N	2009-01-01 00:00:00
5321	8384	5320	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5322	8385	5321	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5323	8387	5321	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5324	8389	5320	nodc	taxonomy	\N	87412102	genus	\N	\N	\N	2009-01-01 00:00:00
5325	8390	5324	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5326	8392	5324	nodc	taxonomy	\N	8741210202	species	\N	\N	\N	2009-01-01 00:00:00
5327	8395	5315	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5328	8396	5305	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5329	8398	5328	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5330	8400	5329	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5331	8403	5328	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5332	8405	5331	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5333	8408	5331	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5334	8411	5328	schlin	\N	http://www.itis.gov	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5335	8412	5334	schlin	\N	http://www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
5336	8413	4329	jana	taxonomy	\N	8701	class	\N	\N	\N	2009-01-01 00:00:00
5337	8416	5336	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
5338	8418	5337	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5339	8419	5338	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5340	8420	5339	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5341	8421	5340	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5342	8424	5341	nodc	taxonomy	\N	87160201	genus	\N	\N	\N	2009-01-01 00:00:00
5343	8425	5342	nodc	taxonomy	\N	8716020101	species	\N	\N	\N	2009-01-01 00:00:00
5344	8427	5342	unknown	taxonomy	Didier, D.A. and B. Séret, 2002. Chimaeroid fishes of New Caledonia with description of a new species of Hydrolagus (Chondrichthyes, Holocephali). Cybium 26(3):225-233.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5345	8429	5340	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5346	8431	5345	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5347	8432	5346	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5348	8433	5345	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5349	8434	5345	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5350	8435	5336	conn	taxonomy	\N	8702	class	sub	\N	\N	2009-01-01 00:00:00
5351	8436	5350	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5352	8438	5351	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5353	8439	5352	nodc	taxonomy	\N	870704	family	\N	\N	\N	2009-01-01 00:00:00
5354	8441	5353	nodc	taxonomy	\N	87070401	genus	\N	\N	\N	2009-01-01 00:00:00
5355	8442	5354	nodc	taxonomy	\N	8707040101	species	\N	\N	\N	2009-01-01 00:00:00
5356	8445	5353	linda	\N	Compagno, Leonard J. V. 1984. Sharks of the World: An annotated and illustrated catalogue of shark species known to date. FAO Fisheries Synopsis, no. 125, vol. 4, pt. 1 	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5357	8446	5356	linda	\N	Compagno, Leonard J. V. 1984. Sharks of the World: An annotated and illustrated catalogue of shark species known to date. FAO Fisheries Synopsis, no. 125, vol. 4, pt. 1 	\N	species	\N	\N	\N	2009-01-01 00:00:00
5358	8447	5351	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5359	8449	5358	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5360	8451	5359	jana	taxonomy	\N	87080206	genus	\N	\N	\N	2009-01-01 00:00:00
5361	8453	5360	nodc	taxonomy	\N	8708020601	species	\N	\N	\N	2009-01-01 00:00:00
5362	8456	5358	jana	taxonomy	\N	870801	family	\N	\N	\N	2009-01-01 00:00:00
5363	8459	5362	nodc	taxonomy	\N	87080101	genus	\N	\N	\N	2009-01-01 00:00:00
5364	8461	5363	nodc	taxonomy	\N	8708010108	species	\N	\N	\N	2009-01-01 00:00:00
5365	8464	5363	nodc	taxonomy	\N	8708010101	species	\N	\N	\N	2009-01-01 00:00:00
5366	8468	5363	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5367	8470	5362	nodc	taxonomy	\N	87080106	genus	\N	\N	\N	2009-01-01 00:00:00
5368	8472	5367	nodc	taxonomy	\N	8708010601	species	\N	\N	\N	2009-01-01 00:00:00
5369	8475	5358	linda	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=160529	\N	family	\N	\N	\N	2009-01-01 00:00:00
5370	8476	5369	linda	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=160226	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5371	8477	5370	linda	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=160236	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5372	8479	5350	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5373	8481	5372	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5374	8483	5373	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5375	8485	5374	jana	taxonomy	\N	87100110	genus	\N	\N	\N	2009-01-01 00:00:00
5376	8487	5375	nodc	taxonomy	\N	8710011002	species	\N	\N	\N	2009-01-01 00:00:00
5377	8490	5373	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5378	8492	5377	jana	taxonomy	\N	87100102	genus	\N	\N	\N	2009-01-01 00:00:00
5379	8494	5378	nodc	taxonomy	\N	8710010201	species	\N	\N	\N	2009-01-01 00:00:00
5380	8501	5377	jana	taxonomy	\N	87100101	genus	\N	\N	\N	2009-01-01 00:00:00
5381	8503	5380	nodc	taxonomy	\N	8710010101	species	\N	\N	\N	2009-01-01 00:00:00
5382	8506	5372	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5383	8508	5382	jana	taxonomy	\N	870502	family	\N	\N	\N	2009-01-01 00:00:00
5384	8511	5383	nodc	taxonomy	\N	87050201	genus	\N	\N	\N	2009-01-01 00:00:00
5385	8516	5384	nodc	taxonomy	\N	8705020101	species	\N	\N	\N	2009-01-01 00:00:00
5386	8520	5383	nodc	taxonomy	\N	87050202	genus	\N	\N	\N	2009-01-01 00:00:00
5387	8522	5386	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5388	8525	5386	nodc	taxonomy	\N	8705020202	species	\N	\N	\N	2009-01-01 00:00:00
5389	8529	5350	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5390	8531	5389	jana	taxonomy	\N	8713	order	\N	\N	\N	2009-01-01 00:00:00
5391	8534	5390	nodc	taxonomy	\N	871303	family	\N	\N	\N	2009-01-01 00:00:00
5392	8538	5391	nodc	taxonomy	\N	87130301	genus	\N	\N	\N	2009-01-01 00:00:00
5393	8540	5392	nodc	taxonomy	\N	8713030101	species	\N	\N	\N	2009-01-01 00:00:00
5394	8543	5390	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5395	8546	5394	jana	taxonomy	\N	87130401	genus	\N	\N	\N	2009-01-01 00:00:00
5396	8548	5395	nodc	taxonomy	\N	8713040103	species	\N	\N	\N	2009-01-01 00:00:00
5397	8551	5395	nodc	taxonomy	\N	8713040104	species	\N	\N	\N	2009-01-01 00:00:00
5398	8554	5395	nodc	taxonomy	\N	8713040108	species	\N	\N	\N	2009-01-01 00:00:00
5399	8557	5395	nodc	taxonomy	\N	8713040111	species	\N	\N	\N	2009-01-01 00:00:00
5400	8560	5394	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5401	8562	5400	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press	\N	species	\N	\N	\N	2009-01-01 00:00:00
5402	8565	5390	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press	\N	family	\N	\N	\N	2009-01-01 00:00:00
5403	8567	5402	jana	taxonomy	\N	87130408	genus	\N	\N	\N	2009-01-01 00:00:00
5404	8568	5403	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5405	8572	5403	nodc	taxonomy	\N	8713040804	species	\N	\N	\N	2009-01-01 00:00:00
5406	8576	5403	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5407	8580	5403	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5408	8583	5403	unknown	taxonomy	Ebert, D. 2003. Sharks, rays and chimeras of California. University of California Press.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5409	8587	5403	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5410	8588	5403	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5411	8589	5402	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5412	8590	5402	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5413	8591	5402	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5414	8592	5350	linda	taxonomy	Ebert, D. et al. 2002. First record of the longnose spiny dogfish Squalus blainvilli and the deep-water stingray Plesiobatis daviesi in S. African waters. S. African Journal of Marine Science. 24:355-357.	\N	order	\N	\N	\N	2009-01-01 00:00:00
5415	8594	5414	linda	taxonomy	Ebert, D. et al. 2002. First record of the longnose spiny dogfish Squalus blainvilli and the deep-water stingray Plesiobatis daviesi in S. African waters. S. African Journal of Marine Science. 24:355-357. 	\N	family	\N	\N	\N	2009-01-01 00:00:00
5416	8596	5415	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5417	8598	5416	linda	taxonomy	Ebert, D. et al. 2002. First record of the longnose spiny dogfish Squalus blainvilli and the deep-water stingray Plesiobatis daviesi in S. African waters. S. African Journal of Marine Science. 24:355-357. 	\N	species	\N	\N	\N	2009-01-01 00:00:00
5418	8600	5414	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5419	8601	5418	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5420	8602	5418	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5421	8603	5414	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5422	8604	5421	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5423	8605	4328	jana	taxonomy	\N	84	phylum	sub	\N	\N	2009-01-01 00:00:00
5424	8608	5423	nodc	taxonomy	\N	8407	class	\N	\N	\N	2009-01-01 00:00:00
5425	8609	5424	jana	taxonomy	\N	8410	order	\N	\N	\N	2009-01-01 00:00:00
5426	8611	5425	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5427	8613	5426	jana	taxonomy	Expert: Larry Madin, WHOI	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5428	8615	5426	jana	taxonomy	Expert: Larry Madin, WHOI	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5429	8617	5425	unknown	taxonomy	Robison, B.H., K.A. Raskoff and R.E. Sherlock (2005). Adaptations for living deep: a new, bathypelagic doliolid from the eastern North Pacific. Journal of the Marine Biological Association of the United Kingdom 85:595-602.	\N	order	sub	\N	\N	2009-01-01 00:00:00
5430	8619	5429	rodgers	taxonomy	Robison, B.H., K.A. Raskoff and R.E. Sherlock (2005). Ecological substrate in midwater: Doliolula equus, a new mesopelagic tunicate. Journal of the Marine Biological Association of the United Kingdom 85:655-663.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5431	8621	5430	jana	taxonomy	\N	84100101	genus	\N	\N	\N	2009-01-01 00:00:00
5432	8623	5430	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5433	8625	5432	unknown	taxonomy	Robison, B.H., K.A. Raskoff and R.E. Sherlock (2005). Ecological substrate in midwater: Doliolula equus, a new mesopelagic tunicate. Journal of the Marine Biological Association of the United Kingdom 85:655-663.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5434	8627	5429	unknown	taxonomy	Robison, B.H., K.A. Raskoff and R.E. Sherlock (2005). Adaptations for living deep: a new, bathypelagic doliolid from the eastern North Pacific. Journal of the Marine Biological Association of the United Kingdom 85:595-602.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5435	8629	5434	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5436	8631	5435	unknown	taxonomy	Robison, B.H., K.A. Raskoff and R.E. Sherlock (2005). Adaptations for living deep: a new, bathypelagic doliolid from the eastern North Pacific. Journal of the Marine Biological Association of the United Kingdom 85:595-602.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5437	8633	5425	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5438	8635	5437	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5439	8637	5438	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5440	8639	5424	jana	taxonomy	\N	8411	order	\N	\N	\N	2009-01-01 00:00:00
5441	8642	5440	jana	taxonomy	www.itis.usda.gov/plantproj/itis/cgi_bin/itis_query.cgi	\N	family	\N	\N	\N	2009-01-01 00:00:00
5442	8643	5441	jana	taxonomy	\N	84110105	genus	\N	\N	\N	2009-01-01 00:00:00
5443	8645	5442	nodc	taxonomy	\N	8411010501	species	\N	\N	\N	2009-01-01 00:00:00
5444	8647	5441	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5445	8649	5444	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5446	8651	5444	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5447	8653	5441	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5448	8655	5447	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5449	8657	5441	jana	taxonomy	\N	84110103	genus	\N	\N	\N	2009-01-01 00:00:00
5450	8659	5449	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5451	8661	5441	jana	taxonomy	\N	84110101	genus	\N	\N	\N	2009-01-01 00:00:00
5452	8664	5441	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5453	8665	5452	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5454	8666	5441	jana	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5455	8667	5454	jana	\N	Madin, L. P. and K.A. Madin. Vitreosalpa gemini, a new species of mesopelagic salp. ASLO/TOS Ocean Research Conference. Hawaii Convention Center Honolulu, Hawaii. February 15-20, 2004.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5456	8668	5441	svonthun	\N	http://jellieszone.com	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5457	8670	5456	svonthun	\N	http://jellieszone.com	\N	species	\N	\N	\N	2009-01-01 00:00:00
5458	8672	5441	svonthun	\N	http://www.jellieszone.com/	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5459	8673	5458	svonthun	\N	http://www.jellieszone.com/	\N	species	\N	\N	\N	2009-01-01 00:00:00
5460	8674	5424	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5461	8676	5460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5462	8678	5461	jana	taxonomy	\N	84080101	genus	\N	\N	\N	2009-01-01 00:00:00
5463	8680	5462	nodc	taxonomy	\N	8408010101	species	\N	\N	\N	2009-01-01 00:00:00
5464	8682	5424	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5465	8685	5423	nodc	taxonomy	\N	8401	class	\N	\N	\N	2009-01-01 00:00:00
5466	8688	5465	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5467	8690	5466	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5468	8692	5465	unknown	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5469	8694	5468	unknown	taxonomy	Swalla, B. J., C. B. Cameron, L. S. Corley, and J. R. Garey. 2000. Urochordates are monophyletic within the deuterostomes. Syst. Biol. 49:52-64.	\N	order	\N	\N	\N	2009-01-01 00:00:00
5470	8697	5469	jana	taxonomy	\N	840602	family	\N	\N	\N	2009-01-01 00:00:00
5471	8699	5470	nodc	taxonomy	\N	84060202	genus	\N	\N	\N	2009-01-01 00:00:00
5472	8701	5471	nodc	taxonomy	\N	8406020203	species	\N	\N	\N	2009-01-01 00:00:00
5473	8703	5471	nodc	taxonomy	\N	8406020202	species	\N	\N	\N	2009-01-01 00:00:00
5474	8705	5470	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5475	8707	5469	nodc	taxonomy	\N	840601	family	\N	\N	\N	2009-01-01 00:00:00
5476	8710	5475	nodc	taxonomy	\N	84060103	genus	\N	\N	\N	2009-01-01 00:00:00
5477	8712	5476	nodc	taxonomy	\N	8406010302	species	\N	\N	\N	2009-01-01 00:00:00
5478	8714	5465	unknown	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5479	8716	5478	unknown	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5480	8718	5479	nodc	taxonomy	\N	840303	family	\N	\N	\N	2009-01-01 00:00:00
5481	8720	5480	nodc	taxonomy	\N	84030301	genus	\N	\N	\N	2009-01-01 00:00:00
5482	8722	5480	nodc	taxonomy	\N	84030304	genus	\N	\N	\N	2009-01-01 00:00:00
5483	8724	5479	nodc	taxonomy	\N	840301	family	\N	\N	\N	2009-01-01 00:00:00
5484	8726	5483	nodc	taxonomy	\N	84030101	genus	\N	\N	\N	2009-01-01 00:00:00
5485	8728	5478	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5486	8730	5485	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5487	8732	5486	conn	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5488	8734	5487	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5489	8736	5423	nodc	taxonomy	\N	8412	class	\N	\N	\N	2009-01-01 00:00:00
5490	8740	5489	nodc	taxonomy	\N	841302	family	\N	\N	\N	2009-01-01 00:00:00
5491	8742	5490	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5492	8743	5491	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5493	8744	5491	nodc	taxonomy	\N	84130201	genus	\N	\N	\N	2009-01-01 00:00:00
5494	8746	5489	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5495	8748	5494	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5496	8750	5489	nodc	taxonomy	\N	841301	family	\N	\N	\N	2009-01-01 00:00:00
5497	8751	5496	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5498	8752	5497	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5499	8754	5498	rodgers	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5500	8757	5497	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5501	8758	5500	jana	taxonomy	Hopcroft, R.R. and B.H. Robison. 1999. A new mesopelagic larvacean, Mesochordaeus erythrocephalus, sp. nov., from Monterey Bay, with a description of its filtering house. Journal of Plankton Research 21:1923-1937.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5502	8762	5496	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5503	8763	5502	nodc	taxonomy	\N	84130101	genus	\N	\N	\N	2009-01-01 00:00:00
5504	8764	5503	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5505	8765	5502	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5506	8766	5423	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
5507	8767	3916	jana	taxonomy	\N	5790	phylum	\N	\N	\N	2009-01-01 00:00:00
5508	8768	5507	jana	taxonomy	\N	62	class	\N	\N	\N	2009-01-01 00:00:00
5509	8770	5507	jana	taxonomy	\N	61	phylum	\N	\N	\N	2009-01-01 00:00:00
5510	8771	5509	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
5511	8772	5510	lonny	taxonomy	An Updated Classification of the Recent Crustacea By Joel W. Martin and George E. Davis Natural History Museum of Los Angeles County Science Series 39 December 14, 2001	\N	class	sub	\N	\N	2009-01-01 00:00:00
5512	8773	5511	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5513	8775	5512	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5514	8776	5513	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5515	8777	5512	svonthun	\N	www.itis.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
5516	8778	5515	svonthun	\N	www.itis.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5517	8779	5510	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
5518	8780	5517	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5519	8781	5518	jana	taxonomy	\N	6174	order	\N	\N	\N	2009-01-01 00:00:00
5520	8783	5519	nodc	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5521	8784	5520	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5522	8787	5520	nodc	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5523	8789	5522	nodc	taxonomy	\N	6174020101	species	\N	\N	\N	2009-01-01 00:00:00
5524	8790	5518	jana	taxonomy	\N	6175	order	\N	\N	\N	2009-01-01 00:00:00
5525	8796	5524	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5526	8797	5525	jana	taxonomy	\N	617702	family	\N	\N	\N	2009-01-01 00:00:00
5527	8798	5526	nodc	taxonomy	\N	61770203	genus	\N	\N	\N	2009-01-01 00:00:00
5528	8799	5527	nodc	taxonomy	\N	6177020301	species	\N	\N	\N	2009-01-01 00:00:00
5529	8801	5526	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5530	8802	5524	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5531	8803	5530	lonny	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5532	8804	5531	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5533	8806	5531	lonny	taxonomy	An Updated Classification of the Recent Crustacea By Joel W. Martin and George E. Davis Natural History Museum of Los Angeles County Science Series 39 December 14, 2001	\N	family	\N	\N	\N	2009-01-01 00:00:00
5534	8807	5533	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5535	8808	5524	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5536	8810	5535	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5537	8811	5536	jana	taxonomy	\N	618304	family	\N	\N	\N	2009-01-01 00:00:00
5538	8813	5537	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5539	8814	5538	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5540	8816	5524	nodc	taxonomy	\N	6184	order	infra	\N	\N	2009-01-01 00:00:00
5541	8818	5540	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5542	8819	5541	jana	taxonomy	\N	618803	family	\N	\N	\N	2009-01-01 00:00:00
5543	8821	5542	nodc	taxonomy	\N	61880301	genus	\N	\N	\N	2009-01-01 00:00:00
5544	8822	5543	nodc	taxonomy	\N	6188030104	species	\N	\N	\N	2009-01-01 00:00:00
5545	8824	5540	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5546	8825	5545	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5547	8827	5546	jana	taxonomy	\N	61870115	genus	\N	\N	\N	2009-01-01 00:00:00
5548	8828	5547	nodc	taxonomy	\N	6187011501	species	\N	\N	\N	2009-01-01 00:00:00
5549	8830	5546	jana	taxonomy	\N	61870103	genus	\N	\N	\N	2009-01-01 00:00:00
5550	8831	5549	nodc	taxonomy	\N	6187010304	species	\N	\N	\N	2009-01-01 00:00:00
5551	8833	5549	nodc	taxonomy	\N	6187010301	species	\N	\N	\N	2009-01-01 00:00:00
5552	8835	5549	nodc	taxonomy	\N	6187010302	species	\N	\N	\N	2009-01-01 00:00:00
5553	8837	5546	jana	taxonomy	\N	61870108	genus	\N	\N	\N	2009-01-01 00:00:00
5554	8838	5553	nodc	taxonomy	\N	6187010801	species	\N	\N	\N	2009-01-01 00:00:00
5555	8840	5546	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5556	8841	5555	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5557	8842	5546	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5558	8843	5540	lonny	taxonomy	A new crab family from the vicinity of submarine thermal vents on the Galapagos Rift (Crustacea: Decapoda: Brachyura). Proceedings of the Biological Society of Washington. Washington DC [PROC. BIOL. SOC. WASH.], vol. 93, no. 2, pp. 443-472, 1980. Williams, 1980.	\N	family	super	\N	\N	2009-01-01 00:00:00
5559	8844	5558	lonny	taxonomy	An updated classification of the recent crustacea. Joel W. Martin and George E. Davis. Natural History Museum of Los Angeles County Science Series 39. December 14, 2001.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5560	8845	5559	lonny	taxonomy	Williams, AB. A new crab family from the vicinity of submarine thermal vents on the Galapagos Rift (Crustacea: Decapoda: Brachyura). Proceedings of the Biological Society of Washington. Washington DC [PROC. BIOL. SOC. WASH.], vol. 93, no. 2, pp. 443-472, 1980	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5561	8846	5560	lonny	taxonomy	Williams, AB. A new crab family from the vicinity of submarine thermal vents on the Galapagos Rift (Crustacea: Decapoda: Brachyura). Proceedings of the Biological Society of Washington. Washington DC [PROC. BIOL. SOC. WASH.], vol. 93, no. 2, pp. 443-472, 1980	\N	species	\N	\N	\N	2009-01-01 00:00:00
5562	8847	5524	jana	taxonomy	\N	6183	order	infra	\N	\N	2009-01-01 00:00:00
5563	8848	5562	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5564	8849	5563	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5565	8852	5564	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5566	8853	5565	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5567	8854	5563	jana	taxonomy	\N	618316	family	\N	\N	\N	2009-01-01 00:00:00
5568	8857	5567	nodc	taxonomy	\N	61831601	genus	\N	\N	\N	2009-01-01 00:00:00
5569	8858	5563	jana	taxonomy	\N	618308	family	\N	\N	\N	2009-01-01 00:00:00
5570	8861	5569	nodc	taxonomy	\N	61830807	genus	\N	\N	\N	2009-01-01 00:00:00
5571	8862	5570	nodc	taxonomy	\N	6183080705	species	\N	\N	\N	2009-01-01 00:00:00
5572	8863	5570	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5573	8865	5569	nodc	taxonomy	\N	61830810	genus	\N	\N	\N	2009-01-01 00:00:00
5574	8866	5573	nodc	taxonomy	\N	6183081002	species	\N	\N	\N	2009-01-01 00:00:00
5575	8868	5569	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5576	8869	5569	nodc	taxonomy	\N	61830808	genus	\N	\N	\N	2009-01-01 00:00:00
5577	8870	5569	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5578	8871	5577	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5579	8873	5577	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5580	8875	5569	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5581	8876	5562	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5582	8877	5581	jana	taxonomy	\N	618310	family	\N	\N	\N	2009-01-01 00:00:00
5583	8879	5582	nodc	taxonomy	\N	61831003	genus	\N	\N	\N	2009-01-01 00:00:00
5584	8880	5583	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5585	8881	5582	nodc	taxonomy	\N	61831001	genus	\N	\N	\N	2009-01-01 00:00:00
5586	8882	5585	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5587	8883	5585	nodc	taxonomy	\N	6183100101	species	\N	\N	\N	2009-01-01 00:00:00
5588	8884	5582	nodc	taxonomy	\N	61831004	genus	\N	\N	\N	2009-01-01 00:00:00
5589	8885	5588	nodc	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5590	8887	5582	nodc	taxonomy	\N	61831002	genus	\N	\N	\N	2009-01-01 00:00:00
5591	8888	5590	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
5592	8889	5524	nodc	taxonomy	\N	6179	order	infra	\N	\N	2009-01-01 00:00:00
5593	8890	5592	lonny	taxonomy	www.itis.usda.gov, Martin, J.W. and Davis, G.E., An updated classification of the recent crustacea. Natural history Museum of Los Angeles County. Science Series 39. December 14, 2001.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5594	8892	5593	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5595	8893	5594	lonny	taxonomy	www.itis.usda.gov, Midwater Decapods of the Northeastern Pacific M.K. Wiksten Contrib. to the study of east pacific crustaceans Vol. 1, 2002	\N	species	\N	\N	\N	2009-01-01 00:00:00
5596	8895	5595	lonny	taxonomy	Midwater Decapods of the Northeastern Pacific M.K. Wiksten Contrib. to the study of east pacific crustaceans Vol. 1, 2002	\N	species	sub	\N	\N	2009-01-01 00:00:00
5597	8896	5594	lonny	taxonomy	www.itis.usda.gov, Midwater Decapods of the Northeastern Pacific M.K. Wiksten Contrib. to the study of east pacific crustaceans Vol. 1, 2002	\N	species	\N	\N	\N	2009-01-01 00:00:00
5598	8897	5593	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5599	8898	5592	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5600	8899	5599	jana	taxonomy	\N	617918	family	\N	\N	\N	2009-01-01 00:00:00
5601	8900	5600	nodc	taxonomy	\N	61791801	genus	\N	\N	\N	2009-01-01 00:00:00
5602	8901	5601	nodc	taxonomy	\N	6179180103	species	\N	\N	\N	2009-01-01 00:00:00
5603	8903	5601	nodc	taxonomy	\N	6179180105	species	\N	\N	\N	2009-01-01 00:00:00
5604	8906	5600	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5605	8907	5604	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5606	8909	5592	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5607	8910	5606	jana	taxonomy	\N	617905	family	\N	\N	\N	2009-01-01 00:00:00
5608	8912	5607	nodc	taxonomy	\N	61790501	genus	\N	\N	\N	2009-01-01 00:00:00
5609	8913	5608	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5610	8914	5608	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5611	8915	5592	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5612	8916	5517	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5613	8917	5612	jana	taxonomy	\N	6151	order	\N	\N	\N	2009-01-01 00:00:00
5614	8919	5613	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5615	8920	5614	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5616	8921	5615	jana	taxonomy	\N	61520101	genus	\N	\N	\N	2009-01-01 00:00:00
5617	8922	5616	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5618	8923	5613	nodc	taxonomy	\N	6153	order	infra	\N	\N	2009-01-01 00:00:00
5619	8924	5618	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5620	8926	5618	nodc	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5621	8927	5620	nodc	taxonomy	\N	61530114	genus	\N	\N	\N	2009-01-01 00:00:00
5622	8928	5620	nodc	taxonomy	\N	61530113	genus	\N	\N	\N	2009-01-01 00:00:00
5623	8929	5622	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5624	8931	5620	nodc	taxonomy	\N	61530104	genus	\N	\N	\N	2009-01-01 00:00:00
5625	8932	5612	jana	taxonomy	\N	6168	order	\N	\N	\N	2009-01-01 00:00:00
5626	8933	5625	jana	taxonomy	\N	6170	order	sub	\N	\N	2009-01-01 00:00:00
5627	8934	5626	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5628	8935	5627	jana	taxonomy	\N	617020	family	\N	\N	\N	2009-01-01 00:00:00
5629	8936	5628	nodc	taxonomy	\N	61702001	genus	\N	\N	\N	2009-01-01 00:00:00
5630	8937	5629	nodc	taxonomy	\N	6170200102	species	\N	\N	\N	2009-01-01 00:00:00
5631	8939	5629	nodc	taxonomy	\N	6170200101	species	\N	\N	\N	2009-01-01 00:00:00
5632	8940	5629	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5633	8941	5627	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=95370	\N	family	\N	\N	\N	2009-01-01 00:00:00
5634	8942	5633	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=95371	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5635	8943	5626	unknown	taxonomy	Martin, Joel W., and George E. Davis. 2001. An Updated Classification of the Recent Crustacea. Natural History Museum of Los Angeles, Science Series 39:124.	\N	order	infra	\N	\N	2009-01-01 00:00:00
5636	8944	5635	jana	taxonomy	Zeidler, Wolfgang. 2004. A review of the families and genera of the hyperiidean amphipod superfamily Phronimoidea Bowman & Gruner, 1973 (Crustacea: Amphipoda: Hyperiidea). Zootaxa, no. 567: 66.	\N	family	super	\N	\N	2009-01-01 00:00:00
5637	8945	5636	jana	taxonomy	\N	617003	family	\N	\N	\N	2009-01-01 00:00:00
5638	8946	5637	nodc	taxonomy	\N	61700301	genus	\N	\N	\N	2009-01-01 00:00:00
5639	8947	5638	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5640	8949	5636	jana	taxonomy	\N	617001	family	\N	\N	\N	2009-01-01 00:00:00
5641	8951	5636	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5642	8952	5641	jana	taxonomy	\N	61700908	genus	\N	\N	\N	2009-01-01 00:00:00
5643	8953	5642	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5644	8954	5636	schlin	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=656368	\N	family	\N	\N	\N	2009-01-01 00:00:00
5645	8957	5644	schlin	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=95139	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5646	8960	5626	unknown	taxonomy	Martin, Joel W., and George E. Davis. 2001. An Updated Classification of the Recent Crustacea. Natural History Museum of Los Angeles, Science Series 39:124.	\N	order	infra	\N	\N	2009-01-01 00:00:00
5647	8961	5646	unknown	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5648	8962	5647	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5649	8963	5648	unknown	taxonomy	Vinogradov, M. E., A. F. Volkov, and T. N. Semenova. Article/Chapter Title: Amphipods-hyperiids (Amphipoda, Hyperiida) of the Pacific Ocean. Opredeliteli po Faune SSSR, no. 132. Page(s): 1-483.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5650	8964	5648	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5651	8965	5646	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5652	8966	5651	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5653	8967	5652	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5654	8968	5625	jana	taxonomy	\N	6169	order	infra	\N	\N	2009-01-01 00:00:00
5655	8970	5654	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5656	8971	5655	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5657	8972	5656	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5658	8973	5657	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5659	8975	5654	svonthun	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5660	8976	5659	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5661	8977	5625	jana	taxonomy	\N	6171	order	sub	\N	\N	2009-01-01 00:00:00
5662	8980	5661	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5663	8981	5662	jana	taxonomy	\N	617101	family	\N	\N	\N	2009-01-01 00:00:00
5664	8982	5663	nodc	taxonomy	\N	61710107	genus	\N	\N	\N	2009-01-01 00:00:00
5665	8983	5612	jana	taxonomy	\N	6158	order	\N	\N	\N	2009-01-01 00:00:00
5666	8986	5665	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5667	8987	5666	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5668	8988	5667	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5669	8989	5668	jana	taxonomy	larson et al. 1988	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5670	8990	5669	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5671	8991	5665	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5672	8992	5671	lonny	taxonomy	ITIS, www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
5673	8993	5671	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5674	8994	5673	jana	taxonomy	\N	616317	family	\N	\N	\N	2009-01-01 00:00:00
5675	8996	5674	jana	taxonomy	Sars, M. 1861. Beskrivelse af an ny Slaegt og Art af Isopoder: Munnopsis typica Sars. Forandlinger I Videnskabs-Selskabet I Kristiania 1860, 1-2	\N	family	sub	\N	\N	2009-01-01 00:00:00
5676	8997	5675	jana	taxonomy	Sars, M. 1861. Beskrivelse af an ny Slaegt og Art af Isopoder: Munnopsis typica Sars. Forandlinger I Videnskabs-Selskabet I Kristiania 1860, 1-2	61631701	genus	\N	\N	\N	2009-01-01 00:00:00
5677	8998	5676	nodc	taxonomy	\N	6163170101	species	\N	\N	\N	2009-01-01 00:00:00
5678	8999	5676	svonthun	\N	www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
5679	9000	5675	lonny	taxonomy	Schultz, G.A. 1978. More planktonic isopod crustaceans from Subantarctic and Antarctic seas. Am. Geophys. Union, Antarctic Research Series. 27(3): 69-90.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5680	9002	5679	lonny	taxonomy	Wilson, G.D.F. 1982. Two natatory asellote isopods from the San Juan Archipelago, Baeonetces inprovisus n. gen., n.sp. and Acanthamunnopsis milleri n.sp., with a revised description of A. hystrix Schultz. Canadian Journal of Zoology. 60: 3332-3343.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5681	9003	5675	lonny	taxonomy	Hansen, H.J. 1916. Crustacea Malacostraca III. V. The order Isopoda. Danish Ingolf Expedition. 3: 1-262.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5682	9004	5675	lonny	taxonomy	Tattersall, W.M. 1905. Some new and rare Isopoda taken in the British area. Report of the British Association for the Advancement of Science Meedting at Cambridge, August 1904, Transactions of Section D, pp. 601-602. or Tattersall, W.M. 1905. The marine fauna of the coast of Ireland. Part V. Isopoda. Great Britain, Reports of the Department of Agriculture and Technical Instruction for Ireland, Scientific Investigations of the Fisheries Branch, 1904, II (1905):1-90	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5683	9005	5674	lonny	taxonomy	Hansen, H.J. 1916. Crustacea Malacostraca III. V. The order Isopoda. Danish Ingolf Expedition. 3: 1-262.	\N	family	sub	\N	\N	2009-01-01 00:00:00
5684	9006	5683	lonny	taxonomy	Sars, M. 1861. Beskrivelse af an ny Slaegt og Art af Isopoder: Munnopsis typica Sars. Forandlinger I Videnskabs-Selskabet I Kristiania 1860, 1-2 or Sars, G.O. 1899. Isopoda. In series: An account of the Crustacea of Norway with short descriptions and figures of all the species. 2: 1-270. Bergen Museum, Bergen.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5685	9007	5674	lonny	taxonomy	Wolff, T. 1962. The systematics and biology of bathyal and abyssal Isopoda Asellota. In series: Galathea Report. Danish Deep-Sea Expedition Round the World (1950-1952) 6:1-320. Danish Science Press, LTD: Copenhagen.	\N	family	sub	\N	\N	2009-01-01 00:00:00
5686	9008	5685	lonny	taxonomy	Nordenstam, A. 1955. A new isopod from the deep sea. In: Reports of the Swedish Deep-Sea Expedition. Vol. 2. Zoology edition. Vol. 16:205-212.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5687	9009	5685	lonny	taxonomy	Wolff, T. 1962. The systematics and biology of bathyal and abyssal Isopoda Asellota. In series: Galathea Report. Danish Deep-Sea Expedition Round the World (1950-1952) 6:1-320. Danish Science Press, LTD: Copenhagen.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5688	9010	5687	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5689	9011	5674	lonny	taxonomy	Richardson, H. 1909. Isopods collected in the Northwest Pacific by the U.S. Bureau of Fisheries steamer Albatross in 1906. Proceedings of the U.S. National Museum. 37: 75-129.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5690	9012	5674	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5691	9014	5690	lonny	taxonomy	Walker, A.O. 1903. Report on the Isopoda and Amphipoda collected by Mr. George Murray, F.R.S., during the cruise of the Oceana in November 1898. Annals and Magazine of Natural History. 12: 223-233.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5692	9015	5674	lonny	taxonomy	Vanhoffen, E. 1914. Die Isopoden der Deutchen Sudpolar-Expedition 1901-1903. Deut. Sudpol-Exped. 20, Zool. 7: 449-598.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5693	9016	5692	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5694	9017	5665	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5695	9018	5510	unknown	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
5696	9019	5695	unknown	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5697	9020	5696	unknown	taxonomy	An Updated Classification of the Recent Crustacea, Martin JW, 2001, LA County Museum of Nat. History 	\N	family	super	\N	\N	2009-01-01 00:00:00
5698	9021	5697	unknown	taxonomy	An Updated Classification of the Recent Crustacea, Martin JW, 2001, LA County Museum 	\N	family	\N	\N	\N	2009-01-01 00:00:00
5699	9022	5698	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5700	9023	5699	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5701	9024	5509	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
5702	9026	5701	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5703	9027	5509	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
5704	9028	5703	jana	taxonomy	\N	6130	class	sub	\N	\N	2009-01-01 00:00:00
5705	9030	5704	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5706	9031	5705	jana	taxonomy	\N	6132	order	infra	\N	\N	2009-01-01 00:00:00
5707	9032	5706	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5708	9033	5707	jana	taxonomy	\N	613201	family	\N	\N	\N	2009-01-01 00:00:00
5709	9034	5708	nodc	taxonomy	\N	61320101	genus	\N	\N	\N	2009-01-01 00:00:00
5710	9036	5706	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5711	9037	5710	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5712	9038	5711	jana	taxonomy	\N	61320503	genus	\N	\N	\N	2009-01-01 00:00:00
5713	9040	5703	jana	taxonomy	\N	6117	class	sub	\N	\N	2009-01-01 00:00:00
5714	9042	5713	lonny	taxonomy	www.itis.usda.gov	\N	class	infra	\N	\N	2009-01-01 00:00:00
5715	9043	5714	lonny	taxonomy	www.itis.usda.gov	\N	order	super	\N	\N	2009-01-01 00:00:00
5716	9044	5715	lonny	taxonomy	www.itis.usda.gov	\N	order	\N	\N	\N	2009-01-01 00:00:00
5717	9045	5716	lonny	taxonomy	www.itis.usda.gov, Martin, J.W. and Davis, G.E., An updated classification of the recent crustacea. Natural history Museum of Los Angeles County. Science Series 39. December 14, 2001.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5718	9046	5717	lonny	taxonomy	www.itis.usda.gov, Martin, J.W. and Davis, G.E., An updated classification of the recent crustacea. Natural history Museum of Los Angeles County. Science Series 39. December 14, 2001.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5719	9047	5714	schlin	\N	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
5720	9048	5719	jana	taxonomy	www.itis.gov	6118	order	\N	\N	\N	2009-01-01 00:00:00
5721	9049	5720	nodc	taxonomy	\N	611801	family	\N	\N	\N	2009-01-01 00:00:00
5722	9050	5720	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5723	9051	5722	jana	taxonomy	MBARI video specimen identified by Erik Theusen on Haddock dive at about 1300 meters.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5724	9052	5720	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5725	9053	5720	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5726	9054	5725	jana	taxonomy	Dunn, Daphne Fautin and Kuni Hulsemann. 1979. Metridiidae Carlgren, 1893 (Anthozoa) and Metridiidae Sars, 1902 (Copepoda): request for a ruling to eliminate the homonymy.  Bulletin of Zoological Nomenclature 36(1): 53-56.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5727	9057	5726	jana	taxonomy	\N	61181601	genus	\N	\N	\N	2009-01-01 00:00:00
5728	9059	5727	nodc	taxonomy	\N	6118160101	species	\N	\N	\N	2009-01-01 00:00:00
5729	9060	5720	schlin	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5730	9061	5729	schlin	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5731	9062	5730	schlin	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5732	9063	5720	schlin	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5733	9064	5732	schlin	\N	www.itis.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5734	9065	5703	jana	taxonomy	\N	6110	class	sub	\N	\N	2009-01-01 00:00:00
5735	9067	5734	jana	taxonomy	\N	\N	order	infra	\N	\N	2009-01-01 00:00:00
5736	9068	5735	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5737	9069	5736	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5738	9070	5737	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5739	9071	5738	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5740	9072	5739	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5741	9074	5739	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5742	9075	5507	unknown	taxonomy	\N	\N	phylum	sub	\N	\N	2009-01-01 00:00:00
5743	9076	5742	jana	taxonomy	\N	60	class	\N	\N	\N	2009-01-01 00:00:00
5744	9078	5743	unknown	taxonomy	www.itis.usda.gov	\N	order	\N	\N	\N	2009-01-01 00:00:00
5745	9079	5744	unknown	taxonomy	 	\N	family	\N	\N	\N	2009-01-01 00:00:00
5746	9080	5745	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5747	9081	5746	unknown	taxonomy	Child, C.A.  Ammothea verenae and Sericosura venticola, two new hydrothermal-vent associated pycnogonids from the northeast Pacific, Proc. biol. Soc. Wash. , 1988.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5748	9082	3916	jana	taxonomy	\N	37	phylum	\N	\N	\N	2009-01-01 00:00:00
5749	9086	5748	nodc	taxonomy	\N	3740	class	\N	\N	\N	2009-01-01 00:00:00
5750	9089	5749	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
5751	9090	5750	jana	taxonomy	\N	3743	order	\N	\N	\N	2009-01-01 00:00:00
5752	9093	5751	nodc	taxonomy	\N	374301	family	\N	\N	\N	2009-01-01 00:00:00
5753	9095	5752	nodc	taxonomy	\N	37430103	genus	\N	\N	\N	2009-01-01 00:00:00
5754	9097	5752	nodc	taxonomy	\N	37430101	genus	\N	\N	\N	2009-01-01 00:00:00
5755	9099	5751	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5756	9100	5755	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5757	9102	5756	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5758	9104	5751	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5759	9105	5751	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5760	9106	5751	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5761	9107	5749	jana	taxonomy	\N	3755	class	sub	\N	\N	2009-01-01 00:00:00
5762	9109	5761	jana	taxonomy	\N	3742	order	\N	\N	\N	2009-01-01 00:00:00
5763	9112	5762	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5764	9114	5763	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5765	9116	5764	jana	taxonomy	\N	37420101	genus	\N	\N	\N	2009-01-01 00:00:00
5766	9118	5762	unknown	taxonomy	http://hercules.kgs.ku.edu/hexacoral/anemone2/classification_path_2.cfm?taxonname=Cladopathidae%20Brook%2C%201889	\N	family	\N	\N	\N	2009-01-01 00:00:00
5767	9120	5766	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5768	9122	5767	unknown	taxonomy	www.unep-wcmc.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
5769	9124	5762	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5770	9125	5769	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5771	9126	5769	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5772	9127	5769	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5773	9128	5769	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5774	9129	5769	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5775	9130	5761	jana	taxonomy	\N	3758	order	\N	\N	\N	2009-01-01 00:00:00
5776	9132	5775	jana	taxonomy	`nyantheae` most recently valid per Hexacorallians of the World online database: http://hercules.kgs.ku.edu/hexacoral/anemone2/index.cfm	\N	order	sub	\N	\N	2009-01-01 00:00:00
5777	9134	5776	jana	taxonomy	\N	3760	tribe	\N	\N	\N	2009-01-01 00:00:00
5778	9135	5777	nodc	taxonomy	\N	376004	family	\N	\N	\N	2009-01-01 00:00:00
5779	9136	5778	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5780	9137	5779	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5781	9138	5777	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5782	9139	5781	jana	taxonomy	\N	37600109	genus	\N	\N	\N	2009-01-01 00:00:00
5783	9142	5782	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5784	9144	5777	nodc	taxonomy	\N	376002	family	\N	\N	\N	2009-01-01 00:00:00
5785	9146	5784	nodc	taxonomy	\N	37600201	genus	\N	\N	\N	2009-01-01 00:00:00
5786	9147	5785	nodc	taxonomy	\N	3760020101	species	\N	\N	\N	2009-01-01 00:00:00
5787	9150	5785	nodc	taxonomy	\N	3760020102	species	\N	\N	\N	2009-01-01 00:00:00
5788	9153	5784	nodc	taxonomy	\N	37600204	genus	\N	\N	\N	2009-01-01 00:00:00
5789	9156	5777	jana	taxonomy	\N	\N	tribe	\N	\N	\N	2009-01-01 00:00:00
5790	9158	5789	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5791	9160	5790	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5792	9162	5777	nodc	taxonomy	Dunn, Daphne Fautin and Kuni Hulsemann. 1979. Metridiidae Carlgren, 1893 (Anthozoa) and Metridiidae Sars, 1902 (Copepoda): request for a ruling to eliminate the homonymy.  Bulletin of Zoological Nomenclature 36(1): 53-56.	376006	family	\N	\N	\N	2009-01-01 00:00:00
5793	9165	5792	nodc	taxonomy	\N	37600601	genus	\N	\N	\N	2009-01-01 00:00:00
5794	9167	5793	nodc	taxonomy	\N	3760060101	species	\N	\N	\N	2009-01-01 00:00:00
5795	9170	5793	lonny	taxonomy	1) Metridium farcimen, the valid name of a common North Pacific sea anemone. Fautin, D.G. and Hand C. Proceedings of the Biological Society of Washington Vol. 113 No. 4, pp 1151-1161. 29 Dec 2000. 2) Systematics of sea anemones belonging to the genus Metridium Fauntin, DG, et al Wasman Journal of Biology Vol. 47 no. 1-2, pp 77-85, 1989. 3) Fautin, Daphne Gail Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Chapter number:3 Volume:3 Publisher:Santa Barbara Museum of Natural History Edition: Date of publication: 1998 City:Santa Barbara Pages:113-139	\N	species	\N	\N	\N	2009-01-01 00:00:00
5796	9173	5777	jana	taxonomy	\N	\N	tribe	\N	\N	\N	2009-01-01 00:00:00
5797	9174	5796	nodc	taxonomy	\N	376001	family	\N	\N	\N	2009-01-01 00:00:00
5798	9177	5797	nodc	taxonomy	\N	37600104	genus	\N	\N	\N	2009-01-01 00:00:00
5799	9179	5797	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5800	9181	5797	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5801	9183	5796	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5802	9185	5777	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5803	9186	5802	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5804	9187	5803	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5805	9188	5776	jana	taxonomy	\N	\N	tribe	\N	\N	\N	2009-01-01 00:00:00
5806	9189	5805	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5807	9190	5806	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5808	9191	5775	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5809	9192	5808	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5810	9194	5809	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5811	9195	5775	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5812	9196	5775	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5813	9197	5775	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5814	9198	5775	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5815	9199	5761	jana	taxonomy	\N	3764	order	\N	\N	\N	2009-01-01 00:00:00
5816	9202	5815	jana	taxonomy	\N	3769	order	sub	\N	\N	2009-01-01 00:00:00
5817	9204	5816	nodc	taxonomy	\N	376901	family	\N	\N	\N	2009-01-01 00:00:00
5818	9206	5817	nodc	taxonomy	\N	37690101	genus	\N	\N	\N	2009-01-01 00:00:00
5819	9208	5818	nodc	taxonomy	\N	3769010101	species	\N	\N	\N	2009-01-01 00:00:00
5820	9210	5815	jana	taxonomy	\N	3768	order	sub	\N	\N	2009-01-01 00:00:00
5821	9213	5820	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
5822	9215	5821	jana	taxonomy	\N	376801	family	\N	\N	\N	2009-01-01 00:00:00
5823	9218	5822	nodc	taxonomy	\N	37680102	genus	\N	\N	\N	2009-01-01 00:00:00
5824	9220	5823	nodc	taxonomy	\N	3768010203	species	\N	\N	\N	2009-01-01 00:00:00
5825	9222	5822	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5826	9223	5825	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5827	9224	5820	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5828	9225	5827	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5829	9226	5828	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5830	9227	5815	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5831	9229	5830	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5832	9231	5761	nodc	taxonomy	\N	3756	order	\N	\N	\N	2009-01-01 00:00:00
5833	9233	5832	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5834	9234	5833	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5835	9235	5834	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5836	9236	5761	nodc	taxonomy	\N	3757	order	\N	\N	\N	2009-01-01 00:00:00
5837	9237	5836	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5838	9238	5837	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5839	9239	5838	nodc	taxonomy	\N	3757010301	species	\N	\N	\N	2009-01-01 00:00:00
5840	9242	5838	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5841	9244	5837	jana	taxonomy	\N	37570101	genus	\N	\N	\N	2009-01-01 00:00:00
5842	9245	5841	nodc	taxonomy	\N	3757010105	species	\N	\N	\N	2009-01-01 00:00:00
5843	9247	5749	jana	taxonomy	\N	3744	class	sub	\N	\N	2009-01-01 00:00:00
5844	9249	5843	nodc	taxonomy	\N	3747	order	\N	\N	\N	2009-01-01 00:00:00
5845	9251	5844	nodc	taxonomy	\N	374702	family	\N	\N	\N	2009-01-01 00:00:00
5846	9254	5845	nodc	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5847	9256	5846	conn	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5848	9259	5846	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5849	9260	5844	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5850	9262	5849	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5851	9265	5849	lonny	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5852	9266	5851	lonny	\N	Nutting, CC. 1908. Descriptions of the Alcyonaria collected by the U.S. bureau of fisheries steamer Albatross in the vicinity of the Hawaiian islands in 1902. \nSmithsonian Institution Press, Washington. p. 543-601. pl. XLI-LI. 24 cm.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5853	9267	5844	lonny	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5854	9268	5843	jana	taxonomy	\N	3749	order	\N	\N	\N	2009-01-01 00:00:00
5855	9271	5854	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5856	9272	5854	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5857	9273	5854	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5858	9274	5854	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5859	9275	5858	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5860	9276	5859	jana	taxonomy	\N	37500401	genus	\N	\N	\N	2009-01-01 00:00:00
5861	9277	5860	nodc	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5862	9280	5858	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5863	9281	5862	jana	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5864	9282	5854	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5865	9283	5854	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5866	9284	5865	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5867	9285	5854	jana	taxonomy	\N	3751	order	sub	\N	\N	2009-01-01 00:00:00
5868	9286	5867	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5869	9287	5868	unknown	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5870	9288	5869	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5871	9289	5868	unknown	taxonomy	http://www.calacademy.com/research/izg/OCTOGEN.htm	\N	species	\N	\N	\N	2009-01-01 00:00:00
5872	9290	5871	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5873	9291	5871	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5874	9292	5868	lonny	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5875	9293	5874	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5876	9294	5874	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5877	9295	5874	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5878	9296	5867	jana	taxonomy	\N	375104	family	\N	\N	\N	2009-01-01 00:00:00
5879	9297	5878	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5880	9298	5879	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5881	9300	5879	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5882	9301	5878	nodc	taxonomy	\N	37510405	genus	\N	\N	\N	2009-01-01 00:00:00
5883	9302	5867	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5884	9304	5883	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5885	9306	5883	jana	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5886	9307	5883	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5887	9309	5883	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5888	9311	5867	nodc	taxonomy	\N	37510408	genus	\N	\N	\N	2009-01-01 00:00:00
5889	9312	5867	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5890	9313	5867	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5891	9314	5890	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5892	9316	5890	unknown	taxonomy	http://www.calacademy.com/research/izg/OCTOGEN.htm	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5893	9318	5890	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5894	9319	5893	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5895	9320	5893	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5896	9321	5843	jana	taxonomy	\N	3752	order	\N	\N	\N	2009-01-01 00:00:00
5897	9324	5896	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5898	9325	5897	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5899	9326	5898	jana	taxonomy	\N	37540101	genus	\N	\N	\N	2009-01-01 00:00:00
5900	9327	5899	nodc	taxonomy	\N	3754010103	species	\N	\N	\N	2009-01-01 00:00:00
5901	9329	5898	linda	\N	Williams, G.C. 2005. New Taxa of Octocorals (Anthozoa: Octocorallia) from the Northeastern Pacific Ocean. Proceedings of the California Academy of Sciences 56(6): 53-65.	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5902	9330	5898	lonny	\N	Identified by Gary Williams at California Academy of Sciences from samples collected in Monterey Canyon on Ventana dive 3209.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5903	9331	5897	jana	taxonomy	\N	375402	family	\N	\N	\N	2009-01-01 00:00:00
5904	9332	5903	nodc	taxonomy	\N	37540202	genus	\N	\N	\N	2009-01-01 00:00:00
5905	9334	5904	nodc	taxonomy	\N	3754020201	species	\N	\N	\N	2009-01-01 00:00:00
5906	9336	5903	nodc	taxonomy	\N	37540201	genus	\N	\N	\N	2009-01-01 00:00:00
5907	9338	5906	unknown	taxonomy	\N	\N	species	sub	\N	\N	2009-01-01 00:00:00
5908	9340	5906	linda	\N	http://itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52418	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5909	9341	5906	linda	\N	Kükenthal, W. 1915. Pennatularia. Das Tierreich 43: 1-132. Verlag von R. \nFriedländer und Sohn, Berlin.  Page 84, fig 84\nKükenthal, W. and H. Broch. 1911. Pennatulacea. Wissenschaftliche Ergebnisse der deutschen Tiefsee-Expedition "Valdivia" 13(1) Lieferung 2: 113-576.  Page 358, Plate XXIII fig 60a, b, c\n 	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5910	9342	5897	unknown	taxonomy	Daphne Fautin, F. G. Hochberg and John Ljubenkov. 1998. Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 3: The Cnidaria. Santa Barbara Museum of Natural History.	\N	family	\N	\N	\N	2009-01-01 00:00:00
5911	9343	5910	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5912	9344	5911	jana	taxonomy	Daphne Fautin, F. G. Hochberg and John Ljubenkov. 1998. Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 3: The Cnidaria. Santa Barbara Museum of Natural History.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5913	9345	5896	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
5914	9346	5913	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5915	9347	5914	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5916	9348	5915	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5917	9349	5915	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5918	9350	5913	jana	taxonomy	\N	375311	family	\N	\N	\N	2009-01-01 00:00:00
5919	9351	5918	nodc	taxonomy	\N	37531101	genus	\N	\N	\N	2009-01-01 00:00:00
5920	9353	5919	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5921	9355	5919	jana	taxonomy	Daphne Fautin, F. G. Hochberg and John Ljubenkov. 1998. Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 3: The Cnidaria. Santa Barbara Museum of Natural History.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5922	9357	5913	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5923	9358	5922	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5924	9360	5923	jana	taxonomy	Williams, G.C. 1995. Living genera of sea pens (Coelenterata: Octocorallia: Pennatulacea): illustrated key and synopses. Zoological Journal of the Linnean Society 113: 93-140.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5925	9362	5922	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5926	9363	5925	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5927	9364	5913	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5928	9365	5927	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5929	9367	5928	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5930	9368	5928	linda	\N	Pasternak, F.A. 1970. Sea pens (Octocorallia, Pennatularia) of the hadal zone of the Kurile-Kamtaschatka Trench. Trudy Instituta okeanologii. Akademiya nauk SSSR 86: 236-248. [In Russian]\nPasternak, F.A. 1960. The deep-sea Pennatularia from the Bering Sea and Kuril- Kamtschatka Trench. Trudy Instituta okeanologii, Akademiya nauk SSSR 34: 329- 335. [In Russian]\n	\N	species	\N	\N	\N	2009-01-01 00:00:00
5931	9369	5913	unknown	taxonomy		\N	family	\N	\N	\N	2009-01-01 00:00:00
5932	9371	5931	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5933	9373	5932	unknown	taxonomy	Daphne Fautin, F. G. Hochberg and John Ljubenkov. 1998. Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 3: The Cnidaria. Santa Barbara Museum of Natural History.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5934	9375	5913	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5935	9376	5934	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5936	9377	5896	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5937	9378	5896	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5938	9379	5896	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5939	9380	5748	nodc	taxonomy	\N	3730	class	\N	\N	\N	2009-01-01 00:00:00
5940	9383	5939	jana	taxonomy	\N	3733	order	\N	\N	\N	2009-01-01 00:00:00
5941	9387	5940	nodc	taxonomy	\N	373305	family	\N	\N	\N	2009-01-01 00:00:00
5942	9389	5941	nodc	taxonomy	\N	37330501	genus	\N	\N	\N	2009-01-01 00:00:00
5943	9391	5942	nodc	taxonomy	\N	3733050102	species	\N	\N	\N	2009-01-01 00:00:00
5944	9393	5940	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
5945	9395	5944	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5946	9397	5945	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5947	9399	5945	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5948	9401	5940	nodc	taxonomy	\N	373306	family	\N	\N	\N	2009-01-01 00:00:00
5949	9403	5948	nodc	taxonomy	\N	37330604	genus	\N	\N	\N	2009-01-01 00:00:00
5950	9405	5949	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5951	9407	5948	nodc	taxonomy	\N	37330601	genus	\N	\N	\N	2009-01-01 00:00:00
5952	9409	5951	nodc	taxonomy	\N	3733060101	species	\N	\N	\N	2009-01-01 00:00:00
5953	9411	5940	nodc	taxonomy	\N	373301	family	\N	\N	\N	2009-01-01 00:00:00
5954	9413	5953	nodc	taxonomy	\N	37330101	genus	\N	\N	\N	2009-01-01 00:00:00
5955	9415	5954	nodc	taxonomy	\N	3733010101	species	\N	\N	\N	2009-01-01 00:00:00
5956	9417	5954	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5957	9419	5940	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=51563	\N	family	\N	\N	\N	2009-01-01 00:00:00
5958	9420	5957	svonthun	\N	www.itis.gov	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5959	9421	5939	jana	taxonomy	\N	3734	order	\N	\N	\N	2009-01-01 00:00:00
5960	9424	5959	nodc	taxonomy	\N	373401	family	\N	\N	\N	2009-01-01 00:00:00
5961	9426	5960	nodc	taxonomy	\N	37340103	genus	\N	\N	\N	2009-01-01 00:00:00
5962	9428	5961	nodc	taxonomy	\N	3734010301	species	\N	\N	\N	2009-01-01 00:00:00
5963	9431	5960	nodc	taxonomy	\N	37340102	genus	\N	\N	\N	2009-01-01 00:00:00
5964	9433	5963	nodc	taxonomy	\N	3734010203	species	\N	\N	\N	2009-01-01 00:00:00
5965	9435	5963	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5966	9438	5963	nodc	taxonomy	\N	3734010201	species	\N	\N	\N	2009-01-01 00:00:00
5967	9440	5963	svonthun	\N	http://jellieszone.com/pelagia.htm	\N	species	\N	\N	\N	2009-01-01 00:00:00
5968	9443	5959	nodc	taxonomy	\N	373403	family	\N	\N	\N	2009-01-01 00:00:00
5969	9446	5968	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5970	9448	5969	jana	taxonomy	\N	37340304	genus	\N	\N	\N	2009-01-01 00:00:00
5971	9450	5970	nodc	taxonomy	\N	3734030401	species	\N	\N	\N	2009-01-01 00:00:00
5972	9452	5968	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5973	9454	5972	jana	taxonomy	\N	37340302	genus	\N	\N	\N	2009-01-01 00:00:00
5974	9456	5973	nodc	taxonomy	\N	3734030201	species	\N	\N	\N	2009-01-01 00:00:00
5975	9459	5968	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5976	9461	5975	jana	taxonomy	\N	37340313	genus	\N	\N	\N	2009-01-01 00:00:00
5977	9463	5976	lonny	taxonomy	GIM	\N	species	\N	\N	\N	2009-01-01 00:00:00
5978	9465	5976	nodc	taxonomy	\N	3734031301	species	\N	\N	\N	2009-01-01 00:00:00
5979	9467	5968	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
5980	9469	5979	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5981	9471	5980	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
5982	9475	5968	lonny	taxonomy	Tiburonia granrojo n. sp., a mesopelagic scyphomedusa from the Pacific Ocean representing the type of a new subfamily (class Scyphozoa: order Semaeostomeae: family Ulmaridae: subfamily Tiburoniinae subfam. nov.)	\N	family	sub	\N	\N	2009-01-01 00:00:00
5983	9477	5982	lonny	taxonomy	Tiburonia granrojo n. sp., a mesopelagic scyphomedusa from the Pacific Ocean representing the type of a new subfamily (class Scyphozoa: order Semaeostomeae: family Ulmaridae: subfamily Tiburoniinae subfam. nov.) G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5984	9479	5983	lonny	taxonomy	Tiburonia granrojo n. sp., a mesopelagic scyphomedusa from the Pacific Ocean representing the type of a new subfamily (class Scyphozoa: order Semaeostomeae: family Ulmaridae: subfamily Tiburoniinae subfam. nov.) G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	\N	species	\N	\N	\N	2009-01-01 00:00:00
5985	9484	5968	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5986	9486	5985	lonny	taxonomy	ITIS, www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
5987	9488	5968	unknown	taxonomy	K. A. Raskoff and G. I. Matsumoto, Stellamedusa ventana, a new mesopelagic scyphomedusae from the eastern Pacific representing a new subfamily, the Stellamedusinae. 2004. Journal of the Marine Biological Association of the United Kingdom. 84, 4274/1-6.	\N	family	sub	\N	\N	2009-01-01 00:00:00
5988	9490	5987	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
5989	9492	5988	unknown	taxonomy	K. A. Raskoff and G. I. Matsumoto, Stellamedusa ventana, a new mesopelagic scyphomedusae from the eastern Pacific representing a new subfamily, the Stellamedusinae. 2004. Journal of the Marine Biological Association of the United Kingdom. 84, 4274/1-6.	\N	species	\N	\N	\N	2009-01-01 00:00:00
5990	9495	5959	nodc	taxonomy	\N	373402	family	\N	\N	\N	2009-01-01 00:00:00
5991	9497	5990	nodc	taxonomy	\N	37340201	genus	\N	\N	\N	2009-01-01 00:00:00
5992	9499	5991	nodc	taxonomy	\N	3734020101	species	\N	\N	\N	2009-01-01 00:00:00
5993	9502	5748	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
5994	9505	5748	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
5995	9507	5748	nodc	taxonomy	Common and Scientific Nmaes of Aquatic Inverts. from the U.S. and Canada; Cnidaria and Ctenophora, 2nd ed. 2002, American Fisheries Society Special Pub. 28	3701	class	super	\N	\N	2009-01-01 00:00:00
5996	9511	5995	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
5997	9513	5996	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
5998	9516	5997	jana	taxonomy	\N	370313	family	\N	\N	\N	2009-01-01 00:00:00
5999	9517	5998	nodc	taxonomy	\N	37031302	genus	\N	\N	\N	2009-01-01 00:00:00
6000	9519	5999	nodc	taxonomy	\N	3703130201	species	\N	\N	\N	2009-01-01 00:00:00
6001	9521	5998	nodc	taxonomy	\N	37031301	genus	\N	\N	\N	2009-01-01 00:00:00
6002	9523	5997	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6003	9524	6002	jana	taxonomy	\N	37030701	genus	\N	\N	\N	2009-01-01 00:00:00
6004	9526	5997	lonny	taxonomy	A checklist of the Medusae (Hydrozoa, Scyphozoa and Cubozoa) of Mexico LOURDES SEGURA-PUERTAS 1 , EDUARDO SUÁREZ-MORALES 2 & LAURA CELIS 1. Zootaxa 194: 1-15 (2003).	\N	family	\N	\N	\N	2009-01-01 00:00:00
6005	9527	6004	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6006	9529	6005	lonny	taxonomy	A checklist of the Medusae (Hydrozoa, Scyphozoa and Cubozoa) of Mexico LOURDES SEGURA-PUERTAS 1 , EDUARDO SU¡REZ-MORALES 2 & LAURA CELIS 1. Zootaxa 194: 1-15 (2003).	\N	species	\N	\N	\N	2009-01-01 00:00:00
6007	9530	5997	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6008	9531	6007	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6009	9533	6008	jana	taxonomy	\N	370306	family	\N	\N	\N	2009-01-01 00:00:00
6010	9535	6009	nodc	taxonomy	\N	37030609	genus	\N	\N	\N	2009-01-01 00:00:00
6011	9537	6007	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6012	9539	6011	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6013	9541	6012	jana	taxonomy	\N	37140202	genus	\N	\N	\N	2009-01-01 00:00:00
6014	9543	6013	jana	taxonomy	\N	3714020202	species	\N	\N	\N	2009-01-01 00:00:00
6015	9546	6011	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6016	9548	6015	jana	taxonomy	\N	37030312	genus	\N	\N	\N	2009-01-01 00:00:00
6017	9550	6016	schlin	\N	The anthomedusan fauna of the Japan\nTrench: preliminary results from in situ\nsurveys with manned and unmanned vehicles. Lindsay et al. 2008. Journal of the Marine Biological Association of the United Kingdom.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6018	9551	6016	schlin	\N	The anthomedusan fauna of the Japan\nTrench: preliminary results from in situ\nsurveys with manned and unmanned vehicles. Lindsay et al. 2008. Journal of the Marine Biological Association of the United Kingdom.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6019	9552	6015	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6020	9554	6019	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6021	9556	6019	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6022	9557	6011	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6023	9559	6022	jana	taxonomy	\N	37030302	genus	\N	\N	\N	2009-01-01 00:00:00
6024	9561	6022	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6025	9563	5997	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6026	9564	6025	jana	taxonomy	\N	370312	family	\N	\N	\N	2009-01-01 00:00:00
6027	9566	6026	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6028	9568	6027	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6029	9570	6026	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6030	9572	6029	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6031	9574	6026	nodc	taxonomy	\N	37031202	genus	\N	\N	\N	2009-01-01 00:00:00
6032	9576	6026	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6033	9578	6032	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6034	9581	6026	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6035	9583	6034	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6036	9585	6025	jana	taxonomy	\N	370320	family	\N	\N	\N	2009-01-01 00:00:00
6037	9586	6036	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6038	9587	6036	nodc	taxonomy	\N	37032005	genus	\N	\N	\N	2009-01-01 00:00:00
6039	9589	6038	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6040	9590	6036	unknown	taxonomy	www.erms.biol.soton.ac.uk/cgi-bin/hierarchy.pl?rank=genus&taxon=Bythotiara	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6041	9591	6040	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6042	9592	6040	svonthun	\N	www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6043	9593	6025	linda	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6044	9594	5996	jana	taxonomy	\N	3711	order	\N	\N	\N	2009-01-01 00:00:00
6045	9595	6044	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6046	9596	6045	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6047	9598	6046	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6048	9600	6045	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6049	9602	6048	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6050	9604	6044	nodc	taxonomy	\N	371104	family	\N	\N	\N	2009-01-01 00:00:00
6051	9605	6050	nodc	taxonomy	\N	37110403	genus	\N	\N	\N	2009-01-01 00:00:00
6052	9606	6050	nodc	taxonomy	\N	37110404	genus	\N	\N	\N	2009-01-01 00:00:00
6053	9607	6052	nodc	taxonomy	\N	3711040402	species	\N	\N	\N	2009-01-01 00:00:00
6054	9609	6050	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6055	9610	6054	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6056	9612	6050	jana	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6057	9613	6056	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6058	9616	6056	jana	taxonomy	Bouillon, J., PagËs, F. Gili, J-M. New species of benthopelagic hydromedusae from the Weddell Sea. Polar Biology.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6059	9618	6050	nodc	taxonomy	\N	37110407	genus	\N	\N	\N	2009-01-01 00:00:00
6060	9619	6059	schlin	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=51085	\N	species	\N	\N	\N	2009-01-01 00:00:00
6061	9620	6050	nodc	taxonomy	\N	37110410	genus	\N	\N	\N	2009-01-01 00:00:00
6062	9621	6061	nodc	taxonomy	\N	3711041001	species	\N	\N	\N	2009-01-01 00:00:00
6063	9623	6050	nodc	taxonomy	\N	37110412	genus	\N	\N	\N	2009-01-01 00:00:00
6064	9624	6063	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6065	9626	6063	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6066	9628	6063	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6067	9630	6063	nodc	taxonomy	\N	3711041204	species	\N	\N	\N	2009-01-01 00:00:00
6068	9632	6050	jana	taxonomy	\N	37110413	genus	\N	\N	\N	2009-01-01 00:00:00
6069	9633	6068	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6070	9635	6050	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6071	9636	6070	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6072	9638	6050	unknown	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6073	9639	6072	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6074	9641	6050	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6075	9642	6044	nodc	taxonomy	\N	371102	family	\N	\N	\N	2009-01-01 00:00:00
6076	9643	6075	nodc	taxonomy	\N	37110201	genus	\N	\N	\N	2009-01-01 00:00:00
6077	9645	6076	nodc	taxonomy	\N	3711020101	species	\N	\N	\N	2009-01-01 00:00:00
6078	9648	6044	nodc	taxonomy	\N	371106	family	\N	\N	\N	2009-01-01 00:00:00
6079	9649	6078	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6080	9651	6079	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6081	9653	6078	nodc	taxonomy	\N	37110604	genus	\N	\N	\N	2009-01-01 00:00:00
6082	9657	6081	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6083	9659	6081	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6084	9661	6078	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6085	9662	6084	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6086	9664	6078	nodc	taxonomy	\N	37110603	genus	\N	\N	\N	2009-01-01 00:00:00
6087	9666	6086	nodc	taxonomy	\N	3711060301	species	\N	\N	\N	2009-01-01 00:00:00
6088	9668	6044	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6089	9669	6088	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6090	9671	5996	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6091	9673	6090	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6092	9675	6091	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6093	9677	6092	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6094	9679	6090	nodc	taxonomy	\N	370415	family	\N	\N	\N	2009-01-01 00:00:00
6095	9681	6094	nodc	taxonomy	\N	37041501	genus	\N	\N	\N	2009-01-01 00:00:00
6096	9683	6090	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6097	9684	6096	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6098	9686	6097	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6099	9688	6090	nodc	taxonomy	\N	370404	family	\N	\N	\N	2009-01-01 00:00:00
6100	9690	6099	nodc	taxonomy	\N	37040419	genus	\N	\N	\N	2009-01-01 00:00:00
6101	9692	6090	nodc	taxonomy	\N	370409	family	\N	\N	\N	2009-01-01 00:00:00
6102	9693	6101	nodc	taxonomy	\N	37040909	genus	\N	\N	\N	2009-01-01 00:00:00
6103	9695	6102	nodc	taxonomy	\N	3704090901	species	\N	\N	\N	2009-01-01 00:00:00
6104	9697	6090	nodc	taxonomy	\N	370407	family	\N	\N	\N	2009-01-01 00:00:00
6105	9699	6104	nodc	taxonomy	\N	37040711	genus	\N	\N	\N	2009-01-01 00:00:00
6106	9701	6090	nodc	taxonomy	\N	370414	family	\N	\N	\N	2009-01-01 00:00:00
6107	9703	6106	nodc	taxonomy	\N	37041403	genus	\N	\N	\N	2009-01-01 00:00:00
6108	9705	6107	nodc	taxonomy	\N	3704140314	species	\N	\N	\N	2009-01-01 00:00:00
6109	9708	6107	nodc	taxonomy	\N	3704140301	species	\N	\N	\N	2009-01-01 00:00:00
6110	9711	6090	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6111	9713	6110	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6112	9715	6090	jana	taxonomy	Bouillon, J., 1985. Essai de classification des hydropolypes-hydromeduses (Hydrozoa-Cnidaria). Indo-Malayan Zoology 2(1): 29-243.	\N	family	\N	\N	\N	2009-01-01 00:00:00
6113	9717	6112	nodc	taxonomy	\N	37032201	genus	\N	\N	\N	2009-01-01 00:00:00
6114	9719	6113	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6115	9720	6112	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6116	9722	6115	jana	taxonomy	Edwards, C. 1973. The medusa Modeeria rotunda and its hydroid Stegopoma fastigiatum, with a review of Stegopoma and Stegolaria. Journal of the Marine Biological Association of the United Kingdom. Vol. 53, no. 3, pp. 573-600.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6117	9725	6112	nodc	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6118	9727	6090	nodc	taxonomy	\N	370408	family	\N	\N	\N	2009-01-01 00:00:00
6119	9729	6118	nodc	taxonomy	\N	37040805	genus	\N	\N	\N	2009-01-01 00:00:00
6120	9731	6119	nodc	taxonomy	\N	3704080504	species	\N	\N	\N	2009-01-01 00:00:00
6121	9734	6118	nodc	taxonomy	\N	37040807	genus	\N	\N	\N	2009-01-01 00:00:00
6122	9736	6121	nodc	taxonomy	\N	3704080701	species	\N	\N	\N	2009-01-01 00:00:00
6123	9738	6118	jana	taxonomy	Collins et. al., 2006	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6124	9740	6123	jana	taxonomy	Collins et. al., 2006	\N	species	\N	\N	\N	2009-01-01 00:00:00
6125	9742	6090	nodc	taxonomy	\N	370413	family	\N	\N	\N	2009-01-01 00:00:00
6126	9743	6125	nodc	taxonomy	\N	37041305	genus	\N	\N	\N	2009-01-01 00:00:00
6127	9745	6090	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6128	9746	6127	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6129	9748	6128	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6130	9750	5996	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6131	9751	6130	jana	taxonomy	\N	371201	family	\N	\N	\N	2009-01-01 00:00:00
6132	9753	6131	nodc	taxonomy	\N	37120101	genus	\N	\N	\N	2009-01-01 00:00:00
6133	9754	6132	nodc	taxonomy	\N	3712010103	species	\N	\N	\N	2009-01-01 00:00:00
6134	9755	6132	unknown	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6135	9756	6131	nodc	taxonomy	\N	37120106	genus	\N	\N	\N	2009-01-01 00:00:00
6136	9758	6135	nodc	taxonomy	\N	3712010601	species	\N	\N	\N	2009-01-01 00:00:00
6137	9760	6131	rodgers	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6138	9761	6137	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6139	9763	6130	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6140	9764	6139	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6141	9765	6139	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6142	9766	6141	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6143	9768	6130	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6144	9770	6143	jana	taxonomy	\N	37120302	genus	\N	\N	\N	2009-01-01 00:00:00
6145	9771	6144	rodgers	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6146	9774	6144	nodc	taxonomy	\N	3712030202	species	\N	\N	\N	2009-01-01 00:00:00
6147	9776	6143	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6148	9778	6130	svonthun	\N	Collins et al, 2006 http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=1617186\nhttp://ctd.mdibl.org\n	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6149	9779	6148	svonthun	\N	http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=1617186\nhttp://ctd.mdibl.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
6150	9780	5995	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6151	9783	5995	jana	taxonomy	\N	3702	order	\N	\N	\N	2009-01-01 00:00:00
6152	9784	5995	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6153	9786	5995	jana	taxonomy	\N	3715	order	\N	\N	\N	2009-01-01 00:00:00
6154	9788	6153	jana	taxonomy	\N	3716	order	sub	\N	\N	2009-01-01 00:00:00
6155	9789	6154	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6156	9790	6155	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6157	9792	6156	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6158	9794	6156	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6159	9796	6156	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6160	9798	6156	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6161	9800	6155	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6162	9802	6161	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6163	9804	6154	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6164	9805	6163	jana	taxonomy	http://sn2000.taxonomy.nl/Main/Classification/117182.htm	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6165	9807	6164	jana	taxonomy	\N	3716010601	species	\N	\N	\N	2009-01-01 00:00:00
6166	9809	6164	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6167	9811	6163	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6168	9813	6167	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6169	9815	6163	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6170	9816	6169	unknown	taxonomy	Pugh, P.R. (2006) Reclassification of the clausophyid siphonophore Clausophyes ovata into the genus Kephyes gen. nov. Journal of the Marine Biological Association of the United Kingdom, 86, (5), 997-1004.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6171	9818	6154	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6172	9819	6171	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6173	9821	6172	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6174	9823	6154	nodc	taxonomy	\N	371601	family	\N	\N	\N	2009-01-01 00:00:00
6175	9824	6174	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6176	9826	6175	jana	taxonomy	\N	37160103	genus	\N	\N	\N	2009-01-01 00:00:00
6177	9828	6176	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6178	9830	6176	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6179	9832	6176	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6180	9833	6176	unknown	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=51278	\N	species	\N	\N	\N	2009-01-01 00:00:00
6181	9834	6174	nodc	taxonomy	\N	37160104	genus	\N	\N	\N	2009-01-01 00:00:00
6182	9836	6154	nodc	taxonomy	\N	371603	family	\N	\N	\N	2009-01-01 00:00:00
6183	9837	6182	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6184	9838	6183	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6185	9840	6184	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6186	9842	6184	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6187	9843	6183	nodc	taxonomy	\N	37160302	genus	\N	\N	\N	2009-01-01 00:00:00
6188	9844	6187	nodc	taxonomy	\N	3716030202	species	\N	\N	\N	2009-01-01 00:00:00
6189	9846	6187	nodc	taxonomy	\N	3716030201	species	\N	\N	\N	2009-01-01 00:00:00
6190	9848	6183	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6191	9850	6190	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6192	9851	6183	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6193	9853	6192	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6194	9855	6183	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6195	9856	6194	unknown	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6196	9857	6183	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6197	9858	6196	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6198	9859	6183	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6199	9860	6198	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6200	9861	6182	svonthun	\N	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6201	9862	6200	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6202	9864	6201	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6203	9866	6200	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6204	9867	6203	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6205	9868	6203	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6206	9869	6203	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6207	9870	6182	svonthun	\N	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6208	9871	6207	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6209	9872	6208	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6210	9874	6208	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6211	9875	6207	svonthun	\N	www.itis.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6212	9876	6211	svonthun	\N	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=719194	\N	species	\N	\N	\N	2009-01-01 00:00:00
6213	9877	6153	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6214	9878	6213	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6215	9880	6214	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6216	9882	6215	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6217	9885	6213	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6218	9887	6217	svonthun	\N	www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6219	9888	6213	jana	taxonomy	\N	371801	family	\N	\N	\N	2009-01-01 00:00:00
6220	9890	6219	nodc	taxonomy	\N	37180102	genus	\N	\N	\N	2009-01-01 00:00:00
6221	9892	6153	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6222	9895	6221	jana	taxonomy	\N	371702	family	\N	\N	\N	2009-01-01 00:00:00
6223	9896	6222	nodc	taxonomy	\N	37170201	genus	\N	\N	\N	2009-01-01 00:00:00
6224	9898	6223	nodc	taxonomy	\N	3717020101	species	\N	\N	\N	2009-01-01 00:00:00
6225	9900	6221	jana	taxonomy	\N	371701	family	\N	\N	\N	2009-01-01 00:00:00
6226	9902	6225	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6227	9903	6226	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6228	9905	6226	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6229	9907	6225	nodc	taxonomy	\N	37170103	genus	\N	\N	\N	2009-01-01 00:00:00
6230	9908	6229	nodc	taxonomy	\N	3717010301	species	\N	\N	\N	2009-01-01 00:00:00
6231	9909	6229	nodc	taxonomy	\N	3717010302	species	\N	\N	\N	2009-01-01 00:00:00
6232	9910	6225	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6233	9911	6232	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6234	9913	6225	nodc	taxonomy	\N	37170107	genus	\N	\N	\N	2009-01-01 00:00:00
6235	9914	6234	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6236	9916	6225	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6237	9919	6225	nodc	taxonomy	\N	37170101	genus	\N	\N	\N	2009-01-01 00:00:00
6238	9920	6225	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6239	9921	6238	unknown	taxonomy	Dunn, C.W., P.R. Pugh, and S.H.D. Haddock (in press, May 2005) Marrus claudanielis, a new species of deep-sea physonect siphonophore, (Siphonophora, Physonectae). Bull. Mar. Sci.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6240	9922	6238	svonthun	\N	www.itis.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6241	9923	6225	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6242	9924	6225	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6243	9925	6242	svonthun	\N	http://www.lifesci.ucsb.edu/~haddock/abstracts/dunn-SysBio-2005.pdf	\N	species	\N	\N	\N	2009-01-01 00:00:00
6244	9926	6221	jana	taxonomy	http://erms.biol.soton.ac.uk/lists/brief/Siphonophora.shtml	\N	family	\N	\N	\N	2009-01-01 00:00:00
6245	9927	6244	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6246	9928	6245	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6247	9930	6245	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6248	9932	6245	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6249	9934	6221	jana	taxonomy	\N	371704	family	\N	\N	\N	2009-01-01 00:00:00
6250	9935	6249	nodc	taxonomy	\N	37170401	genus	\N	\N	\N	2009-01-01 00:00:00
6251	9937	6250	nodc	taxonomy	\N	3717040101	species	\N	\N	\N	2009-01-01 00:00:00
6252	9940	6249	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6253	9941	6252	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6254	9942	6249	svonthun	\N	www.itis.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6255	9943	6254	svonthun	\N	http://www.lifesci.ucsb.edu/~haddock/abstracts/dunn-SysBio-2005.pdf	\N	species	\N	\N	\N	2009-01-01 00:00:00
6256	9944	6221	jana	taxonomy	\N	371706	family	\N	\N	\N	2009-01-01 00:00:00
6257	9945	6256	nodc	taxonomy	\N	37170601	genus	\N	\N	\N	2009-01-01 00:00:00
6258	9947	6257	nodc	taxonomy	\N	3717060101	species	\N	\N	\N	2009-01-01 00:00:00
6259	9949	6221	jana	taxonomy	\N	371705	family	\N	\N	\N	2009-01-01 00:00:00
6260	9950	6259	nodc	taxonomy	\N	37170502	genus	\N	\N	\N	2009-01-01 00:00:00
6261	9952	6260	nodc	taxonomy	\N	3717050202	species	\N	\N	\N	2009-01-01 00:00:00
6262	9954	6260	nodc	taxonomy	\N	3717050201	species	\N	\N	\N	2009-01-01 00:00:00
6263	9956	6260	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6264	9958	6221	svonthun	\N	Pugh, P.R. (2001) A review of the genus Erenna Bedot, 1904 (Siphonophora, Physonectae). Bulletin\nof the Natural History Museum, London (Zoology Series), 67, 169–182.	\N	family	\N	\N	\N	2009-01-01 00:00:00
6265	9959	6264	nodc	taxonomy	\N	37170106	genus	\N	\N	\N	2009-01-01 00:00:00
6266	9961	6265	nodc	taxonomy	\N	3717010601	species	\N	\N	\N	2009-01-01 00:00:00
6267	9963	6265	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6268	9964	6265	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6269	9965	6221	svonthun	\N	Pugh, P.R.  The taxonomic status of the genus Moseria (Siphonophora, Physonectae). Zootaxa Volume: 1343 Page(s): 1-42 Published: Oct 26 2006 	\N	family	\N	\N	\N	2009-01-01 00:00:00
6270	9966	6269	svonthun	\N	Pugh, P.R.  The taxonomic status of the genus Moseria (Siphonophora, Physonectae). Zootaxa Volume: 1343 Page(s): 1-42 Published: Oct 26 2006	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6271	9967	5995	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6272	9969	6271	jana	taxonomy	\N	370901	family	\N	\N	\N	2009-01-01 00:00:00
6273	9971	6272	nodc	taxonomy	\N	37090105	genus	\N	\N	\N	2009-01-01 00:00:00
6274	9974	6273	nodc	taxonomy	\N	3709010508	species	\N	\N	\N	2009-01-01 00:00:00
6275	9978	5995	jana	\N	Bouillon, J.; Boero, F. (2000). Synopsis of the families and genera of the Hydromedusae of the world, with a list of the worldwide species. Thalassia Salent. 24: 47-296	\N	class	\N	\N	\N	2009-01-01 00:00:00
6276	9979	3916	jana	taxonomy	\N	38	phylum	\N	\N	\N	2009-01-01 00:00:00
6277	9981	6276	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6278	9983	6277	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6279	9985	6278	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6280	9987	6279	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6281	9989	6280	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6282	9991	6278	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6283	9993	6282	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6284	9995	6277	jana	taxonomy	\N	3802	order	\N	\N	\N	2009-01-01 00:00:00
6285	9997	6284	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6286	9999	6285	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6287	10001	6286	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6288	10004	6284	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6289	10006	6288	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6290	10008	6288	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6291	10010	6284	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6292	10012	6291	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6293	10014	6292	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6294	10016	6292	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6295	10018	6284	nodc	taxonomy	\N	380201	family	\N	\N	\N	2009-01-01 00:00:00
6296	10020	6295	nodc	taxonomy	\N	38020102	genus	\N	\N	\N	2009-01-01 00:00:00
6297	10022	6296	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6298	10024	6295	nodc	taxonomy	\N	38020101	genus	\N	\N	\N	2009-01-01 00:00:00
6299	10026	6298	nodc	taxonomy	\N	3802010101	species	\N	\N	\N	2009-01-01 00:00:00
6300	10029	6284	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6301	10031	6300	rodgers	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6302	10033	6300	jana	taxonomy	\N	38020401	genus	\N	\N	\N	2009-01-01 00:00:00
6303	10035	6302	nodc	taxonomy	\N	3802040101	species	\N	\N	\N	2009-01-01 00:00:00
6304	10037	6284	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6305	10039	6304	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6306	10041	6305	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6307	10043	6284	svonthun	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6308	10044	6307	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6309	10045	6308	svonthun	\N	http://faculty.washington.edu/cemills/Ctenolist.html	\N	species	\N	\N	\N	2009-01-01 00:00:00
6310	10046	6277	nodc	taxonomy	\N	3804	order	\N	\N	\N	2009-01-01 00:00:00
6311	10048	6310	nodc	taxonomy	\N	380401	family	\N	\N	\N	2009-01-01 00:00:00
6312	10050	6311	nodc	taxonomy	\N	38040102	genus	\N	\N	\N	2009-01-01 00:00:00
6313	10052	6312	nodc	taxonomy	\N	3804010201	species	\N	\N	\N	2009-01-01 00:00:00
6314	10054	6311	nodc	taxonomy	\N	38040101	genus	\N	\N	\N	2009-01-01 00:00:00
6315	10056	6314	nodc	taxonomy	\N	3804010101	species	\N	\N	\N	2009-01-01 00:00:00
6316	10060	6277	nodc	taxonomy	\N	3803	order	\N	\N	\N	2009-01-01 00:00:00
6317	10063	6316	lonny	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6318	10065	6317	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6319	10067	6318	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6320	10069	6316	nodc	taxonomy	\N	38030301	genus	\N	\N	\N	2009-01-01 00:00:00
6321	10071	6320	nodc	taxonomy	\N	3803030102	species	\N	\N	\N	2009-01-01 00:00:00
6322	10073	6316	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6323	10075	6322	jana	taxonomy	\N	38030103	genus	\N	\N	\N	2009-01-01 00:00:00
6324	10077	6323	nodc	taxonomy	\N	3803010301	species	\N	\N	\N	2009-01-01 00:00:00
6325	10079	6316	lonny	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6326	10081	6325	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6327	10083	6326	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6328	10085	6327	lonny	taxonomy	www.itis.usda.gov	\N	species	sub	\N	\N	2009-01-01 00:00:00
6329	10087	6327	lonny	taxonomy	www.itis.usda.gov	\N	species	sub	\N	\N	2009-01-01 00:00:00
6330	10089	6326	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6331	10091	6330	lonny	taxonomy	www.itis.usda.gov	\N	species	sub	\N	\N	2009-01-01 00:00:00
6332	10093	6330	lonny	taxonomy	www.itis.usda.gov	\N	species	sub	\N	\N	2009-01-01 00:00:00
6333	10095	6316	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6334	10097	6316	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6335	10099	6334	jana	taxonomy	\N	38030102	genus	\N	\N	\N	2009-01-01 00:00:00
6336	10101	6335	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6337	10103	6316	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6338	10105	6316	conn	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6339	10107	6338	conn	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6340	10109	6316	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6341	10111	6340	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6342	10114	6341	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6343	10116	6316	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6344	10118	6343	nodc	taxonomy	\N	38030101	genus	\N	\N	\N	2009-01-01 00:00:00
6345	10120	6344	nodc	taxonomy	\N	3803010101	species	\N	\N	\N	2009-01-01 00:00:00
6346	10122	6277	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6347	10124	6346	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6348	10126	6347	jana	taxonomy	\N	38080101	genus	\N	\N	\N	2009-01-01 00:00:00
6349	10128	6348	nodc	taxonomy	\N	3808010101	species	\N	\N	\N	2009-01-01 00:00:00
6350	10130	6277	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6351	10133	6276	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6352	10135	6276	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6353	10137	6352	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6354	10139	6353	nodc	taxonomy	\N	38070101	genus	\N	\N	\N	2009-01-01 00:00:00
6355	10141	6354	nodc	taxonomy	\N	3807010104	species	\N	\N	\N	2009-01-01 00:00:00
6356	10143	6354	nodc	taxonomy	\N	3807010101	species	\N	\N	\N	2009-01-01 00:00:00
6357	10145	6354	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6358	10147	6354	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6359	10149	6276	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6360	10151	3916	jana	taxonomy	\N	39	phylum	\N	\N	\N	2009-01-01 00:00:00
6361	10153	6360	nodc	taxonomy	\N	3901	class	\N	\N	\N	2009-01-01 00:00:00
6362	10156	6360	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6363	10158	6362	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6364	10160	6363	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6365	10162	3916	jana	taxonomy	\N	82	phylum	\N	\N	\N	2009-01-01 00:00:00
6366	10164	6365	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6367	10166	6365	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6368	10170	3916	jana	taxonomy	\N	\N	phylum	\N	\N	\N	2009-01-01 00:00:00
6369	10175	6368	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6370	10177	6369	jana	taxonomy	\N	730102	family	\N	\N	\N	2009-01-01 00:00:00
6371	10179	6369	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6372	10181	6368	nodc	taxonomy	\N	7302	order	\N	\N	\N	2009-01-01 00:00:00
6373	10183	6372	nodc	taxonomy	\N	730201	family	\N	\N	\N	2009-01-01 00:00:00
6374	10185	6373	nodc	taxonomy	\N	73020101	genus	\N	\N	\N	2009-01-01 00:00:00
6375	10189	6374	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6376	10191	6368	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6377	10193	6376	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6378	10195	6377	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6379	10197	3916	jana	taxonomy	\N	50	phylum	\N	\N	\N	2009-01-01 00:00:00
6380	10200	6379	nodc	taxonomy	\N	5001	class	\N	\N	\N	2009-01-01 00:00:00
6381	10204	6380	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6382	10205	6381	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
6383	10206	6382	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6384	10207	6383	jana	taxonomy	\N	500110	family	\N	\N	\N	2009-01-01 00:00:00
6385	10209	6382	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6386	10210	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6387	10211	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6388	10212	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6389	10213	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6390	10214	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6391	10215	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6392	10216	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6393	10217	6392	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6394	10218	6393	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6395	10219	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6396	10220	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6397	10221	6396	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6398	10222	6397	lonny	taxonomy	www.ntnu.no/~vmzotbak/polychaeta/nereidae/nereidinae/nereis.htm	\N	species	\N	\N	\N	2009-01-01 00:00:00
6399	10223	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6400	10224	6399	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6401	10225	6400	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6402	10226	6399	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6403	10227	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6404	10228	6403	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6405	10229	6404	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6406	10230	6403	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6407	10231	6406	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6408	10232	6385	jana	taxonomy	\N	500120	family	\N	\N	\N	2009-01-01 00:00:00
6409	10233	6408	nodc	taxonomy	\N	50012001	genus	\N	\N	\N	2009-01-01 00:00:00
6410	10234	6409	rodgers	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6411	10236	6409	nodc	taxonomy	\N	5001200102	species	\N	\N	\N	2009-01-01 00:00:00
6412	10237	6385	jana	taxonomy	\N	500114	family	\N	\N	\N	2009-01-01 00:00:00
6413	10239	6412	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6414	10240	6412	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6415	10241	6412	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6416	10242	6412	jana	taxonomy	\N	50011407	genus	\N	\N	\N	2009-01-01 00:00:00
6417	10243	6416	nodc	taxonomy	\N	5001140701	species	\N	\N	\N	2009-01-01 00:00:00
6418	10244	6412	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6419	10245	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6420	10246	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6421	10247	6420	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6422	10248	6421	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6423	10249	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6424	10250	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6425	10251	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6426	10252	6425	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6427	10253	6426	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6428	10254	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6429	10255	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6430	10256	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6431	10257	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6432	10258	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6433	10259	6432	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6434	10260	6385	jana	taxonomy	\N	500102	family	\N	\N	\N	2009-01-01 00:00:00
6435	10262	6434	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6436	10263	6435	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6437	10264	6434	lonny	taxonomy	Proccedings of the Biological Society of Washington. Washington DC, vol. 98, no. 2, pp. 447-469, 1985	\N	family	sub	\N	\N	2009-01-01 00:00:00
6438	10265	6437	lonny	taxonomy	Proccedings of the Biological Society of Washington. Washington DC, vol. 98, no. 2, pp. 447-469, 1985	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6439	10266	6438	lonny	taxonomy	Proccedings of the Biological Society of Washington. Washington DC, vol. 98, no. 2, pp. 447-469, 1985	\N	species	\N	\N	\N	2009-01-01 00:00:00
6440	10267	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6441	10268	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6442	10269	6441	linda	\N	Fauchald, K. 1977. The polychaete worms: Definitions and keys to the orders, families, and genera. Natural History Museum of Los Angeles County, Science Series 28.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6443	10270	6385	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6444	10271	6443	unknown	taxonomy	Fauchald, K. 1977. The polychaete worms: Definitions and keys to the orders, families, and genera. Natural History Museum of Los Angeles County, Science Series 28. 190.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6445	10272	6382	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6446	10273	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6447	10274	6446	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6448	10275	6447	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6449	10276	6446	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6450	10277	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6451	10278	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6452	10279	6451	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6453	10280	6452	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6454	10281	6452	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6455	10282	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6456	10283	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6457	10284	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6458	10285	6445	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6459	10286	6381	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
6460	10287	6459	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6461	10288	6460	jana	taxonomy	\N	500173	family	\N	\N	\N	2009-01-01 00:00:00
6462	10289	6461	nodc	taxonomy	\N	50017319	genus	\N	\N	\N	2009-01-01 00:00:00
6463	10290	6460	jana	taxonomy	\N	500170	family	\N	\N	\N	2009-01-01 00:00:00
6464	10291	6463	nodc	taxonomy	\N	50017005	genus	\N	\N	\N	2009-01-01 00:00:00
6465	10292	6463	linda	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6466	10293	6460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6467	10294	6460	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6468	10295	6460	jana	taxonomy	Rouse, Greg W. June 2000. A cladistic analysis of Siboglinidae Caullery, 1914 (Polychaeta, Annelida): formerly the phyla Pogonophora and Vestimentifera. Zoological Journal of the Linnean Society (2001), 132: 55-80.	\N	family	\N	\N	\N	2009-01-01 00:00:00
6469	10300	6468	jana	taxonomy	Rouse G.W., S.K. Goffredi, R.C. Vrijenhoek RC. 2004. Osedax: Bone-Eating Marine Worms with Dwarf Males. Science 305: 668-671.	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6470	10301	6468	nodc	taxonomy	\N	71020105	genus	\N	\N	\N	2009-01-01 00:00:00
6471	10302	6468	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6472	10303	6471	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6473	10304	6468	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6474	10305	6473	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6475	10306	6468	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6476	10307	6475	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6477	10308	6468	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6478	10309	6468	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6479	10310	6468	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6480	10311	6479	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6481	10312	6460	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6482	10313	6481	jana	taxonomy	\N	50017305	genus	\N	\N	\N	2009-01-01 00:00:00
6483	10314	6459	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6484	10315	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6485	10316	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6486	10317	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6487	10318	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6488	10319	6487	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6489	10320	6488	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6490	10321	6487	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6491	10322	6490	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6492	10323	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6493	10324	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6494	10325	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6495	10326	6494	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6496	10327	6494	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6497	10328	6496	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6498	10329	6483	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6499	10330	6459	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6500	10331	6499	jana	taxonomy	\N	500168	family	\N	\N	\N	2009-01-01 00:00:00
6501	10332	6500	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6502	10333	6501	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6503	10334	6500	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6504	10335	6499	jana	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6505	10336	6504	lonny	taxonomy	Desbruyeres and Laubier, Oceanol. Acta, 3(3), 267-274, 1980	\N	family	sub	\N	\N	2009-01-01 00:00:00
6506	10337	6505	lonny	taxonomy	Desbruyeres and Laubier, Oceanol. Acta, 3(3), 267-274, 1980	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6507	10338	6506	lonny	taxonomy	Desbruyeres and Laubier, Oceanol. Acta, 3(3), 267-274, 1980	\N	species	\N	\N	\N	2009-01-01 00:00:00
6508	10339	6506	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6509	10340	6505	lonny	taxonomy	Desbruyeres and Laubier, PROC. BIOL. SOC. WASH., vol. 95 no.3, pp. 484-494, 1982	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6510	10341	6509	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6511	10342	6509	lonny	taxonomy	Desbruyeres and Laubier, PROC. BIOL. SOC. WASH., vol. 95 no.3, pp. 484-494, 1982	\N	species	\N	\N	\N	2009-01-01 00:00:00
6512	10343	6509	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6513	10344	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6514	10345	6513	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6515	10346	6513	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6516	10347	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6517	10348	6516	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6518	10349	6517	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6519	10350	6517	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6520	10351	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6521	10352	6520	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6522	10353	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6523	10354	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6524	10355	6523	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6525	10356	6524	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6526	10357	6523	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6527	10358	6526	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6528	10359	6523	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6529	10360	6523	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6530	10361	6529	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6531	10362	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6532	10363	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6533	10364	6532	jana	taxonomy	\N	50015601	genus	\N	\N	\N	2009-01-01 00:00:00
6534	10365	6533	nodc	taxonomy	\N	5001560101	species	\N	\N	\N	2009-01-01 00:00:00
6535	10368	6532	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6536	10370	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6537	10371	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6538	10372	6537	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6539	10373	6537	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6540	10374	6537	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6541	10375	6537	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6542	10376	6541	lonny	taxonomy	PROC. BIOL. SOC. WASH., vol. 96, no. 3, pp. 379-391, 1983	\N	species	\N	\N	\N	2009-01-01 00:00:00
6543	10377	6499	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6544	10378	6543	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6545	10379	6499	jana	taxonomy	\N	500166	family	\N	\N	\N	2009-01-01 00:00:00
6546	10380	6545	nodc	taxonomy	\N	50016603	genus	\N	\N	\N	2009-01-01 00:00:00
6547	10381	6546	nodc	taxonomy	\N	5001660304	species	\N	\N	\N	2009-01-01 00:00:00
6548	10382	6380	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6549	10383	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6550	10384	6549	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6551	10385	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6552	10386	6551	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6553	10387	6552	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6554	10388	6551	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6555	10389	6554	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6556	10390	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6557	10391	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6558	10392	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6559	10393	6558	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6560	10394	6559	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6561	10395	6558	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6562	10396	6561	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6563	10397	6558	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6564	10398	6563	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6565	10399	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6566	10400	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6567	10401	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6568	10402	6567	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6569	10403	6548	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6570	10404	6379	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6571	10406	6379	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6572	10407	3916	jana	taxonomy	\N	5085	phylum	\N	\N	\N	2009-01-01 00:00:00
6573	10408	6572	jana	taxonomy	\N	51	class	\N	\N	\N	2009-01-01 00:00:00
6574	10412	6573	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6575	10414	6574	jana	taxonomy	\N	5103	order	\N	\N	\N	2009-01-01 00:00:00
6576	10415	6575	jana	taxonomy	american-fisheries-society-publication-16	\N	family	\N	\N	\N	2009-01-01 00:00:00
6577	10417	6576	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6578	10419	6577	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6579	10421	6575	lonny	taxonomy	www.nhm.org	\N	family	\N	\N	\N	2009-01-01 00:00:00
6580	10423	6579	lonny	taxonomy	www.nhm.org	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6581	10425	6580	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6582	10427	6575	jana	taxonomy	\N	510335	family	\N	\N	\N	2009-01-01 00:00:00
6583	10430	6582	nodc	taxonomy	\N	51033504	genus	\N	\N	\N	2009-01-01 00:00:00
6584	10433	6583	nodc	taxonomy	\N	5103350402	species	\N	\N	\N	2009-01-01 00:00:00
6585	10435	6575	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6586	10438	6585	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6587	10440	6586	rodgers	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6588	10442	6587	rodgers	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6589	10444	6586	jana	taxonomy	\N	510374	family	\N	\N	\N	2009-01-01 00:00:00
6590	10446	6589	nodc	taxonomy	\N	51037401	genus	\N	\N	\N	2009-01-01 00:00:00
6591	10448	6590	nodc	taxonomy	\N	5103740101	species	\N	\N	\N	2009-01-01 00:00:00
6592	10450	6590	nodc	taxonomy	\N	5103740102	species	\N	\N	\N	2009-01-01 00:00:00
6593	10452	6574	jana	taxonomy	\N	5102	order	\N	\N	\N	2009-01-01 00:00:00
6594	10453	6593	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6595	10454	6594	jana	taxonomy	\N	510204	family	\N	\N	\N	2009-01-01 00:00:00
6596	10457	6593	lonny	taxonomy	www.itis.usda.gov	\N	family	super	\N	\N	2009-01-01 00:00:00
6597	10458	6596	lonny	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6598	10460	6597	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6599	10462	6598	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6600	10464	6593	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6601	10465	6600	jana	taxonomy	\N	510210	family	\N	\N	\N	2009-01-01 00:00:00
6602	10467	6601	nodc	taxonomy	\N	51021023	genus	\N	\N	\N	2009-01-01 00:00:00
6603	10469	6602	nodc	taxonomy	\N	5102102301	species	\N	\N	\N	2009-01-01 00:00:00
6604	10471	6601	nodc	taxonomy	\N	51021001	genus	\N	\N	\N	2009-01-01 00:00:00
6605	10473	6604	nodc	taxonomy	\N	5102100154	species	\N	\N	\N	2009-01-01 00:00:00
6606	10476	6593	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6607	10477	6606	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6608	10479	6607	jana	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6609	10481	6608	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6610	10483	6608	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6611	10485	6593	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6612	10486	6611	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6613	10489	6612	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6614	10491	6613	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6615	10494	6612	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6616	10496	6593	nodc	taxonomy	\N	510203	family	\N	\N	\N	2009-01-01 00:00:00
6617	10497	6616	nodc	taxonomy	\N	51020301	genus	\N	\N	\N	2009-01-01 00:00:00
6618	10499	6617	nodc	taxonomy	\N	5102030102	species	\N	\N	\N	2009-01-01 00:00:00
6619	10502	6573	nodc	taxonomy	\N	5127	order	\N	\N	\N	2009-01-01 00:00:00
6620	10504	6619	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6621	10506	6620	jana	taxonomy	\N	513401	family	\N	\N	\N	2009-01-01 00:00:00
6622	10508	6621	nodc	taxonomy	\N	51340102	genus	\N	\N	\N	2009-01-01 00:00:00
6623	10510	6622	nodc	taxonomy	\N	5134010201	species	\N	\N	\N	2009-01-01 00:00:00
6624	10513	6621	nodc	taxonomy	\N	51340101	genus	\N	\N	\N	2009-01-01 00:00:00
6625	10515	6624	nodc	taxonomy	\N	5134010102	species	\N	\N	\N	2009-01-01 00:00:00
6626	10518	6624	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6627	10519	6620	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6628	10521	6627	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6629	10523	6619	nodc	taxonomy	\N	5128	order	sub	\N	\N	2009-01-01 00:00:00
6630	10524	6629	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6631	10525	6630	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6632	10526	6619	nodc	taxonomy	\N	5139	order	sub	\N	\N	2009-01-01 00:00:00
6633	10528	6619	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6634	10530	6619	lonny	\N	Behrens, D.W. 2004. Pacific Coast Nudibranchs, Supplement II: New Species to the Pacific Coast and New Information on the Oldies. Proc. Calif. Academy Sciences, 55(2): 11-54	\N	order	sub	\N	\N	2009-01-01 00:00:00
6635	10531	6634	lonny	\N	Behrens, D.W. 2004. Pacific Coast Nudibranchs, Supplement II: New Species to the Pacific Coast and New Information on the Oldies. Proc. Calif. Academy Sciences, 55(2): 11-54	\N	family	\N	\N	\N	2009-01-01 00:00:00
6636	10533	6635	lonny	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6637	10534	6636	lonny	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6638	10536	6573	nodc	taxonomy	\N	5181	class	sub	\N	\N	2009-01-01 00:00:00
6639	10538	6638	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6640	10540	6639	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6641	10542	6640	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6642	10544	6641	jana	taxonomy	\N	51260203	genus	\N	\N	\N	2009-01-01 00:00:00
6643	10546	6642	nodc	taxonomy	\N	5126020303	species	\N	\N	\N	2009-01-01 00:00:00
6644	10548	6638	jana	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
6645	10550	6644	jana	taxonomy	\N	5125	order	\N	\N	\N	2009-01-01 00:00:00
6646	10553	6645	nodc	taxonomy	\N	512506	family	\N	\N	\N	2009-01-01 00:00:00
6647	10555	6646	nodc	taxonomy	\N	51250601	genus	\N	\N	\N	2009-01-01 00:00:00
6648	10557	6647	nodc	taxonomy	\N	5125060101	species	\N	\N	\N	2009-01-01 00:00:00
6649	10559	6644	nodc	taxonomy	\N	5113	order	\N	\N	\N	2009-01-01 00:00:00
6650	10562	6649	jana	taxonomy	sn2000.taxonomy.nl	\N	order	sub	\N	\N	2009-01-01 00:00:00
6651	10564	6650	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6652	10566	6651	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6653	10568	6651	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6654	10570	6651	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6655	10572	6573	jana	taxonomy	www.natureserve.org	\N	order	\N	\N	\N	2009-01-01 00:00:00
6656	10573	6655	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp. 485-528, 1990	\N	order	sub	\N	\N	2009-01-01 00:00:00
6657	10574	6656	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp. 485-528, 1990	\N	family	super	\N	\N	2009-01-01 00:00:00
6658	10575	6657	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp. 485-528, 1990	\N	family	\N	\N	\N	2009-01-01 00:00:00
6659	10576	6658	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp.485-528, 1990	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6660	10577	6659	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6661	10578	6658	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp.485-528, 1990	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6662	10579	6661	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6663	10580	6658	lonny	taxonomy	J. ZOOL., vol. 222, no. 3, pp.485-528, 1990	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6664	10581	6663	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6665	10582	6655	jana	\N	Lindberg, D.R. (1998) Order Patellogastropoda in Mollusca: The Southern Synthesis Part B pg. 639-652\n	\N	order	sub	\N	\N	2009-01-01 00:00:00
6666	10583	6573	nodc	taxonomy	\N	5104	order	\N	\N	\N	2009-01-01 00:00:00
6667	10585	6666	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6668	10586	6667	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6669	10587	6668	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6670	10589	6667	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6671	10590	6670	lonny	taxonomy	ITIS, www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6672	10591	6671	jana	taxonomy	\N	51050503	genus	\N	\N	\N	2009-01-01 00:00:00
6673	10593	6671	jana	taxonomy	\N	51050508	genus	\N	\N	\N	2009-01-01 00:00:00
6674	10595	6673	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6675	10597	6671	lonny	taxonomy	ITIS, www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6676	10598	6671	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6677	10599	6671	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6678	10600	6667	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6679	10601	6678	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6680	10603	6679	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6681	10605	6680	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6682	10607	6679	jana	taxonomy	\N	51050302	genus	\N	\N	\N	2009-01-01 00:00:00
6683	10609	6679	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6684	10611	6683	lonny	taxonomy	Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel, Volume 9, Santa Barbara Museum of Natural History, pg 110	\N	species	\N	\N	\N	2009-01-01 00:00:00
6685	10614	6573	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6686	10615	6573	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6687	10616	6572	jana	taxonomy	\N	53	class	\N	\N	\N	2009-01-01 00:00:00
6688	10619	6687	nodc	taxonomy	\N	5301	order	\N	\N	\N	2009-01-01 00:00:00
6689	10622	6572	jana	taxonomy	\N	56	class	\N	\N	\N	2009-01-01 00:00:00
6690	10624	6572	jana	taxonomy	\N	55	class	\N	\N	\N	2009-01-01 00:00:00
6691	10628	6690	nodc	taxonomy	\N	5502	order	\N	\N	\N	2009-01-01 00:00:00
6692	10629	6691	nodc	taxonomy	\N	550201	family	\N	\N	\N	2009-01-01 00:00:00
6693	10630	6691	nodc	taxonomy	\N	550204	family	\N	\N	\N	2009-01-01 00:00:00
6694	10631	6693	nodc	taxonomy	\N	55020402	genus	\N	\N	\N	2009-01-01 00:00:00
6695	10632	6694	lonny	taxonomy	Malacologia, 35(1):141-151, 1993	\N	species	\N	\N	\N	2009-01-01 00:00:00
6696	10633	6690	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6697	10634	6696	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6698	10635	6697	lonny	taxonomy	www.itis.usda.gov	\N	family	super	\N	\N	2009-01-01 00:00:00
6699	10636	6698	lonny	taxonomy	www.itis.usda.gov	\N	family	\N	\N	\N	2009-01-01 00:00:00
6700	10637	6699	lonny	taxonomy	www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6701	10638	6700	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6702	10639	6700	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6703	10640	6700	lonny	taxonomy	www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6704	10642	6697	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6705	10643	6704	jana	taxonomy	Barry, J.P., H.G. Greene, D.L. Orange, C.H. Baxter, B.H. Robison, R.E. Kochevar, J.W. Nybakken, D.L. Reed, and C.M. McHugh. 1996. Biologic and geologic characteristics of cold seeps in Monterey Bay, California.	551544	family	\N	\N	\N	2009-01-01 00:00:00
6706	10646	6705	nodc	taxonomy	\N	55154402	genus	\N	\N	\N	2009-01-01 00:00:00
6707	10647	6705	nodc	taxonomy	\N	55154401	genus	\N	\N	\N	2009-01-01 00:00:00
6708	10648	6707	nodc	taxonomy	\N	5515440101	species	\N	\N	\N	2009-01-01 00:00:00
6709	10649	6707	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6710	10650	6707	lonny	taxonomy	Malacologia, 20(1), 161-194, 1980	\N	species	\N	\N	\N	2009-01-01 00:00:00
6711	10651	6707	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6712	10652	6707	unknown	taxonomy	per J Barry. Coan et al. 2000, Bivalve seashells of Western North America SBMNH	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6713	10653	6707	unknown	taxonomy	Coan et al. 2000, Bivalve seashells of Western North America SBMNH	\N	species	\N	\N	\N	2009-01-01 00:00:00
6714	10655	6707	unknown	taxonomy	Coan et al. 2000, Bivalve seashells of Western North America SBMNH	\N	species	\N	\N	\N	2009-01-01 00:00:00
6715	10657	6707	unknown	taxonomy	Coan et al. 2000, Bivalve seashells of Western North America SBMNH	\N	species	\N	\N	\N	2009-01-01 00:00:00
6716	10659	6705	unknown	taxonomy	Krylova, N. M. Moskalev, L. I. 1996 Ectenagena extenta, a new vesicomyid bivalve species from Monterey Bay, California Ruthenica, 6(1): 1-10 	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6717	10660	6716	unknown	taxonomy	Krylova, N. M. Moskalev, L. I. 1996 Ectenagena extenta, a new vesicomyid bivalve species from Monterey Bay, California Ruthenica, 6(1): 1-10 	\N	species	\N	\N	\N	2009-01-01 00:00:00
6718	10661	6690	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6719	10662	6718	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6720	10663	6719	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6721	10664	6720	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6722	10665	6721	jana	taxonomy	\N	55020405	genus	\N	\N	\N	2009-01-01 00:00:00
6723	10666	6722	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6724	10667	6722	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6725	10668	6718	jana	taxonomy	\N	5504	order	\N	\N	\N	2009-01-01 00:00:00
6726	10669	6725	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6727	10670	6726	jana	taxonomy	\N	550401	family	\N	\N	\N	2009-01-01 00:00:00
6728	10671	6727	nodc	taxonomy	\N	55040101	genus	\N	\N	\N	2009-01-01 00:00:00
6729	10672	6690	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6730	10673	6729	jana	taxonomy	\N	5505	class	sub	\N	\N	2009-01-01 00:00:00
6731	10675	6730	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6732	10676	6731	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6733	10679	6731	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6734	10680	6733	jana	taxonomy	\N	550905	family	\N	\N	\N	2009-01-01 00:00:00
6735	10682	6734	nodc	taxonomy	\N	55090503	genus	\N	\N	\N	2009-01-01 00:00:00
6736	10683	6734	nodc	taxonomy	\N	55090501	genus	\N	\N	\N	2009-01-01 00:00:00
6737	10684	6730	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6738	10685	6730	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6739	10686	6738	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6740	10687	6739	jana	taxonomy	\N	550910	family	\N	\N	\N	2009-01-01 00:00:00
6741	10688	6740	nodc	taxonomy	\N	55091001	genus	\N	\N	\N	2009-01-01 00:00:00
6742	10689	6740	lonny	taxonomy	http://www.itis.usda.gov/	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6743	10690	6742	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6744	10691	6742	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6745	10692	6730	jana	taxonomy	\N	5506	order	\N	\N	\N	2009-01-01 00:00:00
6746	10693	6572	jana	taxonomy	\N	54	class	\N	\N	\N	2009-01-01 00:00:00
6747	10694	6572	jana	taxonomy	www.cephbase.dal.ca	57	class	\N	\N	\N	2009-01-01 00:00:00
6748	10695	6747	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6749	10697	6747	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6750	10699	6749	jana	taxonomy	www.cephbase.org	\N	order	super	\N	\N	2009-01-01 00:00:00
6751	10701	6750	jana	taxonomy	\N	5708	order	\N	\N	\N	2009-01-01 00:00:00
6752	10702	6751	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6753	10704	6752	jana	taxonomy	\N	570801	family	\N	\N	\N	2009-01-01 00:00:00
6754	10706	6753	jana	taxonomy	www.itis.usda.gov	\N	family	sub	\N	\N	2009-01-01 00:00:00
6755	10707	6754	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6756	10708	6755	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6757	10710	6754	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6758	10712	6753	jana	taxonomy	www.itis.usda.gov	\N	family	sub	\N	\N	2009-01-01 00:00:00
6759	10713	6753	jana	taxonomy	www.itis.usda.gov	\N	family	sub	\N	\N	2009-01-01 00:00:00
6760	10714	6759	jana	taxonomy	\N	57080102	genus	\N	\N	\N	2009-01-01 00:00:00
6761	10715	6760	nodc	taxonomy	\N	5708010203	species	\N	\N	\N	2009-01-01 00:00:00
6762	10718	6759	lonny	taxonomy	www.cephbase.org, www.itis.usda.gov	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6763	10719	6762	lonny	taxonomy	www.cephbase.org, www.itis.usda.gov	\N	species	\N	\N	\N	2009-01-01 00:00:00
6764	10722	6753	jana	taxonomy	www.itis.usda.gov	\N	family	sub	\N	\N	2009-01-01 00:00:00
6765	10724	6764	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6766	10725	6765	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6767	10726	6765	jana	taxonomy	www.cephbase.utmb.edu	\N	species	\N	\N	\N	2009-01-01 00:00:00
6768	10729	6765	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6769	10730	6765	jana	taxonomy	Eugene Coan, Douglas Eernisse, F.G. Hochberg, Amélie Scheltema, Paul Valentich Scott and Ronald Shimek. 1998. Taxonomic Atlas of the Benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 8: The Mollusca Part 1 Aplacophora, Polyplacophora, Scaphopoda, Bivalvia and Cephalopoda. Santa Barbara Museum of Natural History.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6770	10731	6765	linda	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6771	10732	6752	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6772	10733	6771	jana	taxonomy	\N	57080301	genus	\N	\N	\N	2009-01-01 00:00:00
6773	10736	6772	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6774	10738	6752	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6775	10739	6774	jana	taxonomy	\N	57080201	genus	\N	\N	\N	2009-01-01 00:00:00
6776	10741	6775	nodc	taxonomy	\N	5708020101	species	\N	\N	\N	2009-01-01 00:00:00
6777	10743	6774	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6778	10745	6751	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6779	10747	6778	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6780	10749	6779	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6781	10751	6778	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6782	10753	6781	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6783	10755	6778	jana	taxonomy	\N	570807	family	\N	\N	\N	2009-01-01 00:00:00
6784	10757	6783	nodc	taxonomy	\N	57080701	genus	\N	\N	\N	2009-01-01 00:00:00
6785	10759	6784	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6786	10761	6784	nodc	taxonomy	\N	5708070102	species	\N	\N	\N	2009-01-01 00:00:00
6787	10764	6783	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6788	10765	6750	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6789	10768	6788	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6790	10770	6789	jana	taxonomy	\N	57072401	genus	\N	\N	\N	2009-01-01 00:00:00
6791	10773	6790	nodc	taxonomy	\N	5707240101	species	\N	\N	\N	2009-01-01 00:00:00
6792	10774	6749	jana	taxonomy	Young, R.E., M. Vecchione, and D.T. Donovan. 1998. The evolution of coleoid cephalopods and their present biodiversity and ecology. African journal of marine science [0257-7615]. vol: 20 pg: 393.	\N	order	super	\N	\N	2009-01-01 00:00:00
6793	10775	6792	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6794	10776	6793	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6795	10777	6794	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6796	10778	6795	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6797	10779	6796	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6798	10782	6792	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6799	10787	6798	jana	taxonomy	http://www.tolweb.org	\N	order	sub	\N	\N	2009-01-01 00:00:00
6800	10788	6799	nodc	taxonomy	\N	570601	family	\N	\N	\N	2009-01-01 00:00:00
6801	10789	6800	nodc	taxonomy	Vecchione, M., E. Shea, S. Bussarawit, F. Anderson, D. Alexeyev, C.-C. Lu, T. Okutani, M. Roeleveld, C. Chotiyaputta, C. Roper, E. Jorgensen and N. Sukramongkol. 2005. Systematics of Indo-West Pacific loliginids. Phuket Marine Biological Center Research Bulletin 66:23-26.\n\nAnderson, F. E. 2000. Phylogenetic relationships among loliginid squids (Cephalopoda: Myopsida) based on analyses of multiple data sets. Zoological Journal of the Linnean Society 130:603-634.\n\n	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6802	10791	6801	nodc	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6803	10794	6798	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6804	10796	6803	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6805	10798	6804	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6806	10800	6798	jana	taxonomy	\N	5707	order	sub	\N	\N	2009-01-01 00:00:00
6807	10801	6806	nodc	taxonomy	\N	570704	family	\N	\N	\N	2009-01-01 00:00:00
6808	10803	6807	nodc	taxonomy	\N	57070401	genus	\N	\N	\N	2009-01-01 00:00:00
6809	10805	6808	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6810	10807	6806	nodc	taxonomy	\N	570705	family	\N	\N	\N	2009-01-01 00:00:00
6811	10808	6810	nodc	taxonomy	\N	57070502	genus	\N	\N	\N	2009-01-01 00:00:00
6812	10810	6811	nodc	taxonomy	\N	5707050203	species	\N	\N	\N	2009-01-01 00:00:00
6813	10813	6810	nodc	taxonomy	\N	57070501	genus	\N	\N	\N	2009-01-01 00:00:00
6814	10815	6813	nodc	taxonomy	\N	5707050101	species	\N	\N	\N	2009-01-01 00:00:00
6815	10818	6806	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6816	10819	6815	jana	taxonomy	\N	57071101	genus	\N	\N	\N	2009-01-01 00:00:00
6817	10820	6816	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6818	10821	6816	nodc	taxonomy	\N	5707110107	species	\N	\N	\N	2009-01-01 00:00:00
6819	10824	6806	nodc	taxonomy	\N	570703	family	\N	\N	\N	2009-01-01 00:00:00
6820	10825	6819	nodc	taxonomy	\N	57070303	genus	\N	\N	\N	2009-01-01 00:00:00
6821	10826	6820	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6822	10827	6819	nodc	taxonomy	\N	57070302	genus	\N	\N	\N	2009-01-01 00:00:00
6823	10828	6822	nodc	taxonomy	\N	5707030206	species	\N	\N	\N	2009-01-01 00:00:00
6824	10832	6822	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6825	10833	6822	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6826	10834	6819	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6827	10835	6826	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6828	10837	6806	nodc	taxonomy	\N	570701	family	\N	\N	\N	2009-01-01 00:00:00
6829	10838	6828	nodc	taxonomy	\N	57070101	genus	\N	\N	\N	2009-01-01 00:00:00
6830	10841	6829	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6831	10843	6806	nodc	taxonomy	\N	570723	family	\N	\N	\N	2009-01-01 00:00:00
6832	10846	6831	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6833	10848	6832	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6834	10851	6831	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6835	10853	6834	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6836	10855	6831	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6837	10857	6836	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6838	10859	6831	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6839	10861	6838	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6840	10863	6831	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6841	10865	6840	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6842	10867	6840	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6843	10869	6831	schlin	\N	www.tolweb.org/cranchia	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6844	10870	6843	schlin	\N	www.tolweb.org/cranchia	\N	species	\N	\N	\N	2009-01-01 00:00:00
6845	10871	6806	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6846	10872	6845	jana	taxonomy	\N	57071701	genus	\N	\N	\N	2009-01-01 00:00:00
6847	10875	6846	nodc	taxonomy	\N	5707170103	species	\N	\N	\N	2009-01-01 00:00:00
6848	10877	6845	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6849	10879	6848	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6850	10881	6848	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6851	10883	6845	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6852	10884	6806	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6853	10885	6852	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6854	10886	6853	svonthun	\N	http://www.tolweb.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
6855	10887	6853	svonthun	\N	http://www.tolweb.org	\N	species	\N	\N	\N	2009-01-01 00:00:00
6856	10889	6806	rodgers	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6857	10890	6856	rodgers	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6858	10892	6857	rodgers	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6859	10895	6806	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6860	10896	6859	unknown	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6861	10898	6860	unknown	taxonomy	Vecchione, M. and R.E. Young. 1998. The Magnapinnidae, a newly discovered family of oceanic squid (Cephalopoda: Oegopsida), pp. 429-437. In: A.I.L. Payne, L. Lipinski, M.R. Clarke and M.A.C. Roeleveld (Eds.). Cephalopod Biodiversity, Ecology and Evolution. South African Journal of Marine Science, volume 20, 469 pages.	\N	species	\N	\N	\N	2009-01-01 00:00:00
6862	10900	6806	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6863	10901	6862	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6864	10903	6806	svonthun	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6865	10904	6864	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6866	10905	6865	svonthun	\N	http://tolweb.org/Ancistrocheiridae/19632	\N	species	\N	\N	\N	2009-01-01 00:00:00
6867	10906	6806	svonthun	\N	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6868	10907	6867	svonthun	\N	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6869	10908	3916	jana	taxonomy	\N	80	phylum	infra	\N	\N	2009-01-01 00:00:00
6870	10910	6869	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6871	10911	6870	nodc	taxonomy	\N	78120101	genus	\N	\N	\N	2009-01-01 00:00:00
6872	10912	6869	nodc	taxonomy	\N	8005	order	\N	\N	\N	2009-01-01 00:00:00
6873	10913	6872	nodc	taxonomy	\N	800507	family	\N	\N	\N	2009-01-01 00:00:00
6874	10914	6873	nodc	taxonomy	\N	80050701	genus	\N	\N	\N	2009-01-01 00:00:00
6875	10915	6872	nodc	taxonomy	\N	800513	family	\N	\N	\N	2009-01-01 00:00:00
6876	10916	6875	nodc	taxonomy	\N	80051301	genus	\N	\N	\N	2009-01-01 00:00:00
6877	10917	6876	nodc	taxonomy	\N	8005130102	species	\N	\N	\N	2009-01-01 00:00:00
6878	10918	6876	nodc	taxonomy	\N	8005130101	species	\N	\N	\N	2009-01-01 00:00:00
6879	10919	3837	jana	taxonomy	\N	\N	kingdom	\N	\N	\N	2009-01-01 00:00:00
6880	10921	6879	jana	taxonomy	\N	34	kingdom	sub	\N	\N	2009-01-01 00:00:00
6881	10922	6880	lonny	taxonomy	\N	\N	phylum	\N	\N	\N	2009-01-01 00:00:00
6882	10923	6881	jana	taxonomy	\N	\N	class	super	\N	\N	2009-01-01 00:00:00
6883	10925	6882	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6884	10928	6882	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6885	10930	6884	jana	taxonomy	\N	3448	order	\N	\N	\N	2009-01-01 00:00:00
6886	10933	6885	jana	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6887	10935	6886	jana	taxonomy	\N	\N	family	super	\N	\N	2009-01-01 00:00:00
6888	10937	6887	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6889	10939	6888	jana	taxonomy	\N	\N	family	sub	\N	\N	2009-01-01 00:00:00
6890	10941	6889	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6891	10944	6890	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6892	10948	6885	lonny	taxonomy	\N	\N	order	sub	\N	\N	2009-01-01 00:00:00
6893	10950	6892	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6894	10952	6893	lonny	taxonomy	Joan M. Bernhard, Ph.D. Research Associate Professor University of South Carolina, The genus Bathysiphon (Protista, Foraminiferida) in the NE Atlantic: Revision of some species described by de Folin (1886). Gooday, AJ Journal of Natural History [J. NAT. HIST.], vol. 22, no. 1, pp. 71-93, 1988	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6895	10955	6882	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6896	10957	6895	unknown	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6897	10959	6896	unknown	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6898	10961	6881	lonny	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6899	10962	6898	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6900	10963	6898	jana	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6901	10965	6898	lonny	taxonomy	\N	\N	class	sub	\N	\N	2009-01-01 00:00:00
6902	10966	6901	lonny	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
6903	10967	6902	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6904	10969	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6905	10971	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6906	10973	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6907	10975	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6908	10977	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6909	10979	6903	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6910	10981	6902	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6911	10983	6910	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6912	10985	6911	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6913	10987	6910	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6914	10989	6913	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6915	10991	6910	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6916	10993	6915	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6917	10995	6910	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6918	10997	6917	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6919	10999	6917	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6920	11001	6902	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6921	11003	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6922	11005	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6923	11007	6922	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6924	11009	6922	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6925	11011	6922	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6926	11013	6922	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6927	11015	6920	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6928	11017	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6929	11019	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6930	11021	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6931	11023	6920	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6932	11025	6901	lonny	taxonomy	\N	\N	order	super	\N	\N	2009-01-01 00:00:00
6933	11027	6932	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6934	11028	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6935	11030	6934	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6936	11031	6935	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6937	11032	6935	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6938	11033	6935	svonthun	\N	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6939	11034	6934	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6940	11036	6934	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6941	11037	6940	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6942	11039	6940	unknown	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6943	11040	6934	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
6944	11043	6943	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6945	11044	6934	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6946	11046	6945	lonny	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6947	11048	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6948	11050	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6949	11052	6948	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6950	11054	6948	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6951	11056	6948	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6952	11058	6948	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6953	11060	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6954	11062	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6955	11064	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6956	11066	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6957	11068	6933	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6958	11070	6932	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6959	11071	6958	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6960	11073	6959	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6961	11075	6958	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6962	11077	6932	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6963	11078	6962	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6964	11080	6962	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6965	11082	6964	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6966	11084	6962	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6967	11086	6932	lonny	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6968	11087	6967	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6969	11089	6967	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6970	11091	6969	lonny	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6971	11093	6967	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6972	11095	6967	lonny	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6973	11097	3837	jana	taxonomy	http://www.ucmp.berkeley.edu/chromista/chromistasy.html	\N	kingdom	\N	\N	\N	2009-01-01 00:00:00
6974	11099	6973	jana	taxonomy	\N	04	phylum	\N	\N	\N	2009-01-01 00:00:00
6975	11101	6974	nodc	taxonomy	\N	0401	class	\N	\N	\N	2009-01-01 00:00:00
6976	11103	6973	jana	taxonomy	\N	\N	phylum	\N	\N	\N	2009-01-01 00:00:00
6977	11104	6976	jana	taxonomy	\N	\N	class	\N	\N	\N	2009-01-01 00:00:00
6978	11107	6973	jana	taxonomy	\N	15	phylum	\N	\N	\N	2009-01-01 00:00:00
6979	11110	6978	nodc	taxonomy	\N	1501	class	\N	\N	\N	2009-01-01 00:00:00
6980	11112	6979	jana	taxonomy	\N	1510	order	\N	\N	\N	2009-01-01 00:00:00
6981	11114	6980	nodc	taxonomy	\N	151001	family	\N	\N	\N	2009-01-01 00:00:00
6982	11117	6981	nodc	taxonomy	\N	15100105	genus	\N	\N	\N	2009-01-01 00:00:00
6983	11119	6981	nodc	taxonomy	\N	15100102	genus	\N	\N	\N	2009-01-01 00:00:00
6984	11121	6981	nodc	taxonomy	\N	15100104	genus	\N	\N	\N	2009-01-01 00:00:00
6985	11123	6980	nodc	taxonomy	\N	151003	family	\N	\N	\N	2009-01-01 00:00:00
6986	11125	6985	jana	taxonomy	\N	15100302	genus	\N	\N	\N	2009-01-01 00:00:00
6987	11127	6986	nodc	taxonomy	\N	1510030202	species	\N	\N	\N	2009-01-01 00:00:00
6988	11129	6979	jana	taxonomy	\N	\N	order	\N	\N	\N	2009-01-01 00:00:00
6989	11131	6988	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6990	11133	6989	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
6991	11135	6990	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6992	11137	6979	jana	taxonomy	\N	1509	order	\N	\N	\N	2009-01-01 00:00:00
6993	11139	6992	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
6994	11141	6993	jana	taxonomy	\N	15090201	genus	\N	\N	\N	2009-01-01 00:00:00
6995	11143	6994	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6996	11145	6994	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6997	11147	6994	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
6998	11149	6979	jana	taxonomy	\N	1508	order	\N	\N	\N	2009-01-01 00:00:00
6999	11152	6998	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
7000	11154	6999	jana	taxonomy	\N	15080402	genus	\N	\N	\N	2009-01-01 00:00:00
7001	11156	7000	nodc	taxonomy	\N	1508040201	species	\N	\N	\N	2009-01-01 00:00:00
7002	11158	6999	jana	taxonomy	\N	15080404	genus	\N	\N	\N	2009-01-01 00:00:00
7003	11160	7002	nodc	taxonomy	\N	1508040401	species	\N	\N	\N	2009-01-01 00:00:00
7004	11162	6999	jana	taxonomy	\N	15080403	genus	\N	\N	\N	2009-01-01 00:00:00
7005	11164	7004	nodc	taxonomy	\N	1508040301	species	\N	\N	\N	2009-01-01 00:00:00
7006	11167	6999	jana	taxonomy	\N	15080401	genus	\N	\N	\N	2009-01-01 00:00:00
7007	11169	7006	nodc	taxonomy	\N	1508040103	species	\N	\N	\N	2009-01-01 00:00:00
7008	11171	6998	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
7009	11173	7008	jana	taxonomy	\N	\N	genus	\N	\N	\N	2009-01-01 00:00:00
7010	11175	7009	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
7011	11177	7008	jana	taxonomy	\N	15080201	genus	\N	\N	\N	2009-01-01 00:00:00
7012	11179	7011	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
7013	11181	6998	jana	taxonomy	\N	\N	family	\N	\N	\N	2009-01-01 00:00:00
7014	11183	7013	jana	taxonomy	\N	15080303	genus	\N	\N	\N	2009-01-01 00:00:00
7015	11185	7014	jana	taxonomy	\N	\N	species	\N	\N	\N	2009-01-01 00:00:00
7016	11189	7013	jana	taxonomy	\N	15080212	genus	\N	\N	\N	2009-01-01 00:00:00
7017	11191	7016	nodc	taxonomy	\N	1508021201	species	\N	\N	\N	2009-01-01 00:00:00
7018	11193	7013	jana	taxonomy	\N	15080304	genus	\N	\N	\N	2009-01-01 00:00:00
7019	11195	7018	nodc	taxonomy	\N	1508030401	species	\N	\N	\N	2009-01-01 00:00:00
7020	11198	7013	jana	taxonomy	\N	15080305	genus	\N	\N	\N	2009-01-01 00:00:00
7021	11200	7020	nodc	taxonomy	\N	1508030501	species	\N	\N	\N	2009-01-01 00:00:00
7022	11202	7013	jana	taxonomy	\N	15080302	genus	\N	\N	\N	2009-01-01 00:00:00
7023	11204	7022	nodc	taxonomy	\N	1508030201	species	\N	\N	\N	2009-01-01 00:00:00
7024	11206	7022	nodc	taxonomy	\N	1508030202	species	\N	\N	\N	2009-01-01 00:00:00
7025	11209	3837	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7026	11210	3825	unknown	taxonomy	\N	\N	kingdom	super	\N	\N	2009-01-01 00:00:00
7027	11211	3824	conn	taxonomy	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7028	11212	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7029	11213	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7030	11214	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7031	11215	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7032	11216	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7033	11217	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7034	11218	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7035	11219	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7036	11220	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7037	11221	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7038	11222	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7039	11223	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7040	11224	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7041	11225	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7042	11226	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7043	11227	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7044	11228	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7045	11229	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7046	11230	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7047	11231	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7048	11232	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7049	11233	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7050	11234	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7051	11235	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7052	11236	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7053	11237	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7054	11238	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7055	11239	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7056	11240	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7057	11241	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7058	11242	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7059	11243	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7060	11244	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7061	11245	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7062	11246	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7063	11247	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7064	11248	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7065	11249	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7066	11250	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7067	11251	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7068	11252	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7069	11253	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7070	11254	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7071	11255	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7072	11256	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7073	11257	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7074	11258	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7075	11259	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7076	11260	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7077	11261	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7078	11262	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7079	11263	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7080	11264	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7081	11265	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7082	11266	7027	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7083	11267	7082	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7084	11269	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7085	11271	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7086	11273	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7087	11275	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7088	11276	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7089	11278	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7090	11280	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7091	11282	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7092	11284	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7093	11286	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7094	11288	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7095	11290	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7096	11292	7085	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7097	11293	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7098	11294	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7099	11296	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7100	11298	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7101	11301	7100	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7102	11303	7100	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7103	11305	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7104	11306	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7105	11308	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7106	11310	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7107	11312	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7108	11314	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7109	11317	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7110	11320	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7111	11321	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7112	11322	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7113	11323	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7114	11324	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7115	11325	7109	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7116	11326	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7117	11329	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7118	11331	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7119	11333	7118	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7120	11335	7118	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7121	11337	7118	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7122	11339	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7123	11341	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7124	11343	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7125	11345	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7126	11347	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7127	11349	7097	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7128	11351	7097	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7129	11353	7097	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7130	11355	7097	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7131	11357	7097	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7132	11359	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7133	11362	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7134	11363	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7135	11365	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7136	11366	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7137	11367	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7138	11368	7137	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7139	11371	7138	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7140	11373	7138	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7141	11375	7138	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7142	11377	7137	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7143	11379	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7144	11382	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7145	11385	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7146	11388	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7147	11390	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7148	11391	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7149	11392	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7150	11393	7149	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7151	11396	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7152	11397	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7153	11398	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7154	11399	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7155	11402	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7156	11403	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7157	11404	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7158	11407	7157	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7159	11410	7157	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7160	11413	7132	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7161	11415	7132	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7162	11417	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7163	11419	7162	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7164	11422	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7165	11425	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7166	11428	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7167	11430	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7168	11433	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7169	11435	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7170	11437	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7171	11439	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7172	11441	7165	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7173	11445	7165	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7174	11446	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7175	11448	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7176	11450	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7177	11452	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7178	11454	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7179	11457	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7180	11459	7179	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7181	11460	7179	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7182	11462	7179	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7183	11464	7179	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7184	11466	7179	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7185	11468	7179	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7186	11470	7179	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7187	11471	7179	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7188	11473	7179	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7189	11475	7163	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7190	11476	7189	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7191	11478	7163	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7192	11481	7162	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7193	11483	7162	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7194	11486	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7195	11488	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7196	11490	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7197	11492	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7198	11494	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7199	11496	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7200	11498	7193	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7201	11500	7083	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7202	11502	7201	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7203	11503	7082	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7204	11504	7203	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7205	11506	7203	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7206	11508	7203	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7207	11510	7203	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7208	11512	7203	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7209	11514	7203	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7210	11517	7203	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7211	11518	7082	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7212	11520	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7213	11521	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7214	11522	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7215	11524	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7216	11525	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7217	11526	7211	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7218	11527	7217	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7219	11529	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7220	11530	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7221	11531	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7222	11532	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7223	11533	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7224	11534	7027	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7225	11535	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7226	11536	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7227	11537	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7228	11538	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7229	11539	7228	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7230	11541	7228	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7231	11543	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7232	11544	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7233	11545	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7234	11546	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7235	11547	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7236	11548	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7237	11549	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7238	11550	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7239	11551	7238	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7240	11554	7238	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7241	11557	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7242	11558	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7243	11559	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7244	11560	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7245	11561	7244	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7246	11562	7244	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7247	11563	7244	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7248	11564	7244	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7249	11565	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7250	11566	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7251	11567	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7252	11568	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7253	11569	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7254	11570	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7255	11571	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7256	11572	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7257	11573	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7258	11574	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7259	11575	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7260	11576	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7261	11577	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7262	11578	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7263	11579	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7264	11580	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7265	11581	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7266	11582	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7267	11583	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7268	11584	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7269	11585	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7270	11586	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7271	11587	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7272	11589	7271	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7273	11591	7271	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7274	11593	7271	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7275	11594	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7276	11595	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7277	11596	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7278	11597	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7279	11598	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7280	11599	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7281	11600	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7282	11601	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7283	11602	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7284	11603	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7285	11604	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7286	11605	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7287	11606	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7288	11608	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7289	11609	7264	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7290	11610	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7291	11611	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7292	11612	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7293	11613	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7294	11614	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7295	11615	7264	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7296	11616	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7297	11617	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7298	11618	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7299	11619	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7300	11620	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7301	11621	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7302	11622	7301	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7303	11623	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7304	11624	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7305	11625	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7306	11626	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7307	11628	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7308	11629	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7309	11630	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7310	11631	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7311	11632	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7312	11633	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7313	11635	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7314	11636	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7315	11637	7314	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7316	11638	7314	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7317	11639	7314	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7318	11640	7314	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7319	11641	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7320	11642	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7321	11643	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7322	11644	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7323	11645	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7324	11646	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7325	11647	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7326	11648	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7327	11649	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7328	11650	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7329	11651	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7330	11652	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7331	11653	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7332	11654	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7333	11655	7332	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7334	11656	7332	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7335	11657	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7336	11658	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7337	11659	7336	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7338	11660	7336	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7339	11661	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7340	11662	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7341	11663	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7342	11664	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7343	11665	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7344	11666	7343	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7345	11667	7343	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7346	11668	7343	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7347	11669	7343	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7348	11670	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7349	11671	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7350	11672	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7351	11673	7224	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7352	11674	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7353	11675	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7354	11676	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7355	11677	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7356	11678	7027	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7357	11679	3824	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7358	11680	7357	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7359	11681	7358	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7360	11684	7358	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7361	11686	7357	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7362	11687	7361	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7363	11688	7361	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7364	11689	7361	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7365	11690	7361	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7366	11691	7361	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7367	11692	7357	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7368	11693	3824	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7369	11694	3824	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7370	11695	3824	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7371	11696	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7372	11697	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7373	11698	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7374	11699	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7375	11700	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7376	11701	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7377	11702	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7378	11703	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7379	11704	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7380	11705	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7381	11706	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7382	11707	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7383	11708	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7384	11709	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7385	11710	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7386	11711	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7387	11712	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7388	11713	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7389	11714	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7390	11715	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7391	11717	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7392	11718	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7393	11719	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7394	11720	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7395	11721	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7396	11722	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7397	11723	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7398	11725	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7399	11726	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7400	11727	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7401	11728	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7402	11729	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7403	11730	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7404	11731	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7405	11732	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7406	11733	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7407	11734	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7408	11735	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7409	11736	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7410	11737	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7411	11738	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7412	11739	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7413	11740	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7414	11741	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7415	11742	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7416	11743	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7417	11744	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7418	11745	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7419	11746	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7420	11747	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7421	11748	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7422	11750	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7423	11751	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7424	11752	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7425	11753	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7426	11754	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7427	11755	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7428	11756	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7429	11757	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7430	11758	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7431	11759	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7432	11760	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7433	11761	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7434	11762	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7435	11763	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7436	11764	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7437	11765	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7438	11766	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7439	11767	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7440	11768	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7441	11769	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7442	11770	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7443	11771	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7444	11772	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7445	11773	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7446	11775	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7447	11776	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7448	11777	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7449	11779	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7450	11780	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7451	11781	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7452	11782	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7453	11783	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7454	11784	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7455	11785	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7456	11787	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7457	11788	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7458	11789	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7459	11790	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7460	11791	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7461	11793	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7462	11795	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7463	11796	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7464	11797	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7465	11798	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7466	11799	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7467	11800	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7468	11801	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7469	11802	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7470	11803	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7471	11804	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7472	11805	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7473	11806	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7474	11807	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7475	11808	7370	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7476	11809	7370	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7477	11810	3824	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7478	11811	7477	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7479	11812	7478	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7480	11813	7478	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7481	11814	7478	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7482	11815	7478	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7483	11816	7478	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7484	11817	7483	rodgers	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7485	11818	7483	rodgers	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7486	11819	7478	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7487	11820	7477	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7488	11823	7477	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7489	11824	7477	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7490	11825	7477	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7491	11826	3824	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7492	11827	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7493	11828	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7494	11830	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7495	11832	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7496	11833	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7497	11834	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7498	11835	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7499	11836	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7500	11838	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7501	11839	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7502	11840	7501	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7503	11841	7501	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7504	11842	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7505	11843	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7506	11844	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7507	11845	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7508	11846	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7509	11847	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7510	11848	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7511	11849	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7512	11850	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7513	11851	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7514	11852	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7515	11853	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7516	11854	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7517	11855	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7518	11856	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7519	11857	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7520	11858	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7521	11859	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7522	11860	7521	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7523	11861	7521	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7524	11862	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7525	11863	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7526	11864	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7527	11865	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7528	11866	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7529	11867	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7530	11868	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7531	11869	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7532	11870	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7533	11871	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7534	11872	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7535	11873	7534	mbari	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7536	11874	7534	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7537	11875	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7538	11876	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7539	11877	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7540	11879	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7541	11880	7540	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7542	11881	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7543	11882	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7544	11883	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7545	11884	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7546	11885	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7547	11886	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7548	11887	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7549	11888	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7550	11889	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7551	11890	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7552	11891	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7553	11892	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7554	11893	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7555	11894	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7556	11895	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7557	11896	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7558	11897	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7559	11898	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7560	11899	7559	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7561	11900	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7562	11901	7561	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7563	11902	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7564	11903	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7565	11904	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7566	11905	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7567	11906	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7568	11907	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7569	11908	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7570	11910	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7571	11911	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7572	11912	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7573	11913	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7574	11914	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7575	11915	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7576	11916	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7577	11917	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7578	11919	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7579	11920	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7580	11921	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7581	11922	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7582	11923	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7583	11924	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7584	11925	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7585	11926	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7586	11927	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7587	11928	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7588	11930	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7589	11931	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7590	11932	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7591	11933	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7592	11934	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7593	11935	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7594	11936	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7595	11937	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7596	11938	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7597	11939	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7598	11940	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7599	11941	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7600	11942	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7601	11943	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7602	11944	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7603	11945	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7604	11946	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7605	11947	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7606	11948	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7607	11950	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7608	11951	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7609	11952	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7610	11953	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7611	11954	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7612	11955	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7613	11956	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7614	11957	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7615	11958	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7616	11959	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7617	11960	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7618	11961	7491	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7619	11962	7618	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7620	11963	7619	mbari	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7621	11964	7619	mbari	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7622	11965	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7623	11966	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7624	11967	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7625	11968	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7626	11969	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7627	11970	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7628	11971	7626	rodgers	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7629	11972	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7630	11973	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7631	11974	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7632	11975	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7633	11976	7626	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7634	11977	7633	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7635	11978	7633	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7636	11979	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7637	11980	7636	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7638	11982	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7639	11983	7638	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7640	11985	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7641	11986	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7642	11987	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7643	11988	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7644	11989	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7645	11990	7644	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7646	11992	7644	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7647	11994	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7648	11995	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7649	11996	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7650	11997	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7651	11998	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7652	11999	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7653	12000	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7654	12001	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7655	12003	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7656	12004	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7657	12005	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7658	12006	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7659	12007	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7660	12008	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7661	12009	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7662	12010	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7663	12011	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7664	12012	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7665	12013	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7666	12014	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7667	12015	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7668	12016	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7669	12017	7491	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7670	12018	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7671	12019	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7672	12020	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7673	12021	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7674	12022	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7675	12023	7491	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7676	12024	7675	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7677	12025	7675	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7678	12027	7675	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7679	12028	7675	vicki	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7680	12029	7675	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7681	12031	7675	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7682	12032	7675	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7683	12033	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7684	12034	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7685	12035	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7686	12036	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7687	12037	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7688	12038	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7689	12039	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7690	12040	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7691	12041	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7692	12042	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7693	12043	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7694	12044	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7695	12045	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7696	12046	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7697	12047	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7698	12048	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7699	12049	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7700	12050	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7701	12051	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7702	12052	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7703	12053	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7704	12054	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7705	12055	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7706	12056	7491	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7707	12057	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7708	12058	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7709	12060	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7710	12061	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7711	12062	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7712	12063	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7713	12064	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7714	12065	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7715	12066	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7716	12067	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7717	12068	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7718	12069	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7719	12070	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7720	12071	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7721	12072	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7722	12073	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7723	12074	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7724	12075	7491	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7725	12076	7491	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7726	12078	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7727	12079	7491	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7728	12081	7491	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7729	12082	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7730	12083	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7731	12085	7491	schlin	\N	used by Bush in 2007	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7732	12086	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7733	12087	7491	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7734	12088	7491	linda	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7735	12089	7491	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7736	12090	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7737	12092	7491	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7738	12093	3824	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7739	12094	7738	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7740	12095	7738	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7741	12096	7738	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7742	12097	7738	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7743	12098	7738	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7744	12099	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7745	12101	7743	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7746	12103	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7747	12105	7743	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7748	12107	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7749	12109	7743	rodgers	lithology	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7750	12111	7743	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7751	12113	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7752	12114	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7753	12116	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7754	12118	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7755	12120	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7756	12122	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7757	12124	7743	rodgers	taxonomy	\N	45345	phylum	super	\N	\N	2009-01-01 00:00:00
7758	12126	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7759	12128	7743	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7760	12130	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7761	12132	7743	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7762	12134	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7763	12136	7743	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7764	12138	7743	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7765	12140	7743	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7766	12141	7743	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7767	12142	7743	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7768	12143	7743	schlin	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7769	12144	7743	svonthun	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7770	12145	7738	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7771	12146	7738	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7772	12147	7738	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7773	12148	7738	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7774	12149	7773	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7775	12150	7773	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7776	12151	7773	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7777	12153	7773	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7778	12154	7773	conn	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7779	12155	7773	unknown	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7780	12156	7738	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7781	12158	7780	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7782	12160	7780	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7783	12161	7780	lonny	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7784	12163	3734	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7785	12164	7784	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7786	12166	7784	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7787	12168	7784	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
7788	12170	3734	jana	\N	\N	\N	\N	\N	\N	\N	2009-01-01 00:00:00
\.


--
-- Data for Name: conceptdelegate; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY conceptdelegate (id, conceptid_fk, usageid_fk, last_updated_time) FROM stdin;
4774	4774	\N	2009-01-01 00:00:00
4775	4775	\N	2009-01-01 00:00:00
4776	4776	\N	2009-01-01 00:00:00
4777	4777	\N	2009-01-01 00:00:00
4778	4778	\N	2009-01-01 00:00:00
4779	4779	\N	2009-01-01 00:00:00
4780	4780	\N	2009-01-01 00:00:00
4781	4781	\N	2009-01-01 00:00:00
4782	4782	\N	2009-01-01 00:00:00
4783	4783	\N	2009-01-01 00:00:00
4784	4784	\N	2009-01-01 00:00:00
4785	4785	\N	2009-01-01 00:00:00
4786	4786	\N	2009-01-01 00:00:00
4787	4787	\N	2009-01-01 00:00:00
4788	4788	\N	2009-01-01 00:00:00
4789	4789	\N	2009-01-01 00:00:00
4790	4790	\N	2009-01-01 00:00:00
4791	4791	\N	2009-01-01 00:00:00
4792	4792	\N	2009-01-01 00:00:00
4793	4793	\N	2009-01-01 00:00:00
4794	4794	\N	2009-01-01 00:00:00
4795	4795	\N	2009-01-01 00:00:00
4796	4796	\N	2009-01-01 00:00:00
4797	4797	\N	2009-01-01 00:00:00
4798	4798	\N	2009-01-01 00:00:00
4799	4799	\N	2009-01-01 00:00:00
4800	4800	\N	2009-01-01 00:00:00
4801	4801	\N	2009-01-01 00:00:00
4802	4802	\N	2009-01-01 00:00:00
4803	4803	\N	2009-01-01 00:00:00
4804	4804	\N	2009-01-01 00:00:00
4805	4805	\N	2009-01-01 00:00:00
4806	4806	\N	2009-01-01 00:00:00
4807	4807	\N	2009-01-01 00:00:00
4808	4808	\N	2009-01-01 00:00:00
4809	4809	\N	2009-01-01 00:00:00
4810	4810	\N	2009-01-01 00:00:00
4811	4811	\N	2009-01-01 00:00:00
4812	4812	\N	2009-01-01 00:00:00
4813	4813	\N	2009-01-01 00:00:00
4814	4814	\N	2009-01-01 00:00:00
4815	4815	\N	2009-01-01 00:00:00
4816	4816	\N	2009-01-01 00:00:00
4817	4817	\N	2009-01-01 00:00:00
4818	4818	\N	2009-01-01 00:00:00
4819	4819	\N	2009-01-01 00:00:00
4820	4820	\N	2009-01-01 00:00:00
4821	4821	\N	2009-01-01 00:00:00
4822	4822	\N	2009-01-01 00:00:00
4823	4823	\N	2009-01-01 00:00:00
4824	4824	\N	2009-01-01 00:00:00
4825	4825	\N	2009-01-01 00:00:00
4826	4826	\N	2009-01-01 00:00:00
4827	4827	\N	2009-01-01 00:00:00
4828	4828	\N	2009-01-01 00:00:00
4829	4829	\N	2009-01-01 00:00:00
4830	4830	\N	2009-01-01 00:00:00
4831	4831	\N	2009-01-01 00:00:00
4832	4832	\N	2009-01-01 00:00:00
4833	4833	\N	2009-01-01 00:00:00
4834	4834	\N	2009-01-01 00:00:00
4835	4835	\N	2009-01-01 00:00:00
4836	4836	\N	2009-01-01 00:00:00
4837	4837	\N	2009-01-01 00:00:00
4838	4838	\N	2009-01-01 00:00:00
4839	4839	\N	2009-01-01 00:00:00
4840	4840	\N	2009-01-01 00:00:00
4841	4841	\N	2009-01-01 00:00:00
4842	4842	\N	2009-01-01 00:00:00
4843	4843	\N	2009-01-01 00:00:00
4844	4844	\N	2009-01-01 00:00:00
4845	4845	\N	2009-01-01 00:00:00
4846	4846	\N	2009-01-01 00:00:00
4847	4847	\N	2009-01-01 00:00:00
4848	4848	\N	2009-01-01 00:00:00
4849	4849	\N	2009-01-01 00:00:00
4850	4850	\N	2009-01-01 00:00:00
4851	4851	\N	2009-01-01 00:00:00
4852	4852	\N	2009-01-01 00:00:00
4853	4853	\N	2009-01-01 00:00:00
4854	4854	\N	2009-01-01 00:00:00
4855	4855	\N	2009-01-01 00:00:00
4856	4856	\N	2009-01-01 00:00:00
4857	4857	\N	2009-01-01 00:00:00
4858	4858	\N	2009-01-01 00:00:00
4859	4859	\N	2009-01-01 00:00:00
4860	4860	\N	2009-01-01 00:00:00
4861	4861	\N	2009-01-01 00:00:00
4862	4862	\N	2009-01-01 00:00:00
4863	4863	\N	2009-01-01 00:00:00
4864	4864	\N	2009-01-01 00:00:00
4865	4865	\N	2009-01-01 00:00:00
4866	4866	\N	2009-01-01 00:00:00
4867	4867	\N	2009-01-01 00:00:00
4868	4868	\N	2009-01-01 00:00:00
4869	4869	\N	2009-01-01 00:00:00
4870	4870	\N	2009-01-01 00:00:00
4871	4871	\N	2009-01-01 00:00:00
4872	4872	\N	2009-01-01 00:00:00
4873	4873	\N	2009-01-01 00:00:00
4874	4874	\N	2009-01-01 00:00:00
4875	4875	\N	2009-01-01 00:00:00
4876	4876	\N	2009-01-01 00:00:00
3734	3734	\N	2009-01-01 00:00:00
3735	3735	\N	2009-01-01 00:00:00
3736	3736	\N	2009-01-01 00:00:00
3737	3737	\N	2009-01-01 00:00:00
3738	3738	\N	2009-01-01 00:00:00
3739	3739	\N	2009-01-01 00:00:00
3740	3740	\N	2009-01-01 00:00:00
3741	3741	\N	2009-01-01 00:00:00
3742	3742	\N	2009-01-01 00:00:00
3743	3743	\N	2009-01-01 00:00:00
3744	3744	\N	2009-01-01 00:00:00
3745	3745	\N	2009-01-01 00:00:00
3746	3746	\N	2009-01-01 00:00:00
3747	3747	\N	2009-01-01 00:00:00
3748	3748	\N	2009-01-01 00:00:00
3749	3749	\N	2009-01-01 00:00:00
3750	3750	\N	2009-01-01 00:00:00
3751	3751	\N	2009-01-01 00:00:00
3752	3752	\N	2009-01-01 00:00:00
3753	3753	\N	2009-01-01 00:00:00
3754	3754	\N	2009-01-01 00:00:00
3755	3755	\N	2009-01-01 00:00:00
3756	3756	\N	2009-01-01 00:00:00
3757	3757	\N	2009-01-01 00:00:00
3758	3758	\N	2009-01-01 00:00:00
3759	3759	\N	2009-01-01 00:00:00
3760	3760	\N	2009-01-01 00:00:00
3761	3761	\N	2009-01-01 00:00:00
3762	3762	\N	2009-01-01 00:00:00
3763	3763	\N	2009-01-01 00:00:00
3764	3764	\N	2009-01-01 00:00:00
3765	3765	\N	2009-01-01 00:00:00
3766	3766	\N	2009-01-01 00:00:00
3767	3767	\N	2009-01-01 00:00:00
3768	3768	\N	2009-01-01 00:00:00
3769	3769	\N	2009-01-01 00:00:00
3770	3770	\N	2009-01-01 00:00:00
3771	3771	\N	2009-01-01 00:00:00
3772	3772	\N	2009-01-01 00:00:00
3773	3773	\N	2009-01-01 00:00:00
3774	3774	\N	2009-01-01 00:00:00
3775	3775	\N	2009-01-01 00:00:00
3776	3776	\N	2009-01-01 00:00:00
3777	3777	\N	2009-01-01 00:00:00
3778	3778	\N	2009-01-01 00:00:00
3779	3779	\N	2009-01-01 00:00:00
3780	3780	\N	2009-01-01 00:00:00
3781	3781	\N	2009-01-01 00:00:00
3782	3782	\N	2009-01-01 00:00:00
3783	3783	\N	2009-01-01 00:00:00
3784	3784	\N	2009-01-01 00:00:00
3785	3785	\N	2009-01-01 00:00:00
3786	3786	\N	2009-01-01 00:00:00
3787	3787	\N	2009-01-01 00:00:00
3788	3788	\N	2009-01-01 00:00:00
3789	3789	\N	2009-01-01 00:00:00
3790	3790	\N	2009-01-01 00:00:00
3791	3791	\N	2009-01-01 00:00:00
3792	3792	\N	2009-01-01 00:00:00
3793	3793	\N	2009-01-01 00:00:00
3794	3794	\N	2009-01-01 00:00:00
3795	3795	\N	2009-01-01 00:00:00
3796	3796	\N	2009-01-01 00:00:00
3797	3797	\N	2009-01-01 00:00:00
3798	3798	\N	2009-01-01 00:00:00
3799	3799	\N	2009-01-01 00:00:00
3800	3800	\N	2009-01-01 00:00:00
3801	3801	\N	2009-01-01 00:00:00
3802	3802	\N	2009-01-01 00:00:00
3803	3803	\N	2009-01-01 00:00:00
3804	3804	\N	2009-01-01 00:00:00
3805	3805	\N	2009-01-01 00:00:00
3806	3806	\N	2009-01-01 00:00:00
3807	3807	\N	2009-01-01 00:00:00
3808	3808	\N	2009-01-01 00:00:00
3809	3809	\N	2009-01-01 00:00:00
3810	3810	\N	2009-01-01 00:00:00
3811	3811	\N	2009-01-01 00:00:00
3812	3812	\N	2009-01-01 00:00:00
3813	3813	\N	2009-01-01 00:00:00
3814	3814	\N	2009-01-01 00:00:00
3815	3815	\N	2009-01-01 00:00:00
3816	3816	\N	2009-01-01 00:00:00
3817	3817	\N	2009-01-01 00:00:00
3818	3818	\N	2009-01-01 00:00:00
3819	3819	\N	2009-01-01 00:00:00
3820	3820	\N	2009-01-01 00:00:00
3821	3821	\N	2009-01-01 00:00:00
3822	3822	\N	2009-01-01 00:00:00
3823	3823	\N	2009-01-01 00:00:00
3824	3824	\N	2009-01-01 00:00:00
3825	3825	\N	2009-01-01 00:00:00
3826	3826	\N	2009-01-01 00:00:00
3827	3827	\N	2009-01-01 00:00:00
3828	3828	\N	2009-01-01 00:00:00
3829	3829	\N	2009-01-01 00:00:00
3830	3830	\N	2009-01-01 00:00:00
3831	3831	\N	2009-01-01 00:00:00
3832	3832	\N	2009-01-01 00:00:00
3833	3833	\N	2009-01-01 00:00:00
3834	3834	\N	2009-01-01 00:00:00
3835	3835	\N	2009-01-01 00:00:00
3836	3836	\N	2009-01-01 00:00:00
3837	3837	\N	2009-01-01 00:00:00
3838	3838	\N	2009-01-01 00:00:00
3839	3839	\N	2009-01-01 00:00:00
3840	3840	\N	2009-01-01 00:00:00
3841	3841	\N	2009-01-01 00:00:00
3842	3842	\N	2009-01-01 00:00:00
3843	3843	\N	2009-01-01 00:00:00
3844	3844	\N	2009-01-01 00:00:00
3845	3845	\N	2009-01-01 00:00:00
3846	3846	\N	2009-01-01 00:00:00
3847	3847	\N	2009-01-01 00:00:00
3848	3848	\N	2009-01-01 00:00:00
3849	3849	\N	2009-01-01 00:00:00
3850	3850	\N	2009-01-01 00:00:00
3851	3851	\N	2009-01-01 00:00:00
3852	3852	\N	2009-01-01 00:00:00
3853	3853	\N	2009-01-01 00:00:00
3854	3854	\N	2009-01-01 00:00:00
3855	3855	\N	2009-01-01 00:00:00
3856	3856	\N	2009-01-01 00:00:00
3857	3857	\N	2009-01-01 00:00:00
3858	3858	\N	2009-01-01 00:00:00
3859	3859	\N	2009-01-01 00:00:00
3860	3860	\N	2009-01-01 00:00:00
3861	3861	\N	2009-01-01 00:00:00
3862	3862	\N	2009-01-01 00:00:00
3863	3863	\N	2009-01-01 00:00:00
3864	3864	\N	2009-01-01 00:00:00
3865	3865	\N	2009-01-01 00:00:00
3866	3866	\N	2009-01-01 00:00:00
3867	3867	\N	2009-01-01 00:00:00
3868	3868	\N	2009-01-01 00:00:00
3869	3869	\N	2009-01-01 00:00:00
3870	3870	\N	2009-01-01 00:00:00
3871	3871	\N	2009-01-01 00:00:00
3872	3872	\N	2009-01-01 00:00:00
3873	3873	\N	2009-01-01 00:00:00
3874	3874	\N	2009-01-01 00:00:00
3875	3875	\N	2009-01-01 00:00:00
3876	3876	\N	2009-01-01 00:00:00
3877	3877	\N	2009-01-01 00:00:00
3878	3878	\N	2009-01-01 00:00:00
3879	3879	\N	2009-01-01 00:00:00
3880	3880	\N	2009-01-01 00:00:00
3881	3881	\N	2009-01-01 00:00:00
3882	3882	\N	2009-01-01 00:00:00
3883	3883	\N	2009-01-01 00:00:00
3884	3884	\N	2009-01-01 00:00:00
3885	3885	\N	2009-01-01 00:00:00
3886	3886	\N	2009-01-01 00:00:00
3887	3887	\N	2009-01-01 00:00:00
3888	3888	\N	2009-01-01 00:00:00
3889	3889	\N	2009-01-01 00:00:00
3890	3890	\N	2009-01-01 00:00:00
3891	3891	\N	2009-01-01 00:00:00
3892	3892	\N	2009-01-01 00:00:00
3893	3893	\N	2009-01-01 00:00:00
3894	3894	\N	2009-01-01 00:00:00
3895	3895	\N	2009-01-01 00:00:00
3896	3896	\N	2009-01-01 00:00:00
3897	3897	\N	2009-01-01 00:00:00
3898	3898	\N	2009-01-01 00:00:00
3899	3899	\N	2009-01-01 00:00:00
3900	3900	\N	2009-01-01 00:00:00
3901	3901	\N	2009-01-01 00:00:00
3902	3902	\N	2009-01-01 00:00:00
3903	3903	\N	2009-01-01 00:00:00
3904	3904	\N	2009-01-01 00:00:00
3905	3905	\N	2009-01-01 00:00:00
3906	3906	\N	2009-01-01 00:00:00
3907	3907	\N	2009-01-01 00:00:00
3908	3908	\N	2009-01-01 00:00:00
3909	3909	\N	2009-01-01 00:00:00
3910	3910	\N	2009-01-01 00:00:00
3911	3911	\N	2009-01-01 00:00:00
3912	3912	\N	2009-01-01 00:00:00
3913	3913	\N	2009-01-01 00:00:00
3914	3914	\N	2009-01-01 00:00:00
3915	3915	\N	2009-01-01 00:00:00
3916	3916	\N	2009-01-01 00:00:00
3917	3917	\N	2009-01-01 00:00:00
3918	3918	\N	2009-01-01 00:00:00
3919	3919	\N	2009-01-01 00:00:00
3920	3920	\N	2009-01-01 00:00:00
3921	3921	\N	2009-01-01 00:00:00
3922	3922	\N	2009-01-01 00:00:00
3923	3923	\N	2009-01-01 00:00:00
3924	3924	\N	2009-01-01 00:00:00
3925	3925	\N	2009-01-01 00:00:00
3926	3926	\N	2009-01-01 00:00:00
3927	3927	\N	2009-01-01 00:00:00
3928	3928	\N	2009-01-01 00:00:00
3929	3929	\N	2009-01-01 00:00:00
3930	3930	\N	2009-01-01 00:00:00
3931	3931	\N	2009-01-01 00:00:00
3932	3932	\N	2009-01-01 00:00:00
3933	3933	\N	2009-01-01 00:00:00
3934	3934	\N	2009-01-01 00:00:00
3935	3935	\N	2009-01-01 00:00:00
3936	3936	\N	2009-01-01 00:00:00
3937	3937	\N	2009-01-01 00:00:00
3938	3938	\N	2009-01-01 00:00:00
3939	3939	\N	2009-01-01 00:00:00
3940	3940	\N	2009-01-01 00:00:00
3941	3941	\N	2009-01-01 00:00:00
3942	3942	\N	2009-01-01 00:00:00
3943	3943	\N	2009-01-01 00:00:00
3944	3944	\N	2009-01-01 00:00:00
3945	3945	\N	2009-01-01 00:00:00
3946	3946	\N	2009-01-01 00:00:00
3947	3947	\N	2009-01-01 00:00:00
3948	3948	\N	2009-01-01 00:00:00
3949	3949	\N	2009-01-01 00:00:00
3950	3950	\N	2009-01-01 00:00:00
3951	3951	\N	2009-01-01 00:00:00
3952	3952	\N	2009-01-01 00:00:00
3953	3953	\N	2009-01-01 00:00:00
3954	3954	\N	2009-01-01 00:00:00
3955	3955	\N	2009-01-01 00:00:00
3956	3956	\N	2009-01-01 00:00:00
3957	3957	\N	2009-01-01 00:00:00
3958	3958	\N	2009-01-01 00:00:00
3959	3959	\N	2009-01-01 00:00:00
3960	3960	\N	2009-01-01 00:00:00
3961	3961	\N	2009-01-01 00:00:00
3962	3962	\N	2009-01-01 00:00:00
3963	3963	\N	2009-01-01 00:00:00
3964	3964	\N	2009-01-01 00:00:00
3965	3965	\N	2009-01-01 00:00:00
3966	3966	\N	2009-01-01 00:00:00
3967	3967	\N	2009-01-01 00:00:00
3968	3968	\N	2009-01-01 00:00:00
3969	3969	\N	2009-01-01 00:00:00
3970	3970	\N	2009-01-01 00:00:00
3971	3971	\N	2009-01-01 00:00:00
3972	3972	\N	2009-01-01 00:00:00
3973	3973	\N	2009-01-01 00:00:00
3974	3974	\N	2009-01-01 00:00:00
3975	3975	\N	2009-01-01 00:00:00
3976	3976	\N	2009-01-01 00:00:00
3977	3977	\N	2009-01-01 00:00:00
3978	3978	\N	2009-01-01 00:00:00
3979	3979	\N	2009-01-01 00:00:00
3980	3980	\N	2009-01-01 00:00:00
3981	3981	\N	2009-01-01 00:00:00
3982	3982	\N	2009-01-01 00:00:00
3983	3983	\N	2009-01-01 00:00:00
3984	3984	\N	2009-01-01 00:00:00
3985	3985	\N	2009-01-01 00:00:00
3986	3986	\N	2009-01-01 00:00:00
3987	3987	\N	2009-01-01 00:00:00
3988	3988	\N	2009-01-01 00:00:00
3989	3989	\N	2009-01-01 00:00:00
3990	3990	\N	2009-01-01 00:00:00
3991	3991	\N	2009-01-01 00:00:00
3992	3992	\N	2009-01-01 00:00:00
3993	3993	\N	2009-01-01 00:00:00
3994	3994	\N	2009-01-01 00:00:00
3995	3995	\N	2009-01-01 00:00:00
3996	3996	\N	2009-01-01 00:00:00
3997	3997	\N	2009-01-01 00:00:00
3998	3998	\N	2009-01-01 00:00:00
3999	3999	\N	2009-01-01 00:00:00
4000	4000	\N	2009-01-01 00:00:00
4001	4001	\N	2009-01-01 00:00:00
4002	4002	\N	2009-01-01 00:00:00
4003	4003	\N	2009-01-01 00:00:00
4004	4004	\N	2009-01-01 00:00:00
4005	4005	\N	2009-01-01 00:00:00
4006	4006	\N	2009-01-01 00:00:00
4007	4007	\N	2009-01-01 00:00:00
4008	4008	\N	2009-01-01 00:00:00
4009	4009	\N	2009-01-01 00:00:00
4010	4010	\N	2009-01-01 00:00:00
4011	4011	\N	2009-01-01 00:00:00
4012	4012	\N	2009-01-01 00:00:00
4013	4013	\N	2009-01-01 00:00:00
4014	4014	\N	2009-01-01 00:00:00
4015	4015	\N	2009-01-01 00:00:00
4016	4016	\N	2009-01-01 00:00:00
4017	4017	\N	2009-01-01 00:00:00
4018	4018	\N	2009-01-01 00:00:00
4019	4019	\N	2009-01-01 00:00:00
4020	4020	\N	2009-01-01 00:00:00
4021	4021	\N	2009-01-01 00:00:00
4022	4022	\N	2009-01-01 00:00:00
4023	4023	\N	2009-01-01 00:00:00
4024	4024	\N	2009-01-01 00:00:00
4025	4025	\N	2009-01-01 00:00:00
4026	4026	\N	2009-01-01 00:00:00
4027	4027	\N	2009-01-01 00:00:00
4028	4028	\N	2009-01-01 00:00:00
4029	4029	\N	2009-01-01 00:00:00
4030	4030	\N	2009-01-01 00:00:00
4031	4031	\N	2009-01-01 00:00:00
4032	4032	\N	2009-01-01 00:00:00
4033	4033	\N	2009-01-01 00:00:00
4034	4034	\N	2009-01-01 00:00:00
4035	4035	\N	2009-01-01 00:00:00
4036	4036	\N	2009-01-01 00:00:00
4037	4037	\N	2009-01-01 00:00:00
4038	4038	\N	2009-01-01 00:00:00
4039	4039	\N	2009-01-01 00:00:00
4040	4040	\N	2009-01-01 00:00:00
4041	4041	\N	2009-01-01 00:00:00
4042	4042	\N	2009-01-01 00:00:00
4043	4043	\N	2009-01-01 00:00:00
4044	4044	\N	2009-01-01 00:00:00
4045	4045	\N	2009-01-01 00:00:00
4046	4046	\N	2009-01-01 00:00:00
4047	4047	\N	2009-01-01 00:00:00
4048	4048	\N	2009-01-01 00:00:00
4049	4049	\N	2009-01-01 00:00:00
4050	4050	\N	2009-01-01 00:00:00
4051	4051	\N	2009-01-01 00:00:00
4052	4052	\N	2009-01-01 00:00:00
4053	4053	\N	2009-01-01 00:00:00
4054	4054	\N	2009-01-01 00:00:00
4055	4055	\N	2009-01-01 00:00:00
4056	4056	\N	2009-01-01 00:00:00
4057	4057	\N	2009-01-01 00:00:00
4058	4058	\N	2009-01-01 00:00:00
4059	4059	\N	2009-01-01 00:00:00
4060	4060	\N	2009-01-01 00:00:00
4061	4061	\N	2009-01-01 00:00:00
4062	4062	\N	2009-01-01 00:00:00
4063	4063	\N	2009-01-01 00:00:00
4064	4064	\N	2009-01-01 00:00:00
4065	4065	\N	2009-01-01 00:00:00
4066	4066	\N	2009-01-01 00:00:00
4067	4067	\N	2009-01-01 00:00:00
4068	4068	\N	2009-01-01 00:00:00
4069	4069	\N	2009-01-01 00:00:00
4070	4070	\N	2009-01-01 00:00:00
4071	4071	\N	2009-01-01 00:00:00
4072	4072	\N	2009-01-01 00:00:00
4073	4073	\N	2009-01-01 00:00:00
4074	4074	\N	2009-01-01 00:00:00
4075	4075	\N	2009-01-01 00:00:00
4076	4076	\N	2009-01-01 00:00:00
4077	4077	\N	2009-01-01 00:00:00
4078	4078	\N	2009-01-01 00:00:00
4079	4079	\N	2009-01-01 00:00:00
4080	4080	\N	2009-01-01 00:00:00
4081	4081	\N	2009-01-01 00:00:00
4082	4082	\N	2009-01-01 00:00:00
4083	4083	\N	2009-01-01 00:00:00
4084	4084	\N	2009-01-01 00:00:00
4085	4085	\N	2009-01-01 00:00:00
4086	4086	\N	2009-01-01 00:00:00
4087	4087	\N	2009-01-01 00:00:00
4088	4088	\N	2009-01-01 00:00:00
4089	4089	\N	2009-01-01 00:00:00
4090	4090	\N	2009-01-01 00:00:00
4091	4091	\N	2009-01-01 00:00:00
4092	4092	\N	2009-01-01 00:00:00
4093	4093	\N	2009-01-01 00:00:00
4094	4094	\N	2009-01-01 00:00:00
4095	4095	\N	2009-01-01 00:00:00
4096	4096	\N	2009-01-01 00:00:00
4097	4097	\N	2009-01-01 00:00:00
4098	4098	\N	2009-01-01 00:00:00
4099	4099	\N	2009-01-01 00:00:00
4100	4100	\N	2009-01-01 00:00:00
4101	4101	\N	2009-01-01 00:00:00
4102	4102	\N	2009-01-01 00:00:00
4103	4103	\N	2009-01-01 00:00:00
4104	4104	\N	2009-01-01 00:00:00
4105	4105	\N	2009-01-01 00:00:00
4106	4106	\N	2009-01-01 00:00:00
4107	4107	\N	2009-01-01 00:00:00
4108	4108	\N	2009-01-01 00:00:00
4109	4109	\N	2009-01-01 00:00:00
4110	4110	\N	2009-01-01 00:00:00
4111	4111	\N	2009-01-01 00:00:00
4112	4112	\N	2009-01-01 00:00:00
4113	4113	\N	2009-01-01 00:00:00
4114	4114	\N	2009-01-01 00:00:00
4115	4115	\N	2009-01-01 00:00:00
4116	4116	\N	2009-01-01 00:00:00
4117	4117	\N	2009-01-01 00:00:00
4118	4118	\N	2009-01-01 00:00:00
4119	4119	\N	2009-01-01 00:00:00
4120	4120	\N	2009-01-01 00:00:00
4121	4121	\N	2009-01-01 00:00:00
4122	4122	\N	2009-01-01 00:00:00
4123	4123	\N	2009-01-01 00:00:00
4124	4124	\N	2009-01-01 00:00:00
4125	4125	\N	2009-01-01 00:00:00
4126	4126	\N	2009-01-01 00:00:00
4127	4127	\N	2009-01-01 00:00:00
4128	4128	\N	2009-01-01 00:00:00
4129	4129	\N	2009-01-01 00:00:00
4130	4130	\N	2009-01-01 00:00:00
4131	4131	\N	2009-01-01 00:00:00
4132	4132	\N	2009-01-01 00:00:00
4133	4133	\N	2009-01-01 00:00:00
4134	4134	\N	2009-01-01 00:00:00
4135	4135	\N	2009-01-01 00:00:00
4136	4136	\N	2009-01-01 00:00:00
4137	4137	\N	2009-01-01 00:00:00
4138	4138	\N	2009-01-01 00:00:00
4139	4139	\N	2009-01-01 00:00:00
4140	4140	\N	2009-01-01 00:00:00
4141	4141	\N	2009-01-01 00:00:00
4142	4142	\N	2009-01-01 00:00:00
4143	4143	\N	2009-01-01 00:00:00
4144	4144	\N	2009-01-01 00:00:00
4145	4145	\N	2009-01-01 00:00:00
4146	4146	\N	2009-01-01 00:00:00
4147	4147	\N	2009-01-01 00:00:00
4148	4148	\N	2009-01-01 00:00:00
4149	4149	\N	2009-01-01 00:00:00
4150	4150	\N	2009-01-01 00:00:00
4151	4151	\N	2009-01-01 00:00:00
4152	4152	\N	2009-01-01 00:00:00
4153	4153	\N	2009-01-01 00:00:00
4154	4154	\N	2009-01-01 00:00:00
4155	4155	\N	2009-01-01 00:00:00
4156	4156	\N	2009-01-01 00:00:00
4157	4157	\N	2009-01-01 00:00:00
4158	4158	\N	2009-01-01 00:00:00
4159	4159	\N	2009-01-01 00:00:00
4160	4160	\N	2009-01-01 00:00:00
4161	4161	\N	2009-01-01 00:00:00
4162	4162	\N	2009-01-01 00:00:00
4163	4163	\N	2009-01-01 00:00:00
4164	4164	\N	2009-01-01 00:00:00
4165	4165	\N	2009-01-01 00:00:00
4166	4166	\N	2009-01-01 00:00:00
4167	4167	\N	2009-01-01 00:00:00
4168	4168	\N	2009-01-01 00:00:00
4169	4169	\N	2009-01-01 00:00:00
4170	4170	\N	2009-01-01 00:00:00
4171	4171	\N	2009-01-01 00:00:00
4172	4172	\N	2009-01-01 00:00:00
4173	4173	\N	2009-01-01 00:00:00
4174	4174	\N	2009-01-01 00:00:00
4175	4175	\N	2009-01-01 00:00:00
4176	4176	\N	2009-01-01 00:00:00
4177	4177	\N	2009-01-01 00:00:00
4178	4178	\N	2009-01-01 00:00:00
4179	4179	\N	2009-01-01 00:00:00
4180	4180	\N	2009-01-01 00:00:00
4181	4181	\N	2009-01-01 00:00:00
4182	4182	\N	2009-01-01 00:00:00
4183	4183	\N	2009-01-01 00:00:00
4184	4184	\N	2009-01-01 00:00:00
4185	4185	\N	2009-01-01 00:00:00
4186	4186	\N	2009-01-01 00:00:00
4187	4187	\N	2009-01-01 00:00:00
4188	4188	\N	2009-01-01 00:00:00
4189	4189	\N	2009-01-01 00:00:00
4190	4190	\N	2009-01-01 00:00:00
4191	4191	\N	2009-01-01 00:00:00
4192	4192	\N	2009-01-01 00:00:00
4193	4193	\N	2009-01-01 00:00:00
4194	4194	\N	2009-01-01 00:00:00
4195	4195	\N	2009-01-01 00:00:00
4196	4196	\N	2009-01-01 00:00:00
4197	4197	\N	2009-01-01 00:00:00
4198	4198	\N	2009-01-01 00:00:00
4199	4199	\N	2009-01-01 00:00:00
4200	4200	\N	2009-01-01 00:00:00
4201	4201	\N	2009-01-01 00:00:00
4202	4202	\N	2009-01-01 00:00:00
4203	4203	\N	2009-01-01 00:00:00
4204	4204	\N	2009-01-01 00:00:00
4205	4205	\N	2009-01-01 00:00:00
4206	4206	\N	2009-01-01 00:00:00
4207	4207	\N	2009-01-01 00:00:00
4208	4208	\N	2009-01-01 00:00:00
4209	4209	\N	2009-01-01 00:00:00
4210	4210	\N	2009-01-01 00:00:00
4211	4211	\N	2009-01-01 00:00:00
4212	4212	\N	2009-01-01 00:00:00
4213	4213	\N	2009-01-01 00:00:00
4214	4214	\N	2009-01-01 00:00:00
4215	4215	\N	2009-01-01 00:00:00
4216	4216	\N	2009-01-01 00:00:00
4217	4217	\N	2009-01-01 00:00:00
4218	4218	\N	2009-01-01 00:00:00
4219	4219	\N	2009-01-01 00:00:00
4220	4220	\N	2009-01-01 00:00:00
4221	4221	\N	2009-01-01 00:00:00
4222	4222	\N	2009-01-01 00:00:00
4223	4223	\N	2009-01-01 00:00:00
4224	4224	\N	2009-01-01 00:00:00
4225	4225	\N	2009-01-01 00:00:00
4226	4226	\N	2009-01-01 00:00:00
4227	4227	\N	2009-01-01 00:00:00
4228	4228	\N	2009-01-01 00:00:00
4229	4229	\N	2009-01-01 00:00:00
4230	4230	\N	2009-01-01 00:00:00
4231	4231	\N	2009-01-01 00:00:00
4232	4232	\N	2009-01-01 00:00:00
4233	4233	\N	2009-01-01 00:00:00
4234	4234	\N	2009-01-01 00:00:00
4235	4235	\N	2009-01-01 00:00:00
4236	4236	\N	2009-01-01 00:00:00
4237	4237	\N	2009-01-01 00:00:00
4238	4238	\N	2009-01-01 00:00:00
4239	4239	\N	2009-01-01 00:00:00
4240	4240	\N	2009-01-01 00:00:00
4241	4241	\N	2009-01-01 00:00:00
4242	4242	\N	2009-01-01 00:00:00
4243	4243	\N	2009-01-01 00:00:00
4244	4244	\N	2009-01-01 00:00:00
4245	4245	\N	2009-01-01 00:00:00
4246	4246	\N	2009-01-01 00:00:00
4247	4247	\N	2009-01-01 00:00:00
4248	4248	\N	2009-01-01 00:00:00
4249	4249	\N	2009-01-01 00:00:00
4250	4250	\N	2009-01-01 00:00:00
4251	4251	\N	2009-01-01 00:00:00
4252	4252	\N	2009-01-01 00:00:00
4253	4253	\N	2009-01-01 00:00:00
4254	4254	\N	2009-01-01 00:00:00
4255	4255	\N	2009-01-01 00:00:00
4256	4256	\N	2009-01-01 00:00:00
4257	4257	\N	2009-01-01 00:00:00
4258	4258	\N	2009-01-01 00:00:00
4259	4259	\N	2009-01-01 00:00:00
4260	4260	\N	2009-01-01 00:00:00
4261	4261	\N	2009-01-01 00:00:00
4262	4262	\N	2009-01-01 00:00:00
4263	4263	\N	2009-01-01 00:00:00
4264	4264	\N	2009-01-01 00:00:00
4265	4265	\N	2009-01-01 00:00:00
4266	4266	\N	2009-01-01 00:00:00
4267	4267	\N	2009-01-01 00:00:00
4268	4268	\N	2009-01-01 00:00:00
4269	4269	\N	2009-01-01 00:00:00
4270	4270	\N	2009-01-01 00:00:00
4271	4271	\N	2009-01-01 00:00:00
4272	4272	\N	2009-01-01 00:00:00
4273	4273	\N	2009-01-01 00:00:00
4274	4274	\N	2009-01-01 00:00:00
4275	4275	\N	2009-01-01 00:00:00
4276	4276	\N	2009-01-01 00:00:00
4277	4277	\N	2009-01-01 00:00:00
4278	4278	\N	2009-01-01 00:00:00
4279	4279	\N	2009-01-01 00:00:00
4280	4280	\N	2009-01-01 00:00:00
4281	4281	\N	2009-01-01 00:00:00
4282	4282	\N	2009-01-01 00:00:00
4283	4283	\N	2009-01-01 00:00:00
4284	4284	\N	2009-01-01 00:00:00
4285	4285	\N	2009-01-01 00:00:00
4286	4286	\N	2009-01-01 00:00:00
4287	4287	\N	2009-01-01 00:00:00
4288	4288	\N	2009-01-01 00:00:00
4289	4289	\N	2009-01-01 00:00:00
4290	4290	\N	2009-01-01 00:00:00
4291	4291	\N	2009-01-01 00:00:00
4292	4292	\N	2009-01-01 00:00:00
4293	4293	\N	2009-01-01 00:00:00
4294	4294	\N	2009-01-01 00:00:00
4295	4295	\N	2009-01-01 00:00:00
4296	4296	\N	2009-01-01 00:00:00
4297	4297	\N	2009-01-01 00:00:00
4298	4298	\N	2009-01-01 00:00:00
4299	4299	\N	2009-01-01 00:00:00
4300	4300	\N	2009-01-01 00:00:00
4301	4301	\N	2009-01-01 00:00:00
4302	4302	\N	2009-01-01 00:00:00
4303	4303	\N	2009-01-01 00:00:00
4304	4304	\N	2009-01-01 00:00:00
4305	4305	\N	2009-01-01 00:00:00
4306	4306	\N	2009-01-01 00:00:00
4307	4307	\N	2009-01-01 00:00:00
4308	4308	\N	2009-01-01 00:00:00
4309	4309	\N	2009-01-01 00:00:00
4310	4310	\N	2009-01-01 00:00:00
4311	4311	\N	2009-01-01 00:00:00
4312	4312	\N	2009-01-01 00:00:00
4313	4313	\N	2009-01-01 00:00:00
4314	4314	\N	2009-01-01 00:00:00
4315	4315	\N	2009-01-01 00:00:00
4316	4316	\N	2009-01-01 00:00:00
4317	4317	\N	2009-01-01 00:00:00
4318	4318	\N	2009-01-01 00:00:00
4319	4319	\N	2009-01-01 00:00:00
4320	4320	\N	2009-01-01 00:00:00
4321	4321	\N	2009-01-01 00:00:00
4322	4322	\N	2009-01-01 00:00:00
4323	4323	\N	2009-01-01 00:00:00
4324	4324	\N	2009-01-01 00:00:00
4325	4325	\N	2009-01-01 00:00:00
4326	4326	\N	2009-01-01 00:00:00
4327	4327	\N	2009-01-01 00:00:00
4328	4328	\N	2009-01-01 00:00:00
4329	4329	\N	2009-01-01 00:00:00
4330	4330	\N	2009-01-01 00:00:00
4331	4331	\N	2009-01-01 00:00:00
4332	4332	\N	2009-01-01 00:00:00
4333	4333	\N	2009-01-01 00:00:00
4334	4334	\N	2009-01-01 00:00:00
4335	4335	\N	2009-01-01 00:00:00
4336	4336	\N	2009-01-01 00:00:00
4337	4337	\N	2009-01-01 00:00:00
4338	4338	\N	2009-01-01 00:00:00
4339	4339	\N	2009-01-01 00:00:00
4340	4340	\N	2009-01-01 00:00:00
4341	4341	\N	2009-01-01 00:00:00
4342	4342	\N	2009-01-01 00:00:00
4343	4343	\N	2009-01-01 00:00:00
4344	4344	\N	2009-01-01 00:00:00
4345	4345	\N	2009-01-01 00:00:00
4346	4346	\N	2009-01-01 00:00:00
4347	4347	\N	2009-01-01 00:00:00
4348	4348	\N	2009-01-01 00:00:00
4349	4349	\N	2009-01-01 00:00:00
4350	4350	\N	2009-01-01 00:00:00
4351	4351	\N	2009-01-01 00:00:00
4352	4352	\N	2009-01-01 00:00:00
4353	4353	\N	2009-01-01 00:00:00
4354	4354	\N	2009-01-01 00:00:00
4355	4355	\N	2009-01-01 00:00:00
4356	4356	\N	2009-01-01 00:00:00
4357	4357	\N	2009-01-01 00:00:00
4358	4358	\N	2009-01-01 00:00:00
4359	4359	\N	2009-01-01 00:00:00
4360	4360	\N	2009-01-01 00:00:00
4361	4361	\N	2009-01-01 00:00:00
4362	4362	\N	2009-01-01 00:00:00
4363	4363	\N	2009-01-01 00:00:00
4364	4364	\N	2009-01-01 00:00:00
4365	4365	\N	2009-01-01 00:00:00
4366	4366	\N	2009-01-01 00:00:00
4367	4367	\N	2009-01-01 00:00:00
4368	4368	\N	2009-01-01 00:00:00
4369	4369	\N	2009-01-01 00:00:00
4370	4370	\N	2009-01-01 00:00:00
4371	4371	\N	2009-01-01 00:00:00
4372	4372	\N	2009-01-01 00:00:00
4373	4373	\N	2009-01-01 00:00:00
4374	4374	\N	2009-01-01 00:00:00
4375	4375	\N	2009-01-01 00:00:00
4376	4376	\N	2009-01-01 00:00:00
4377	4377	\N	2009-01-01 00:00:00
4378	4378	\N	2009-01-01 00:00:00
4379	4379	\N	2009-01-01 00:00:00
4380	4380	\N	2009-01-01 00:00:00
4381	4381	\N	2009-01-01 00:00:00
4382	4382	\N	2009-01-01 00:00:00
4383	4383	\N	2009-01-01 00:00:00
4384	4384	\N	2009-01-01 00:00:00
4385	4385	\N	2009-01-01 00:00:00
4386	4386	\N	2009-01-01 00:00:00
4387	4387	\N	2009-01-01 00:00:00
4388	4388	\N	2009-01-01 00:00:00
4389	4389	\N	2009-01-01 00:00:00
4390	4390	\N	2009-01-01 00:00:00
4391	4391	\N	2009-01-01 00:00:00
4392	4392	\N	2009-01-01 00:00:00
4393	4393	\N	2009-01-01 00:00:00
4394	4394	\N	2009-01-01 00:00:00
4395	4395	\N	2009-01-01 00:00:00
4396	4396	\N	2009-01-01 00:00:00
4397	4397	\N	2009-01-01 00:00:00
4398	4398	\N	2009-01-01 00:00:00
4399	4399	\N	2009-01-01 00:00:00
4400	4400	\N	2009-01-01 00:00:00
4401	4401	\N	2009-01-01 00:00:00
4402	4402	\N	2009-01-01 00:00:00
4403	4403	\N	2009-01-01 00:00:00
4404	4404	\N	2009-01-01 00:00:00
4405	4405	\N	2009-01-01 00:00:00
4406	4406	\N	2009-01-01 00:00:00
4407	4407	\N	2009-01-01 00:00:00
4408	4408	\N	2009-01-01 00:00:00
4409	4409	\N	2009-01-01 00:00:00
4410	4410	\N	2009-01-01 00:00:00
4411	4411	\N	2009-01-01 00:00:00
4412	4412	\N	2009-01-01 00:00:00
4413	4413	\N	2009-01-01 00:00:00
4414	4414	\N	2009-01-01 00:00:00
4415	4415	\N	2009-01-01 00:00:00
4416	4416	\N	2009-01-01 00:00:00
4417	4417	\N	2009-01-01 00:00:00
4418	4418	\N	2009-01-01 00:00:00
4419	4419	\N	2009-01-01 00:00:00
4420	4420	\N	2009-01-01 00:00:00
4421	4421	\N	2009-01-01 00:00:00
4422	4422	\N	2009-01-01 00:00:00
4423	4423	\N	2009-01-01 00:00:00
4424	4424	\N	2009-01-01 00:00:00
4425	4425	\N	2009-01-01 00:00:00
4426	4426	\N	2009-01-01 00:00:00
4427	4427	\N	2009-01-01 00:00:00
4428	4428	\N	2009-01-01 00:00:00
4429	4429	\N	2009-01-01 00:00:00
4430	4430	\N	2009-01-01 00:00:00
4431	4431	\N	2009-01-01 00:00:00
4432	4432	\N	2009-01-01 00:00:00
4433	4433	\N	2009-01-01 00:00:00
4434	4434	\N	2009-01-01 00:00:00
4435	4435	\N	2009-01-01 00:00:00
4436	4436	\N	2009-01-01 00:00:00
4437	4437	\N	2009-01-01 00:00:00
4438	4438	\N	2009-01-01 00:00:00
4439	4439	\N	2009-01-01 00:00:00
4440	4440	\N	2009-01-01 00:00:00
4441	4441	\N	2009-01-01 00:00:00
4442	4442	\N	2009-01-01 00:00:00
4443	4443	\N	2009-01-01 00:00:00
4444	4444	\N	2009-01-01 00:00:00
4445	4445	\N	2009-01-01 00:00:00
4446	4446	\N	2009-01-01 00:00:00
4447	4447	\N	2009-01-01 00:00:00
4448	4448	\N	2009-01-01 00:00:00
4449	4449	\N	2009-01-01 00:00:00
4450	4450	\N	2009-01-01 00:00:00
4451	4451	\N	2009-01-01 00:00:00
4452	4452	\N	2009-01-01 00:00:00
4453	4453	\N	2009-01-01 00:00:00
4454	4454	\N	2009-01-01 00:00:00
4455	4455	\N	2009-01-01 00:00:00
4456	4456	\N	2009-01-01 00:00:00
4457	4457	\N	2009-01-01 00:00:00
4458	4458	\N	2009-01-01 00:00:00
4459	4459	\N	2009-01-01 00:00:00
4460	4460	\N	2009-01-01 00:00:00
4461	4461	\N	2009-01-01 00:00:00
4462	4462	\N	2009-01-01 00:00:00
4463	4463	\N	2009-01-01 00:00:00
4464	4464	\N	2009-01-01 00:00:00
4465	4465	\N	2009-01-01 00:00:00
4466	4466	\N	2009-01-01 00:00:00
4467	4467	\N	2009-01-01 00:00:00
4468	4468	\N	2009-01-01 00:00:00
4469	4469	\N	2009-01-01 00:00:00
4470	4470	\N	2009-01-01 00:00:00
4471	4471	\N	2009-01-01 00:00:00
4472	4472	\N	2009-01-01 00:00:00
4473	4473	\N	2009-01-01 00:00:00
4474	4474	\N	2009-01-01 00:00:00
4475	4475	\N	2009-01-01 00:00:00
4476	4476	\N	2009-01-01 00:00:00
4477	4477	\N	2009-01-01 00:00:00
4478	4478	\N	2009-01-01 00:00:00
4479	4479	\N	2009-01-01 00:00:00
4480	4480	\N	2009-01-01 00:00:00
4481	4481	\N	2009-01-01 00:00:00
4482	4482	\N	2009-01-01 00:00:00
4483	4483	\N	2009-01-01 00:00:00
4484	4484	\N	2009-01-01 00:00:00
4485	4485	\N	2009-01-01 00:00:00
4486	4486	\N	2009-01-01 00:00:00
4487	4487	\N	2009-01-01 00:00:00
4488	4488	\N	2009-01-01 00:00:00
4489	4489	\N	2009-01-01 00:00:00
4490	4490	\N	2009-01-01 00:00:00
4491	4491	\N	2009-01-01 00:00:00
4492	4492	\N	2009-01-01 00:00:00
4493	4493	\N	2009-01-01 00:00:00
4494	4494	\N	2009-01-01 00:00:00
4495	4495	\N	2009-01-01 00:00:00
4496	4496	\N	2009-01-01 00:00:00
4497	4497	\N	2009-01-01 00:00:00
4498	4498	\N	2009-01-01 00:00:00
4499	4499	\N	2009-01-01 00:00:00
4500	4500	\N	2009-01-01 00:00:00
4501	4501	\N	2009-01-01 00:00:00
4502	4502	\N	2009-01-01 00:00:00
4503	4503	\N	2009-01-01 00:00:00
4504	4504	\N	2009-01-01 00:00:00
4505	4505	\N	2009-01-01 00:00:00
4506	4506	\N	2009-01-01 00:00:00
4507	4507	\N	2009-01-01 00:00:00
4508	4508	\N	2009-01-01 00:00:00
4509	4509	\N	2009-01-01 00:00:00
4510	4510	\N	2009-01-01 00:00:00
4511	4511	\N	2009-01-01 00:00:00
4512	4512	\N	2009-01-01 00:00:00
4513	4513	\N	2009-01-01 00:00:00
4514	4514	\N	2009-01-01 00:00:00
4515	4515	\N	2009-01-01 00:00:00
4516	4516	\N	2009-01-01 00:00:00
4517	4517	\N	2009-01-01 00:00:00
4518	4518	\N	2009-01-01 00:00:00
4519	4519	\N	2009-01-01 00:00:00
4520	4520	\N	2009-01-01 00:00:00
4521	4521	\N	2009-01-01 00:00:00
4522	4522	\N	2009-01-01 00:00:00
4523	4523	\N	2009-01-01 00:00:00
4524	4524	\N	2009-01-01 00:00:00
4525	4525	\N	2009-01-01 00:00:00
4526	4526	\N	2009-01-01 00:00:00
4527	4527	\N	2009-01-01 00:00:00
4528	4528	\N	2009-01-01 00:00:00
4529	4529	\N	2009-01-01 00:00:00
4530	4530	\N	2009-01-01 00:00:00
4531	4531	\N	2009-01-01 00:00:00
4532	4532	\N	2009-01-01 00:00:00
4533	4533	\N	2009-01-01 00:00:00
4534	4534	\N	2009-01-01 00:00:00
4535	4535	\N	2009-01-01 00:00:00
4536	4536	\N	2009-01-01 00:00:00
4537	4537	\N	2009-01-01 00:00:00
4538	4538	\N	2009-01-01 00:00:00
4539	4539	\N	2009-01-01 00:00:00
4540	4540	\N	2009-01-01 00:00:00
4541	4541	\N	2009-01-01 00:00:00
4542	4542	\N	2009-01-01 00:00:00
4543	4543	\N	2009-01-01 00:00:00
4544	4544	\N	2009-01-01 00:00:00
4545	4545	\N	2009-01-01 00:00:00
4546	4546	\N	2009-01-01 00:00:00
4547	4547	\N	2009-01-01 00:00:00
4548	4548	\N	2009-01-01 00:00:00
4549	4549	\N	2009-01-01 00:00:00
4550	4550	\N	2009-01-01 00:00:00
4551	4551	\N	2009-01-01 00:00:00
4552	4552	\N	2009-01-01 00:00:00
4553	4553	\N	2009-01-01 00:00:00
4554	4554	\N	2009-01-01 00:00:00
4555	4555	\N	2009-01-01 00:00:00
4556	4556	\N	2009-01-01 00:00:00
4557	4557	\N	2009-01-01 00:00:00
4558	4558	\N	2009-01-01 00:00:00
4559	4559	\N	2009-01-01 00:00:00
4560	4560	\N	2009-01-01 00:00:00
4561	4561	\N	2009-01-01 00:00:00
4562	4562	\N	2009-01-01 00:00:00
4563	4563	\N	2009-01-01 00:00:00
4564	4564	\N	2009-01-01 00:00:00
4565	4565	\N	2009-01-01 00:00:00
4566	4566	\N	2009-01-01 00:00:00
4567	4567	\N	2009-01-01 00:00:00
4568	4568	\N	2009-01-01 00:00:00
4569	4569	\N	2009-01-01 00:00:00
4570	4570	\N	2009-01-01 00:00:00
4571	4571	\N	2009-01-01 00:00:00
4572	4572	\N	2009-01-01 00:00:00
4573	4573	\N	2009-01-01 00:00:00
4574	4574	\N	2009-01-01 00:00:00
4575	4575	\N	2009-01-01 00:00:00
4576	4576	\N	2009-01-01 00:00:00
4577	4577	\N	2009-01-01 00:00:00
4578	4578	\N	2009-01-01 00:00:00
4579	4579	\N	2009-01-01 00:00:00
4580	4580	\N	2009-01-01 00:00:00
4581	4581	\N	2009-01-01 00:00:00
4582	4582	\N	2009-01-01 00:00:00
4583	4583	\N	2009-01-01 00:00:00
4584	4584	\N	2009-01-01 00:00:00
4585	4585	\N	2009-01-01 00:00:00
4586	4586	\N	2009-01-01 00:00:00
4587	4587	\N	2009-01-01 00:00:00
4588	4588	\N	2009-01-01 00:00:00
4589	4589	\N	2009-01-01 00:00:00
4590	4590	\N	2009-01-01 00:00:00
4591	4591	\N	2009-01-01 00:00:00
4592	4592	\N	2009-01-01 00:00:00
4593	4593	\N	2009-01-01 00:00:00
4594	4594	\N	2009-01-01 00:00:00
4595	4595	\N	2009-01-01 00:00:00
4596	4596	\N	2009-01-01 00:00:00
4597	4597	\N	2009-01-01 00:00:00
4598	4598	\N	2009-01-01 00:00:00
4599	4599	\N	2009-01-01 00:00:00
4600	4600	\N	2009-01-01 00:00:00
4601	4601	\N	2009-01-01 00:00:00
4602	4602	\N	2009-01-01 00:00:00
4603	4603	\N	2009-01-01 00:00:00
4604	4604	\N	2009-01-01 00:00:00
4605	4605	\N	2009-01-01 00:00:00
4606	4606	\N	2009-01-01 00:00:00
4607	4607	\N	2009-01-01 00:00:00
4608	4608	\N	2009-01-01 00:00:00
4609	4609	\N	2009-01-01 00:00:00
4610	4610	\N	2009-01-01 00:00:00
4611	4611	\N	2009-01-01 00:00:00
4612	4612	\N	2009-01-01 00:00:00
4613	4613	\N	2009-01-01 00:00:00
4614	4614	\N	2009-01-01 00:00:00
4615	4615	\N	2009-01-01 00:00:00
4616	4616	\N	2009-01-01 00:00:00
4617	4617	\N	2009-01-01 00:00:00
4618	4618	\N	2009-01-01 00:00:00
4619	4619	\N	2009-01-01 00:00:00
4620	4620	\N	2009-01-01 00:00:00
4621	4621	\N	2009-01-01 00:00:00
4622	4622	\N	2009-01-01 00:00:00
4623	4623	\N	2009-01-01 00:00:00
4624	4624	\N	2009-01-01 00:00:00
4625	4625	\N	2009-01-01 00:00:00
4626	4626	\N	2009-01-01 00:00:00
4627	4627	\N	2009-01-01 00:00:00
4628	4628	\N	2009-01-01 00:00:00
4629	4629	\N	2009-01-01 00:00:00
4630	4630	\N	2009-01-01 00:00:00
4631	4631	\N	2009-01-01 00:00:00
4632	4632	\N	2009-01-01 00:00:00
4633	4633	\N	2009-01-01 00:00:00
4634	4634	\N	2009-01-01 00:00:00
4635	4635	\N	2009-01-01 00:00:00
4636	4636	\N	2009-01-01 00:00:00
4637	4637	\N	2009-01-01 00:00:00
4638	4638	\N	2009-01-01 00:00:00
4639	4639	\N	2009-01-01 00:00:00
4640	4640	\N	2009-01-01 00:00:00
4641	4641	\N	2009-01-01 00:00:00
4642	4642	\N	2009-01-01 00:00:00
4643	4643	\N	2009-01-01 00:00:00
4644	4644	\N	2009-01-01 00:00:00
4645	4645	\N	2009-01-01 00:00:00
4646	4646	\N	2009-01-01 00:00:00
4647	4647	\N	2009-01-01 00:00:00
4648	4648	\N	2009-01-01 00:00:00
4649	4649	\N	2009-01-01 00:00:00
4650	4650	\N	2009-01-01 00:00:00
4651	4651	\N	2009-01-01 00:00:00
4652	4652	\N	2009-01-01 00:00:00
4653	4653	\N	2009-01-01 00:00:00
4654	4654	\N	2009-01-01 00:00:00
4655	4655	\N	2009-01-01 00:00:00
4656	4656	\N	2009-01-01 00:00:00
4657	4657	\N	2009-01-01 00:00:00
4658	4658	\N	2009-01-01 00:00:00
4659	4659	\N	2009-01-01 00:00:00
4660	4660	\N	2009-01-01 00:00:00
4661	4661	\N	2009-01-01 00:00:00
4662	4662	\N	2009-01-01 00:00:00
4663	4663	\N	2009-01-01 00:00:00
4664	4664	\N	2009-01-01 00:00:00
4665	4665	\N	2009-01-01 00:00:00
4666	4666	\N	2009-01-01 00:00:00
4667	4667	\N	2009-01-01 00:00:00
4668	4668	\N	2009-01-01 00:00:00
4669	4669	\N	2009-01-01 00:00:00
4670	4670	\N	2009-01-01 00:00:00
4671	4671	\N	2009-01-01 00:00:00
4672	4672	\N	2009-01-01 00:00:00
4673	4673	\N	2009-01-01 00:00:00
4674	4674	\N	2009-01-01 00:00:00
4675	4675	\N	2009-01-01 00:00:00
4676	4676	\N	2009-01-01 00:00:00
4677	4677	\N	2009-01-01 00:00:00
4678	4678	\N	2009-01-01 00:00:00
4679	4679	\N	2009-01-01 00:00:00
4680	4680	\N	2009-01-01 00:00:00
4681	4681	\N	2009-01-01 00:00:00
4682	4682	\N	2009-01-01 00:00:00
4683	4683	\N	2009-01-01 00:00:00
4684	4684	\N	2009-01-01 00:00:00
4685	4685	\N	2009-01-01 00:00:00
4686	4686	\N	2009-01-01 00:00:00
4687	4687	\N	2009-01-01 00:00:00
4688	4688	\N	2009-01-01 00:00:00
4689	4689	\N	2009-01-01 00:00:00
4690	4690	\N	2009-01-01 00:00:00
4691	4691	\N	2009-01-01 00:00:00
4692	4692	\N	2009-01-01 00:00:00
4693	4693	\N	2009-01-01 00:00:00
4694	4694	\N	2009-01-01 00:00:00
4695	4695	\N	2009-01-01 00:00:00
4696	4696	\N	2009-01-01 00:00:00
4697	4697	\N	2009-01-01 00:00:00
4698	4698	\N	2009-01-01 00:00:00
4699	4699	\N	2009-01-01 00:00:00
4700	4700	\N	2009-01-01 00:00:00
4701	4701	\N	2009-01-01 00:00:00
4702	4702	\N	2009-01-01 00:00:00
4703	4703	\N	2009-01-01 00:00:00
4704	4704	\N	2009-01-01 00:00:00
4705	4705	\N	2009-01-01 00:00:00
4706	4706	\N	2009-01-01 00:00:00
4707	4707	\N	2009-01-01 00:00:00
4708	4708	\N	2009-01-01 00:00:00
4709	4709	\N	2009-01-01 00:00:00
4710	4710	\N	2009-01-01 00:00:00
4711	4711	\N	2009-01-01 00:00:00
4712	4712	\N	2009-01-01 00:00:00
4713	4713	\N	2009-01-01 00:00:00
4714	4714	\N	2009-01-01 00:00:00
4715	4715	\N	2009-01-01 00:00:00
4716	4716	\N	2009-01-01 00:00:00
4717	4717	\N	2009-01-01 00:00:00
4718	4718	\N	2009-01-01 00:00:00
4719	4719	\N	2009-01-01 00:00:00
4720	4720	\N	2009-01-01 00:00:00
4721	4721	\N	2009-01-01 00:00:00
4722	4722	\N	2009-01-01 00:00:00
4723	4723	\N	2009-01-01 00:00:00
4724	4724	\N	2009-01-01 00:00:00
4725	4725	\N	2009-01-01 00:00:00
4726	4726	\N	2009-01-01 00:00:00
4727	4727	\N	2009-01-01 00:00:00
4728	4728	\N	2009-01-01 00:00:00
4729	4729	\N	2009-01-01 00:00:00
4730	4730	\N	2009-01-01 00:00:00
4731	4731	\N	2009-01-01 00:00:00
4732	4732	\N	2009-01-01 00:00:00
4733	4733	\N	2009-01-01 00:00:00
4734	4734	\N	2009-01-01 00:00:00
4735	4735	\N	2009-01-01 00:00:00
4736	4736	\N	2009-01-01 00:00:00
4737	4737	\N	2009-01-01 00:00:00
4738	4738	\N	2009-01-01 00:00:00
4739	4739	\N	2009-01-01 00:00:00
4740	4740	\N	2009-01-01 00:00:00
4741	4741	\N	2009-01-01 00:00:00
4742	4742	\N	2009-01-01 00:00:00
4743	4743	\N	2009-01-01 00:00:00
4744	4744	\N	2009-01-01 00:00:00
4745	4745	\N	2009-01-01 00:00:00
4746	4746	\N	2009-01-01 00:00:00
4747	4747	\N	2009-01-01 00:00:00
4748	4748	\N	2009-01-01 00:00:00
4749	4749	\N	2009-01-01 00:00:00
4750	4750	\N	2009-01-01 00:00:00
4751	4751	\N	2009-01-01 00:00:00
4752	4752	\N	2009-01-01 00:00:00
4753	4753	\N	2009-01-01 00:00:00
4754	4754	\N	2009-01-01 00:00:00
4755	4755	\N	2009-01-01 00:00:00
4756	4756	\N	2009-01-01 00:00:00
4757	4757	\N	2009-01-01 00:00:00
4758	4758	\N	2009-01-01 00:00:00
4759	4759	\N	2009-01-01 00:00:00
4760	4760	\N	2009-01-01 00:00:00
4761	4761	\N	2009-01-01 00:00:00
4762	4762	\N	2009-01-01 00:00:00
4763	4763	\N	2009-01-01 00:00:00
4764	4764	\N	2009-01-01 00:00:00
4765	4765	\N	2009-01-01 00:00:00
4766	4766	\N	2009-01-01 00:00:00
4767	4767	\N	2009-01-01 00:00:00
4768	4768	\N	2009-01-01 00:00:00
4769	4769	\N	2009-01-01 00:00:00
4770	4770	\N	2009-01-01 00:00:00
4771	4771	\N	2009-01-01 00:00:00
4772	4772	\N	2009-01-01 00:00:00
4773	4773	\N	2009-01-01 00:00:00
4877	4877	\N	2009-01-01 00:00:00
4878	4878	\N	2009-01-01 00:00:00
4879	4879	\N	2009-01-01 00:00:00
4880	4880	\N	2009-01-01 00:00:00
4881	4881	\N	2009-01-01 00:00:00
4882	4882	\N	2009-01-01 00:00:00
4883	4883	\N	2009-01-01 00:00:00
4884	4884	\N	2009-01-01 00:00:00
4885	4885	\N	2009-01-01 00:00:00
4886	4886	\N	2009-01-01 00:00:00
4887	4887	\N	2009-01-01 00:00:00
4888	4888	\N	2009-01-01 00:00:00
4889	4889	\N	2009-01-01 00:00:00
4890	4890	\N	2009-01-01 00:00:00
4891	4891	\N	2009-01-01 00:00:00
4892	4892	\N	2009-01-01 00:00:00
4893	4893	\N	2009-01-01 00:00:00
4894	4894	\N	2009-01-01 00:00:00
4895	4895	\N	2009-01-01 00:00:00
4896	4896	\N	2009-01-01 00:00:00
4897	4897	\N	2009-01-01 00:00:00
4898	4898	\N	2009-01-01 00:00:00
4899	4899	\N	2009-01-01 00:00:00
4900	4900	\N	2009-01-01 00:00:00
4901	4901	\N	2009-01-01 00:00:00
4902	4902	\N	2009-01-01 00:00:00
4903	4903	\N	2009-01-01 00:00:00
4904	4904	\N	2009-01-01 00:00:00
4905	4905	\N	2009-01-01 00:00:00
4906	4906	\N	2009-01-01 00:00:00
4907	4907	\N	2009-01-01 00:00:00
4908	4908	\N	2009-01-01 00:00:00
4909	4909	\N	2009-01-01 00:00:00
4910	4910	\N	2009-01-01 00:00:00
4911	4911	\N	2009-01-01 00:00:00
4912	4912	\N	2009-01-01 00:00:00
4913	4913	\N	2009-01-01 00:00:00
4914	4914	\N	2009-01-01 00:00:00
4915	4915	\N	2009-01-01 00:00:00
4916	4916	\N	2009-01-01 00:00:00
4917	4917	\N	2009-01-01 00:00:00
4918	4918	\N	2009-01-01 00:00:00
4919	4919	\N	2009-01-01 00:00:00
4920	4920	\N	2009-01-01 00:00:00
4921	4921	\N	2009-01-01 00:00:00
4922	4922	\N	2009-01-01 00:00:00
4923	4923	\N	2009-01-01 00:00:00
4924	4924	\N	2009-01-01 00:00:00
4925	4925	\N	2009-01-01 00:00:00
4926	4926	\N	2009-01-01 00:00:00
4927	4927	\N	2009-01-01 00:00:00
4928	4928	\N	2009-01-01 00:00:00
4929	4929	\N	2009-01-01 00:00:00
4930	4930	\N	2009-01-01 00:00:00
4931	4931	\N	2009-01-01 00:00:00
4932	4932	\N	2009-01-01 00:00:00
4933	4933	\N	2009-01-01 00:00:00
4934	4934	\N	2009-01-01 00:00:00
4935	4935	\N	2009-01-01 00:00:00
4936	4936	\N	2009-01-01 00:00:00
4937	4937	\N	2009-01-01 00:00:00
4938	4938	\N	2009-01-01 00:00:00
4939	4939	\N	2009-01-01 00:00:00
4940	4940	\N	2009-01-01 00:00:00
4941	4941	\N	2009-01-01 00:00:00
4942	4942	\N	2009-01-01 00:00:00
4943	4943	\N	2009-01-01 00:00:00
4944	4944	\N	2009-01-01 00:00:00
4945	4945	\N	2009-01-01 00:00:00
4946	4946	\N	2009-01-01 00:00:00
4947	4947	\N	2009-01-01 00:00:00
4948	4948	\N	2009-01-01 00:00:00
4949	4949	\N	2009-01-01 00:00:00
4950	4950	\N	2009-01-01 00:00:00
4951	4951	\N	2009-01-01 00:00:00
4952	4952	\N	2009-01-01 00:00:00
4953	4953	\N	2009-01-01 00:00:00
4954	4954	\N	2009-01-01 00:00:00
4955	4955	\N	2009-01-01 00:00:00
4956	4956	\N	2009-01-01 00:00:00
4957	4957	\N	2009-01-01 00:00:00
4958	4958	\N	2009-01-01 00:00:00
4959	4959	\N	2009-01-01 00:00:00
4960	4960	\N	2009-01-01 00:00:00
4961	4961	\N	2009-01-01 00:00:00
4962	4962	\N	2009-01-01 00:00:00
4963	4963	\N	2009-01-01 00:00:00
4964	4964	\N	2009-01-01 00:00:00
4965	4965	\N	2009-01-01 00:00:00
4966	4966	\N	2009-01-01 00:00:00
4967	4967	\N	2009-01-01 00:00:00
4968	4968	\N	2009-01-01 00:00:00
4969	4969	\N	2009-01-01 00:00:00
4970	4970	\N	2009-01-01 00:00:00
4971	4971	\N	2009-01-01 00:00:00
4972	4972	\N	2009-01-01 00:00:00
4973	4973	\N	2009-01-01 00:00:00
4974	4974	\N	2009-01-01 00:00:00
4975	4975	\N	2009-01-01 00:00:00
4976	4976	\N	2009-01-01 00:00:00
4977	4977	\N	2009-01-01 00:00:00
4978	4978	\N	2009-01-01 00:00:00
4979	4979	\N	2009-01-01 00:00:00
4980	4980	\N	2009-01-01 00:00:00
4981	4981	\N	2009-01-01 00:00:00
4982	4982	\N	2009-01-01 00:00:00
4983	4983	\N	2009-01-01 00:00:00
4984	4984	\N	2009-01-01 00:00:00
4985	4985	\N	2009-01-01 00:00:00
4986	4986	\N	2009-01-01 00:00:00
4987	4987	\N	2009-01-01 00:00:00
4988	4988	\N	2009-01-01 00:00:00
4989	4989	\N	2009-01-01 00:00:00
4990	4990	\N	2009-01-01 00:00:00
4991	4991	\N	2009-01-01 00:00:00
4992	4992	\N	2009-01-01 00:00:00
4993	4993	\N	2009-01-01 00:00:00
4994	4994	\N	2009-01-01 00:00:00
4995	4995	\N	2009-01-01 00:00:00
4996	4996	\N	2009-01-01 00:00:00
4997	4997	\N	2009-01-01 00:00:00
4998	4998	\N	2009-01-01 00:00:00
4999	4999	\N	2009-01-01 00:00:00
5000	5000	\N	2009-01-01 00:00:00
5001	5001	\N	2009-01-01 00:00:00
5002	5002	\N	2009-01-01 00:00:00
5003	5003	\N	2009-01-01 00:00:00
5004	5004	\N	2009-01-01 00:00:00
5005	5005	\N	2009-01-01 00:00:00
5006	5006	\N	2009-01-01 00:00:00
5007	5007	\N	2009-01-01 00:00:00
5008	5008	\N	2009-01-01 00:00:00
5009	5009	\N	2009-01-01 00:00:00
5010	5010	\N	2009-01-01 00:00:00
5011	5011	\N	2009-01-01 00:00:00
5012	5012	\N	2009-01-01 00:00:00
5013	5013	\N	2009-01-01 00:00:00
5014	5014	\N	2009-01-01 00:00:00
5015	5015	\N	2009-01-01 00:00:00
5016	5016	\N	2009-01-01 00:00:00
5017	5017	\N	2009-01-01 00:00:00
5018	5018	\N	2009-01-01 00:00:00
5019	5019	\N	2009-01-01 00:00:00
5020	5020	\N	2009-01-01 00:00:00
5021	5021	\N	2009-01-01 00:00:00
5022	5022	\N	2009-01-01 00:00:00
5023	5023	\N	2009-01-01 00:00:00
5024	5024	\N	2009-01-01 00:00:00
5025	5025	\N	2009-01-01 00:00:00
5026	5026	\N	2009-01-01 00:00:00
5027	5027	\N	2009-01-01 00:00:00
5028	5028	\N	2009-01-01 00:00:00
5029	5029	\N	2009-01-01 00:00:00
5030	5030	\N	2009-01-01 00:00:00
5031	5031	\N	2009-01-01 00:00:00
5032	5032	\N	2009-01-01 00:00:00
5033	5033	\N	2009-01-01 00:00:00
5034	5034	\N	2009-01-01 00:00:00
5035	5035	\N	2009-01-01 00:00:00
5036	5036	\N	2009-01-01 00:00:00
5037	5037	\N	2009-01-01 00:00:00
5038	5038	\N	2009-01-01 00:00:00
5039	5039	\N	2009-01-01 00:00:00
5040	5040	\N	2009-01-01 00:00:00
5041	5041	\N	2009-01-01 00:00:00
5042	5042	\N	2009-01-01 00:00:00
5043	5043	\N	2009-01-01 00:00:00
5044	5044	\N	2009-01-01 00:00:00
5045	5045	\N	2009-01-01 00:00:00
5046	5046	\N	2009-01-01 00:00:00
5047	5047	\N	2009-01-01 00:00:00
5048	5048	\N	2009-01-01 00:00:00
5049	5049	\N	2009-01-01 00:00:00
5050	5050	\N	2009-01-01 00:00:00
5051	5051	\N	2009-01-01 00:00:00
5052	5052	\N	2009-01-01 00:00:00
5053	5053	\N	2009-01-01 00:00:00
5054	5054	\N	2009-01-01 00:00:00
5055	5055	\N	2009-01-01 00:00:00
5056	5056	\N	2009-01-01 00:00:00
5057	5057	\N	2009-01-01 00:00:00
5058	5058	\N	2009-01-01 00:00:00
5059	5059	\N	2009-01-01 00:00:00
5060	5060	\N	2009-01-01 00:00:00
5061	5061	\N	2009-01-01 00:00:00
5062	5062	\N	2009-01-01 00:00:00
5063	5063	\N	2009-01-01 00:00:00
5064	5064	\N	2009-01-01 00:00:00
5065	5065	\N	2009-01-01 00:00:00
5066	5066	\N	2009-01-01 00:00:00
5067	5067	\N	2009-01-01 00:00:00
5068	5068	\N	2009-01-01 00:00:00
5069	5069	\N	2009-01-01 00:00:00
5070	5070	\N	2009-01-01 00:00:00
5071	5071	\N	2009-01-01 00:00:00
5072	5072	\N	2009-01-01 00:00:00
5073	5073	\N	2009-01-01 00:00:00
5074	5074	\N	2009-01-01 00:00:00
5075	5075	\N	2009-01-01 00:00:00
5076	5076	\N	2009-01-01 00:00:00
5077	5077	\N	2009-01-01 00:00:00
5078	5078	\N	2009-01-01 00:00:00
5079	5079	\N	2009-01-01 00:00:00
5080	5080	\N	2009-01-01 00:00:00
5081	5081	\N	2009-01-01 00:00:00
5082	5082	\N	2009-01-01 00:00:00
5083	5083	\N	2009-01-01 00:00:00
5084	5084	\N	2009-01-01 00:00:00
5085	5085	\N	2009-01-01 00:00:00
5086	5086	\N	2009-01-01 00:00:00
5087	5087	\N	2009-01-01 00:00:00
5088	5088	\N	2009-01-01 00:00:00
5089	5089	\N	2009-01-01 00:00:00
5090	5090	\N	2009-01-01 00:00:00
5091	5091	\N	2009-01-01 00:00:00
5092	5092	\N	2009-01-01 00:00:00
5093	5093	\N	2009-01-01 00:00:00
5094	5094	\N	2009-01-01 00:00:00
5095	5095	\N	2009-01-01 00:00:00
5096	5096	\N	2009-01-01 00:00:00
5097	5097	\N	2009-01-01 00:00:00
5098	5098	\N	2009-01-01 00:00:00
5099	5099	\N	2009-01-01 00:00:00
5100	5100	\N	2009-01-01 00:00:00
5101	5101	\N	2009-01-01 00:00:00
5102	5102	\N	2009-01-01 00:00:00
5103	5103	\N	2009-01-01 00:00:00
5104	5104	\N	2009-01-01 00:00:00
5105	5105	\N	2009-01-01 00:00:00
5106	5106	\N	2009-01-01 00:00:00
5107	5107	\N	2009-01-01 00:00:00
5108	5108	\N	2009-01-01 00:00:00
5109	5109	\N	2009-01-01 00:00:00
5110	5110	\N	2009-01-01 00:00:00
5111	5111	\N	2009-01-01 00:00:00
5112	5112	\N	2009-01-01 00:00:00
5113	5113	\N	2009-01-01 00:00:00
5114	5114	\N	2009-01-01 00:00:00
5115	5115	\N	2009-01-01 00:00:00
5116	5116	\N	2009-01-01 00:00:00
5117	5117	\N	2009-01-01 00:00:00
5118	5118	\N	2009-01-01 00:00:00
5119	5119	\N	2009-01-01 00:00:00
5120	5120	\N	2009-01-01 00:00:00
5121	5121	\N	2009-01-01 00:00:00
5122	5122	\N	2009-01-01 00:00:00
5123	5123	\N	2009-01-01 00:00:00
5124	5124	\N	2009-01-01 00:00:00
5125	5125	\N	2009-01-01 00:00:00
5126	5126	\N	2009-01-01 00:00:00
5127	5127	\N	2009-01-01 00:00:00
5128	5128	\N	2009-01-01 00:00:00
5129	5129	\N	2009-01-01 00:00:00
5130	5130	\N	2009-01-01 00:00:00
5131	5131	\N	2009-01-01 00:00:00
5132	5132	\N	2009-01-01 00:00:00
5133	5133	\N	2009-01-01 00:00:00
5134	5134	\N	2009-01-01 00:00:00
5135	5135	\N	2009-01-01 00:00:00
5136	5136	\N	2009-01-01 00:00:00
5137	5137	\N	2009-01-01 00:00:00
5138	5138	\N	2009-01-01 00:00:00
5139	5139	\N	2009-01-01 00:00:00
5140	5140	\N	2009-01-01 00:00:00
5141	5141	\N	2009-01-01 00:00:00
5142	5142	\N	2009-01-01 00:00:00
5143	5143	\N	2009-01-01 00:00:00
5144	5144	\N	2009-01-01 00:00:00
5145	5145	\N	2009-01-01 00:00:00
5146	5146	\N	2009-01-01 00:00:00
5147	5147	\N	2009-01-01 00:00:00
5148	5148	\N	2009-01-01 00:00:00
5149	5149	\N	2009-01-01 00:00:00
5150	5150	\N	2009-01-01 00:00:00
5151	5151	\N	2009-01-01 00:00:00
5152	5152	\N	2009-01-01 00:00:00
5153	5153	\N	2009-01-01 00:00:00
5154	5154	\N	2009-01-01 00:00:00
5155	5155	\N	2009-01-01 00:00:00
5156	5156	\N	2009-01-01 00:00:00
5157	5157	\N	2009-01-01 00:00:00
5158	5158	\N	2009-01-01 00:00:00
5159	5159	\N	2009-01-01 00:00:00
5160	5160	\N	2009-01-01 00:00:00
5161	5161	\N	2009-01-01 00:00:00
5162	5162	\N	2009-01-01 00:00:00
5163	5163	\N	2009-01-01 00:00:00
5164	5164	\N	2009-01-01 00:00:00
5165	5165	\N	2009-01-01 00:00:00
5166	5166	\N	2009-01-01 00:00:00
5167	5167	\N	2009-01-01 00:00:00
5168	5168	\N	2009-01-01 00:00:00
5169	5169	\N	2009-01-01 00:00:00
5170	5170	\N	2009-01-01 00:00:00
5171	5171	\N	2009-01-01 00:00:00
5172	5172	\N	2009-01-01 00:00:00
5173	5173	\N	2009-01-01 00:00:00
5174	5174	\N	2009-01-01 00:00:00
5175	5175	\N	2009-01-01 00:00:00
5176	5176	\N	2009-01-01 00:00:00
5177	5177	\N	2009-01-01 00:00:00
5178	5178	\N	2009-01-01 00:00:00
5179	5179	\N	2009-01-01 00:00:00
5180	5180	\N	2009-01-01 00:00:00
5181	5181	\N	2009-01-01 00:00:00
5182	5182	\N	2009-01-01 00:00:00
5183	5183	\N	2009-01-01 00:00:00
5184	5184	\N	2009-01-01 00:00:00
5185	5185	\N	2009-01-01 00:00:00
5186	5186	\N	2009-01-01 00:00:00
5187	5187	\N	2009-01-01 00:00:00
5188	5188	\N	2009-01-01 00:00:00
5189	5189	\N	2009-01-01 00:00:00
5190	5190	\N	2009-01-01 00:00:00
5191	5191	\N	2009-01-01 00:00:00
5192	5192	\N	2009-01-01 00:00:00
5193	5193	\N	2009-01-01 00:00:00
5194	5194	\N	2009-01-01 00:00:00
5195	5195	\N	2009-01-01 00:00:00
5196	5196	\N	2009-01-01 00:00:00
5197	5197	\N	2009-01-01 00:00:00
5198	5198	\N	2009-01-01 00:00:00
5199	5199	\N	2009-01-01 00:00:00
5200	5200	\N	2009-01-01 00:00:00
5201	5201	\N	2009-01-01 00:00:00
5202	5202	\N	2009-01-01 00:00:00
5203	5203	\N	2009-01-01 00:00:00
5204	5204	\N	2009-01-01 00:00:00
5205	5205	\N	2009-01-01 00:00:00
5206	5206	\N	2009-01-01 00:00:00
5207	5207	\N	2009-01-01 00:00:00
5208	5208	\N	2009-01-01 00:00:00
5209	5209	\N	2009-01-01 00:00:00
5210	5210	\N	2009-01-01 00:00:00
5211	5211	\N	2009-01-01 00:00:00
5212	5212	\N	2009-01-01 00:00:00
5213	5213	\N	2009-01-01 00:00:00
5214	5214	\N	2009-01-01 00:00:00
5215	5215	\N	2009-01-01 00:00:00
5216	5216	\N	2009-01-01 00:00:00
5217	5217	\N	2009-01-01 00:00:00
5218	5218	\N	2009-01-01 00:00:00
5219	5219	\N	2009-01-01 00:00:00
5220	5220	\N	2009-01-01 00:00:00
5221	5221	\N	2009-01-01 00:00:00
5222	5222	\N	2009-01-01 00:00:00
5223	5223	\N	2009-01-01 00:00:00
5224	5224	\N	2009-01-01 00:00:00
5225	5225	\N	2009-01-01 00:00:00
5226	5226	\N	2009-01-01 00:00:00
5227	5227	\N	2009-01-01 00:00:00
5228	5228	\N	2009-01-01 00:00:00
5229	5229	\N	2009-01-01 00:00:00
5230	5230	\N	2009-01-01 00:00:00
5231	5231	\N	2009-01-01 00:00:00
5232	5232	\N	2009-01-01 00:00:00
5233	5233	\N	2009-01-01 00:00:00
5234	5234	\N	2009-01-01 00:00:00
5235	5235	\N	2009-01-01 00:00:00
5236	5236	\N	2009-01-01 00:00:00
5237	5237	\N	2009-01-01 00:00:00
5238	5238	\N	2009-01-01 00:00:00
5239	5239	\N	2009-01-01 00:00:00
5240	5240	\N	2009-01-01 00:00:00
5241	5241	\N	2009-01-01 00:00:00
5242	5242	\N	2009-01-01 00:00:00
5243	5243	\N	2009-01-01 00:00:00
5244	5244	\N	2009-01-01 00:00:00
5245	5245	\N	2009-01-01 00:00:00
5246	5246	\N	2009-01-01 00:00:00
5247	5247	\N	2009-01-01 00:00:00
5248	5248	\N	2009-01-01 00:00:00
5249	5249	\N	2009-01-01 00:00:00
5250	5250	\N	2009-01-01 00:00:00
5251	5251	\N	2009-01-01 00:00:00
5252	5252	\N	2009-01-01 00:00:00
5253	5253	\N	2009-01-01 00:00:00
5254	5254	\N	2009-01-01 00:00:00
5255	5255	\N	2009-01-01 00:00:00
5256	5256	\N	2009-01-01 00:00:00
5257	5257	\N	2009-01-01 00:00:00
5258	5258	\N	2009-01-01 00:00:00
5259	5259	\N	2009-01-01 00:00:00
5260	5260	\N	2009-01-01 00:00:00
5261	5261	\N	2009-01-01 00:00:00
5262	5262	\N	2009-01-01 00:00:00
5263	5263	\N	2009-01-01 00:00:00
5264	5264	\N	2009-01-01 00:00:00
5265	5265	\N	2009-01-01 00:00:00
5266	5266	\N	2009-01-01 00:00:00
5267	5267	\N	2009-01-01 00:00:00
5268	5268	\N	2009-01-01 00:00:00
5269	5269	\N	2009-01-01 00:00:00
5270	5270	\N	2009-01-01 00:00:00
5271	5271	\N	2009-01-01 00:00:00
5272	5272	\N	2009-01-01 00:00:00
5273	5273	\N	2009-01-01 00:00:00
5274	5274	\N	2009-01-01 00:00:00
5275	5275	\N	2009-01-01 00:00:00
5276	5276	\N	2009-01-01 00:00:00
5277	5277	\N	2009-01-01 00:00:00
5278	5278	\N	2009-01-01 00:00:00
5279	5279	\N	2009-01-01 00:00:00
5280	5280	\N	2009-01-01 00:00:00
5281	5281	\N	2009-01-01 00:00:00
5282	5282	\N	2009-01-01 00:00:00
5283	5283	\N	2009-01-01 00:00:00
5284	5284	\N	2009-01-01 00:00:00
5285	5285	\N	2009-01-01 00:00:00
5286	5286	\N	2009-01-01 00:00:00
5287	5287	\N	2009-01-01 00:00:00
5288	5288	\N	2009-01-01 00:00:00
5289	5289	\N	2009-01-01 00:00:00
5290	5290	\N	2009-01-01 00:00:00
5291	5291	\N	2009-01-01 00:00:00
5292	5292	\N	2009-01-01 00:00:00
5293	5293	\N	2009-01-01 00:00:00
5294	5294	\N	2009-01-01 00:00:00
5295	5295	\N	2009-01-01 00:00:00
5296	5296	\N	2009-01-01 00:00:00
5297	5297	\N	2009-01-01 00:00:00
5298	5298	\N	2009-01-01 00:00:00
5299	5299	\N	2009-01-01 00:00:00
5300	5300	\N	2009-01-01 00:00:00
5301	5301	\N	2009-01-01 00:00:00
5302	5302	\N	2009-01-01 00:00:00
5303	5303	\N	2009-01-01 00:00:00
5304	5304	\N	2009-01-01 00:00:00
5305	5305	\N	2009-01-01 00:00:00
5306	5306	\N	2009-01-01 00:00:00
5307	5307	\N	2009-01-01 00:00:00
5308	5308	\N	2009-01-01 00:00:00
5309	5309	\N	2009-01-01 00:00:00
5310	5310	\N	2009-01-01 00:00:00
5311	5311	\N	2009-01-01 00:00:00
5312	5312	\N	2009-01-01 00:00:00
5313	5313	\N	2009-01-01 00:00:00
5314	5314	\N	2009-01-01 00:00:00
5315	5315	\N	2009-01-01 00:00:00
5316	5316	\N	2009-01-01 00:00:00
5317	5317	\N	2009-01-01 00:00:00
5318	5318	\N	2009-01-01 00:00:00
5319	5319	\N	2009-01-01 00:00:00
5320	5320	\N	2009-01-01 00:00:00
5321	5321	\N	2009-01-01 00:00:00
5322	5322	\N	2009-01-01 00:00:00
5323	5323	\N	2009-01-01 00:00:00
5324	5324	\N	2009-01-01 00:00:00
5325	5325	\N	2009-01-01 00:00:00
5326	5326	\N	2009-01-01 00:00:00
5327	5327	\N	2009-01-01 00:00:00
5328	5328	\N	2009-01-01 00:00:00
5329	5329	\N	2009-01-01 00:00:00
5330	5330	\N	2009-01-01 00:00:00
5331	5331	\N	2009-01-01 00:00:00
5332	5332	\N	2009-01-01 00:00:00
5333	5333	\N	2009-01-01 00:00:00
5334	5334	\N	2009-01-01 00:00:00
5335	5335	\N	2009-01-01 00:00:00
5336	5336	\N	2009-01-01 00:00:00
5337	5337	\N	2009-01-01 00:00:00
5338	5338	\N	2009-01-01 00:00:00
5339	5339	\N	2009-01-01 00:00:00
5340	5340	\N	2009-01-01 00:00:00
5341	5341	\N	2009-01-01 00:00:00
5342	5342	\N	2009-01-01 00:00:00
5343	5343	\N	2009-01-01 00:00:00
5344	5344	\N	2009-01-01 00:00:00
5345	5345	\N	2009-01-01 00:00:00
5346	5346	\N	2009-01-01 00:00:00
5347	5347	\N	2009-01-01 00:00:00
5348	5348	\N	2009-01-01 00:00:00
5349	5349	\N	2009-01-01 00:00:00
5350	5350	\N	2009-01-01 00:00:00
5351	5351	\N	2009-01-01 00:00:00
5352	5352	\N	2009-01-01 00:00:00
5353	5353	\N	2009-01-01 00:00:00
5354	5354	\N	2009-01-01 00:00:00
5355	5355	\N	2009-01-01 00:00:00
5356	5356	\N	2009-01-01 00:00:00
5357	5357	\N	2009-01-01 00:00:00
5358	5358	\N	2009-01-01 00:00:00
5359	5359	\N	2009-01-01 00:00:00
5360	5360	\N	2009-01-01 00:00:00
5361	5361	\N	2009-01-01 00:00:00
5362	5362	\N	2009-01-01 00:00:00
5363	5363	\N	2009-01-01 00:00:00
5364	5364	\N	2009-01-01 00:00:00
5365	5365	\N	2009-01-01 00:00:00
5366	5366	\N	2009-01-01 00:00:00
5367	5367	\N	2009-01-01 00:00:00
5368	5368	\N	2009-01-01 00:00:00
5369	5369	\N	2009-01-01 00:00:00
5370	5370	\N	2009-01-01 00:00:00
5371	5371	\N	2009-01-01 00:00:00
5372	5372	\N	2009-01-01 00:00:00
5373	5373	\N	2009-01-01 00:00:00
5374	5374	\N	2009-01-01 00:00:00
5375	5375	\N	2009-01-01 00:00:00
5376	5376	\N	2009-01-01 00:00:00
5377	5377	\N	2009-01-01 00:00:00
5378	5378	\N	2009-01-01 00:00:00
5379	5379	\N	2009-01-01 00:00:00
5380	5380	\N	2009-01-01 00:00:00
5381	5381	\N	2009-01-01 00:00:00
5382	5382	\N	2009-01-01 00:00:00
5383	5383	\N	2009-01-01 00:00:00
5384	5384	\N	2009-01-01 00:00:00
5385	5385	\N	2009-01-01 00:00:00
5386	5386	\N	2009-01-01 00:00:00
5387	5387	\N	2009-01-01 00:00:00
5388	5388	\N	2009-01-01 00:00:00
5389	5389	\N	2009-01-01 00:00:00
5390	5390	\N	2009-01-01 00:00:00
5391	5391	\N	2009-01-01 00:00:00
5392	5392	\N	2009-01-01 00:00:00
5393	5393	\N	2009-01-01 00:00:00
5394	5394	\N	2009-01-01 00:00:00
5395	5395	\N	2009-01-01 00:00:00
5396	5396	\N	2009-01-01 00:00:00
5397	5397	\N	2009-01-01 00:00:00
5398	5398	\N	2009-01-01 00:00:00
5399	5399	\N	2009-01-01 00:00:00
5400	5400	\N	2009-01-01 00:00:00
5401	5401	\N	2009-01-01 00:00:00
5402	5402	\N	2009-01-01 00:00:00
5403	5403	\N	2009-01-01 00:00:00
5404	5404	\N	2009-01-01 00:00:00
5405	5405	\N	2009-01-01 00:00:00
5406	5406	\N	2009-01-01 00:00:00
5407	5407	\N	2009-01-01 00:00:00
5408	5408	\N	2009-01-01 00:00:00
5409	5409	\N	2009-01-01 00:00:00
5410	5410	\N	2009-01-01 00:00:00
5411	5411	\N	2009-01-01 00:00:00
5412	5412	\N	2009-01-01 00:00:00
5413	5413	\N	2009-01-01 00:00:00
5414	5414	\N	2009-01-01 00:00:00
5415	5415	\N	2009-01-01 00:00:00
5416	5416	\N	2009-01-01 00:00:00
5417	5417	\N	2009-01-01 00:00:00
5418	5418	\N	2009-01-01 00:00:00
5419	5419	\N	2009-01-01 00:00:00
5420	5420	\N	2009-01-01 00:00:00
5421	5421	\N	2009-01-01 00:00:00
5422	5422	\N	2009-01-01 00:00:00
5423	5423	\N	2009-01-01 00:00:00
5424	5424	\N	2009-01-01 00:00:00
5425	5425	\N	2009-01-01 00:00:00
5426	5426	\N	2009-01-01 00:00:00
5427	5427	\N	2009-01-01 00:00:00
5428	5428	\N	2009-01-01 00:00:00
5429	5429	\N	2009-01-01 00:00:00
5430	5430	\N	2009-01-01 00:00:00
5431	5431	\N	2009-01-01 00:00:00
5432	5432	\N	2009-01-01 00:00:00
5433	5433	\N	2009-01-01 00:00:00
5434	5434	\N	2009-01-01 00:00:00
5435	5435	\N	2009-01-01 00:00:00
5436	5436	\N	2009-01-01 00:00:00
5437	5437	\N	2009-01-01 00:00:00
5438	5438	\N	2009-01-01 00:00:00
5439	5439	\N	2009-01-01 00:00:00
5440	5440	\N	2009-01-01 00:00:00
5441	5441	\N	2009-01-01 00:00:00
5442	5442	\N	2009-01-01 00:00:00
5443	5443	\N	2009-01-01 00:00:00
5444	5444	\N	2009-01-01 00:00:00
5445	5445	\N	2009-01-01 00:00:00
5446	5446	\N	2009-01-01 00:00:00
5447	5447	\N	2009-01-01 00:00:00
5448	5448	\N	2009-01-01 00:00:00
5449	5449	\N	2009-01-01 00:00:00
5450	5450	\N	2009-01-01 00:00:00
5451	5451	\N	2009-01-01 00:00:00
5452	5452	\N	2009-01-01 00:00:00
5453	5453	\N	2009-01-01 00:00:00
5454	5454	\N	2009-01-01 00:00:00
5455	5455	\N	2009-01-01 00:00:00
5456	5456	\N	2009-01-01 00:00:00
5457	5457	\N	2009-01-01 00:00:00
5458	5458	\N	2009-01-01 00:00:00
5459	5459	\N	2009-01-01 00:00:00
5460	5460	\N	2009-01-01 00:00:00
5461	5461	\N	2009-01-01 00:00:00
5462	5462	\N	2009-01-01 00:00:00
5463	5463	\N	2009-01-01 00:00:00
5464	5464	\N	2009-01-01 00:00:00
5465	5465	\N	2009-01-01 00:00:00
5466	5466	\N	2009-01-01 00:00:00
5467	5467	\N	2009-01-01 00:00:00
5468	5468	\N	2009-01-01 00:00:00
5469	5469	\N	2009-01-01 00:00:00
5470	5470	\N	2009-01-01 00:00:00
5471	5471	\N	2009-01-01 00:00:00
5472	5472	\N	2009-01-01 00:00:00
5473	5473	\N	2009-01-01 00:00:00
5474	5474	\N	2009-01-01 00:00:00
5475	5475	\N	2009-01-01 00:00:00
5476	5476	\N	2009-01-01 00:00:00
5477	5477	\N	2009-01-01 00:00:00
5478	5478	\N	2009-01-01 00:00:00
5479	5479	\N	2009-01-01 00:00:00
5480	5480	\N	2009-01-01 00:00:00
5481	5481	\N	2009-01-01 00:00:00
5482	5482	\N	2009-01-01 00:00:00
5483	5483	\N	2009-01-01 00:00:00
5484	5484	\N	2009-01-01 00:00:00
5485	5485	\N	2009-01-01 00:00:00
5486	5486	\N	2009-01-01 00:00:00
5487	5487	\N	2009-01-01 00:00:00
5488	5488	\N	2009-01-01 00:00:00
5489	5489	\N	2009-01-01 00:00:00
5490	5490	\N	2009-01-01 00:00:00
5491	5491	\N	2009-01-01 00:00:00
5492	5492	\N	2009-01-01 00:00:00
5493	5493	\N	2009-01-01 00:00:00
5494	5494	\N	2009-01-01 00:00:00
5495	5495	\N	2009-01-01 00:00:00
5496	5496	\N	2009-01-01 00:00:00
5497	5497	\N	2009-01-01 00:00:00
5498	5498	\N	2009-01-01 00:00:00
5499	5499	\N	2009-01-01 00:00:00
5500	5500	\N	2009-01-01 00:00:00
5501	5501	\N	2009-01-01 00:00:00
5502	5502	\N	2009-01-01 00:00:00
5503	5503	\N	2009-01-01 00:00:00
5504	5504	\N	2009-01-01 00:00:00
5505	5505	\N	2009-01-01 00:00:00
5506	5506	\N	2009-01-01 00:00:00
5507	5507	\N	2009-01-01 00:00:00
5508	5508	\N	2009-01-01 00:00:00
5509	5509	\N	2009-01-01 00:00:00
5510	5510	\N	2009-01-01 00:00:00
5511	5511	\N	2009-01-01 00:00:00
5512	5512	\N	2009-01-01 00:00:00
5513	5513	\N	2009-01-01 00:00:00
5514	5514	\N	2009-01-01 00:00:00
5515	5515	\N	2009-01-01 00:00:00
5516	5516	\N	2009-01-01 00:00:00
5517	5517	\N	2009-01-01 00:00:00
5518	5518	\N	2009-01-01 00:00:00
5519	5519	\N	2009-01-01 00:00:00
5520	5520	\N	2009-01-01 00:00:00
5521	5521	\N	2009-01-01 00:00:00
5522	5522	\N	2009-01-01 00:00:00
5523	5523	\N	2009-01-01 00:00:00
5524	5524	\N	2009-01-01 00:00:00
5525	5525	\N	2009-01-01 00:00:00
5526	5526	\N	2009-01-01 00:00:00
5527	5527	\N	2009-01-01 00:00:00
5528	5528	\N	2009-01-01 00:00:00
5529	5529	\N	2009-01-01 00:00:00
5530	5530	\N	2009-01-01 00:00:00
5531	5531	\N	2009-01-01 00:00:00
5532	5532	\N	2009-01-01 00:00:00
5533	5533	\N	2009-01-01 00:00:00
5534	5534	\N	2009-01-01 00:00:00
5535	5535	\N	2009-01-01 00:00:00
5536	5536	\N	2009-01-01 00:00:00
5537	5537	\N	2009-01-01 00:00:00
5538	5538	\N	2009-01-01 00:00:00
5539	5539	\N	2009-01-01 00:00:00
5540	5540	\N	2009-01-01 00:00:00
5541	5541	\N	2009-01-01 00:00:00
5542	5542	\N	2009-01-01 00:00:00
5543	5543	\N	2009-01-01 00:00:00
5544	5544	\N	2009-01-01 00:00:00
5545	5545	\N	2009-01-01 00:00:00
5546	5546	\N	2009-01-01 00:00:00
5547	5547	\N	2009-01-01 00:00:00
5548	5548	\N	2009-01-01 00:00:00
5549	5549	\N	2009-01-01 00:00:00
5550	5550	\N	2009-01-01 00:00:00
5551	5551	\N	2009-01-01 00:00:00
5552	5552	\N	2009-01-01 00:00:00
5553	5553	\N	2009-01-01 00:00:00
5554	5554	\N	2009-01-01 00:00:00
5555	5555	\N	2009-01-01 00:00:00
5556	5556	\N	2009-01-01 00:00:00
5557	5557	\N	2009-01-01 00:00:00
5558	5558	\N	2009-01-01 00:00:00
5559	5559	\N	2009-01-01 00:00:00
5560	5560	\N	2009-01-01 00:00:00
5561	5561	\N	2009-01-01 00:00:00
5562	5562	\N	2009-01-01 00:00:00
5563	5563	\N	2009-01-01 00:00:00
5564	5564	\N	2009-01-01 00:00:00
5565	5565	\N	2009-01-01 00:00:00
5566	5566	\N	2009-01-01 00:00:00
5567	5567	\N	2009-01-01 00:00:00
5568	5568	\N	2009-01-01 00:00:00
5569	5569	\N	2009-01-01 00:00:00
5570	5570	\N	2009-01-01 00:00:00
5571	5571	\N	2009-01-01 00:00:00
5572	5572	\N	2009-01-01 00:00:00
5573	5573	\N	2009-01-01 00:00:00
5574	5574	\N	2009-01-01 00:00:00
5575	5575	\N	2009-01-01 00:00:00
5576	5576	\N	2009-01-01 00:00:00
5577	5577	\N	2009-01-01 00:00:00
5578	5578	\N	2009-01-01 00:00:00
5579	5579	\N	2009-01-01 00:00:00
5580	5580	\N	2009-01-01 00:00:00
5581	5581	\N	2009-01-01 00:00:00
5582	5582	\N	2009-01-01 00:00:00
5583	5583	\N	2009-01-01 00:00:00
5584	5584	\N	2009-01-01 00:00:00
5585	5585	\N	2009-01-01 00:00:00
5586	5586	\N	2009-01-01 00:00:00
5587	5587	\N	2009-01-01 00:00:00
5588	5588	\N	2009-01-01 00:00:00
5589	5589	\N	2009-01-01 00:00:00
5590	5590	\N	2009-01-01 00:00:00
5591	5591	\N	2009-01-01 00:00:00
5592	5592	\N	2009-01-01 00:00:00
5593	5593	\N	2009-01-01 00:00:00
5594	5594	\N	2009-01-01 00:00:00
5595	5595	\N	2009-01-01 00:00:00
5596	5596	\N	2009-01-01 00:00:00
5597	5597	\N	2009-01-01 00:00:00
5598	5598	\N	2009-01-01 00:00:00
5599	5599	\N	2009-01-01 00:00:00
5600	5600	\N	2009-01-01 00:00:00
5601	5601	\N	2009-01-01 00:00:00
5602	5602	\N	2009-01-01 00:00:00
5603	5603	\N	2009-01-01 00:00:00
5604	5604	\N	2009-01-01 00:00:00
5605	5605	\N	2009-01-01 00:00:00
5606	5606	\N	2009-01-01 00:00:00
5607	5607	\N	2009-01-01 00:00:00
5608	5608	\N	2009-01-01 00:00:00
5609	5609	\N	2009-01-01 00:00:00
5610	5610	\N	2009-01-01 00:00:00
5611	5611	\N	2009-01-01 00:00:00
5612	5612	\N	2009-01-01 00:00:00
5613	5613	\N	2009-01-01 00:00:00
5614	5614	\N	2009-01-01 00:00:00
5615	5615	\N	2009-01-01 00:00:00
5616	5616	\N	2009-01-01 00:00:00
5617	5617	\N	2009-01-01 00:00:00
5618	5618	\N	2009-01-01 00:00:00
5619	5619	\N	2009-01-01 00:00:00
5620	5620	\N	2009-01-01 00:00:00
5621	5621	\N	2009-01-01 00:00:00
5622	5622	\N	2009-01-01 00:00:00
5623	5623	\N	2009-01-01 00:00:00
5624	5624	\N	2009-01-01 00:00:00
5625	5625	\N	2009-01-01 00:00:00
5626	5626	\N	2009-01-01 00:00:00
5627	5627	\N	2009-01-01 00:00:00
5628	5628	\N	2009-01-01 00:00:00
5629	5629	\N	2009-01-01 00:00:00
5630	5630	\N	2009-01-01 00:00:00
5631	5631	\N	2009-01-01 00:00:00
5632	5632	\N	2009-01-01 00:00:00
5633	5633	\N	2009-01-01 00:00:00
5634	5634	\N	2009-01-01 00:00:00
5635	5635	\N	2009-01-01 00:00:00
5636	5636	\N	2009-01-01 00:00:00
5637	5637	\N	2009-01-01 00:00:00
5638	5638	\N	2009-01-01 00:00:00
5639	5639	\N	2009-01-01 00:00:00
5640	5640	\N	2009-01-01 00:00:00
5641	5641	\N	2009-01-01 00:00:00
5642	5642	\N	2009-01-01 00:00:00
5643	5643	\N	2009-01-01 00:00:00
5644	5644	\N	2009-01-01 00:00:00
5645	5645	\N	2009-01-01 00:00:00
5646	5646	\N	2009-01-01 00:00:00
5647	5647	\N	2009-01-01 00:00:00
5648	5648	\N	2009-01-01 00:00:00
5649	5649	\N	2009-01-01 00:00:00
5650	5650	\N	2009-01-01 00:00:00
5651	5651	\N	2009-01-01 00:00:00
5652	5652	\N	2009-01-01 00:00:00
5653	5653	\N	2009-01-01 00:00:00
5654	5654	\N	2009-01-01 00:00:00
5655	5655	\N	2009-01-01 00:00:00
5656	5656	\N	2009-01-01 00:00:00
5657	5657	\N	2009-01-01 00:00:00
5658	5658	\N	2009-01-01 00:00:00
5659	5659	\N	2009-01-01 00:00:00
5660	5660	\N	2009-01-01 00:00:00
5661	5661	\N	2009-01-01 00:00:00
5662	5662	\N	2009-01-01 00:00:00
5663	5663	\N	2009-01-01 00:00:00
5664	5664	\N	2009-01-01 00:00:00
5665	5665	\N	2009-01-01 00:00:00
5666	5666	\N	2009-01-01 00:00:00
5667	5667	\N	2009-01-01 00:00:00
5668	5668	\N	2009-01-01 00:00:00
5669	5669	\N	2009-01-01 00:00:00
5670	5670	\N	2009-01-01 00:00:00
5671	5671	\N	2009-01-01 00:00:00
5672	5672	\N	2009-01-01 00:00:00
5673	5673	\N	2009-01-01 00:00:00
5674	5674	\N	2009-01-01 00:00:00
5675	5675	\N	2009-01-01 00:00:00
5676	5676	\N	2009-01-01 00:00:00
5677	5677	\N	2009-01-01 00:00:00
5678	5678	\N	2009-01-01 00:00:00
5679	5679	\N	2009-01-01 00:00:00
5680	5680	\N	2009-01-01 00:00:00
5681	5681	\N	2009-01-01 00:00:00
5682	5682	\N	2009-01-01 00:00:00
5683	5683	\N	2009-01-01 00:00:00
5684	5684	\N	2009-01-01 00:00:00
5685	5685	\N	2009-01-01 00:00:00
5686	5686	\N	2009-01-01 00:00:00
5687	5687	\N	2009-01-01 00:00:00
5688	5688	\N	2009-01-01 00:00:00
5689	5689	\N	2009-01-01 00:00:00
5690	5690	\N	2009-01-01 00:00:00
5691	5691	\N	2009-01-01 00:00:00
5692	5692	\N	2009-01-01 00:00:00
5693	5693	\N	2009-01-01 00:00:00
5694	5694	\N	2009-01-01 00:00:00
5695	5695	\N	2009-01-01 00:00:00
5696	5696	\N	2009-01-01 00:00:00
5697	5697	\N	2009-01-01 00:00:00
5698	5698	\N	2009-01-01 00:00:00
5699	5699	\N	2009-01-01 00:00:00
5700	5700	\N	2009-01-01 00:00:00
5701	5701	\N	2009-01-01 00:00:00
5702	5702	\N	2009-01-01 00:00:00
5703	5703	\N	2009-01-01 00:00:00
5704	5704	\N	2009-01-01 00:00:00
5705	5705	\N	2009-01-01 00:00:00
5706	5706	\N	2009-01-01 00:00:00
5707	5707	\N	2009-01-01 00:00:00
5708	5708	\N	2009-01-01 00:00:00
5709	5709	\N	2009-01-01 00:00:00
5710	5710	\N	2009-01-01 00:00:00
5711	5711	\N	2009-01-01 00:00:00
5712	5712	\N	2009-01-01 00:00:00
5713	5713	\N	2009-01-01 00:00:00
5714	5714	\N	2009-01-01 00:00:00
5715	5715	\N	2009-01-01 00:00:00
5716	5716	\N	2009-01-01 00:00:00
5717	5717	\N	2009-01-01 00:00:00
5718	5718	\N	2009-01-01 00:00:00
5719	5719	\N	2009-01-01 00:00:00
5720	5720	\N	2009-01-01 00:00:00
5721	5721	\N	2009-01-01 00:00:00
5722	5722	\N	2009-01-01 00:00:00
5723	5723	\N	2009-01-01 00:00:00
5724	5724	\N	2009-01-01 00:00:00
5725	5725	\N	2009-01-01 00:00:00
5726	5726	\N	2009-01-01 00:00:00
5727	5727	\N	2009-01-01 00:00:00
5728	5728	\N	2009-01-01 00:00:00
5729	5729	\N	2009-01-01 00:00:00
5730	5730	\N	2009-01-01 00:00:00
5731	5731	\N	2009-01-01 00:00:00
5732	5732	\N	2009-01-01 00:00:00
5733	5733	\N	2009-01-01 00:00:00
5734	5734	\N	2009-01-01 00:00:00
5735	5735	\N	2009-01-01 00:00:00
5736	5736	\N	2009-01-01 00:00:00
5737	5737	\N	2009-01-01 00:00:00
5738	5738	\N	2009-01-01 00:00:00
5739	5739	\N	2009-01-01 00:00:00
5740	5740	\N	2009-01-01 00:00:00
5741	5741	\N	2009-01-01 00:00:00
5742	5742	\N	2009-01-01 00:00:00
5743	5743	\N	2009-01-01 00:00:00
5744	5744	\N	2009-01-01 00:00:00
5745	5745	\N	2009-01-01 00:00:00
5746	5746	\N	2009-01-01 00:00:00
5747	5747	\N	2009-01-01 00:00:00
5748	5748	\N	2009-01-01 00:00:00
5749	5749	\N	2009-01-01 00:00:00
5750	5750	\N	2009-01-01 00:00:00
5751	5751	\N	2009-01-01 00:00:00
5752	5752	\N	2009-01-01 00:00:00
5753	5753	\N	2009-01-01 00:00:00
5754	5754	\N	2009-01-01 00:00:00
5755	5755	\N	2009-01-01 00:00:00
5756	5756	\N	2009-01-01 00:00:00
5757	5757	\N	2009-01-01 00:00:00
5758	5758	\N	2009-01-01 00:00:00
5759	5759	\N	2009-01-01 00:00:00
5760	5760	\N	2009-01-01 00:00:00
5761	5761	\N	2009-01-01 00:00:00
5762	5762	\N	2009-01-01 00:00:00
5763	5763	\N	2009-01-01 00:00:00
5764	5764	\N	2009-01-01 00:00:00
5765	5765	\N	2009-01-01 00:00:00
5766	5766	\N	2009-01-01 00:00:00
5767	5767	\N	2009-01-01 00:00:00
5768	5768	\N	2009-01-01 00:00:00
5769	5769	\N	2009-01-01 00:00:00
5770	5770	\N	2009-01-01 00:00:00
5771	5771	\N	2009-01-01 00:00:00
5772	5772	\N	2009-01-01 00:00:00
5773	5773	\N	2009-01-01 00:00:00
5774	5774	\N	2009-01-01 00:00:00
5775	5775	\N	2009-01-01 00:00:00
5776	5776	\N	2009-01-01 00:00:00
5777	5777	\N	2009-01-01 00:00:00
5778	5778	\N	2009-01-01 00:00:00
5779	5779	\N	2009-01-01 00:00:00
5780	5780	\N	2009-01-01 00:00:00
5781	5781	\N	2009-01-01 00:00:00
5782	5782	\N	2009-01-01 00:00:00
5783	5783	\N	2009-01-01 00:00:00
5784	5784	\N	2009-01-01 00:00:00
5785	5785	\N	2009-01-01 00:00:00
5786	5786	\N	2009-01-01 00:00:00
5787	5787	\N	2009-01-01 00:00:00
5788	5788	\N	2009-01-01 00:00:00
5789	5789	\N	2009-01-01 00:00:00
5790	5790	\N	2009-01-01 00:00:00
5791	5791	\N	2009-01-01 00:00:00
5792	5792	\N	2009-01-01 00:00:00
5793	5793	\N	2009-01-01 00:00:00
5794	5794	\N	2009-01-01 00:00:00
5795	5795	\N	2009-01-01 00:00:00
5796	5796	\N	2009-01-01 00:00:00
5797	5797	\N	2009-01-01 00:00:00
5798	5798	\N	2009-01-01 00:00:00
5799	5799	\N	2009-01-01 00:00:00
5800	5800	\N	2009-01-01 00:00:00
5801	5801	\N	2009-01-01 00:00:00
5802	5802	\N	2009-01-01 00:00:00
5803	5803	\N	2009-01-01 00:00:00
5804	5804	\N	2009-01-01 00:00:00
5805	5805	\N	2009-01-01 00:00:00
5806	5806	\N	2009-01-01 00:00:00
5807	5807	\N	2009-01-01 00:00:00
5808	5808	\N	2009-01-01 00:00:00
5809	5809	\N	2009-01-01 00:00:00
5810	5810	\N	2009-01-01 00:00:00
5811	5811	\N	2009-01-01 00:00:00
5812	5812	\N	2009-01-01 00:00:00
5813	5813	\N	2009-01-01 00:00:00
5814	5814	\N	2009-01-01 00:00:00
5815	5815	\N	2009-01-01 00:00:00
5816	5816	\N	2009-01-01 00:00:00
5817	5817	\N	2009-01-01 00:00:00
5818	5818	\N	2009-01-01 00:00:00
5819	5819	\N	2009-01-01 00:00:00
5820	5820	\N	2009-01-01 00:00:00
5821	5821	\N	2009-01-01 00:00:00
5822	5822	\N	2009-01-01 00:00:00
5823	5823	\N	2009-01-01 00:00:00
5824	5824	\N	2009-01-01 00:00:00
5825	5825	\N	2009-01-01 00:00:00
5826	5826	\N	2009-01-01 00:00:00
5827	5827	\N	2009-01-01 00:00:00
5828	5828	\N	2009-01-01 00:00:00
5829	5829	\N	2009-01-01 00:00:00
5830	5830	\N	2009-01-01 00:00:00
5831	5831	\N	2009-01-01 00:00:00
5832	5832	\N	2009-01-01 00:00:00
5833	5833	\N	2009-01-01 00:00:00
5834	5834	\N	2009-01-01 00:00:00
5835	5835	\N	2009-01-01 00:00:00
5836	5836	\N	2009-01-01 00:00:00
5837	5837	\N	2009-01-01 00:00:00
5838	5838	\N	2009-01-01 00:00:00
5839	5839	\N	2009-01-01 00:00:00
5840	5840	\N	2009-01-01 00:00:00
5841	5841	\N	2009-01-01 00:00:00
5842	5842	\N	2009-01-01 00:00:00
5843	5843	\N	2009-01-01 00:00:00
5844	5844	\N	2009-01-01 00:00:00
5845	5845	\N	2009-01-01 00:00:00
5846	5846	\N	2009-01-01 00:00:00
5847	5847	\N	2009-01-01 00:00:00
5848	5848	\N	2009-01-01 00:00:00
5849	5849	\N	2009-01-01 00:00:00
5850	5850	\N	2009-01-01 00:00:00
5851	5851	\N	2009-01-01 00:00:00
5852	5852	\N	2009-01-01 00:00:00
5853	5853	\N	2009-01-01 00:00:00
5854	5854	\N	2009-01-01 00:00:00
5855	5855	\N	2009-01-01 00:00:00
5856	5856	\N	2009-01-01 00:00:00
5857	5857	\N	2009-01-01 00:00:00
5858	5858	\N	2009-01-01 00:00:00
5859	5859	\N	2009-01-01 00:00:00
5860	5860	\N	2009-01-01 00:00:00
5861	5861	\N	2009-01-01 00:00:00
5862	5862	\N	2009-01-01 00:00:00
5863	5863	\N	2009-01-01 00:00:00
5864	5864	\N	2009-01-01 00:00:00
5865	5865	\N	2009-01-01 00:00:00
5866	5866	\N	2009-01-01 00:00:00
5867	5867	\N	2009-01-01 00:00:00
5868	5868	\N	2009-01-01 00:00:00
5869	5869	\N	2009-01-01 00:00:00
5870	5870	\N	2009-01-01 00:00:00
5871	5871	\N	2009-01-01 00:00:00
5872	5872	\N	2009-01-01 00:00:00
5873	5873	\N	2009-01-01 00:00:00
5874	5874	\N	2009-01-01 00:00:00
5875	5875	\N	2009-01-01 00:00:00
5876	5876	\N	2009-01-01 00:00:00
5877	5877	\N	2009-01-01 00:00:00
5878	5878	\N	2009-01-01 00:00:00
5879	5879	\N	2009-01-01 00:00:00
5880	5880	\N	2009-01-01 00:00:00
5881	5881	\N	2009-01-01 00:00:00
5882	5882	\N	2009-01-01 00:00:00
5883	5883	\N	2009-01-01 00:00:00
5884	5884	\N	2009-01-01 00:00:00
5885	5885	\N	2009-01-01 00:00:00
5886	5886	\N	2009-01-01 00:00:00
5887	5887	\N	2009-01-01 00:00:00
5888	5888	\N	2009-01-01 00:00:00
5889	5889	\N	2009-01-01 00:00:00
5890	5890	\N	2009-01-01 00:00:00
5891	5891	\N	2009-01-01 00:00:00
5892	5892	\N	2009-01-01 00:00:00
5893	5893	\N	2009-01-01 00:00:00
5894	5894	\N	2009-01-01 00:00:00
5895	5895	\N	2009-01-01 00:00:00
5896	5896	\N	2009-01-01 00:00:00
5897	5897	\N	2009-01-01 00:00:00
5898	5898	\N	2009-01-01 00:00:00
5899	5899	\N	2009-01-01 00:00:00
5900	5900	\N	2009-01-01 00:00:00
5901	5901	\N	2009-01-01 00:00:00
5902	5902	\N	2009-01-01 00:00:00
5903	5903	\N	2009-01-01 00:00:00
5904	5904	\N	2009-01-01 00:00:00
5905	5905	\N	2009-01-01 00:00:00
5906	5906	\N	2009-01-01 00:00:00
5907	5907	\N	2009-01-01 00:00:00
5908	5908	\N	2009-01-01 00:00:00
5909	5909	\N	2009-01-01 00:00:00
5910	5910	\N	2009-01-01 00:00:00
5911	5911	\N	2009-01-01 00:00:00
5912	5912	\N	2009-01-01 00:00:00
5913	5913	\N	2009-01-01 00:00:00
5914	5914	\N	2009-01-01 00:00:00
5915	5915	\N	2009-01-01 00:00:00
5916	5916	\N	2009-01-01 00:00:00
5917	5917	\N	2009-01-01 00:00:00
5918	5918	\N	2009-01-01 00:00:00
5919	5919	\N	2009-01-01 00:00:00
5920	5920	\N	2009-01-01 00:00:00
5921	5921	\N	2009-01-01 00:00:00
5922	5922	\N	2009-01-01 00:00:00
5923	5923	\N	2009-01-01 00:00:00
5924	5924	\N	2009-01-01 00:00:00
5925	5925	\N	2009-01-01 00:00:00
5926	5926	\N	2009-01-01 00:00:00
5927	5927	\N	2009-01-01 00:00:00
5928	5928	\N	2009-01-01 00:00:00
5929	5929	\N	2009-01-01 00:00:00
5930	5930	\N	2009-01-01 00:00:00
5931	5931	\N	2009-01-01 00:00:00
5932	5932	\N	2009-01-01 00:00:00
5933	5933	\N	2009-01-01 00:00:00
5934	5934	\N	2009-01-01 00:00:00
5935	5935	\N	2009-01-01 00:00:00
5936	5936	\N	2009-01-01 00:00:00
5937	5937	\N	2009-01-01 00:00:00
5938	5938	\N	2009-01-01 00:00:00
5939	5939	\N	2009-01-01 00:00:00
5940	5940	\N	2009-01-01 00:00:00
5941	5941	\N	2009-01-01 00:00:00
5942	5942	\N	2009-01-01 00:00:00
5943	5943	\N	2009-01-01 00:00:00
5944	5944	\N	2009-01-01 00:00:00
5945	5945	\N	2009-01-01 00:00:00
5946	5946	\N	2009-01-01 00:00:00
5947	5947	\N	2009-01-01 00:00:00
5948	5948	\N	2009-01-01 00:00:00
5949	5949	\N	2009-01-01 00:00:00
5950	5950	\N	2009-01-01 00:00:00
5951	5951	\N	2009-01-01 00:00:00
5952	5952	\N	2009-01-01 00:00:00
5953	5953	\N	2009-01-01 00:00:00
5954	5954	\N	2009-01-01 00:00:00
5955	5955	\N	2009-01-01 00:00:00
5956	5956	\N	2009-01-01 00:00:00
5957	5957	\N	2009-01-01 00:00:00
5958	5958	\N	2009-01-01 00:00:00
5959	5959	\N	2009-01-01 00:00:00
5960	5960	\N	2009-01-01 00:00:00
5961	5961	\N	2009-01-01 00:00:00
5962	5962	\N	2009-01-01 00:00:00
5963	5963	\N	2009-01-01 00:00:00
5964	5964	\N	2009-01-01 00:00:00
5965	5965	\N	2009-01-01 00:00:00
5966	5966	\N	2009-01-01 00:00:00
5967	5967	\N	2009-01-01 00:00:00
5968	5968	\N	2009-01-01 00:00:00
5969	5969	\N	2009-01-01 00:00:00
5970	5970	\N	2009-01-01 00:00:00
5971	5971	\N	2009-01-01 00:00:00
5972	5972	\N	2009-01-01 00:00:00
5973	5973	\N	2009-01-01 00:00:00
5974	5974	\N	2009-01-01 00:00:00
5975	5975	\N	2009-01-01 00:00:00
5976	5976	\N	2009-01-01 00:00:00
5977	5977	\N	2009-01-01 00:00:00
5978	5978	\N	2009-01-01 00:00:00
5979	5979	\N	2009-01-01 00:00:00
5980	5980	\N	2009-01-01 00:00:00
5981	5981	\N	2009-01-01 00:00:00
5982	5982	\N	2009-01-01 00:00:00
5983	5983	\N	2009-01-01 00:00:00
5984	5984	\N	2009-01-01 00:00:00
5985	5985	\N	2009-01-01 00:00:00
5986	5986	\N	2009-01-01 00:00:00
5987	5987	\N	2009-01-01 00:00:00
5988	5988	\N	2009-01-01 00:00:00
5989	5989	\N	2009-01-01 00:00:00
5990	5990	\N	2009-01-01 00:00:00
5991	5991	\N	2009-01-01 00:00:00
5992	5992	\N	2009-01-01 00:00:00
5993	5993	\N	2009-01-01 00:00:00
5994	5994	\N	2009-01-01 00:00:00
5995	5995	\N	2009-01-01 00:00:00
5996	5996	\N	2009-01-01 00:00:00
5997	5997	\N	2009-01-01 00:00:00
5998	5998	\N	2009-01-01 00:00:00
5999	5999	\N	2009-01-01 00:00:00
6000	6000	\N	2009-01-01 00:00:00
6001	6001	\N	2009-01-01 00:00:00
6002	6002	\N	2009-01-01 00:00:00
6003	6003	\N	2009-01-01 00:00:00
6004	6004	\N	2009-01-01 00:00:00
6005	6005	\N	2009-01-01 00:00:00
6006	6006	\N	2009-01-01 00:00:00
6007	6007	\N	2009-01-01 00:00:00
6008	6008	\N	2009-01-01 00:00:00
6009	6009	\N	2009-01-01 00:00:00
6010	6010	\N	2009-01-01 00:00:00
6011	6011	\N	2009-01-01 00:00:00
6012	6012	\N	2009-01-01 00:00:00
6013	6013	\N	2009-01-01 00:00:00
6014	6014	\N	2009-01-01 00:00:00
6015	6015	\N	2009-01-01 00:00:00
6016	6016	\N	2009-01-01 00:00:00
6017	6017	\N	2009-01-01 00:00:00
6018	6018	\N	2009-01-01 00:00:00
6019	6019	\N	2009-01-01 00:00:00
6020	6020	\N	2009-01-01 00:00:00
6021	6021	\N	2009-01-01 00:00:00
6022	6022	\N	2009-01-01 00:00:00
6023	6023	\N	2009-01-01 00:00:00
6024	6024	\N	2009-01-01 00:00:00
6025	6025	\N	2009-01-01 00:00:00
6026	6026	\N	2009-01-01 00:00:00
6027	6027	\N	2009-01-01 00:00:00
6028	6028	\N	2009-01-01 00:00:00
6029	6029	\N	2009-01-01 00:00:00
6030	6030	\N	2009-01-01 00:00:00
6031	6031	\N	2009-01-01 00:00:00
6032	6032	\N	2009-01-01 00:00:00
6033	6033	\N	2009-01-01 00:00:00
6034	6034	\N	2009-01-01 00:00:00
6035	6035	\N	2009-01-01 00:00:00
6036	6036	\N	2009-01-01 00:00:00
6037	6037	\N	2009-01-01 00:00:00
6038	6038	\N	2009-01-01 00:00:00
6039	6039	\N	2009-01-01 00:00:00
6040	6040	\N	2009-01-01 00:00:00
6041	6041	\N	2009-01-01 00:00:00
6042	6042	\N	2009-01-01 00:00:00
6043	6043	\N	2009-01-01 00:00:00
6044	6044	\N	2009-01-01 00:00:00
6045	6045	\N	2009-01-01 00:00:00
6046	6046	\N	2009-01-01 00:00:00
6047	6047	\N	2009-01-01 00:00:00
6048	6048	\N	2009-01-01 00:00:00
6049	6049	\N	2009-01-01 00:00:00
6050	6050	\N	2009-01-01 00:00:00
6051	6051	\N	2009-01-01 00:00:00
6052	6052	\N	2009-01-01 00:00:00
6053	6053	\N	2009-01-01 00:00:00
6054	6054	\N	2009-01-01 00:00:00
6055	6055	\N	2009-01-01 00:00:00
6056	6056	\N	2009-01-01 00:00:00
6057	6057	\N	2009-01-01 00:00:00
6058	6058	\N	2009-01-01 00:00:00
6059	6059	\N	2009-01-01 00:00:00
6060	6060	\N	2009-01-01 00:00:00
6061	6061	\N	2009-01-01 00:00:00
6062	6062	\N	2009-01-01 00:00:00
6063	6063	\N	2009-01-01 00:00:00
6064	6064	\N	2009-01-01 00:00:00
6065	6065	\N	2009-01-01 00:00:00
6066	6066	\N	2009-01-01 00:00:00
6067	6067	\N	2009-01-01 00:00:00
6068	6068	\N	2009-01-01 00:00:00
6069	6069	\N	2009-01-01 00:00:00
6070	6070	\N	2009-01-01 00:00:00
6071	6071	\N	2009-01-01 00:00:00
6072	6072	\N	2009-01-01 00:00:00
6073	6073	\N	2009-01-01 00:00:00
6074	6074	\N	2009-01-01 00:00:00
6075	6075	\N	2009-01-01 00:00:00
6076	6076	\N	2009-01-01 00:00:00
6077	6077	\N	2009-01-01 00:00:00
6078	6078	\N	2009-01-01 00:00:00
6079	6079	\N	2009-01-01 00:00:00
6080	6080	\N	2009-01-01 00:00:00
6081	6081	\N	2009-01-01 00:00:00
6082	6082	\N	2009-01-01 00:00:00
6083	6083	\N	2009-01-01 00:00:00
6084	6084	\N	2009-01-01 00:00:00
6085	6085	\N	2009-01-01 00:00:00
6086	6086	\N	2009-01-01 00:00:00
6087	6087	\N	2009-01-01 00:00:00
6088	6088	\N	2009-01-01 00:00:00
6089	6089	\N	2009-01-01 00:00:00
6090	6090	\N	2009-01-01 00:00:00
6091	6091	\N	2009-01-01 00:00:00
6092	6092	\N	2009-01-01 00:00:00
6093	6093	\N	2009-01-01 00:00:00
6094	6094	\N	2009-01-01 00:00:00
6095	6095	\N	2009-01-01 00:00:00
6096	6096	\N	2009-01-01 00:00:00
6097	6097	\N	2009-01-01 00:00:00
6098	6098	\N	2009-01-01 00:00:00
6099	6099	\N	2009-01-01 00:00:00
6100	6100	\N	2009-01-01 00:00:00
6101	6101	\N	2009-01-01 00:00:00
6102	6102	\N	2009-01-01 00:00:00
6103	6103	\N	2009-01-01 00:00:00
6104	6104	\N	2009-01-01 00:00:00
6105	6105	\N	2009-01-01 00:00:00
6106	6106	\N	2009-01-01 00:00:00
6107	6107	\N	2009-01-01 00:00:00
6108	6108	\N	2009-01-01 00:00:00
6109	6109	\N	2009-01-01 00:00:00
6110	6110	\N	2009-01-01 00:00:00
6111	6111	\N	2009-01-01 00:00:00
6112	6112	\N	2009-01-01 00:00:00
6113	6113	\N	2009-01-01 00:00:00
6114	6114	\N	2009-01-01 00:00:00
6115	6115	\N	2009-01-01 00:00:00
6116	6116	\N	2009-01-01 00:00:00
6117	6117	\N	2009-01-01 00:00:00
6118	6118	\N	2009-01-01 00:00:00
6119	6119	\N	2009-01-01 00:00:00
6120	6120	\N	2009-01-01 00:00:00
6121	6121	\N	2009-01-01 00:00:00
6122	6122	\N	2009-01-01 00:00:00
6123	6123	\N	2009-01-01 00:00:00
6124	6124	\N	2009-01-01 00:00:00
6125	6125	\N	2009-01-01 00:00:00
6126	6126	\N	2009-01-01 00:00:00
6127	6127	\N	2009-01-01 00:00:00
6128	6128	\N	2009-01-01 00:00:00
6129	6129	\N	2009-01-01 00:00:00
6130	6130	\N	2009-01-01 00:00:00
6131	6131	\N	2009-01-01 00:00:00
6132	6132	\N	2009-01-01 00:00:00
6133	6133	\N	2009-01-01 00:00:00
6134	6134	\N	2009-01-01 00:00:00
6135	6135	\N	2009-01-01 00:00:00
6136	6136	\N	2009-01-01 00:00:00
6137	6137	\N	2009-01-01 00:00:00
6138	6138	\N	2009-01-01 00:00:00
6139	6139	\N	2009-01-01 00:00:00
6140	6140	\N	2009-01-01 00:00:00
6141	6141	\N	2009-01-01 00:00:00
6142	6142	\N	2009-01-01 00:00:00
6143	6143	\N	2009-01-01 00:00:00
6144	6144	\N	2009-01-01 00:00:00
6145	6145	\N	2009-01-01 00:00:00
6146	6146	\N	2009-01-01 00:00:00
6147	6147	\N	2009-01-01 00:00:00
6148	6148	\N	2009-01-01 00:00:00
6149	6149	\N	2009-01-01 00:00:00
6150	6150	\N	2009-01-01 00:00:00
6151	6151	\N	2009-01-01 00:00:00
6152	6152	\N	2009-01-01 00:00:00
6153	6153	\N	2009-01-01 00:00:00
6154	6154	\N	2009-01-01 00:00:00
6155	6155	\N	2009-01-01 00:00:00
6156	6156	\N	2009-01-01 00:00:00
6157	6157	\N	2009-01-01 00:00:00
6158	6158	\N	2009-01-01 00:00:00
6159	6159	\N	2009-01-01 00:00:00
6160	6160	\N	2009-01-01 00:00:00
6161	6161	\N	2009-01-01 00:00:00
6162	6162	\N	2009-01-01 00:00:00
6163	6163	\N	2009-01-01 00:00:00
6164	6164	\N	2009-01-01 00:00:00
6165	6165	\N	2009-01-01 00:00:00
6166	6166	\N	2009-01-01 00:00:00
6167	6167	\N	2009-01-01 00:00:00
6168	6168	\N	2009-01-01 00:00:00
6169	6169	\N	2009-01-01 00:00:00
6170	6170	\N	2009-01-01 00:00:00
6171	6171	\N	2009-01-01 00:00:00
6172	6172	\N	2009-01-01 00:00:00
6173	6173	\N	2009-01-01 00:00:00
6174	6174	\N	2009-01-01 00:00:00
6175	6175	\N	2009-01-01 00:00:00
6176	6176	\N	2009-01-01 00:00:00
6177	6177	\N	2009-01-01 00:00:00
6178	6178	\N	2009-01-01 00:00:00
6179	6179	\N	2009-01-01 00:00:00
6180	6180	\N	2009-01-01 00:00:00
6181	6181	\N	2009-01-01 00:00:00
6182	6182	\N	2009-01-01 00:00:00
6183	6183	\N	2009-01-01 00:00:00
6184	6184	\N	2009-01-01 00:00:00
6185	6185	\N	2009-01-01 00:00:00
6186	6186	\N	2009-01-01 00:00:00
6187	6187	\N	2009-01-01 00:00:00
6188	6188	\N	2009-01-01 00:00:00
6189	6189	\N	2009-01-01 00:00:00
6190	6190	\N	2009-01-01 00:00:00
6191	6191	\N	2009-01-01 00:00:00
6192	6192	\N	2009-01-01 00:00:00
6193	6193	\N	2009-01-01 00:00:00
6194	6194	\N	2009-01-01 00:00:00
6195	6195	\N	2009-01-01 00:00:00
6196	6196	\N	2009-01-01 00:00:00
6197	6197	\N	2009-01-01 00:00:00
6198	6198	\N	2009-01-01 00:00:00
6199	6199	\N	2009-01-01 00:00:00
6200	6200	\N	2009-01-01 00:00:00
6201	6201	\N	2009-01-01 00:00:00
6202	6202	\N	2009-01-01 00:00:00
6203	6203	\N	2009-01-01 00:00:00
6204	6204	\N	2009-01-01 00:00:00
6205	6205	\N	2009-01-01 00:00:00
6206	6206	\N	2009-01-01 00:00:00
6207	6207	\N	2009-01-01 00:00:00
6208	6208	\N	2009-01-01 00:00:00
6209	6209	\N	2009-01-01 00:00:00
6210	6210	\N	2009-01-01 00:00:00
6211	6211	\N	2009-01-01 00:00:00
6212	6212	\N	2009-01-01 00:00:00
6213	6213	\N	2009-01-01 00:00:00
6214	6214	\N	2009-01-01 00:00:00
6215	6215	\N	2009-01-01 00:00:00
6216	6216	\N	2009-01-01 00:00:00
6217	6217	\N	2009-01-01 00:00:00
6218	6218	\N	2009-01-01 00:00:00
6219	6219	\N	2009-01-01 00:00:00
6220	6220	\N	2009-01-01 00:00:00
6221	6221	\N	2009-01-01 00:00:00
6222	6222	\N	2009-01-01 00:00:00
6223	6223	\N	2009-01-01 00:00:00
6224	6224	\N	2009-01-01 00:00:00
6225	6225	\N	2009-01-01 00:00:00
6226	6226	\N	2009-01-01 00:00:00
6227	6227	\N	2009-01-01 00:00:00
6228	6228	\N	2009-01-01 00:00:00
6229	6229	\N	2009-01-01 00:00:00
6230	6230	\N	2009-01-01 00:00:00
6231	6231	\N	2009-01-01 00:00:00
6232	6232	\N	2009-01-01 00:00:00
6233	6233	\N	2009-01-01 00:00:00
6234	6234	\N	2009-01-01 00:00:00
6235	6235	\N	2009-01-01 00:00:00
6236	6236	\N	2009-01-01 00:00:00
6237	6237	\N	2009-01-01 00:00:00
6238	6238	\N	2009-01-01 00:00:00
6239	6239	\N	2009-01-01 00:00:00
6240	6240	\N	2009-01-01 00:00:00
6241	6241	\N	2009-01-01 00:00:00
6242	6242	\N	2009-01-01 00:00:00
6243	6243	\N	2009-01-01 00:00:00
6244	6244	\N	2009-01-01 00:00:00
6245	6245	\N	2009-01-01 00:00:00
6246	6246	\N	2009-01-01 00:00:00
6247	6247	\N	2009-01-01 00:00:00
6248	6248	\N	2009-01-01 00:00:00
6249	6249	\N	2009-01-01 00:00:00
6250	6250	\N	2009-01-01 00:00:00
6251	6251	\N	2009-01-01 00:00:00
6252	6252	\N	2009-01-01 00:00:00
6253	6253	\N	2009-01-01 00:00:00
6254	6254	\N	2009-01-01 00:00:00
6255	6255	\N	2009-01-01 00:00:00
6256	6256	\N	2009-01-01 00:00:00
6257	6257	\N	2009-01-01 00:00:00
6258	6258	\N	2009-01-01 00:00:00
6259	6259	\N	2009-01-01 00:00:00
6260	6260	\N	2009-01-01 00:00:00
6261	6261	\N	2009-01-01 00:00:00
6262	6262	\N	2009-01-01 00:00:00
6263	6263	\N	2009-01-01 00:00:00
6264	6264	\N	2009-01-01 00:00:00
6265	6265	\N	2009-01-01 00:00:00
6266	6266	\N	2009-01-01 00:00:00
6267	6267	\N	2009-01-01 00:00:00
6268	6268	\N	2009-01-01 00:00:00
6269	6269	\N	2009-01-01 00:00:00
6270	6270	\N	2009-01-01 00:00:00
6271	6271	\N	2009-01-01 00:00:00
6272	6272	\N	2009-01-01 00:00:00
6273	6273	\N	2009-01-01 00:00:00
6274	6274	\N	2009-01-01 00:00:00
6275	6275	\N	2009-01-01 00:00:00
6276	6276	\N	2009-01-01 00:00:00
6277	6277	\N	2009-01-01 00:00:00
6278	6278	\N	2009-01-01 00:00:00
6279	6279	\N	2009-01-01 00:00:00
6280	6280	\N	2009-01-01 00:00:00
6281	6281	\N	2009-01-01 00:00:00
6282	6282	\N	2009-01-01 00:00:00
6283	6283	\N	2009-01-01 00:00:00
6284	6284	\N	2009-01-01 00:00:00
6285	6285	\N	2009-01-01 00:00:00
6286	6286	\N	2009-01-01 00:00:00
6287	6287	\N	2009-01-01 00:00:00
6288	6288	\N	2009-01-01 00:00:00
6289	6289	\N	2009-01-01 00:00:00
6290	6290	\N	2009-01-01 00:00:00
6291	6291	\N	2009-01-01 00:00:00
6292	6292	\N	2009-01-01 00:00:00
6293	6293	\N	2009-01-01 00:00:00
6294	6294	\N	2009-01-01 00:00:00
6295	6295	\N	2009-01-01 00:00:00
6296	6296	\N	2009-01-01 00:00:00
6297	6297	\N	2009-01-01 00:00:00
6298	6298	\N	2009-01-01 00:00:00
6299	6299	\N	2009-01-01 00:00:00
6300	6300	\N	2009-01-01 00:00:00
6301	6301	\N	2009-01-01 00:00:00
6302	6302	\N	2009-01-01 00:00:00
6303	6303	\N	2009-01-01 00:00:00
6304	6304	\N	2009-01-01 00:00:00
6305	6305	\N	2009-01-01 00:00:00
6306	6306	\N	2009-01-01 00:00:00
6307	6307	\N	2009-01-01 00:00:00
6308	6308	\N	2009-01-01 00:00:00
6309	6309	\N	2009-01-01 00:00:00
6310	6310	\N	2009-01-01 00:00:00
6311	6311	\N	2009-01-01 00:00:00
6312	6312	\N	2009-01-01 00:00:00
6313	6313	\N	2009-01-01 00:00:00
6314	6314	\N	2009-01-01 00:00:00
6315	6315	\N	2009-01-01 00:00:00
6316	6316	\N	2009-01-01 00:00:00
6317	6317	\N	2009-01-01 00:00:00
6318	6318	\N	2009-01-01 00:00:00
6319	6319	\N	2009-01-01 00:00:00
6320	6320	\N	2009-01-01 00:00:00
6321	6321	\N	2009-01-01 00:00:00
6322	6322	\N	2009-01-01 00:00:00
6323	6323	\N	2009-01-01 00:00:00
6324	6324	\N	2009-01-01 00:00:00
6325	6325	\N	2009-01-01 00:00:00
6326	6326	\N	2009-01-01 00:00:00
6327	6327	\N	2009-01-01 00:00:00
6328	6328	\N	2009-01-01 00:00:00
6329	6329	\N	2009-01-01 00:00:00
6330	6330	\N	2009-01-01 00:00:00
6331	6331	\N	2009-01-01 00:00:00
6332	6332	\N	2009-01-01 00:00:00
6333	6333	\N	2009-01-01 00:00:00
6334	6334	\N	2009-01-01 00:00:00
6335	6335	\N	2009-01-01 00:00:00
6336	6336	\N	2009-01-01 00:00:00
6337	6337	\N	2009-01-01 00:00:00
6338	6338	\N	2009-01-01 00:00:00
6339	6339	\N	2009-01-01 00:00:00
6340	6340	\N	2009-01-01 00:00:00
6341	6341	\N	2009-01-01 00:00:00
6342	6342	\N	2009-01-01 00:00:00
6343	6343	\N	2009-01-01 00:00:00
6344	6344	\N	2009-01-01 00:00:00
6345	6345	\N	2009-01-01 00:00:00
6346	6346	\N	2009-01-01 00:00:00
6347	6347	\N	2009-01-01 00:00:00
6348	6348	\N	2009-01-01 00:00:00
6349	6349	\N	2009-01-01 00:00:00
6350	6350	\N	2009-01-01 00:00:00
6351	6351	\N	2009-01-01 00:00:00
6352	6352	\N	2009-01-01 00:00:00
6353	6353	\N	2009-01-01 00:00:00
6354	6354	\N	2009-01-01 00:00:00
6355	6355	\N	2009-01-01 00:00:00
6356	6356	\N	2009-01-01 00:00:00
6357	6357	\N	2009-01-01 00:00:00
6358	6358	\N	2009-01-01 00:00:00
6359	6359	\N	2009-01-01 00:00:00
6360	6360	\N	2009-01-01 00:00:00
6361	6361	\N	2009-01-01 00:00:00
6362	6362	\N	2009-01-01 00:00:00
6363	6363	\N	2009-01-01 00:00:00
6364	6364	\N	2009-01-01 00:00:00
6365	6365	\N	2009-01-01 00:00:00
6366	6366	\N	2009-01-01 00:00:00
6367	6367	\N	2009-01-01 00:00:00
6368	6368	\N	2009-01-01 00:00:00
6369	6369	\N	2009-01-01 00:00:00
6370	6370	\N	2009-01-01 00:00:00
6371	6371	\N	2009-01-01 00:00:00
6372	6372	\N	2009-01-01 00:00:00
6373	6373	\N	2009-01-01 00:00:00
6374	6374	\N	2009-01-01 00:00:00
6375	6375	\N	2009-01-01 00:00:00
6376	6376	\N	2009-01-01 00:00:00
6377	6377	\N	2009-01-01 00:00:00
6378	6378	\N	2009-01-01 00:00:00
6379	6379	\N	2009-01-01 00:00:00
6380	6380	\N	2009-01-01 00:00:00
6381	6381	\N	2009-01-01 00:00:00
6382	6382	\N	2009-01-01 00:00:00
6383	6383	\N	2009-01-01 00:00:00
6384	6384	\N	2009-01-01 00:00:00
6385	6385	\N	2009-01-01 00:00:00
6386	6386	\N	2009-01-01 00:00:00
6387	6387	\N	2009-01-01 00:00:00
6388	6388	\N	2009-01-01 00:00:00
6389	6389	\N	2009-01-01 00:00:00
6390	6390	\N	2009-01-01 00:00:00
6391	6391	\N	2009-01-01 00:00:00
6392	6392	\N	2009-01-01 00:00:00
6393	6393	\N	2009-01-01 00:00:00
6394	6394	\N	2009-01-01 00:00:00
6395	6395	\N	2009-01-01 00:00:00
6396	6396	\N	2009-01-01 00:00:00
6397	6397	\N	2009-01-01 00:00:00
6398	6398	\N	2009-01-01 00:00:00
6399	6399	\N	2009-01-01 00:00:00
6400	6400	\N	2009-01-01 00:00:00
6401	6401	\N	2009-01-01 00:00:00
6402	6402	\N	2009-01-01 00:00:00
6403	6403	\N	2009-01-01 00:00:00
6404	6404	\N	2009-01-01 00:00:00
6405	6405	\N	2009-01-01 00:00:00
6406	6406	\N	2009-01-01 00:00:00
6407	6407	\N	2009-01-01 00:00:00
6408	6408	\N	2009-01-01 00:00:00
6409	6409	\N	2009-01-01 00:00:00
6410	6410	\N	2009-01-01 00:00:00
6411	6411	\N	2009-01-01 00:00:00
6412	6412	\N	2009-01-01 00:00:00
6413	6413	\N	2009-01-01 00:00:00
6414	6414	\N	2009-01-01 00:00:00
6415	6415	\N	2009-01-01 00:00:00
6416	6416	\N	2009-01-01 00:00:00
6417	6417	\N	2009-01-01 00:00:00
6418	6418	\N	2009-01-01 00:00:00
6419	6419	\N	2009-01-01 00:00:00
6420	6420	\N	2009-01-01 00:00:00
6421	6421	\N	2009-01-01 00:00:00
6422	6422	\N	2009-01-01 00:00:00
6423	6423	\N	2009-01-01 00:00:00
6424	6424	\N	2009-01-01 00:00:00
6425	6425	\N	2009-01-01 00:00:00
6426	6426	\N	2009-01-01 00:00:00
6427	6427	\N	2009-01-01 00:00:00
6428	6428	\N	2009-01-01 00:00:00
6429	6429	\N	2009-01-01 00:00:00
6430	6430	\N	2009-01-01 00:00:00
6431	6431	\N	2009-01-01 00:00:00
6432	6432	\N	2009-01-01 00:00:00
6433	6433	\N	2009-01-01 00:00:00
6434	6434	\N	2009-01-01 00:00:00
6435	6435	\N	2009-01-01 00:00:00
6436	6436	\N	2009-01-01 00:00:00
6437	6437	\N	2009-01-01 00:00:00
6438	6438	\N	2009-01-01 00:00:00
6439	6439	\N	2009-01-01 00:00:00
6440	6440	\N	2009-01-01 00:00:00
6441	6441	\N	2009-01-01 00:00:00
6442	6442	\N	2009-01-01 00:00:00
6443	6443	\N	2009-01-01 00:00:00
6444	6444	\N	2009-01-01 00:00:00
6445	6445	\N	2009-01-01 00:00:00
6446	6446	\N	2009-01-01 00:00:00
6447	6447	\N	2009-01-01 00:00:00
6448	6448	\N	2009-01-01 00:00:00
6449	6449	\N	2009-01-01 00:00:00
6450	6450	\N	2009-01-01 00:00:00
6451	6451	\N	2009-01-01 00:00:00
6452	6452	\N	2009-01-01 00:00:00
6453	6453	\N	2009-01-01 00:00:00
6454	6454	\N	2009-01-01 00:00:00
6455	6455	\N	2009-01-01 00:00:00
6456	6456	\N	2009-01-01 00:00:00
6457	6457	\N	2009-01-01 00:00:00
6458	6458	\N	2009-01-01 00:00:00
6459	6459	\N	2009-01-01 00:00:00
6460	6460	\N	2009-01-01 00:00:00
6461	6461	\N	2009-01-01 00:00:00
6462	6462	\N	2009-01-01 00:00:00
6463	6463	\N	2009-01-01 00:00:00
6464	6464	\N	2009-01-01 00:00:00
6465	6465	\N	2009-01-01 00:00:00
6466	6466	\N	2009-01-01 00:00:00
6467	6467	\N	2009-01-01 00:00:00
6468	6468	\N	2009-01-01 00:00:00
6469	6469	\N	2009-01-01 00:00:00
6470	6470	\N	2009-01-01 00:00:00
6471	6471	\N	2009-01-01 00:00:00
6472	6472	\N	2009-01-01 00:00:00
6473	6473	\N	2009-01-01 00:00:00
6474	6474	\N	2009-01-01 00:00:00
6475	6475	\N	2009-01-01 00:00:00
6476	6476	\N	2009-01-01 00:00:00
6477	6477	\N	2009-01-01 00:00:00
6478	6478	\N	2009-01-01 00:00:00
6479	6479	\N	2009-01-01 00:00:00
6480	6480	\N	2009-01-01 00:00:00
6481	6481	\N	2009-01-01 00:00:00
6482	6482	\N	2009-01-01 00:00:00
6483	6483	\N	2009-01-01 00:00:00
6484	6484	\N	2009-01-01 00:00:00
6485	6485	\N	2009-01-01 00:00:00
6486	6486	\N	2009-01-01 00:00:00
6487	6487	\N	2009-01-01 00:00:00
6488	6488	\N	2009-01-01 00:00:00
6489	6489	\N	2009-01-01 00:00:00
6490	6490	\N	2009-01-01 00:00:00
6491	6491	\N	2009-01-01 00:00:00
6492	6492	\N	2009-01-01 00:00:00
6493	6493	\N	2009-01-01 00:00:00
6494	6494	\N	2009-01-01 00:00:00
6495	6495	\N	2009-01-01 00:00:00
6496	6496	\N	2009-01-01 00:00:00
6497	6497	\N	2009-01-01 00:00:00
6498	6498	\N	2009-01-01 00:00:00
6499	6499	\N	2009-01-01 00:00:00
6500	6500	\N	2009-01-01 00:00:00
6501	6501	\N	2009-01-01 00:00:00
6502	6502	\N	2009-01-01 00:00:00
6503	6503	\N	2009-01-01 00:00:00
6504	6504	\N	2009-01-01 00:00:00
6505	6505	\N	2009-01-01 00:00:00
6506	6506	\N	2009-01-01 00:00:00
6507	6507	\N	2009-01-01 00:00:00
6508	6508	\N	2009-01-01 00:00:00
6509	6509	\N	2009-01-01 00:00:00
6510	6510	\N	2009-01-01 00:00:00
6511	6511	\N	2009-01-01 00:00:00
6512	6512	\N	2009-01-01 00:00:00
6513	6513	\N	2009-01-01 00:00:00
6514	6514	\N	2009-01-01 00:00:00
6515	6515	\N	2009-01-01 00:00:00
6516	6516	\N	2009-01-01 00:00:00
6517	6517	\N	2009-01-01 00:00:00
6518	6518	\N	2009-01-01 00:00:00
6519	6519	\N	2009-01-01 00:00:00
6520	6520	\N	2009-01-01 00:00:00
6521	6521	\N	2009-01-01 00:00:00
6522	6522	\N	2009-01-01 00:00:00
6523	6523	\N	2009-01-01 00:00:00
6524	6524	\N	2009-01-01 00:00:00
6525	6525	\N	2009-01-01 00:00:00
6526	6526	\N	2009-01-01 00:00:00
6527	6527	\N	2009-01-01 00:00:00
6528	6528	\N	2009-01-01 00:00:00
6529	6529	\N	2009-01-01 00:00:00
6530	6530	\N	2009-01-01 00:00:00
6531	6531	\N	2009-01-01 00:00:00
6532	6532	\N	2009-01-01 00:00:00
6533	6533	\N	2009-01-01 00:00:00
6534	6534	\N	2009-01-01 00:00:00
6535	6535	\N	2009-01-01 00:00:00
6536	6536	\N	2009-01-01 00:00:00
6537	6537	\N	2009-01-01 00:00:00
6538	6538	\N	2009-01-01 00:00:00
6539	6539	\N	2009-01-01 00:00:00
6540	6540	\N	2009-01-01 00:00:00
6541	6541	\N	2009-01-01 00:00:00
6542	6542	\N	2009-01-01 00:00:00
6543	6543	\N	2009-01-01 00:00:00
6544	6544	\N	2009-01-01 00:00:00
6545	6545	\N	2009-01-01 00:00:00
6546	6546	\N	2009-01-01 00:00:00
6547	6547	\N	2009-01-01 00:00:00
6548	6548	\N	2009-01-01 00:00:00
6549	6549	\N	2009-01-01 00:00:00
6550	6550	\N	2009-01-01 00:00:00
6551	6551	\N	2009-01-01 00:00:00
6552	6552	\N	2009-01-01 00:00:00
6553	6553	\N	2009-01-01 00:00:00
6554	6554	\N	2009-01-01 00:00:00
6555	6555	\N	2009-01-01 00:00:00
6556	6556	\N	2009-01-01 00:00:00
6557	6557	\N	2009-01-01 00:00:00
6558	6558	\N	2009-01-01 00:00:00
6559	6559	\N	2009-01-01 00:00:00
6560	6560	\N	2009-01-01 00:00:00
6561	6561	\N	2009-01-01 00:00:00
6562	6562	\N	2009-01-01 00:00:00
6563	6563	\N	2009-01-01 00:00:00
6564	6564	\N	2009-01-01 00:00:00
6565	6565	\N	2009-01-01 00:00:00
6566	6566	\N	2009-01-01 00:00:00
6567	6567	\N	2009-01-01 00:00:00
6568	6568	\N	2009-01-01 00:00:00
6569	6569	\N	2009-01-01 00:00:00
6570	6570	\N	2009-01-01 00:00:00
6571	6571	\N	2009-01-01 00:00:00
6572	6572	\N	2009-01-01 00:00:00
6573	6573	\N	2009-01-01 00:00:00
6574	6574	\N	2009-01-01 00:00:00
6575	6575	\N	2009-01-01 00:00:00
6576	6576	\N	2009-01-01 00:00:00
6577	6577	\N	2009-01-01 00:00:00
6578	6578	\N	2009-01-01 00:00:00
6579	6579	\N	2009-01-01 00:00:00
6580	6580	\N	2009-01-01 00:00:00
6581	6581	\N	2009-01-01 00:00:00
6582	6582	\N	2009-01-01 00:00:00
6583	6583	\N	2009-01-01 00:00:00
6584	6584	\N	2009-01-01 00:00:00
6585	6585	\N	2009-01-01 00:00:00
6586	6586	\N	2009-01-01 00:00:00
6587	6587	\N	2009-01-01 00:00:00
6588	6588	\N	2009-01-01 00:00:00
6589	6589	\N	2009-01-01 00:00:00
6590	6590	\N	2009-01-01 00:00:00
6591	6591	\N	2009-01-01 00:00:00
6592	6592	\N	2009-01-01 00:00:00
6593	6593	\N	2009-01-01 00:00:00
6594	6594	\N	2009-01-01 00:00:00
6595	6595	\N	2009-01-01 00:00:00
6596	6596	\N	2009-01-01 00:00:00
6597	6597	\N	2009-01-01 00:00:00
6598	6598	\N	2009-01-01 00:00:00
6599	6599	\N	2009-01-01 00:00:00
6600	6600	\N	2009-01-01 00:00:00
6601	6601	\N	2009-01-01 00:00:00
6602	6602	\N	2009-01-01 00:00:00
6603	6603	\N	2009-01-01 00:00:00
6604	6604	\N	2009-01-01 00:00:00
6605	6605	\N	2009-01-01 00:00:00
6606	6606	\N	2009-01-01 00:00:00
6607	6607	\N	2009-01-01 00:00:00
6608	6608	\N	2009-01-01 00:00:00
6609	6609	\N	2009-01-01 00:00:00
6610	6610	\N	2009-01-01 00:00:00
6611	6611	\N	2009-01-01 00:00:00
6612	6612	\N	2009-01-01 00:00:00
6613	6613	\N	2009-01-01 00:00:00
6614	6614	\N	2009-01-01 00:00:00
6615	6615	\N	2009-01-01 00:00:00
6616	6616	\N	2009-01-01 00:00:00
6617	6617	\N	2009-01-01 00:00:00
6618	6618	\N	2009-01-01 00:00:00
6619	6619	\N	2009-01-01 00:00:00
6620	6620	\N	2009-01-01 00:00:00
6621	6621	\N	2009-01-01 00:00:00
6622	6622	\N	2009-01-01 00:00:00
6623	6623	\N	2009-01-01 00:00:00
6624	6624	\N	2009-01-01 00:00:00
6625	6625	\N	2009-01-01 00:00:00
6626	6626	\N	2009-01-01 00:00:00
6627	6627	\N	2009-01-01 00:00:00
6628	6628	\N	2009-01-01 00:00:00
6629	6629	\N	2009-01-01 00:00:00
6630	6630	\N	2009-01-01 00:00:00
6631	6631	\N	2009-01-01 00:00:00
6632	6632	\N	2009-01-01 00:00:00
6633	6633	\N	2009-01-01 00:00:00
6634	6634	\N	2009-01-01 00:00:00
6635	6635	\N	2009-01-01 00:00:00
6636	6636	\N	2009-01-01 00:00:00
6637	6637	\N	2009-01-01 00:00:00
6638	6638	\N	2009-01-01 00:00:00
6639	6639	\N	2009-01-01 00:00:00
6640	6640	\N	2009-01-01 00:00:00
6641	6641	\N	2009-01-01 00:00:00
6642	6642	\N	2009-01-01 00:00:00
6643	6643	\N	2009-01-01 00:00:00
6644	6644	\N	2009-01-01 00:00:00
6645	6645	\N	2009-01-01 00:00:00
6646	6646	\N	2009-01-01 00:00:00
6647	6647	\N	2009-01-01 00:00:00
6648	6648	\N	2009-01-01 00:00:00
6649	6649	\N	2009-01-01 00:00:00
6650	6650	\N	2009-01-01 00:00:00
6651	6651	\N	2009-01-01 00:00:00
6652	6652	\N	2009-01-01 00:00:00
6653	6653	\N	2009-01-01 00:00:00
6654	6654	\N	2009-01-01 00:00:00
6655	6655	\N	2009-01-01 00:00:00
6656	6656	\N	2009-01-01 00:00:00
6657	6657	\N	2009-01-01 00:00:00
6658	6658	\N	2009-01-01 00:00:00
6659	6659	\N	2009-01-01 00:00:00
6660	6660	\N	2009-01-01 00:00:00
6661	6661	\N	2009-01-01 00:00:00
6662	6662	\N	2009-01-01 00:00:00
6663	6663	\N	2009-01-01 00:00:00
6664	6664	\N	2009-01-01 00:00:00
6665	6665	\N	2009-01-01 00:00:00
6666	6666	\N	2009-01-01 00:00:00
6667	6667	\N	2009-01-01 00:00:00
6668	6668	\N	2009-01-01 00:00:00
6669	6669	\N	2009-01-01 00:00:00
6670	6670	\N	2009-01-01 00:00:00
6671	6671	\N	2009-01-01 00:00:00
6672	6672	\N	2009-01-01 00:00:00
6673	6673	\N	2009-01-01 00:00:00
6674	6674	\N	2009-01-01 00:00:00
6675	6675	\N	2009-01-01 00:00:00
6676	6676	\N	2009-01-01 00:00:00
6677	6677	\N	2009-01-01 00:00:00
6678	6678	\N	2009-01-01 00:00:00
6679	6679	\N	2009-01-01 00:00:00
6680	6680	\N	2009-01-01 00:00:00
6681	6681	\N	2009-01-01 00:00:00
6682	6682	\N	2009-01-01 00:00:00
6683	6683	\N	2009-01-01 00:00:00
6684	6684	\N	2009-01-01 00:00:00
6685	6685	\N	2009-01-01 00:00:00
6686	6686	\N	2009-01-01 00:00:00
6687	6687	\N	2009-01-01 00:00:00
6688	6688	\N	2009-01-01 00:00:00
6689	6689	\N	2009-01-01 00:00:00
6690	6690	\N	2009-01-01 00:00:00
6691	6691	\N	2009-01-01 00:00:00
6692	6692	\N	2009-01-01 00:00:00
6693	6693	\N	2009-01-01 00:00:00
6694	6694	\N	2009-01-01 00:00:00
6695	6695	\N	2009-01-01 00:00:00
6696	6696	\N	2009-01-01 00:00:00
6697	6697	\N	2009-01-01 00:00:00
6698	6698	\N	2009-01-01 00:00:00
6699	6699	\N	2009-01-01 00:00:00
6700	6700	\N	2009-01-01 00:00:00
6701	6701	\N	2009-01-01 00:00:00
6702	6702	\N	2009-01-01 00:00:00
6703	6703	\N	2009-01-01 00:00:00
6704	6704	\N	2009-01-01 00:00:00
6705	6705	\N	2009-01-01 00:00:00
6706	6706	\N	2009-01-01 00:00:00
6707	6707	\N	2009-01-01 00:00:00
6708	6708	\N	2009-01-01 00:00:00
6709	6709	\N	2009-01-01 00:00:00
6710	6710	\N	2009-01-01 00:00:00
6711	6711	\N	2009-01-01 00:00:00
6712	6712	\N	2009-01-01 00:00:00
6713	6713	\N	2009-01-01 00:00:00
6714	6714	\N	2009-01-01 00:00:00
6715	6715	\N	2009-01-01 00:00:00
6716	6716	\N	2009-01-01 00:00:00
6717	6717	\N	2009-01-01 00:00:00
6718	6718	\N	2009-01-01 00:00:00
6719	6719	\N	2009-01-01 00:00:00
6720	6720	\N	2009-01-01 00:00:00
6721	6721	\N	2009-01-01 00:00:00
6722	6722	\N	2009-01-01 00:00:00
6723	6723	\N	2009-01-01 00:00:00
6724	6724	\N	2009-01-01 00:00:00
6725	6725	\N	2009-01-01 00:00:00
6726	6726	\N	2009-01-01 00:00:00
6727	6727	\N	2009-01-01 00:00:00
6728	6728	\N	2009-01-01 00:00:00
6729	6729	\N	2009-01-01 00:00:00
6730	6730	\N	2009-01-01 00:00:00
6731	6731	\N	2009-01-01 00:00:00
6732	6732	\N	2009-01-01 00:00:00
6733	6733	\N	2009-01-01 00:00:00
6734	6734	\N	2009-01-01 00:00:00
6735	6735	\N	2009-01-01 00:00:00
6736	6736	\N	2009-01-01 00:00:00
6737	6737	\N	2009-01-01 00:00:00
6738	6738	\N	2009-01-01 00:00:00
6739	6739	\N	2009-01-01 00:00:00
6740	6740	\N	2009-01-01 00:00:00
6741	6741	\N	2009-01-01 00:00:00
6742	6742	\N	2009-01-01 00:00:00
6743	6743	\N	2009-01-01 00:00:00
6744	6744	\N	2009-01-01 00:00:00
6745	6745	\N	2009-01-01 00:00:00
6746	6746	\N	2009-01-01 00:00:00
6747	6747	\N	2009-01-01 00:00:00
6748	6748	\N	2009-01-01 00:00:00
6749	6749	\N	2009-01-01 00:00:00
6750	6750	\N	2009-01-01 00:00:00
6751	6751	\N	2009-01-01 00:00:00
6752	6752	\N	2009-01-01 00:00:00
6753	6753	\N	2009-01-01 00:00:00
6754	6754	\N	2009-01-01 00:00:00
6755	6755	\N	2009-01-01 00:00:00
6756	6756	\N	2009-01-01 00:00:00
6757	6757	\N	2009-01-01 00:00:00
6758	6758	\N	2009-01-01 00:00:00
6759	6759	\N	2009-01-01 00:00:00
6760	6760	\N	2009-01-01 00:00:00
6761	6761	\N	2009-01-01 00:00:00
6762	6762	\N	2009-01-01 00:00:00
6763	6763	\N	2009-01-01 00:00:00
6764	6764	\N	2009-01-01 00:00:00
6765	6765	\N	2009-01-01 00:00:00
6766	6766	\N	2009-01-01 00:00:00
6767	6767	\N	2009-01-01 00:00:00
6768	6768	\N	2009-01-01 00:00:00
6769	6769	\N	2009-01-01 00:00:00
6770	6770	\N	2009-01-01 00:00:00
6771	6771	\N	2009-01-01 00:00:00
6772	6772	\N	2009-01-01 00:00:00
6773	6773	\N	2009-01-01 00:00:00
6774	6774	\N	2009-01-01 00:00:00
6775	6775	\N	2009-01-01 00:00:00
6776	6776	\N	2009-01-01 00:00:00
6777	6777	\N	2009-01-01 00:00:00
6778	6778	\N	2009-01-01 00:00:00
6779	6779	\N	2009-01-01 00:00:00
6780	6780	\N	2009-01-01 00:00:00
6781	6781	\N	2009-01-01 00:00:00
6782	6782	\N	2009-01-01 00:00:00
6783	6783	\N	2009-01-01 00:00:00
6784	6784	\N	2009-01-01 00:00:00
6785	6785	\N	2009-01-01 00:00:00
6786	6786	\N	2009-01-01 00:00:00
6787	6787	\N	2009-01-01 00:00:00
6788	6788	\N	2009-01-01 00:00:00
6789	6789	\N	2009-01-01 00:00:00
6790	6790	\N	2009-01-01 00:00:00
6791	6791	\N	2009-01-01 00:00:00
6792	6792	\N	2009-01-01 00:00:00
6793	6793	\N	2009-01-01 00:00:00
6794	6794	\N	2009-01-01 00:00:00
6795	6795	\N	2009-01-01 00:00:00
6796	6796	\N	2009-01-01 00:00:00
6797	6797	\N	2009-01-01 00:00:00
6798	6798	\N	2009-01-01 00:00:00
6799	6799	\N	2009-01-01 00:00:00
6800	6800	\N	2009-01-01 00:00:00
6801	6801	\N	2009-01-01 00:00:00
6802	6802	\N	2009-01-01 00:00:00
6803	6803	\N	2009-01-01 00:00:00
6804	6804	\N	2009-01-01 00:00:00
6805	6805	\N	2009-01-01 00:00:00
6806	6806	\N	2009-01-01 00:00:00
6807	6807	\N	2009-01-01 00:00:00
6808	6808	\N	2009-01-01 00:00:00
6809	6809	\N	2009-01-01 00:00:00
6810	6810	\N	2009-01-01 00:00:00
6811	6811	\N	2009-01-01 00:00:00
6812	6812	\N	2009-01-01 00:00:00
6813	6813	\N	2009-01-01 00:00:00
6814	6814	\N	2009-01-01 00:00:00
6815	6815	\N	2009-01-01 00:00:00
6816	6816	\N	2009-01-01 00:00:00
6817	6817	\N	2009-01-01 00:00:00
6818	6818	\N	2009-01-01 00:00:00
6819	6819	\N	2009-01-01 00:00:00
6820	6820	\N	2009-01-01 00:00:00
6821	6821	\N	2009-01-01 00:00:00
6822	6822	\N	2009-01-01 00:00:00
6823	6823	\N	2009-01-01 00:00:00
6824	6824	\N	2009-01-01 00:00:00
6825	6825	\N	2009-01-01 00:00:00
6826	6826	\N	2009-01-01 00:00:00
6827	6827	\N	2009-01-01 00:00:00
6828	6828	\N	2009-01-01 00:00:00
6829	6829	\N	2009-01-01 00:00:00
6830	6830	\N	2009-01-01 00:00:00
6831	6831	\N	2009-01-01 00:00:00
6832	6832	\N	2009-01-01 00:00:00
6833	6833	\N	2009-01-01 00:00:00
6834	6834	\N	2009-01-01 00:00:00
6835	6835	\N	2009-01-01 00:00:00
6836	6836	\N	2009-01-01 00:00:00
6837	6837	\N	2009-01-01 00:00:00
6838	6838	\N	2009-01-01 00:00:00
6839	6839	\N	2009-01-01 00:00:00
6840	6840	\N	2009-01-01 00:00:00
6841	6841	\N	2009-01-01 00:00:00
6842	6842	\N	2009-01-01 00:00:00
6843	6843	\N	2009-01-01 00:00:00
6844	6844	\N	2009-01-01 00:00:00
6845	6845	\N	2009-01-01 00:00:00
6846	6846	\N	2009-01-01 00:00:00
6847	6847	\N	2009-01-01 00:00:00
6848	6848	\N	2009-01-01 00:00:00
6849	6849	\N	2009-01-01 00:00:00
6850	6850	\N	2009-01-01 00:00:00
6851	6851	\N	2009-01-01 00:00:00
6852	6852	\N	2009-01-01 00:00:00
6853	6853	\N	2009-01-01 00:00:00
6854	6854	\N	2009-01-01 00:00:00
6855	6855	\N	2009-01-01 00:00:00
6856	6856	\N	2009-01-01 00:00:00
6857	6857	\N	2009-01-01 00:00:00
6858	6858	\N	2009-01-01 00:00:00
6859	6859	\N	2009-01-01 00:00:00
6860	6860	\N	2009-01-01 00:00:00
6861	6861	\N	2009-01-01 00:00:00
6862	6862	\N	2009-01-01 00:00:00
6863	6863	\N	2009-01-01 00:00:00
6864	6864	\N	2009-01-01 00:00:00
6865	6865	\N	2009-01-01 00:00:00
6866	6866	\N	2009-01-01 00:00:00
6867	6867	\N	2009-01-01 00:00:00
6868	6868	\N	2009-01-01 00:00:00
6869	6869	\N	2009-01-01 00:00:00
6870	6870	\N	2009-01-01 00:00:00
6871	6871	\N	2009-01-01 00:00:00
6872	6872	\N	2009-01-01 00:00:00
6873	6873	\N	2009-01-01 00:00:00
6874	6874	\N	2009-01-01 00:00:00
6875	6875	\N	2009-01-01 00:00:00
6876	6876	\N	2009-01-01 00:00:00
6877	6877	\N	2009-01-01 00:00:00
6878	6878	\N	2009-01-01 00:00:00
6879	6879	\N	2009-01-01 00:00:00
6880	6880	\N	2009-01-01 00:00:00
6881	6881	\N	2009-01-01 00:00:00
6882	6882	\N	2009-01-01 00:00:00
6883	6883	\N	2009-01-01 00:00:00
6884	6884	\N	2009-01-01 00:00:00
6885	6885	\N	2009-01-01 00:00:00
6886	6886	\N	2009-01-01 00:00:00
6887	6887	\N	2009-01-01 00:00:00
6888	6888	\N	2009-01-01 00:00:00
6889	6889	\N	2009-01-01 00:00:00
6890	6890	\N	2009-01-01 00:00:00
6891	6891	\N	2009-01-01 00:00:00
6892	6892	\N	2009-01-01 00:00:00
6893	6893	\N	2009-01-01 00:00:00
6894	6894	\N	2009-01-01 00:00:00
6895	6895	\N	2009-01-01 00:00:00
6896	6896	\N	2009-01-01 00:00:00
6897	6897	\N	2009-01-01 00:00:00
6898	6898	\N	2009-01-01 00:00:00
6899	6899	\N	2009-01-01 00:00:00
6900	6900	\N	2009-01-01 00:00:00
6901	6901	\N	2009-01-01 00:00:00
6902	6902	\N	2009-01-01 00:00:00
6903	6903	\N	2009-01-01 00:00:00
6904	6904	\N	2009-01-01 00:00:00
6905	6905	\N	2009-01-01 00:00:00
6906	6906	\N	2009-01-01 00:00:00
6907	6907	\N	2009-01-01 00:00:00
6908	6908	\N	2009-01-01 00:00:00
6909	6909	\N	2009-01-01 00:00:00
6910	6910	\N	2009-01-01 00:00:00
6911	6911	\N	2009-01-01 00:00:00
6912	6912	\N	2009-01-01 00:00:00
6913	6913	\N	2009-01-01 00:00:00
6914	6914	\N	2009-01-01 00:00:00
6915	6915	\N	2009-01-01 00:00:00
6916	6916	\N	2009-01-01 00:00:00
6917	6917	\N	2009-01-01 00:00:00
6918	6918	\N	2009-01-01 00:00:00
6919	6919	\N	2009-01-01 00:00:00
6920	6920	\N	2009-01-01 00:00:00
6921	6921	\N	2009-01-01 00:00:00
6922	6922	\N	2009-01-01 00:00:00
6923	6923	\N	2009-01-01 00:00:00
6924	6924	\N	2009-01-01 00:00:00
6925	6925	\N	2009-01-01 00:00:00
6926	6926	\N	2009-01-01 00:00:00
6927	6927	\N	2009-01-01 00:00:00
6928	6928	\N	2009-01-01 00:00:00
6929	6929	\N	2009-01-01 00:00:00
6930	6930	\N	2009-01-01 00:00:00
6931	6931	\N	2009-01-01 00:00:00
6932	6932	\N	2009-01-01 00:00:00
6933	6933	\N	2009-01-01 00:00:00
6934	6934	\N	2009-01-01 00:00:00
6935	6935	\N	2009-01-01 00:00:00
6936	6936	\N	2009-01-01 00:00:00
6937	6937	\N	2009-01-01 00:00:00
6938	6938	\N	2009-01-01 00:00:00
6939	6939	\N	2009-01-01 00:00:00
6940	6940	\N	2009-01-01 00:00:00
6941	6941	\N	2009-01-01 00:00:00
6942	6942	\N	2009-01-01 00:00:00
6943	6943	\N	2009-01-01 00:00:00
6944	6944	\N	2009-01-01 00:00:00
6945	6945	\N	2009-01-01 00:00:00
6946	6946	\N	2009-01-01 00:00:00
6947	6947	\N	2009-01-01 00:00:00
6948	6948	\N	2009-01-01 00:00:00
6949	6949	\N	2009-01-01 00:00:00
6950	6950	\N	2009-01-01 00:00:00
6951	6951	\N	2009-01-01 00:00:00
6952	6952	\N	2009-01-01 00:00:00
6953	6953	\N	2009-01-01 00:00:00
6954	6954	\N	2009-01-01 00:00:00
6955	6955	\N	2009-01-01 00:00:00
6956	6956	\N	2009-01-01 00:00:00
6957	6957	\N	2009-01-01 00:00:00
6958	6958	\N	2009-01-01 00:00:00
6959	6959	\N	2009-01-01 00:00:00
6960	6960	\N	2009-01-01 00:00:00
6961	6961	\N	2009-01-01 00:00:00
6962	6962	\N	2009-01-01 00:00:00
6963	6963	\N	2009-01-01 00:00:00
6964	6964	\N	2009-01-01 00:00:00
6965	6965	\N	2009-01-01 00:00:00
6966	6966	\N	2009-01-01 00:00:00
6967	6967	\N	2009-01-01 00:00:00
6968	6968	\N	2009-01-01 00:00:00
6969	6969	\N	2009-01-01 00:00:00
6970	6970	\N	2009-01-01 00:00:00
6971	6971	\N	2009-01-01 00:00:00
6972	6972	\N	2009-01-01 00:00:00
6973	6973	\N	2009-01-01 00:00:00
6974	6974	\N	2009-01-01 00:00:00
6975	6975	\N	2009-01-01 00:00:00
6976	6976	\N	2009-01-01 00:00:00
6977	6977	\N	2009-01-01 00:00:00
6978	6978	\N	2009-01-01 00:00:00
6979	6979	\N	2009-01-01 00:00:00
6980	6980	\N	2009-01-01 00:00:00
6981	6981	\N	2009-01-01 00:00:00
6982	6982	\N	2009-01-01 00:00:00
6983	6983	\N	2009-01-01 00:00:00
6984	6984	\N	2009-01-01 00:00:00
6985	6985	\N	2009-01-01 00:00:00
6986	6986	\N	2009-01-01 00:00:00
6987	6987	\N	2009-01-01 00:00:00
6988	6988	\N	2009-01-01 00:00:00
6989	6989	\N	2009-01-01 00:00:00
6990	6990	\N	2009-01-01 00:00:00
6991	6991	\N	2009-01-01 00:00:00
6992	6992	\N	2009-01-01 00:00:00
6993	6993	\N	2009-01-01 00:00:00
6994	6994	\N	2009-01-01 00:00:00
6995	6995	\N	2009-01-01 00:00:00
6996	6996	\N	2009-01-01 00:00:00
6997	6997	\N	2009-01-01 00:00:00
6998	6998	\N	2009-01-01 00:00:00
6999	6999	\N	2009-01-01 00:00:00
7000	7000	\N	2009-01-01 00:00:00
7001	7001	\N	2009-01-01 00:00:00
7002	7002	\N	2009-01-01 00:00:00
7003	7003	\N	2009-01-01 00:00:00
7004	7004	\N	2009-01-01 00:00:00
7005	7005	\N	2009-01-01 00:00:00
7006	7006	\N	2009-01-01 00:00:00
7007	7007	\N	2009-01-01 00:00:00
7008	7008	\N	2009-01-01 00:00:00
7009	7009	\N	2009-01-01 00:00:00
7010	7010	\N	2009-01-01 00:00:00
7011	7011	\N	2009-01-01 00:00:00
7012	7012	\N	2009-01-01 00:00:00
7013	7013	\N	2009-01-01 00:00:00
7014	7014	\N	2009-01-01 00:00:00
7015	7015	\N	2009-01-01 00:00:00
7016	7016	\N	2009-01-01 00:00:00
7017	7017	\N	2009-01-01 00:00:00
7018	7018	\N	2009-01-01 00:00:00
7019	7019	\N	2009-01-01 00:00:00
7020	7020	\N	2009-01-01 00:00:00
7021	7021	\N	2009-01-01 00:00:00
7022	7022	\N	2009-01-01 00:00:00
7023	7023	\N	2009-01-01 00:00:00
7024	7024	\N	2009-01-01 00:00:00
7025	7025	\N	2009-01-01 00:00:00
7026	7026	\N	2009-01-01 00:00:00
7027	7027	\N	2009-01-01 00:00:00
7028	7028	\N	2009-01-01 00:00:00
7029	7029	\N	2009-01-01 00:00:00
7030	7030	\N	2009-01-01 00:00:00
7031	7031	\N	2009-01-01 00:00:00
7032	7032	\N	2009-01-01 00:00:00
7033	7033	\N	2009-01-01 00:00:00
7034	7034	\N	2009-01-01 00:00:00
7035	7035	\N	2009-01-01 00:00:00
7036	7036	\N	2009-01-01 00:00:00
7037	7037	\N	2009-01-01 00:00:00
7038	7038	\N	2009-01-01 00:00:00
7039	7039	\N	2009-01-01 00:00:00
7040	7040	\N	2009-01-01 00:00:00
7041	7041	\N	2009-01-01 00:00:00
7042	7042	\N	2009-01-01 00:00:00
7043	7043	\N	2009-01-01 00:00:00
7044	7044	\N	2009-01-01 00:00:00
7045	7045	\N	2009-01-01 00:00:00
7046	7046	\N	2009-01-01 00:00:00
7047	7047	\N	2009-01-01 00:00:00
7048	7048	\N	2009-01-01 00:00:00
7049	7049	\N	2009-01-01 00:00:00
7050	7050	\N	2009-01-01 00:00:00
7051	7051	\N	2009-01-01 00:00:00
7052	7052	\N	2009-01-01 00:00:00
7053	7053	\N	2009-01-01 00:00:00
7054	7054	\N	2009-01-01 00:00:00
7055	7055	\N	2009-01-01 00:00:00
7056	7056	\N	2009-01-01 00:00:00
7057	7057	\N	2009-01-01 00:00:00
7058	7058	\N	2009-01-01 00:00:00
7059	7059	\N	2009-01-01 00:00:00
7060	7060	\N	2009-01-01 00:00:00
7061	7061	\N	2009-01-01 00:00:00
7062	7062	\N	2009-01-01 00:00:00
7063	7063	\N	2009-01-01 00:00:00
7064	7064	\N	2009-01-01 00:00:00
7065	7065	\N	2009-01-01 00:00:00
7066	7066	\N	2009-01-01 00:00:00
7067	7067	\N	2009-01-01 00:00:00
7068	7068	\N	2009-01-01 00:00:00
7069	7069	\N	2009-01-01 00:00:00
7070	7070	\N	2009-01-01 00:00:00
7071	7071	\N	2009-01-01 00:00:00
7072	7072	\N	2009-01-01 00:00:00
7073	7073	\N	2009-01-01 00:00:00
7074	7074	\N	2009-01-01 00:00:00
7075	7075	\N	2009-01-01 00:00:00
7076	7076	\N	2009-01-01 00:00:00
7077	7077	\N	2009-01-01 00:00:00
7078	7078	\N	2009-01-01 00:00:00
7079	7079	\N	2009-01-01 00:00:00
7080	7080	\N	2009-01-01 00:00:00
7081	7081	\N	2009-01-01 00:00:00
7082	7082	\N	2009-01-01 00:00:00
7083	7083	\N	2009-01-01 00:00:00
7084	7084	\N	2009-01-01 00:00:00
7085	7085	\N	2009-01-01 00:00:00
7086	7086	\N	2009-01-01 00:00:00
7087	7087	\N	2009-01-01 00:00:00
7088	7088	\N	2009-01-01 00:00:00
7089	7089	\N	2009-01-01 00:00:00
7090	7090	\N	2009-01-01 00:00:00
7091	7091	\N	2009-01-01 00:00:00
7092	7092	\N	2009-01-01 00:00:00
7093	7093	\N	2009-01-01 00:00:00
7094	7094	\N	2009-01-01 00:00:00
7095	7095	\N	2009-01-01 00:00:00
7096	7096	\N	2009-01-01 00:00:00
7097	7097	\N	2009-01-01 00:00:00
7098	7098	\N	2009-01-01 00:00:00
7099	7099	\N	2009-01-01 00:00:00
7100	7100	\N	2009-01-01 00:00:00
7101	7101	\N	2009-01-01 00:00:00
7102	7102	\N	2009-01-01 00:00:00
7103	7103	\N	2009-01-01 00:00:00
7104	7104	\N	2009-01-01 00:00:00
7105	7105	\N	2009-01-01 00:00:00
7106	7106	\N	2009-01-01 00:00:00
7107	7107	\N	2009-01-01 00:00:00
7108	7108	\N	2009-01-01 00:00:00
7109	7109	\N	2009-01-01 00:00:00
7110	7110	\N	2009-01-01 00:00:00
7111	7111	\N	2009-01-01 00:00:00
7112	7112	\N	2009-01-01 00:00:00
7113	7113	\N	2009-01-01 00:00:00
7114	7114	\N	2009-01-01 00:00:00
7115	7115	\N	2009-01-01 00:00:00
7116	7116	\N	2009-01-01 00:00:00
7117	7117	\N	2009-01-01 00:00:00
7118	7118	\N	2009-01-01 00:00:00
7119	7119	\N	2009-01-01 00:00:00
7120	7120	\N	2009-01-01 00:00:00
7121	7121	\N	2009-01-01 00:00:00
7122	7122	\N	2009-01-01 00:00:00
7123	7123	\N	2009-01-01 00:00:00
7124	7124	\N	2009-01-01 00:00:00
7125	7125	\N	2009-01-01 00:00:00
7126	7126	\N	2009-01-01 00:00:00
7127	7127	\N	2009-01-01 00:00:00
7128	7128	\N	2009-01-01 00:00:00
7129	7129	\N	2009-01-01 00:00:00
7130	7130	\N	2009-01-01 00:00:00
7131	7131	\N	2009-01-01 00:00:00
7132	7132	\N	2009-01-01 00:00:00
7133	7133	\N	2009-01-01 00:00:00
7134	7134	\N	2009-01-01 00:00:00
7135	7135	\N	2009-01-01 00:00:00
7136	7136	\N	2009-01-01 00:00:00
7137	7137	\N	2009-01-01 00:00:00
7138	7138	\N	2009-01-01 00:00:00
7139	7139	\N	2009-01-01 00:00:00
7140	7140	\N	2009-01-01 00:00:00
7141	7141	\N	2009-01-01 00:00:00
7142	7142	\N	2009-01-01 00:00:00
7143	7143	\N	2009-01-01 00:00:00
7144	7144	\N	2009-01-01 00:00:00
7145	7145	\N	2009-01-01 00:00:00
7146	7146	\N	2009-01-01 00:00:00
7147	7147	\N	2009-01-01 00:00:00
7148	7148	\N	2009-01-01 00:00:00
7149	7149	\N	2009-01-01 00:00:00
7150	7150	\N	2009-01-01 00:00:00
7151	7151	\N	2009-01-01 00:00:00
7152	7152	\N	2009-01-01 00:00:00
7153	7153	\N	2009-01-01 00:00:00
7154	7154	\N	2009-01-01 00:00:00
7155	7155	\N	2009-01-01 00:00:00
7156	7156	\N	2009-01-01 00:00:00
7157	7157	\N	2009-01-01 00:00:00
7158	7158	\N	2009-01-01 00:00:00
7159	7159	\N	2009-01-01 00:00:00
7160	7160	\N	2009-01-01 00:00:00
7161	7161	\N	2009-01-01 00:00:00
7162	7162	\N	2009-01-01 00:00:00
7163	7163	\N	2009-01-01 00:00:00
7164	7164	\N	2009-01-01 00:00:00
7165	7165	\N	2009-01-01 00:00:00
7166	7166	\N	2009-01-01 00:00:00
7167	7167	\N	2009-01-01 00:00:00
7168	7168	\N	2009-01-01 00:00:00
7169	7169	\N	2009-01-01 00:00:00
7170	7170	\N	2009-01-01 00:00:00
7171	7171	\N	2009-01-01 00:00:00
7172	7172	\N	2009-01-01 00:00:00
7173	7173	\N	2009-01-01 00:00:00
7174	7174	\N	2009-01-01 00:00:00
7175	7175	\N	2009-01-01 00:00:00
7176	7176	\N	2009-01-01 00:00:00
7177	7177	\N	2009-01-01 00:00:00
7178	7178	\N	2009-01-01 00:00:00
7179	7179	\N	2009-01-01 00:00:00
7180	7180	\N	2009-01-01 00:00:00
7181	7181	\N	2009-01-01 00:00:00
7182	7182	\N	2009-01-01 00:00:00
7183	7183	\N	2009-01-01 00:00:00
7184	7184	\N	2009-01-01 00:00:00
7185	7185	\N	2009-01-01 00:00:00
7186	7186	\N	2009-01-01 00:00:00
7187	7187	\N	2009-01-01 00:00:00
7188	7188	\N	2009-01-01 00:00:00
7189	7189	\N	2009-01-01 00:00:00
7190	7190	\N	2009-01-01 00:00:00
7191	7191	\N	2009-01-01 00:00:00
7192	7192	\N	2009-01-01 00:00:00
7193	7193	\N	2009-01-01 00:00:00
7194	7194	\N	2009-01-01 00:00:00
7195	7195	\N	2009-01-01 00:00:00
7196	7196	\N	2009-01-01 00:00:00
7197	7197	\N	2009-01-01 00:00:00
7198	7198	\N	2009-01-01 00:00:00
7199	7199	\N	2009-01-01 00:00:00
7200	7200	\N	2009-01-01 00:00:00
7201	7201	\N	2009-01-01 00:00:00
7202	7202	\N	2009-01-01 00:00:00
7203	7203	\N	2009-01-01 00:00:00
7204	7204	\N	2009-01-01 00:00:00
7205	7205	\N	2009-01-01 00:00:00
7206	7206	\N	2009-01-01 00:00:00
7207	7207	\N	2009-01-01 00:00:00
7208	7208	\N	2009-01-01 00:00:00
7209	7209	\N	2009-01-01 00:00:00
7210	7210	\N	2009-01-01 00:00:00
7211	7211	\N	2009-01-01 00:00:00
7212	7212	\N	2009-01-01 00:00:00
7213	7213	\N	2009-01-01 00:00:00
7214	7214	\N	2009-01-01 00:00:00
7215	7215	\N	2009-01-01 00:00:00
7216	7216	\N	2009-01-01 00:00:00
7217	7217	\N	2009-01-01 00:00:00
7218	7218	\N	2009-01-01 00:00:00
7219	7219	\N	2009-01-01 00:00:00
7220	7220	\N	2009-01-01 00:00:00
7221	7221	\N	2009-01-01 00:00:00
7222	7222	\N	2009-01-01 00:00:00
7223	7223	\N	2009-01-01 00:00:00
7224	7224	\N	2009-01-01 00:00:00
7225	7225	\N	2009-01-01 00:00:00
7226	7226	\N	2009-01-01 00:00:00
7227	7227	\N	2009-01-01 00:00:00
7228	7228	\N	2009-01-01 00:00:00
7229	7229	\N	2009-01-01 00:00:00
7230	7230	\N	2009-01-01 00:00:00
7231	7231	\N	2009-01-01 00:00:00
7232	7232	\N	2009-01-01 00:00:00
7233	7233	\N	2009-01-01 00:00:00
7234	7234	\N	2009-01-01 00:00:00
7235	7235	\N	2009-01-01 00:00:00
7236	7236	\N	2009-01-01 00:00:00
7237	7237	\N	2009-01-01 00:00:00
7238	7238	\N	2009-01-01 00:00:00
7239	7239	\N	2009-01-01 00:00:00
7240	7240	\N	2009-01-01 00:00:00
7241	7241	\N	2009-01-01 00:00:00
7242	7242	\N	2009-01-01 00:00:00
7243	7243	\N	2009-01-01 00:00:00
7244	7244	\N	2009-01-01 00:00:00
7245	7245	\N	2009-01-01 00:00:00
7246	7246	\N	2009-01-01 00:00:00
7247	7247	\N	2009-01-01 00:00:00
7248	7248	\N	2009-01-01 00:00:00
7249	7249	\N	2009-01-01 00:00:00
7250	7250	\N	2009-01-01 00:00:00
7251	7251	\N	2009-01-01 00:00:00
7252	7252	\N	2009-01-01 00:00:00
7253	7253	\N	2009-01-01 00:00:00
7254	7254	\N	2009-01-01 00:00:00
7255	7255	\N	2009-01-01 00:00:00
7256	7256	\N	2009-01-01 00:00:00
7257	7257	\N	2009-01-01 00:00:00
7258	7258	\N	2009-01-01 00:00:00
7259	7259	\N	2009-01-01 00:00:00
7260	7260	\N	2009-01-01 00:00:00
7261	7261	\N	2009-01-01 00:00:00
7262	7262	\N	2009-01-01 00:00:00
7263	7263	\N	2009-01-01 00:00:00
7264	7264	\N	2009-01-01 00:00:00
7265	7265	\N	2009-01-01 00:00:00
7266	7266	\N	2009-01-01 00:00:00
7267	7267	\N	2009-01-01 00:00:00
7268	7268	\N	2009-01-01 00:00:00
7269	7269	\N	2009-01-01 00:00:00
7270	7270	\N	2009-01-01 00:00:00
7271	7271	\N	2009-01-01 00:00:00
7272	7272	\N	2009-01-01 00:00:00
7273	7273	\N	2009-01-01 00:00:00
7274	7274	\N	2009-01-01 00:00:00
7275	7275	\N	2009-01-01 00:00:00
7276	7276	\N	2009-01-01 00:00:00
7277	7277	\N	2009-01-01 00:00:00
7278	7278	\N	2009-01-01 00:00:00
7279	7279	\N	2009-01-01 00:00:00
7280	7280	\N	2009-01-01 00:00:00
7281	7281	\N	2009-01-01 00:00:00
7282	7282	\N	2009-01-01 00:00:00
7283	7283	\N	2009-01-01 00:00:00
7284	7284	\N	2009-01-01 00:00:00
7285	7285	\N	2009-01-01 00:00:00
7286	7286	\N	2009-01-01 00:00:00
7287	7287	\N	2009-01-01 00:00:00
7288	7288	\N	2009-01-01 00:00:00
7289	7289	\N	2009-01-01 00:00:00
7290	7290	\N	2009-01-01 00:00:00
7291	7291	\N	2009-01-01 00:00:00
7292	7292	\N	2009-01-01 00:00:00
7293	7293	\N	2009-01-01 00:00:00
7294	7294	\N	2009-01-01 00:00:00
7295	7295	\N	2009-01-01 00:00:00
7296	7296	\N	2009-01-01 00:00:00
7297	7297	\N	2009-01-01 00:00:00
7298	7298	\N	2009-01-01 00:00:00
7299	7299	\N	2009-01-01 00:00:00
7300	7300	\N	2009-01-01 00:00:00
7301	7301	\N	2009-01-01 00:00:00
7302	7302	\N	2009-01-01 00:00:00
7303	7303	\N	2009-01-01 00:00:00
7304	7304	\N	2009-01-01 00:00:00
7305	7305	\N	2009-01-01 00:00:00
7306	7306	\N	2009-01-01 00:00:00
7307	7307	\N	2009-01-01 00:00:00
7308	7308	\N	2009-01-01 00:00:00
7309	7309	\N	2009-01-01 00:00:00
7310	7310	\N	2009-01-01 00:00:00
7311	7311	\N	2009-01-01 00:00:00
7312	7312	\N	2009-01-01 00:00:00
7313	7313	\N	2009-01-01 00:00:00
7314	7314	\N	2009-01-01 00:00:00
7315	7315	\N	2009-01-01 00:00:00
7316	7316	\N	2009-01-01 00:00:00
7317	7317	\N	2009-01-01 00:00:00
7318	7318	\N	2009-01-01 00:00:00
7319	7319	\N	2009-01-01 00:00:00
7320	7320	\N	2009-01-01 00:00:00
7321	7321	\N	2009-01-01 00:00:00
7322	7322	\N	2009-01-01 00:00:00
7323	7323	\N	2009-01-01 00:00:00
7324	7324	\N	2009-01-01 00:00:00
7325	7325	\N	2009-01-01 00:00:00
7326	7326	\N	2009-01-01 00:00:00
7327	7327	\N	2009-01-01 00:00:00
7328	7328	\N	2009-01-01 00:00:00
7329	7329	\N	2009-01-01 00:00:00
7330	7330	\N	2009-01-01 00:00:00
7331	7331	\N	2009-01-01 00:00:00
7332	7332	\N	2009-01-01 00:00:00
7333	7333	\N	2009-01-01 00:00:00
7334	7334	\N	2009-01-01 00:00:00
7335	7335	\N	2009-01-01 00:00:00
7336	7336	\N	2009-01-01 00:00:00
7337	7337	\N	2009-01-01 00:00:00
7338	7338	\N	2009-01-01 00:00:00
7339	7339	\N	2009-01-01 00:00:00
7340	7340	\N	2009-01-01 00:00:00
7341	7341	\N	2009-01-01 00:00:00
7342	7342	\N	2009-01-01 00:00:00
7343	7343	\N	2009-01-01 00:00:00
7344	7344	\N	2009-01-01 00:00:00
7345	7345	\N	2009-01-01 00:00:00
7346	7346	\N	2009-01-01 00:00:00
7347	7347	\N	2009-01-01 00:00:00
7348	7348	\N	2009-01-01 00:00:00
7349	7349	\N	2009-01-01 00:00:00
7350	7350	\N	2009-01-01 00:00:00
7351	7351	\N	2009-01-01 00:00:00
7352	7352	\N	2009-01-01 00:00:00
7353	7353	\N	2009-01-01 00:00:00
7354	7354	\N	2009-01-01 00:00:00
7355	7355	\N	2009-01-01 00:00:00
7356	7356	\N	2009-01-01 00:00:00
7357	7357	\N	2009-01-01 00:00:00
7358	7358	\N	2009-01-01 00:00:00
7359	7359	\N	2009-01-01 00:00:00
7360	7360	\N	2009-01-01 00:00:00
7361	7361	\N	2009-01-01 00:00:00
7362	7362	\N	2009-01-01 00:00:00
7363	7363	\N	2009-01-01 00:00:00
7364	7364	\N	2009-01-01 00:00:00
7365	7365	\N	2009-01-01 00:00:00
7366	7366	\N	2009-01-01 00:00:00
7367	7367	\N	2009-01-01 00:00:00
7368	7368	\N	2009-01-01 00:00:00
7369	7369	\N	2009-01-01 00:00:00
7370	7370	\N	2009-01-01 00:00:00
7371	7371	\N	2009-01-01 00:00:00
7372	7372	\N	2009-01-01 00:00:00
7373	7373	\N	2009-01-01 00:00:00
7374	7374	\N	2009-01-01 00:00:00
7375	7375	\N	2009-01-01 00:00:00
7376	7376	\N	2009-01-01 00:00:00
7377	7377	\N	2009-01-01 00:00:00
7378	7378	\N	2009-01-01 00:00:00
7379	7379	\N	2009-01-01 00:00:00
7380	7380	\N	2009-01-01 00:00:00
7381	7381	\N	2009-01-01 00:00:00
7382	7382	\N	2009-01-01 00:00:00
7383	7383	\N	2009-01-01 00:00:00
7384	7384	\N	2009-01-01 00:00:00
7385	7385	\N	2009-01-01 00:00:00
7386	7386	\N	2009-01-01 00:00:00
7387	7387	\N	2009-01-01 00:00:00
7388	7388	\N	2009-01-01 00:00:00
7389	7389	\N	2009-01-01 00:00:00
7390	7390	\N	2009-01-01 00:00:00
7391	7391	\N	2009-01-01 00:00:00
7392	7392	\N	2009-01-01 00:00:00
7393	7393	\N	2009-01-01 00:00:00
7394	7394	\N	2009-01-01 00:00:00
7395	7395	\N	2009-01-01 00:00:00
7396	7396	\N	2009-01-01 00:00:00
7397	7397	\N	2009-01-01 00:00:00
7398	7398	\N	2009-01-01 00:00:00
7399	7399	\N	2009-01-01 00:00:00
7400	7400	\N	2009-01-01 00:00:00
7401	7401	\N	2009-01-01 00:00:00
7402	7402	\N	2009-01-01 00:00:00
7403	7403	\N	2009-01-01 00:00:00
7404	7404	\N	2009-01-01 00:00:00
7405	7405	\N	2009-01-01 00:00:00
7406	7406	\N	2009-01-01 00:00:00
7407	7407	\N	2009-01-01 00:00:00
7408	7408	\N	2009-01-01 00:00:00
7409	7409	\N	2009-01-01 00:00:00
7410	7410	\N	2009-01-01 00:00:00
7411	7411	\N	2009-01-01 00:00:00
7412	7412	\N	2009-01-01 00:00:00
7413	7413	\N	2009-01-01 00:00:00
7414	7414	\N	2009-01-01 00:00:00
7415	7415	\N	2009-01-01 00:00:00
7416	7416	\N	2009-01-01 00:00:00
7417	7417	\N	2009-01-01 00:00:00
7418	7418	\N	2009-01-01 00:00:00
7419	7419	\N	2009-01-01 00:00:00
7420	7420	\N	2009-01-01 00:00:00
7421	7421	\N	2009-01-01 00:00:00
7422	7422	\N	2009-01-01 00:00:00
7423	7423	\N	2009-01-01 00:00:00
7424	7424	\N	2009-01-01 00:00:00
7425	7425	\N	2009-01-01 00:00:00
7426	7426	\N	2009-01-01 00:00:00
7427	7427	\N	2009-01-01 00:00:00
7428	7428	\N	2009-01-01 00:00:00
7429	7429	\N	2009-01-01 00:00:00
7430	7430	\N	2009-01-01 00:00:00
7431	7431	\N	2009-01-01 00:00:00
7432	7432	\N	2009-01-01 00:00:00
7433	7433	\N	2009-01-01 00:00:00
7434	7434	\N	2009-01-01 00:00:00
7435	7435	\N	2009-01-01 00:00:00
7436	7436	\N	2009-01-01 00:00:00
7437	7437	\N	2009-01-01 00:00:00
7438	7438	\N	2009-01-01 00:00:00
7439	7439	\N	2009-01-01 00:00:00
7440	7440	\N	2009-01-01 00:00:00
7441	7441	\N	2009-01-01 00:00:00
7442	7442	\N	2009-01-01 00:00:00
7443	7443	\N	2009-01-01 00:00:00
7444	7444	\N	2009-01-01 00:00:00
7445	7445	\N	2009-01-01 00:00:00
7446	7446	\N	2009-01-01 00:00:00
7447	7447	\N	2009-01-01 00:00:00
7448	7448	\N	2009-01-01 00:00:00
7449	7449	\N	2009-01-01 00:00:00
7450	7450	\N	2009-01-01 00:00:00
7451	7451	\N	2009-01-01 00:00:00
7452	7452	\N	2009-01-01 00:00:00
7453	7453	\N	2009-01-01 00:00:00
7454	7454	\N	2009-01-01 00:00:00
7455	7455	\N	2009-01-01 00:00:00
7456	7456	\N	2009-01-01 00:00:00
7457	7457	\N	2009-01-01 00:00:00
7458	7458	\N	2009-01-01 00:00:00
7459	7459	\N	2009-01-01 00:00:00
7460	7460	\N	2009-01-01 00:00:00
7461	7461	\N	2009-01-01 00:00:00
7462	7462	\N	2009-01-01 00:00:00
7463	7463	\N	2009-01-01 00:00:00
7464	7464	\N	2009-01-01 00:00:00
7465	7465	\N	2009-01-01 00:00:00
7466	7466	\N	2009-01-01 00:00:00
7467	7467	\N	2009-01-01 00:00:00
7468	7468	\N	2009-01-01 00:00:00
7469	7469	\N	2009-01-01 00:00:00
7470	7470	\N	2009-01-01 00:00:00
7471	7471	\N	2009-01-01 00:00:00
7472	7472	\N	2009-01-01 00:00:00
7473	7473	\N	2009-01-01 00:00:00
7474	7474	\N	2009-01-01 00:00:00
7475	7475	\N	2009-01-01 00:00:00
7476	7476	\N	2009-01-01 00:00:00
7477	7477	\N	2009-01-01 00:00:00
7478	7478	\N	2009-01-01 00:00:00
7479	7479	\N	2009-01-01 00:00:00
7480	7480	\N	2009-01-01 00:00:00
7481	7481	\N	2009-01-01 00:00:00
7482	7482	\N	2009-01-01 00:00:00
7483	7483	\N	2009-01-01 00:00:00
7484	7484	\N	2009-01-01 00:00:00
7485	7485	\N	2009-01-01 00:00:00
7486	7486	\N	2009-01-01 00:00:00
7487	7487	\N	2009-01-01 00:00:00
7488	7488	\N	2009-01-01 00:00:00
7489	7489	\N	2009-01-01 00:00:00
7490	7490	\N	2009-01-01 00:00:00
7491	7491	\N	2009-01-01 00:00:00
7492	7492	\N	2009-01-01 00:00:00
7493	7493	\N	2009-01-01 00:00:00
7494	7494	\N	2009-01-01 00:00:00
7495	7495	\N	2009-01-01 00:00:00
7496	7496	\N	2009-01-01 00:00:00
7497	7497	\N	2009-01-01 00:00:00
7498	7498	\N	2009-01-01 00:00:00
7499	7499	\N	2009-01-01 00:00:00
7500	7500	\N	2009-01-01 00:00:00
7501	7501	\N	2009-01-01 00:00:00
7502	7502	\N	2009-01-01 00:00:00
7503	7503	\N	2009-01-01 00:00:00
7504	7504	\N	2009-01-01 00:00:00
7505	7505	\N	2009-01-01 00:00:00
7506	7506	\N	2009-01-01 00:00:00
7507	7507	\N	2009-01-01 00:00:00
7508	7508	\N	2009-01-01 00:00:00
7509	7509	\N	2009-01-01 00:00:00
7510	7510	\N	2009-01-01 00:00:00
7511	7511	\N	2009-01-01 00:00:00
7512	7512	\N	2009-01-01 00:00:00
7513	7513	\N	2009-01-01 00:00:00
7514	7514	\N	2009-01-01 00:00:00
7515	7515	\N	2009-01-01 00:00:00
7516	7516	\N	2009-01-01 00:00:00
7517	7517	\N	2009-01-01 00:00:00
7518	7518	\N	2009-01-01 00:00:00
7519	7519	\N	2009-01-01 00:00:00
7520	7520	\N	2009-01-01 00:00:00
7521	7521	\N	2009-01-01 00:00:00
7522	7522	\N	2009-01-01 00:00:00
7523	7523	\N	2009-01-01 00:00:00
7524	7524	\N	2009-01-01 00:00:00
7525	7525	\N	2009-01-01 00:00:00
7526	7526	\N	2009-01-01 00:00:00
7527	7527	\N	2009-01-01 00:00:00
7528	7528	\N	2009-01-01 00:00:00
7529	7529	\N	2009-01-01 00:00:00
7530	7530	\N	2009-01-01 00:00:00
7531	7531	\N	2009-01-01 00:00:00
7532	7532	\N	2009-01-01 00:00:00
7533	7533	\N	2009-01-01 00:00:00
7534	7534	\N	2009-01-01 00:00:00
7535	7535	\N	2009-01-01 00:00:00
7536	7536	\N	2009-01-01 00:00:00
7537	7537	\N	2009-01-01 00:00:00
7538	7538	\N	2009-01-01 00:00:00
7539	7539	\N	2009-01-01 00:00:00
7540	7540	\N	2009-01-01 00:00:00
7541	7541	\N	2009-01-01 00:00:00
7542	7542	\N	2009-01-01 00:00:00
7543	7543	\N	2009-01-01 00:00:00
7544	7544	\N	2009-01-01 00:00:00
7545	7545	\N	2009-01-01 00:00:00
7546	7546	\N	2009-01-01 00:00:00
7547	7547	\N	2009-01-01 00:00:00
7548	7548	\N	2009-01-01 00:00:00
7549	7549	\N	2009-01-01 00:00:00
7550	7550	\N	2009-01-01 00:00:00
7551	7551	\N	2009-01-01 00:00:00
7552	7552	\N	2009-01-01 00:00:00
7553	7553	\N	2009-01-01 00:00:00
7554	7554	\N	2009-01-01 00:00:00
7555	7555	\N	2009-01-01 00:00:00
7556	7556	\N	2009-01-01 00:00:00
7557	7557	\N	2009-01-01 00:00:00
7558	7558	\N	2009-01-01 00:00:00
7559	7559	\N	2009-01-01 00:00:00
7560	7560	\N	2009-01-01 00:00:00
7561	7561	\N	2009-01-01 00:00:00
7562	7562	\N	2009-01-01 00:00:00
7563	7563	\N	2009-01-01 00:00:00
7564	7564	\N	2009-01-01 00:00:00
7565	7565	\N	2009-01-01 00:00:00
7566	7566	\N	2009-01-01 00:00:00
7567	7567	\N	2009-01-01 00:00:00
7568	7568	\N	2009-01-01 00:00:00
7569	7569	\N	2009-01-01 00:00:00
7570	7570	\N	2009-01-01 00:00:00
7571	7571	\N	2009-01-01 00:00:00
7572	7572	\N	2009-01-01 00:00:00
7573	7573	\N	2009-01-01 00:00:00
7574	7574	\N	2009-01-01 00:00:00
7575	7575	\N	2009-01-01 00:00:00
7576	7576	\N	2009-01-01 00:00:00
7577	7577	\N	2009-01-01 00:00:00
7578	7578	\N	2009-01-01 00:00:00
7579	7579	\N	2009-01-01 00:00:00
7580	7580	\N	2009-01-01 00:00:00
7581	7581	\N	2009-01-01 00:00:00
7582	7582	\N	2009-01-01 00:00:00
7583	7583	\N	2009-01-01 00:00:00
7584	7584	\N	2009-01-01 00:00:00
7585	7585	\N	2009-01-01 00:00:00
7586	7586	\N	2009-01-01 00:00:00
7587	7587	\N	2009-01-01 00:00:00
7588	7588	\N	2009-01-01 00:00:00
7589	7589	\N	2009-01-01 00:00:00
7590	7590	\N	2009-01-01 00:00:00
7591	7591	\N	2009-01-01 00:00:00
7592	7592	\N	2009-01-01 00:00:00
7593	7593	\N	2009-01-01 00:00:00
7594	7594	\N	2009-01-01 00:00:00
7595	7595	\N	2009-01-01 00:00:00
7596	7596	\N	2009-01-01 00:00:00
7597	7597	\N	2009-01-01 00:00:00
7598	7598	\N	2009-01-01 00:00:00
7599	7599	\N	2009-01-01 00:00:00
7600	7600	\N	2009-01-01 00:00:00
7601	7601	\N	2009-01-01 00:00:00
7602	7602	\N	2009-01-01 00:00:00
7603	7603	\N	2009-01-01 00:00:00
7604	7604	\N	2009-01-01 00:00:00
7605	7605	\N	2009-01-01 00:00:00
7606	7606	\N	2009-01-01 00:00:00
7607	7607	\N	2009-01-01 00:00:00
7608	7608	\N	2009-01-01 00:00:00
7609	7609	\N	2009-01-01 00:00:00
7610	7610	\N	2009-01-01 00:00:00
7611	7611	\N	2009-01-01 00:00:00
7612	7612	\N	2009-01-01 00:00:00
7613	7613	\N	2009-01-01 00:00:00
7614	7614	\N	2009-01-01 00:00:00
7615	7615	\N	2009-01-01 00:00:00
7616	7616	\N	2009-01-01 00:00:00
7617	7617	\N	2009-01-01 00:00:00
7618	7618	\N	2009-01-01 00:00:00
7619	7619	\N	2009-01-01 00:00:00
7620	7620	\N	2009-01-01 00:00:00
7621	7621	\N	2009-01-01 00:00:00
7622	7622	\N	2009-01-01 00:00:00
7623	7623	\N	2009-01-01 00:00:00
7624	7624	\N	2009-01-01 00:00:00
7625	7625	\N	2009-01-01 00:00:00
7626	7626	\N	2009-01-01 00:00:00
7627	7627	\N	2009-01-01 00:00:00
7628	7628	\N	2009-01-01 00:00:00
7629	7629	\N	2009-01-01 00:00:00
7630	7630	\N	2009-01-01 00:00:00
7631	7631	\N	2009-01-01 00:00:00
7632	7632	\N	2009-01-01 00:00:00
7633	7633	\N	2009-01-01 00:00:00
7634	7634	\N	2009-01-01 00:00:00
7635	7635	\N	2009-01-01 00:00:00
7636	7636	\N	2009-01-01 00:00:00
7637	7637	\N	2009-01-01 00:00:00
7638	7638	\N	2009-01-01 00:00:00
7639	7639	\N	2009-01-01 00:00:00
7640	7640	\N	2009-01-01 00:00:00
7641	7641	\N	2009-01-01 00:00:00
7642	7642	\N	2009-01-01 00:00:00
7643	7643	\N	2009-01-01 00:00:00
7644	7644	\N	2009-01-01 00:00:00
7645	7645	\N	2009-01-01 00:00:00
7646	7646	\N	2009-01-01 00:00:00
7647	7647	\N	2009-01-01 00:00:00
7648	7648	\N	2009-01-01 00:00:00
7649	7649	\N	2009-01-01 00:00:00
7650	7650	\N	2009-01-01 00:00:00
7651	7651	\N	2009-01-01 00:00:00
7652	7652	\N	2009-01-01 00:00:00
7653	7653	\N	2009-01-01 00:00:00
7654	7654	\N	2009-01-01 00:00:00
7655	7655	\N	2009-01-01 00:00:00
7656	7656	\N	2009-01-01 00:00:00
7657	7657	\N	2009-01-01 00:00:00
7658	7658	\N	2009-01-01 00:00:00
7659	7659	\N	2009-01-01 00:00:00
7660	7660	\N	2009-01-01 00:00:00
7661	7661	\N	2009-01-01 00:00:00
7662	7662	\N	2009-01-01 00:00:00
7663	7663	\N	2009-01-01 00:00:00
7664	7664	\N	2009-01-01 00:00:00
7665	7665	\N	2009-01-01 00:00:00
7666	7666	\N	2009-01-01 00:00:00
7667	7667	\N	2009-01-01 00:00:00
7668	7668	\N	2009-01-01 00:00:00
7669	7669	\N	2009-01-01 00:00:00
7670	7670	\N	2009-01-01 00:00:00
7671	7671	\N	2009-01-01 00:00:00
7672	7672	\N	2009-01-01 00:00:00
7673	7673	\N	2009-01-01 00:00:00
7674	7674	\N	2009-01-01 00:00:00
7675	7675	\N	2009-01-01 00:00:00
7676	7676	\N	2009-01-01 00:00:00
7677	7677	\N	2009-01-01 00:00:00
7678	7678	\N	2009-01-01 00:00:00
7679	7679	\N	2009-01-01 00:00:00
7680	7680	\N	2009-01-01 00:00:00
7681	7681	\N	2009-01-01 00:00:00
7682	7682	\N	2009-01-01 00:00:00
7683	7683	\N	2009-01-01 00:00:00
7684	7684	\N	2009-01-01 00:00:00
7685	7685	\N	2009-01-01 00:00:00
7686	7686	\N	2009-01-01 00:00:00
7687	7687	\N	2009-01-01 00:00:00
7688	7688	\N	2009-01-01 00:00:00
7689	7689	\N	2009-01-01 00:00:00
7690	7690	\N	2009-01-01 00:00:00
7691	7691	\N	2009-01-01 00:00:00
7692	7692	\N	2009-01-01 00:00:00
7693	7693	\N	2009-01-01 00:00:00
7694	7694	\N	2009-01-01 00:00:00
7695	7695	\N	2009-01-01 00:00:00
7696	7696	\N	2009-01-01 00:00:00
7697	7697	\N	2009-01-01 00:00:00
7698	7698	\N	2009-01-01 00:00:00
7699	7699	\N	2009-01-01 00:00:00
7700	7700	\N	2009-01-01 00:00:00
7701	7701	\N	2009-01-01 00:00:00
7702	7702	\N	2009-01-01 00:00:00
7703	7703	\N	2009-01-01 00:00:00
7704	7704	\N	2009-01-01 00:00:00
7705	7705	\N	2009-01-01 00:00:00
7706	7706	\N	2009-01-01 00:00:00
7707	7707	\N	2009-01-01 00:00:00
7708	7708	\N	2009-01-01 00:00:00
7709	7709	\N	2009-01-01 00:00:00
7710	7710	\N	2009-01-01 00:00:00
7711	7711	\N	2009-01-01 00:00:00
7712	7712	\N	2009-01-01 00:00:00
7713	7713	\N	2009-01-01 00:00:00
7714	7714	\N	2009-01-01 00:00:00
7715	7715	\N	2009-01-01 00:00:00
7716	7716	\N	2009-01-01 00:00:00
7717	7717	\N	2009-01-01 00:00:00
7718	7718	\N	2009-01-01 00:00:00
7719	7719	\N	2009-01-01 00:00:00
7720	7720	\N	2009-01-01 00:00:00
7721	7721	\N	2009-01-01 00:00:00
7722	7722	\N	2009-01-01 00:00:00
7723	7723	\N	2009-01-01 00:00:00
7724	7724	\N	2009-01-01 00:00:00
7725	7725	\N	2009-01-01 00:00:00
7726	7726	\N	2009-01-01 00:00:00
7727	7727	\N	2009-01-01 00:00:00
7728	7728	\N	2009-01-01 00:00:00
7729	7729	\N	2009-01-01 00:00:00
7730	7730	\N	2009-01-01 00:00:00
7731	7731	\N	2009-01-01 00:00:00
7732	7732	\N	2009-01-01 00:00:00
7733	7733	\N	2009-01-01 00:00:00
7734	7734	\N	2009-01-01 00:00:00
7735	7735	\N	2009-01-01 00:00:00
7736	7736	\N	2009-01-01 00:00:00
7737	7737	\N	2009-01-01 00:00:00
7738	7738	\N	2009-01-01 00:00:00
7739	7739	\N	2009-01-01 00:00:00
7740	7740	\N	2009-01-01 00:00:00
7741	7741	\N	2009-01-01 00:00:00
7742	7742	\N	2009-01-01 00:00:00
7743	7743	\N	2009-01-01 00:00:00
7744	7744	\N	2009-01-01 00:00:00
7745	7745	\N	2009-01-01 00:00:00
7746	7746	\N	2009-01-01 00:00:00
7747	7747	\N	2009-01-01 00:00:00
7748	7748	\N	2009-01-01 00:00:00
7749	7749	\N	2009-01-01 00:00:00
7750	7750	\N	2009-01-01 00:00:00
7751	7751	\N	2009-01-01 00:00:00
7752	7752	\N	2009-01-01 00:00:00
7753	7753	\N	2009-01-01 00:00:00
7754	7754	\N	2009-01-01 00:00:00
7755	7755	\N	2009-01-01 00:00:00
7756	7756	\N	2009-01-01 00:00:00
7757	7757	\N	2009-01-01 00:00:00
7758	7758	\N	2009-01-01 00:00:00
7759	7759	\N	2009-01-01 00:00:00
7760	7760	\N	2009-01-01 00:00:00
7761	7761	\N	2009-01-01 00:00:00
7762	7762	\N	2009-01-01 00:00:00
7763	7763	\N	2009-01-01 00:00:00
7764	7764	\N	2009-01-01 00:00:00
7765	7765	\N	2009-01-01 00:00:00
7766	7766	\N	2009-01-01 00:00:00
7767	7767	\N	2009-01-01 00:00:00
7768	7768	\N	2009-01-01 00:00:00
7769	7769	\N	2009-01-01 00:00:00
7770	7770	\N	2009-01-01 00:00:00
7771	7771	\N	2009-01-01 00:00:00
7772	7772	\N	2009-01-01 00:00:00
7773	7773	\N	2009-01-01 00:00:00
7774	7774	\N	2009-01-01 00:00:00
7775	7775	\N	2009-01-01 00:00:00
7776	7776	\N	2009-01-01 00:00:00
7777	7777	\N	2009-01-01 00:00:00
7778	7778	\N	2009-01-01 00:00:00
7779	7779	\N	2009-01-01 00:00:00
7780	7780	\N	2009-01-01 00:00:00
7781	7781	\N	2009-01-01 00:00:00
7782	7782	\N	2009-01-01 00:00:00
7783	7783	\N	2009-01-01 00:00:00
7784	7784	\N	2009-01-01 00:00:00
7785	7785	\N	2009-01-01 00:00:00
7786	7786	\N	2009-01-01 00:00:00
7787	7787	\N	2009-01-01 00:00:00
7788	7788	\N	2009-01-01 00:00:00
\.


--
-- Data for Name: conceptname; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY conceptname (conceptname, conceptid_fk, author, nametype, id, last_updated_time) FROM stdin;
snake-prickleback	4745	unknown	Common	6841	2009-01-01 00:00:00
lumpenus-sagitta	4745	Wilimovsky, 1956	Synonym	6842	2009-01-01 00:00:00
Poroclinus	4746	unknown	Primary	6843	2009-01-01 00:00:00
poroclinus	4746	unknown	Synonym	6844	2009-01-01 00:00:00
Poroclinus rothrocki	4747	Bean, 1890	Primary	6845	2009-01-01 00:00:00
whitebarred-prickleback	4747	unknown	Common	6846	2009-01-01 00:00:00
poroclinus-rothrocki	4747	Bean, 1890	Synonym	6847	2009-01-01 00:00:00
Anoplarchus	4748	unknown	Primary	6848	2009-01-01 00:00:00
anoplarchus	4748	unknown	Synonym	6849	2009-01-01 00:00:00
Anoplarchus purpurescens	4749	Gill, 1861	Primary	6850	2009-01-01 00:00:00
high-cockscomb-prickleback	4749	unknown	Common	6851	2009-01-01 00:00:00
anoplarchus-purpurescens	4749	Gill, 1861	Synonym	6852	2009-01-01 00:00:00
Zaproridae	4750	unknown	Primary	6853	2009-01-01 00:00:00
zaproridae	4750	unknown	Synonym	6854	2009-01-01 00:00:00
Zaprora	4751	unknown	Primary	6855	2009-01-01 00:00:00
zaprora	4751	unknown	Synonym	6856	2009-01-01 00:00:00
Zaprora silenus	4752	Jordan, 1896	Primary	6857	2009-01-01 00:00:00
prowfish	4752	unknown	Common	6858	2009-01-01 00:00:00
zaprora-silenus	4752	Jordan, 1896	Synonym	6859	2009-01-01 00:00:00
Anarhichadidae	4753	unknown	Primary	6860	2009-01-01 00:00:00
wolffish	4753	shiino, 1978	Common	6861	2009-01-01 00:00:00
anarhichadidae	4753	unknown	Synonym	6862	2009-01-01 00:00:00
Anarrhichthys	4754	unknown	Primary	6863	2009-01-01 00:00:00
anarrhichthys	4754	unknown	Synonym	6864	2009-01-01 00:00:00
Anarrhichthys ocellatus	4755	ayres	Primary	6865	2009-01-01 00:00:00
wolf-eel	4755	amer. fisheries society, 1980	Common	6866	2009-01-01 00:00:00
anarrhichthys-ocellatus	4755	ayres	Synonym	6867	2009-01-01 00:00:00
Percoidei	4756	unknown	Primary	6868	2009-01-01 00:00:00
percoidei	4756	unknown	Synonym	6869	2009-01-01 00:00:00
Haemulidae	4757	unknown	Primary	6870	2009-01-01 00:00:00
grunt	4757	unknown	Common	6871	2009-01-01 00:00:00
haemulidae	4757	unknown	Synonym	6872	2009-01-01 00:00:00
Xenistius	4758	unknown	Primary	6873	2009-01-01 00:00:00
xenistius	4758	unknown	Synonym	6874	2009-01-01 00:00:00
Xenistius californiensis	4759	(Steindachner, 1876)	Primary	6875	2009-01-01 00:00:00
california-salema	4759	unknown	Common	6876	2009-01-01 00:00:00
xenistius-californiensis	4759	(Steindachner, 1876)	Synonym	6877	2009-01-01 00:00:00
Anisotremus	4760	unknown	Primary	6878	2009-01-01 00:00:00
anisotremus	4760	unknown	Synonym	6879	2009-01-01 00:00:00
Anisotremus davidsonii	4761	(Steindachner, 1876)	Primary	6880	2009-01-01 00:00:00
xantic-sargo	4761	unknown	Common	6881	2009-01-01 00:00:00
anisotremus-davidsonii	4761	(Steindachner, 1876)	Synonym	6882	2009-01-01 00:00:00
Chaetodontidae	4762	unknown	Primary	6883	2009-01-01 00:00:00
butterflyfish	4762	unknown	Common	6884	2009-01-01 00:00:00
object	3734	\N	Primary	4916	2009-01-01 00:00:00
root	3734	jana	Synonym	4917	2009-01-01 00:00:00
ocean region	3735	unknown	Primary	4918	2009-01-01 00:00:00
behavior	3736	unknown	Primary	4919	2009-01-01 00:00:00
lying-atop	3737	unknown	Primary	4920	2009-01-01 00:00:00
swimming	3738	unknown	Primary	4921	2009-01-01 00:00:00
diving	3739	unknown	Primary	4922	2009-01-01 00:00:00
catching	3740	unknown	Primary	4923	2009-01-01 00:00:00
parachuting	3741	unknown	Primary	4924	2009-01-01 00:00:00
curling around	3742	unknown	Primary	4925	2009-01-01 00:00:00
curling-around	3742	unknown	Synonym	4926	2009-01-01 00:00:00
venting	3743	unknown	Primary	4927	2009-01-01 00:00:00
reproducing	3744	unknown	Primary	4928	2009-01-01 00:00:00
grooming	3745	unknown	Primary	4929	2009-01-01 00:00:00
somersaulting	3746	unknown	Primary	4930	2009-01-01 00:00:00
fishing	3747	unknown	Primary	4931	2009-01-01 00:00:00
curling	3748	unknown	Primary	4932	2009-01-01 00:00:00
hanging	3749	unknown	Primary	4933	2009-01-01 00:00:00
rotating	3750	unknown	Primary	4934	2009-01-01 00:00:00
regenerate	3751	unknown	Primary	4935	2009-01-01 00:00:00
walking	3752	unknown	Primary	4936	2009-01-01 00:00:00
bubbling	3753	unknown	Primary	4937	2009-01-01 00:00:00
schooling	3754	unknown	Primary	4938	2009-01-01 00:00:00
feeding	3755	unknown	Primary	4939	2009-01-01 00:00:00
changing	3756	unknown	Primary	4940	2009-01-01 00:00:00
swarming	3757	unknown	Primary	4941	2009-01-01 00:00:00
respiring	3758	unknown	Primary	4942	2009-01-01 00:00:00
pulsing	3759	unknown	Primary	4943	2009-01-01 00:00:00
shimmering	3760	unknown	Primary	4944	2009-01-01 00:00:00
hopping	3761	unknown	Primary	4945	2009-01-01 00:00:00
hiding	3762	unknown	Primary	4946	2009-01-01 00:00:00
elking	3763	unknown	Primary	4947	2009-01-01 00:00:00
attaching	3764	unknown	Primary	4948	2009-01-01 00:00:00
pursuing	3765	unknown	Primary	4949	2009-01-01 00:00:00
mating	3766	unknown	Primary	4950	2009-01-01 00:00:00
extending	3767	unknown	Primary	4951	2009-01-01 00:00:00
colliding	3768	unknown	Primary	4952	2009-01-01 00:00:00
active	3769	unknown	Primary	4953	2009-01-01 00:00:00
sitting-in	3770	unknown	Primary	4954	2009-01-01 00:00:00
raiding	3771	unknown	Primary	4955	2009-01-01 00:00:00
spawning	3772	unknown	Primary	4956	2009-01-01 00:00:00
arrange	3773	unknown	Primary	4957	2009-01-01 00:00:00
bioluminesce	3774	unknown	Primary	4958	2009-01-01 00:00:00
puckering	3775	unknown	Primary	4959	2009-01-01 00:00:00
waving	3776	unknown	Primary	4960	2009-01-01 00:00:00
jettisoning	3777	unknown	Primary	4961	2009-01-01 00:00:00
free-swimming	3778	unknown	Primary	4962	2009-01-01 00:00:00
kissing	3779	unknown	Primary	4963	2009-01-01 00:00:00
damaged	3780	unknown	Primary	4964	2009-01-01 00:00:00
inhabiting	3781	unknown	Primary	4965	2009-01-01 00:00:00
retreating	3782	unknown	Primary	4966	2009-01-01 00:00:00
burrowing	3783	unknown	Primary	4967	2009-01-01 00:00:00
disconnecting	3784	unknown	Primary	4968	2009-01-01 00:00:00
brooding	3785	unknown	Primary	4969	2009-01-01 00:00:00
drifting	3786	unknown	Primary	4970	2009-01-01 00:00:00
hide	3787	unknown	Primary	4971	2009-01-01 00:00:00
not-venting	3788	unknown	Primary	4972	2009-01-01 00:00:00
caught in	3789	unknown	Primary	4973	2009-01-01 00:00:00
caught-in	3789	unknown	Synonym	4974	2009-01-01 00:00:00
obscuring	3790	unknown	Primary	4975	2009-01-01 00:00:00
inking	3791	unknown	Primary	4976	2009-01-01 00:00:00
j-posing	3792	unknown	Primary	4977	2009-01-01 00:00:00
excreting	3793	unknown	Primary	4978	2009-01-01 00:00:00
retracting	3794	unknown	Primary	4979	2009-01-01 00:00:00
sitting	3795	unknown	Primary	4980	2009-01-01 00:00:00
inactive	3796	unknown	Primary	4981	2009-01-01 00:00:00
moving	3797	unknown	Primary	4982	2009-01-01 00:00:00
connecting	3798	unknown	Primary	4983	2009-01-01 00:00:00
crawling	3799	unknown	Primary	4984	2009-01-01 00:00:00
unattaching	3800	unknown	Primary	4985	2009-01-01 00:00:00
grabbing	3801	unknown	Primary	4986	2009-01-01 00:00:00
resting	3802	unknown	Primary	4987	2009-01-01 00:00:00
ocean zone	3803	unknown	Primary	4988	2009-01-01 00:00:00
Benthic zone	3804	unknown	Primary	4989	2009-01-01 00:00:00
benthic-zone	3804	unknown	Synonym	4990	2009-01-01 00:00:00
benthic zone	3804	unknown	Synonym	4991	2009-01-01 00:00:00
Sublittoral	3805	unknown	Primary	4992	2009-01-01 00:00:00
sublittoral	3805	unknown	Synonym	4993	2009-01-01 00:00:00
Abyssal	3806	unknown	Primary	4994	2009-01-01 00:00:00
abyssal	3806	unknown	Synonym	4995	2009-01-01 00:00:00
Bathyal	3807	unknown	Primary	4996	2009-01-01 00:00:00
bathyal	3807	unknown	Synonym	4997	2009-01-01 00:00:00
Supralittoral	3808	unknown	Primary	4998	2009-01-01 00:00:00
supralittoral	3808	unknown	Synonym	4999	2009-01-01 00:00:00
Littoral	3809	unknown	Primary	5000	2009-01-01 00:00:00
intertidal	3809	unknown	Synonym	5001	2009-01-01 00:00:00
littoral	3809	unknown	Synonym	5002	2009-01-01 00:00:00
Hadal	3810	unknown	Primary	5003	2009-01-01 00:00:00
hadal	3810	unknown	Synonym	5004	2009-01-01 00:00:00
Pelagic zone	3811	unknown	Primary	5005	2009-01-01 00:00:00
pelagic-zone	3811	unknown	Synonym	5006	2009-01-01 00:00:00
pelagic zone	3811	unknown	Synonym	5007	2009-01-01 00:00:00
Mesopelagic	3812	unknown	Primary	5008	2009-01-01 00:00:00
mesopelagic	3812	unknown	Synonym	5009	2009-01-01 00:00:00
Epipelagic	3813	unknown	Primary	5010	2009-01-01 00:00:00
epipelagic	3813	unknown	Synonym	5011	2009-01-01 00:00:00
Hadopelagic	3814	unknown	Primary	5012	2009-01-01 00:00:00
hadopelagic	3814	unknown	Synonym	5013	2009-01-01 00:00:00
Abyssopelagic	3815	unknown	Primary	5014	2009-01-01 00:00:00
abyssopelagic	3815	unknown	Synonym	5015	2009-01-01 00:00:00
Bathypelagic	3816	unknown	Primary	5016	2009-01-01 00:00:00
bathypelagic	3816	unknown	Synonym	5017	2009-01-01 00:00:00
Neritic	3817	unknown	Primary	5018	2009-01-01 00:00:00
neritic	3817	unknown	Synonym	5019	2009-01-01 00:00:00
Oceanic	3818	unknown	Primary	5020	2009-01-01 00:00:00
oceanic	3818	unknown	Synonym	5021	2009-01-01 00:00:00
Photic zone	3819	unknown	Primary	5022	2009-01-01 00:00:00
photic-zone	3819	unknown	Synonym	5023	2009-01-01 00:00:00
photic zone	3819	unknown	Synonym	5024	2009-01-01 00:00:00
Aphotic zone	3820	unknown	Primary	5025	2009-01-01 00:00:00
aphotic-zone	3820	unknown	Synonym	5026	2009-01-01 00:00:00
aphotic zone	3820	unknown	Synonym	5027	2009-01-01 00:00:00
Euphotic zone	3821	unknown	Primary	5028	2009-01-01 00:00:00
sunlit-water	3821	unknown	Common	5029	2009-01-01 00:00:00
euphotic-zone	3821	unknown	Synonym	5030	2009-01-01 00:00:00
euphotic zone	3821	unknown	Synonym	5031	2009-01-01 00:00:00
Dysphotic zone	3822	unknown	Primary	5032	2009-01-01 00:00:00
dysphotic-zone	3822	unknown	Synonym	5033	2009-01-01 00:00:00
dysphotic zone	3822	unknown	Synonym	5034	2009-01-01 00:00:00
data file	3823	unknown	Primary	5035	2009-01-01 00:00:00
physical object	3824	unknown	Primary	5036	2009-01-01 00:00:00
physical-object	3824		Synonym	5037	2009-01-01 00:00:00
marine organism	3825	unknown	Primary	5038	2009-01-01 00:00:00
marine-organism	3825		Common	5039	2009-01-01 00:00:00
Eubacteria	3826	unknown	Primary	5040	2009-01-01 00:00:00
Bacteria	3827	unknown	Primary	5041	2009-01-01 00:00:00
Schizomycetes	3828	unknown	Primary	5042	2009-01-01 00:00:00
Beggiatoales	3829	unknown	Primary	5043	2009-01-01 00:00:00
Beggiatoaceae	3830	unknown	Primary	5044	2009-01-01 00:00:00
Thioplaca	3831	unknown	Primary	5045	2009-01-01 00:00:00
Beggiatoa	3832	unknown	Primary	5046	2009-01-01 00:00:00
Cyanobacteria	3833	unknown	Primary	5047	2009-01-01 00:00:00
blue-green-algae	3833	unknown	Common	5048	2009-01-01 00:00:00
Oscillatoriales	3834	unknown	Primary	5049	2009-01-01 00:00:00
Oscillatoriacea	3835	unknown	Primary	5050	2009-01-01 00:00:00
Trichodesmium	3836	unknown	Primary	5051	2009-01-01 00:00:00
sea-sawdust	3836	unknown	Common	5052	2009-01-01 00:00:00
Eukaryota	3837	unknown	Primary	5053	2009-01-01 00:00:00
Plantae	3838	unknown	Primary	5054	2009-01-01 00:00:00
Chlorophycota	3839	unknown	Primary	5055	2009-01-01 00:00:00
chlorophyta	3839	unknown	Synonym	5056	2009-01-01 00:00:00
green-algae	3839	(n.o.d.c.)	Common	5057	2009-01-01 00:00:00
chlorophycota	3839	unknown	Synonym	5058	2009-01-01 00:00:00
Chlorophyceae	3840	unknown	Primary	5059	2009-01-01 00:00:00
chlorophyceae	3840	unknown	Synonym	5060	2009-01-01 00:00:00
Ulvaceae	3841	unknown	Primary	5061	2009-01-01 00:00:00
ulvaceae	3841	unknown	Synonym	5062	2009-01-01 00:00:00
Enteromorpha	3842	unknown	Primary	5063	2009-01-01 00:00:00
enteromorpha	3842	unknown	Synonym	5064	2009-01-01 00:00:00
Ulva	3843	linnaeus, 1753	Primary	5065	2009-01-01 00:00:00
ulva	3843	linnaeus, 1753	Synonym	5066	2009-01-01 00:00:00
Codiales	3844	unknown	Primary	5067	2009-01-01 00:00:00
codiales	3844	unknown	Synonym	5068	2009-01-01 00:00:00
Derbesiaceae	3845	unknown	Primary	5069	2009-01-01 00:00:00
derbesiaceae	3845	unknown	Synonym	5070	2009-01-01 00:00:00
Derbesia	3846	unknown	Primary	5071	2009-01-01 00:00:00
derbesia	3846	unknown	Synonym	5072	2009-01-01 00:00:00
Derbesia marina	3847	unknown	Primary	5073	2009-01-01 00:00:00
derbesia-marina	3847	unknown	Synonym	5074	2009-01-01 00:00:00
Codiaceae	3848	unknown	Primary	5075	2009-01-01 00:00:00
codiaceae	3848	unknown	Synonym	5076	2009-01-01 00:00:00
Codium	3849	j. stackhouse, 1797	Primary	5077	2009-01-01 00:00:00
codium	3849	j. stackhouse, 1797	Synonym	5078	2009-01-01 00:00:00
Rhodophycota	3850	unknown	Primary	5079	2009-01-01 00:00:00
rhodophyta	3850	unknown	Synonym	5080	2009-01-01 00:00:00
red-algae	3850	(n.o.d.c.)	Common	5081	2009-01-01 00:00:00
rhodophycota	3850	unknown	Synonym	5082	2009-01-01 00:00:00
Gigartinales	3851	unknown	Primary	5083	2009-01-01 00:00:00
gigartinales	3851	unknown	Synonym	5084	2009-01-01 00:00:00
Gigartinaceae	3852	unknown	Primary	5085	2009-01-01 00:00:00
gigartinaceae	3852	unknown	Synonym	5086	2009-01-01 00:00:00
Gigartina	3853	unknown	Primary	5087	2009-01-01 00:00:00
gigartina	3853	unknown	Synonym	5088	2009-01-01 00:00:00
Gigartina exasperata	3854	unknown	Primary	5089	2009-01-01 00:00:00
gigartina-exasperata	3854	unknown	Synonym	5090	2009-01-01 00:00:00
Iridaea	3855	unknown	Primary	5091	2009-01-01 00:00:00
iridaea	3855	unknown	Synonym	5092	2009-01-01 00:00:00
Iridaea flaccida	3856	unknown	Primary	5093	2009-01-01 00:00:00
iridaea-flaccida	3856	unknown	Synonym	5094	2009-01-01 00:00:00
Iridaea cordata	3857	unknown	Primary	5095	2009-01-01 00:00:00
iridaea-cordata	3857	unknown	Synonym	5096	2009-01-01 00:00:00
Plocamiaceae	3858	unknown	Primary	5097	2009-01-01 00:00:00
plocamiaceae	3858	unknown	Synonym	5098	2009-01-01 00:00:00
Plocamium	3859	unknown	Primary	5099	2009-01-01 00:00:00
plocamium	3859	unknown	Synonym	5100	2009-01-01 00:00:00
Solieriaceae	3860	unknown	Primary	5101	2009-01-01 00:00:00
solieriaceae	3860	unknown	Synonym	5102	2009-01-01 00:00:00
Opuntiella	3861	unknown	Primary	5103	2009-01-01 00:00:00
opuntiella	3861	unknown	Synonym	5104	2009-01-01 00:00:00
Opuntiella californica	3862	unknown	Primary	5105	2009-01-01 00:00:00
opuntiella-californica	3862	unknown	Synonym	5106	2009-01-01 00:00:00
Rhodymeniales	3863	unknown	Primary	5107	2009-01-01 00:00:00
rhodymeniales	3863	unknown	Synonym	5108	2009-01-01 00:00:00
Rhodymeniaceae	3864	unknown	Primary	5109	2009-01-01 00:00:00
rhodymeniaceae	3864	unknown	Synonym	5110	2009-01-01 00:00:00
Fryeella	3865	unknown	Primary	5111	2009-01-01 00:00:00
fryeella	3865	unknown	Synonym	5112	2009-01-01 00:00:00
Fryeella gardneri	3866	unknown	Primary	5113	2009-01-01 00:00:00
fryeella-gardneri	3866	unknown	Synonym	5114	2009-01-01 00:00:00
Fauchea	3867	unknown	Primary	5115	2009-01-01 00:00:00
fauchea	3867	unknown	Synonym	5116	2009-01-01 00:00:00
Fauchea laciniata	3868	unknown	Primary	5117	2009-01-01 00:00:00
fauchea-laciniata	3868	unknown	Synonym	5118	2009-01-01 00:00:00
Rhodymenia	3869	unknown	Primary	5119	2009-01-01 00:00:00
rhodymenia	3869	unknown	Synonym	5120	2009-01-01 00:00:00
Rhodymenia californica	3870	unknown	Primary	5121	2009-01-01 00:00:00
rhodymenia-californica	3870	unknown	Synonym	5122	2009-01-01 00:00:00
Rhodymenia californica var. attenuata	3871	unknown	Primary	5123	2009-01-01 00:00:00
rhodymenia-californica-var.-attenuata	3871	unknown	Synonym	5124	2009-01-01 00:00:00
Rhodymenia pacifica	3872	unknown	Primary	5125	2009-01-01 00:00:00
rhodymenia-pacifica	3872	unknown	Synonym	5126	2009-01-01 00:00:00
Maripelta	3873	unknown	Primary	5127	2009-01-01 00:00:00
maripelta	3873	unknown	Synonym	5128	2009-01-01 00:00:00
Maripelta rotata	3874	unknown	Primary	5129	2009-01-01 00:00:00
maripelta-rotata	3874	unknown	Synonym	5130	2009-01-01 00:00:00
Botryocladia	3875	unknown	Primary	5131	2009-01-01 00:00:00
botryocladia	3875	unknown	Synonym	5132	2009-01-01 00:00:00
Botryocladia pseudodichotoma	3876	unknown	Primary	5133	2009-01-01 00:00:00
botryocladia-pseudodichotoma	3876	unknown	Synonym	5134	2009-01-01 00:00:00
Porphyridiales	3877	unknown	Primary	5135	2009-01-01 00:00:00
porphyridiales	3877	unknown	Synonym	5136	2009-01-01 00:00:00
Cryptonemiales	3878	unknown	Primary	5137	2009-01-01 00:00:00
cryptonemiales	3878	unknown	Synonym	5138	2009-01-01 00:00:00
Corallinaceae	3879	unknown	Primary	5139	2009-01-01 00:00:00
coralline	3879	unknown	Common	5140	2009-01-01 00:00:00
corallinaceae	3879	unknown	Synonym	5141	2009-01-01 00:00:00
Bossiella	3880	unknown	Primary	5142	2009-01-01 00:00:00
bossiella	3880	unknown	Synonym	5143	2009-01-01 00:00:00
Bossiella californica	3881	unknown	Primary	5144	2009-01-01 00:00:00
bossiella-californica	3881	unknown	Synonym	5145	2009-01-01 00:00:00
Bossiella orbigniana	3882	unknown	Primary	5146	2009-01-01 00:00:00
bossiella-orbigniana	3882	unknown	Synonym	5147	2009-01-01 00:00:00
Lithothamnium	3883	unknown	Primary	5148	2009-01-01 00:00:00
lithothamnium	3883	unknown	Synonym	5149	2009-01-01 00:00:00
Corallina	3884	unknown	Primary	5150	2009-01-01 00:00:00
corallina	3884	unknown	Synonym	5151	2009-01-01 00:00:00
Calliarthron	3885	unknown	Primary	5152	2009-01-01 00:00:00
calliarthron	3885	unknown	Synonym	5153	2009-01-01 00:00:00
Calliarthron tuberculosum	3886	unknown	Primary	5154	2009-01-01 00:00:00
calliarthron-tuberculosum	3886	unknown	Synonym	5155	2009-01-01 00:00:00
Kallymeniaceae	3887	unknown	Primary	5156	2009-01-01 00:00:00
kallymeniaceae	3887	unknown	Synonym	5157	2009-01-01 00:00:00
Callophyllis	3888	unknown	Primary	5158	2009-01-01 00:00:00
callophyllis	3888	unknown	Synonym	5159	2009-01-01 00:00:00
Callophyllis flabellulata	3889	unknown	Primary	5160	2009-01-01 00:00:00
callophyllis-flabellulata	3889	unknown	Synonym	5161	2009-01-01 00:00:00
Callophyllis violacea	3890	unknown	Primary	5162	2009-01-01 00:00:00
callophyllis-violacea	3890	unknown	Synonym	5163	2009-01-01 00:00:00
Callophyllis thompsonii	3891	unknown	Primary	5164	2009-01-01 00:00:00
callophyllis-thompsonii	3891	unknown	Synonym	5165	2009-01-01 00:00:00
Cryptonemiaceae	3892	unknown	Primary	5166	2009-01-01 00:00:00
cryptonemiaceae	3892	unknown	Synonym	5167	2009-01-01 00:00:00
Halymenia	3893	unknown	Primary	5168	2009-01-01 00:00:00
halymenia	3893	unknown	Synonym	5169	2009-01-01 00:00:00
Halymenia gardneri	3894	unknown	Primary	5170	2009-01-01 00:00:00
halymenia-gardneri	3894	unknown	Synonym	5171	2009-01-01 00:00:00
Halymenia coccinea	3895	unknown	Primary	5172	2009-01-01 00:00:00
halymenia-coccinea	3895	unknown	Synonym	5173	2009-01-01 00:00:00
Weeksiaceae	3896	unknown	Primary	5174	2009-01-01 00:00:00
weeksiaceae	3896	unknown	Synonym	5175	2009-01-01 00:00:00
Weeksia	3897	unknown	Primary	5176	2009-01-01 00:00:00
weeksia	3897	unknown	Synonym	5177	2009-01-01 00:00:00
Weeksia reticulata	3898	unknown	Primary	5178	2009-01-01 00:00:00
weeksia-reticulata	3898	unknown	Synonym	5179	2009-01-01 00:00:00
Weeksia digitata	3899	unknown	Primary	5180	2009-01-01 00:00:00
weeksia-digitata	3899	unknown	Synonym	5181	2009-01-01 00:00:00
Ceramiales	3900	unknown	Primary	5182	2009-01-01 00:00:00
ceramiales	3900	unknown	Synonym	5183	2009-01-01 00:00:00
Delesseriaceae	3901	unknown	Primary	5184	2009-01-01 00:00:00
delesseriaceae	3901	unknown	Synonym	5185	2009-01-01 00:00:00
Cryptopleura	3902	unknown	Primary	5186	2009-01-01 00:00:00
cryptopleura	3902	unknown	Synonym	5187	2009-01-01 00:00:00
Polyneura	3903	unknown	Primary	5188	2009-01-01 00:00:00
polyneura	3903	unknown	Synonym	5189	2009-01-01 00:00:00
Polyneura latissima	3904	unknown	Primary	5190	2009-01-01 00:00:00
polyneura-latissima	3904	unknown	Synonym	5191	2009-01-01 00:00:00
Holmesia	3905	unknown	Primary	5192	2009-01-01 00:00:00
holmesia	3905	unknown	Synonym	5193	2009-01-01 00:00:00
Holmesia californica	3906	unknown	Primary	5194	2009-01-01 00:00:00
holmesia-californica	3906	unknown	Synonym	5195	2009-01-01 00:00:00
Tracheophyta	3907	unknown	Primary	5196	2009-01-01 00:00:00
vascular-plant	3907	unknown	Common	5197	2009-01-01 00:00:00
tracheophyta	3907	unknown	Synonym	5198	2009-01-01 00:00:00
Magnoliophyta	3908	unknown	Primary	5199	2009-01-01 00:00:00
flowering-plant	3908	unknown	Common	5200	2009-01-01 00:00:00
angiosperm	3908	(n.o.d.c.)	Common	5201	2009-01-01 00:00:00
angiospermae	3908	unknown	Synonym	5202	2009-01-01 00:00:00
magnoliophyta	3908	unknown	Synonym	5203	2009-01-01 00:00:00
Najadales	3909	unknown	Primary	5204	2009-01-01 00:00:00
najadales	3909	unknown	Synonym	5205	2009-01-01 00:00:00
Zosteraceae	3910	unknown	Primary	5206	2009-01-01 00:00:00
sea-grass	3910	unknown	Common	5207	2009-01-01 00:00:00
zosteraceae	3910	unknown	Synonym	5208	2009-01-01 00:00:00
Phyllospadix	3911	unknown	Primary	5209	2009-01-01 00:00:00
surf-grass	3911	unknown	Common	5210	2009-01-01 00:00:00
phyllospadix	3911	unknown	Synonym	5211	2009-01-01 00:00:00
Phyllospadix scouleri	3912	hook	Primary	5212	2009-01-01 00:00:00
phyllospadix-scouleri	3912	hook	Synonym	5213	2009-01-01 00:00:00
Phyllospadix torreyi	3913	s. wats.	Primary	5214	2009-01-01 00:00:00
phyllospadix-torreyi	3913	s. wats.	Synonym	5215	2009-01-01 00:00:00
Zostera	3914	unknown	Primary	5216	2009-01-01 00:00:00
eel-grass	3914	unknown	Common	5217	2009-01-01 00:00:00
zostera	3914	unknown	Synonym	5218	2009-01-01 00:00:00
Zostera marina	3915	unknown	Primary	5219	2009-01-01 00:00:00
zostera-marina	3915	unknown	Synonym	5220	2009-01-01 00:00:00
Animalia	3916	unknown	Primary	5221	2009-01-01 00:00:00
metazoa	3916	unknown	Synonym	5222	2009-01-01 00:00:00
Bryozoa	3917	unknown	Primary	5223	2009-01-01 00:00:00
ectoprocta	3917	unknown	Synonym	5224	2009-01-01 00:00:00
moss-animal	3917	unknown	Common	5225	2009-01-01 00:00:00
moss-animalcule	3917	unknown	Common	5226	2009-01-01 00:00:00
ectoproct	3917	unknown	Common	5227	2009-01-01 00:00:00
bryozoan	3917	(n.o.d.c.)	Common	5228	2009-01-01 00:00:00
Gymnolaemata	3918	unknown	Primary	5229	2009-01-01 00:00:00
tubular-bryozoan	3918	unknown	Common	5230	2009-01-01 00:00:00
marine-bryozoan	3918	(n.o.d.c.)	Common	5231	2009-01-01 00:00:00
Cheilostomatida 	3919	Busk, 1852	Primary	5232	2009-01-01 00:00:00
Cheilostomata 	3919	Busk, 1852	Synonym	5233	2009-01-01 00:00:00
Neocheilostomatina	3920	d’Hondt, 1985	Primary	5234	2009-01-01 00:00:00
Ascophora	3921	Levinsen, 1909	Primary	5235	2009-01-01 00:00:00
Lepralielloidea	3922	Vigneaux, 1949	Primary	5236	2009-01-01 00:00:00
Tessaradomidae	3923	Norman, 1869	Primary	5237	2009-01-01 00:00:00
Striatodoma	3924	Winston, 1999	Primary	5238	2009-01-01 00:00:00
Striatodoma dorothea	3925	Winston, 1999	Primary	5239	2009-01-01 00:00:00
Nemertea	3926	unknown	Primary	5240	2009-01-01 00:00:00
rhynchocoela	3926	unknown	Synonym	5241	2009-01-01 00:00:00
ribbon-worm	3926	unknown	Common	5242	2009-01-01 00:00:00
proboscis-worm	3926	(n.o.d.c.)	Common	5243	2009-01-01 00:00:00
Enopla	3927	unknown	Primary	5244	2009-01-01 00:00:00
enopla	3927	unknown	Synonym	5245	2009-01-01 00:00:00
Hoplonemertea	3928	unknown	Primary	5246	2009-01-01 00:00:00
hoplonemertea	3928	unknown	Synonym	5247	2009-01-01 00:00:00
Polystilifera	3929	unknown	Primary	5248	2009-01-01 00:00:00
polystilifera	3929	unknown	Synonym	5249	2009-01-01 00:00:00
Nectonemertidae	3930	unknown	Primary	5250	2009-01-01 00:00:00
nectonemertidae	3930	unknown	Synonym	5251	2009-01-01 00:00:00
Nectonemertes	3931	unknown	Primary	5252	2009-01-01 00:00:00
nectonemertes	3931	unknown	Synonym	5253	2009-01-01 00:00:00
Nectonemertes mirabilis	3932	unknown	Primary	5254	2009-01-01 00:00:00
nectonemertes-pelagica	3932	unknown	Synonym	5255	2009-01-01 00:00:00
nectonemertes-mirabilis	3932	unknown	Synonym	5256	2009-01-01 00:00:00
Phallonemertidae	3933	unknown	Primary	5257	2009-01-01 00:00:00
phallonemertidae	3933	unknown	Synonym	5258	2009-01-01 00:00:00
Phallonemertes	3934	unknown	Primary	5259	2009-01-01 00:00:00
phallonemertes	3934	unknown	Synonym	5260	2009-01-01 00:00:00
Sipuncula	3935	unknown	Primary	5261	2009-01-01 00:00:00
Sipunculoidea	3935	unknown	Synonym	5262	2009-01-01 00:00:00
sipunculan-worm	3935	unknown	Common	5263	2009-01-01 00:00:00
shore-worm	3935	unknown	Common	5264	2009-01-01 00:00:00
peanut-worm	3935	(n.o.d.c.)	Common	5265	2009-01-01 00:00:00
Sipunculiniformes	3936	unknown	Primary	5266	2009-01-01 00:00:00
Sipunculidae	3937	unknown	Primary	5267	2009-01-01 00:00:00
Porifera	3938	unknown	Primary	5268	2009-01-01 00:00:00
sponge	3938	(n.o.d.c.)	Common	5269	2009-01-01 00:00:00
sulfer sponge	3939	unknown	Primary	5270	2009-01-01 00:00:00
Hexactinellida	3940	Schmidt, 1870	Primary	5271	2009-01-01 00:00:00
Amphidiscophora	3941	Schulze, 1886	Primary	5272	2009-01-01 00:00:00
Amphidiscosida	3942	Schrammen, 1924	Primary	5273	2009-01-01 00:00:00
Hyalonematidae	3943	Gray, 1857	Primary	5274	2009-01-01 00:00:00
Hyalonema	3944	Gray, 1832	Primary	5275	2009-01-01 00:00:00
Hyalonema sp. A	3945	\N	Primary	5276	2009-01-01 00:00:00
Hyalonema bianchoratum	3946	\N	Primary	5277	2009-01-01 00:00:00
Hexasterophora	3947	Schulze, 1886	Primary	5278	2009-01-01 00:00:00
Lychniscosida	3948	unknown	Primary	5279	2009-01-01 00:00:00
Lyssacinosida	3949	Zittel, 1877	Primary	5280	2009-01-01 00:00:00
Euplectellidae	3950	Gray, 1867	Primary	5281	2009-01-01 00:00:00
Euplectella	3951	Owen, 1841	Primary	5282	2009-01-01 00:00:00
Saccocalyx	3952	unknown	Primary	5283	2009-01-01 00:00:00
Saccocalyx pedunculata 	3953	unknown	Primary	5284	2009-01-01 00:00:00
Corbitellinae	3954	unknown	Primary	5285	2009-01-01 00:00:00
Atlantisella	3955	unknown	Primary	5286	2009-01-01 00:00:00
Regadrella	3956	unknown	Primary	5287	2009-01-01 00:00:00
Euplectellidae sp. A	3957	\N	Primary	5288	2009-01-01 00:00:00
Rossellidae	3958	Schulze, 1885	Primary	5289	2009-01-01 00:00:00
Caulophacidae	3958	Ijima, 1903	Synonym	5290	2009-01-01 00:00:00
Acanthascinae	3959	unknown	Primary	5291	2009-01-01 00:00:00
Staurocalyptus	3960	unknown	Primary	5292	2009-01-01 00:00:00
yellow-picasso-sponge	3960		Common	5293	2009-01-01 00:00:00
Rossellinae	3961	Schulze, 1885	Primary	5294	2009-01-01 00:00:00
Caulophacus	3962	F.E. von Schulze, 1886	Primary	5295	2009-01-01 00:00:00
Caulophacus cyanae	3963	Boury-Esnaulkt & De Vos, 1988	Primary	5296	2009-01-01 00:00:00
Bathydorus	3964	Schulze, 1886	Primary	5297	2009-01-01 00:00:00
Bathydorus sp. A	3965	\N	Primary	5298	2009-01-01 00:00:00
Bathydorus laevis spinosus	3966	Wilson, 1904	Primary	5299	2009-01-01 00:00:00
Bathydorus sp. B	3967	\N	Primary	5300	2009-01-01 00:00:00
Hexactinosida	3968	Schrammen, 1912	Primary	5301	2009-01-01 00:00:00
Tretodictyidae	3969	unknown	Primary	5302	2009-01-01 00:00:00
Hexactinella	3970	Carter, 1885	Primary	5303	2009-01-01 00:00:00
Sclerothamnopsis	3971	Wilson, 1904	Primary	5304	2009-01-01 00:00:00
Sclerothamnopsis compressa	3972	Wilson, 1904	Primary	5305	2009-01-01 00:00:00
Farreidae	3973	Gray, 1872	Primary	5306	2009-01-01 00:00:00
Farrea	3974	Bowerbank, 1862	Primary	5307	2009-01-01 00:00:00
Farrea occa	3975	(Bowerbank, 1862)	Primary	5308	2009-01-01 00:00:00
white-ruffled-sponge	3975		Common	5309	2009-01-01 00:00:00
Aphrocallistidae	3976	unknown	Primary	5310	2009-01-01 00:00:00
Heterochone	3977	Ijima, 1927	Primary	5311	2009-01-01 00:00:00
yellow-goiter-sponge	3977		Common	5312	2009-01-01 00:00:00
Heterochone calyx	3978	(Schulze, 1886)	Primary	5313	2009-01-01 00:00:00
white-goiter-sponge	3978		Common	5314	2009-01-01 00:00:00
Euretidae	3979	Zittel, 1877	Primary	5315	2009-01-01 00:00:00
Chonelasmatinae	3980	Schrammen, 1912	Primary	5316	2009-01-01 00:00:00
Chonelasma	3981	Schulze, 1886	Primary	5317	2009-01-01 00:00:00
white-trumpet-sponge	3981		Common	5318	2009-01-01 00:00:00
yellow ruffled sponge	3982	unknown	Primary	5319	2009-01-01 00:00:00
gray encrusting sponge	3983	unknown	Primary	5320	2009-01-01 00:00:00
white lattice sponge	3984	unknown	Primary	5321	2009-01-01 00:00:00
Hexactinellida sp. 1	3985	\N	Primary	5322	2009-01-01 00:00:00
Hexactinellida sp. 2	3986	\N	Primary	5323	2009-01-01 00:00:00
Demospongiae	3987	Sollas, 1885	Primary	5324	2009-01-01 00:00:00
Sclerospongiae	3987	Hartman & Goreau, 1970	Synonym	5325	2009-01-01 00:00:00
Haplosclerida	3988	Topsent, 1928	Primary	5326	2009-01-01 00:00:00
Ceractinomorpha	3989	Lévi, 1953	Primary	5327	2009-01-01 00:00:00
Ceractinomorpha incertae sedis	3989	unknown	Synonym	5328	2009-01-01 00:00:00
Poecilosclerida	3990	Topsent, 1928	Primary	5329	2009-01-01 00:00:00
Mycalina	3991	Hajdu, Van Soest & Hooper, 1994	Primary	5330	2009-01-01 00:00:00
Cladorhizidae	3992	Dendy, 1922	Primary	5331	2009-01-01 00:00:00
Asbestopluma	3993	Topsent, 1901	Primary	5332	2009-01-01 00:00:00
Asbestopluma biserialis	3994	(Ridley and Dendy, 1886)	Primary	5333	2009-01-01 00:00:00
Asbestopluma occidentalis	3995	(Lambe, 1893)	Primary	5334	2009-01-01 00:00:00
Asbestopluma branched	3996	unknown	Primary	5335	2009-01-01 00:00:00
Chondrocladia	3997	W.D. Hartman, in Parker,1982:652	Primary	5336	2009-01-01 00:00:00
Chondrocladia sp. 2	3998	\N	Primary	5337	2009-01-01 00:00:00
Chondrocladia sp. 1	3999	\N	Primary	5338	2009-01-01 00:00:00
Cladorhiza	4000	Sars, 1872	Primary	5339	2009-01-01 00:00:00
Cladorhiza pteron	4001	unknown	Primary	5340	2009-01-01 00:00:00
Lollipocladia	4002	Vacelet, 2008	Primary	5341	2009-01-01 00:00:00
Lollipocladia tiburoni	4003	Vacelet, 2008	Primary	5342	2009-01-01 00:00:00
Hadromerida	4004	Topsent, 1894	Primary	5343	2009-01-01 00:00:00
Polymastiidae	4005	unknown	Primary	5344	2009-01-01 00:00:00
Polymastia	4006	Bowerbank, 1864	Primary	5345	2009-01-01 00:00:00
Stylocordylidae	4007	Topsent, 1892	Primary	5346	2009-01-01 00:00:00
Stylocordyla	4008	Thomson, 1873	Primary	5347	2009-01-01 00:00:00
Astrophorida	4009	Sollas, 1887	Primary	5348	2009-01-01 00:00:00
Pachastrellidae	4010	Carter, 1875	Primary	5349	2009-01-01 00:00:00
Thenea	4011	Gray, 1867	Primary	5350	2009-01-01 00:00:00
Thenea muricata	4012	(Bowerbank, 1858)	Primary	5351	2009-01-01 00:00:00
Homoscleromorpha	4013	Lévi, 1973	Primary	5352	2009-01-01 00:00:00
Homosclerophorida	4014	Dendy, 1905	Primary	5353	2009-01-01 00:00:00
Carnosa	4014	Dendy, 1905	Synonym	5354	2009-01-01 00:00:00
Calcarea	4015	Bowerbank, 1864	Primary	5355	2009-01-01 00:00:00
Calcaronea	4016	Bidder, 1898	Primary	5356	2009-01-01 00:00:00
Leucosolenida	4017	Hartman, 1958	Primary	5357	2009-01-01 00:00:00
Leucosoleniidae	4018	Minchin, 1900	Primary	5358	2009-01-01 00:00:00
Leucosolenia	4019	Bowerbank, 1864	Primary	5359	2009-01-01 00:00:00
Calcinea	4020	Bidder, 1898	Primary	5360	2009-01-01 00:00:00
basket sponge	4021	unknown	Primary	5361	2009-01-01 00:00:00
Porifera sp. 1	4022	unknown	Primary	5362	2009-01-01 00:00:00
Porifera sp. 2	4023	\N	Primary	5363	2009-01-01 00:00:00
Porifera sp. 3	4024	\N	Primary	5364	2009-01-01 00:00:00
Echinodermata	4025	klein, 1734	Primary	5365	2009-01-01 00:00:00
echinoderm	4025	(n.o.d.c.)	Common	5366	2009-01-01 00:00:00
Benthopectinidae	4026	verrill, 1894	Primary	5367	2009-01-01 00:00:00
Benthopecten	4027	verrill, 1884	Primary	5368	2009-01-01 00:00:00
Benthopecten claviger	4028	Fisher, 1910	Primary	5369	2009-01-01 00:00:00
Echinoidea	4029	leske, 1778	Primary	5370	2009-01-01 00:00:00
urchin	4029	unknown	Common	5371	2009-01-01 00:00:00
echinoid	4029	unknown	Common	5372	2009-01-01 00:00:00
Perischoechinoidea	4030	unknown	Primary	5373	2009-01-01 00:00:00
Cidaroida	4031	unknown	Primary	5374	2009-01-01 00:00:00
Cidaridae	4032	Gray, 1825	Primary	5375	2009-01-01 00:00:00
pencil-urchin	4032	unknown	Common	5376	2009-01-01 00:00:00
Aporocidaris	4033	unknown	Primary	5377	2009-01-01 00:00:00
Aporocidaris milleri	4034	Agassiz, 1907	Primary	5378	2009-01-01 00:00:00
pink pencil-urchin	4034	unknown	Common	5379	2009-01-01 00:00:00
Euechinoidea	4035	Bronn, 1960	Primary	5380	2009-01-01 00:00:00
Echinacea	4036	Claus, 1976	Primary	5381	2009-01-01 00:00:00
Temnopleuroida	4037	mortensen, 1942	Primary	5382	2009-01-01 00:00:00
Toxopneustidae	4038	troschel, 1872	Primary	5383	2009-01-01 00:00:00
Lytechinus	4039	a. agassiz, 1863	Primary	5384	2009-01-01 00:00:00
Lytechinus pictus	4040	verrill	Primary	5385	2009-01-01 00:00:00
Echinoida	4041	unknown	Primary	5386	2009-01-01 00:00:00
Strongylocentrotidae	4042	unknown	Primary	5387	2009-01-01 00:00:00
Allocentrotus	4043	unknown	Primary	5388	2009-01-01 00:00:00
deep-sea urchin	4043	unknown	Common	5389	2009-01-01 00:00:00
Allocentrotus fragilis	4044	(jackson, 1912)	Primary	5390	2009-01-01 00:00:00
fragile urchin	4044	unknown	Common	5391	2009-01-01 00:00:00
Strongylocentrotus	4045	unknown	Primary	5392	2009-01-01 00:00:00
Strongylocentrotus purpuratus	4046	unknown	Primary	5393	2009-01-01 00:00:00
Strongylocentrotus franciscanus	4047	unknown	Primary	5394	2009-01-01 00:00:00
Atelostomata	4048	unknown	Primary	5395	2009-01-01 00:00:00
Cassiduloida	4049	unknown	Primary	5396	2009-01-01 00:00:00
Holasterina	4050	unknown	Primary	5397	2009-01-01 00:00:00
Pourtalesiidae	4051	unknown	Primary	5398	2009-01-01 00:00:00
Echinocrepis	4052	unknown	Primary	5399	2009-01-01 00:00:00
Echinocrepis rostrata	4053	Mironov, 1973	Primary	5400	2009-01-01 00:00:00
Cystechinus	4054	unknown	Primary	5401	2009-01-01 00:00:00
Cystechinus loveni	4055	Agassiz, 1904	Primary	5402	2009-01-01 00:00:00
Cystocrepis	4056	unknown	Primary	5403	2009-01-01 00:00:00
Cystocrepis setigera	4057	(Agassiz, 1898)	Primary	5404	2009-01-01 00:00:00
Echinocrepis setigera	4057	Agassiz, 1898	Synonym	5405	2009-01-01 00:00:00
Spatangoida	4058	Claus, 1876	Primary	5406	2009-01-01 00:00:00
heart-urchin	4058	unknown	Common	5407	2009-01-01 00:00:00
spatangoida	4058	Claus, 1876	Synonym	5408	2009-01-01 00:00:00
Hemiasterina	4059	unknown	Primary	5409	2009-01-01 00:00:00
Schizasteridae	4060	Lambert, 1905	Primary	5410	2009-01-01 00:00:00
Brisaster	4061	Gray, 1855	Primary	5411	2009-01-01 00:00:00
heart-urchin Brisaster	4061	unknown	Common	5412	2009-01-01 00:00:00
Brisaster latifrons	4062	Agassiz, 1898	Primary	5413	2009-01-01 00:00:00
Micrasterina	4063	unknown	Primary	5414	2009-01-01 00:00:00
Loveniidae	4064	lambert, 1905	Primary	5415	2009-01-01 00:00:00
Lovenia	4065	Desor, 1847	Primary	5416	2009-01-01 00:00:00
Lovenia cordiformis	4066	A. Agassiz, 1872	Primary	5417	2009-01-01 00:00:00
Diadematacea	4067	unknown	Primary	5418	2009-01-01 00:00:00
Echinothurioida	4068	unknown	Primary	5419	2009-01-01 00:00:00
Echinothuriidae	4069	Thomson, 1872	Primary	5420	2009-01-01 00:00:00
Hygrosoma	4070	unknown	Primary	5421	2009-01-01 00:00:00
Hygrosoma petersii	4071	unknown	Primary	5422	2009-01-01 00:00:00
Tromikosoma	4072	Mortensen, 1903	Primary	5423	2009-01-01 00:00:00
Tromikosoma panamense	4073	unknown	Primary	5424	2009-01-01 00:00:00
Tromikosoma hispidum	4074	(Agassiz, 1898)	Primary	5425	2009-01-01 00:00:00
Tromikosoma sp. 1	4075	\N	Primary	5426	2009-01-01 00:00:00
Araeosoma	4076	\N	Primary	5427	2009-01-01 00:00:00
Araeosoma leptaleum	4077	Agassiz and Clark, 1909	Primary	5428	2009-01-01 00:00:00
Echinoidea sp. 1	4078	\N	Primary	5429	2009-01-01 00:00:00
Holothuroidea	4079	de blainville, 1834	Primary	5430	2009-01-01 00:00:00
sea-cucumber	4079	(n.o.d.c.)	Common	5431	2009-01-01 00:00:00
holothurian	4079	unknown	Common	5432	2009-01-01 00:00:00
Apodacea	4080	unknown	Primary	5433	2009-01-01 00:00:00
Molpadiida	4081	unknown	Primary	5434	2009-01-01 00:00:00
Molpadiidae	4082	unknown	Primary	5435	2009-01-01 00:00:00
Molpadia	4083	unknown	Primary	5436	2009-01-01 00:00:00
burrowing cucumber	4083	unknown	Common	5437	2009-01-01 00:00:00
Aspidochirotacea	4084	unknown	Primary	5438	2009-01-01 00:00:00
Elasipodida	4085	unknown	Primary	5439	2009-01-01 00:00:00
Psychropotidae	4086	unknown	Primary	5440	2009-01-01 00:00:00
Benthodytes	4087	unknown	Primary	5441	2009-01-01 00:00:00
benthodytes	4087	unknown	Synonym	5442	2009-01-01 00:00:00
Benthodytes sanguinolenta	4088	Theel, 1882	Primary	5443	2009-01-01 00:00:00
benthodytes-sanguinolenta	4088	Theel, 1882	Synonym	5444	2009-01-01 00:00:00
Benthodytes sp.1	4089	unknown	Primary	5445	2009-01-01 00:00:00
benthodytes sp.1	4089	unknown	Synonym	5446	2009-01-01 00:00:00
Benthodytes sp.2	4090	unknown	Primary	5447	2009-01-01 00:00:00
benthodytes sp.2	4090	unknown	Synonym	5448	2009-01-01 00:00:00
Psychropotes	4091	unknown	Primary	5449	2009-01-01 00:00:00
psychropotes	4091	unknown	Synonym	5450	2009-01-01 00:00:00
Psychropotes longicauda	4092	Theel, 1882	Primary	5451	2009-01-01 00:00:00
psychropotes longicauda	4092	Theel, 1882	Synonym	5452	2009-01-01 00:00:00
Laetmogonidae	4093	Ekman, 1926	Primary	5453	2009-01-01 00:00:00
Pannychia	4094	Théel, 1882	Primary	5454	2009-01-01 00:00:00
Pannychia moseleyi	4095	theel, 1882	Primary	5455	2009-01-01 00:00:00
pannychia-moseleyi	4095	theel, 1882	Synonym	5456	2009-01-01 00:00:00
Laetmogone	4096	unknown	Primary	5457	2009-01-01 00:00:00
Laetmogone wyvillethomsoni	4097	Theel, 1882	Primary	5458	2009-01-01 00:00:00
Benthogone	4098	Koehler, 1895	Primary	5459	2009-01-01 00:00:00
Benthogone rosea	4099	Koehler, 1896	Primary	5460	2009-01-01 00:00:00
Deimatidae	4100	unknown	Primary	5461	2009-01-01 00:00:00
Oneirophanta	4101	unknown	Primary	5462	2009-01-01 00:00:00
Oneirophanta mutabilis	4102	Theel, 1879	Primary	5463	2009-01-01 00:00:00
Elpidiidae	4103	unknown	Primary	5464	2009-01-01 00:00:00
Scotoplanes	4104	unknown	Primary	5465	2009-01-01 00:00:00
Scotoplanes globosa	4105	unknown	Primary	5466	2009-01-01 00:00:00
Scotoplanes clarki	4106	unknown	Primary	5467	2009-01-01 00:00:00
Peniagone	4107	unknown	Primary	5468	2009-01-01 00:00:00
Peniagone leander	4108	Pawson, DL & Foell, EJ, 1986	Primary	5469	2009-01-01 00:00:00
Peniagone gracilis	4109	unknown	Primary	5470	2009-01-01 00:00:00
Amperima	4110	\N	Primary	5471	2009-01-01 00:00:00
Amperima robusta	4111	Theel, 1882	Primary	5472	2009-01-01 00:00:00
Pelagothuridae	4112	Ludwig, 1894	Primary	5473	2009-01-01 00:00:00
Enypniastes	4113	Theel, 1882	Primary	5474	2009-01-01 00:00:00
Aspidochirotida	4114	unknown	Primary	5475	2009-01-01 00:00:00
Stichopodidae	4115	unknown	Primary	5476	2009-01-01 00:00:00
Parastichopus	4116	unknown	Primary	5477	2009-01-01 00:00:00
Parastichopus leukothele	4117	unknown	Primary	5478	2009-01-01 00:00:00
Parastichopus johnsoni	4118	theel, 1886	Primary	5479	2009-01-01 00:00:00
Parastichopus californicus	4119	unknown	Primary	5480	2009-01-01 00:00:00
parastichopus-californicus	4119	unknown	Synonym	5481	2009-01-01 00:00:00
Stichopus	4120	unknown	Primary	5482	2009-01-01 00:00:00
Synallactidae	4121	unknown	Primary	5483	2009-01-01 00:00:00
Paelopadites	4122	unknown	Primary	5484	2009-01-01 00:00:00
Paelopadites confundus	4123	(Theel, 1882)	Primary	5485	2009-01-01 00:00:00
Meseres	4124	Ludwig, 1894	Primary	5486	2009-01-01 00:00:00
Pseudostichopus	4125	Theel 1882	Primary	5487	2009-01-01 00:00:00
Pseudostichopus mollis	4126	Theel, 1886	Primary	5488	2009-01-01 00:00:00
Bathyplotes	4127	Östergren, 1896	Primary	5489	2009-01-01 00:00:00
Dendrochirotida	4128	unknown	Primary	5490	2009-01-01 00:00:00
Cucumariidae	4129	Ludwig, 1894	Primary	5491	2009-01-01 00:00:00
cucumariidae	4129	Ludwig, 1894	Synonym	5492	2009-01-01 00:00:00
Abyssocucumis	4130	Heding,1942	Primary	5493	2009-01-01 00:00:00
abyssocucumis	4130	Heding,1942	Synonym	5494	2009-01-01 00:00:00
Abyssocucumis abyssorum	4131	Theel, 1886	Primary	5495	2009-01-01 00:00:00
abyssocucumis-abyssorum	4131	Theel, 1886	Synonym	5496	2009-01-01 00:00:00
Psolidae	4132	perrier, 1902	Primary	5497	2009-01-01 00:00:00
psolidae	4132	perrier, 1902	Synonym	5498	2009-01-01 00:00:00
Psolus	4133	unknown	Primary	5499	2009-01-01 00:00:00
psolus	4133	unknown	Synonym	5500	2009-01-01 00:00:00
Psolus chitonoides	4134	unknown	Primary	5501	2009-01-01 00:00:00
psolus-chitonoides	4134	unknown	Synonym	5502	2009-01-01 00:00:00
Psolus squamatus	4135	(koren, 1844)	Primary	5503	2009-01-01 00:00:00
psolus-squamatus	4135	(koren, 1844)	Synonym	5504	2009-01-01 00:00:00
Crinoidea	4136	unknown	Primary	5505	2009-01-01 00:00:00
sea-lilly	4136	unknown	Common	5506	2009-01-01 00:00:00
feather-star	4136	(n.o.d.c.)	Common	5507	2009-01-01 00:00:00
Comatulidina	4137	unknown	Primary	5508	2009-01-01 00:00:00
Comatulida	4137	unknown	Synonym	5509	2009-01-01 00:00:00
Antedonacea	4138	unknown	Primary	5510	2009-01-01 00:00:00
Antedonidae	4139	norman, 1865	Primary	5511	2009-01-01 00:00:00
Florometra	4140	a. h. clark, 1913	Primary	5512	2009-01-01 00:00:00
Florometra serratissima	4141	(a. h. clark, 1907)	Primary	5513	2009-01-01 00:00:00
Macrophreata	4142	A. H. Clark, 1909	Primary	5514	2009-01-01 00:00:00
Pentametrocrinidae	4143	unknown	Primary	5515	2009-01-01 00:00:00
Pentametrocrinus	4144	unknown	Primary	5516	2009-01-01 00:00:00
Pentametrocrinus paucispinulus	4145	Messing CG, 2008	Primary	5517	2009-01-01 00:00:00
Fariometra	4146	\N	Primary	5518	2009-01-01 00:00:00
Fariometra parvula	4147	\N	Primary	5519	2009-01-01 00:00:00
yellow-stalked crinoid	4148	unknown	Primary	5520	2009-01-01 00:00:00
Cyrtocrinida	4149		Primary	5521	2009-01-01 00:00:00
Hyocrinidae	4150	Carpenter, 1884	Primary	5522	2009-01-01 00:00:00
Hyocrinus	4151	unknown	Primary	5523	2009-01-01 00:00:00
Bourgueticrinida	4152	unknown	Primary	5524	2009-01-01 00:00:00
Bathycrinidae	4153	unknown	Primary	5525	2009-01-01 00:00:00
Stelleroidea	4154	Lamarck, 1816	Primary	5526	2009-01-01 00:00:00
Asteroidea	4155	unknown	Primary	5527	2009-01-01 00:00:00
sea-star	4155	(n.o.d.c.)	Common	5528	2009-01-01 00:00:00
Euclasterida	4156	Grzimek,1974	Primary	5529	2009-01-01 00:00:00
Brisingida	4157	Downey, 1986	Primary	5530	2009-01-01 00:00:00
Brisingina	4157	Fisher, 1928	Synonym	5531	2009-01-01 00:00:00
Brisingidae	4158	Sars, 1875	Primary	5532	2009-01-01 00:00:00
Brisinga	4159	unknown	Primary	5533	2009-01-01 00:00:00
Freyella	4160	unknown	Primary	5534	2009-01-01 00:00:00
Freyella microplax	4161	unknown	Primary	5535	2009-01-01 00:00:00
Freyellaster	4162	unknown	Primary	5536	2009-01-01 00:00:00
Freyellaster fecundus	4163	(Fisher, 1905)	Primary	5537	2009-01-01 00:00:00
freyellaster-fecundus	4163	(Fisher, 1905)	Synonym	5538	2009-01-01 00:00:00
Hymenodiscidae	4164	unknown	Primary	5539	2009-01-01 00:00:00
Hymenodiscus	4165	Perrier, 1884	Primary	5540	2009-01-01 00:00:00
hymenodiscus	4165	Perrier, 1884	Synonym	5541	2009-01-01 00:00:00
Spinulosida	4166	Perrier, 1884	Primary	5542	2009-01-01 00:00:00
Eugnathina	4167	unknown	Primary	5543	2009-01-01 00:00:00
Leptognathina	4168	Spencer and Wright, 1966	Primary	5544	2009-01-01 00:00:00
Echinasteridae	4169	Verrill, 1867	Primary	5545	2009-01-01 00:00:00
Henricia	4170	gray, 1840	Primary	5546	2009-01-01 00:00:00
Henricia sanguinolenta	4171	(O. F. Mueller, 1776)	Primary	5547	2009-01-01 00:00:00
Cribella sanguinolenta	4171	unknown	Synonym	5548	2009-01-01 00:00:00
Henricia aspera	4172	Fisher, 1906	Primary	5549	2009-01-01 00:00:00
Henricia asthenactis	4173	Fisher, 1910	Primary	5550	2009-01-01 00:00:00
Henricia cf. asthenactis	4174	\N	Primary	5551	2009-01-01 00:00:00
Poraniopsis	4175	perrier, 1891	Primary	5552	2009-01-01 00:00:00
Poraniopsis inflata	4176	unknown	Primary	5553	2009-01-01 00:00:00
poraniopsis-inflata	4176	unknown	Synonym	5554	2009-01-01 00:00:00
Echinaster	4177	Müller and Troschel, 1840	Primary	5555	2009-01-01 00:00:00
Valvatida	4178	unknown	Primary	5556	2009-01-01 00:00:00
Granulosina	4179	unknown	Primary	5557	2009-01-01 00:00:00
granulosina	4179	unknown	Synonym	5558	2009-01-01 00:00:00
Asteropsidae	4180	unknown	Primary	5559	2009-01-01 00:00:00
asteropsidae	4180	unknown	Synonym	5560	2009-01-01 00:00:00
Dermasterias	4181	perrier, 1881	Primary	5561	2009-01-01 00:00:00
leather-star	4181	unknown	Common	5562	2009-01-01 00:00:00
dermasterias	4181	perrier, 1881	Synonym	5563	2009-01-01 00:00:00
Dermasterias imbricata	4182	(grube, 1857)	Primary	5564	2009-01-01 00:00:00
dermasterias-imbricata	4182	(grube, 1857)	Synonym	5565	2009-01-01 00:00:00
Goniasteridae	4183	Forbes, 1841	Primary	5566	2009-01-01 00:00:00
goniasteridae	4183	Forbes, 1841	Synonym	5567	2009-01-01 00:00:00
Mediaster	4184	stimpson, 1857	Primary	5568	2009-01-01 00:00:00
mediaster	4184	stimpson, 1857	Synonym	5569	2009-01-01 00:00:00
Mediaster aequalis	4185	Stimpson, 1857	Primary	5570	2009-01-01 00:00:00
mediaster-aequalis	4185	Stimpson, 1857	Synonym	5571	2009-01-01 00:00:00
Mediaster tenellus	4186	fisher, 1911	Primary	5572	2009-01-01 00:00:00
mediaster-tenellus	4186	fisher, 1911	Synonym	5573	2009-01-01 00:00:00
Mediaster elegans	4187	unknown	Primary	5574	2009-01-01 00:00:00
mediaster-elegans	4187	unknown	Synonym	5575	2009-01-01 00:00:00
Hippasteria	4188	gray, 1840	Primary	5576	2009-01-01 00:00:00
hippasteria	4188	gray, 1840	Synonym	5577	2009-01-01 00:00:00
Hippasteria spinosa	4189	verrill, 1909	Primary	5578	2009-01-01 00:00:00
hippasteria-spinosa	4189	verrill, 1909	Synonym	5579	2009-01-01 00:00:00
Hippasteria californica	4190	unknown	Primary	5580	2009-01-01 00:00:00
hippasteria-californica	4190	unknown	Synonym	5581	2009-01-01 00:00:00
Pseudarchaster	4191	Sladen, 1889	Primary	5582	2009-01-01 00:00:00
pseudarchaster	4191	Sladen, 1889	Synonym	5583	2009-01-01 00:00:00
Pseudarchaster dissonus	4192	Fisher, 1910	Primary	5584	2009-01-01 00:00:00
pseudarchaster-dissonus	4192	Fisher, 1910	Synonym	5585	2009-01-01 00:00:00
Evoplosoma	4193	Fisher, 1906	Primary	5586	2009-01-01 00:00:00
evoplosoma	4193	Fisher, 1906	Synonym	5587	2009-01-01 00:00:00
Ceramaster	4194	Verrill, 1899	Primary	5588	2009-01-01 00:00:00
ceramaster	4194	Verrill, 1899	Synonym	5589	2009-01-01 00:00:00
Ceramaster patagonicus	4195	(Sladen, 1889)	Primary	5590	2009-01-01 00:00:00
ceramaster patagonicus	4195	(Sladen, 1889)	Synonym	5591	2009-01-01 00:00:00
Ceramaster clarki	4196	unknown	Primary	5592	2009-01-01 00:00:00
ceramaster clarki	4196	unknown	Synonym	5593	2009-01-01 00:00:00
Asterinidae	4197	gray, 1840	Primary	5594	2009-01-01 00:00:00
asterinidae	4197	gray, 1840	Synonym	5595	2009-01-01 00:00:00
Patiria	4198	unknown	Primary	5596	2009-01-01 00:00:00
patiria	4198	unknown	Synonym	5597	2009-01-01 00:00:00
Asterina	4199	nardo, 1943	Primary	5598	2009-01-01 00:00:00
batstar	4199	unknown	Common	5599	2009-01-01 00:00:00
asterina	4199	nardo, 1943	Synonym	5600	2009-01-01 00:00:00
Asterina miniata	4200	(brandt, 1835)	Primary	5601	2009-01-01 00:00:00
patiria-miniata	4200	unknown	Synonym	5602	2009-01-01 00:00:00
asterina-miniata	4200	(brandt, 1835)	Synonym	5603	2009-01-01 00:00:00
Forcipulatida	4201	unknown	Primary	5604	2009-01-01 00:00:00
Zoroasteridae	4202	Sladen, 1889	Primary	5605	2009-01-01 00:00:00
zoroasteridae	4202	Sladen, 1889	Synonym	5606	2009-01-01 00:00:00
Zoroaster	4203	wyville thomson 1873	Primary	5607	2009-01-01 00:00:00
zoroaster	4203	wyville thomson 1873	Synonym	5608	2009-01-01 00:00:00
Zoroaster ophiurus	4204	unknown	Primary	5609	2009-01-01 00:00:00
zoroaster-ophiurus	4204	unknown	Synonym	5610	2009-01-01 00:00:00
Zoroaster evermanni	4205	unknown	Primary	5611	2009-01-01 00:00:00
zoroaster-evermanni	4205	unknown	Synonym	5612	2009-01-01 00:00:00
Myxoderma	4206	Fisher, 1904	Primary	5613	2009-01-01 00:00:00
myxoderma	4206	Fisher, 1904	Synonym	5614	2009-01-01 00:00:00
Myxoderma sacculatum	4207	Fisher, 1904	Primary	5615	2009-01-01 00:00:00
myxoderma-sacculatum	4207	Fisher, 1904	Synonym	5616	2009-01-01 00:00:00
Myxoderma platyacanthum	4208	H.L. Clark, 1913	Primary	5617	2009-01-01 00:00:00
Asteriidae	4209	Gray, 1840	Primary	5618	2009-01-01 00:00:00
asteriidae	4209	Gray, 1840	Synonym	5619	2009-01-01 00:00:00
Pisaster	4210	mueller and troschel, 1840	Primary	5620	2009-01-01 00:00:00
pisaster	4210	mueller and troschel, 1840	Synonym	5621	2009-01-01 00:00:00
Pisaster brevispinus	4211	(stimpson, 1857)	Primary	5622	2009-01-01 00:00:00
pisaster-brevispinus	4211	(stimpson, 1857)	Synonym	5623	2009-01-01 00:00:00
Pisaster ochraceus	4212	(brandt, 1835)	Primary	5624	2009-01-01 00:00:00
pisaster-ochraceus	4212	(brandt, 1835)	Synonym	5625	2009-01-01 00:00:00
Pisaster giganteus	4213	(stimpson,1857)	Primary	5626	2009-01-01 00:00:00
pisaster-giganteus	4213	(stimpson,1857)	Synonym	5627	2009-01-01 00:00:00
Pycnopodia	4214	stimpson, 1862	Primary	5628	2009-01-01 00:00:00
pycnopodia	4214	stimpson, 1862	Synonym	5629	2009-01-01 00:00:00
Pycnopodia helianthoides	4215	(brandt, 1835)	Primary	5630	2009-01-01 00:00:00
pycnopodia-helianthoides	4215	(brandt, 1835)	Synonym	5631	2009-01-01 00:00:00
Orthasterias	4216	verrill	Primary	5632	2009-01-01 00:00:00
orthasterias	4216	verrill	Synonym	5633	2009-01-01 00:00:00
Orthasterias nybakken	4217	unknown	Primary	5634	2009-01-01 00:00:00
orthasterias-nybakken	4217	unknown	Synonym	5635	2009-01-01 00:00:00
Stylasterias	4218	verrill, 1914	Primary	5636	2009-01-01 00:00:00
stylasterias	4218	verrill, 1914	Synonym	5637	2009-01-01 00:00:00
Stylasterias forreri	4219	(deloriol, 1887)	Primary	5638	2009-01-01 00:00:00
stylasterias-forreri	4219	(deloriol, 1887)	Synonym	5639	2009-01-01 00:00:00
Evasterias	4220	unknown	Primary	5640	2009-01-01 00:00:00
evasterias	4220	unknown	Synonym	5641	2009-01-01 00:00:00
Evasterias troschelii	4221	(stimpson, 1862)	Primary	5642	2009-01-01 00:00:00
evasterias-troschelii	4221	(stimpson, 1862)	Synonym	5643	2009-01-01 00:00:00
Leptasterias	4222	unknown	Primary	5644	2009-01-01 00:00:00
leptasterias	4222	unknown	Synonym	5645	2009-01-01 00:00:00
Anteliaster	4223	Fisher, 1923	Primary	5646	2009-01-01 00:00:00
anteliaster	4223	Fisher, 1923	Synonym	5647	2009-01-01 00:00:00
Tarsaster	4224	Sladen, 1889	Primary	5648	2009-01-01 00:00:00
tarsaster	4224	Sladen, 1889	Synonym	5649	2009-01-01 00:00:00
Ampheraster	4225	Fisher, 1923	Primary	5650	2009-01-01 00:00:00
ampheraster	4225	Fisher, 1923	Synonym	5651	2009-01-01 00:00:00
Ampheraster marianus	4226	(Lugwig, 1905)	Primary	5652	2009-01-01 00:00:00
ampheraster marianus	4226	(Lugwig, 1905)	Synonym	5653	2009-01-01 00:00:00
Heliasteridae	4227	Viguier, 1878	Primary	5654	2009-01-01 00:00:00
heliasteridae	4227	Viguier, 1878	Synonym	5655	2009-01-01 00:00:00
Labidiasteridae	4228	Verril, 1914	Primary	5656	2009-01-01 00:00:00
labidiasteridae	4228	Verril, 1914	Synonym	5657	2009-01-01 00:00:00
Rathbunaster	4229	Fisher, 1906	Primary	5658	2009-01-01 00:00:00
rathbunaster	4229	Fisher, 1906	Synonym	5659	2009-01-01 00:00:00
Rathbunaster californicus	4230	fisher, 1906	Primary	5660	2009-01-01 00:00:00
rathbunaster-californicus	4230	fisher, 1906	Synonym	5661	2009-01-01 00:00:00
Pedicellasteridae	4231	Fisher, 1918	Primary	5662	2009-01-01 00:00:00
pedicellasteridae	4231	Fisher, 1918	Synonym	5663	2009-01-01 00:00:00
Pedicellaster	4232	Sars, 1861	Primary	5664	2009-01-01 00:00:00
pedicellaster	4232	Sars, 1861	Synonym	5665	2009-01-01 00:00:00
Pedicellaster magister	4233	Fisher, 1923	Primary	5666	2009-01-01 00:00:00
pedicellaster-magister	4233	Fisher, 1923	Synonym	5667	2009-01-01 00:00:00
Pedicellaster typicus	4234	Sars, 1861	Primary	5668	2009-01-01 00:00:00
pedicellaster-typicus	4234	Sars, 1861	Synonym	5669	2009-01-01 00:00:00
Hydrasterias	4235	Sladen, 1889	Primary	5670	2009-01-01 00:00:00
hydrasterias	4235	Sladen, 1889	Synonym	5671	2009-01-01 00:00:00
Neomorphasteridae	4236	Fisher, 1923	Primary	5672	2009-01-01 00:00:00
neomorphasteridae	4236	Fisher, 1923	Synonym	5673	2009-01-01 00:00:00
Paxillosida	4237	spencer, 1951	Primary	5674	2009-01-01 00:00:00
Porcellanasteridae	4238	unknown	Primary	5675	2009-01-01 00:00:00
porcellanasteridae	4238	unknown	Synonym	5676	2009-01-01 00:00:00
Cribellina	4239	unknown	Primary	5677	2009-01-01 00:00:00
cribellina	4239	unknown	Synonym	5678	2009-01-01 00:00:00
Goniopectinidae	4240	unknown	Primary	5679	2009-01-01 00:00:00
goniopectinidae	4240	unknown	Synonym	5680	2009-01-01 00:00:00
Ctenodiscus	4241	unknown	Primary	5681	2009-01-01 00:00:00
ctenodiscus	4241	unknown	Synonym	5682	2009-01-01 00:00:00
Ctenodiscus crispatus	4242	(retzius, 1805)	Primary	5683	2009-01-01 00:00:00
ctenodiscus-crispatus	4242	(retzius, 1805)	Synonym	5684	2009-01-01 00:00:00
Diplozonina	4243	unknown	Primary	5685	2009-01-01 00:00:00
diplozonina	4243	unknown	Synonym	5686	2009-01-01 00:00:00
Astropectinidae	4244	gray, 1840	Primary	5687	2009-01-01 00:00:00
Astropecten	4245	gray, 1840	Primary	5688	2009-01-01 00:00:00
astropecten	4245	gray, 1840	Synonym	5689	2009-01-01 00:00:00
Astropecten verrilli	4246	(fisher, 1906)	Primary	5690	2009-01-01 00:00:00
Astropecten californicus	4246	Fisher, 1906	Synonym	5691	2009-01-01 00:00:00
Dipsacaster	4247	Alcock, 1893	Primary	5692	2009-01-01 00:00:00
Platyasterida	4248	unknown	Primary	5693	2009-01-01 00:00:00
Platasteriidae	4249	unknown	Primary	5694	2009-01-01 00:00:00
platasteriidae	4249	unknown	Synonym	5695	2009-01-01 00:00:00
Luidiidae	4250	unknown	Primary	5696	2009-01-01 00:00:00
luidiidae	4250	unknown	Synonym	5697	2009-01-01 00:00:00
Luidia	4251	unknown	Primary	5698	2009-01-01 00:00:00
luidia	4251	unknown	Synonym	5699	2009-01-01 00:00:00
Luidia foliolata	4252	grube, 1866	Primary	5700	2009-01-01 00:00:00
luidia-foliolata	4252	grube, 1866	Synonym	5701	2009-01-01 00:00:00
Velatida	4253	(Blake, 1987)	Primary	5702	2009-01-01 00:00:00
Pterasteridae	4254	Perrier, 1875	Primary	5703	2009-01-01 00:00:00
pterasteridae	4254	Perrier, 1875	Synonym	5704	2009-01-01 00:00:00
Pteraster	4255	mueller and troschel, 1842	Primary	5705	2009-01-01 00:00:00
cushion-star	4255	unknown	Common	5706	2009-01-01 00:00:00
pteraster	4255	mueller and troschel, 1842	Synonym	5707	2009-01-01 00:00:00
Pteraster jordani	4256	unknown	Primary	5708	2009-01-01 00:00:00
pteraster-jordani	4256	unknown	Synonym	5709	2009-01-01 00:00:00
Pteraster tesselatus	4257	ives, 1888	Primary	5710	2009-01-01 00:00:00
pteraster-tesselatus	4257	ives, 1888	Synonym	5711	2009-01-01 00:00:00
Hymenaster	4258	unknown	Primary	5712	2009-01-01 00:00:00
hymenaster	4258	unknown	Synonym	5713	2009-01-01 00:00:00
Hymenaster koehleri	4259	unknown	Primary	5714	2009-01-01 00:00:00
hymenaster-koehleri	4259	unknown	Synonym	5715	2009-01-01 00:00:00
Solasteridae	4260	Perrier, 1884	Primary	5716	2009-01-01 00:00:00
solasteridae	4260	Perrier, 1884	Synonym	5717	2009-01-01 00:00:00
Lophaster	4261	verrill, 1878	Primary	5718	2009-01-01 00:00:00
Lophaster furcilliger	4262	Fisher, 1905	Primary	5719	2009-01-01 00:00:00
lophaster-furcilliger	4262	Fisher, 1905	Synonym	5720	2009-01-01 00:00:00
Crossaster	4263	unknown	Primary	5721	2009-01-01 00:00:00
Solaster	4264	forbes, 1839	Primary	5722	2009-01-01 00:00:00
Solaster dawsoni	4265	unknown	Primary	5723	2009-01-01 00:00:00
Solaster endeca	4266	Linnaeus, 1771	Primary	5724	2009-01-01 00:00:00
northern-sunstar	4266	unknown	Common	5725	2009-01-01 00:00:00
Crossaster borealis	4267	unknown	Primary	5726	2009-01-01 00:00:00
Solaster borealis	4268	(Fisher, 1906)	Primary	5727	2009-01-01 00:00:00
Korethrasteridae	4269	Danielsson and Koren, 1884	Primary	5728	2009-01-01 00:00:00
korethrasteridae	4269	Danielsson and Koren, 1884	Synonym	5729	2009-01-01 00:00:00
Peribolaster	4270	Sladen, 1998	Primary	5730	2009-01-01 00:00:00
peribolaster	4270	Sladen, 1998	Synonym	5731	2009-01-01 00:00:00
Peribolaster biserialis	4271	Fisher, 1905	Primary	5732	2009-01-01 00:00:00
peribolaster-biserialis	4271	Fisher, 1905	Synonym	5733	2009-01-01 00:00:00
Caymanostellidae	4272	Belyaev, 1990	Primary	5734	2009-01-01 00:00:00
caymanostellidae	4272	Belyaev, 1990	Synonym	5735	2009-01-01 00:00:00
Caymanostella	4273	unknown	Primary	5736	2009-01-01 00:00:00
caymanostella	4273	unknown	Synonym	5737	2009-01-01 00:00:00
Ophiuroidea	4274	gray, 1840	Primary	5738	2009-01-01 00:00:00
ophiuroidea	4274	gray, 1840	Synonym	5739	2009-01-01 00:00:00
Phrynophiurida	4275	matsumoto, 1915	Primary	5740	2009-01-01 00:00:00
euryhaline-brittle-star	4275	(n.o.d.c.)	Common	5741	2009-01-01 00:00:00
phrynophiurida	4275	matsumoto, 1915	Synonym	5742	2009-01-01 00:00:00
Amphiuridae	4276	ljungman, 1867	Primary	5743	2009-01-01 00:00:00
amphiuridae	4276	ljungman, 1867	Synonym	5744	2009-01-01 00:00:00
Amphiura	4277	forbes, 1942	Primary	5745	2009-01-01 00:00:00
amphiura	4277	forbes, 1942	Synonym	5746	2009-01-01 00:00:00
Amphiura otteri	4278	unknown	Primary	5747	2009-01-01 00:00:00
amphiura-otteri	4278	unknown	Synonym	5748	2009-01-01 00:00:00
Amphiura carchara	4279	h. l. clark, 1911	Primary	5749	2009-01-01 00:00:00
amphiura-carchara	4279	h. l. clark, 1911	Synonym	5750	2009-01-01 00:00:00
Ophiurida	4280	unknown	Primary	5751	2009-01-01 00:00:00
brittle-star	4280	unknown	Common	5752	2009-01-01 00:00:00
ophiurida	4280	unknown	Synonym	5753	2009-01-01 00:00:00
Euryalina	4281	unknown	Primary	5754	2009-01-01 00:00:00
euryalina	4281	unknown	Synonym	5755	2009-01-01 00:00:00
Gorgonocephalidae	4282	ljungman, 1867	Primary	5756	2009-01-01 00:00:00
basket-star	4282	unknown	Common	5757	2009-01-01 00:00:00
gorgonocephalidae	4282	ljungman, 1867	Synonym	5758	2009-01-01 00:00:00
Gorgonocephalus	4283	leach, 1815	Primary	5759	2009-01-01 00:00:00
gorgonocephalus	4283	leach, 1815	Synonym	5760	2009-01-01 00:00:00
Gorgonocephalus eucnemis	4284	Mueller and Troschel, 1842	Primary	5761	2009-01-01 00:00:00
gorgonocephalus-japonicus	4284	unknown	Synonym	5762	2009-01-01 00:00:00
gorgonocephalus-eucnemis	4284	Mueller and Troschel, 1842	Synonym	5763	2009-01-01 00:00:00
Asteronychidae	4285	mueller and troschel,1842	Primary	5764	2009-01-01 00:00:00
asteronychidae	4285	mueller and troschel,1842	Synonym	5765	2009-01-01 00:00:00
Asteronyx	4286	mueller and troschel,1842	Primary	5766	2009-01-01 00:00:00
asteronyx	4286	mueller and troschel,1842	Synonym	5767	2009-01-01 00:00:00
Asteronyx loveni	4287	mueller & mortensen, 1899	Primary	5768	2009-01-01 00:00:00
asteronyx-loveni	4287	mueller & mortensen, 1899	Synonym	5769	2009-01-01 00:00:00
Asteronyx longifissus	4288	unknown	Primary	5770	2009-01-01 00:00:00
asteronyx-longifissus	4288	unknown	Synonym	5771	2009-01-01 00:00:00
Laemophiurina	4289	unknown	Primary	5772	2009-01-01 00:00:00
laemophiurina	4289	unknown	Synonym	5773	2009-01-01 00:00:00
Ophiacanthidae	4290	perrier, 1891	Primary	5774	2009-01-01 00:00:00
ophiacanthidae	4290	perrier, 1891	Synonym	5775	2009-01-01 00:00:00
Ophiopthalmus	4291	matsumoto, 1917	Primary	5776	2009-01-01 00:00:00
ophiopthalmus	4291	matsumoto, 1917	Synonym	5777	2009-01-01 00:00:00
Ophiopthalmus normani	4292	(lyman, 1897)	Primary	5778	2009-01-01 00:00:00
ophiacantha-normani	4292	(lyman, 1879)	Synonym	5779	2009-01-01 00:00:00
ophiopthalmus-normani	4292	(lyman, 1897)	Synonym	5780	2009-01-01 00:00:00
Ophiolimna	4293	verrill, 1899	Primary	5781	2009-01-01 00:00:00
ophiolimna	4293	verrill, 1899	Synonym	5782	2009-01-01 00:00:00
Ophiolimna bairdi	4294	(lyman, 1883)	Primary	5783	2009-01-01 00:00:00
ophiacantha-bairdi	4294	unknown	Synonym	5784	2009-01-01 00:00:00
ophiolimna-bairdi	4294	(lyman, 1883)	Synonym	5785	2009-01-01 00:00:00
Ophiacantha	4295	Müller and Troschel, 1842	Primary	5786	2009-01-01 00:00:00
ophiacantha	4295	Müller and Troschel, 1842	Synonym	5787	2009-01-01 00:00:00
Chilophiurina	4296	unknown	Primary	5788	2009-01-01 00:00:00
chilophiurina	4296	unknown	Synonym	5789	2009-01-01 00:00:00
Ophiuridae	4297	lyman, 1865	Primary	5790	2009-01-01 00:00:00
ophiuridae	4297	lyman, 1865	Synonym	5791	2009-01-01 00:00:00
Ophiocten	4298	unknown	Primary	5792	2009-01-01 00:00:00
ophiocten	4298	unknown	Synonym	5793	2009-01-01 00:00:00
Ophiocten hastatum	4299	lyman, 1878	Primary	5794	2009-01-01 00:00:00
ophiocten-hastatum	4299	lyman, 1878	Synonym	5795	2009-01-01 00:00:00
Ophiura	4300	lamarck, 1816	Primary	5796	2009-01-01 00:00:00
ophiura	4300	lamarck, 1816	Synonym	5797	2009-01-01 00:00:00
Ophiura leptoctenia	4301	h. l. clark, 1911	Primary	5798	2009-01-01 00:00:00
ophiura-leptoctenia	4301	h. l. clark, 1911	Synonym	5799	2009-01-01 00:00:00
Chaetognatha	4302	unknown	Primary	5800	2009-01-01 00:00:00
arrow-worm	4302	(n.o.d.c.)	Common	5801	2009-01-01 00:00:00
Sagittoidea	4303	Claus and Grobben, 1905	Primary	5802	2009-01-01 00:00:00
Aphragmophora	4304	unknown	Primary	5803	2009-01-01 00:00:00
Pterosagittidae	4305	unknown	Primary	5804	2009-01-01 00:00:00
Pterosagitta	4306	costa, 1969	Primary	5805	2009-01-01 00:00:00
Pterosagitta draco	4307	(krohn, 1853)	Primary	5806	2009-01-01 00:00:00
Spadella draco	4307	Krohn, 1853	Synonym	5807	2009-01-01 00:00:00
Sagittidae	4308	unknown	Primary	5808	2009-01-01 00:00:00
Ferosagitta	4309	unknown	Primary	5809	2009-01-01 00:00:00
Ferosagitta robusta	4310	(Doncaster, 1902)	Primary	5810	2009-01-01 00:00:00
Sagitta robusta	4310	Doncaster, 1902	Synonym	5811	2009-01-01 00:00:00
Ferosagitta ferox	4311	(Doncaster, 1902)	Primary	5812	2009-01-01 00:00:00
Sagitta ferox	4311	Doncaster, 1902	Synonym	5813	2009-01-01 00:00:00
Caecosagitta	4312	tokioka, 1965	Primary	5814	2009-01-01 00:00:00
Caecosagitta macrocephala	4313	(Fowler, 1904)	Primary	5815	2009-01-01 00:00:00
orange-gut-chaetognath	4313	unknown	Common	5816	2009-01-01 00:00:00
Sagitta macrocephala	4313	Fowler, 1904	Synonym	5817	2009-01-01 00:00:00
Sagitta	4314	quoy and gaimard, 1827	Primary	5818	2009-01-01 00:00:00
Pseudosagitta	4315	germain and joubin, 1912	Primary	5819	2009-01-01 00:00:00
Pseudosagitta lyra	4316	(Krohn, 1853)	Primary	5820	2009-01-01 00:00:00
Sagitta lyra	4316	krohn, 1853	Synonym	5821	2009-01-01 00:00:00
Pseudosagitta maxima	4317	(Conant, 1896)	Primary	5822	2009-01-01 00:00:00
Sagitta maxima	4317	Conant, 1896	Synonym	5823	2009-01-01 00:00:00
 Solidosagitta	4318	Tokioka, 1965	Primary	5824	2009-01-01 00:00:00
Solidosagitta zetesios	4319	Fowler, 1905	Primary	5825	2009-01-01 00:00:00
Phragmophora	4320	Tokioka, 1965	Primary	5826	2009-01-01 00:00:00
Eukrohniidae	4321	Tokioka, 1965	Primary	5827	2009-01-01 00:00:00
Eukrohnia	4322	Ritter-Z·hony, 1909	Primary	5828	2009-01-01 00:00:00
Eukrohnia fowleri	4323	Ritter-Z·hony, 1909	Primary	5829	2009-01-01 00:00:00
Eukrohnia hamata	4324	Möbius, 1875	Primary	5830	2009-01-01 00:00:00
Heterokrohnia	4325	Ritter-zahony, 1911	Primary	5831	2009-01-01 00:00:00
Bathyspadellidae	4326	\N	Primary	5832	2009-01-01 00:00:00
Bathyspadella	4327	Tokioka, 1939	Primary	5833	2009-01-01 00:00:00
Chordata	4328	unknown	Primary	5834	2009-01-01 00:00:00
Vertebrata	4329	unknown	Primary	5835	2009-01-01 00:00:00
Agnatha	4330	unknown	Primary	5836	2009-01-01 00:00:00
jawless-fish	4330	(n.o.d.c.)	Common	5837	2009-01-01 00:00:00
Cephalaspidomorphi	4331	unknown	Primary	5838	2009-01-01 00:00:00
cephalaspidomorpha	4331	unknown	Synonym	5839	2009-01-01 00:00:00
lamprey	4331	unknown	Common	5840	2009-01-01 00:00:00
cephalaspidomorphi	4331	unknown	Synonym	5841	2009-01-01 00:00:00
Petromyzontiformes	4332	unknown	Primary	5842	2009-01-01 00:00:00
petromyzontiformes	4332	unknown	Synonym	5843	2009-01-01 00:00:00
Petromyzontidae	4333	unknown	Primary	5844	2009-01-01 00:00:00
petromyzontidae	4333	unknown	Synonym	5845	2009-01-01 00:00:00
Petromyzontinae	4334	unknown	Primary	5846	2009-01-01 00:00:00
petromyzontinae	4334	unknown	Synonym	5847	2009-01-01 00:00:00
Lampetra	4335	Bonnaterre, 1788	Primary	5848	2009-01-01 00:00:00
entosphenus	4335	unknown	Synonym	5849	2009-01-01 00:00:00
lampetra	4335	Bonnaterre, 1788	Synonym	5850	2009-01-01 00:00:00
Lampetra tridentata	4336	(Richardson, 1836)	Primary	5851	2009-01-01 00:00:00
pacific-lamprey	4336	unknown	Common	5852	2009-01-01 00:00:00
lampetra-tridentata	4336	(Richardson, 1836)	Synonym	5853	2009-01-01 00:00:00
Myxiniformes	4337	unknown	Primary	5854	2009-01-01 00:00:00
myxiniformes	4337	unknown	Synonym	5855	2009-01-01 00:00:00
Myxinidae	4338	unknown	Primary	5856	2009-01-01 00:00:00
hagfish	4338	unknown	Common	5857	2009-01-01 00:00:00
myxinidae	4338	unknown	Synonym	5858	2009-01-01 00:00:00
Eptatretus	4339	unknown	Primary	5859	2009-01-01 00:00:00
paramyxine	4339	unknown	Synonym	5860	2009-01-01 00:00:00
eptatretus	4339	unknown	Synonym	5861	2009-01-01 00:00:00
Eptatretus deani	4340	Everm. and Goldsb.	Primary	5862	2009-01-01 00:00:00
black-hagfish	4340	amer. fisheries society, 1980	Common	5863	2009-01-01 00:00:00
eptatretus-deani	4340	Everm. and Goldsb.	Synonym	5864	2009-01-01 00:00:00
Eptatretus stoutii	4341	unknown	Primary	5865	2009-01-01 00:00:00
pacific-hagfish	4341	unknown	Common	5866	2009-01-01 00:00:00
eptatretus-stoutii	4341	unknown	Synonym	5867	2009-01-01 00:00:00
Mammalia	4342	unknown	Primary	5868	2009-01-01 00:00:00
Cetacea	4343	unknown	Primary	5869	2009-01-01 00:00:00
whale	4343	banks et al, 1987	Common	5870	2009-01-01 00:00:00
cetacean	4343	(n.o.d.c.)	Common	5871	2009-01-01 00:00:00
Odontoceti	4344	unknown	Primary	5872	2009-01-01 00:00:00
toothed-whale	4344	unknown	Common	5873	2009-01-01 00:00:00
Delphinidae	4345	unknown	Primary	5874	2009-01-01 00:00:00
dolphin	4345	banks et al, 1987	Common	5875	2009-01-01 00:00:00
Phocoena	4346	g. cuvier, 1817	Primary	5876	2009-01-01 00:00:00
common-name-porpoise	4346	banks et al, 1987	Common	5877	2009-01-01 00:00:00
phocoena	4346	g. cuvier, 1817	Synonym	5878	2009-01-01 00:00:00
Phocoena sinus	4347	unknown	Primary	5879	2009-01-01 00:00:00
Phocoena spinipinnis	4348	unknown	Primary	5880	2009-01-01 00:00:00
Phocoena dioptrica	4349	unknown	Primary	5881	2009-01-01 00:00:00
Phocoena phocoena	4350	(linnaeus, 1758)	Primary	5882	2009-01-01 00:00:00
harbor-porpoise	4350	banks et al, 1987	Common	5883	2009-01-01 00:00:00
Lissodelphis	4351	unknown	Primary	5884	2009-01-01 00:00:00
Lissodelphis borealis	4352	unknown	Primary	5885	2009-01-01 00:00:00
northern-right-whale-dolphin	4352	unknown	Common	5886	2009-01-01 00:00:00
Lagenorhynchus	4353	gray, 1846	Primary	5887	2009-01-01 00:00:00
Lagenorhynchus obliquidens	4354	gill, 1865	Primary	5888	2009-01-01 00:00:00
pacific-white-sided-dolphin	4354	banks et al, 1987	Common	5889	2009-01-01 00:00:00
Phocoenoides	4355	unknown	Primary	5890	2009-01-01 00:00:00
Phocoenoides dalli	4356	unknown	Primary	5891	2009-01-01 00:00:00
Orcinus	4357	fitzinger, 1860	Primary	5892	2009-01-01 00:00:00
Orcinus orca	4358	(linnaeus, 1758)	Primary	5893	2009-01-01 00:00:00
killer-whale	4358	banks et al, 1987	Common	5894	2009-01-01 00:00:00
Ziphiidae	4359	unknown	Primary	5895	2009-01-01 00:00:00
beaked-whale	4359	unknown	Common	5896	2009-01-01 00:00:00
Mesoplodon	4360	unknown	Primary	5897	2009-01-01 00:00:00
Mesoplodon perrini	4361	unknown	Primary	5898	2009-01-01 00:00:00
Mysticeti	4362	unknown	Primary	5899	2009-01-01 00:00:00
baleen-whale	4362	unknown	Common	5900	2009-01-01 00:00:00
Eschrichtiidae	4363	unknown	Primary	5901	2009-01-01 00:00:00
Eschrichtius	4364	gray, 1864	Primary	5902	2009-01-01 00:00:00
Eschrichtius robustus	4365	(lilljeborg, 1861)	Primary	5903	2009-01-01 00:00:00
gray-whale	4365	unknown	Common	5904	2009-01-01 00:00:00
grey-whale	4365	banks et al, 1987	Common	5905	2009-01-01 00:00:00
Balaenopteridae	4366	unknown	Primary	5906	2009-01-01 00:00:00
Megapterinae	4367	unknown	Primary	5907	2009-01-01 00:00:00
Megaptera	4368	gray, 1846	Primary	5908	2009-01-01 00:00:00
Megaptera novaeangliae	4369	(borowski, 1781)	Primary	5909	2009-01-01 00:00:00
humpback-whale	4369	banks et al, 1987	Common	5910	2009-01-01 00:00:00
Balaenoptera	4370	lacepede, 1804	Primary	5911	2009-01-01 00:00:00
finback-whale	4370	banks et al, 1987	Common	5912	2009-01-01 00:00:00
Balaenoptera musculus	4371	(linnaeus, 1758)	Primary	5913	2009-01-01 00:00:00
blue-whale	4371	banks et al, 1987	Common	5914	2009-01-01 00:00:00
Carnivora	4372	unknown	Primary	5915	2009-01-01 00:00:00
carnivore	4372	(n.o.d.c.)	Common	5916	2009-01-01 00:00:00
Mustelidae	4373	unknown	Primary	5917	2009-01-01 00:00:00
Enhydra	4374	fleming, 1822	Primary	5918	2009-01-01 00:00:00
sea-otter	4374	banks et al, 1987	Common	5919	2009-01-01 00:00:00
Enhydra lutris	4375	(linnaeus, 1758)	Primary	5920	2009-01-01 00:00:00
Pinnipedia	4376	unknown	Primary	5921	2009-01-01 00:00:00
Phocidae	4377	unknown	Primary	5922	2009-01-01 00:00:00
true-seal	4377	unknown	Common	5923	2009-01-01 00:00:00
earless-seal	4377	banks et al, 1987	Common	5924	2009-01-01 00:00:00
Mirounga	4378	gray, 1827	Primary	5925	2009-01-01 00:00:00
elephant-seal	4378	banks et al, 1987	Common	5926	2009-01-01 00:00:00
Mirounga leonina	4379	unknown	Primary	5927	2009-01-01 00:00:00
Mirounga angustirostris	4380	(gill, 1866)	Primary	5928	2009-01-01 00:00:00
northern-elephant-seal	4380	banks et al, 1987	Common	5929	2009-01-01 00:00:00
Phoca	4381	linnaeus, 1758	Primary	5930	2009-01-01 00:00:00
harbor-seal	4381	unknown	Common	5931	2009-01-01 00:00:00
hair-seal	4381	banks et al, 1987	Common	5932	2009-01-01 00:00:00
Phoca vitulina	4382	linnaeus, 1758	Primary	5933	2009-01-01 00:00:00
pacific-harbor-seal	4382	unknown	Common	5934	2009-01-01 00:00:00
Otariidae	4383	unknown	Primary	5935	2009-01-01 00:00:00
sea-lion	4383	unknown	Common	5936	2009-01-01 00:00:00
eared-seal	4383	banks et al, 1987	Common	5937	2009-01-01 00:00:00
Zalophus	4384	gill, 1866	Primary	5938	2009-01-01 00:00:00
california-sea-lion	4384	banks et al, 1987	Common	5939	2009-01-01 00:00:00
Zalophus californianus	4385	(lesson, 1828)	Primary	5940	2009-01-01 00:00:00
Aves	4386	unknown	Primary	5941	2009-01-01 00:00:00
bird	4386	(n.o.d.c.)	Common	5942	2009-01-01 00:00:00
Procellariiformes	4387	unknown	Primary	5943	2009-01-01 00:00:00
tube-nosed-swimmer	4387	banks et al, 1987	Common	5944	2009-01-01 00:00:00
procellariiformes	4387	unknown	Synonym	5945	2009-01-01 00:00:00
Diomedeidae	4388	unknown	Primary	5946	2009-01-01 00:00:00
diomedeidae	4388	unknown	Synonym	5947	2009-01-01 00:00:00
Diomedea	4389	unknown	Primary	5948	2009-01-01 00:00:00
albatross	4389	banks et al, 1987	Common	5949	2009-01-01 00:00:00
diomedea	4389	unknown	Synonym	5950	2009-01-01 00:00:00
Gnathostomata	4390	unknown	Primary	5951	2009-01-01 00:00:00
Teleostomi	4391	unknown	Primary	5952	2009-01-01 00:00:00
Osteichthyes	4392	unknown	Primary	5953	2009-01-01 00:00:00
Pleuronectiformes 2	4393	unknown	Primary	5954	2009-01-01 00:00:00
pleuronectiformes-larval-flatfish	4393	unknown	Common	5955	2009-01-01 00:00:00
larval-flatfish	4393	unknown	Common	5956	2009-01-01 00:00:00
Actinopterygii	4394	unknown	Primary	5957	2009-01-01 00:00:00
ray-finned-fish	4394	unknown	Common	5958	2009-01-01 00:00:00
Neopterygii	4395	unknown	Primary	5959	2009-01-01 00:00:00
Teleostei	4396	unknown	Primary	5960	2009-01-01 00:00:00
Clupeomorpha	4397	unknown	Primary	5961	2009-01-01 00:00:00
Clupeiformes	4398	unknown	Primary	5962	2009-01-01 00:00:00
clupeiformes	4398	unknown	Synonym	5963	2009-01-01 00:00:00
Engraulidae	4399	unknown	Primary	5964	2009-01-01 00:00:00
anchovy	4399	unknown	Common	5965	2009-01-01 00:00:00
engraulidae	4399	unknown	Synonym	5966	2009-01-01 00:00:00
Engraulis	4400	unknown	Primary	5967	2009-01-01 00:00:00
engraulis	4400	unknown	Synonym	5968	2009-01-01 00:00:00
Engraulis mordax	4401	girard, 1854	Primary	5969	2009-01-01 00:00:00
northern-anchovy	4401	amer. fisheries society, 1980	Common	5970	2009-01-01 00:00:00
engraulis-mordax	4401	girard, 1854	Synonym	5971	2009-01-01 00:00:00
Clupeidae	4402	unknown	Primary	5972	2009-01-01 00:00:00
herring	4402	amer. fisheries society, 1992	Common	5973	2009-01-01 00:00:00
clupeidae	4402	unknown	Synonym	5974	2009-01-01 00:00:00
Sardinops	4403	unknown	Primary	5975	2009-01-01 00:00:00
sardinops	4403	unknown	Synonym	5976	2009-01-01 00:00:00
Sardinops sagax	4404	(jenyns, 1842)	Primary	5977	2009-01-01 00:00:00
california-sardine	4404	shiino, 1978	Common	5978	2009-01-01 00:00:00
sardinops-sagax-caeruleus	4404	unknown	Synonym	5979	2009-01-01 00:00:00
pacific-sardine	4404	amer. fisheries society, 1980	Common	5980	2009-01-01 00:00:00
sardinops-sagax	4404	(jenyns, 1842)	Synonym	5981	2009-01-01 00:00:00
Clupea	4405	unknown	Primary	5982	2009-01-01 00:00:00
clupea	4405	unknown	Synonym	5983	2009-01-01 00:00:00
Clupea pallasii	4406	unknown	Primary	5984	2009-01-01 00:00:00
pacific-herring	4406	unknown	Common	5985	2009-01-01 00:00:00
clupea-pallasii	4406	unknown	Synonym	5986	2009-01-01 00:00:00
Euteleostei	4407	unknown	Primary	5987	2009-01-01 00:00:00
Paracanthopterygii	4408	unknown	Primary	5988	2009-01-01 00:00:00
Gadiformes	4409	unknown	Primary	5989	2009-01-01 00:00:00
gadiformes	4409	unknown	Synonym	5990	2009-01-01 00:00:00
Merlucciidae	4410	unknown	Primary	5991	2009-01-01 00:00:00
hake	4410	shiino, 1978	Common	5992	2009-01-01 00:00:00
Merluccius	4411	unknown	Primary	5993	2009-01-01 00:00:00
merluccius	4411	unknown	Synonym	5994	2009-01-01 00:00:00
Merluccius productus	4412	(ayres)	Primary	5995	2009-01-01 00:00:00
pacific-hake	4412	amer. fisheries society, 1980	Common	5996	2009-01-01 00:00:00
merluccius-productus	4412	(ayres)	Synonym	5997	2009-01-01 00:00:00
Moridae	4413	unknown	Primary	5998	2009-01-01 00:00:00
mora	4413	unknown	Common	5999	2009-01-01 00:00:00
deepsea-codfish	4413	shiino, 1978	Common	6000	2009-01-01 00:00:00
codling	4413	amer. fisheries society, 1991	Common	6001	2009-01-01 00:00:00
Physiculus	4414	unknown	Primary	6002	2009-01-01 00:00:00
physiculus	4414	unknown	Synonym	6003	2009-01-01 00:00:00
Physiculus rastrelliger	4415	gilbert, 1890	Primary	6004	2009-01-01 00:00:00
hundred-fathom-codling	4415	amer. fisheries society, 1991	Common	6005	2009-01-01 00:00:00
physiculus-rastrelliger	4415	gilbert, 1890	Synonym	6006	2009-01-01 00:00:00
Antimora	4416	unknown	Primary	6007	2009-01-01 00:00:00
Antimora microlepis	4417	bean, 1890	Primary	6008	2009-01-01 00:00:00
pacific-flatnose	4417	amer. fisheries society, 1991	Common	6009	2009-01-01 00:00:00
antimora-microlepis	4417	bean, 1890	Synonym	6010	2009-01-01 00:00:00
Lepidion	4418	Swainson, 1838	Primary	6011	2009-01-01 00:00:00
Gadidae	4419	unknown	Primary	6012	2009-01-01 00:00:00
cod	4419	unknown	Common	6013	2009-01-01 00:00:00
true-cod	4419	unknown	Common	6014	2009-01-01 00:00:00
codfish	4419	shiino, 1978	Common	6015	2009-01-01 00:00:00
Gadus macrocephalus	4420	Tilesius, 1810	Primary	6016	2009-01-01 00:00:00
pacific-cod	4420	unknown	Common	6017	2009-01-01 00:00:00
gadus-macrocephalus	4420	Tilesius, 1810	Synonym	6018	2009-01-01 00:00:00
Gadus	4421	unknown	Primary	6019	2009-01-01 00:00:00
gadus	4421	unknown	Synonym	6020	2009-01-01 00:00:00
Theragra	4422	unknown	Primary	6021	2009-01-01 00:00:00
theragra	4422	unknown	Synonym	6022	2009-01-01 00:00:00
Theragra chalcogramma	4423	unknown	Primary	6023	2009-01-01 00:00:00
walleye-pollock	4423	unknown	Common	6024	2009-01-01 00:00:00
theragra-chalcogramma	4423	unknown	Synonym	6025	2009-01-01 00:00:00
Microgadus	4424	unknown	Primary	6026	2009-01-01 00:00:00
microgadus	4424	unknown	Synonym	6027	2009-01-01 00:00:00
Microgadus proximus	4425	girard, 1854	Primary	6028	2009-01-01 00:00:00
pacific-tomcod	4425	amer. fisheries society, 1980	Common	6029	2009-01-01 00:00:00
microgadus-proximus	4425	girard, 1854	Synonym	6030	2009-01-01 00:00:00
Macrouroidei	4426	unknown	Primary	6031	2009-01-01 00:00:00
Macrouridae	4427	unknown	Primary	6032	2009-01-01 00:00:00
rattail	4427	unknown	Common	6033	2009-01-01 00:00:00
grenadier	4427	shiino, 1978	Common	6034	2009-01-01 00:00:00
Nezumia	4428	unknown	Primary	6035	2009-01-01 00:00:00
Nezumia liolepis	4429	(Gilbert, 1890)	Primary	6036	2009-01-01 00:00:00
smooth-grenadier	4429	unknown	Common	6037	2009-01-01 00:00:00
Nezumia stelgidolepis	4430	unknown	Primary	6038	2009-01-01 00:00:00
california-grenadier	4430	amer. fisheries society, 1980	Common	6039	2009-01-01 00:00:00
Coelorinchus	4431	unknown	Primary	6040	2009-01-01 00:00:00
Coelorinchus scaphopsis	4432	(Gilbert, 1890)	Primary	6041	2009-01-01 00:00:00
shoulderspot-grenadier	4432	unknown	Common	6042	2009-01-01 00:00:00
Albatrossia	4433	unknown	Primary	6043	2009-01-01 00:00:00
Albatrossia pectoralis	4434	(Gilbert, 1892)	Primary	6044	2009-01-01 00:00:00
giant-grenadier	4434	unknown	Common	6045	2009-01-01 00:00:00
Mesobius	4435	unknown	Primary	6046	2009-01-01 00:00:00
Mesobius berryi	4436	Hubbs & Iwamoto, 1977	Primary	6047	2009-01-01 00:00:00
midwater-grenadier	4436	unknown	Common	6048	2009-01-01 00:00:00
berry`s-grenadier	4436	unknown	Common	6049	2009-01-01 00:00:00
Coryphaenoides	4437	unknown	Primary	6050	2009-01-01 00:00:00
Coryphaenoides leptolepis	4438	G¸nther, 1877	Primary	6051	2009-01-01 00:00:00
ghostly-grenadier	4438	unknown	Common	6052	2009-01-01 00:00:00
Coryphaenoides cinereus	4439	Gilbert	Primary	6053	2009-01-01 00:00:00
Coryphaenoides filifer	4440	(Gilbert, 1896)	Primary	6054	2009-01-01 00:00:00
filamented-rattail	4440	unknown	Common	6055	2009-01-01 00:00:00
filamented-grenadier	4440	unknown	Common	6056	2009-01-01 00:00:00
threadfin-grenadier	4440	unknown	Common	6057	2009-01-01 00:00:00
Coryphaenoides acrolepis	4441	(bean)	Primary	6058	2009-01-01 00:00:00
pacific-grenadier	4441	unknown	Common	6059	2009-01-01 00:00:00
pacific-rattail	4441	unknown	Common	6060	2009-01-01 00:00:00
roughscale-rattail	4441	shiino, 1978	Common	6061	2009-01-01 00:00:00
Coryphaenoides yaquinae	4442	Iwamoto & Stein, 1974	Primary	6062	2009-01-01 00:00:00
Coryphaenoides armatus	4443	(Hector, 1875)	Primary	6063	2009-01-01 00:00:00
abyssal-grenadier	4443	unknown	Common	6064	2009-01-01 00:00:00
Coryphaenoides armatus/yaquinae complex	4444	\N	Primary	6065	2009-01-01 00:00:00
Melanonidae	4445	unknown	Primary	6066	2009-01-01 00:00:00
pelagic-cod	4445	unknown	Common	6067	2009-01-01 00:00:00
Melanonus	4446	unknown	Primary	6068	2009-01-01 00:00:00
melanonus	4446	unknown	Synonym	6069	2009-01-01 00:00:00
Melanonus zugmayeri	4447	Norman, 1930	Primary	6070	2009-01-01 00:00:00
arrowtail	4447	unknown	Common	6071	2009-01-01 00:00:00
melanonus-zugmayeri	4447	Norman, 1930	Synonym	6072	2009-01-01 00:00:00
Bregmacerotidae	4448	Gill, 1872	Primary	6073	2009-01-01 00:00:00
codfishes	4448	unknown	Common	6074	2009-01-01 00:00:00
Bregmaceros	4449	Thompson, 1840	Primary	6075	2009-01-01 00:00:00
bregmaceros	4449	Thompson, 1840	Synonym	6076	2009-01-01 00:00:00
Bregmaceros bathymaster	4450	Jordan and Bollman, 1889	Primary	6077	2009-01-01 00:00:00
bregmaceros-bathymaster	4450	Jordan and Bollman, 1889	Synonym	6078	2009-01-01 00:00:00
Batrachoidiformes	4451	unknown	Primary	6079	2009-01-01 00:00:00
batrachoidiformes	4451	unknown	Synonym	6080	2009-01-01 00:00:00
Batrachoididae	4452	unknown	Primary	6081	2009-01-01 00:00:00
toadfish	4452	Shiino, 1978	Common	6082	2009-01-01 00:00:00
midshipman	4452	unknown	Common	6083	2009-01-01 00:00:00
batrachoididae	4452	unknown	Synonym	6084	2009-01-01 00:00:00
Porichthys	4453	unknown	Primary	6085	2009-01-01 00:00:00
porichthys	4453	unknown	Synonym	6086	2009-01-01 00:00:00
Porichthys notatus	4454	girard	Primary	6087	2009-01-01 00:00:00
plainfin-midshipman	4454	amer. fisheries society, 1980	Common	6088	2009-01-01 00:00:00
porichthys-notatus	4454	girard	Synonym	6089	2009-01-01 00:00:00
Lophiiformes	4455	unknown	Primary	6090	2009-01-01 00:00:00
anglerfish	4455	unknown	Common	6091	2009-01-01 00:00:00
lophiiformes	4455	unknown	Synonym	6092	2009-01-01 00:00:00
Ogcocephalioidei	4456	unknown	Primary	6093	2009-01-01 00:00:00
ogcocephalioidei	4456	unknown	Synonym	6094	2009-01-01 00:00:00
Chaunacidae	4457	unknown	Primary	6095	2009-01-01 00:00:00
sea-toad	4457	unknown	Common	6096	2009-01-01 00:00:00
chaunacidae	4457	unknown	Synonym	6097	2009-01-01 00:00:00
Bathychaunax	4458	unknown	Primary	6098	2009-01-01 00:00:00
bathychaunax	4458	unknown	Synonym	6099	2009-01-01 00:00:00
Bathychaunax coloratus	4459	unknown	Primary	6100	2009-01-01 00:00:00
bathychaunax-coloratus	4459	unknown	Synonym	6101	2009-01-01 00:00:00
Ceratioidei	4460	unknown	Primary	6102	2009-01-01 00:00:00
deepsea-anglerfish	4460	unknown	Common	6103	2009-01-01 00:00:00
ceratioidei	4460	unknown	Synonym	6104	2009-01-01 00:00:00
Gigantactinidae	4461	unknown	Primary	6105	2009-01-01 00:00:00
whipnose	4461	unknown	Common	6106	2009-01-01 00:00:00
gigantactinidae	4461	unknown	Synonym	6107	2009-01-01 00:00:00
Gigantactus	4462	unknown	Primary	6108	2009-01-01 00:00:00
gigantactus	4462	unknown	Synonym	6109	2009-01-01 00:00:00
Gigantactus vanhoeffeni	4463	Brauer, 1902	Primary	6110	2009-01-01 00:00:00
gigantactus-vanhoeffeni	4463	Brauer, 1902	Synonym	6111	2009-01-01 00:00:00
Himantolophidae	4464	unknown	Primary	6112	2009-01-01 00:00:00
football-fish	4464	unknown	Common	6113	2009-01-01 00:00:00
himantolophidae	4464	unknown	Synonym	6114	2009-01-01 00:00:00
Himantolophu	4465	unknown	Primary	6115	2009-01-01 00:00:00
himantolophus	4465	unknown	Synonym	6116	2009-01-01 00:00:00
Himantolophus sagamius	4466	Tanaka, 1918	Primary	6117	2009-01-01 00:00:00
himantolophus-sagamius	4466	Tanaka, 1918	Synonym	6118	2009-01-01 00:00:00
Oneirodidae	4467	unknown	Primary	6119	2009-01-01 00:00:00
dreamer	4467	shiino, 1978	Common	6120	2009-01-01 00:00:00
oneirodidae	4467	unknown	Synonym	6121	2009-01-01 00:00:00
Dolopichthys	4468	unknown	Primary	6122	2009-01-01 00:00:00
dolopichthys	4468	unknown	Synonym	6123	2009-01-01 00:00:00
Dolopichthys longicornis	4469	Parr, 1927	Primary	6124	2009-01-01 00:00:00
longhorn-dreamer	4469	unknown	Common	6125	2009-01-01 00:00:00
dolopichthys-longicornis	4469	Parr, 1927	Synonym	6126	2009-01-01 00:00:00
Chaenophryne	4470	unknown	Primary	6127	2009-01-01 00:00:00
chaenophryne	4470	unknown	Synonym	6128	2009-01-01 00:00:00
Chaenophryne longiceps	4471	Regan, 1925	Primary	6129	2009-01-01 00:00:00
chaenophryne-longiceps	4471	Regan, 1925	Synonym	6130	2009-01-01 00:00:00
Chaenophryne melanorhabdus	4472	Regan & Trewavas, 1932	Primary	6131	2009-01-01 00:00:00
chaenophryne-melanorhabdus	4472	Regan & Trewavas, 1932	Synonym	6132	2009-01-01 00:00:00
Oneirodes	4473	unknown	Primary	6133	2009-01-01 00:00:00
oneirodes	4473	unknown	Synonym	6134	2009-01-01 00:00:00
Oneirodes acanthias	4474	gilbert, 1915	Primary	6135	2009-01-01 00:00:00
southern-spiny-dreamer	4474	unknown	Common	6136	2009-01-01 00:00:00
spiny-dreamer	4474	unknown	Common	6137	2009-01-01 00:00:00
pacific-dreamer	4474	shiino, 1978	Common	6138	2009-01-01 00:00:00
oneirodes-acanthias	4474	gilbert, 1915	Synonym	6139	2009-01-01 00:00:00
Ceratiidae	4475	unknown	Primary	6140	2009-01-01 00:00:00
seadevil	4475	unknown	Common	6141	2009-01-01 00:00:00
ceratiidae	4475	unknown	Synonym	6142	2009-01-01 00:00:00
Ceratias	4476	unknown	Primary	6143	2009-01-01 00:00:00
ceratias	4476	unknown	Synonym	6144	2009-01-01 00:00:00
Ceratias holboelli	4477	Kr¯yer, 1845	Primary	6145	2009-01-01 00:00:00
northern-seadevil	4477	unknown	Common	6146	2009-01-01 00:00:00
kroyer`s-deepsea-anglerfish	4477	unknown	Common	6147	2009-01-01 00:00:00
northern-giant-seadevil	4477	unknown	Common	6148	2009-01-01 00:00:00
ceratias-holboelli	4477	Kr¯yer, 1845	Synonym	6149	2009-01-01 00:00:00
Cryptopsaras	4478	unknown	Primary	6150	2009-01-01 00:00:00
cryptopsaras	4478	unknown	Synonym	6151	2009-01-01 00:00:00
Cryptopsaras couesii	4479	Gill, 1883	Primary	6152	2009-01-01 00:00:00
triplewart-seadevil	4479	unknown	Common	6153	2009-01-01 00:00:00
cryptopsaras-couesii	4479	Gill, 1883	Synonym	6154	2009-01-01 00:00:00
Lophiidae	4480	unknown	Primary	6155	2009-01-01 00:00:00
goosefish	4480	unknown	Common	6156	2009-01-01 00:00:00
lophiidae	4480	unknown	Synonym	6157	2009-01-01 00:00:00
Lophiodes	4481	unknown	Primary	6158	2009-01-01 00:00:00
lophiodes	4481	unknown	Synonym	6159	2009-01-01 00:00:00
Lophiodes spilurus	4482	(Garman, 1899)	Primary	6160	2009-01-01 00:00:00
threadfin-goosefish	4482	unknown	Common	6161	2009-01-01 00:00:00
threadfin-angler	4482	unknown	Common	6162	2009-01-01 00:00:00
lophiodes-spilurus	4482	(Garman, 1899)	Synonym	6163	2009-01-01 00:00:00
Lophiodes miacanthus	4483	Gilbert, 1905	Primary	6164	2009-01-01 00:00:00
Ophidiiformes	4484	unknown	Primary	6165	2009-01-01 00:00:00
Bythitidae	4485	unknown	Primary	6166	2009-01-01 00:00:00
viviparous-brotula	4485	unknown	Common	6167	2009-01-01 00:00:00
brotulidae	4485	unknown	Synonym	6168	2009-01-01 00:00:00
brotulid	4485	unknown	Common	6169	2009-01-01 00:00:00
brotula	4485	unknown	Common	6170	2009-01-01 00:00:00
Barathronus	4486	unknown	Primary	6171	2009-01-01 00:00:00
barathronus	4486	unknown	Synonym	6172	2009-01-01 00:00:00
Barathronus pacificus	4487	Nielson and Eagle, 1974	Primary	6173	2009-01-01 00:00:00
barathronus-pacificus	4487	Nielson and Eagle, 1974	Synonym	6174	2009-01-01 00:00:00
Oligopus	4488	unknown	Primary	6175	2009-01-01 00:00:00
oligopus	4488	unknown	Synonym	6176	2009-01-01 00:00:00
Oligopus diagrammus	4489	(heller and snodgrass)	Primary	6177	2009-01-01 00:00:00
purple-brotula	4489	amer. fisheries society, 1980	Common	6178	2009-01-01 00:00:00
oligopus-diagrammus	4489	(heller and snodgrass)	Synonym	6179	2009-01-01 00:00:00
Sciadonus	4490	unknown	Primary	6180	2009-01-01 00:00:00
sciadonus	4490	unknown	Synonym	6181	2009-01-01 00:00:00
Brosmophycis	4491	unknown	Primary	6182	2009-01-01 00:00:00
brosmophycis	4491	unknown	Synonym	6183	2009-01-01 00:00:00
Brosmophycis marginata	4492	ayres, 1854	Primary	6184	2009-01-01 00:00:00
red-brotula	4492	amer. fisheries society, 1980	Common	6185	2009-01-01 00:00:00
brosmophycis-marginata	4492	ayres, 1854	Synonym	6186	2009-01-01 00:00:00
Thalassobathia	4493	Cohen , 1963	Primary	6187	2009-01-01 00:00:00
thalassobathia	4493	Cohen , 1963	Synonym	6188	2009-01-01 00:00:00
Thalassobathia pelagica	4494	Cohen, 1963	Primary	6189	2009-01-01 00:00:00
thalassobathia-pelagica	4494	Cohen, 1963	Synonym	6190	2009-01-01 00:00:00
Cataetyx	4495	unknown	Primary	6191	2009-01-01 00:00:00
cataetyx	4495	unknown	Synonym	6192	2009-01-01 00:00:00
Cataetyx rubrirostris	4496	Gilbert, 1890	Primary	6193	2009-01-01 00:00:00
rubynose-brotula	4496	unknown	Common	6194	2009-01-01 00:00:00
cataetyx-rubrirostris	4496	Gilbert, 1890	Synonym	6195	2009-01-01 00:00:00
Aphyonidae	4497	unknown	Primary	6196	2009-01-01 00:00:00
Ophidiidae	4498	unknown	Primary	6197	2009-01-01 00:00:00
cuskeel	4498	unknown	Common	6198	2009-01-01 00:00:00
Chilara	4499	unknown	Primary	6199	2009-01-01 00:00:00
chilara	4499	unknown	Synonym	6200	2009-01-01 00:00:00
Chilara taylori	4500	unknown	Primary	6201	2009-01-01 00:00:00
spotted-cuskeel	4500	unknown	Common	6202	2009-01-01 00:00:00
chilara-taylori	4500	unknown	Synonym	6203	2009-01-01 00:00:00
Lamprogrammus	4501	unknown	Primary	6204	2009-01-01 00:00:00
lamprogrammus	4501	unknown	Synonym	6205	2009-01-01 00:00:00
Lamprogrammus niger	4502	Alcock, 1891	Primary	6206	2009-01-01 00:00:00
paperbone-cuskeel	4502	unknown	Common	6207	2009-01-01 00:00:00
lamprogrammus-niger	4502	Alcock, 1891	Synonym	6208	2009-01-01 00:00:00
Neobythitinae	4503	unknown	Primary	6209	2009-01-01 00:00:00
neobythitinae	4503	unknown	Synonym	6210	2009-01-01 00:00:00
Porogadus	4504	Goode and Bean, 1885	Primary	6211	2009-01-01 00:00:00
porogadus	4504	Goode and Bean, 1885	Synonym	6212	2009-01-01 00:00:00
Luciobrotula	4505	Smith and Radcliffe in Radcliffe, 1913	Primary	6213	2009-01-01 00:00:00
luciobrotula	4505	Smith and Radcliffe in Radcliffe, 1913	Synonym	6214	2009-01-01 00:00:00
Barathrites	4506	Zugmayer, 1911	Primary	6215	2009-01-01 00:00:00
barathrites	4506	Zugmayer, 1911	Synonym	6216	2009-01-01 00:00:00
Barathrites parri	4507	Nybelin, 1957	Primary	6217	2009-01-01 00:00:00
barathrites-parri	4507	Nybelin, 1957	Synonym	6218	2009-01-01 00:00:00
Ophidion	4508	Linnaeus, 1758	Primary	6219	2009-01-01 00:00:00
ophidion	4508	Linnaeus, 1758	Synonym	6220	2009-01-01 00:00:00
Ophidion scrippsae	4509	(Hubbs, 1916)	Primary	6221	2009-01-01 00:00:00
basketweave	4509	unknown	Common	6222	2009-01-01 00:00:00
ophidion-scrippsae	4509	(Hubbs, 1916)	Synonym	6223	2009-01-01 00:00:00
Dicrolene	4510	unknown	Primary	6224	2009-01-01 00:00:00
dicrolene	4510	unknown	Synonym	6225	2009-01-01 00:00:00
Dicrolene filamentosa	4511	Garman, 1899	Primary	6226	2009-01-01 00:00:00
threadfin-cuskeel	4511	unknown	Common	6227	2009-01-01 00:00:00
dicrolene-filamentosa	4511	Garman, 1899	Synonym	6228	2009-01-01 00:00:00
Spectrunculus	4512	unknown	Primary	6229	2009-01-01 00:00:00
spectrunculus	4512	unknown	Synonym	6230	2009-01-01 00:00:00
Spectrunculus grandis	4513	(G¸nther, 1877)	Primary	6231	2009-01-01 00:00:00
giant-cuskeel	4513	unknown	Common	6232	2009-01-01 00:00:00
pudgy-cuskeel	4513	unknown	Common	6233	2009-01-01 00:00:00
spectrunculus-grandis	4513	(G¸nther, 1877)	Synonym	6234	2009-01-01 00:00:00
Bassozetus	4514	unknown	Primary	6235	2009-01-01 00:00:00
Bassozetus nasus	4515	unknown	Primary	6236	2009-01-01 00:00:00
Stenopterygii	4516	unknown	Primary	6237	2009-01-01 00:00:00
Stomiiformes	4517	unknown	Primary	6238	2009-01-01 00:00:00
stomiiformes	4517	unknown	Synonym	6239	2009-01-01 00:00:00
Gonostomatidae	4518	unknown	Primary	6240	2009-01-01 00:00:00
bristlemouth	4518	shiino, 1978	Common	6241	2009-01-01 00:00:00
gonostomatidae	4518	unknown	Synonym	6242	2009-01-01 00:00:00
Cyclothone	4519	unknown	Primary	6243	2009-01-01 00:00:00
cyclothone	4519	unknown	Synonym	6244	2009-01-01 00:00:00
Cyclothone acclinidens	4520	unknown	Primary	6245	2009-01-01 00:00:00
benttooth-bristlemouth	4520	unknown	Common	6246	2009-01-01 00:00:00
cyclothone-acclinidens	4520	unknown	Synonym	6247	2009-01-01 00:00:00
Cyclothone signata	4521	Garman, 1899	Primary	6248	2009-01-01 00:00:00
showy-bristlemouth	4521	shiino, 1978	Common	6249	2009-01-01 00:00:00
cyclothone-signata	4521	Garman, 1899	Synonym	6250	2009-01-01 00:00:00
Cyclothone pallida	4522	brauer	Primary	6251	2009-01-01 00:00:00
tan-bristlemouth	4522	unknown	Common	6252	2009-01-01 00:00:00
bicolored-bristlemouth	4522	shiino, 1978	Common	6253	2009-01-01 00:00:00
cyclothone-pallida	4522	brauer	Synonym	6254	2009-01-01 00:00:00
Stomiidae	4523	unknown	Primary	6255	2009-01-01 00:00:00
dragonfish	4523	unknown	Common	6256	2009-01-01 00:00:00
stomiidae	4523	unknown	Synonym	6257	2009-01-01 00:00:00
Stomiinae	4524	unknown	Primary	6258	2009-01-01 00:00:00
scaly-dragonfish	4524	unknown	Common	6259	2009-01-01 00:00:00
stomiinae	4524	unknown	Synonym	6260	2009-01-01 00:00:00
Stomias	4525	unknown	Primary	6261	2009-01-01 00:00:00
stomias	4525	unknown	Synonym	6262	2009-01-01 00:00:00
Stomias atriventer	4526	Garman, 1899	Primary	6263	2009-01-01 00:00:00
blackbelly-dragonfish	4526	unknown	Common	6264	2009-01-01 00:00:00
Idiacanthinae	4527	unknown	Primary	6265	2009-01-01 00:00:00
black-dragonfish	4527	unknown	Common	6266	2009-01-01 00:00:00
idiacanthinae	4527	unknown	Synonym	6267	2009-01-01 00:00:00
Idiacanthus	4528	unknown	Primary	6268	2009-01-01 00:00:00
idiacanthus	4528	unknown	Synonym	6269	2009-01-01 00:00:00
Idiacanthus antrostomus	4529	gilbert,1890	Primary	6270	2009-01-01 00:00:00
pacific-blackdragon	4529	unknown	Common	6271	2009-01-01 00:00:00
idiacanthus-antrostomus	4529	gilbert,1890	Synonym	6272	2009-01-01 00:00:00
Idiacanthus fasciola	4530	Peters, 1877	Primary	6273	2009-01-01 00:00:00
deepsea-stalkeye-fish	4530	unknown	Common	6274	2009-01-01 00:00:00
ribbon-sawtail-fish	4530	unknown	Common	6275	2009-01-01 00:00:00
idiacanthus-fasciola	4530	Peters, 1877	Synonym	6276	2009-01-01 00:00:00
Astronesthinae	4531	unknown	Primary	6277	2009-01-01 00:00:00
snaggletooth	4531	unknown	Common	6278	2009-01-01 00:00:00
astronesthinae	4531	unknown	Synonym	6279	2009-01-01 00:00:00
Astronesthes	4532	unknown	Primary	6280	2009-01-01 00:00:00
astronesthes	4532	unknown	Synonym	6281	2009-01-01 00:00:00
Astronesthes nigroides	4533	Gibbs and Aron, 1960	Primary	6282	2009-01-01 00:00:00
astronesthes-nigroides	4533	Gibbs and Aron, 1960	Synonym	6283	2009-01-01 00:00:00
Borostomius	4534	unknown	Primary	6284	2009-01-01 00:00:00
borostomius	4534	unknown	Synonym	6285	2009-01-01 00:00:00
Borostomius panamensis	4535	Regan and Trewavas, 1929	Primary	6286	2009-01-01 00:00:00
panama-snaggletooth	4535	unknown	Common	6287	2009-01-01 00:00:00
borostomius-panamensis	4535	Regan and Trewavas, 1929	Synonym	6288	2009-01-01 00:00:00
Melanostomiinae	4536	unknown	Primary	6289	2009-01-01 00:00:00
scaleless-black-dragonfish	4536	unknown	Common	6290	2009-01-01 00:00:00
melanostomiidae	4536	unknown	Synonym	6291	2009-01-01 00:00:00
melanostomiinae	4536	unknown	Synonym	6292	2009-01-01 00:00:00
Bathophilus	4537	unknown	Primary	6293	2009-01-01 00:00:00
bathophilus	4537	unknown	Synonym	6294	2009-01-01 00:00:00
Bathophilus flemingi	4538	aron and mccrery	Primary	6295	2009-01-01 00:00:00
highfin-dragonfish	4538	shiino, 1978	Common	6296	2009-01-01 00:00:00
bathophilus-flemingi	4538	aron and mccrery	Synonym	6297	2009-01-01 00:00:00
Bathophilus brevis	4539	Regan and Trewavas, 1930	Primary	6298	2009-01-01 00:00:00
bathophilus-brevis	4539	Regan and Trewavas, 1930	Synonym	6299	2009-01-01 00:00:00
Tactostoma	4540	unknown	Primary	6300	2009-01-01 00:00:00
tactostoma	4540	unknown	Synonym	6301	2009-01-01 00:00:00
Tactostoma macropus	4541	bolin	Primary	6302	2009-01-01 00:00:00
longfin-dragonfish	4541	amer. fisheries society, 1980	Common	6303	2009-01-01 00:00:00
tactostoma-macropus	4541	bolin	Synonym	6304	2009-01-01 00:00:00
Photonectes	4542	unknown	Primary	6305	2009-01-01 00:00:00
photonectes	4542	unknown	Synonym	6306	2009-01-01 00:00:00
Photonectes margarita	4543	(Goode and Bean, 1896)	Primary	6307	2009-01-01 00:00:00
sooty-dragonfish	4543	unknown	Common	6308	2009-01-01 00:00:00
photonectes-margarita	4543	(Goode and Bean, 1896)	Synonym	6309	2009-01-01 00:00:00
Opostomias	4544	unknown	Primary	6310	2009-01-01 00:00:00
opostomias	4544	unknown	Synonym	6311	2009-01-01 00:00:00
Opostomias mitsui	4545	Imai, 1941	Primary	6312	2009-01-01 00:00:00
pitgum-dragonfish	4545	unknown	Common	6313	2009-01-01 00:00:00
opostomias-mitsui	4545	Imai, 1941	Synonym	6314	2009-01-01 00:00:00
Chauliodontinae	4546	Shiino, 1978	Primary	6315	2009-01-01 00:00:00
viperfish	4546	unknown	Common	6316	2009-01-01 00:00:00
chauliodontinae	4546	Shiino, 1978	Synonym	6317	2009-01-01 00:00:00
Chauliodus	4547	unknown	Primary	6318	2009-01-01 00:00:00
chauliodus	4547	unknown	Synonym	6319	2009-01-01 00:00:00
Chauliodus macouni	4548	bean	Primary	6320	2009-01-01 00:00:00
pacific-viperfish	4548	amer. fisheries society, 1980	Common	6321	2009-01-01 00:00:00
chauliodus-macouni	4548	bean	Synonym	6322	2009-01-01 00:00:00
Malacosteinae	4549	unknown	Primary	6323	2009-01-01 00:00:00
loosejaw-fish	4549	unknown	Common	6324	2009-01-01 00:00:00
malacosteinae	4549	unknown	Synonym	6325	2009-01-01 00:00:00
Aristostomias	4550	unknown	Primary	6326	2009-01-01 00:00:00
aristostomias	4550	unknown	Synonym	6327	2009-01-01 00:00:00
Aristostomias scintillans	4551	(Gilbert, 1915)	Primary	6328	2009-01-01 00:00:00
shiny-loosejaw	4551	unknown	Common	6329	2009-01-01 00:00:00
aristostomias-scintillans	4551	(Gilbert, 1915)	Synonym	6330	2009-01-01 00:00:00
Sternoptychidae	4552	unknown	Primary	6331	2009-01-01 00:00:00
hatchetfish	4552	unknown	Common	6332	2009-01-01 00:00:00
deepsea-hatchetfish	4552	shiino, 1978	Common	6333	2009-01-01 00:00:00
sternoptychidae	4552	unknown	Synonym	6334	2009-01-01 00:00:00
Sternoptyx	4553	unknown	Primary	6335	2009-01-01 00:00:00
dollar-hatchet-fish	4553	unknown	Common	6336	2009-01-01 00:00:00
sternoptyx	4553	unknown	Synonym	6337	2009-01-01 00:00:00
Sternoptyx diaphana	4554	Hermann, 1781	Primary	6338	2009-01-01 00:00:00
diaphanous-hatchetfish	4554	unknown	Common	6339	2009-01-01 00:00:00
transparent-hatchetfish	4554	unknown	Common	6340	2009-01-01 00:00:00
longspine-hatchetfish	4554	unknown	Common	6341	2009-01-01 00:00:00
sternoptyx-diaphana	4554	Hermann, 1781	Synonym	6342	2009-01-01 00:00:00
Sternoptyx obscura	4555	Garman, 1899	Primary	6343	2009-01-01 00:00:00
dusky-hatchetfish	4555	unknown	Common	6344	2009-01-01 00:00:00
sternoptyx-obscura	4555	Garman, 1899	Synonym	6345	2009-01-01 00:00:00
Danaphos	4556	unknown	Primary	6346	2009-01-01 00:00:00
danaphos	4556	unknown	Synonym	6347	2009-01-01 00:00:00
Danaphos oculatus	4557	(Garman, 1899)	Primary	6348	2009-01-01 00:00:00
bigeye-lightfish	4557	unknown	Common	6349	2009-01-01 00:00:00
bottlelight	4557	unknown	Common	6350	2009-01-01 00:00:00
danaphos-oculatus	4557	(Garman, 1899)	Synonym	6351	2009-01-01 00:00:00
Argyropelecus	4558	unknown	Primary	6352	2009-01-01 00:00:00
silvery-hatchet-fish	4558	unknown	Common	6353	2009-01-01 00:00:00
argyropelecus	4558	unknown	Synonym	6354	2009-01-01 00:00:00
Argyropelecus lychnus	4559	Garman, 1899	Primary	6355	2009-01-01 00:00:00
tropical-hatchetfish	4559	unknown	Common	6356	2009-01-01 00:00:00
silver-hatchetfish	4559	unknown	Common	6357	2009-01-01 00:00:00
argyropelecus-lychnus	4559	Garman, 1899	Synonym	6358	2009-01-01 00:00:00
Argyropelecus hemigymnus	4560	Cocco, 1829	Primary	6359	2009-01-01 00:00:00
half-naked-hatchetfish	4560	unknown	Common	6360	2009-01-01 00:00:00
spurred-hatchetfish	4560	unknown	Common	6361	2009-01-01 00:00:00
argyropelecus-hemigymnus	4560	Cocco, 1829	Synonym	6362	2009-01-01 00:00:00
Argyropelecus affinis	4561	Garman, 1899	Primary	6363	2009-01-01 00:00:00
argyropelecus-pacificus	4561	unknown	Synonym	6364	2009-01-01 00:00:00
slender-hatchetfish	4561	unknown	Common	6365	2009-01-01 00:00:00
pacific-hatchetfish	4561	unknown	Common	6366	2009-01-01 00:00:00
argyropelecus-affinis	4561	Garman, 1899	Synonym	6367	2009-01-01 00:00:00
Argyropelecus sladeni	4562	Regan, 1908	Primary	6368	2009-01-01 00:00:00
lowcrest-hatchetfish	4562	unknown	Common	6369	2009-01-01 00:00:00
hawaiian-hatchetfish	4562	unknown	Common	6370	2009-01-01 00:00:00
silvery-hatchetfish	4562	unknown	Common	6371	2009-01-01 00:00:00
sladen`s-hatchetfish	4562	unknown	Common	6372	2009-01-01 00:00:00
argyropelecus-sladeni	4562	Regan, 1908	Synonym	6373	2009-01-01 00:00:00
Phosichthyidae	4563	unknown	Primary	6374	2009-01-01 00:00:00
lightfish	4563	unknown	Common	6375	2009-01-01 00:00:00
phosichthyidae	4563	unknown	Synonym	6376	2009-01-01 00:00:00
Ichthyococcus	4564	unknown	Primary	6377	2009-01-01 00:00:00
ichthyococcus	4564	unknown	Synonym	6378	2009-01-01 00:00:00
Ichthyococcus elongatus	4565	Imai, 1941	Primary	6379	2009-01-01 00:00:00
slim-lightfish	4565	unknown	Common	6380	2009-01-01 00:00:00
ichthyococcus-elongatus	4565	Imai, 1941	Synonym	6381	2009-01-01 00:00:00
Vinciguerria	4566	unknown	Primary	6382	2009-01-01 00:00:00
vinciguerria	4566	unknown	Synonym	6383	2009-01-01 00:00:00
Vinciguerria lucetia	4567	Garman	Primary	6384	2009-01-01 00:00:00
vinciguerria-lucetia	4567	Garman	Synonym	6385	2009-01-01 00:00:00
Vinciguerria nimbaria	4568	(Jordan and Williams, 1895)	Primary	6386	2009-01-01 00:00:00
oceanic-lightfish	4568	unknown	Common	6387	2009-01-01 00:00:00
vinciguerria-nimbaria	4568	(Jordan and Williams, 1895)	Synonym	6388	2009-01-01 00:00:00
Ostariophysi	4569	unknown	Primary	6389	2009-01-01 00:00:00
Siluriformes	4570	unknown	Primary	6390	2009-01-01 00:00:00
siluriformes	4570	unknown	Synonym	6391	2009-01-01 00:00:00
Ariidae	4571	unknown	Primary	6392	2009-01-01 00:00:00
sea-catfish	4571	unknown	Common	6393	2009-01-01 00:00:00
ariidae	4571	unknown	Synonym	6394	2009-01-01 00:00:00
Scopelomorpha	4572	unknown	Primary	6395	2009-01-01 00:00:00
Myctophiformes	4573	unknown	Primary	6396	2009-01-01 00:00:00
myctophiformes	4573	unknown	Synonym	6397	2009-01-01 00:00:00
Neoscopelidae	4574	unknown	Primary	6398	2009-01-01 00:00:00
blackchin	4574	unknown	Common	6399	2009-01-01 00:00:00
neoscopelidae	4574	unknown	Synonym	6400	2009-01-01 00:00:00
Neoscopelus	4575	unknown	Primary	6401	2009-01-01 00:00:00
neoscopelus	4575	unknown	Synonym	6402	2009-01-01 00:00:00
Neoscopelus macrolepidotus	4576	Johnson, 1863	Primary	6403	2009-01-01 00:00:00
glowingfish	4576	unknown	Common	6404	2009-01-01 00:00:00
large-scaled-lanternfish	4576	unknown	Common	6405	2009-01-01 00:00:00
neoscopelus-macrolepidotus	4576	Johnson, 1863	Synonym	6406	2009-01-01 00:00:00
Scopelengys	4577	unknown	Primary	6407	2009-01-01 00:00:00
scopelengys	4577	unknown	Synonym	6408	2009-01-01 00:00:00
Scopelengys tristis	4578	Alcock, 1890	Primary	6409	2009-01-01 00:00:00
pacific-blackchin	4578	unknown	Common	6410	2009-01-01 00:00:00
scopelengys-tristis	4578	Alcock, 1890	Synonym	6411	2009-01-01 00:00:00
Myctophidae	4579	unknown	Primary	6412	2009-01-01 00:00:00
lanternfish	4579	unknown	Common	6413	2009-01-01 00:00:00
myctophidae	4579	unknown	Synonym	6414	2009-01-01 00:00:00
Diaphus	4580	eigenmann and eigenmann, 1890	Primary	6415	2009-01-01 00:00:00
diaphus	4580	eigenmann and eigenmann, 1890	Synonym	6416	2009-01-01 00:00:00
Diaphus trachops	4581	Wisner, 1974	Primary	6417	2009-01-01 00:00:00
rougheye-headlightfish	4581	unknown	Common	6418	2009-01-01 00:00:00
diaphus-trachops	4581	Wisner, 1974	Synonym	6419	2009-01-01 00:00:00
Diaphus theta	4582	eigenmann & eigenmann, 1890	Primary	6420	2009-01-01 00:00:00
california-headlightfish	4582	amer. fisheries society, 1980	Common	6421	2009-01-01 00:00:00
diaphus-theta	4582	eigenmann & eigenmann, 1890	Synonym	6422	2009-01-01 00:00:00
Diaphus anderseni	4583	TÂning, 1932	Primary	6423	2009-01-01 00:00:00
andersen`s-lantern-fish	4583	unknown	Common	6424	2009-01-01 00:00:00
lowlight-headlightfish	4583	unknown	Common	6425	2009-01-01 00:00:00
diaphus-anderseni	4583	TÂning, 1932	Synonym	6426	2009-01-01 00:00:00
Diaphus pacificus	4584	Parr, 1931	Primary	6427	2009-01-01 00:00:00
diaphus-pacificus	4584	Parr, 1931	Synonym	6428	2009-01-01 00:00:00
Diogenichthys	4585	unknown	Primary	6429	2009-01-01 00:00:00
diogenichthys	4585	unknown	Synonym	6430	2009-01-01 00:00:00
Diogenichthys laternatus	4586	(Garman, 1899)	Primary	6431	2009-01-01 00:00:00
diogenes-lanternfish	4586	unknown	Common	6432	2009-01-01 00:00:00
diogenichthys-laternatus	4586	(Garman, 1899)	Synonym	6433	2009-01-01 00:00:00
Diogenichthys atlanticus	4587	(TÂning, 1928)	Primary	6434	2009-01-01 00:00:00
longfin-lanternfish	4587	unknown	Common	6435	2009-01-01 00:00:00
diogenichthys-atlanticus	4587	(TÂning, 1928)	Synonym	6436	2009-01-01 00:00:00
Stenobrachius	4588	eigenmann & eigenmann,1890	Primary	6437	2009-01-01 00:00:00
stenobrachius	4588	eigenmann & eigenmann,1890	Synonym	6438	2009-01-01 00:00:00
Stenobrachius leucopsarus	4589	eigenm. & eigenm.	Primary	6439	2009-01-01 00:00:00
northern-lampfish	4589	amer. fisheries society, 1980	Common	6440	2009-01-01 00:00:00
stenobrachius-leucopsarus	4589	eigenm. & eigenm.	Synonym	6441	2009-01-01 00:00:00
Ceratoscopelus	4590	unknown	Primary	6442	2009-01-01 00:00:00
ceratoscopelus	4590	unknown	Synonym	6443	2009-01-01 00:00:00
Ceratoscopelus townsendi	4591	(Eigenmann & Eigenmann, 1889)	Primary	6444	2009-01-01 00:00:00
dogtooth-lampfish	4591	unknown	Common	6445	2009-01-01 00:00:00
ceratoscopelus-townsendi	4591	(Eigenmann & Eigenmann, 1889)	Synonym	6446	2009-01-01 00:00:00
Symbolophorus californiensis	4592	(Eigenmann & Eigenmann, 1889)	Primary	6447	2009-01-01 00:00:00
california-lanternfish	4592	unknown	Common	6448	2009-01-01 00:00:00
bigfin-lanternfish	4592	unknown	Common	6449	2009-01-01 00:00:00
symbolophorus-californiensis	4592	(Eigenmann & Eigenmann, 1889)	Synonym	6450	2009-01-01 00:00:00
Notoscopelus	4593	unknown	Primary	6451	2009-01-01 00:00:00
notoscopelus	4593	unknown	Synonym	6452	2009-01-01 00:00:00
Notoscopelus resplendens	4594	(Richardson, 1845)	Primary	6453	2009-01-01 00:00:00
patchwork-lampfish	4594	unknown	Common	6454	2009-01-01 00:00:00
notoscopelus-resplendens	4594	(Richardson, 1845)	Synonym	6455	2009-01-01 00:00:00
Hygophum	4595	unknown	Primary	6456	2009-01-01 00:00:00
hygophum	4595	unknown	Synonym	6457	2009-01-01 00:00:00
Hygophum reinhardtii	4596	(L¸tken, 1892)	Primary	6458	2009-01-01 00:00:00
slender-lanternfish	4596	unknown	Common	6459	2009-01-01 00:00:00
hygophum-reinhardtii	4596	(L¸tken, 1892)	Synonym	6460	2009-01-01 00:00:00
Benthosema	4597	Goode and Bean, 1896	Primary	6461	2009-01-01 00:00:00
benthosema	4597	Goode and Bean, 1896	Synonym	6462	2009-01-01 00:00:00
Benthosema panamense	4598	Taning, 1932	Primary	6463	2009-01-01 00:00:00
benthosema-panamense	4598	Taning, 1932	Synonym	6464	2009-01-01 00:00:00
Electrona	4599	unknown	Primary	6465	2009-01-01 00:00:00
electrona	4599	unknown	Synonym	6466	2009-01-01 00:00:00
Electrona risso	4600	(Cocco, 1829)	Primary	6467	2009-01-01 00:00:00
chubby-flashlightfish	4600	unknown	Common	6468	2009-01-01 00:00:00
electrona-risso	4600	(Cocco, 1829)	Synonym	6469	2009-01-01 00:00:00
Protomyctophum	4601	unknown	Primary	6470	2009-01-01 00:00:00
protomyctophum	4601	unknown	Synonym	6471	2009-01-01 00:00:00
Protomyctophum crockeri	4602	(bolin, 1939)	Primary	6472	2009-01-01 00:00:00
hierops-crockeri	4602	bolin, 1939	Synonym	6473	2009-01-01 00:00:00
california-flashlightfish	4602	unknown	Common	6474	2009-01-01 00:00:00
protomyctophum-crockeri	4602	(bolin, 1939)	Synonym	6475	2009-01-01 00:00:00
Protomyctophum thompsoni	4603	(Chapman, 1944)	Primary	6476	2009-01-01 00:00:00
bigeye-lanternfish	4603	unknown	Common	6477	2009-01-01 00:00:00
protomyctophum-thompsoni	4603	(Chapman, 1944)	Synonym	6478	2009-01-01 00:00:00
Taaningichthys	4604	unknown	Primary	6479	2009-01-01 00:00:00
taaningichthys	4604	unknown	Synonym	6480	2009-01-01 00:00:00
Lampanyctus	4605	bonaparte	Primary	6481	2009-01-01 00:00:00
lampanyctus	4605	bonaparte	Synonym	6482	2009-01-01 00:00:00
Lampanyctus jordani	4606	Gilbert, 1913	Primary	6483	2009-01-01 00:00:00
brokenline-lampfish	4606	unknown	Common	6484	2009-01-01 00:00:00
lampanyctus-jordani	4606	Gilbert, 1913	Synonym	6485	2009-01-01 00:00:00
Lampanyctus simulator	4607	Wisner, 1971	Primary	6486	2009-01-01 00:00:00
lampanyctus-simulator	4607	Wisner, 1971	Synonym	6487	2009-01-01 00:00:00
Lampanyctus ritteri	4608	unknown	Primary	6488	2009-01-01 00:00:00
broadfin-lampfish	4608	unknown	Common	6489	2009-01-01 00:00:00
lampanyctus-ritteri	4608	unknown	Synonym	6490	2009-01-01 00:00:00
Lampanyctus niger	4609	(G¸nther, 1887)	Primary	6491	2009-01-01 00:00:00
sooty-lampfish	4609	unknown	Common	6492	2009-01-01 00:00:00
lampanyctus-niger	4609	(G¸nther, 1887)	Synonym	6493	2009-01-01 00:00:00
Lampanyctus regalis	4610	(gilbert, 1892)	Primary	6494	2009-01-01 00:00:00
pinpoint-lampfish	4610	amer. fisheries society, 1980	Common	6495	2009-01-01 00:00:00
lampanyctus-regalis	4610	(gilbert, 1892)	Synonym	6496	2009-01-01 00:00:00
Lampadena	4611	unknown	Primary	6497	2009-01-01 00:00:00
lampadena	4611	unknown	Synonym	6498	2009-01-01 00:00:00
Lampadena urophaos urophaos	4612	Paxton, 1963	Primary	6499	2009-01-01 00:00:00
sunbeam-lampfish	4612	unknown	Common	6500	2009-01-01 00:00:00
lampadena-urophaos-urophaos	4612	Paxton, 1963	Synonym	6501	2009-01-01 00:00:00
Loweina	4613	unknown	Primary	6502	2009-01-01 00:00:00
loweina	4613	unknown	Synonym	6503	2009-01-01 00:00:00
Loweina rara	4614	(L¸tken, 1892)	Primary	6504	2009-01-01 00:00:00
laura`s-lanternfish	4614	unknown	Common	6505	2009-01-01 00:00:00
dwarf-lanternfish	4614	unknown	Common	6506	2009-01-01 00:00:00
loweina-rara	4614	(L¸tken, 1892)	Synonym	6507	2009-01-01 00:00:00
Taaningichthys bathyphilus	4615	(TÂning, 1928)	Primary	6508	2009-01-01 00:00:00
black-lampfish	4615	unknown	Common	6509	2009-01-01 00:00:00
taaningichthys-bathyphilus	4615	(TÂning, 1928)	Synonym	6510	2009-01-01 00:00:00
Symbolophorus	4616	unknown	Primary	6511	2009-01-01 00:00:00
symbolophorus	4616	unknown	Synonym	6512	2009-01-01 00:00:00
Triphoturus	4617	unknown	Primary	6513	2009-01-01 00:00:00
triphoturus	4617	unknown	Synonym	6514	2009-01-01 00:00:00
Triphoturus mexicanus	4618	(gilbert)	Primary	6515	2009-01-01 00:00:00
mexican-lampfish	4618	amer. fisheries society, 1980	Common	6516	2009-01-01 00:00:00
triphoturus-mexicanus	4618	(gilbert)	Synonym	6517	2009-01-01 00:00:00
Myctophum	4619	unknown	Primary	6518	2009-01-01 00:00:00
myctophum	4619	unknown	Synonym	6519	2009-01-01 00:00:00
Myctophum nitidulum	4620	Garman, 1899	Primary	6520	2009-01-01 00:00:00
pearly-lanternfish	4620	unknown	Common	6521	2009-01-01 00:00:00
myctophum-nitidulum	4620	Garman, 1899	Synonym	6522	2009-01-01 00:00:00
Tarletonbeania	4621	unknown	Primary	6523	2009-01-01 00:00:00
tarletonbeania	4621	unknown	Synonym	6524	2009-01-01 00:00:00
Tarletonbeania crenularis	4622	jordan gilbert	Primary	6525	2009-01-01 00:00:00
blue-lanternfish	4622	amer. fisheries society, 1980	Common	6526	2009-01-01 00:00:00
tarletonbeania-crenularis	4622	jordan gilbert	Synonym	6527	2009-01-01 00:00:00
Tarletonbeania taylori	4623	Mead, 1953	Primary	6528	2009-01-01 00:00:00
tarletonbeania-taylori	4623	Mead, 1953	Synonym	6529	2009-01-01 00:00:00
Parvilux	4624	unknown	Primary	6530	2009-01-01 00:00:00
parvilux	4624	unknown	Synonym	6531	2009-01-01 00:00:00
Parvilux ingens	4625	Hubbs & Wisner, 1964	Primary	6532	2009-01-01 00:00:00
giant-lampfish	4625	unknown	Common	6533	2009-01-01 00:00:00
parvilux-ingens	4625	Hubbs & Wisner, 1964	Synonym	6534	2009-01-01 00:00:00
Lampridiomorpha	4626	unknown	Primary	6535	2009-01-01 00:00:00
Lampriformes	4627	unknown	Primary	6536	2009-01-01 00:00:00
lampriformes	4627	unknown	Synonym	6537	2009-01-01 00:00:00
Lamproidei	4628	unknown	Primary	6538	2009-01-01 00:00:00
lamproidei	4628	unknown	Synonym	6539	2009-01-01 00:00:00
Lampridae	4629	unknown	Primary	6540	2009-01-01 00:00:00
opah	4629	unknown	Common	6541	2009-01-01 00:00:00
lampridae	4629	unknown	Synonym	6542	2009-01-01 00:00:00
Trachipteroidei	4630	unknown	Primary	6543	2009-01-01 00:00:00
trachipteroidei	4630	unknown	Synonym	6544	2009-01-01 00:00:00
Lophotidae	4631	unknown	Primary	6545	2009-01-01 00:00:00
crestfish	4631	unknown	Common	6546	2009-01-01 00:00:00
lophotidae	4631	unknown	Synonym	6547	2009-01-01 00:00:00
Lophotus	4632	unknown	Primary	6548	2009-01-01 00:00:00
lophotus	4632	unknown	Synonym	6549	2009-01-01 00:00:00
Lophotus lacepede	4633	Giorna, 1809	Primary	6550	2009-01-01 00:00:00
crested-oarfish	4633	unknown	Common	6551	2009-01-01 00:00:00
lophotus-lacepede	4633	Giorna, 1809	Synonym	6552	2009-01-01 00:00:00
Lampris	4634	unknown	Primary	6553	2009-01-01 00:00:00
lampris	4634	unknown	Synonym	6554	2009-01-01 00:00:00
Lampris guttatus	4635	(Br¸nnich, 1788)	Primary	6555	2009-01-01 00:00:00
kingfish	4635	unknown	Common	6556	2009-01-01 00:00:00
moonfish	4635	unknown	Common	6557	2009-01-01 00:00:00
jerusalum-haddock	4635	unknown	Common	6558	2009-01-01 00:00:00
lampris-guttatus	4635	(Br¸nnich, 1788)	Synonym	6559	2009-01-01 00:00:00
Trachipteridae	4636	unknown	Primary	6560	2009-01-01 00:00:00
ribbonfish	4636	shiino, 1978	Common	6561	2009-01-01 00:00:00
trachipteridae	4636	unknown	Synonym	6562	2009-01-01 00:00:00
Trachipterus	4637	unknown	Primary	6563	2009-01-01 00:00:00
trachipterus	4637	unknown	Synonym	6564	2009-01-01 00:00:00
Trachipterus altivelis	4638	kner, 1859	Primary	6565	2009-01-01 00:00:00
king-of-the-salmon	4638	amer. fisheries society, 1980	Common	6566	2009-01-01 00:00:00
trachipterus-altivelis	4638	kner, 1859	Synonym	6567	2009-01-01 00:00:00
Desmodema	4639	unknown	Primary	6568	2009-01-01 00:00:00
desmodema	4639	unknown	Synonym	6569	2009-01-01 00:00:00
Desmodema lorum	4640	unknown	Primary	6570	2009-01-01 00:00:00
whiptail-ribbonfish	4640	amer. fisheries society, 1980	Common	6571	2009-01-01 00:00:00
desmodema-lorum	4640	unknown	Synonym	6572	2009-01-01 00:00:00
Regalecidae	4641	unknown	Primary	6573	2009-01-01 00:00:00
regalecidae	4641	unknown	Synonym	6574	2009-01-01 00:00:00
Regalecus	4642	unknown	Primary	6575	2009-01-01 00:00:00
regalecus	4642	unknown	Synonym	6576	2009-01-01 00:00:00
Regalecus glesne	4643	(ascanius)	Primary	6577	2009-01-01 00:00:00
oarfish	4643	amer. fisheries society, 1980	Common	6578	2009-01-01 00:00:00
regalecus-glesne	4643	(ascanius)	Synonym	6579	2009-01-01 00:00:00
Sternopterygii	4644	unknown	Primary	6580	2009-01-01 00:00:00
Cyclosquamata	4645	unknown	Primary	6581	2009-01-01 00:00:00
Aulopiformes	4646	unknown	Primary	6582	2009-01-01 00:00:00
Evermannellidae	4647	unknown	Primary	6583	2009-01-01 00:00:00
sabertooth-fish	4647	unknown	Common	6584	2009-01-01 00:00:00
evermannellidae	4647	unknown	Synonym	6585	2009-01-01 00:00:00
Evermannella	4648	unknown	Primary	6586	2009-01-01 00:00:00
evermannella	4648	unknown	Synonym	6587	2009-01-01 00:00:00
Evermannella ahlstromi	4649	Johnson and Glodek, 1975	Primary	6588	2009-01-01 00:00:00
evermannella-ahlstromi	4649	Johnson and Glodek, 1975	Synonym	6589	2009-01-01 00:00:00
Aulopidae	4650	unknown	Primary	6590	2009-01-01 00:00:00
Aulopus	4651	Cuvier, 1816	Primary	6591	2009-01-01 00:00:00
aulopus	4651	Cuvier, 1816	Synonym	6592	2009-01-01 00:00:00
Synodontidae	4652	unknown	Primary	6593	2009-01-01 00:00:00
lizardfish	4652	unknown	Common	6594	2009-01-01 00:00:00
synodontidae	4652	unknown	Synonym	6595	2009-01-01 00:00:00
Bathysaurus	4653	unknown	Primary	6596	2009-01-01 00:00:00
bathysaurus	4653	unknown	Synonym	6597	2009-01-01 00:00:00
Bathysaurus mollis	4654	G¸nther, 1878	Primary	6598	2009-01-01 00:00:00
highfin-lizardfish	4654	unknown	Common	6599	2009-01-01 00:00:00
bathysaurus-mollis	4654	G¸nther, 1878	Synonym	6600	2009-01-01 00:00:00
Synodus	4655	unknown	Primary	6601	2009-01-01 00:00:00
synodus	4655	unknown	Synonym	6602	2009-01-01 00:00:00
Synodus lucioceps	4656	ayres	Primary	6603	2009-01-01 00:00:00
california-lizardfish	4656	unknown	Common	6604	2009-01-01 00:00:00
synodus-lucioceps	4656	ayres	Synonym	6605	2009-01-01 00:00:00
Alepisauridae	4657	unknown	Primary	6606	2009-01-01 00:00:00
lancetfish	4657	shiino, 1978	Common	6607	2009-01-01 00:00:00
Alepisaurus	4658	lowe, 1833	Primary	6608	2009-01-01 00:00:00
alepisaurus	4658	lowe, 1833	Synonym	6609	2009-01-01 00:00:00
Alepisaurus ferox	4659	lowe, 1833	Primary	6610	2009-01-01 00:00:00
longnose-lancetfish	4659	amer. fisheries society, 1980	Common	6611	2009-01-01 00:00:00
alepisaurus-ferox	4659	lowe, 1833	Synonym	6612	2009-01-01 00:00:00
Paralepididae	4660	unknown	Primary	6613	2009-01-01 00:00:00
barracudina	4660	shiino, 1978	Common	6614	2009-01-01 00:00:00
paralepididae	4660	unknown	Synonym	6615	2009-01-01 00:00:00
Arctozenus	4661	unknown	Primary	6616	2009-01-01 00:00:00
arctozenus	4661	unknown	Synonym	6617	2009-01-01 00:00:00
Arctozenus risso	4662	(Bonaparte, 1840)	Primary	6618	2009-01-01 00:00:00
notolepis-rissoi	4662	unknown	Synonym	6619	2009-01-01 00:00:00
ribbon-barracudina	4662	unknown	Common	6620	2009-01-01 00:00:00
arctozenus-risso	4662	(Bonaparte, 1840)	Synonym	6621	2009-01-01 00:00:00
Lestidium	4663	unknown	Primary	6622	2009-01-01 00:00:00
lestidium	4663	unknown	Synonym	6623	2009-01-01 00:00:00
Stemonosudis	4664	unknown	Primary	6624	2009-01-01 00:00:00
stemonosudis	4664	unknown	Synonym	6625	2009-01-01 00:00:00
Stemonosudis macrurus	4665	(Ege, 1933)	Primary	6626	2009-01-01 00:00:00
macroparalepis-macrurus	4665	unknown	Synonym	6627	2009-01-01 00:00:00
sharpchin-barracudina	4665	unknown	Common	6628	2009-01-01 00:00:00
stemonosudis-macrurus	4665	(Ege, 1933)	Synonym	6629	2009-01-01 00:00:00
Macroparalepis	4666	unknown	Primary	6630	2009-01-01 00:00:00
macroparalepis	4666	unknown	Synonym	6631	2009-01-01 00:00:00
Macroparalepis johnfitchi	4667	(Rofen 1960)	Primary	6632	2009-01-01 00:00:00
black-barracudina	4667	unknown	Common	6633	2009-01-01 00:00:00
macroparalepis-johnfitchi	4667	(Rofen 1960)	Synonym	6634	2009-01-01 00:00:00
Lestidiops	4668	unknown	Primary	6635	2009-01-01 00:00:00
lestidiops	4668	unknown	Synonym	6636	2009-01-01 00:00:00
Lestidiops sphyraenopsis	4669	Hubbs, 1916	Primary	6637	2009-01-01 00:00:00
smalleye-barracudina	4669	unknown	Common	6638	2009-01-01 00:00:00
lestidiops-sphyraenopsis	4669	Hubbs, 1916	Synonym	6639	2009-01-01 00:00:00
Lestidiops ringens	4670	jordan and gilbert, 1880	Primary	6640	2009-01-01 00:00:00
slender-barracudina	4670	shiino, 1978	Common	6641	2009-01-01 00:00:00
lestidium-ringens	4670	unknown	Synonym	6642	2009-01-01 00:00:00
lestidiops-ringens	4670	jordan and gilbert, 1880	Synonym	6643	2009-01-01 00:00:00
Paralepis	4671	unknown	Primary	6644	2009-01-01 00:00:00
paralepis	4671	unknown	Synonym	6645	2009-01-01 00:00:00
Paralepis atlantica	4672	Kr¯yer, 1868	Primary	6646	2009-01-01 00:00:00
duckbill-barracudina	4672	unknown	Common	6647	2009-01-01 00:00:00
paralepis-atlantica	4672	Kr¯yer, 1868	Synonym	6648	2009-01-01 00:00:00
Giganturidae	4673	unknown	Primary	6649	2009-01-01 00:00:00
telescopefish	4673	unknown	Common	6650	2009-01-01 00:00:00
giganturidae	4673	unknown	Synonym	6651	2009-01-01 00:00:00
Gigantura	4674	unknown	Primary	6652	2009-01-01 00:00:00
gigantura	4674	unknown	Synonym	6653	2009-01-01 00:00:00
Gigantura indica	4675	Brauer, 1901	Primary	6654	2009-01-01 00:00:00
lisa`s-telescopefish	4675	unknown	Common	6655	2009-01-01 00:00:00
pacific-telescopefish	4675	unknown	Common	6656	2009-01-01 00:00:00
gigantura-indica	4675	Brauer, 1901	Synonym	6657	2009-01-01 00:00:00
Notosudidae	4676	unknown	Primary	6658	2009-01-01 00:00:00
waryfish	4676	unknown	Common	6659	2009-01-01 00:00:00
paperbone-fish	4676	unknown	Common	6660	2009-01-01 00:00:00
notosudidae	4676	unknown	Synonym	6661	2009-01-01 00:00:00
Scopelosaurus	4677	unknown	Primary	6662	2009-01-01 00:00:00
scopelosaurus	4677	unknown	Synonym	6663	2009-01-01 00:00:00
Scopelosaurus harryi	4678	(Mead, 1953)	Primary	6664	2009-01-01 00:00:00
scaly-paperbone	4678	unknown	Common	6665	2009-01-01 00:00:00
scopelosaurus-harryi	4678	(Mead, 1953)	Synonym	6666	2009-01-01 00:00:00
Anotopteridae	4679	unknown	Primary	6667	2009-01-01 00:00:00
Anotopterus	4680	unknown	Primary	6668	2009-01-01 00:00:00
anotopterus	4680	unknown	Synonym	6669	2009-01-01 00:00:00
Anotopterus pharao	4681	Zugmayer, 1911	Primary	6670	2009-01-01 00:00:00
daggertooth	4681	unknown	Common	6671	2009-01-01 00:00:00
anotopterus-pharao	4681	Zugmayer, 1911	Synonym	6672	2009-01-01 00:00:00
Scopelarchidae	4682	unknown	Primary	6673	2009-01-01 00:00:00
pearleye	4682	unknown	Common	6674	2009-01-01 00:00:00
scopelarchidae	4682	unknown	Synonym	6675	2009-01-01 00:00:00
Benthalbella	4683	unknown	Primary	6676	2009-01-01 00:00:00
benthalbella	4683	unknown	Synonym	6677	2009-01-01 00:00:00
Benthalbella linguidens	4684	(Mead & Bˆhlke, 1953)	Primary	6678	2009-01-01 00:00:00
longfin-pearleye	4684	unknown	Common	6679	2009-01-01 00:00:00
benthalbella-linguidens	4684	(Mead & Bˆhlke, 1953)	Synonym	6680	2009-01-01 00:00:00
Benthalbella dentata	4685	(Chapman, 1939)	Primary	6681	2009-01-01 00:00:00
northern-pearleye	4685	unknown	Common	6682	2009-01-01 00:00:00
benthalbella-dentata	4685	(Chapman, 1939)	Synonym	6683	2009-01-01 00:00:00
Scopelarchus	4686	unknown	Primary	6684	2009-01-01 00:00:00
scopelarchus	4686	unknown	Synonym	6685	2009-01-01 00:00:00
Scopelarchus analis	4687	(Brauer, 1902)	Primary	6686	2009-01-01 00:00:00
blackbelly-pearleye	4687	unknown	Common	6687	2009-01-01 00:00:00
shortfin-pearleye	4687	unknown	Common	6688	2009-01-01 00:00:00
scopelarchus-analis	4687	(Brauer, 1902)	Synonym	6689	2009-01-01 00:00:00
Ipnopidae	4688	\N	Primary	6690	2009-01-01 00:00:00
deep-sea tripod fish	4688		Common	6691	2009-01-01 00:00:00
Bathypteroidae	4688	Nelson, J.S. 1994. Fishes of the World, Third Edition. John Wiley and Sons, New York, NY. xvii + 600 	Synonym	6692	2009-01-01 00:00:00
spiderfish	4688		Common	6693	2009-01-01 00:00:00
Bathypterois	4689	Guenther, 1878	Primary	6694	2009-01-01 00:00:00
tripodfishes	4689	unknown	Common	6695	2009-01-01 00:00:00
bathypterois	4689	Guenther, 1878	Synonym	6696	2009-01-01 00:00:00
Bathypterois grallator	4690	(Goode and Bean, 1886)	Primary	6697	2009-01-01 00:00:00
tripodfish	4690		Common	6698	2009-01-01 00:00:00
Bathypterois atricolor	4691	Alcock, 1896	Primary	6699	2009-01-01 00:00:00
attenuated spider fish 	4691		Common	6700	2009-01-01 00:00:00
Acanthopterygii	4692	unknown	Primary	6701	2009-01-01 00:00:00
Perciformes	4693	unknown	Primary	6702	2009-01-01 00:00:00
perch-like-fish	4693	shiino, 1978	Common	6703	2009-01-01 00:00:00
perciformes	4693	unknown	Synonym	6704	2009-01-01 00:00:00
Blennioidei	4694	unknown	Primary	6705	2009-01-01 00:00:00
blennioidei	4694	unknown	Synonym	6706	2009-01-01 00:00:00
Blenniidae	4695	unknown	Primary	6707	2009-01-01 00:00:00
scaleless-blenny	4695	unknown	Common	6708	2009-01-01 00:00:00
combtooth-blenny	4695	unknown	Common	6709	2009-01-01 00:00:00
blenny	4695	unknown	Common	6710	2009-01-01 00:00:00
blenniidae	4695	unknown	Synonym	6711	2009-01-01 00:00:00
Zoarcoidei	4696	unknown	Primary	6712	2009-01-01 00:00:00
zoarcoidei	4696	unknown	Synonym	6713	2009-01-01 00:00:00
Cryptacanthodidae	4697	unknown	Primary	6714	2009-01-01 00:00:00
wrymouth	4697	unknown	Common	6715	2009-01-01 00:00:00
cryptacanthodidae	4697	unknown	Synonym	6716	2009-01-01 00:00:00
Cryptacanthodes	4698	unknown	Primary	6717	2009-01-01 00:00:00
cryptacanthodes	4698	unknown	Synonym	6718	2009-01-01 00:00:00
Cryptacanthodes aleutensis	4699	(Gilbert, 1896)	Primary	6719	2009-01-01 00:00:00
dwarf-wrymouth	4699	unknown	Common	6720	2009-01-01 00:00:00
cryptacanthodes-aleutensis	4699	(Gilbert, 1896)	Synonym	6721	2009-01-01 00:00:00
Cryptacanthodes giganteus	4700	(Kittlitz, 1858)	Primary	6722	2009-01-01 00:00:00
giant-wrymouth	4700	unknown	Common	6723	2009-01-01 00:00:00
cryptacanthodes-giganteus	4700	(Kittlitz, 1858)	Synonym	6724	2009-01-01 00:00:00
Bathymasteridae	4701	unknown	Primary	6725	2009-01-01 00:00:00
ronquil	4701	unknown	Common	6726	2009-01-01 00:00:00
bathymasteridae	4701	unknown	Synonym	6727	2009-01-01 00:00:00
Ronquilus	4702	unknown	Primary	6728	2009-01-01 00:00:00
ronquilus	4702	unknown	Synonym	6729	2009-01-01 00:00:00
Ronquilus jordani	4703	(Gilbert, 1889)	Primary	6730	2009-01-01 00:00:00
northern-ronquil	4703	unknown	Common	6731	2009-01-01 00:00:00
ronquilus-jordani	4703	(Gilbert, 1889)	Synonym	6732	2009-01-01 00:00:00
Rathbunella	4704	unknown	Primary	6733	2009-01-01 00:00:00
rathbunella	4704	unknown	Synonym	6734	2009-01-01 00:00:00
Rathbunella hypoplecta	4705	(Gilbert, 1890)	Primary	6735	2009-01-01 00:00:00
stripefin-ronquil	4705	unknown	Common	6736	2009-01-01 00:00:00
rathbunella-hypoplecta	4705	(Gilbert, 1890)	Synonym	6737	2009-01-01 00:00:00
Zoarcidae	4706	unknown	Primary	6738	2009-01-01 00:00:00
viviparous-blennies	4706	unknown	Common	6739	2009-01-01 00:00:00
eelpout	4706	shiino, 1978	Common	6740	2009-01-01 00:00:00
zoarcidae	4706	unknown	Synonym	6741	2009-01-01 00:00:00
Pachycara	4707	unknown	Primary	6742	2009-01-01 00:00:00
pachycara	4707	unknown	Synonym	6743	2009-01-01 00:00:00
Pachycara bulbiceps	4708	(Garman, 1899)	Primary	6744	2009-01-01 00:00:00
snubnose-eelpout	4708	unknown	Common	6745	2009-01-01 00:00:00
pachycara-bulbiceps	4708	(Garman, 1899)	Synonym	6746	2009-01-01 00:00:00
Maynea	4709	unknown	Primary	6747	2009-01-01 00:00:00
maynea	4709	unknown	Synonym	6748	2009-01-01 00:00:00
Melanostigma	4710	unknown	Primary	6749	2009-01-01 00:00:00
melanostigma	4710	unknown	Synonym	6750	2009-01-01 00:00:00
Melanostigma pammelas	4711	gilbert	Primary	6751	2009-01-01 00:00:00
midwater-eelpout	4711	unknown	Common	6752	2009-01-01 00:00:00
melanostigma-pammelas	4711	gilbert	Synonym	6753	2009-01-01 00:00:00
Derepodichthys	4712	unknown	Primary	6754	2009-01-01 00:00:00
derepodichthys	4712	unknown	Synonym	6755	2009-01-01 00:00:00
Derepodichthys alepidotus	4713	Gilbert, 1896	Primary	6756	2009-01-01 00:00:00
cuskpout	4713	unknown	Common	6757	2009-01-01 00:00:00
derepodichthys-alepidotus	4713	Gilbert, 1896	Synonym	6758	2009-01-01 00:00:00
Bothrocara	4714	unknown	Primary	6759	2009-01-01 00:00:00
bothrocara	4714	unknown	Synonym	6760	2009-01-01 00:00:00
Bothrocara molle	4715	Bean, 1890	Primary	6761	2009-01-01 00:00:00
soft-eelpout	4715	unknown	Common	6762	2009-01-01 00:00:00
bothrocara-molle	4715	Bean, 1890	Synonym	6763	2009-01-01 00:00:00
Bothrocara brunneum	4716	bean, 1891	Primary	6764	2009-01-01 00:00:00
twoline-eelpout	4716	siino, 1978	Common	6765	2009-01-01 00:00:00
bothrocara-brunneum	4716	bean, 1891	Synonym	6766	2009-01-01 00:00:00
Lyconema	4717	unknown	Primary	6767	2009-01-01 00:00:00
lyconema	4717	unknown	Synonym	6768	2009-01-01 00:00:00
Lyconema barbatum	4718	gilbert	Primary	6769	2009-01-01 00:00:00
bearded-eelpout	4718	amer. fisheries society, 1980	Common	6770	2009-01-01 00:00:00
lyconema-barbatum	4718	gilbert	Synonym	6771	2009-01-01 00:00:00
Lycodes	4719	unknown	Primary	6772	2009-01-01 00:00:00
lycodes	4719	unknown	Synonym	6773	2009-01-01 00:00:00
Lycodes brevipes	4720	Bean, 1890	Primary	6774	2009-01-01 00:00:00
shortfin-eelpout	4720	unknown	Common	6775	2009-01-01 00:00:00
lycodes-brevipes	4720	Bean, 1890	Synonym	6776	2009-01-01 00:00:00
Lycodes cortezianus	4721	gilbert, 1890	Primary	6777	2009-01-01 00:00:00
bigfin-eelpout	4721	amer fisheries society, 1980	Common	6778	2009-01-01 00:00:00
aprodon-cortezianus	4721	unknown	Synonym	6779	2009-01-01 00:00:00
lycodes-cortezianus	4721	gilbert, 1890	Synonym	6780	2009-01-01 00:00:00
Lycodes diapterus	4722	gilbert, 1891	Primary	6781	2009-01-01 00:00:00
black-eelpout	4722	amer. fisheries society, 1980	Common	6782	2009-01-01 00:00:00
lycodes-diapterus	4722	gilbert, 1891	Synonym	6783	2009-01-01 00:00:00
Lycodes pacificus	4723	collett	Primary	6784	2009-01-01 00:00:00
blackbelly-eelpout	4723	amer. fisheries society, 1980	Common	6785	2009-01-01 00:00:00
lycodes-pacificus	4723	collett	Synonym	6786	2009-01-01 00:00:00
Embryx	4724	unknown	Primary	6787	2009-01-01 00:00:00
embryx	4724	unknown	Synonym	6788	2009-01-01 00:00:00
Aprodon	4725	unknown	Primary	6789	2009-01-01 00:00:00
aprodon	4725	unknown	Synonym	6790	2009-01-01 00:00:00
Lycodopsis	4726	unknown	Primary	6791	2009-01-01 00:00:00
lycodopsis	4726	unknown	Synonym	6792	2009-01-01 00:00:00
Lycenchelys	4727	unknown	Primary	6793	2009-01-01 00:00:00
lycenchelys	4727	unknown	Synonym	6794	2009-01-01 00:00:00
Lycenchelys jordani	4728	(Evermann & Goldsborough, 1907)	Primary	6795	2009-01-01 00:00:00
shortjaw-eelpout	4728	unknown	Common	6796	2009-01-01 00:00:00
lycenchelys-jordani	4728	(Evermann & Goldsborough, 1907)	Synonym	6797	2009-01-01 00:00:00
Lycenchelys crotalinus	4729	(Gilbert, 1890)	Primary	6798	2009-01-01 00:00:00
embryx-crotalinus	4729	unknown	Synonym	6799	2009-01-01 00:00:00
snakehead-eelpout	4729	unknown	Common	6800	2009-01-01 00:00:00
lycenchelys-crotalinus	4729	(Gilbert, 1890)	Synonym	6801	2009-01-01 00:00:00
Lycenchelys camchatica	4730	(Gilbert & Burke, 1912)	Primary	6802	2009-01-01 00:00:00
kamchatka-eelpout	4730	unknown	Common	6803	2009-01-01 00:00:00
lycenchelys-camchatica	4730	(Gilbert & Burke, 1912)	Synonym	6804	2009-01-01 00:00:00
Lycodapus	4731	unknown	Primary	6805	2009-01-01 00:00:00
lycodapus	4731	unknown	Synonym	6806	2009-01-01 00:00:00
Lycodapus dermatinus	4732	Gilbert, 1896	Primary	6807	2009-01-01 00:00:00
looseskin-eelpout	4732	unknown	Common	6808	2009-01-01 00:00:00
lycodapus-dermatinus	4732	Gilbert, 1896	Synonym	6809	2009-01-01 00:00:00
Lycodapus fierasfer	4733	Gilbert, 1890	Primary	6810	2009-01-01 00:00:00
blackmouth-eelpout	4733	unknown	Common	6811	2009-01-01 00:00:00
lycodapus-fierasfer	4733	Gilbert, 1890	Synonym	6812	2009-01-01 00:00:00
Lycodapus psarostomatus	4734	Peden & Anderson, 1981	Primary	6813	2009-01-01 00:00:00
lycodapus-psarostomatus	4734	Peden & Anderson, 1981	Synonym	6814	2009-01-01 00:00:00
Lycodapus endemoscotus	4735	Peden & Anderson, 1978	Primary	6815	2009-01-01 00:00:00
deepwater-slipskin	4735	unknown	Common	6816	2009-01-01 00:00:00
deepwater-eelpout	4735	unknown	Common	6817	2009-01-01 00:00:00
lycodapus-endemoscotus	4735	Peden & Anderson, 1978	Synonym	6818	2009-01-01 00:00:00
Lycodapus mandibularis	4736	gilbert, 1915	Primary	6819	2009-01-01 00:00:00
pallid-eelpout	4736	amer. fisheries society, 1980	Common	6820	2009-01-01 00:00:00
lycodapus-mandibularis	4736	gilbert, 1915	Synonym	6821	2009-01-01 00:00:00
Thermarces	4737	Rosenblatt & Cohen , 1986	Primary	6822	2009-01-01 00:00:00
thermarces	4737	Rosenblatt & Cohen , 1986	Synonym	6823	2009-01-01 00:00:00
Thermarces cerberus	4738	Rosenblatt & Cohen, 1986	Primary	6824	2009-01-01 00:00:00
thermarces-cerberus	4738	Rosenblatt & Cohen, 1986	Synonym	6825	2009-01-01 00:00:00
Eucryphycus	4739	\N	Primary	6826	2009-01-01 00:00:00
Eucryphycus californicus	4740	\N	Primary	6827	2009-01-01 00:00:00
Persimmon eelpout	4740	Starks & Mann, 1911	Common	6828	2009-01-01 00:00:00
 Maynea californica	4740	Starks & Mann, 1911	Synonym	6829	2009-01-01 00:00:00
Stichaeidae	4741	unknown	Primary	6830	2009-01-01 00:00:00
prickleback	4741	unknown	Common	6831	2009-01-01 00:00:00
stichaeidae	4741	unknown	Synonym	6832	2009-01-01 00:00:00
Plectobranchus	4742	unknown	Primary	6833	2009-01-01 00:00:00
plectobranchus	4742	unknown	Synonym	6834	2009-01-01 00:00:00
Plectobranchus evides	4743	Gilbert, 1890	Primary	6835	2009-01-01 00:00:00
bluebarred-prickleback	4743	unknown	Common	6836	2009-01-01 00:00:00
plectobranchus-evides	4743	Gilbert, 1890	Synonym	6837	2009-01-01 00:00:00
Lumpenus	4744	unknown	Primary	6838	2009-01-01 00:00:00
lumpenus	4744	unknown	Synonym	6839	2009-01-01 00:00:00
Lumpenus sagitta	4745	Wilimovsky, 1956	Primary	6840	2009-01-01 00:00:00
chaetodontidae	4762	unknown	Synonym	6885	2009-01-01 00:00:00
Polynemidae	4763	unknown	Primary	6886	2009-01-01 00:00:00
threadfin	4763	unknown	Common	6887	2009-01-01 00:00:00
polynemidae	4763	unknown	Synonym	6888	2009-01-01 00:00:00
Polydactylus	4764	unknown	Primary	6889	2009-01-01 00:00:00
polydactylus	4764	unknown	Synonym	6890	2009-01-01 00:00:00
Polydactylus approximans	4765	(Lay & Bennett, 1839)	Primary	6891	2009-01-01 00:00:00
blue-bobo	4765	unknown	Common	6892	2009-01-01 00:00:00
polydactylus-approximans	4765	(Lay & Bennett, 1839)	Synonym	6893	2009-01-01 00:00:00
Gerreidae	4766	unknown	Primary	6894	2009-01-01 00:00:00
mojarra	4766	unknown	Common	6895	2009-01-01 00:00:00
gerreidae	4766	unknown	Synonym	6896	2009-01-01 00:00:00
Coryphaenidae	4767	unknown	Primary	6897	2009-01-01 00:00:00
dolphinfish	4767	unknown	Common	6898	2009-01-01 00:00:00
coryphaenidae	4767	unknown	Synonym	6899	2009-01-01 00:00:00
Coryphaena hippurus	4768	Linnaeus, 1758	Primary	6900	2009-01-01 00:00:00
common-dolphinfish	4768	unknown	Common	6901	2009-01-01 00:00:00
coryphaena-hippurus	4768	Linnaeus, 1758	Synonym	6902	2009-01-01 00:00:00
Coryphaena	4769	unknown	Primary	6903	2009-01-01 00:00:00
coryphaena	4769	unknown	Synonym	6904	2009-01-01 00:00:00
Malacanthidae	4770	unknown	Primary	6905	2009-01-01 00:00:00
branchiostegidae	4770	unknown	Synonym	6906	2009-01-01 00:00:00
tilefish	4770	shiino, 1978	Common	6907	2009-01-01 00:00:00
malacanthidae	4770	unknown	Synonym	6908	2009-01-01 00:00:00
Caulolatilus	4771	unknown	Primary	6909	2009-01-01 00:00:00
caulolatilus	4771	unknown	Synonym	6910	2009-01-01 00:00:00
Caulolatilus princeps	4772	jenyns, 1842	Primary	6911	2009-01-01 00:00:00
ocean-whitefish	4772	amer. fisheries society, 1980	Common	6912	2009-01-01 00:00:00
caulolatilus-princeps	4772	jenyns, 1842	Synonym	6913	2009-01-01 00:00:00
Serranidae	4773	unknown	Primary	6914	2009-01-01 00:00:00
sea-bass	4773	unknown	Common	6915	2009-01-01 00:00:00
grouper	4773	shiino, 1978	Common	6916	2009-01-01 00:00:00
serranidae	4773	unknown	Synonym	6917	2009-01-01 00:00:00
Hemanthias	4774	Steindachner, 1874	Primary	6918	2009-01-01 00:00:00
hemanthias	4774	Steindachner, 1874	Synonym	6919	2009-01-01 00:00:00
Holanthias	4775	unknown	Primary	6920	2009-01-01 00:00:00
holanthias	4775	unknown	Synonym	6921	2009-01-01 00:00:00
Holanthias fuscipinnis	4776	unknown	Primary	6922	2009-01-01 00:00:00
brown-finned-basslet	4776	unknown	Common	6923	2009-01-01 00:00:00
holanthias-fuscipinnis	4776	unknown	Synonym	6924	2009-01-01 00:00:00
Mullidae	4777	unknown	Primary	6925	2009-01-01 00:00:00
goatfish	4777	unknown	Common	6926	2009-01-01 00:00:00
mullidae	4777	unknown	Synonym	6927	2009-01-01 00:00:00
Carangidae	4778	unknown	Primary	6928	2009-01-01 00:00:00
pompano	4778	unknown	Common	6929	2009-01-01 00:00:00
amberjack	4778	unknown	Common	6930	2009-01-01 00:00:00
jack	4778	unknown	Common	6931	2009-01-01 00:00:00
carangidae	4778	unknown	Synonym	6932	2009-01-01 00:00:00
Trachurus	4779	unknown	Primary	6933	2009-01-01 00:00:00
trachurus	4779	unknown	Synonym	6934	2009-01-01 00:00:00
Trachurus symmetricus	4780	(Ayres, 1855)	Primary	6935	2009-01-01 00:00:00
pacific-jack-mackerel	4780	unknown	Common	6936	2009-01-01 00:00:00
jack-mackerel	4780	unknown	Common	6937	2009-01-01 00:00:00
trachurus-symmetricus	4780	(Ayres, 1855)	Synonym	6938	2009-01-01 00:00:00
Seriola	4781	unknown	Primary	6939	2009-01-01 00:00:00
seriola	4781	unknown	Synonym	6940	2009-01-01 00:00:00
Seriola lalandi	4782	Valenciennes, 1833	Primary	6941	2009-01-01 00:00:00
yellowtail-amberjack	4782	unknown	Common	6942	2009-01-01 00:00:00
seriola-lalandi	4782	Valenciennes, 1833	Synonym	6943	2009-01-01 00:00:00
Polyprionidae	4783	unknown	Primary	6944	2009-01-01 00:00:00
wreckfish	4783	unknown	Common	6945	2009-01-01 00:00:00
polyprionidae	4783	unknown	Synonym	6946	2009-01-01 00:00:00
Stereolepis	4784	unknown	Primary	6947	2009-01-01 00:00:00
stereolepis	4784	unknown	Synonym	6948	2009-01-01 00:00:00
Stereolepis gigas	4785	Ayres, 1859	Primary	6949	2009-01-01 00:00:00
giant-seabass	4785	unknown	Common	6950	2009-01-01 00:00:00
stereolepis-gigas	4785	Ayres, 1859	Synonym	6951	2009-01-01 00:00:00
Epigonidae	4786	unknown	Primary	6952	2009-01-01 00:00:00
deepwater-cardinalfish	4786	unknown	Common	6953	2009-01-01 00:00:00
epigonidae	4786	unknown	Synonym	6954	2009-01-01 00:00:00
Pomacanthidae	4787	unknown	Primary	6955	2009-01-01 00:00:00
angelfish	4787	unknown	Common	6956	2009-01-01 00:00:00
pomacanthidae	4787	unknown	Synonym	6957	2009-01-01 00:00:00
Priacanthidae	4788	unknown	Primary	6958	2009-01-01 00:00:00
bigeye-fish	4788	unknown	Common	6959	2009-01-01 00:00:00
priacanthidae	4788	unknown	Synonym	6960	2009-01-01 00:00:00
Cookeolus	4789	unknown	Primary	6961	2009-01-01 00:00:00
cookeolus	4789	unknown	Synonym	6962	2009-01-01 00:00:00
Cookeolus japonicus	4790	unknown	Primary	6963	2009-01-01 00:00:00
long-finned bullseye	4790	unknown	Common	6964	2009-01-01 00:00:00
Echeneidae	4791	unknown	Primary	6965	2009-01-01 00:00:00
sharksucker	4791	unknown	Common	6966	2009-01-01 00:00:00
remora-family	4791	unknown	Common	6967	2009-01-01 00:00:00
echeneidae	4791	unknown	Synonym	6968	2009-01-01 00:00:00
Remora	4792	unknown	Primary	6969	2009-01-01 00:00:00
remora	4792	unknown	Synonym	6970	2009-01-01 00:00:00
Remora remora	4793	(Linnaeus, 1758)	Primary	6971	2009-01-01 00:00:00
common-remora	4793	unknown	Common	6972	2009-01-01 00:00:00
remora-remora	4793	(Linnaeus, 1758)	Synonym	6973	2009-01-01 00:00:00
Apogonidae	4794	unknown	Primary	6974	2009-01-01 00:00:00
cardinalfish	4794	unknown	Common	6975	2009-01-01 00:00:00
apogonidae	4794	unknown	Synonym	6976	2009-01-01 00:00:00
Percicthyidae	4795	unknown	Primary	6977	2009-01-01 00:00:00
temperate-bass	4795	unknown	Common	6978	2009-01-01 00:00:00
percicthyidae	4795	unknown	Synonym	6979	2009-01-01 00:00:00
Howella	4796	unknown	Primary	6980	2009-01-01 00:00:00
howella	4796	unknown	Synonym	6981	2009-01-01 00:00:00
Howella brodiei	4797	Ogilby, 1899	Primary	6982	2009-01-01 00:00:00
pelagic-basslet	4797	unknown	Common	6983	2009-01-01 00:00:00
howella-brodiei	4797	Ogilby, 1899	Synonym	6984	2009-01-01 00:00:00
Sciaenidae	4798	unknown	Primary	6985	2009-01-01 00:00:00
roncadore	4798	unknown	Common	6986	2009-01-01 00:00:00
drum	4798	unknown	Common	6987	2009-01-01 00:00:00
croaker	4798	shiino, 1978	Common	6988	2009-01-01 00:00:00
sciaenidae	4798	unknown	Synonym	6989	2009-01-01 00:00:00
Cynoscion	4799	unknown	Primary	6990	2009-01-01 00:00:00
weak-fish	4799	unknown	Common	6991	2009-01-01 00:00:00
sea-trout	4799	shiino, 1978	Common	6992	2009-01-01 00:00:00
cynoscion	4799	unknown	Synonym	6993	2009-01-01 00:00:00
Genyonemus	4800	unknown	Primary	6994	2009-01-01 00:00:00
genyonemus	4800	unknown	Synonym	6995	2009-01-01 00:00:00
Genyonemus lineatus	4801	(ayres)	Primary	6996	2009-01-01 00:00:00
white-croaker	4801	amer. fisheries society, 1980	Common	6997	2009-01-01 00:00:00
genyonemus-lineatus	4801	(ayres)	Synonym	6998	2009-01-01 00:00:00
Atractoscion	4802	unknown	Primary	6999	2009-01-01 00:00:00
atractoscion	4802	unknown	Synonym	7000	2009-01-01 00:00:00
Atractoscion nobilis	4803	unknown	Primary	7001	2009-01-01 00:00:00
cynoscion-nobilis	4803	ayres	Synonym	7002	2009-01-01 00:00:00
white-seabass	4803	amer. fisheries society, 1980	Common	7003	2009-01-01 00:00:00
atractoscion-nobilis	4803	unknown	Synonym	7004	2009-01-01 00:00:00
Seriphus	4804	unknown	Primary	7005	2009-01-01 00:00:00
seriphus	4804	unknown	Synonym	7006	2009-01-01 00:00:00
Seriphus politus	4805	Ayres, 1860	Primary	7007	2009-01-01 00:00:00
queen-croaker	4805	unknown	Common	7008	2009-01-01 00:00:00
queenfish	4805	unknown	Common	7009	2009-01-01 00:00:00
seriphus-politus	4805	Ayres, 1860	Synonym	7010	2009-01-01 00:00:00
Bramidae	4806	unknown	Primary	7011	2009-01-01 00:00:00
pomfret	4806	unknown	Common	7012	2009-01-01 00:00:00
bramidae	4806	unknown	Synonym	7013	2009-01-01 00:00:00
Brama	4807	unknown	Primary	7014	2009-01-01 00:00:00
brama	4807	unknown	Synonym	7015	2009-01-01 00:00:00
Brama japonica	4808	Hilgendorf, 1878	Primary	7016	2009-01-01 00:00:00
pacific-pomfret	4808	unknown	Common	7017	2009-01-01 00:00:00
brama-japonica	4808	Hilgendorf, 1878	Synonym	7018	2009-01-01 00:00:00
Taractes	4809	unknown	Primary	7019	2009-01-01 00:00:00
taractes	4809	unknown	Synonym	7020	2009-01-01 00:00:00
Taractes asper	4810	Lowe, 1843	Primary	7021	2009-01-01 00:00:00
rough-pomfret	4810	unknown	Common	7022	2009-01-01 00:00:00
taractes-asper	4810	Lowe, 1843	Synonym	7023	2009-01-01 00:00:00
Opistognathidae	4811	unknown	Primary	7024	2009-01-01 00:00:00
jawfish	4811	unknown	Common	7025	2009-01-01 00:00:00
opistognathidae	4811	unknown	Synonym	7026	2009-01-01 00:00:00
Sparidae	4812	unknown	Primary	7027	2009-01-01 00:00:00
seabream	4812	unknown	Common	7028	2009-01-01 00:00:00
porgy	4812	unknown	Common	7029	2009-01-01 00:00:00
sparidae	4812	unknown	Synonym	7030	2009-01-01 00:00:00
Pentacerotidae	4813	unknown	Primary	7031	2009-01-01 00:00:00
armorhead	4813	unknown	Common	7032	2009-01-01 00:00:00
pentacerotidae	4813	unknown	Synonym	7033	2009-01-01 00:00:00
Pentaceros	4814	unknown	Primary	7034	2009-01-01 00:00:00
pentaceros	4814	unknown	Synonym	7035	2009-01-01 00:00:00
Pentaceros pectoralis	4815	(Hardy, 1983)	Primary	7036	2009-01-01 00:00:00
longfin-armorhead	4815	unknown	Common	7037	2009-01-01 00:00:00
pentaceros-pectoralis	4815	(Hardy, 1983)	Synonym	7038	2009-01-01 00:00:00
Lutjanidae	4816	unknown	Primary	7039	2009-01-01 00:00:00
snapper	4816	unknown	Common	7040	2009-01-01 00:00:00
lutjanidae	4816	unknown	Synonym	7041	2009-01-01 00:00:00
Lobotidae	4817	unknown	Primary	7042	2009-01-01 00:00:00
tripletail	4817	unknown	Common	7043	2009-01-01 00:00:00
lobotidae	4817	unknown	Synonym	7044	2009-01-01 00:00:00
Caristiidae	4818	unknown	Primary	7045	2009-01-01 00:00:00
veilfin	4818	unknown	Common	7046	2009-01-01 00:00:00
manefish	4818	unknown	Common	7047	2009-01-01 00:00:00
caristiidae	4818	unknown	Synonym	7048	2009-01-01 00:00:00
Caristius	4819	unknown	Primary	7049	2009-01-01 00:00:00
caristius	4819	unknown	Synonym	7050	2009-01-01 00:00:00
Caristius macropus	4820	(Bellotti, 1903)	Primary	7051	2009-01-01 00:00:00
bigmouth-veilfin	4820	unknown	Common	7052	2009-01-01 00:00:00
caristius-macropus	4820	(Bellotti, 1903)	Synonym	7053	2009-01-01 00:00:00
Acanthuroidei	4821	unknown	Primary	7054	2009-01-01 00:00:00
acanthuroidei	4821	unknown	Synonym	7055	2009-01-01 00:00:00
Acanthuridae	4822	unknown	Primary	7056	2009-01-01 00:00:00
unicornfish	4822	unknown	Common	7057	2009-01-01 00:00:00
surgeonfish	4822	unknown	Common	7058	2009-01-01 00:00:00
acanthuridae	4822	unknown	Synonym	7059	2009-01-01 00:00:00
Luvaridae	4823	unknown	Primary	7060	2009-01-01 00:00:00
luvar	4823	unknown	Common	7061	2009-01-01 00:00:00
luvaridae	4823	unknown	Synonym	7062	2009-01-01 00:00:00
Luvarus	4824	unknown	Primary	7063	2009-01-01 00:00:00
luvarus	4824	unknown	Synonym	7064	2009-01-01 00:00:00
Luvarus imperialis	4825	Rafinesque, 1810	Primary	7065	2009-01-01 00:00:00
luvarus-imperialis	4825	Rafinesque, 1810	Synonym	7066	2009-01-01 00:00:00
Zanclidae	4826	unknown	Primary	7067	2009-01-01 00:00:00
moorish-idol-fish	4826	unknown	Common	7068	2009-01-01 00:00:00
zanclidae	4826	unknown	Synonym	7069	2009-01-01 00:00:00
Zanclus	4827	unknown	Primary	7070	2009-01-01 00:00:00
zanclus	4827	unknown	Synonym	7071	2009-01-01 00:00:00
Zanclus canescens	4828	Linnaeus, 1758	Primary	7072	2009-01-01 00:00:00
moorish-idol	4828	unknown	Common	7073	2009-01-01 00:00:00
zanclus-canescens	4828	Linnaeus, 1758	Synonym	7074	2009-01-01 00:00:00
Labroidei	4829	unknown	Primary	7075	2009-01-01 00:00:00
labroidei	4829	unknown	Synonym	7076	2009-01-01 00:00:00
Embiotocidae	4830	unknown	Primary	7077	2009-01-01 00:00:00
surfperch	4830	unknown	Common	7078	2009-01-01 00:00:00
embiotocidae	4830	unknown	Synonym	7079	2009-01-01 00:00:00
Rhacochilus	4831	unknown	Primary	7080	2009-01-01 00:00:00
rhacochilus	4831	unknown	Synonym	7081	2009-01-01 00:00:00
Zalembius	4832	unknown	Primary	7082	2009-01-01 00:00:00
zalembius	4832	unknown	Synonym	7083	2009-01-01 00:00:00
Zalembius rosaceus	4833	jordan-gilbert	Primary	7084	2009-01-01 00:00:00
pink-surfperch	4833	unknown	Common	7085	2009-01-01 00:00:00
zalembius-rosaceus	4833	jordan-gilbert	Synonym	7086	2009-01-01 00:00:00
Cymatogaster	4834	unknown	Primary	7087	2009-01-01 00:00:00
cymatogaster	4834	unknown	Synonym	7088	2009-01-01 00:00:00
Hyperprosopon	4835	unknown	Primary	7089	2009-01-01 00:00:00
hyperprosopon	4835	unknown	Synonym	7090	2009-01-01 00:00:00
Phanerodon	4836	unknown	Primary	7091	2009-01-01 00:00:00
phanerodon	4836	unknown	Synonym	7092	2009-01-01 00:00:00
Brachyistius	4837	unknown	Primary	7093	2009-01-01 00:00:00
brachyistius	4837	unknown	Synonym	7094	2009-01-01 00:00:00
Brachyistius frenatus	4838	gill, 1862	Primary	7095	2009-01-01 00:00:00
kelp-perch	4838	unknown	Common	7096	2009-01-01 00:00:00
brachyistius-frenatus	4838	gill, 1862	Synonym	7097	2009-01-01 00:00:00
Scaridae	4839	unknown	Primary	7098	2009-01-01 00:00:00
parrotfish	4839	unknown	Common	7099	2009-01-01 00:00:00
scaridae	4839	unknown	Synonym	7100	2009-01-01 00:00:00
Pomacentridae	4840	unknown	Primary	7101	2009-01-01 00:00:00
anemonefish	4840	unknown	Common	7102	2009-01-01 00:00:00
damselfish	4840	unknown	Common	7103	2009-01-01 00:00:00
pomacentridae	4840	unknown	Synonym	7104	2009-01-01 00:00:00
Labridae	4841	unknown	Primary	7105	2009-01-01 00:00:00
wrasse	4841	unknown	Common	7106	2009-01-01 00:00:00
labridae	4841	unknown	Synonym	7107	2009-01-01 00:00:00
Stromateoidei	4842	unknown	Primary	7108	2009-01-01 00:00:00
stromateoidei	4842	unknown	Synonym	7109	2009-01-01 00:00:00
Ariommatidae	4843	unknown	Primary	7110	2009-01-01 00:00:00
ariommatids	4843	unknown	Common	7111	2009-01-01 00:00:00
ariommatidae	4843	unknown	Synonym	7112	2009-01-01 00:00:00
Ariomma	4844	unknown	Primary	7113	2009-01-01 00:00:00
ariomma	4844	unknown	Synonym	7114	2009-01-01 00:00:00
Centrolophidae	4845	unknown	Primary	7115	2009-01-01 00:00:00
rudderfishes	4845	shiino, 1978	Common	7116	2009-01-01 00:00:00
centrolophidae	4845	unknown	Synonym	7117	2009-01-01 00:00:00
Icichthys	4846	unknown	Primary	7118	2009-01-01 00:00:00
icichthys	4846	unknown	Synonym	7119	2009-01-01 00:00:00
Icichthys lockingtoni	4847	jordan and gilbert	Primary	7120	2009-01-01 00:00:00
medusafish	4847	amer. fisheries society, 1980	Common	7121	2009-01-01 00:00:00
brown-rudderfish	4847	shiino, 1978	Common	7122	2009-01-01 00:00:00
icichthys-lockingtoni	4847	jordan and gilbert	Synonym	7123	2009-01-01 00:00:00
Tetragonuridae	4848	unknown	Primary	7124	2009-01-01 00:00:00
squaretail	4848	unknown	Common	7125	2009-01-01 00:00:00
tetragonuridae	4848	unknown	Synonym	7126	2009-01-01 00:00:00
Tetragonurus	4849	unknown	Primary	7127	2009-01-01 00:00:00
tetragonurus	4849	unknown	Synonym	7128	2009-01-01 00:00:00
Tetragonurus cuvieri	4850	Risso, 1810	Primary	7129	2009-01-01 00:00:00
smalleye-squaretail	4850	unknown	Common	7130	2009-01-01 00:00:00
tetragonurus-cuvieri	4850	Risso, 1810	Synonym	7131	2009-01-01 00:00:00
Stromateidae	4851	unknown	Primary	7132	2009-01-01 00:00:00
butterfish	4851	unknown	Common	7133	2009-01-01 00:00:00
stromateidae	4851	unknown	Synonym	7134	2009-01-01 00:00:00
Peprilus	4852	unknown	Primary	7135	2009-01-01 00:00:00
peprilus	4852	unknown	Synonym	7136	2009-01-01 00:00:00
Peprilus simillimus	4853	Ayres, 1860	Primary	7137	2009-01-01 00:00:00
pacific-butterfish	4853	unknown	Common	7138	2009-01-01 00:00:00
pacific-pompano	4853	unknown	Common	7139	2009-01-01 00:00:00
peprilus-simillimus	4853	Ayres, 1860	Synonym	7140	2009-01-01 00:00:00
Nomeidae	4854	unknown	Primary	7141	2009-01-01 00:00:00
driftfish	4854	unknown	Common	7142	2009-01-01 00:00:00
flotsamfish	4854	unknown	Common	7143	2009-01-01 00:00:00
nomeidae	4854	unknown	Synonym	7144	2009-01-01 00:00:00
Psenes	4855	unknown	Primary	7145	2009-01-01 00:00:00
psenes	4855	unknown	Synonym	7146	2009-01-01 00:00:00
Psenes pellucidus	4856	Luetken, 1880	Primary	7147	2009-01-01 00:00:00
bluefin-driftfish	4856	unknown	Common	7148	2009-01-01 00:00:00
psenes-pellucidus	4856	Luetken, 1880	Synonym	7149	2009-01-01 00:00:00
Scombroidei	4857	unknown	Primary	7150	2009-01-01 00:00:00
scombroidei	4857	unknown	Synonym	7151	2009-01-01 00:00:00
Gempylidae	4858	unknown	Primary	7152	2009-01-01 00:00:00
snake-mackeral	4858	unknown	Common	7153	2009-01-01 00:00:00
gempylidae	4858	unknown	Synonym	7154	2009-01-01 00:00:00
Ruvettus	4859	unknown	Primary	7155	2009-01-01 00:00:00
ruvettus	4859	unknown	Synonym	7156	2009-01-01 00:00:00
Ruvettus pretiosus	4860	Cocco, 1833	Primary	7157	2009-01-01 00:00:00
oilfish	4860	unknown	Common	7158	2009-01-01 00:00:00
ruvettus-pretiosus	4860	Cocco, 1833	Synonym	7159	2009-01-01 00:00:00
Gempylus	4861	unknown	Primary	7160	2009-01-01 00:00:00
gempylus	4861	unknown	Synonym	7161	2009-01-01 00:00:00
Gempylus serpens	4862	Cuvier, 1829	Primary	7162	2009-01-01 00:00:00
snake-mackerel	4862	unknown	Common	7163	2009-01-01 00:00:00
gempylus-serpens	4862	Cuvier, 1829	Synonym	7164	2009-01-01 00:00:00
Diplospinus	4863	unknown	Primary	7165	2009-01-01 00:00:00
diplospinus	4863	unknown	Synonym	7166	2009-01-01 00:00:00
Diplospinus multistriatus	4864	Maul, 1948	Primary	7167	2009-01-01 00:00:00
striped-escolar	4864	unknown	Common	7168	2009-01-01 00:00:00
lined-cutlassfish	4864	unknown	Common	7169	2009-01-01 00:00:00
diplospinus-multistriatus	4864	Maul, 1948	Synonym	7170	2009-01-01 00:00:00
Lepidocybium	4865	unknown	Primary	7171	2009-01-01 00:00:00
lepidocybium	4865	unknown	Synonym	7172	2009-01-01 00:00:00
Lepidocybium flavobrunneum	4866	Smith, 1849	Primary	7173	2009-01-01 00:00:00
escolar	4866	unknown	Common	7174	2009-01-01 00:00:00
lepidocybium-flavobrunneum	4866	Smith, 1849	Synonym	7175	2009-01-01 00:00:00
Xiphiidae	4867	unknown	Primary	7176	2009-01-01 00:00:00
swordfish	4867	unknown	Common	7177	2009-01-01 00:00:00
xiphiidae	4867	unknown	Synonym	7178	2009-01-01 00:00:00
Istiophoridae	4868	unknown	Primary	7179	2009-01-01 00:00:00
marlin	4868	unknown	Common	7180	2009-01-01 00:00:00
billfish	4868	unknown	Common	7181	2009-01-01 00:00:00
istiophoridae	4868	unknown	Synonym	7182	2009-01-01 00:00:00
Scombridae	4869	unknown	Primary	7183	2009-01-01 00:00:00
bonito	4869	unknown	Common	7184	2009-01-01 00:00:00
tuna	4869	unknown	Common	7185	2009-01-01 00:00:00
mackeral	4869	unknown	Common	7186	2009-01-01 00:00:00
scombridae	4869	unknown	Synonym	7187	2009-01-01 00:00:00
Trichiuridae	4870	unknown	Primary	7188	2009-01-01 00:00:00
scabbardfish	4870	unknown	Common	7189	2009-01-01 00:00:00
cutlassfish	4870	unknown	Common	7190	2009-01-01 00:00:00
Aphanopus	4871	unknown	Primary	7191	2009-01-01 00:00:00
aphanopus	4871	unknown	Synonym	7192	2009-01-01 00:00:00
Aphanopus carbo	4872	Lowe, 1839	Primary	7193	2009-01-01 00:00:00
black-scabbardfish	4872	unknown	Common	7194	2009-01-01 00:00:00
aphanopus-carbo	4872	Lowe, 1839	Synonym	7195	2009-01-01 00:00:00
Trichiurus	4873	Linnaeus, 1758	Primary	7196	2009-01-01 00:00:00
trichiurus	4873	Linnaeus, 1758	Synonym	7197	2009-01-01 00:00:00
Lepidopus	4874	unknown	Primary	7198	2009-01-01 00:00:00
lepidopus	4874	unknown	Synonym	7199	2009-01-01 00:00:00
Lepidopus fitchi	4875	Rosenblatt and Wilson, 1987	Primary	7200	2009-01-01 00:00:00
pacific-scabbardfish	4875	unknown	Common	7201	2009-01-01 00:00:00
fitch`s-scabbardfish	4875	unknown	Common	7202	2009-01-01 00:00:00
lepidopus-fitchi	4875	Rosenblatt and Wilson, 1987	Synonym	7203	2009-01-01 00:00:00
Benthodesmus	4876	unknown	Primary	7204	2009-01-01 00:00:00
benthodesmus	4876	unknown	Synonym	7205	2009-01-01 00:00:00
Benthodesmus tenuis	4877	Guenther, 1877	Primary	7206	2009-01-01 00:00:00
javelinfish	4877	unknown	Common	7207	2009-01-01 00:00:00
slender-frostfish	4877	unknown	Common	7208	2009-01-01 00:00:00
benthodesmus-tenuis	4877	Guenther, 1877	Synonym	7209	2009-01-01 00:00:00
Benthodesmus elongatus	4878	Clarke, 1879	Primary	7210	2009-01-01 00:00:00
frostfish	4878	unknown	Common	7211	2009-01-01 00:00:00
elongate-frostfish	4878	unknown	Common	7212	2009-01-01 00:00:00
bigeyed-scabbardfish	4878	unknown	Common	7213	2009-01-01 00:00:00
benthodesmus-elongatus	4878	Clarke, 1879	Synonym	7214	2009-01-01 00:00:00
Thrichiurus	4879	unknown	Primary	7215	2009-01-01 00:00:00
thrichiurus	4879	unknown	Synonym	7216	2009-01-01 00:00:00
Assurger	4880	Whitley, 1933	Primary	7217	2009-01-01 00:00:00
Assurger anzac	4881	Alexander, 1916	Primary	7218	2009-01-01 00:00:00
razorback-scabbardfish	4881	unknown	Common	7219	2009-01-01 00:00:00
assurger-anzac	4881	Alexander, 1916	Synonym	7220	2009-01-01 00:00:00
Sphyraenoidei	4882	unknown	Primary	7221	2009-01-01 00:00:00
sphyraenoidei	4882	unknown	Synonym	7222	2009-01-01 00:00:00
Sphyraenidae	4883	unknown	Primary	7223	2009-01-01 00:00:00
barracuda	4883	shiino, 1978	Common	7224	2009-01-01 00:00:00
sphyraenidae	4883	unknown	Synonym	7225	2009-01-01 00:00:00
Sphyraena	4884	unknown	Primary	7226	2009-01-01 00:00:00
sphyraena	4884	unknown	Synonym	7227	2009-01-01 00:00:00
Sphyraena argentea	4885	girard, 1854	Primary	7228	2009-01-01 00:00:00
california-barracuda	4885	unknown	Common	7229	2009-01-01 00:00:00
pacific-barracuda	4885	amer. fisheries society, 1980	Common	7230	2009-01-01 00:00:00
sphyraena-argentea	4885	girard, 1854	Synonym	7231	2009-01-01 00:00:00
Gobioidei	4886	unknown	Primary	7232	2009-01-01 00:00:00
gobioidei	4886	unknown	Synonym	7233	2009-01-01 00:00:00
Gobiidae	4887	unknown	Primary	7234	2009-01-01 00:00:00
goby	4887	unknown	Common	7235	2009-01-01 00:00:00
gobiidae	4887	unknown	Synonym	7236	2009-01-01 00:00:00
Lepidogobius	4888	unknown	Primary	7237	2009-01-01 00:00:00
lepidogobius	4888	unknown	Synonym	7238	2009-01-01 00:00:00
Lepidogobius lepidus	4889	Girard, 1858	Primary	7239	2009-01-01 00:00:00
bay-goby	4889	unknown	Common	7240	2009-01-01 00:00:00
lepidogobius-lepidus	4889	Girard, 1858	Synonym	7241	2009-01-01 00:00:00
Coryphopterus	4890	unknown	Primary	7242	2009-01-01 00:00:00
coryphopterus	4890	unknown	Synonym	7243	2009-01-01 00:00:00
Coryphopterus nicholsii	4891	bean	Primary	7244	2009-01-01 00:00:00
blackeye-goby	4891	amer. fisheries society, 1980	Common	7245	2009-01-01 00:00:00
coryphopterus-nicholsii	4891	bean	Synonym	7246	2009-01-01 00:00:00
Icosteoidei	4892	unknown	Primary	7247	2009-01-01 00:00:00
icosteoidei	4892	unknown	Synonym	7248	2009-01-01 00:00:00
Icosteidae	4893	unknown	Primary	7249	2009-01-01 00:00:00
icosteidae	4893	unknown	Synonym	7250	2009-01-01 00:00:00
Icosteus	4894	unknown	Primary	7251	2009-01-01 00:00:00
icosteus	4894	unknown	Synonym	7252	2009-01-01 00:00:00
Icosteus aenigmaticus	4895	Lockington, 1880	Primary	7253	2009-01-01 00:00:00
ragfish	4895	unknown	Common	7254	2009-01-01 00:00:00
icosteus-aenigmaticus	4895	Lockington, 1880	Synonym	7255	2009-01-01 00:00:00
Trachinoidei	4896	unknown	Primary	7256	2009-01-01 00:00:00
trachinoidei	4896	unknown	Synonym	7257	2009-01-01 00:00:00
Ammodytidae	4897	unknown	Primary	7258	2009-01-01 00:00:00
sand-lance	4897	unknown	Common	7259	2009-01-01 00:00:00
ammodytidae	4897	unknown	Synonym	7260	2009-01-01 00:00:00
Ammodytes	4898	unknown	Primary	7261	2009-01-01 00:00:00
ammodytes	4898	unknown	Synonym	7262	2009-01-01 00:00:00
Ammodytes hexapterus	4899	Pallas, 1814	Primary	7263	2009-01-01 00:00:00
pacific-sand-lance	4899	unknown	Common	7264	2009-01-01 00:00:00
ammodytes-hexapterus	4899	Pallas, 1814	Synonym	7265	2009-01-01 00:00:00
Uranoscopidae	4900	unknown	Primary	7266	2009-01-01 00:00:00
stargazer	4900	unknown	Common	7267	2009-01-01 00:00:00
uranoscopidae	4900	unknown	Synonym	7268	2009-01-01 00:00:00
Kathetostoma	4901	unknown	Primary	7269	2009-01-01 00:00:00
kathetostoma	4901	unknown	Synonym	7270	2009-01-01 00:00:00
Kathetostoma averruncus	4902	Jordan & Bollman, 1890	Primary	7271	2009-01-01 00:00:00
smooth-stargazer	4902	unknown	Common	7272	2009-01-01 00:00:00
kathetostoma-averruncus	4902	Jordan & Bollman, 1890	Synonym	7273	2009-01-01 00:00:00
Trichodontidae	4903	unknown	Primary	7274	2009-01-01 00:00:00
sandfish	4903	unknown	Common	7275	2009-01-01 00:00:00
trichodontidae	4903	unknown	Synonym	7276	2009-01-01 00:00:00
Trichodon	4904	unknown	Primary	7277	2009-01-01 00:00:00
trichodon	4904	unknown	Synonym	7278	2009-01-01 00:00:00
Trichodon trichodon	4905	(Tilesius, 1813)	Primary	7279	2009-01-01 00:00:00
pacific-sandfish	4905	unknown	Common	7280	2009-01-01 00:00:00
trichodon-trichodon	4905	(Tilesius, 1813)	Synonym	7281	2009-01-01 00:00:00
Chiasmodontidae	4906	unknown	Primary	7282	2009-01-01 00:00:00
swallower-chiasmodontid	4906	unknown	Common	7283	2009-01-01 00:00:00
chiasmodontidae	4906	unknown	Synonym	7284	2009-01-01 00:00:00
Kali	4907	unknown	Primary	7285	2009-01-01 00:00:00
kali	4907	unknown	Synonym	7286	2009-01-01 00:00:00
Kali normani	4908	(Parr, 1931)	Primary	7287	2009-01-01 00:00:00
needletooth-swallower	4908	unknown	Common	7288	2009-01-01 00:00:00
kali-normani	4908	(Parr, 1931)	Synonym	7289	2009-01-01 00:00:00
Kali indica	4909	Lloyd, 1909	Primary	7290	2009-01-01 00:00:00
shortnose-swallower	4909	unknown	Common	7291	2009-01-01 00:00:00
kali-indica	4909	Lloyd, 1909	Synonym	7292	2009-01-01 00:00:00
Chiasmodon	4910	unknown	Primary	7293	2009-01-01 00:00:00
chiasmodon	4910	unknown	Synonym	7294	2009-01-01 00:00:00
Chiasmodon niger	4911	Johnson, 1864	Primary	7295	2009-01-01 00:00:00
black-swallower	4911	unknown	Common	7296	2009-01-01 00:00:00
chiasmodon-niger	4911	Johnson, 1864	Synonym	7297	2009-01-01 00:00:00
Pleuronectiformes	4912	unknown	Primary	7298	2009-01-01 00:00:00
flatfish	4912	Shiino, 1978	Common	7299	2009-01-01 00:00:00
flounder	4912	unknown	Common	7300	2009-01-01 00:00:00
sole	4912	unknown	Common	7301	2009-01-01 00:00:00
pleuronectiformes-adult	4912	unknown	Common	7302	2009-01-01 00:00:00
pleuronectiformes	4912	unknown	Synonym	7303	2009-01-01 00:00:00
Pleuronectidae	4913	unknown	Primary	7304	2009-01-01 00:00:00
righteyed-flounder	4913	unknown	Common	7305	2009-01-01 00:00:00
halibut	4913	unknown	Common	7306	2009-01-01 00:00:00
dab	4913	shiino, 1978	Common	7307	2009-01-01 00:00:00
pleuronectidae	4913	unknown	Synonym	7308	2009-01-01 00:00:00
Reinhardtius	4914	Gill, 1861	Primary	7309	2009-01-01 00:00:00
reinhardtius	4914	Gill, 1861	Synonym	7310	2009-01-01 00:00:00
Platichthys	4915	unknown	Primary	7311	2009-01-01 00:00:00
platichthys	4915	unknown	Synonym	7312	2009-01-01 00:00:00
Platichthys stellatus	4916	Pallas, 1788	Primary	7313	2009-01-01 00:00:00
starry-flounder	4916	unknown	Common	7314	2009-01-01 00:00:00
platichthys-stellatus	4916	Pallas, 1788	Synonym	7315	2009-01-01 00:00:00
Eopsetta	4917	unknown	Primary	7316	2009-01-01 00:00:00
eopsetta	4917	unknown	Synonym	7317	2009-01-01 00:00:00
Eopsetta jordani	4918	Lockington, 1879	Primary	7318	2009-01-01 00:00:00
petrale-sole	4918	unknown	Common	7319	2009-01-01 00:00:00
eopsetta-jordani	4918	Lockington, 1879	Synonym	7320	2009-01-01 00:00:00
Glyptocephalus	4919	unknown	Primary	7321	2009-01-01 00:00:00
glyptocephalus	4919	unknown	Synonym	7322	2009-01-01 00:00:00
Glyptocephalus zachirus	4920	Lockington, 1879	Primary	7323	2009-01-01 00:00:00
errex-zachirus	4920	unknown	Synonym	7324	2009-01-01 00:00:00
rex-sole	4920	unknown	Common	7325	2009-01-01 00:00:00
glyptocephalus-zachirus	4920	Lockington, 1879	Synonym	7326	2009-01-01 00:00:00
Pleuronichthys	4921	unknown	Primary	7327	2009-01-01 00:00:00
pleuronichthys	4921	unknown	Synonym	7328	2009-01-01 00:00:00
Pleuronichthys verticalis	4922	Jordan and Gilbert, 1880	Primary	7329	2009-01-01 00:00:00
hornyhead-turbot	4922	unknown	Common	7330	2009-01-01 00:00:00
pleuronichthys-verticalis	4922	Jordan and Gilbert, 1880	Synonym	7331	2009-01-01 00:00:00
Pleuronichthys coenosus	4923	Girard, 1854	Primary	7332	2009-01-01 00:00:00
c-o-turbot	4923	unknown	Common	7333	2009-01-01 00:00:00
pleuronichthys-coenosus	4923	Girard, 1854	Synonym	7334	2009-01-01 00:00:00
Pleuronichthys decurrens	4924	Jordan and Gilbert, 1881	Primary	7335	2009-01-01 00:00:00
curlfin-turbot	4924	unknown	Common	7336	2009-01-01 00:00:00
pleuronichthys-decurrens	4924	Jordan and Gilbert, 1881	Synonym	7337	2009-01-01 00:00:00
Pleuronichthys guttulatus	4925	Girard, 1856	Primary	7338	2009-01-01 00:00:00
hypsopsetta	4925	unknown	Synonym	7339	2009-01-01 00:00:00
diamond	4925	unknown	Common	7340	2009-01-01 00:00:00
pleuronichthys-guttulatus	4925	Girard, 1856	Synonym	7341	2009-01-01 00:00:00
Clidoderma	4926	unknown	Primary	7342	2009-01-01 00:00:00
clidoderma	4926	unknown	Synonym	7343	2009-01-01 00:00:00
Clidoderma asperrimum	4927	Temminck & Schlegel, 1846	Primary	7344	2009-01-01 00:00:00
roughscale-sole	4927	unknown	Common	7345	2009-01-01 00:00:00
clidoderma-asperrimum	4927	Temminck & Schlegel, 1846	Synonym	7346	2009-01-01 00:00:00
Atheresthes	4928	unknown	Primary	7347	2009-01-01 00:00:00
atheresthes	4928	unknown	Synonym	7348	2009-01-01 00:00:00
Atheresthes stomias	4929	Jordan and Gilbert, 1880	Primary	7349	2009-01-01 00:00:00
reinhardtius-stomias	4929	unknown	Synonym	7350	2009-01-01 00:00:00
arrow-flounder	4929	unknown	Common	7351	2009-01-01 00:00:00
arrowtooth-flounder	4929	unknown	Common	7352	2009-01-01 00:00:00
atheresthes-stomias	4929	Jordan and Gilbert, 1880	Synonym	7353	2009-01-01 00:00:00
Psettichthys	4930	unknown	Primary	7354	2009-01-01 00:00:00
psettichthys	4930	unknown	Synonym	7355	2009-01-01 00:00:00
Psettichthys melanostictus	4931	Girard, 1854	Primary	7356	2009-01-01 00:00:00
sand-sole	4931	unknown	Common	7357	2009-01-01 00:00:00
psettichthys-melanostictus	4931	Girard, 1854	Synonym	7358	2009-01-01 00:00:00
Pseudopleuronectes	4932	Bleeker, 1862	Primary	7359	2009-01-01 00:00:00
pleuronectes	4932	unknown	Synonym	7360	2009-01-01 00:00:00
pseudopleuronectes	4932	Bleeker, 1862	Synonym	7361	2009-01-01 00:00:00
Pseudopleuronectes bilineatus	4933	nil	Primary	7362	2009-01-01 00:00:00
pleuronectes-bilineatus	4933	unknown	Synonym	7363	2009-01-01 00:00:00
pseudopleuronectes-bilineatus	4933	nil	Synonym	7364	2009-01-01 00:00:00
Pseudopleuronectes isolepis	4934	nil	Primary	7365	2009-01-01 00:00:00
butter-sole	4934	unknown	Common	7366	2009-01-01 00:00:00
pleuronectes-isolepis	4934	unknown	Synonym	7367	2009-01-01 00:00:00
pseudopleuronectes-isolepis	4934	nil	Synonym	7368	2009-01-01 00:00:00
Parophrys	4935	Gunther, 1854	Primary	7369	2009-01-01 00:00:00
parophrys	4935	Gunther, 1854	Synonym	7370	2009-01-01 00:00:00
Parophrys vetulus	4936	Girard, 1854	Primary	7371	2009-01-01 00:00:00
pseudopleuronectes-vetulus	4936	unknown	Synonym	7372	2009-01-01 00:00:00
english-sole	4936	unknown	Common	7373	2009-01-01 00:00:00
parophrys-vetulus	4936	Girard, 1854	Synonym	7374	2009-01-01 00:00:00
Microstomus	4937	unknown	Primary	7375	2009-01-01 00:00:00
Microstomus pacificus	4938	lockington, 1879	Primary	7376	2009-01-01 00:00:00
dover-sole	4938	unknown	Common	7377	2009-01-01 00:00:00
microstomus-pacificus	4938	lockington, 1879	Synonym	7378	2009-01-01 00:00:00
Embassichthys bathybius	4939	Gilbert, 1890	Primary	7379	2009-01-01 00:00:00
cynicoglossus-bathybius	4939	unknown	Synonym	7380	2009-01-01 00:00:00
deepsea-sole	4939	unknown	Common	7381	2009-01-01 00:00:00
Embassichthys bathybius	4939	Gilbert, 1890	Synonym	7382	2009-01-01 00:00:00
microstomus-bathybius	4939	Cooper J.A. and Chapleau F, 1998	Synonym	7383	2009-01-01 00:00:00
Microstomus bathybius	4939	Cooper J.A. and Chapleau F, 1998	Synonym	7384	2009-01-01 00:00:00
Lyopsetta	4940	unknown	Primary	7385	2009-01-01 00:00:00
lyopsetta	4940	unknown	Synonym	7386	2009-01-01 00:00:00
Lyopsetta exilis	4941	jordan and gilbert, 1880	Primary	7387	2009-01-01 00:00:00
slender-sole	4941	amer. fisheries society, 1980	Common	7388	2009-01-01 00:00:00
eopsetta-exilis	4941	unknown	Synonym	7389	2009-01-01 00:00:00
lyopsetta-exilis	4941	jordan and gilbert, 1880	Synonym	7390	2009-01-01 00:00:00
Hippoglossus	4942	unknown	Primary	7391	2009-01-01 00:00:00
hippoglossus	4942	unknown	Synonym	7392	2009-01-01 00:00:00
Hippoglossus stenolepis	4943	Schmidt, 1904	Primary	7393	2009-01-01 00:00:00
pacific-halibut	4943	unknown	Common	7394	2009-01-01 00:00:00
hippoglossus-stenolepis	4943	Schmidt, 1904	Synonym	7395	2009-01-01 00:00:00
Hippoglossoides	4944	unknown	Primary	7396	2009-01-01 00:00:00
hippoglossoides	4944	unknown	Synonym	7397	2009-01-01 00:00:00
Hippoglossoides elassodon	4945	unknown	Primary	7398	2009-01-01 00:00:00
flathead-sole	4945	unknown	Common	7399	2009-01-01 00:00:00
hippoglossoides-elassodon	4945	unknown	Synonym	7400	2009-01-01 00:00:00
Paralichthyidae	4946	unknown	Primary	7401	2009-01-01 00:00:00
large-tooth-flounder	4946	unknown	Common	7402	2009-01-01 00:00:00
paralichthyidae	4946	unknown	Synonym	7403	2009-01-01 00:00:00
Hippoglossina	4947	unknown	Primary	7404	2009-01-01 00:00:00
hippoglossina	4947	unknown	Synonym	7405	2009-01-01 00:00:00
Hippoglossina stomata	4948	Eigenmann & Eigenmann, 1890	Primary	7406	2009-01-01 00:00:00
bigmouth-sole	4948	unknown	Common	7407	2009-01-01 00:00:00
hippoglossina-stomata	4948	Eigenmann & Eigenmann, 1890	Synonym	7408	2009-01-01 00:00:00
Paralichthys	4949	unknown	Primary	7409	2009-01-01 00:00:00
paralichthys	4949	unknown	Synonym	7410	2009-01-01 00:00:00
Paralichthys californicus	4950	Ayres, 1859	Primary	7411	2009-01-01 00:00:00
california-halibut	4950	unknown	Common	7412	2009-01-01 00:00:00
paralichthys-californicus	4950	Ayres, 1859	Synonym	7413	2009-01-01 00:00:00
Xystreurys	4951	unknown	Primary	7414	2009-01-01 00:00:00
xystreurys	4951	unknown	Synonym	7415	2009-01-01 00:00:00
Xystreurys liolepis	4952	Jordan and Gilbert, 1880	Primary	7416	2009-01-01 00:00:00
fantail-sole	4952	unknown	Common	7417	2009-01-01 00:00:00
xystreurys-liolepis	4952	Jordan and Gilbert, 1880	Synonym	7418	2009-01-01 00:00:00
Bothidae	4953	unknown	Primary	7419	2009-01-01 00:00:00
lefteyed-flounder	4953	shiino, 1978	Common	7420	2009-01-01 00:00:00
bothidae	4953	unknown	Synonym	7421	2009-01-01 00:00:00
Citharichthys	4954	unknown	Primary	7422	2009-01-01 00:00:00
sanddab	4954	shiino, 1978	Common	7423	2009-01-01 00:00:00
citharichthys	4954	unknown	Synonym	7424	2009-01-01 00:00:00
Citharichthys xanthostigma	4955	Gilbert, 1890	Primary	7425	2009-01-01 00:00:00
longfin-sanddab	4955	unknown	Common	7426	2009-01-01 00:00:00
citharichthys-xanthostigma	4955	Gilbert, 1890	Synonym	7427	2009-01-01 00:00:00
Citharichthys sordidus	4956	girard, 1854	Primary	7428	2009-01-01 00:00:00
pacific-sanddab	4956	amer. fisheries society, 1980	Common	7429	2009-01-01 00:00:00
citharichthys-sordidus	4956	girard, 1854	Synonym	7430	2009-01-01 00:00:00
Cynoglossidae	4957	unknown	Primary	7431	2009-01-01 00:00:00
tonguefish	4957	unknown	Common	7432	2009-01-01 00:00:00
tongue-sole	4957	shiino, 1978	Common	7433	2009-01-01 00:00:00
cynoglossidae	4957	unknown	Synonym	7434	2009-01-01 00:00:00
Symphurus	4958	unknown	Primary	7435	2009-01-01 00:00:00
symphurus	4958	unknown	Synonym	7436	2009-01-01 00:00:00
Symphurus atricauda	4959	(jordan and gilbert)	Primary	7437	2009-01-01 00:00:00
california-tonguefish	4959	amer. fisheries society, 1980	Common	7438	2009-01-01 00:00:00
symphurus-atricauda	4959	(jordan and gilbert)	Synonym	7439	2009-01-01 00:00:00
Gasterosteiformes	4960	unknown	Primary	7440	2009-01-01 00:00:00
gasterosteiformes	4960	unknown	Synonym	7441	2009-01-01 00:00:00
Aulorhynchidae	4961	unknown	Primary	7442	2009-01-01 00:00:00
tubesnout	4961	unknown	Common	7443	2009-01-01 00:00:00
aulorhynchidae	4961	unknown	Synonym	7444	2009-01-01 00:00:00
Aulorhynchus	4962	unknown	Primary	7445	2009-01-01 00:00:00
aulorhynchus	4962	unknown	Synonym	7446	2009-01-01 00:00:00
Aulorhynchus flavidus	4963	Gill, 1861	Primary	7447	2009-01-01 00:00:00
aulorhynchus-flavidus	4963	Gill, 1861	Synonym	7448	2009-01-01 00:00:00
Syngnathiformes	4964	unknown	Primary	7449	2009-01-01 00:00:00
syngnathiformes	4964	unknown	Synonym	7450	2009-01-01 00:00:00
Aulostomidae	4965	unknown	Primary	7451	2009-01-01 00:00:00
trumpetfish	4965	unknown	Common	7452	2009-01-01 00:00:00
aulostomidae	4965	unknown	Synonym	7453	2009-01-01 00:00:00
Fistulariidae	4966	unknown	Primary	7454	2009-01-01 00:00:00
cornetfish	4966	unknown	Common	7455	2009-01-01 00:00:00
fistulariidae	4966	unknown	Synonym	7456	2009-01-01 00:00:00
Beryciformes	4967	unknown	Primary	7457	2009-01-01 00:00:00
beryciformes	4967	unknown	Synonym	7458	2009-01-01 00:00:00
Diretmidae	4968	unknown	Primary	7459	2009-01-01 00:00:00
spinyfin	4968	unknown	Common	7460	2009-01-01 00:00:00
diretmidae	4968	unknown	Synonym	7461	2009-01-01 00:00:00
Diretmoides	4969	unknown	Primary	7462	2009-01-01 00:00:00
diretmoides	4969	unknown	Synonym	7463	2009-01-01 00:00:00
Diretmoides pauciradiatus	4970	(Woods, 1973)	Primary	7464	2009-01-01 00:00:00
longwing-spinyfin	4970	unknown	Common	7465	2009-01-01 00:00:00
diretmoides-pauciradiatus	4970	(Woods, 1973)	Synonym	7466	2009-01-01 00:00:00
Holocentridae	4971	unknown	Primary	7467	2009-01-01 00:00:00
soldierfish	4971	unknown	Common	7468	2009-01-01 00:00:00
squirrelfish	4971	unknown	Common	7469	2009-01-01 00:00:00
holocentridae	4971	unknown	Synonym	7470	2009-01-01 00:00:00
Myripristinae	4972	unknown	Primary	7471	2009-01-01 00:00:00
myripristinae	4972	unknown	Synonym	7472	2009-01-01 00:00:00
Myripristis	4973	unknown	Primary	7473	2009-01-01 00:00:00
myripristis	4973	unknown	Synonym	7474	2009-01-01 00:00:00
Myripristis berndti	4974	unknown	Primary	7475	2009-01-01 00:00:00
big-scale-soldierfish	4974	unknown	Common	7476	2009-01-01 00:00:00
blotcheye-soldierfish	4974	unknown	Common	7477	2009-01-01 00:00:00
myripristis-berndti	4974	unknown	Synonym	7478	2009-01-01 00:00:00
Bercoidei	4975	unknown	Primary	7479	2009-01-01 00:00:00
bercoidei	4975	unknown	Synonym	7480	2009-01-01 00:00:00
Anoplogasteridae	4976	unknown	Primary	7481	2009-01-01 00:00:00
fangtooth-fish	4976	nelson, 1987	Common	7482	2009-01-01 00:00:00
anoplogasteridae	4976	unknown	Synonym	7483	2009-01-01 00:00:00
Anoplogaster	4977	unknown	Primary	7484	2009-01-01 00:00:00
anoplogaster	4977	unknown	Synonym	7485	2009-01-01 00:00:00
Anoplogaster cornuta	4978	(bellotti)	Primary	7486	2009-01-01 00:00:00
ogrefish	4978	unknown	Common	7487	2009-01-01 00:00:00
fangtooth	4978	shiino, 1978	Common	7488	2009-01-01 00:00:00
anoplogaster-cornuta	4978	(bellotti)	Synonym	7489	2009-01-01 00:00:00
Scorpaeniformes	4979	unknown	Primary	7490	2009-01-01 00:00:00
mail-cheeked-fish	4979	unknown	Common	7491	2009-01-01 00:00:00
scorpaeniformes	4979	unknown	Synonym	7492	2009-01-01 00:00:00
Zaniolepididae	4980	unknown	Primary	7493	2009-01-01 00:00:00
combfish	4980	shiino, 1978	Common	7494	2009-01-01 00:00:00
Zaniolepis	4981	unknown	Primary	7495	2009-01-01 00:00:00
zaniolepis	4981	unknown	Synonym	7496	2009-01-01 00:00:00
Zaniolepis frenata	4982	unknown	Primary	7497	2009-01-01 00:00:00
shortspine-combfish	4982	amer. fisheries society, 1980	Common	7498	2009-01-01 00:00:00
zaniolepis-frenata	4982	unknown	Synonym	7499	2009-01-01 00:00:00
Zaniolepis latipinnis	4983	unknown	Primary	7500	2009-01-01 00:00:00
longspine-combfish	4983	amer. fisheries society, 1980	Common	7501	2009-01-01 00:00:00
zaniolepis-latipinnis	4983	unknown	Synonym	7502	2009-01-01 00:00:00
Cottoidei	4984	unknown	Primary	7503	2009-01-01 00:00:00
sculpins	4984	shiino, 1978	Common	7504	2009-01-01 00:00:00
Rhamphocottidae	4985	unknown	Primary	7505	2009-01-01 00:00:00
rhamphocottidae	4985	unknown	Synonym	7506	2009-01-01 00:00:00
Rhamphocottus	4986	unknown	Primary	7507	2009-01-01 00:00:00
rhamphocottus	4986	unknown	Synonym	7508	2009-01-01 00:00:00
Rhamphocottus richardsoni	4987	G¸nther, 1874	Primary	7509	2009-01-01 00:00:00
grunt-sculpin	4987	unknown	Common	7510	2009-01-01 00:00:00
rhamphocottus-richardsoni	4987	G¸nther, 1874	Synonym	7511	2009-01-01 00:00:00
Cottidae	4988	moyle	Primary	7512	2009-01-01 00:00:00
icelidae	4988	unknown	Synonym	7513	2009-01-01 00:00:00
sculpin	4988	unknown	Common	7514	2009-01-01 00:00:00
cottidae	4988	moyle	Synonym	7515	2009-01-01 00:00:00
Zesticelus	4989	unknown	Primary	7516	2009-01-01 00:00:00
zesticelus	4989	unknown	Synonym	7517	2009-01-01 00:00:00
Zesticelus profundorum	4990	(Gilbert, 1896)	Primary	7518	2009-01-01 00:00:00
flabby-sculpin	4990	unknown	Common	7519	2009-01-01 00:00:00
zesticelus-profundorum	4990	(Gilbert, 1896)	Synonym	7520	2009-01-01 00:00:00
Icelinus	4991	unknown	Primary	7521	2009-01-01 00:00:00
icelinus	4991	unknown	Synonym	7522	2009-01-01 00:00:00
Icelinus tenuis	4992	gilbert	Primary	7523	2009-01-01 00:00:00
spotfin-sculpin	4992	amer. fisheries society, 1980	Common	7524	2009-01-01 00:00:00
icelinus-tenuis	4992	gilbert	Synonym	7525	2009-01-01 00:00:00
Icelinus quadriseriatus	4993	(Lockington, 1880)	Primary	7526	2009-01-01 00:00:00
yellowchin-sculpin	4993	unknown	Common	7527	2009-01-01 00:00:00
icelinus-quadriseriatus	4993	(Lockington, 1880)	Synonym	7528	2009-01-01 00:00:00
Icelinus burchami	4994	Evermann & Goldsborough, 1907	Primary	7529	2009-01-01 00:00:00
dusky-sculpin	4994	unknown	Common	7530	2009-01-01 00:00:00
icelinus-burchami	4994	Evermann & Goldsborough, 1907	Synonym	7531	2009-01-01 00:00:00
Icelinus fimbriatus	4995	Gilbert, 1890	Primary	7532	2009-01-01 00:00:00
fringed-sculpin	4995	unknown	Common	7533	2009-01-01 00:00:00
icelinus-fimbriatus	4995	Gilbert, 1890	Synonym	7534	2009-01-01 00:00:00
Icelinus filamentosus	4996	Gilbert, 1890	Primary	7535	2009-01-01 00:00:00
threadfin-sculpin	4996	unknown	Common	7536	2009-01-01 00:00:00
icelinus-filamentosus	4996	Gilbert, 1890	Synonym	7537	2009-01-01 00:00:00
Icelinus oculatus	4997	Gilbert, 1890	Primary	7538	2009-01-01 00:00:00
frogmouthed-sculpin	4997	unknown	Common	7539	2009-01-01 00:00:00
icelinus-oculatus	4997	Gilbert, 1890	Synonym	7540	2009-01-01 00:00:00
Enophrys	4998	unknown	Primary	7541	2009-01-01 00:00:00
enophrys	4998	unknown	Synonym	7542	2009-01-01 00:00:00
Enophrys bison	4999	(Girard, 1854)	Primary	7543	2009-01-01 00:00:00
buffalo-sculpin	4999	unknown	Common	7544	2009-01-01 00:00:00
enophrys-bison	4999	(Girard, 1854)	Synonym	7545	2009-01-01 00:00:00
Enophrys taurina	5000	Gilbert, 1914	Primary	7546	2009-01-01 00:00:00
bull-sculpin	5000	unknown	Common	7547	2009-01-01 00:00:00
enophrys-taurina	5000	Gilbert, 1914	Synonym	7548	2009-01-01 00:00:00
Hemilepidotus	5001	unknown	Primary	7549	2009-01-01 00:00:00
hemilepidotus	5001	unknown	Synonym	7550	2009-01-01 00:00:00
Hemilepidotus hemilepidotus	5002	(Tilesius, 1811)	Primary	7551	2009-01-01 00:00:00
red-irish-lord	5002	unknown	Common	7552	2009-01-01 00:00:00
hemilepidotus-hemilepidotus	5002	(Tilesius, 1811)	Synonym	7553	2009-01-01 00:00:00
Hemilepidotus spinosus	5003	Ayres, 1854	Primary	7554	2009-01-01 00:00:00
brown-irish-lord	5003	unknown	Common	7555	2009-01-01 00:00:00
hemilepidotus-spinosus	5003	Ayres, 1854	Synonym	7556	2009-01-01 00:00:00
Scorpaenichthys	5004	unknown	Primary	7557	2009-01-01 00:00:00
scorpaenichthys	5004	unknown	Synonym	7558	2009-01-01 00:00:00
Scorpaenichthys marmoratus	5005	(ayres, 1854)	Primary	7559	2009-01-01 00:00:00
cabezon	5005	amer. fisheries society, 1980	Common	7560	2009-01-01 00:00:00
scorpaenichthys-marmoratus	5005	(ayres, 1854)	Synonym	7561	2009-01-01 00:00:00
Chitonotus	5006	unknown	Primary	7562	2009-01-01 00:00:00
chitonotus	5006	unknown	Synonym	7563	2009-01-01 00:00:00
Chitonotus pugetensis	5007	(Steindachner, 1876)	Primary	7564	2009-01-01 00:00:00
roughback-sculpin	5007	unknown	Common	7565	2009-01-01 00:00:00
chitonotus-pugetensis	5007	(Steindachner, 1876)	Synonym	7566	2009-01-01 00:00:00
Paricelinus	5008	unknown	Primary	7567	2009-01-01 00:00:00
paricelinus	5008	unknown	Synonym	7568	2009-01-01 00:00:00
Paricelinus hopliticus	5009	Eigenmann & Eigenmann, 1889	Primary	7569	2009-01-01 00:00:00
thornback-sculpin	5009	unknown	Common	7570	2009-01-01 00:00:00
paricelinus-hopliticus	5009	Eigenmann & Eigenmann, 1889	Synonym	7571	2009-01-01 00:00:00
Radulinus	5010	unknown	Primary	7572	2009-01-01 00:00:00
radulinus	5010	unknown	Synonym	7573	2009-01-01 00:00:00
Radulinus asprellus	5011	Gilbert, 1890	Primary	7574	2009-01-01 00:00:00
slim-sculpin	5011	unknown	Common	7575	2009-01-01 00:00:00
radulinus-asprellus	5011	Gilbert, 1890	Synonym	7576	2009-01-01 00:00:00
Radulinus boleoides	5012	Gilbert, 1898	Primary	7577	2009-01-01 00:00:00
darter-sculpin	5012	unknown	Common	7578	2009-01-01 00:00:00
radulinus-boleoides	5012	Gilbert, 1898	Synonym	7579	2009-01-01 00:00:00
Leptocottus	5013	unknown	Primary	7580	2009-01-01 00:00:00
leptocottus	5013	unknown	Synonym	7581	2009-01-01 00:00:00
Leptocottus armatus	5014	Girard, 1854	Primary	7582	2009-01-01 00:00:00
staghorn-sculpin	5014	unknown	Common	7583	2009-01-01 00:00:00
leptocottus-armatus	5014	Girard, 1854	Synonym	7584	2009-01-01 00:00:00
Liparidae	5015	unknown	Primary	7585	2009-01-01 00:00:00
liparididae	5015	unknown	Synonym	7586	2009-01-01 00:00:00
liparinae	5015	unknown	Synonym	7587	2009-01-01 00:00:00
snailfish	5015	unknown	Common	7588	2009-01-01 00:00:00
liparidae	5015	unknown	Synonym	7589	2009-01-01 00:00:00
Rhinoliparis	5016	unknown	Primary	7590	2009-01-01 00:00:00
rhinoliparis	5016	unknown	Synonym	7591	2009-01-01 00:00:00
Rhinoliparis barbulifer	5017	Gilbert, 1896	Primary	7592	2009-01-01 00:00:00
longnose-snailfish	5017	unknown	Common	7593	2009-01-01 00:00:00
rhinoliparis-barbulifer	5017	Gilbert, 1896	Synonym	7594	2009-01-01 00:00:00
Rhinoliparis attenuatus	5018	Burke, 1912	Primary	7595	2009-01-01 00:00:00
slim-snailfish	5018	unknown	Common	7596	2009-01-01 00:00:00
rhinoliparis-attenuatus	5018	Burke, 1912	Synonym	7597	2009-01-01 00:00:00
Acantholiparis	5019	unknown	Primary	7598	2009-01-01 00:00:00
acantholiparis	5019	unknown	Synonym	7599	2009-01-01 00:00:00
Acantholiparis caecus	5020	Grinols, 1969	Primary	7600	2009-01-01 00:00:00
acantholiparis-caecus	5020	Grinols, 1969	Synonym	7601	2009-01-01 00:00:00
Acantholiparis opercularis	5021	Gilbert & Burke, 1912	Primary	7602	2009-01-01 00:00:00
spiny-snailfish	5021	unknown	Common	7603	2009-01-01 00:00:00
acantholiparis-opercularis	5021	Gilbert & Burke, 1912	Synonym	7604	2009-01-01 00:00:00
Elassodiscus	5022	Gilbert & Burke, 1912	Primary	7605	2009-01-01 00:00:00
elassodiscus	5022	Gilbert & Burke, 1912	Synonym	7606	2009-01-01 00:00:00
Elassodiscus caudatus	5023	(Gilbert, 1915)	Primary	7607	2009-01-01 00:00:00
humpback-snailfish	5023	unknown	Common	7608	2009-01-01 00:00:00
elassodiscus-caudatus	5023	(Gilbert, 1915)	Synonym	7609	2009-01-01 00:00:00
Careproctus	5024	unknown	Primary	7610	2009-01-01 00:00:00
careproctus	5024	unknown	Synonym	7611	2009-01-01 00:00:00
Careproctus cypselurus	5025	Jordan & Gilbert, 1898	Primary	7612	2009-01-01 00:00:00
careproctus-cypselurus	5025	Jordan & Gilbert, 1898	Synonym	7613	2009-01-01 00:00:00
Careproctus rastrinus	5026	Gilbert & Burke, 1912	Primary	7614	2009-01-01 00:00:00
salmon-snailfish	5026	unknown	Common	7615	2009-01-01 00:00:00
careproctus-rastrinus	5026	Gilbert & Burke, 1912	Synonym	7616	2009-01-01 00:00:00
Careproctus longifilis	5027	Garman, 1892	Primary	7617	2009-01-01 00:00:00
threadfin-snailfish	5027	unknown	Common	7618	2009-01-01 00:00:00
careproctus-longifilis	5027	Garman, 1892	Synonym	7619	2009-01-01 00:00:00
Careproctus ovigerus	5028	Gilbert, 1896	Primary	7620	2009-01-01 00:00:00
abyssal-snailfish	5028	unknown	Common	7621	2009-01-01 00:00:00
careproctus-ovigerum	5028	Gilbert, 1896	Synonym	7622	2009-01-01 00:00:00
Careproctus ovigerum	5028	Gilbert, 1896	Synonym	7623	2009-01-01 00:00:00
Careproctus filamentosus	5029	Stein, 1978	Primary	7624	2009-01-01 00:00:00
careproctus-filamentosus	5029	Stein, 1978	Synonym	7625	2009-01-01 00:00:00
Careproctus melanurus	5030	gilbert	Primary	7626	2009-01-01 00:00:00
blacktail-snailfish	5030	amer. fisheries society, 1980	Common	7627	2009-01-01 00:00:00
careproctus-melanurus	5030	gilbert	Synonym	7628	2009-01-01 00:00:00
Careproctus gilberti	5031	Burke, 1912	Primary	7629	2009-01-01 00:00:00
smalldisk-snailfish	5031	unknown	Common	7630	2009-01-01 00:00:00
careproctus-gilberti	5031	Burke, 1912	Synonym	7631	2009-01-01 00:00:00
Careproctus microstomus	5032	Stein, 1978	Primary	7632	2009-01-01 00:00:00
careproctus microstomus	5032	Stein, 1978	Synonym	7633	2009-01-01 00:00:00
Psednos	5033	Barnard, 1927	Primary	7634	2009-01-01 00:00:00
psednos	5033	Barnard, 1927	Synonym	7635	2009-01-01 00:00:00
Psednos pallidus	5034	Chernova & Stein, 2002	Primary	7636	2009-01-01 00:00:00
psednos-pallidus	5034	Chernova & Stein, 2002	Synonym	7637	2009-01-01 00:00:00
Lipariscus	5035	Gilbert, 1915	Primary	7638	2009-01-01 00:00:00
lipariscus	5035	Gilbert, 1915	Synonym	7639	2009-01-01 00:00:00
Lipariscus nanus	5036	Gilbert, 1915	Primary	7640	2009-01-01 00:00:00
lipariscus-nanus	5036	Gilbert, 1915	Synonym	7641	2009-01-01 00:00:00
Paraliparis	5037	unknown	Primary	7642	2009-01-01 00:00:00
paraliparis	5037	unknown	Synonym	7643	2009-01-01 00:00:00
Paraliparis rosaceus	5038	Gilbert, 1890	Primary	7644	2009-01-01 00:00:00
pink-snailfish	5038	unknown	Common	7645	2009-01-01 00:00:00
paraliparis-rosaceus	5038	Gilbert, 1890	Synonym	7646	2009-01-01 00:00:00
Paraliparis dactylosus	5039	Gilbert, 1896	Primary	7647	2009-01-01 00:00:00
red-snailfish	5039	unknown	Common	7648	2009-01-01 00:00:00
paraliparis-dactylosus	5039	Gilbert, 1896	Synonym	7649	2009-01-01 00:00:00
Paraliparis albescens	5040	Gilbert, 1915	Primary	7650	2009-01-01 00:00:00
phantom-snailfish	5040	unknown	Common	7651	2009-01-01 00:00:00
paraliparis-albescens	5040	Gilbert, 1915	Synonym	7652	2009-01-01 00:00:00
Paraliparis mento	5041	Gilbert, 1892	Primary	7653	2009-01-01 00:00:00
bulldog-snailfish	5041	unknown	Common	7654	2009-01-01 00:00:00
paraliparis-mento	5041	Gilbert, 1892	Synonym	7655	2009-01-01 00:00:00
Paraliparis latifrons	5042	Garman, 1899	Primary	7656	2009-01-01 00:00:00
bigpored-snailfish	5042	unknown	Common	7657	2009-01-01 00:00:00
paraliparis-latifrons	5042	Garman, 1899	Synonym	7658	2009-01-01 00:00:00
Paraliparis ulochir	5043	Gilbert, 1896	Primary	7659	2009-01-01 00:00:00
broadfin-snailfish	5043	unknown	Common	7660	2009-01-01 00:00:00
paraliparis-ulochir	5043	Gilbert, 1896	Synonym	7661	2009-01-01 00:00:00
Paraliparis deani	5044	Burke, 1912	Primary	7662	2009-01-01 00:00:00
prickly-snailfish	5044	unknown	Common	7663	2009-01-01 00:00:00
paraliparis-deani	5044	Burke, 1912	Synonym	7664	2009-01-01 00:00:00
Paraliparis cephalus	5045	Gilbert, 1892	Primary	7665	2009-01-01 00:00:00
swellhead-snailfish	5045	unknown	Common	7666	2009-01-01 00:00:00
paraliparis-cephalus	5045	Gilbert, 1892	Synonym	7667	2009-01-01 00:00:00
Paraliparis megalopus	5046	Stein, 1978	Primary	7668	2009-01-01 00:00:00
paraliparis-megalopus	5046	Stein, 1978	Synonym	7669	2009-01-01 00:00:00
Nectoliparis	5047	Gilbert & Burke 1912	Primary	7670	2009-01-01 00:00:00
nectoliparis	5047	Gilbert & Burke 1912	Synonym	7671	2009-01-01 00:00:00
Nectoliparis pelagicus	5048	Gilbert & Burke 1912	Primary	7672	2009-01-01 00:00:00
tadpole-snailfish	5048	amer. fisheries society, 1980	Common	7673	2009-01-01 00:00:00
nectoliparis-pelagicus	5048	Gilbert & Burke 1912	Synonym	7674	2009-01-01 00:00:00
Liparis	5049	Scopoli, 1777	Primary	7675	2009-01-01 00:00:00
liparis	5049	Scopoli, 1777	Synonym	7676	2009-01-01 00:00:00
Liparis pulchellus	5050	Ayres, 1855	Primary	7677	2009-01-01 00:00:00
showy-snailfish	5050	unknown	Common	7678	2009-01-01 00:00:00
liparis-pulchellus	5050	Ayres, 1855	Synonym	7679	2009-01-01 00:00:00
Liparis fucensis	5051	Gilbert, 1896	Primary	7680	2009-01-01 00:00:00
slipskin-snailfish	5051	unknown	Common	7681	2009-01-01 00:00:00
liparis-fucensis	5051	Gilbert, 1896	Synonym	7682	2009-01-01 00:00:00
Osteodiscus cascadiae	5052	unknown	Primary	7683	2009-01-01 00:00:00
Osteodiscus	5053	unknown	Primary	7684	2009-01-01 00:00:00
Agonidae	5054	unknown	Primary	7685	2009-01-01 00:00:00
sea-poacher	5054	unknown	Common	7686	2009-01-01 00:00:00
poacher	5054	unknown	Common	7687	2009-01-01 00:00:00
alligatorfish	5054	shiino, 1978	Common	7688	2009-01-01 00:00:00
agonidae	5054	unknown	Synonym	7689	2009-01-01 00:00:00
Odontopyxis	5055	unknown	Primary	7690	2009-01-01 00:00:00
odontopyxis	5055	unknown	Synonym	7691	2009-01-01 00:00:00
Odontopyxis trispinosa	5056	lockington	Primary	7692	2009-01-01 00:00:00
pygmy-poacher	5056	amer. fisheries society, 1980	Common	7693	2009-01-01 00:00:00
odontopyxis-trispinosa	5056	lockington	Synonym	7694	2009-01-01 00:00:00
Bathyagonus	5057	unknown	Primary	7695	2009-01-01 00:00:00
bathyagonus	5057	unknown	Synonym	7696	2009-01-01 00:00:00
Bathyagonus pentacanthus	5058	(Gilbert, 1890)	Primary	7697	2009-01-01 00:00:00
bigeye-poacher	5058	unknown	Common	7698	2009-01-01 00:00:00
bigeye-starsnout-poacher	5058	unknown	Common	7699	2009-01-01 00:00:00
bathyagonus-pentacanthus	5058	(Gilbert, 1890)	Synonym	7700	2009-01-01 00:00:00
Bathyagonus infraspinatus	5059	(Gilbert, 1904)	Primary	7701	2009-01-01 00:00:00
spinycheek-starsnout-poacher	5059	unknown	Common	7702	2009-01-01 00:00:00
bathyagonus-infraspinatus	5059	(Gilbert, 1904)	Synonym	7703	2009-01-01 00:00:00
Bathyagonus alascanus	5060	(Gilbert, 1896)	Primary	7704	2009-01-01 00:00:00
gray-starsnout	5060	unknown	Common	7705	2009-01-01 00:00:00
gray-starnose-poacher	5060	unknown	Common	7706	2009-01-01 00:00:00
bathyagonus-alascanus	5060	(Gilbert, 1896)	Synonym	7707	2009-01-01 00:00:00
Bathyagonus nigripinnis	5061	Gilbert, 1890	Primary	7708	2009-01-01 00:00:00
blackfin-poacher	5061	unknown	Common	7709	2009-01-01 00:00:00
blackfin-starsnout-poacher	5061	unknown	Common	7710	2009-01-01 00:00:00
bathyagonus-nigripinnis	5061	Gilbert, 1890	Synonym	7711	2009-01-01 00:00:00
Xeneretmus	5062	unknown	Primary	7712	2009-01-01 00:00:00
xeneretmus	5062	unknown	Synonym	7713	2009-01-01 00:00:00
Xeneretmus leiops	5063	Gilbert, 1915	Primary	7714	2009-01-01 00:00:00
smootheye-poacher	5063	unknown	Common	7715	2009-01-01 00:00:00
xeneretmus-leiops	5063	Gilbert, 1915	Synonym	7716	2009-01-01 00:00:00
Xeneretmus latifrons	5064	(Gilbert, 1890)	Primary	7717	2009-01-01 00:00:00
blacktip-poacher	5064	unknown	Common	7718	2009-01-01 00:00:00
xeneretmus-latifrons	5064	(Gilbert, 1890)	Synonym	7719	2009-01-01 00:00:00
Xeneretmus triacanthus	5065	(Gilbert, 1890)	Primary	7720	2009-01-01 00:00:00
bluespotted-poacher	5065	unknown	Common	7721	2009-01-01 00:00:00
xeneretmus-triacanthus	5065	(Gilbert, 1890)	Synonym	7722	2009-01-01 00:00:00
Occella	5066	unknown	Primary	7723	2009-01-01 00:00:00
occella	5066	unknown	Synonym	7724	2009-01-01 00:00:00
Occella verrucosa	5067	(Lockington, 1880)	Primary	7725	2009-01-01 00:00:00
warty-poacher	5067	unknown	Common	7726	2009-01-01 00:00:00
occella-verrucosa	5067	(Lockington, 1880)	Synonym	7727	2009-01-01 00:00:00
Anoplagonus	5068	unknown	Primary	7728	2009-01-01 00:00:00
anoplagonus	5068	unknown	Synonym	7729	2009-01-01 00:00:00
Anoplagonus inermis	5069	(G¸nther, 1860)	Primary	7730	2009-01-01 00:00:00
smooth-alligatorfish	5069	unknown	Common	7731	2009-01-01 00:00:00
anoplagonus-inermis	5069	(G¸nther, 1860)	Synonym	7732	2009-01-01 00:00:00
Agonopsis	5070	unknown	Primary	7733	2009-01-01 00:00:00
agonopsis	5070	unknown	Synonym	7734	2009-01-01 00:00:00
Agonopsis sterletus	5071	(Gilbert, 1898)	Primary	7735	2009-01-01 00:00:00
southern-spearnose-poacher	5071	unknown	Common	7736	2009-01-01 00:00:00
agonopsis-sterletus	5071	(Gilbert, 1898)	Synonym	7737	2009-01-01 00:00:00
Agonopsis vulsa	5072	(Jordan & Gilbert, 1880)	Primary	7738	2009-01-01 00:00:00
northern-spearnose-poacher	5072	unknown	Common	7739	2009-01-01 00:00:00
agonopsis-vulsa	5072	(Jordan & Gilbert, 1880)	Synonym	7740	2009-01-01 00:00:00
Psychrolutidae	5073	unknown	Primary	7741	2009-01-01 00:00:00
fathead	5073	unknown	Common	7742	2009-01-01 00:00:00
psychrolutidae	5073	unknown	Synonym	7743	2009-01-01 00:00:00
Psychrolutes	5074	unknown	Primary	7744	2009-01-01 00:00:00
psychrolutes	5074	unknown	Synonym	7745	2009-01-01 00:00:00
Psychrolutes phrictus	5075	unknown	Primary	7746	2009-01-01 00:00:00
blob-sculpin	5075	unknown	Common	7747	2009-01-01 00:00:00
psychrolutes-phrictus	5075	unknown	Synonym	7748	2009-01-01 00:00:00
Hemitripteridae	5076	unknown	Primary	7749	2009-01-01 00:00:00
hemitripteridae	5076	unknown	Synonym	7750	2009-01-01 00:00:00
Nautichthys	5077	unknown	Primary	7751	2009-01-01 00:00:00
nautichthys	5077	unknown	Synonym	7752	2009-01-01 00:00:00
Nautichthys oculofasciatus	5078	(Girard, 1858)	Primary	7753	2009-01-01 00:00:00
sailfin-sculpin	5078	unknown	Common	7754	2009-01-01 00:00:00
nautichthys-oculofasciatus	5078	(Girard, 1858)	Synonym	7755	2009-01-01 00:00:00
Hemitripterus	5079	unknown	Primary	7756	2009-01-01 00:00:00
hemitripterus	5079	unknown	Synonym	7757	2009-01-01 00:00:00
Hemitripterus bolini	5080	(Myers, 1934)	Primary	7758	2009-01-01 00:00:00
bigmouth-sculpin	5080	unknown	Common	7759	2009-01-01 00:00:00
hemitripterus-bolini	5080	(Myers, 1934)	Synonym	7760	2009-01-01 00:00:00
Cyclopteridae	5081	unknown	Primary	7761	2009-01-01 00:00:00
cyclopteridae	5081	unknown	Synonym	7762	2009-01-01 00:00:00
Cyclopterinae	5082	unknown	Primary	7763	2009-01-01 00:00:00
lumpfish	5082	unknown	Common	7764	2009-01-01 00:00:00
lumpsucker	5082	unknown	Common	7765	2009-01-01 00:00:00
cyclopterinae	5082	unknown	Synonym	7766	2009-01-01 00:00:00
Dactylopteroidei	5083	unknown	Primary	7767	2009-01-01 00:00:00
Scorpaenoidei	5084	unknown	Primary	7768	2009-01-01 00:00:00
Scorpaenidae	5085	unknown	Primary	7769	2009-01-01 00:00:00
sebastidae	5085	unknown	Synonym	7770	2009-01-01 00:00:00
scorpionfish	5085	unknown	Common	7771	2009-01-01 00:00:00
goblinfish	5085	unknown	Common	7772	2009-01-01 00:00:00
firefish	5085	shiino, 1978	Common	7773	2009-01-01 00:00:00
scorpaenidae	5085	unknown	Synonym	7774	2009-01-01 00:00:00
Sebastes	5086	unknown	Primary	7775	2009-01-01 00:00:00
rosefish	5086	unknown	Common	7776	2009-01-01 00:00:00
rockfish	5086	unknown	Common	7777	2009-01-01 00:00:00
rockcod	5086	shiino, 1978	Common	7778	2009-01-01 00:00:00
sebastes	5086	unknown	Synonym	7779	2009-01-01 00:00:00
Sebastes diploproa	5087	(Gilbert, 1890)	Primary	7780	2009-01-01 00:00:00
splitnose-rockfish	5087	amer. fisheries society, 1980	Common	7781	2009-01-01 00:00:00
Sebastes flavidus	5088	(Ayres, 1862)	Primary	7782	2009-01-01 00:00:00
yellowtail-rockfish	5088	unknown	Common	7783	2009-01-01 00:00:00
sebastes-flavidus	5088	(Ayres, 1862)	Synonym	7784	2009-01-01 00:00:00
Sebastes mystinus	5089	(jordan and gilbert)	Primary	7785	2009-01-01 00:00:00
blue-rockfish	5089	amer. fisheries society, 1980	Common	7786	2009-01-01 00:00:00
sebastes-mystinus	5089	(jordan and gilbert)	Synonym	7787	2009-01-01 00:00:00
Sebastes borealis	5090	Barsukov, 1970	Primary	7788	2009-01-01 00:00:00
shortraker-rockfish	5090	unknown	Common	7789	2009-01-01 00:00:00
sebastes-borealis	5090	Barsukov, 1970	Synonym	7790	2009-01-01 00:00:00
Sebastes proriger	5091	(Jordan & Gilbert, 1880)	Primary	7791	2009-01-01 00:00:00
redstripe-rockfish	5091	unknown	Common	7792	2009-01-01 00:00:00
sebastes-proriger	5091	(Jordan & Gilbert, 1880)	Synonym	7793	2009-01-01 00:00:00
Sebastes emphaeus	5092	(Starks, 1911)	Primary	7794	2009-01-01 00:00:00
puget-sound-rockfish	5092	unknown	Common	7795	2009-01-01 00:00:00
sebastes-emphaeus	5092	(Starks, 1911)	Synonym	7796	2009-01-01 00:00:00
Sebastes goodei	5093	(eigenmann & eigenmann)	Primary	7797	2009-01-01 00:00:00
chilipepper	5093	amer. fisheries society, 1980	Common	7798	2009-01-01 00:00:00
sebastes-goodei	5093	(eigenmann & eigenmann)	Synonym	7799	2009-01-01 00:00:00
Sebastes melanops	5094	Girard, 1856	Primary	7800	2009-01-01 00:00:00
black-rockfish	5094	unknown	Common	7801	2009-01-01 00:00:00
sebastes-melanops	5094	Girard, 1856	Synonym	7802	2009-01-01 00:00:00
Sebastes pinniger	5095	(Gill, 1864)	Primary	7803	2009-01-01 00:00:00
canary-rockfish	5095	unknown	Common	7804	2009-01-01 00:00:00
sebastes-pinniger	5095	(Gill, 1864)	Synonym	7805	2009-01-01 00:00:00
Sebastes gilli	5096	(Eigenmann, 1891)	Primary	7806	2009-01-01 00:00:00
bronzespotted-rockfish	5096	unknown	Common	7807	2009-01-01 00:00:00
sebastes-gilli	5096	(Eigenmann, 1891)	Synonym	7808	2009-01-01 00:00:00
Sebastes nebulosus	5097	ayres	Primary	7809	2009-01-01 00:00:00
china-rockfish	5097	amer. fisheries society, 1980	Common	7810	2009-01-01 00:00:00
sebastes-nebulosus	5097	ayres	Synonym	7811	2009-01-01 00:00:00
Sebastes alutus	5098	(gilbert)	Primary	7812	2009-01-01 00:00:00
pacific-ocean-perch	5098	amer. fisheries society, 1980	Common	7813	2009-01-01 00:00:00
Sebastes ruberrimus	5099	(cramer)	Primary	7814	2009-01-01 00:00:00
yelloweye-rockfish	5099	amer. fisheries society, 1980	Common	7815	2009-01-01 00:00:00
rasphead-rockfish	5099	shiino, 1978	Common	7816	2009-01-01 00:00:00
sebastes-ruberrimus	5099	(cramer)	Synonym	7817	2009-01-01 00:00:00
Sebastes entomelas	5100	(Jordan & Gilbert, 1880)	Primary	7818	2009-01-01 00:00:00
widow-rockfish	5100	unknown	Common	7819	2009-01-01 00:00:00
sebastes-entomelas	5100	(Jordan & Gilbert, 1880)	Synonym	7820	2009-01-01 00:00:00
Sebastes carnatus	5101	(Jordan & Gilbert, 1880)	Primary	7821	2009-01-01 00:00:00
gopher-rockfish	5101	unknown	Common	7822	2009-01-01 00:00:00
sebastes-carnatus	5101	(Jordan & Gilbert, 1880)	Synonym	7823	2009-01-01 00:00:00
Sebastes serriceps	5102	(Jordan & Gilbert, 1880)	Primary	7824	2009-01-01 00:00:00
treefish	5102	unknown	Common	7825	2009-01-01 00:00:00
sebastes-serriceps	5102	(Jordan & Gilbert, 1880)	Synonym	7826	2009-01-01 00:00:00
Sebastes eos	5103	(Eigenmann & Eigenmann, 1890)	Primary	7827	2009-01-01 00:00:00
pink-rockfish	5103	unknown	Common	7828	2009-01-01 00:00:00
sebastes-eos	5103	(Eigenmann & Eigenmann, 1890)	Synonym	7829	2009-01-01 00:00:00
Sebastes dallii	5104	eigenmann and beeson	Primary	7830	2009-01-01 00:00:00
calico-rockfish	5104	unknown	Common	7831	2009-01-01 00:00:00
sebastes-dallii	5104	eigenmann and beeson	Synonym	7832	2009-01-01 00:00:00
Sebastes serranoides	5105	(eigenmann and eigenmann)	Primary	7833	2009-01-01 00:00:00
olive-rockfish	5105	amer. fisheries society, 1980	Common	7834	2009-01-01 00:00:00
sebastes-serranoides	5105	(eigenmann and eigenmann)	Synonym	7835	2009-01-01 00:00:00
Sebastes paucispinis	5106	ayres	Primary	7836	2009-01-01 00:00:00
bocaccio	5106	amer. fisheries society, 1980	Common	7837	2009-01-01 00:00:00
sebastes-paucispinis	5106	ayres	Synonym	7838	2009-01-01 00:00:00
Sebastes saxicola	5107	(gilbert)	Primary	7839	2009-01-01 00:00:00
stripetail-rockfish	5107	amer. fisheries society, 1980	Common	7840	2009-01-01 00:00:00
sebastes-saxicola	5107	(gilbert)	Synonym	7841	2009-01-01 00:00:00
Sebastes aleutianus	5108	(Jordan & Evermann, 1898)	Primary	7842	2009-01-01 00:00:00
rougheye-rockfish	5108	unknown	Common	7843	2009-01-01 00:00:00
Sebastes melanostictus	5108		Common	7844	2009-01-01 00:00:00
Sebastes miniatus	5109	(Jordan & Gilbert, 1880)	Primary	7845	2009-01-01 00:00:00
vermillion-rockfish	5109	unknown	Common	7846	2009-01-01 00:00:00
sebastes-miniatus	5109	(Jordan & Gilbert, 1880)	Synonym	7847	2009-01-01 00:00:00
Sebastes elongatus	5110	Ayres, 1859	Primary	7848	2009-01-01 00:00:00
greenstriped-rockfish	5110	unknown	Common	7849	2009-01-01 00:00:00
sebastes-elongatus	5110	Ayres, 1859	Synonym	7850	2009-01-01 00:00:00
Sebastes ensifer	5111	(Starks, 1911)	Primary	7851	2009-01-01 00:00:00
swordspine-rockfish	5111	unknown	Common	7852	2009-01-01 00:00:00
sebastes-ensifer	5111	(Starks, 1911)	Synonym	7853	2009-01-01 00:00:00
Sebastes rosenblatti	5112	Chen, 1971	Primary	7854	2009-01-01 00:00:00
greenblotched-rockfish	5112	unknown	Common	7855	2009-01-01 00:00:00
sebastes-rosenblatti	5112	Chen, 1971	Synonym	7856	2009-01-01 00:00:00
Sebastes maliger	5113	(Jordan & Gilbert, 1880)	Primary	7857	2009-01-01 00:00:00
quillback-rockfish	5113	unknown	Common	7858	2009-01-01 00:00:00
sebastes-maliger	5113	(Jordan & Gilbert, 1880)	Synonym	7859	2009-01-01 00:00:00
Sebastes caurinus	5114	Richardson, 1844	Primary	7860	2009-01-01 00:00:00
copper-rockfish	5114	unknown	Common	7861	2009-01-01 00:00:00
sebastes-caurinus	5114	Richardson, 1844	Synonym	7862	2009-01-01 00:00:00
Sebastes rubrivinctus	5115	(jordan gilbert)	Primary	7863	2009-01-01 00:00:00
flag-rockfish	5115	amer. fisheries society, 1980	Common	7864	2009-01-01 00:00:00
sebastes-rubrivinctus	5115	(jordan gilbert)	Synonym	7865	2009-01-01 00:00:00
Sebastes macdonaldi	5116	(Eigenmann & Beeson, 1893)	Primary	7866	2009-01-01 00:00:00
mexican-rockfish	5116	unknown	Common	7867	2009-01-01 00:00:00
sebastes-macdonaldi	5116	(Eigenmann & Beeson, 1893)	Synonym	7868	2009-01-01 00:00:00
Sebastes levis	5117	(eigenmann & eigenmann, 1889)	Primary	7869	2009-01-01 00:00:00
cowcod	5117	amer. fisheries society, 1980	Common	7870	2009-01-01 00:00:00
sebastes-levis	5117	(eigenmann & eigenmann, 1889)	Synonym	7871	2009-01-01 00:00:00
Sebastes aurora	5118	(gilbert)	Primary	7872	2009-01-01 00:00:00
aurora-rockfish	5118	amer. fisheries society, 1980	Common	7873	2009-01-01 00:00:00
sebastes-aurora	5118	(gilbert)	Synonym	7874	2009-01-01 00:00:00
Sebastes ruber	5119	unknown	Primary	7875	2009-01-01 00:00:00
sebastes-ruber	5119	unknown	Synonym	7876	2009-01-01 00:00:00
Sebastes nigrocinctus	5120	Ayres, 1859	Primary	7877	2009-01-01 00:00:00
tiger-rockfish	5120	unknown	Common	7878	2009-01-01 00:00:00
sebastes-nigrocinctus	5120	Ayres, 1859	Synonym	7879	2009-01-01 00:00:00
Sebastes rufus	5121	(eigenmann and eigenmann)	Primary	7880	2009-01-01 00:00:00
bank-rockfish	5121	amer. fisheries society, 1980	Common	7881	2009-01-01 00:00:00
sebastes-rufus	5121	(eigenmann and eigenmann)	Synonym	7882	2009-01-01 00:00:00
Sebastes hopkinsi	5122	(Cramer, 1895)	Primary	7883	2009-01-01 00:00:00
squarespot-rockfish	5122	unknown	Common	7884	2009-01-01 00:00:00
sebastes-hopkinsi	5122	(Cramer, 1895)	Synonym	7885	2009-01-01 00:00:00
Sebastes zacentrus	5123	(Gilbert, 1890)	Primary	7886	2009-01-01 00:00:00
sharpchin-rockfish	5123	unknown	Common	7887	2009-01-01 00:00:00
sebastes-zacentrus	5123	(Gilbert, 1890)	Synonym	7888	2009-01-01 00:00:00
Sebastes ovalis	5124	(Ayres, 1863)	Primary	7889	2009-01-01 00:00:00
speckled-rockfish	5124	unknown	Common	7890	2009-01-01 00:00:00
sebastes-ovalis	5124	(Ayres, 1863)	Synonym	7891	2009-01-01 00:00:00
Sebastes phillipsi	5125	(Fitch, 1964)	Primary	7892	2009-01-01 00:00:00
chameleon-rockfish	5125	unknown	Common	7893	2009-01-01 00:00:00
sebastes-phillipsi	5125	(Fitch, 1964)	Synonym	7894	2009-01-01 00:00:00
Sebastomus complex	5126	Chen, 1971	Primary	7895	2009-01-01 00:00:00
sebastomus-complex	5126	Chen, 1971	Synonym	7896	2009-01-01 00:00:00
Sebastes rosaceus	5127	girard	Primary	7897	2009-01-01 00:00:00
rosy-rockfish	5127	amer. fisheries society, 1980	Common	7898	2009-01-01 00:00:00
sebastes-rosaceus	5127	girard	Synonym	7899	2009-01-01 00:00:00
Sebastes constellatus	5128	(Jordan & Gilbert, 1880)	Primary	7900	2009-01-01 00:00:00
starry-rockfish	5128	unknown	Common	7901	2009-01-01 00:00:00
sebastes-constellatus	5128	(Jordan & Gilbert, 1880)	Synonym	7902	2009-01-01 00:00:00
Sebastes simulator	5129	Chen, 1971	Primary	7903	2009-01-01 00:00:00
pinkrose-rockfish	5129	unknown	Common	7904	2009-01-01 00:00:00
sebastes-simulator	5129	Chen, 1971	Synonym	7905	2009-01-01 00:00:00
Sebastes chlorostictus	5130	(Jordan & Gilbert, 1880)	Primary	7906	2009-01-01 00:00:00
greenspotted-rockfish	5130	unknown	Common	7907	2009-01-01 00:00:00
sebastes-chlorostictus	5130	(Jordan & Gilbert, 1880)	Synonym	7908	2009-01-01 00:00:00
Sebastes helvomaculatus	5131	ayres	Primary	7909	2009-01-01 00:00:00
rosethorn-rockfish	5131	amer. fisheries society, 1980	Common	7910	2009-01-01 00:00:00
sebastes-helvomaculatus	5131	ayres	Synonym	7911	2009-01-01 00:00:00
Sebastes wilsoni	5132	(Gilbert, 1915)	Primary	7912	2009-01-01 00:00:00
pygmy-rockfish	5132	unknown	Common	7913	2009-01-01 00:00:00
sebastes-wilsoni	5132	(Gilbert, 1915)	Synonym	7914	2009-01-01 00:00:00
Sebastes brevispinis	5133	Barsukov, 1970	Primary	7915	2009-01-01 00:00:00
silvergray-rockfish	5133	unknown	Common	7916	2009-01-01 00:00:00
sebastes-brevispinis	5133	Barsukov, 1970	Synonym	7917	2009-01-01 00:00:00
Sebastes melanostomus	5134	(eigenmann and eigenmann)	Primary	7918	2009-01-01 00:00:00
blackgill-rockfish	5134	amer. fisheries society, 1980	Common	7919	2009-01-01 00:00:00
sebastes-melanostomus	5134	(eigenmann and eigenmann)	Synonym	7920	2009-01-01 00:00:00
Sebastes jordani	5135	unknown	Primary	7921	2009-01-01 00:00:00
shortbelly-rockfish	5135	unknown	Common	7922	2009-01-01 00:00:00
sebastes-jordani	5135	unknown	Synonym	7923	2009-01-01 00:00:00
Sebastes semicinctus	5136	(Gilbert, 1897)	Primary	7924	2009-01-01 00:00:00
halfbanded-rockfish	5136	unknown	Common	7925	2009-01-01 00:00:00
sebastes-semicinctus	5136	(Gilbert, 1897)	Synonym	7926	2009-01-01 00:00:00
Sebastes umbrosus	5137	(Jordan & Gilbert, 1882)	Primary	7927	2009-01-01 00:00:00
honeycomb-rockfish	5137	unknown	Common	7928	2009-01-01 00:00:00
sebastes-umbrosus	5137	(Jordan & Gilbert, 1882)	Synonym	7929	2009-01-01 00:00:00
Sebastes babcocki	5138	(thompson)	Primary	7930	2009-01-01 00:00:00
redbanded-rockfish	5138	amer. fisheries society, 1980	Common	7931	2009-01-01 00:00:00
sebastes-babcocki	5138	(thompson)	Synonym	7932	2009-01-01 00:00:00
Sebastes crameri	5139	(jordan)	Primary	7933	2009-01-01 00:00:00
darkblotched-rockfish	5139	amer. fisheries society, 1980	Common	7934	2009-01-01 00:00:00
sebastes-crameri	5139	(jordan)	Synonym	7935	2009-01-01 00:00:00
Sebastes entomelas/miniatus Complex	5140	\N	Primary	7936	2009-01-01 00:00:00
Sebastolobus	5141	unknown	Primary	7937	2009-01-01 00:00:00
thornyhead-rockfish	5141	unknown	Common	7938	2009-01-01 00:00:00
Sebastolobus altivelis	5142	gilbert	Primary	7939	2009-01-01 00:00:00
longspine-thornyhead	5142	amer. fisheries society, 1980	Common	7940	2009-01-01 00:00:00
Sebastolobus alascanus	5143	bean	Primary	7941	2009-01-01 00:00:00
shortspine-thornyhead	5143	amer. fisheries society, 1980	Common	7942	2009-01-01 00:00:00
Anoplopomatoidei	5144	unknown	Primary	7943	2009-01-01 00:00:00
Anoplopomatidae	5145	unknown	Primary	7944	2009-01-01 00:00:00
anoplopomatidae	5145	unknown	Synonym	7945	2009-01-01 00:00:00
Anoplopoma	5146	unknown	Primary	7946	2009-01-01 00:00:00
anoplopoma	5146	unknown	Synonym	7947	2009-01-01 00:00:00
Anoplopoma fimbria	5147	(pallas)	Primary	7948	2009-01-01 00:00:00
black-cod	5147	peterson guide	Common	7949	2009-01-01 00:00:00
sablefish	5147	amer. fisheries society, 1980	Common	7950	2009-01-01 00:00:00
anoplopoma-fimbria	5147	(pallas)	Synonym	7951	2009-01-01 00:00:00
Erilepis	5148	unknown	Primary	7952	2009-01-01 00:00:00
erilepis	5148	unknown	Synonym	7953	2009-01-01 00:00:00
Erilepis zonifer	5149	(Lockington, 1880)	Primary	7954	2009-01-01 00:00:00
skilfish	5149	unknown	Common	7955	2009-01-01 00:00:00
erilepis-zonifer	5149	(Lockington, 1880)	Synonym	7956	2009-01-01 00:00:00
Hexagrammoidei	5150	unknown	Primary	7957	2009-01-01 00:00:00
Hexagrammidae	5151	unknown	Primary	7958	2009-01-01 00:00:00
greenling	5151	nelson, 1984	Common	7959	2009-01-01 00:00:00
hexagrammidae	5151	unknown	Synonym	7960	2009-01-01 00:00:00
Hexagrammos	5152	unknown	Primary	7961	2009-01-01 00:00:00
hexagrammos	5152	unknown	Synonym	7962	2009-01-01 00:00:00
Hexagrammos decagrammus	5153	(pallas)	Primary	7963	2009-01-01 00:00:00
kelp-greenling	5153	amer. fisheries society, 1980	Common	7964	2009-01-01 00:00:00
hexagrammos-decagrammus	5153	(pallas)	Synonym	7965	2009-01-01 00:00:00
Hexagrammos stelleri	5154	Tilesius, 1810	Primary	7966	2009-01-01 00:00:00
whitespotted-greenling	5154	unknown	Common	7967	2009-01-01 00:00:00
hexagrammos-stelleri	5154	Tilesius, 1810	Synonym	7968	2009-01-01 00:00:00
Oxylebius	5155	unknown	Primary	7969	2009-01-01 00:00:00
oxylebius	5155	unknown	Synonym	7970	2009-01-01 00:00:00
Oxylebius pictus	5156	gill	Primary	7971	2009-01-01 00:00:00
convict-fish	5156	unknown	Common	7972	2009-01-01 00:00:00
painted-greenling	5156	amer. fisheries society, 1980	Common	7973	2009-01-01 00:00:00
oxylebius-pictus	5156	gill	Synonym	7974	2009-01-01 00:00:00
Ophiodon	5157	unknown	Primary	7975	2009-01-01 00:00:00
ophiodon	5157	unknown	Synonym	7976	2009-01-01 00:00:00
Ophiodon elongatus	5158	girard	Primary	7977	2009-01-01 00:00:00
lingcod	5158	amer. fisheries society, 1980	Common	7978	2009-01-01 00:00:00
ophiodon-elongatus	5158	girard	Synonym	7979	2009-01-01 00:00:00
Platycephaloidei	5159	\N	Primary	7980	2009-01-01 00:00:00
Triglidae	5160	unknown	Primary	7981	2009-01-01 00:00:00
searobin	5160	unknown	Common	7982	2009-01-01 00:00:00
Peristediidae	5161	Nelson, J.S., 1994	Primary	7983	2009-01-01 00:00:00
armored searobin	5161		Common	7984	2009-01-01 00:00:00
armored gurnard	5161		Common	7985	2009-01-01 00:00:00
Satyrichthys	5162	Kaup, 1873	Primary	7986	2009-01-01 00:00:00
Satyrichthys hians	5163	Gilbert and Cramer, 1897	Primary	7987	2009-01-01 00:00:00
Stephanoberyciformes	5164	unknown	Primary	7988	2009-01-01 00:00:00
stephanoberycoidei	5164	unknown	Synonym	7989	2009-01-01 00:00:00
Melamphaidae	5165	unknown	Primary	7990	2009-01-01 00:00:00
ridgeback	5165	unknown	Common	7991	2009-01-01 00:00:00
bigscale	5165	unknown	Common	7992	2009-01-01 00:00:00
melamphaidae	5165	unknown	Synonym	7993	2009-01-01 00:00:00
Scopeloberyx	5166	unknown	Primary	7994	2009-01-01 00:00:00
scopeloberyx	5166	unknown	Synonym	7995	2009-01-01 00:00:00
Scopeloberyx robustus	5167	(G¸nther, 1887)	Primary	7996	2009-01-01 00:00:00
longjaw-bigscale	5167	unknown	Common	7997	2009-01-01 00:00:00
scopeloberyx-robustus	5167	(G¸nther, 1887)	Synonym	7998	2009-01-01 00:00:00
Melamphaes	5168	unknown	Primary	7999	2009-01-01 00:00:00
melamphaes	5168	unknown	Synonym	8000	2009-01-01 00:00:00
Melamphaes lugubris	5169	Gilbert, 1891	Primary	8001	2009-01-01 00:00:00
highsnout-bigscale	5169	unknown	Common	8002	2009-01-01 00:00:00
melamphaes-lugubris	5169	Gilbert, 1891	Synonym	8003	2009-01-01 00:00:00
Melamphaes parvus	5170	Ebeling, 1962	Primary	8004	2009-01-01 00:00:00
little-bigscale	5170	unknown	Common	8005	2009-01-01 00:00:00
melamphaes-parvus	5170	Ebeling, 1962	Synonym	8006	2009-01-01 00:00:00
Scopelogadus	5171	unknown	Primary	8007	2009-01-01 00:00:00
scopelogadus	5171	unknown	Synonym	8008	2009-01-01 00:00:00
Scopelogadus mizolepis bispinosus	5172	(Gilbert, 1915)	Primary	8009	2009-01-01 00:00:00
twospine-bigscale	5172	unknown	Common	8010	2009-01-01 00:00:00
scopelogadus-mizolepis-bispinosus	5172	(Gilbert, 1915)	Synonym	8011	2009-01-01 00:00:00
Poromitra	5173	Goode and Bean,1883	Primary	8012	2009-01-01 00:00:00
poromitra	5173	Goode and Bean,1883	Synonym	8013	2009-01-01 00:00:00
Poromitra oscitans	5174	Ebeling, 1975	Primary	8014	2009-01-01 00:00:00
yawning-bigscale	5174	unknown	Common	8015	2009-01-01 00:00:00
sluggish-bigscale	5174	unknown	Common	8016	2009-01-01 00:00:00
poromitra-oscitans	5174	Ebeling, 1975	Synonym	8017	2009-01-01 00:00:00
Poromitra crassiceps	5175	guenther, 1878	Primary	8018	2009-01-01 00:00:00
crested-bigscale	5175	shiino, 1978	Common	8019	2009-01-01 00:00:00
poromitra-crassiceps	5175	guenther, 1878	Synonym	8020	2009-01-01 00:00:00
Beloniformes	5176	unknown	Primary	8021	2009-01-01 00:00:00
beloniformes	5176	unknown	Synonym	8022	2009-01-01 00:00:00
Exocoetoidei	5177	unknown	Primary	8023	2009-01-01 00:00:00
exocoetoidei	5177	unknown	Synonym	8024	2009-01-01 00:00:00
Exocoetidae	5178	unknown	Primary	8025	2009-01-01 00:00:00
halfbeak	5178	unknown	Common	8026	2009-01-01 00:00:00
flyingfish	5178	shiino, 1978	Common	8027	2009-01-01 00:00:00
exocoetidae	5178	unknown	Synonym	8028	2009-01-01 00:00:00
Cypselurus	5179	lowe,1841	Primary	8029	2009-01-01 00:00:00
cypselurus	5179	lowe,1841	Synonym	8030	2009-01-01 00:00:00
Cypselurus californicus	5180	(cooper)	Primary	8031	2009-01-01 00:00:00
california-flyingfish	5180	amer. fisheries society, 1980	Common	8032	2009-01-01 00:00:00
cypselurus-californicus	5180	(cooper)	Synonym	8033	2009-01-01 00:00:00
Scomberesocidae	5181	unknown	Primary	8034	2009-01-01 00:00:00
saury	5181	unknown	Common	8035	2009-01-01 00:00:00
scomberesocidae	5181	unknown	Synonym	8036	2009-01-01 00:00:00
Cololabis	5182	unknown	Primary	8037	2009-01-01 00:00:00
cololabis	5182	unknown	Synonym	8038	2009-01-01 00:00:00
Cololabis saira	5183	(Brevoort, 1856)	Primary	8039	2009-01-01 00:00:00
pacific-saury	5183	unknown	Common	8040	2009-01-01 00:00:00
cololabis-saira	5183	(Brevoort, 1856)	Synonym	8041	2009-01-01 00:00:00
Zeiformes	5184	unknown	Primary	8042	2009-01-01 00:00:00
zeiformes	5184	unknown	Synonym	8043	2009-01-01 00:00:00
Oreosomatidae	5185	unknown	Primary	8044	2009-01-01 00:00:00
oreo	5185	unknown	Common	8045	2009-01-01 00:00:00
oreosomatidae	5185	unknown	Synonym	8046	2009-01-01 00:00:00
Allocyttus	5186	unknown	Primary	8047	2009-01-01 00:00:00
allocyttus	5186	unknown	Synonym	8048	2009-01-01 00:00:00
Allocyttus folletti	5187	Myers, 1960	Primary	8049	2009-01-01 00:00:00
oxeye-oreo	5187	unknown	Common	8050	2009-01-01 00:00:00
allocyttus-folletti	5187	Myers, 1960	Synonym	8051	2009-01-01 00:00:00
Zeidae	5188	unknown	Primary	8052	2009-01-01 00:00:00
dory	5188	unknown	Common	8053	2009-01-01 00:00:00
zeidae	5188	unknown	Synonym	8054	2009-01-01 00:00:00
Zenopsis	5189	unknown	Primary	8055	2009-01-01 00:00:00
zenopsis	5189	unknown	Synonym	8056	2009-01-01 00:00:00
Zenopsis nebulosus	5190	(Temminck and Schlegel, 1845)	Primary	8057	2009-01-01 00:00:00
zenopsis-nebulosa	5190	unknown	Synonym	8058	2009-01-01 00:00:00
mirror-dory	5190	unknown	Common	8059	2009-01-01 00:00:00
zenopsis-nebulosus	5190	(Temminck and Schlegel, 1845)	Synonym	8060	2009-01-01 00:00:00
Cetomimiformes	5191	unknown	Primary	8061	2009-01-01 00:00:00
cetomimiformes	5191	unknown	Synonym	8062	2009-01-01 00:00:00
Mirapinnidae	5192	unknown	Primary	8063	2009-01-01 00:00:00
ribbonbearer	5192	unknown	Common	8064	2009-01-01 00:00:00
tapetail	5192	unknown	Common	8065	2009-01-01 00:00:00
ribbontail	5192	unknown	Common	8066	2009-01-01 00:00:00
hairyfish	5192	unknown	Common	8067	2009-01-01 00:00:00
mirapinnidae	5192	unknown	Synonym	8068	2009-01-01 00:00:00
Eutaeniophorus	5193	unknown	Primary	8069	2009-01-01 00:00:00
eutaeniophorus	5193	unknown	Synonym	8070	2009-01-01 00:00:00
Eutaeniophorus festivus	5194	(Bertelsen and Marshall, 1956)	Primary	8071	2009-01-01 00:00:00
festive-ribbonfish	5194	unknown	Common	8072	2009-01-01 00:00:00
festive-ribbontail	5194	unknown	Common	8073	2009-01-01 00:00:00
eutaeniophorus-festivus	5194	(Bertelsen and Marshall, 1956)	Synonym	8074	2009-01-01 00:00:00
Rondeletiidae	5195	unknown	Primary	8075	2009-01-01 00:00:00
redmouth-whalefish	5195	unknown	Common	8076	2009-01-01 00:00:00
rondeletiidae	5195	unknown	Synonym	8077	2009-01-01 00:00:00
Rondeletia	5196	unknown	Primary	8078	2009-01-01 00:00:00
rondeletia	5196	unknown	Synonym	8079	2009-01-01 00:00:00
Rondeletia loricata	5197	Abe and Hotta, 1963	Primary	8080	2009-01-01 00:00:00
armoured-redmouthed-whalefish	5197	unknown	Common	8081	2009-01-01 00:00:00
rondeletia-loricata	5197	Abe and Hotta, 1963	Synonym	8082	2009-01-01 00:00:00
Barbourisiidae	5198	unknown	Primary	8083	2009-01-01 00:00:00
red-whalefish	5198	unknown	Common	8084	2009-01-01 00:00:00
barbourisiidae	5198	unknown	Synonym	8085	2009-01-01 00:00:00
Barbourisia	5199	unknown	Primary	8086	2009-01-01 00:00:00
barbourisia	5199	unknown	Synonym	8087	2009-01-01 00:00:00
Barbourisia rufa	5200	Parr, 1945	Primary	8088	2009-01-01 00:00:00
velvelt-whalefish	5200	unknown	Common	8089	2009-01-01 00:00:00
barbourisia-rufa	5200	Parr, 1945	Synonym	8090	2009-01-01 00:00:00
Cetomimidae	5201	unknown	Primary	8091	2009-01-01 00:00:00
flabby-whalefish	5201	unknown	Common	8092	2009-01-01 00:00:00
cetomimidae	5201	unknown	Synonym	8093	2009-01-01 00:00:00
whalefish	5201		Synonym	8094	2009-01-01 00:00:00
Cetostoma	5202	unknown	Primary	8095	2009-01-01 00:00:00
cetostoma	5202	unknown	Synonym	8096	2009-01-01 00:00:00
Cetostoma regani	5203	Zugmayer, 1914	Primary	8097	2009-01-01 00:00:00
pink-flabby-whalefish	5203	unknown	Common	8098	2009-01-01 00:00:00
cetostoma-regani	5203	Zugmayer, 1914	Synonym	8099	2009-01-01 00:00:00
Ditropichthys	5204	unknown	Primary	8100	2009-01-01 00:00:00
ditropichthys	5204	unknown	Synonym	8101	2009-01-01 00:00:00
Ditropichthys storeri	5205	(Goode and Bean, 1895)	Primary	8102	2009-01-01 00:00:00
ditropichthys-storeri	5205	(Goode and Bean, 1895)	Synonym	8103	2009-01-01 00:00:00
Tetraodontiformes	5206	unknown	Primary	8104	2009-01-01 00:00:00
tetraodontiformes	5206	unknown	Synonym	8105	2009-01-01 00:00:00
Tetraodontidae	5207	unknown	Primary	8106	2009-01-01 00:00:00
puffer-fish	5207	unknown	Common	8107	2009-01-01 00:00:00
tetraodontidae	5207	unknown	Synonym	8108	2009-01-01 00:00:00
Molidae	5208	unknown	Primary	8109	2009-01-01 00:00:00
headfish	5208	shiino, 1978	Common	8110	2009-01-01 00:00:00
molidae	5208	unknown	Synonym	8111	2009-01-01 00:00:00
Mola	5209	unknown	Primary	8112	2009-01-01 00:00:00
mola	5209	unknown	Synonym	8113	2009-01-01 00:00:00
Mola mola	5210	(linnaeus)	Primary	8114	2009-01-01 00:00:00
ocean-sunfish	5210	amer. fisheries society, 1980	Common	8115	2009-01-01 00:00:00
mola-mola	5210	(linnaeus)	Synonym	8116	2009-01-01 00:00:00
Ostraciidae	5211	unknown	Primary	8117	2009-01-01 00:00:00
boxfish	5211	unknown	Common	8118	2009-01-01 00:00:00
ostraciidae	5211	unknown	Synonym	8119	2009-01-01 00:00:00
Balistidae	5212	unknown	Primary	8120	2009-01-01 00:00:00
triggerfish	5212	unknown	Common	8121	2009-01-01 00:00:00
balistidae	5212	unknown	Synonym	8122	2009-01-01 00:00:00
Balistes	5213	unknown	Primary	8123	2009-01-01 00:00:00
balistes	5213	unknown	Synonym	8124	2009-01-01 00:00:00
Balistes polylepis	5214	Steindachner, 1876	Primary	8125	2009-01-01 00:00:00
finescale-triggerfish	5214	unknown	Common	8126	2009-01-01 00:00:00
balistes-polylepis	5214	Steindachner, 1876	Synonym	8127	2009-01-01 00:00:00
Diodontidae	5215	unknown	Primary	8128	2009-01-01 00:00:00
burrfish	5215	unknown	Common	8129	2009-01-01 00:00:00
porcupinefish	5215	unknown	Common	8130	2009-01-01 00:00:00
diodontidae	5215	unknown	Synonym	8131	2009-01-01 00:00:00
Protacanthopterygii	5216	unknown	Primary	8132	2009-01-01 00:00:00
Salmoniformes	5217	unknown	Primary	8133	2009-01-01 00:00:00
salmoniformes	5217	unknown	Synonym	8134	2009-01-01 00:00:00
Argentinoidei	5218	unknown	Primary	8135	2009-01-01 00:00:00
argentinoidei	5218	unknown	Synonym	8136	2009-01-01 00:00:00
Argentinidae	5219	unknown	Primary	8137	2009-01-01 00:00:00
herring-smelt	5219	unknown	Common	8138	2009-01-01 00:00:00
argentine	5219	nelson, 1984	Common	8139	2009-01-01 00:00:00
argentinidae	5219	unknown	Synonym	8140	2009-01-01 00:00:00
Argentina	5220	linnaeus, 1758	Primary	8141	2009-01-01 00:00:00
argentina	5220	linnaeus, 1758	Synonym	8142	2009-01-01 00:00:00
Argentina sialis	5221	gilbert, 1890	Primary	8143	2009-01-01 00:00:00
pacific-argentine	5221	amer. fisheries society, 1980	Common	8144	2009-01-01 00:00:00
argentina-sialis	5221	gilbert, 1890	Synonym	8145	2009-01-01 00:00:00
Leptochilichthyidae	5222	unknown	Primary	8146	2009-01-01 00:00:00
leptochilichthyidae	5222	unknown	Synonym	8147	2009-01-01 00:00:00
Leptochilichthys	5223	unknown	Primary	8148	2009-01-01 00:00:00
leptochilichthys	5223	unknown	Synonym	8149	2009-01-01 00:00:00
Leptochilichthys agassizi	5224	Garman, 1899	Primary	8150	2009-01-01 00:00:00
agassiz-smooth-head	5224	unknown	Common	8151	2009-01-01 00:00:00
leptochilichthys-agassizi	5224	Garman, 1899	Synonym	8152	2009-01-01 00:00:00
Alepocephalidae	5225	unknown	Primary	8153	2009-01-01 00:00:00
slickhead-fish	5225	Shiino, 1978	Common	8154	2009-01-01 00:00:00
smoothhead-fish	5225	unknown	Common	8155	2009-01-01 00:00:00
alepocephalidae	5225	unknown	Synonym	8156	2009-01-01 00:00:00
Narcetes	5226	unknown	Primary	8157	2009-01-01 00:00:00
narcetes	5226	unknown	Synonym	8158	2009-01-01 00:00:00
Narcetes stomias	5227	(Gilbert, 1890)	Primary	8159	2009-01-01 00:00:00
blackhead-salmon	5227	unknown	Common	8160	2009-01-01 00:00:00
narcetes-stomias	5227	(Gilbert, 1890)	Synonym	8161	2009-01-01 00:00:00
Talismania	5228	unknown	Primary	8162	2009-01-01 00:00:00
talismania	5228	unknown	Synonym	8163	2009-01-01 00:00:00
Talismania bifurcata	5229	(Parr, 1951)	Primary	8164	2009-01-01 00:00:00
threadfin-slickhead	5229	unknown	Common	8165	2009-01-01 00:00:00
talismania-bifurcata	5229	(Parr, 1951)	Synonym	8166	2009-01-01 00:00:00
Alepocephalus	5230	unknown	Primary	8167	2009-01-01 00:00:00
alepocephalus	5230	unknown	Synonym	8168	2009-01-01 00:00:00
Alepocephalus tenebrosus	5231	gilbert,1891	Primary	8169	2009-01-01 00:00:00
california-slickhead	5231	unknown	Common	8170	2009-01-01 00:00:00
alepocephalus-tenebrosus	5231	gilbert,1891	Synonym	8171	2009-01-01 00:00:00
Bathylaco	5232	unknown	Primary	8172	2009-01-01 00:00:00
bathylaco	5232	unknown	Synonym	8173	2009-01-01 00:00:00
Bathylaco nigricans	5233	Goode and Bean, 1896	Primary	8174	2009-01-01 00:00:00
black-warrior	5233	unknown	Common	8175	2009-01-01 00:00:00
boneythroat	5233	unknown	Common	8176	2009-01-01 00:00:00
bathylaco-nigricans	5233	Goode and Bean, 1896	Synonym	8177	2009-01-01 00:00:00
Conocara	5234	unknown	Primary	8178	2009-01-01 00:00:00
conocara	5234	unknown	Synonym	8179	2009-01-01 00:00:00
Conocara salmonea	5235	(Gill & Townsend, 1897)	Primary	8180	2009-01-01 00:00:00
conocara-salmoneum	5235	unknown	Synonym	8181	2009-01-01 00:00:00
salmon-smoothhead	5235	unknown	Common	8182	2009-01-01 00:00:00
deepsea-slickhead	5235	unknown	Common	8183	2009-01-01 00:00:00
conocara-salmonea	5235	(Gill & Townsend, 1897)	Synonym	8184	2009-01-01 00:00:00
Platytroctidae	5236	unknown	Primary	8185	2009-01-01 00:00:00
searsiidae	5236	unknown	Synonym	8186	2009-01-01 00:00:00
tubeshoulder	5236	unknown	Common	8187	2009-01-01 00:00:00
platytroctidae	5236	unknown	Synonym	8188	2009-01-01 00:00:00
Holtbyrnia	5237	unknown	Primary	8189	2009-01-01 00:00:00
holtbyrnia	5237	unknown	Synonym	8190	2009-01-01 00:00:00
Holtbyrnia latifrons	5238	Sazanov, 1976	Primary	8191	2009-01-01 00:00:00
streaklight-tubeshoulder	5238	unknown	Common	8192	2009-01-01 00:00:00
holtbyrnia-latifrons	5238	Sazanov, 1976	Synonym	8193	2009-01-01 00:00:00
Maulisia	5239	unknown	Primary	8194	2009-01-01 00:00:00
maulisia	5239	unknown	Synonym	8195	2009-01-01 00:00:00
Maulisia argipalla	5240	Matsui and Rosenblatt, 1979	Primary	8196	2009-01-01 00:00:00
palegold-searsid	5240	unknown	Common	8197	2009-01-01 00:00:00
pitted-tubeshoulder	5240	unknown	Common	8198	2009-01-01 00:00:00
maulisia-argipalla	5240	Matsui and Rosenblatt, 1979	Synonym	8199	2009-01-01 00:00:00
Sagamichthys	5241	unknown	Primary	8200	2009-01-01 00:00:00
sagamichthys	5241	unknown	Synonym	8201	2009-01-01 00:00:00
Sagamichthys abei	5242	unknown	Primary	8202	2009-01-01 00:00:00
shining-tubeshoulder	5242	unknown	Common	8203	2009-01-01 00:00:00
sagamichthys-abei	5242	unknown	Synonym	8204	2009-01-01 00:00:00
Mirorictus	5243	unknown	Primary	8205	2009-01-01 00:00:00
mirorictus	5243	unknown	Synonym	8206	2009-01-01 00:00:00
Mirorictus taningi	5244	Parr, 1947	Primary	8207	2009-01-01 00:00:00
striped-tubeshoulder	5244	unknown	Common	8208	2009-01-01 00:00:00
mirorictus-taningi	5244	Parr, 1947	Synonym	8209	2009-01-01 00:00:00
Pellisolus	5245	unknown	Primary	8210	2009-01-01 00:00:00
pellisolus	5245	unknown	Synonym	8211	2009-01-01 00:00:00
Pellisolus eubranchus	5246	Matsui and Rosenblatt, 1987	Primary	8212	2009-01-01 00:00:00
pellisolus-eubranchus	5246	Matsui and Rosenblatt, 1987	Synonym	8213	2009-01-01 00:00:00
Bathylagidae	5247	unknown	Primary	8214	2009-01-01 00:00:00
deepsea-smelt	5247	Nelson, 1984	Common	8215	2009-01-01 00:00:00
bathylagidae	5247	unknown	Synonym	8216	2009-01-01 00:00:00
Bathylagus	5248	guenther, 1878	Primary	8217	2009-01-01 00:00:00
bathylagus	5248	guenther, 1878	Synonym	8218	2009-01-01 00:00:00
Bathylagus pacificus	5249	Gilbert, 1890	Primary	8219	2009-01-01 00:00:00
slender-blacksmelt	5249	unknown	Common	8220	2009-01-01 00:00:00
pacific-blacksmelt	5249	unknown	Common	8221	2009-01-01 00:00:00
bathylagus-pacificus	5249	Gilbert, 1890	Synonym	8222	2009-01-01 00:00:00
Bathylagus bericoides	5250	(Borodin, 1929)	Primary	8223	2009-01-01 00:00:00
bathylagus-bericoides	5250	(Borodin, 1929)	Synonym	8224	2009-01-01 00:00:00
Bathylagus nigrigenys	5251	Parr, 1931	Primary	8225	2009-01-01 00:00:00
blackchin-blacksmelt	5251	unknown	Common	8226	2009-01-01 00:00:00
bathylagus-nigrigenys	5251	Parr, 1931	Synonym	8227	2009-01-01 00:00:00
Bathylagus wesethi	5252	Bolin, 1938	Primary	8228	2009-01-01 00:00:00
snubnose-blacksmelt	5252	sea-grant	Common	8229	2009-01-01 00:00:00
bathylagus-wesethi	5252	Bolin, 1938	Synonym	8230	2009-01-01 00:00:00
Bathylagus ochotensis	5253	Schmidt, 1938	Primary	8231	2009-01-01 00:00:00
popeye-blacksmelt	5253	sea-grant	Common	8232	2009-01-01 00:00:00
okhotsk-blacksmelt	5253	shiino, 1978	Common	8233	2009-01-01 00:00:00
bathylagus-ochotensis	5253	Schmidt, 1938	Synonym	8234	2009-01-01 00:00:00
Bathylagus milleri	5254	Jordan & Gilbert, 1898	Primary	8235	2009-01-01 00:00:00
robust-blacksmelt	5254	sea-grant	Common	8236	2009-01-01 00:00:00
owlfish	5254	unknown	Common	8237	2009-01-01 00:00:00
stout-blacksmelt	5254	shiino, 1978	Common	8238	2009-01-01 00:00:00
bathylagus-milleri	5254	Jordan & Gilbert, 1898	Synonym	8239	2009-01-01 00:00:00
Leuroglossus	5255	unknown	Primary	8240	2009-01-01 00:00:00
leuroglossus	5255	unknown	Synonym	8241	2009-01-01 00:00:00
Leuroglossus stilbius	5256	Gilbert, 1890	Primary	8242	2009-01-01 00:00:00
bathylagus-stilbius	5256	unknown	Synonym	8243	2009-01-01 00:00:00
california-smoothtongue	5256	American Fisheries Society	Common	8244	2009-01-01 00:00:00
leuroglossus-stilbius	5256	Gilbert, 1890	Synonym	8245	2009-01-01 00:00:00
Microstomatidae	5257	unknown	Primary	8246	2009-01-01 00:00:00
microstomatidae	5257	unknown	Synonym	8247	2009-01-01 00:00:00
Nansenia	5258	unknown	Primary	8248	2009-01-01 00:00:00
nansenia	5258	unknown	Synonym	8249	2009-01-01 00:00:00
Nansenia candida	5259	unknown	Primary	8250	2009-01-01 00:00:00
blue-throat-argentine	5259	unknown	Common	8251	2009-01-01 00:00:00
nansenia-candida	5259	unknown	Synonym	8252	2009-01-01 00:00:00
Nansenia crassa	5260	unknown	Primary	8253	2009-01-01 00:00:00
stout-argentine	5260	unknown	Common	8254	2009-01-01 00:00:00
nansenia-crassa	5260	unknown	Synonym	8255	2009-01-01 00:00:00
Microstoma	5261	unknown	Primary	8256	2009-01-01 00:00:00
microstoma	5261	unknown	Synonym	8257	2009-01-01 00:00:00
Microstoma microstoma	5262	unknown	Primary	8258	2009-01-01 00:00:00
dusky-pencilsmelt	5262	unknown	Common	8259	2009-01-01 00:00:00
microstoma-microstoma	5262	unknown	Synonym	8260	2009-01-01 00:00:00
Opisthoproctidae	5263	unknown	Primary	8261	2009-01-01 00:00:00
barreleye-fish	5263	unknown	Common	8262	2009-01-01 00:00:00
spookfish	5263	unknown	Common	8263	2009-01-01 00:00:00
opisthoproctidae	5263	unknown	Synonym	8264	2009-01-01 00:00:00
Bathylychnops	5264	unknown	Primary	8265	2009-01-01 00:00:00
bathylychnops	5264	unknown	Synonym	8266	2009-01-01 00:00:00
Bathylychnops exilis	5265	Cohen, 1958	Primary	8267	2009-01-01 00:00:00
javelin-spookfish	5265	unknown	Common	8268	2009-01-01 00:00:00
bathylychnops-exilis	5265	Cohen, 1958	Synonym	8269	2009-01-01 00:00:00
Dolichopteryx	5266	unknown	Primary	8270	2009-01-01 00:00:00
dolichopteryx	5266	unknown	Synonym	8271	2009-01-01 00:00:00
Dolichopteryx longipes	5267	(Vaillant, 1888)	Primary	8272	2009-01-01 00:00:00
brownsnout-spookfish	5267	unknown	Common	8273	2009-01-01 00:00:00
dolichopteryx-longipes	5267	(Vaillant, 1888)	Synonym	8274	2009-01-01 00:00:00
Macropinna	5268	unknown	Primary	8275	2009-01-01 00:00:00
macropinna	5268	unknown	Synonym	8276	2009-01-01 00:00:00
Macropinna microstoma	5269	chapman, 1939	Primary	8277	2009-01-01 00:00:00
barreleye	5269	amer. fisheries society, 1980	Common	8278	2009-01-01 00:00:00
macropinna-microstoma	5269	chapman, 1939	Synonym	8279	2009-01-01 00:00:00
Salmonoidei	5270	unknown	Primary	8280	2009-01-01 00:00:00
salmonoidei	5270	unknown	Synonym	8281	2009-01-01 00:00:00
Salmonidae	5271	unknown	Primary	8282	2009-01-01 00:00:00
salmonid	5271	nelson, 1984	Common	8283	2009-01-01 00:00:00
salmonidae	5271	unknown	Synonym	8284	2009-01-01 00:00:00
Salmoninae	5272	unknown	Primary	8285	2009-01-01 00:00:00
char	5272	unknown	Common	8286	2009-01-01 00:00:00
trout	5272	unknown	Common	8287	2009-01-01 00:00:00
salmoninae	5272	unknown	Synonym	8288	2009-01-01 00:00:00
Oncorhynchus	5273	unknown	Primary	8289	2009-01-01 00:00:00
salmon	5273	unknown	Common	8290	2009-01-01 00:00:00
oncorhynchus	5273	unknown	Synonym	8291	2009-01-01 00:00:00
Osmeriformes	5274	unknown	Primary	8292	2009-01-01 00:00:00
osmeriformes	5274	unknown	Synonym	8293	2009-01-01 00:00:00
Osmeroidei	5275	unknown	Primary	8294	2009-01-01 00:00:00
osmeroidei	5275	unknown	Synonym	8295	2009-01-01 00:00:00
Osmeridae	5276	unknown	Primary	8296	2009-01-01 00:00:00
smelt	5276	unknown	Common	8297	2009-01-01 00:00:00
osmeridae	5276	unknown	Synonym	8298	2009-01-01 00:00:00
Spirinchus	5277	unknown	Primary	8299	2009-01-01 00:00:00
spirinchus	5277	unknown	Synonym	8300	2009-01-01 00:00:00
Spirinchus starksi	5278	(Fisk, 1913)	Primary	8301	2009-01-01 00:00:00
night-smelt	5278	unknown	Common	8302	2009-01-01 00:00:00
spirinchus-starksi	5278	(Fisk, 1913)	Synonym	8303	2009-01-01 00:00:00
Thaleichthys	5279	unknown	Primary	8304	2009-01-01 00:00:00
thaleichthys	5279	unknown	Synonym	8305	2009-01-01 00:00:00
Thaleichthys pacificus	5280	(Richardson, 1836)	Primary	8306	2009-01-01 00:00:00
eulachon	5280	unknown	Common	8307	2009-01-01 00:00:00
thaleichthys-pacificus	5280	(Richardson, 1836)	Synonym	8308	2009-01-01 00:00:00
Leptocephalus	5281	unknown	Primary	8309	2009-01-01 00:00:00
Elopamorpha	5282	unknown	Primary	8310	2009-01-01 00:00:00
Saccopharyngiformes	5283	unknown	Primary	8311	2009-01-01 00:00:00
Saccopharyngidae	5284	unknown	Primary	8312	2009-01-01 00:00:00
whiptail-gulper	5284	unknown	Common	8313	2009-01-01 00:00:00
swallower	5284	nelson	Common	8314	2009-01-01 00:00:00
Saccopharynx	5285	mitchill, 1842	Primary	8315	2009-01-01 00:00:00
Saccopharynx lavenbergi	5286	unknown	Primary	8316	2009-01-01 00:00:00
Saccopharynx ampullaceus	5287	(harwood, 1827)	Primary	8317	2009-01-01 00:00:00
pelican-fish	5287	shiino, 1978	Common	8318	2009-01-01 00:00:00
Saccopharynx flagellum	5288	cuvier, 1829	Primary	8319	2009-01-01 00:00:00
Saccopharynx harrisoni	5289	unknown	Primary	8320	2009-01-01 00:00:00
Eurypharyngidae	5290	unknown	Primary	8321	2009-01-01 00:00:00
gulper-eel	5290	unknown	Common	8322	2009-01-01 00:00:00
Eurypharynx	5291	vaillant, 1882	Primary	8323	2009-01-01 00:00:00
eurypharynx	5291	vaillant, 1882	Synonym	8324	2009-01-01 00:00:00
Eurypharynx pelecanoides	5292	vaillant, 1882	Primary	8325	2009-01-01 00:00:00
umbrellamouth-gulper	5292	unknown	Common	8326	2009-01-01 00:00:00
pelican-gulper	5292	shiino, 1978	Common	8327	2009-01-01 00:00:00
eurypharynx-pelecanoides	5292	vaillant, 1882	Synonym	8328	2009-01-01 00:00:00
Cyematidae	5293	unknown	Primary	8329	2009-01-01 00:00:00
bobtail-eel	5293	unknown	Common	8330	2009-01-01 00:00:00
cyematidae	5293	unknown	Synonym	8331	2009-01-01 00:00:00
Cyema	5294	unknown	Primary	8332	2009-01-01 00:00:00
cyema	5294	unknown	Synonym	8333	2009-01-01 00:00:00
Cyema atrum	5295	Gunther, 1878	Primary	8334	2009-01-01 00:00:00
deepwater-eel	5295	unknown	Common	8335	2009-01-01 00:00:00
bobtail-snipe-eel	5295	unknown	Common	8336	2009-01-01 00:00:00
Notacanthiformes	5296	unknown	Primary	8337	2009-01-01 00:00:00
Halosauridae	5297	unknown	Primary	8338	2009-01-01 00:00:00
halosaur	5297	unknown	Common	8339	2009-01-01 00:00:00
Aldrovandia	5298	Goode and Bean, 1896	Primary	8340	2009-01-01 00:00:00
Notacanthidae	5299	unknown	Primary	8341	2009-01-01 00:00:00
spiny-eel	5299	unknown	Common	8342	2009-01-01 00:00:00
Notacanthus chemnitzii	5300	unknown	Primary	8343	2009-01-01 00:00:00
Notacanthus	5301	unknown	Primary	8344	2009-01-01 00:00:00
Polyacanthonotus	5302	unknown	Primary	8345	2009-01-01 00:00:00
Polyacanthonotus challengeri	5303	unknown	Primary	8346	2009-01-01 00:00:00
longnose-tapirfish	5303	unknown	Common	8347	2009-01-01 00:00:00
Albuliformes	5304	unknown	Primary	8348	2009-01-01 00:00:00
Anguilliformes	5305	unknown	Primary	8349	2009-01-01 00:00:00
eel	5305	(n.o.d.c.)	Common	8350	2009-01-01 00:00:00
Serrivomeridae	5306	unknown	Primary	8351	2009-01-01 00:00:00
sawtooth-eels	5306	unknown	Common	8352	2009-01-01 00:00:00
Serrivomer	5307	unknown	Primary	8353	2009-01-01 00:00:00
serrivomer	5307	unknown	Synonym	8354	2009-01-01 00:00:00
Serrivomer sector	5308	unknown	Primary	8355	2009-01-01 00:00:00
sawtooth-eel-species	5308	unknown	Common	8356	2009-01-01 00:00:00
serrivomer-sector	5308	unknown	Synonym	8357	2009-01-01 00:00:00
Muraenoidei	5309	unknown	Primary	8358	2009-01-01 00:00:00
Muraenidae	5310	unknown	Primary	8359	2009-01-01 00:00:00
moray-eel	5310	unknown	Common	8360	2009-01-01 00:00:00
muraenidae	5310	unknown	Synonym	8361	2009-01-01 00:00:00
Muraeninae	5311	unknown	Primary	8362	2009-01-01 00:00:00
muraeninae	5311	unknown	Synonym	8363	2009-01-01 00:00:00
Gymnothorax	5312	unknown	Primary	8364	2009-01-01 00:00:00
gymnothorax	5312	unknown	Synonym	8365	2009-01-01 00:00:00
Gymnothorax berndti	5313	unknown	Primary	8366	2009-01-01 00:00:00
y-patterned-moray	5313	unknown	Common	8367	2009-01-01 00:00:00
Anguilloidei	5314	unknown	Primary	8368	2009-01-01 00:00:00
Congroidei	5315	unknown	Primary	8369	2009-01-01 00:00:00
Congridae	5316	unknown	Primary	8370	2009-01-01 00:00:00
conger-eel	5316	unknown	Common	8371	2009-01-01 00:00:00
congridae	5316	unknown	Synonym	8372	2009-01-01 00:00:00
Derichthyidae	5317	unknown	Primary	8373	2009-01-01 00:00:00
neck-eel	5317	unknown	Common	8374	2009-01-01 00:00:00
longneck-eel	5317	unknown	Common	8375	2009-01-01 00:00:00
derichthyidae	5317	unknown	Synonym	8376	2009-01-01 00:00:00
Derichthys	5318	unknown	Primary	8377	2009-01-01 00:00:00
derichthys	5318	unknown	Synonym	8378	2009-01-01 00:00:00
Derichthys sperpentinus	5319	unknown	Primary	8379	2009-01-01 00:00:00
narrownecked-oceanic-eel	5319	unknown	Common	8380	2009-01-01 00:00:00
derichthys-sperpentinus	5319	unknown	Synonym	8381	2009-01-01 00:00:00
Nemichthyidae	5320	unknown	Primary	8382	2009-01-01 00:00:00
snipe-eel	5320	nelson	Common	8383	2009-01-01 00:00:00
Avocettina	5321	Jordan & Davis, 1891	Primary	8384	2009-01-01 00:00:00
Avocettina infans	5322	Günther, 1878	Primary	8385	2009-01-01 00:00:00
blackline-snipe-eel	5322	unknown	Common	8386	2009-01-01 00:00:00
Avocettina bowersii	5323	Garman, 1899	Primary	8387	2009-01-01 00:00:00
smalleye-snipe-eel	5323	unknown	Common	8388	2009-01-01 00:00:00
Nemichthys	5324	Richardson, 1848	Primary	8389	2009-01-01 00:00:00
Nemichthys larsoni	5325	Nielsen & Smith, 1978	Primary	8390	2009-01-01 00:00:00
pale-snipe-eel	5325	unknown	Common	8391	2009-01-01 00:00:00
Nemichthys scolopaceus	5326	Richardson, 1848	Primary	8392	2009-01-01 00:00:00
slender-snipe-eel	5326	amer. fisheries society, 1980	Common	8393	2009-01-01 00:00:00
atlantic-snipe-eel	5326	shiino, 1978	Common	8394	2009-01-01 00:00:00
Synaphobranchidae	5327	unknown	Primary	8395	2009-01-01 00:00:00
Nettastomatidae	5328	unknown	Primary	8396	2009-01-01 00:00:00
duckbill-eel	5328	unknown	Common	8397	2009-01-01 00:00:00
Facciolella	5329	unknown	Primary	8398	2009-01-01 00:00:00
facciolella	5329	unknown	Synonym	8399	2009-01-01 00:00:00
Facciolella gilberti	5330	garman, 1899	Primary	8400	2009-01-01 00:00:00
dogface-witch-eel	5330	unknown	Common	8401	2009-01-01 00:00:00
facciolella-gilberti	5330	garman, 1899	Synonym	8402	2009-01-01 00:00:00
Venefica	5331	unknown	Primary	8403	2009-01-01 00:00:00
venefica	5331	unknown	Synonym	8404	2009-01-01 00:00:00
Venefica procera	5332	unknown	Primary	8405	2009-01-01 00:00:00
shortnose-witch-eel	5332	unknown	Common	8406	2009-01-01 00:00:00
venefica-procera	5332	unknown	Synonym	8407	2009-01-01 00:00:00
Venefica tentaculata	5333	unknown	Primary	8408	2009-01-01 00:00:00
longnose-witch-eel	5333	unknown	Common	8409	2009-01-01 00:00:00
venefica-tentaculata	5333	unknown	Synonym	8410	2009-01-01 00:00:00
Nettastoma	5334	Rafinesque, 1810	Primary	8411	2009-01-01 00:00:00
Nettastoma parviceps	5335	Günther, 1877	Primary	8412	2009-01-01 00:00:00
Chondrichthyes	5336	unknown	Primary	8413	2009-01-01 00:00:00
shark	5336	unknown	Common	8414	2009-01-01 00:00:00
cartilaginous-fish	5336	(n.o.d.c.)	Common	8415	2009-01-01 00:00:00
Holocephali	5337	unknown	Primary	8416	2009-01-01 00:00:00
chimaera	5337	www.fishbase.org	Common	8417	2009-01-01 00:00:00
Holocephalimorpha	5338	unknown	Primary	8418	2009-01-01 00:00:00
Chimaeriformes	5339	unknown	Primary	8419	2009-01-01 00:00:00
Chimaeroidei	5340	unknown	Primary	8420	2009-01-01 00:00:00
Chimaeridae	5341	Bonaparte, 1831	Primary	8421	2009-01-01 00:00:00
ratfish	5341	www.fishbase.org	Common	8422	2009-01-01 00:00:00
shortnosed-chimaera	5341	www.fishbase.org	Common	8423	2009-01-01 00:00:00
Hydrolagus	5342	unknown	Primary	8424	2009-01-01 00:00:00
Hydrolagus colliei	5343	(lay and bennett, 1839)	Primary	8425	2009-01-01 00:00:00
spotted-ratfish	5343	amer. fisheries society, 1980	Common	8426	2009-01-01 00:00:00
Hydrolagus trolli	5344	Didier and Séret, 2002	Primary	8427	2009-01-01 00:00:00
Pointy-nosed blue chimaera	5344	unknown	Common	8428	2009-01-01 00:00:00
Rhinochimaeridae	5345	Garman, 1901	Primary	8429	2009-01-01 00:00:00
longnosed-chimaera	5345	unknown	Common	8430	2009-01-01 00:00:00
Harriotta	5346	Goode and Bean, 1895	Primary	8431	2009-01-01 00:00:00
Harriotta raleighana	5347	Goode and Bean, 1895	Primary	8432	2009-01-01 00:00:00
Rhinochimaera	5348	Garman, 1901	Primary	8433	2009-01-01 00:00:00
Neoharriotta	5349	Bigelow and Schroeder, 1950	Primary	8434	2009-01-01 00:00:00
Elasmobranchii	5350	unknown	Primary	8435	2009-01-01 00:00:00
Galeomorphi	5351	unknown	Primary	8436	2009-01-01 00:00:00
galeomorphi	5351	unknown	Synonym	8437	2009-01-01 00:00:00
Lamniformes	5352	unknown	Primary	8438	2009-01-01 00:00:00
Lamnidae	5353	Mueller and Henle, 1838	Primary	8439	2009-01-01 00:00:00
mackerel-shark	5353	compagno, 1984 (f.a.o.)	Common	8440	2009-01-01 00:00:00
Carcharodon	5354	smith, 1838	Primary	8441	2009-01-01 00:00:00
Carcharodon carcharias	5355	(linnaeus, 1758)	Primary	8442	2009-01-01 00:00:00
white-shark	5355	amer. fisheries society, 1980	Common	8443	2009-01-01 00:00:00
great-white-shark	5355	compagno, 1984 (f.a.o.)	Common	8444	2009-01-01 00:00:00
Lamna	5356	Cuvier, 1816	Primary	8445	2009-01-01 00:00:00
Lamna ditropis	5357	Hubbs and Follett, 1947	Primary	8446	2009-01-01 00:00:00
Carcharhiniformes	5358	unknown	Primary	8447	2009-01-01 00:00:00
carcharhiniformes	5358	unknown	Synonym	8448	2009-01-01 00:00:00
Carcharhinidae	5359	unknown	Primary	8449	2009-01-01 00:00:00
carcharhinidae	5359	unknown	Synonym	8450	2009-01-01 00:00:00
Prionace	5360	cantor, 1849	Primary	8451	2009-01-01 00:00:00
prionace	5360	cantor, 1849	Synonym	8452	2009-01-01 00:00:00
Prionace glauca	5361	(linnaeus, 1758)	Primary	8453	2009-01-01 00:00:00
blue-shark	5361	amer. fisheries society, 1980	Common	8454	2009-01-01 00:00:00
prionace-glauca	5361	(linnaeus, 1758)	Synonym	8455	2009-01-01 00:00:00
Scyliorhinidae	5362	gill, 1862	Primary	8456	2009-01-01 00:00:00
cat-shark	5362	unknown	Common	8457	2009-01-01 00:00:00
scyliorhinidae	5362	gill, 1862	Synonym	8458	2009-01-01 00:00:00
Apristurus	5363	garman, 1913	Primary	8459	2009-01-01 00:00:00
apristurus	5363	garman, 1913	Synonym	8460	2009-01-01 00:00:00
Apristurus kampae	5364	taylor, 1972	Primary	8461	2009-01-01 00:00:00
longnose-catshark	5364	compagno, 1984 (f.a.o.)	Common	8462	2009-01-01 00:00:00
apristurus-kampae	5364	taylor, 1972	Synonym	8463	2009-01-01 00:00:00
Apristurus brunneus	5365	(gilbert, 1891)	Primary	8464	2009-01-01 00:00:00
catulus-brunneus	5365	gilbert, 1892	Synonym	8465	2009-01-01 00:00:00
brown-cat-shark	5365	amer. fisheries society, 1980	Common	8466	2009-01-01 00:00:00
apristurus-brunneus	5365	(gilbert, 1891)	Synonym	8467	2009-01-01 00:00:00
Apristurus spongiceps	5366	Gilbert 1905	Primary	8468	2009-01-01 00:00:00
Spongehead catshark	5366		Common	8469	2009-01-01 00:00:00
Parmaturus	5367	garman, 1906	Primary	8470	2009-01-01 00:00:00
parmaturus	5367	garman, 1906	Synonym	8471	2009-01-01 00:00:00
Parmaturus xaniurus	5368	(gilbert, 1892)	Primary	8472	2009-01-01 00:00:00
filetail-cat-shark	5368	amer. fisheries society, 1980	Common	8473	2009-01-01 00:00:00
parmaturus-xaniurus	5368	(gilbert, 1892)	Synonym	8474	2009-01-01 00:00:00
Triakidae	5369	Gray 1851	Primary	8475	2009-01-01 00:00:00
Mustelus	5370	Linck, 1790	Primary	8476	2009-01-01 00:00:00
Mustelus henlei	5371	Brown, 1863	Primary	8477	2009-01-01 00:00:00
brown smoothhound	5371	Gill, 1863	Common	8478	2009-01-01 00:00:00
Squalomorphi	5372	unknown	Primary	8479	2009-01-01 00:00:00
squalomorphi	5372	unknown	Synonym	8480	2009-01-01 00:00:00
Squaliformes	5373	(hart, 1988)	Primary	8481	2009-01-01 00:00:00
squaliformes	5373	(hart, 1988)	Synonym	8482	2009-01-01 00:00:00
Echinorhinidae	5374	unknown	Primary	8483	2009-01-01 00:00:00
echinorhinidae	5374	unknown	Synonym	8484	2009-01-01 00:00:00
Echinorhinus	5375	blainville, 1816	Primary	8485	2009-01-01 00:00:00
echinorhinus	5375	blainville, 1816	Synonym	8486	2009-01-01 00:00:00
Echinorhinus cookei	5376	pietschmann, 1928	Primary	8487	2009-01-01 00:00:00
prickly-shark	5376	amer. fisheries society, 1980	Common	8488	2009-01-01 00:00:00
echinorhinus-cookei	5376	pietschmann, 1928	Synonym	8489	2009-01-01 00:00:00
Squalidae	5377	unknown	Primary	8490	2009-01-01 00:00:00
squalidae	5377	unknown	Synonym	8491	2009-01-01 00:00:00
Squalus	5378	linnaeus, 1758	Primary	8492	2009-01-01 00:00:00
squalus	5378	linnaeus, 1758	Synonym	8493	2009-01-01 00:00:00
Squalus acanthias	5379	smith and radcliff, 1912	Primary	8494	2009-01-01 00:00:00
squalus-suckleyi	5379	unknown	Synonym	8495	2009-01-01 00:00:00
spinax-suckleyi	5379	girard, 1854	Synonym	8496	2009-01-01 00:00:00
acanthias-suckleyi	5379	(girard, 1854)	Synonym	8497	2009-01-01 00:00:00
spiny-dogfish	5379	amer. fisheries society, 1980	Common	8498	2009-01-01 00:00:00
piked-dogfish	5379	compagno, 1984 (f.a.o.)	Common	8499	2009-01-01 00:00:00
squalus-acanthias	5379	smith and radcliff, 1912	Synonym	8500	2009-01-01 00:00:00
Somniosus	5380	unknown	Primary	8501	2009-01-01 00:00:00
somniosus	5380	unknown	Synonym	8502	2009-01-01 00:00:00
Somniosus pacificus	5381	bigelow and schroeder, 1944	Primary	8503	2009-01-01 00:00:00
pacific-sleeper-shark	5381	amer. fisheries society, 1980	Common	8504	2009-01-01 00:00:00
somniosus-pacificus	5381	bigelow and schroeder, 1944	Synonym	8505	2009-01-01 00:00:00
Hexanchiformes	5382	unknown	Primary	8506	2009-01-01 00:00:00
hexanchiformes	5382	unknown	Synonym	8507	2009-01-01 00:00:00
Hexanchidae	5383	gray, 1851	Primary	8508	2009-01-01 00:00:00
cow-shark	5383	compagno, 1984 (f.a.o.)	Common	8509	2009-01-01 00:00:00
hexanchidae	5383	gray, 1851	Synonym	8510	2009-01-01 00:00:00
Hexanchus	5384	rafinesque, 1810	Primary	8511	2009-01-01 00:00:00
notidamus	5384	munster, 1842	Synonym	8512	2009-01-01 00:00:00
hexancus	5384	agassiz, 1846	Synonym	8513	2009-01-01 00:00:00
hexanchias	5384	swainson, 1838	Synonym	8514	2009-01-01 00:00:00
hexanchus	5384	rafinesque, 1810	Synonym	8515	2009-01-01 00:00:00
Hexanchus griseus	5385	(bonnaterre, 1788)	Primary	8516	2009-01-01 00:00:00
sixgill-shark	5385	amer. fisheries society, 1980	Common	8517	2009-01-01 00:00:00
bluntnose-sixgill-shark	5385	compagno, 1984 (f.a.o.)	Common	8518	2009-01-01 00:00:00
hexanchus-griseus	5385	(bonnaterre, 1788)	Synonym	8519	2009-01-01 00:00:00
Notorynchus	5386	ayers, 1855	Primary	8520	2009-01-01 00:00:00
notorynchus	5386	ayers, 1855	Synonym	8521	2009-01-01 00:00:00
Notorynchus maculatus	5387	unknown	Primary	8522	2009-01-01 00:00:00
sevengill-shark-westcoast	5387	unknown	Common	8523	2009-01-01 00:00:00
notorynchus-maculatus	5387	unknown	Synonym	8524	2009-01-01 00:00:00
Notorynchus cepedianus	5388	(ayres, 1855)	Primary	8525	2009-01-01 00:00:00
sevengill-shark	5388	amer. fisheries society, 1980	Common	8526	2009-01-01 00:00:00
bluntnose-sevengill-shark	5388	compagno, 1984 (f.a.o.)	Common	8527	2009-01-01 00:00:00
notorynchus-cepedianus	5388	(ayres, 1855)	Synonym	8528	2009-01-01 00:00:00
Batoidea	5389	unknown	Primary	8529	2009-01-01 00:00:00
batoidea	5389	unknown	Synonym	8530	2009-01-01 00:00:00
Rajiformes	5390	unknown	Primary	8531	2009-01-01 00:00:00
skate	5390	shiino, 1978	Common	8532	2009-01-01 00:00:00
ray	5390	shiino, 1978	Common	8533	2009-01-01 00:00:00
Torpedinidae	5391	unknown	Primary	8534	2009-01-01 00:00:00
torpedo-ray	5391	unknown	Common	8535	2009-01-01 00:00:00
electric-ray	5391	shiino, 1978	Common	8536	2009-01-01 00:00:00
torpedinidae	5391	unknown	Synonym	8537	2009-01-01 00:00:00
Torpedo	5392	houttuyn, 1764	Primary	8538	2009-01-01 00:00:00
torpedo	5392	houttuyn, 1764	Synonym	8539	2009-01-01 00:00:00
Torpedo californica	5393	ayres	Primary	8540	2009-01-01 00:00:00
pacific-electric-ray	5393	amer. fisheries society, 1980	Common	8541	2009-01-01 00:00:00
torpedo-californica	5393	ayres	Synonym	8542	2009-01-01 00:00:00
Rajidae	5394	unknown	Primary	8543	2009-01-01 00:00:00
hardnose skates	5394	unknown	Common	8544	2009-01-01 00:00:00
rajidae	5394	unknown	Synonym	8545	2009-01-01 00:00:00
Raja	5395	unknown	Primary	8546	2009-01-01 00:00:00
raja	5395	unknown	Synonym	8547	2009-01-01 00:00:00
Raja binoculata	5396	girard	Primary	8548	2009-01-01 00:00:00
big-skate	5396	amer. fisheries society, 1980	Common	8549	2009-01-01 00:00:00
raja-binoculata	5396	girard	Synonym	8550	2009-01-01 00:00:00
Raja inornata	5397	jordan,gilbert	Primary	8551	2009-01-01 00:00:00
california-skate	5397	amer. fisheries society, 1980	Common	8552	2009-01-01 00:00:00
raja-inornata	5397	jordan,gilbert	Synonym	8553	2009-01-01 00:00:00
Raja rhina	5398	(jordan and gilbert, 1880)	Primary	8554	2009-01-01 00:00:00
longnose-skate	5398	amer. fisheries society, 1980	Common	8555	2009-01-01 00:00:00
raja-rhina	5398	(jordan and gilbert, 1880)	Synonym	8556	2009-01-01 00:00:00
Raja stellulata	5399	(jordan and gilbert, 1880)	Primary	8557	2009-01-01 00:00:00
starry-skate	5399	amer. fisheries society, 1980	Common	8558	2009-01-01 00:00:00
raja-stellulata	5399	(jordan and gilbert, 1880)	Synonym	8559	2009-01-01 00:00:00
Amblyraja	5400	Malm, 1877	Primary	8560	2009-01-01 00:00:00
amblyraja	5400	Malm, 1877	Synonym	8561	2009-01-01 00:00:00
Amblyraja badia	5401	(Garman, 1899)	Primary	8562	2009-01-01 00:00:00
broad skate	5401	unknown	Common	8563	2009-01-01 00:00:00
amblyraja badia	5401	(Garman, 1899)	Synonym	8564	2009-01-01 00:00:00
Arhynchobatidae	5402	unknown	Primary	8565	2009-01-01 00:00:00
softnose skates	5402	unknown	Common	8566	2009-01-01 00:00:00
Bathyraja	5403	unknown	Primary	8567	2009-01-01 00:00:00
Bathyraja trachura	5404	Gilbert, 1892	Primary	8568	2009-01-01 00:00:00
black-skate	5404	unknown	Common	8569	2009-01-01 00:00:00
roughtail skate	5404	unknown	Common	8570	2009-01-01 00:00:00
bathyraja-trachura	5404	Gilbert, 1892	Synonym	8571	2009-01-01 00:00:00
Bathyraja spinosissima	5405	(Beebe and Tee-van,1941)	Primary	8572	2009-01-01 00:00:00
white-skate	5405	unknown	Common	8573	2009-01-01 00:00:00
pacific-white-skate	5405	unknown	Common	8574	2009-01-01 00:00:00
bathyraja-spinosissima	5405	(Beebe and Tee-van,1941)	Synonym	8575	2009-01-01 00:00:00
Bathyraja abyssicola	5406	(Gilbert, 1896)	Primary	8576	2009-01-01 00:00:00
deepsea skate	5406	Shiino, 1978	Common	8577	2009-01-01 00:00:00
Raja abyssicola	5406	unknown	Synonym	8578	2009-01-01 00:00:00
bathyraja abyssicola	5406	(Gilbert, 1896)	Synonym	8579	2009-01-01 00:00:00
Bathyraja microtrachys	5407	Osburn and Nichols, 1916	Primary	8580	2009-01-01 00:00:00
fine-spined skate	5407	unknown	Common	8581	2009-01-01 00:00:00
bathyraja microtrachys	5407	Osburn and Nichols, 1916	Synonym	8582	2009-01-01 00:00:00
Bathyraja kincaidii	5408	(Garman, 1908)	Primary	8583	2009-01-01 00:00:00
sandpaper-skate	5408	unknown	Common	8584	2009-01-01 00:00:00
Raja kincaidii	5408	unknown	Synonym	8585	2009-01-01 00:00:00
bathyraja kincaidii	5408	(Garman, 1908)	Synonym	8586	2009-01-01 00:00:00
Bathyraja aleutica	5409	unknown	Primary	8587	2009-01-01 00:00:00
Bathyraja cf. microtrachys	5410	\N	Primary	8588	2009-01-01 00:00:00
Arhynchobatidae sp. A	5411	\N	Primary	8589	2009-01-01 00:00:00
Arhynchobatidae sp. B	5412	\N	Primary	8590	2009-01-01 00:00:00
Arhynchobatidae sp. C	5413	\N	Primary	8591	2009-01-01 00:00:00
Myliobatiformes	5414	unknown	Primary	8592	2009-01-01 00:00:00
myliobatiformes	5414	unknown	Synonym	8593	2009-01-01 00:00:00
Plesiobatidae	5415	unknown	Primary	8594	2009-01-01 00:00:00
plesiobatidae	5415	unknown	Synonym	8595	2009-01-01 00:00:00
Plesiobatis	5416	unknown	Primary	8596	2009-01-01 00:00:00
plesiobatis	5416	unknown	Synonym	8597	2009-01-01 00:00:00
Plesiobatis daviesi	5417	(Wallace, 1967)	Primary	8598	2009-01-01 00:00:00
plesiobatis daviesi	5417	(Wallace, 1967)	Synonym	8599	2009-01-01 00:00:00
Hexatrygonidae	5418	unknown	Primary	8600	2009-01-01 00:00:00
Hexatrygon bickelli	5419	unknown	Primary	8601	2009-01-01 00:00:00
Hexatrygon	5420	unknown	Primary	8602	2009-01-01 00:00:00
Dasyatidae	5421	unknown	Primary	8603	2009-01-01 00:00:00
Dasyatis	5422	unknown	Primary	8604	2009-01-01 00:00:00
Urochordata	5423	unknown	Primary	8605	2009-01-01 00:00:00
tunicate	5423	unknown	Common	8606	2009-01-01 00:00:00
sea-squirt	5423	(n.o.d.c.)	Common	8607	2009-01-01 00:00:00
Thaliacea	5424	unknown	Primary	8608	2009-01-01 00:00:00
Doliolida	5425	unknown	Primary	8609	2009-01-01 00:00:00
doliolida	5425	unknown	Synonym	8610	2009-01-01 00:00:00
Doliolidae	5426	unknown	Primary	8611	2009-01-01 00:00:00
doliolidae	5426	unknown	Synonym	8612	2009-01-01 00:00:00
Dolioletta	5427	unknown	Primary	8613	2009-01-01 00:00:00
dolioletta	5427	unknown	Synonym	8614	2009-01-01 00:00:00
Doliolenetta	5428	unknown	Primary	8615	2009-01-01 00:00:00
doliolenetta	5428	unknown	Synonym	8616	2009-01-01 00:00:00
Doliopsidina	5429	unknown	Primary	8617	2009-01-01 00:00:00
doliopsidina	5429	unknown	Synonym	8618	2009-01-01 00:00:00
Doliopsidae	5430	unknown	Primary	8619	2009-01-01 00:00:00
doliopsidae	5430	unknown	Synonym	8620	2009-01-01 00:00:00
Doliolum	5431	unknown	Primary	8621	2009-01-01 00:00:00
doliolum	5431	unknown	Synonym	8622	2009-01-01 00:00:00
Doliolula	5432	unknown	Primary	8623	2009-01-01 00:00:00
doliolula	5432	unknown	Synonym	8624	2009-01-01 00:00:00
Doliolula equus	5433	unknown	Primary	8625	2009-01-01 00:00:00
doliolula equus	5433	unknown	Synonym	8626	2009-01-01 00:00:00
Doliolunidae	5434	unknown	Primary	8627	2009-01-01 00:00:00
doliolunidae	5434	unknown	Synonym	8628	2009-01-01 00:00:00
Pseudusa	5435	unknown	Primary	8629	2009-01-01 00:00:00
pseudusa	5435	unknown	Synonym	8630	2009-01-01 00:00:00
Pseudusa bostgrinus	5436	unknown	Primary	8631	2009-01-01 00:00:00
pseudusa bostgrinus	5436	unknown	Synonym	8632	2009-01-01 00:00:00
Paradoliopsidae	5437	unknown	Primary	8633	2009-01-01 00:00:00
paradoliopsidae	5437	unknown	Synonym	8634	2009-01-01 00:00:00
Paradoliopsis	5438	unknown	Primary	8635	2009-01-01 00:00:00
paradoliopsis	5438	unknown	Synonym	8636	2009-01-01 00:00:00
Paradoliopsis harbisoni	5439	unknown	Primary	8637	2009-01-01 00:00:00
paradoliopsis harbisoni	5439	unknown	Synonym	8638	2009-01-01 00:00:00
Salpida	5440	unknown	Primary	8639	2009-01-01 00:00:00
salp-chain	5440	unknown	Common	8640	2009-01-01 00:00:00
salp	5440	unknown	Common	8641	2009-01-01 00:00:00
Salpidae	5441	unknown	Primary	8642	2009-01-01 00:00:00
Thetys	5442	unknown	Primary	8643	2009-01-01 00:00:00
thetys	5442	unknown	Synonym	8644	2009-01-01 00:00:00
Thetys vagina	5443	unknown	Primary	8645	2009-01-01 00:00:00
thetys-vagina	5443	unknown	Synonym	8646	2009-01-01 00:00:00
Pegea	5444	unknown	Primary	8647	2009-01-01 00:00:00
pegea	5444	unknown	Synonym	8648	2009-01-01 00:00:00
Pegea confoederata	5445	(Forskaal, 1774)	Primary	8649	2009-01-01 00:00:00
pegea-confoederata	5445	(Forskaal, 1774)	Synonym	8650	2009-01-01 00:00:00
Pegea socia	5446	unknown	Primary	8651	2009-01-01 00:00:00
pegea-socia	5446	unknown	Synonym	8652	2009-01-01 00:00:00
Thalia	5447	unknown	Primary	8653	2009-01-01 00:00:00
thalia	5447	unknown	Synonym	8654	2009-01-01 00:00:00
Thalia democratica	5448	forskaal, 1775	Primary	8655	2009-01-01 00:00:00
thalia-democratica	5448	forskaal, 1775	Synonym	8656	2009-01-01 00:00:00
Salpa	5449	Forskål, 1775	Primary	8657	2009-01-01 00:00:00
salpa	5449	Forskål, 1775	Synonym	8658	2009-01-01 00:00:00
Salpa fusiformis	5450	unknown	Primary	8659	2009-01-01 00:00:00
salpa fusiformis	5450	unknown	Synonym	8660	2009-01-01 00:00:00
Cyclosalpa	5451	unknown	Primary	8661	2009-01-01 00:00:00
salp-ring	5451	unknown	Common	8662	2009-01-01 00:00:00
cyclosalpa	5451	unknown	Synonym	8663	2009-01-01 00:00:00
lasis	5452	unknown	Primary	8664	2009-01-01 00:00:00
lasis-zonaria	5453	unknown	Primary	8665	2009-01-01 00:00:00
Vitreosalpa	5454	Madin and Madin, 2004	Primary	8666	2009-01-01 00:00:00
Vitreosalpa gemini	5455	Madin and Madin, 2004	Primary	8667	2009-01-01 00:00:00
Lasis	5456	Pallas, 1774	Primary	8668	2009-01-01 00:00:00
Iasis	5456	Pallas, 1774	Synonym	8669	2009-01-01 00:00:00
Lasis zonaria	5457	Pallas, 1774	Primary	8670	2009-01-01 00:00:00
Iasis zonaria	5457	Pallas, 1774	Synonym	8671	2009-01-01 00:00:00
Helicosalpa	5458	Todaro, 1902	Primary	8672	2009-01-01 00:00:00
Helicosalpa virgula	5459	Vogt, 1854	Primary	8673	2009-01-01 00:00:00
Pyrosomida	5460	unknown	Primary	8674	2009-01-01 00:00:00
pyrosomida	5460	unknown	Synonym	8675	2009-01-01 00:00:00
Pyrosomatidae	5461	unknown	Primary	8676	2009-01-01 00:00:00
pyrosomatidae	5461	unknown	Synonym	8677	2009-01-01 00:00:00
Pyrosoma	5462	unknown	Primary	8678	2009-01-01 00:00:00
pyrosoma	5462	unknown	Synonym	8679	2009-01-01 00:00:00
Pyrosoma atlanticum	5463	unknown	Primary	8680	2009-01-01 00:00:00
pyrosoma-atlanticum	5463	unknown	Synonym	8681	2009-01-01 00:00:00
Doliolida 2	5464	unknown	Primary	8682	2009-01-01 00:00:00
doliolida-contains-tail	5464	unknown	Common	8683	2009-01-01 00:00:00
doliolida-2	5464	unknown	Synonym	8684	2009-01-01 00:00:00
Ascidiacea	5465	unknown	Primary	8685	2009-01-01 00:00:00
sessile-tunicate	5465	unknown	Common	8686	2009-01-01 00:00:00
ascidian	5465	(n.o.d.c.)	Common	8687	2009-01-01 00:00:00
Stolidobranchiata	5466	unknown	Primary	8688	2009-01-01 00:00:00
stolidobranchiata	5466	unknown	Synonym	8689	2009-01-01 00:00:00
Stylelidae	5467	unknown	Primary	8690	2009-01-01 00:00:00
stylelidae	5467	unknown	Synonym	8691	2009-01-01 00:00:00
Pleurogona	5468	unknown	Primary	8692	2009-01-01 00:00:00
pleurogona	5468	unknown	Synonym	8693	2009-01-01 00:00:00
Stolidobranchia	5469	Lahille, 1887	Primary	8694	2009-01-01 00:00:00
Stolidobranchiata (suborder)	5469	unknown	Synonym	8695	2009-01-01 00:00:00
stolidobranchia	5469	Lahille, 1887	Synonym	8696	2009-01-01 00:00:00
Pyuridae	5470	Hartmeyer, 1908	Primary	8697	2009-01-01 00:00:00
pyuridae	5470	Hartmeyer, 1908	Synonym	8698	2009-01-01 00:00:00
Boltenia	5471	Savigny, 1816	Primary	8699	2009-01-01 00:00:00
boltenia	5471	Savigny, 1816	Synonym	8700	2009-01-01 00:00:00
Boltenia villosa	5472	(stimpson, 1864)	Primary	8701	2009-01-01 00:00:00
boltenia-villosa	5472	(stimpson, 1864)	Synonym	8702	2009-01-01 00:00:00
Boltenia echinata	5473	(linnaeus, 1767)	Primary	8703	2009-01-01 00:00:00
boltenia-echinata	5473	(linnaeus, 1767)	Synonym	8704	2009-01-01 00:00:00
Culeolus	5474	Herdman, 1881	Primary	8705	2009-01-01 00:00:00
culeolus	5474	Herdman, 1881	Synonym	8706	2009-01-01 00:00:00
Styelidae	5475	Sluiter, 1895	Primary	8707	2009-01-01 00:00:00
botryllidae	5475	verrill, 1871	Synonym	8708	2009-01-01 00:00:00
styelidae	5475	Sluiter, 1895	Synonym	8709	2009-01-01 00:00:00
Cnemidocarpa	5476	Huntsman, 1913	Primary	8710	2009-01-01 00:00:00
cnemidocarpa	5476	Huntsman, 1913	Synonym	8711	2009-01-01 00:00:00
Cnemidocarpa finmarkiensis	5477	unknown	Primary	8712	2009-01-01 00:00:00
cnemidocarpa-finmarkiensis	5477	unknown	Synonym	8713	2009-01-01 00:00:00
Enterogona 	5478	unknown	Primary	8714	2009-01-01 00:00:00
enterogona 	5478	unknown	Synonym	8715	2009-01-01 00:00:00
Aplousobranchia	5479	unknown	Primary	8716	2009-01-01 00:00:00
aplousobranchia	5479	unknown	Synonym	8717	2009-01-01 00:00:00
Didemnidae	5480	verrill, 1871	Primary	8718	2009-01-01 00:00:00
didemnidae	5480	verrill, 1871	Synonym	8719	2009-01-01 00:00:00
Didemnum	5481	savigny, 1816	Primary	8720	2009-01-01 00:00:00
didemnum	5481	savigny, 1816	Synonym	8721	2009-01-01 00:00:00
Diplosoma	5482	macdonald, 1859	Primary	8722	2009-01-01 00:00:00
diplosoma	5482	macdonald, 1859	Synonym	8723	2009-01-01 00:00:00
Clavelinidae	5483	unknown	Primary	8724	2009-01-01 00:00:00
clavelinidae	5483	unknown	Synonym	8725	2009-01-01 00:00:00
Cystodytes	5484	unknown	Primary	8726	2009-01-01 00:00:00
cystodytes	5484	unknown	Synonym	8727	2009-01-01 00:00:00
Phlebobranchia	5485	unknown	Primary	8728	2009-01-01 00:00:00
phlebobranchia	5485	unknown	Synonym	8729	2009-01-01 00:00:00
Octacnemidae	5486	unknown	Primary	8730	2009-01-01 00:00:00
octacnemidae	5486	unknown	Synonym	8731	2009-01-01 00:00:00
Megalodicopia	5487	unknown	Primary	8732	2009-01-01 00:00:00
megalodicopia	5487	unknown	Synonym	8733	2009-01-01 00:00:00
Megalodicopia hians	5488	unknown	Primary	8734	2009-01-01 00:00:00
megalodicopia-hians	5488	unknown	Synonym	8735	2009-01-01 00:00:00
Appendicularia	5489	unknown	Primary	8736	2009-01-01 00:00:00
larvacean	5489	unknown	Common	8737	2009-01-01 00:00:00
Larvacea	5489	unknown	Synonym	8738	2009-01-01 00:00:00
pelagic-tunicate	5489	(n.o.d.c.)	Common	8739	2009-01-01 00:00:00
Fritillariidae	5490	unknown	Primary	8740	2009-01-01 00:00:00
fritillariidae	5490	unknown	Synonym	8741	2009-01-01 00:00:00
Fritillariinae	5491	unknown	Primary	8742	2009-01-01 00:00:00
Tectillaria	5492	unknown	Primary	8743	2009-01-01 00:00:00
Fritillaria	5493	unknown	Primary	8744	2009-01-01 00:00:00
hammerhead-larvacean	5493	unknown	Common	8745	2009-01-01 00:00:00
Kowalevskiidae	5494	unknown	Primary	8746	2009-01-01 00:00:00
kowalevskiidae	5494	unknown	Synonym	8747	2009-01-01 00:00:00
Kowalevskia	5495	unknown	Primary	8748	2009-01-01 00:00:00
kowalevskia	5495	unknown	Synonym	8749	2009-01-01 00:00:00
Oikopleuridae	5496	unknown	Primary	8750	2009-01-01 00:00:00
Bathochordaeinae	5497	unknown	Primary	8751	2009-01-01 00:00:00
Bathochordaeus	5498	unknown	Primary	8752	2009-01-01 00:00:00
bathochordaeus	5498	unknown	Synonym	8753	2009-01-01 00:00:00
Bathochordaeus stygius	5499	unknown	Primary	8754	2009-01-01 00:00:00
giant-larvacean	5499	unknown	Common	8755	2009-01-01 00:00:00
bathochordaeus-stygius	5499	unknown	Synonym	8756	2009-01-01 00:00:00
Mesochordaeus	5500	unknown	Primary	8757	2009-01-01 00:00:00
Mesochordaeus erythrocephalus	5501	unknown	Primary	8758	2009-01-01 00:00:00
redhead-larvacean	5501	unknown	Common	8759	2009-01-01 00:00:00
redhead-oikopleurid	5501	unknown	Synonym	8760	2009-01-01 00:00:00
mesochordaeus-erythrocephalus	5501	unknown	Synonym	8761	2009-01-01 00:00:00
Oikopleurinae	5502	unknown	Primary	8762	2009-01-01 00:00:00
Oikopleura	5503	unknown	Primary	8763	2009-01-01 00:00:00
Oikopleura villafrancae	5504	unknown	Primary	8764	2009-01-01 00:00:00
Mesoikopleura	5505	unknown	Primary	8765	2009-01-01 00:00:00
Sorberacea	5506	unknown	Primary	8766	2009-01-01 00:00:00
Arthropoda	5507	unknown	Primary	8767	2009-01-01 00:00:00
Insecta	5508	unknown	Primary	8768	2009-01-01 00:00:00
insect	5508	(n.o.d.c.)	Common	8769	2009-01-01 00:00:00
Crustacea	5509	unknown	Primary	8770	2009-01-01 00:00:00
Malacostraca	5510	unknown	Primary	8771	2009-01-01 00:00:00
Phyllocarida	5511	Packard, 1879	Primary	8772	2009-01-01 00:00:00
Leptostraca	5512	Claus, 1880	Primary	8773	2009-01-01 00:00:00
sea flea	5512	http://tolweb.org/Leptostraca/6296	Common	8774	2009-01-01 00:00:00
Nebaliidae	5513	Samouelle, 1819	Primary	8775	2009-01-01 00:00:00
Nebalia	5514	Leach, 1814	Primary	8776	2009-01-01 00:00:00
Nebaliopsididae	5515	Hessler, 1984	Primary	8777	2009-01-01 00:00:00
Nebaliopsis	5516	G. O. Sars, 1887  	Primary	8778	2009-01-01 00:00:00
Eumalacostraca	5517	unknown	Primary	8779	2009-01-01 00:00:00
Eucarida	5518	unknown	Primary	8780	2009-01-01 00:00:00
Euphausiacea	5519	unknown	Primary	8781	2009-01-01 00:00:00
krill	5519	(n.o.d.c.)	Common	8782	2009-01-01 00:00:00
Euphausiidae	5520	unknown	Primary	8783	2009-01-01 00:00:00
Euphausia 2	5521	unknown	Primary	8784	2009-01-01 00:00:00
Euphausia-krill-swarm	5521	unknown	Common	8785	2009-01-01 00:00:00
krill-swarm	5521	unknown	Common	8786	2009-01-01 00:00:00
Euphausia	5522	unknown	Primary	8787	2009-01-01 00:00:00
Euphausia-individual	5522	unknown	Common	8788	2009-01-01 00:00:00
Euphausia pacifica	5523	hansen, 1911	Primary	8789	2009-01-01 00:00:00
Decapoda	5524	unknown	Primary	8790	2009-01-01 00:00:00
shrimp	5524	unknown	Common	8791	2009-01-01 00:00:00
prawn	5524	unknown	Common	8792	2009-01-01 00:00:00
lobster	5524	unknown	Common	8793	2009-01-01 00:00:00
crayfish	5524	unknown	Common	8794	2009-01-01 00:00:00
crab	5524	(n.o.d.c.)	Common	8795	2009-01-01 00:00:00
Sergestoidea	5525	unknown	Primary	8796	2009-01-01 00:00:00
Sergestidae	5526	dana, 1852	Primary	8797	2009-01-01 00:00:00
Sergestes	5527	unknown	Primary	8798	2009-01-01 00:00:00
Sergestes similis	5528	hansen, 1903	Primary	8799	2009-01-01 00:00:00
angler-shrimp	5528	unknown	Common	8800	2009-01-01 00:00:00
Sergia	5529	unknown	Primary	8801	2009-01-01 00:00:00
Palinura	5530	unknown	Primary	8802	2009-01-01 00:00:00
Eryonoidea	5531	de Haan, 1841	Primary	8803	2009-01-01 00:00:00
Polychelidae 2	5532	unknown	Primary	8804	2009-01-01 00:00:00
eryoneicus-larvae	5532	unknown	Synonym	8805	2009-01-01 00:00:00
Polychelidae	5533	Wood-Mason, 1874	Primary	8806	2009-01-01 00:00:00
Polycheles	5534	Heller, 1862	Primary	8807	2009-01-01 00:00:00
Thalassinidea	5535	unknown	Primary	8808	2009-01-01 00:00:00
mud-shrimp	5535	unknown	Common	8809	2009-01-01 00:00:00
Thalassinoidea	5536	unknown	Primary	8810	2009-01-01 00:00:00
Callianassidae	5537	unknown	Primary	8811	2009-01-01 00:00:00
ghost-shrimp	5537	amer. fisheries society, 1991	Common	8812	2009-01-01 00:00:00
Neotrypaea	5538	Manning and Felder, 1991	Primary	8813	2009-01-01 00:00:00
Neotrypaea californiensis	5539	(Dana, 1854)	Primary	8814	2009-01-01 00:00:00
bay-ghost-shrimp	5539	unknown	Common	8815	2009-01-01 00:00:00
Brachyura	5540	unknown	Primary	8816	2009-01-01 00:00:00
true-crab	5540	unknown	Common	8817	2009-01-01 00:00:00
Cancroidea	5541	unknown	Primary	8818	2009-01-01 00:00:00
Cancridae	5542	unknown	Primary	8819	2009-01-01 00:00:00
rock-crab	5542	amer. fisheries society, 1991	Common	8820	2009-01-01 00:00:00
Cancer	5543	unknown	Primary	8821	2009-01-01 00:00:00
Cancer magister	5544	dana, 1852	Primary	8822	2009-01-01 00:00:00
Dungeness-crab	5544	American Fisheries Society, 1991	Common	8823	2009-01-01 00:00:00
Majoidea	5545	unknown	Primary	8824	2009-01-01 00:00:00
Majidae	5546	unknown	Primary	8825	2009-01-01 00:00:00
decorator-crab	5546	unknown	Common	8826	2009-01-01 00:00:00
Loxorhynchus	5547	unknown	Primary	8827	2009-01-01 00:00:00
Loxorhynchus crispatus	5548	stimpson, 1857	Primary	8828	2009-01-01 00:00:00
moss-crab	5548	amer. fisheries society, 1991	Common	8829	2009-01-01 00:00:00
Chionoecetes	5549	unknown	Primary	8830	2009-01-01 00:00:00
Chionoecetes tanneri	5550	rathbun, 1893	Primary	8831	2009-01-01 00:00:00
grooved-tanner-crab	5550	amer. fisheries society, 1991	Common	8832	2009-01-01 00:00:00
Chionoecetes opilio	5551	(fabricius, 1788)	Primary	8833	2009-01-01 00:00:00
snow-crab	5551	amer. fisheries society, 1991	Common	8834	2009-01-01 00:00:00
Chionoecetes bairdi	5552	rathbun, 1924	Primary	8835	2009-01-01 00:00:00
tanner-crab	5552	amer. fisheries society, 1991	Common	8836	2009-01-01 00:00:00
Chorilia	5553	unknown	Primary	8837	2009-01-01 00:00:00
Chorilia longipes	5554	dana, 1851	Primary	8838	2009-01-01 00:00:00
longhorn-decorator-crab	5554	amer. fisheries society, 1991	Common	8839	2009-01-01 00:00:00
Macroregonia	5555	unknown	Primary	8840	2009-01-01 00:00:00
Macroregonia macrochira	5556	unknown	Primary	8841	2009-01-01 00:00:00
Macroregonia	5557	unknown	Primary	8842	2009-01-01 00:00:00
Bythograeoidea	5558	Williams, 1980	Primary	8843	2009-01-01 00:00:00
Bythograeidae	5559	Williams, 1980	Primary	8844	2009-01-01 00:00:00
Bythograea	5560	Williams, AB., 1980	Primary	8845	2009-01-01 00:00:00
Bythograea thermydron	5561	Williams, AB., 1980	Primary	8846	2009-01-01 00:00:00
Anomura	5562	unknown	Primary	8847	2009-01-01 00:00:00
Paguroidea	5563	unknown	Primary	8848	2009-01-01 00:00:00
Parapaguridae	5564	Smith, 1882	Primary	8849	2009-01-01 00:00:00
Probeebeidae	5564	Smith, 1882	Synonym	8850	2009-01-01 00:00:00
deep-sea hermit crab	5564		Common	8851	2009-01-01 00:00:00
Probeebei	5565	Boone, 1926	Primary	8852	2009-01-01 00:00:00
Probeebei mirabilis	5566	Boone, 1926	Primary	8853	2009-01-01 00:00:00
Diogenidae	5567	unknown	Primary	8854	2009-01-01 00:00:00
hermit-crab	5567	unknown	Common	8855	2009-01-01 00:00:00
left-handed-hermit-crab	5567	amer. fisheries society, 1991	Common	8856	2009-01-01 00:00:00
Paguristes	5568	unknown	Primary	8857	2009-01-01 00:00:00
Lithodidae	5569	unknown	Primary	8858	2009-01-01 00:00:00
king-crab	5569	amer. fisheries society, 1991	Common	8859	2009-01-01 00:00:00
stone-crab	5569	amer. fisheries society, 1991	Common	8860	2009-01-01 00:00:00
Paralithodes	5570	unknown	Primary	8861	2009-01-01 00:00:00
Paralithodes rathbuni	5571	(benedict, 1894)	Primary	8862	2009-01-01 00:00:00
Paralithodes californiensis	5572	Benedict, 1894	Primary	8863	2009-01-01 00:00:00
California-king-crab	5572	unknown	Common	8864	2009-01-01 00:00:00
Lopholithodes	5573	unknown	Primary	8865	2009-01-01 00:00:00
Lopholithodes foraminatus	5574	(stimpson, 1859)	Primary	8866	2009-01-01 00:00:00
box-crab	5574	unknown	Common	8867	2009-01-01 00:00:00
Neolithodes diomedae	5575	unknown	Primary	8868	2009-01-01 00:00:00
Lithodes	5576	unknown	Primary	8869	2009-01-01 00:00:00
Paralomis	5577	unknown	Primary	8870	2009-01-01 00:00:00
Paralomis verrilli	5578	unknown	Primary	8871	2009-01-01 00:00:00
vermillion-crab	5578	unknown	Common	8872	2009-01-01 00:00:00
Paralomis multispina	5579	Benedict, 1894	Primary	8873	2009-01-01 00:00:00
Oregon-hair-crab	5579	unknown	Common	8874	2009-01-01 00:00:00
Neolithodes	5580	unknown	Primary	8875	2009-01-01 00:00:00
Galatheoidea	5581	unknown	Primary	8876	2009-01-01 00:00:00
Galatheidae	5582	unknown	Primary	8877	2009-01-01 00:00:00
squat-lobster	5582	amer. fisheries society	Common	8878	2009-01-01 00:00:00
Galathea	5583	unknown	Primary	8879	2009-01-01 00:00:00
Galathea californiensis	5584	unknown	Primary	8880	2009-01-01 00:00:00
Munida	5585	unknown	Primary	8881	2009-01-01 00:00:00
Munida hispida	5586	unknown	Primary	8882	2009-01-01 00:00:00
Munida quadrispina	5587	benedict, 1902	Primary	8883	2009-01-01 00:00:00
Pleuroncodes	5588	unknown	Primary	8884	2009-01-01 00:00:00
Pleuroncodes planipes	5589	Stimpson, 1860	Primary	8885	2009-01-01 00:00:00
pelagic-red-crab	5589	unknown	Common	8886	2009-01-01 00:00:00
Munidopsis	5590	unknown	Primary	8887	2009-01-01 00:00:00
Munidopsis spp	5591	Whiteaves, 1874	Primary	8888	2009-01-01 00:00:00
Caridea	5592	unknown	Primary	8889	2009-01-01 00:00:00
Oplophoridae	5593	Dana, 1852	Primary	8890	2009-01-01 00:00:00
deep-sea shrimp	5593	unknown	Common	8891	2009-01-01 00:00:00
Systellaspis	5594	Bate, 1888	Primary	8892	2009-01-01 00:00:00
Systellaspis braueri	5595	Balss, 1914	Primary	8893	2009-01-01 00:00:00
quayle spinytail	5595	unknown	Common	8894	2009-01-01 00:00:00
Systellaspis braueri paucispinosa	5596	unknown	Primary	8895	2009-01-01 00:00:00
Systellaspis cristata	5597	Faxon, 1893	Primary	8896	2009-01-01 00:00:00
Acanthephyra	5598	unknown	Primary	8897	2009-01-01 00:00:00
Pandaloidea	5599	unknown	Primary	8898	2009-01-01 00:00:00
Pandalidae	5600	haworth, 1925	Primary	8899	2009-01-01 00:00:00
Pandalus	5601	unknown	Primary	8900	2009-01-01 00:00:00
Pandalus jordani	5602	rathbun, 1902	Primary	8901	2009-01-01 00:00:00
ocean-shrimp	5602	amer. fisheries society, 1991	Common	8902	2009-01-01 00:00:00
Pandalus platyceros	5603	brandt, 1851	Primary	8903	2009-01-01 00:00:00
spot-prawn	5603	unknown	Common	8904	2009-01-01 00:00:00
spot-shrimp	5603	amer. fisheries society, 1991	Common	8905	2009-01-01 00:00:00
Pandalopsis	5604	Bate, 1888	Primary	8906	2009-01-01 00:00:00
Pandalopsis ampla	5605	Bate, 1888	Primary	8907	2009-01-01 00:00:00
deepwater bigeye	5605	www.itis.usda.gov	Common	8908	2009-01-01 00:00:00
Pasiphaeoidea	5606	unknown	Primary	8909	2009-01-01 00:00:00
Pasiphaeidae	5607	dana, 1852	Primary	8910	2009-01-01 00:00:00
glass-shrimp	5607	amer. fisheries society, 1991	Common	8911	2009-01-01 00:00:00
Pasiphaea	5608	unknown	Primary	8912	2009-01-01 00:00:00
Pasiphaea emarginata	5609	unknown	Primary	8913	2009-01-01 00:00:00
Pasiphaea pacifica	5610	unknown	Primary	8914	2009-01-01 00:00:00
Caridea sp.1	5611	unknown	Primary	8915	2009-01-01 00:00:00
Peracarida	5612	unknown	Primary	8916	2009-01-01 00:00:00
Mysidacea	5613	unknown	Primary	8917	2009-01-01 00:00:00
opossom-shrimp	5613	(n.o.d.c.)	Common	8918	2009-01-01 00:00:00
Lophogastrida	5614	unknown	Primary	8919	2009-01-01 00:00:00
Lophogastridae	5615	unknown	Primary	8920	2009-01-01 00:00:00
Gnathophausia	5616	unknown	Primary	8921	2009-01-01 00:00:00
Gnathophausia ingens	5617	unknown	Primary	8922	2009-01-01 00:00:00
Mysida	5618	unknown	Primary	8923	2009-01-01 00:00:00
Mysidae 2	5619	unknown	Primary	8924	2009-01-01 00:00:00
Mysidae-red-colored	5619	unknown	Common	8925	2009-01-01 00:00:00
Mysidae	5620	unknown	Primary	8926	2009-01-01 00:00:00
Mysis	5621	unknown	Primary	8927	2009-01-01 00:00:00
Mysidella	5622	unknown	Primary	8928	2009-01-01 00:00:00
Mysidella americana	5623	unknown	Primary	8929	2009-01-01 00:00:00
golden-eye-mysid	5623	unknown	Common	8930	2009-01-01 00:00:00
Boreomysis	5624	unknown	Primary	8931	2009-01-01 00:00:00
Amphipoda	5625	unknown	Primary	8932	2009-01-01 00:00:00
Hyperiidea	5626	unknown	Primary	8933	2009-01-01 00:00:00
Vibilioidea	5627	unknown	Primary	8934	2009-01-01 00:00:00
Cystisomatidae	5628	unknown	Primary	8935	2009-01-01 00:00:00
Cystisoma	5629	unknown	Primary	8936	2009-01-01 00:00:00
Cystisoma pellucida	5630	Willemöes-Suhm, 1873	Primary	8937	2009-01-01 00:00:00
Cystisoma pellucidum	5630	unknown	Synonym	8938	2009-01-01 00:00:00
Cystisoma fabricii	5631	unknown	Primary	8939	2009-01-01 00:00:00
Cystisoma magna	5632	Woltereck, 1903	Primary	8940	2009-01-01 00:00:00
Paraphronimidae	5633	Bovallius, 1887	Primary	8941	2009-01-01 00:00:00
Paraphronima	5634	Claus, 1879	Primary	8942	2009-01-01 00:00:00
Physocephalata	5635	Bowman & Gruner, 1973	Primary	8943	2009-01-01 00:00:00
Phronimoidea	5636	Rafinesque, 1815	Primary	8944	2009-01-01 00:00:00
Phronimidae	5637	unknown	Primary	8945	2009-01-01 00:00:00
Phronima	5638	unknown	Primary	8946	2009-01-01 00:00:00
Phronima sedentaria	5639	(forskaal 1775)	Primary	8947	2009-01-01 00:00:00
barrel-amphipod	5639	unknown	Common	8948	2009-01-01 00:00:00
Hyperiidae	5640	unknown	Primary	8949	2009-01-01 00:00:00
hyperiid-amphipod	5640	unknown	Common	8950	2009-01-01 00:00:00
Oxycephalidae	5641	unknown	Primary	8951	2009-01-01 00:00:00
Streetsia	5642	unknown	Primary	8952	2009-01-01 00:00:00
Streetsia pronoides	5643	unknown	Primary	8953	2009-01-01 00:00:00
Iulopididae	5644	Zeidler, 2004	Primary	8954	2009-01-01 00:00:00
Iulopididae	5644	Zeidler, 2004	Synonym	8955	2009-01-01 00:00:00
Lulopididae	5644	Zeidler, 2004	Synonym	8956	2009-01-01 00:00:00
Iulopis	5645	Bovallius, 1887	Primary	8957	2009-01-01 00:00:00
Iulopis	5645	Bovallius, 1887	Synonym	8958	2009-01-01 00:00:00
Lulopis	5645	Bovallius, 1887	Synonym	8959	2009-01-01 00:00:00
Physosomata	5646	Pirlot, 1929	Primary	8960	2009-01-01 00:00:00
Lanceoloidea	5647	Bovallius, 1887	Primary	8961	2009-01-01 00:00:00
Lanceolidae	5648	Bovallius, 1887	Primary	8962	2009-01-01 00:00:00
Lanceola	5649	Say, 1818	Primary	8963	2009-01-01 00:00:00
Scypholanceola	5650	Woltereck, 1905	Primary	8964	2009-01-01 00:00:00
Scinoidea	5651	unknown	Primary	8965	2009-01-01 00:00:00
Scinidae	5652	unknown	Primary	8966	2009-01-01 00:00:00
Scina	5653	unknown	Primary	8967	2009-01-01 00:00:00
Gammaridea	5654	unknown	Primary	8968	2009-01-01 00:00:00
gammarid-amphipod	5654	(n.o.d.c.)	Common	8969	2009-01-01 00:00:00
Lysianassoidea	5655	unknown	Primary	8970	2009-01-01 00:00:00
Lysianassidae	5656	unknown	Primary	8971	2009-01-01 00:00:00
Paracallisoma	5657	unknown	Primary	8972	2009-01-01 00:00:00
Paracallisoma coecus	5658	unknown	Primary	8973	2009-01-01 00:00:00
orange-amphipod	5658	unknown	Common	8974	2009-01-01 00:00:00
Cyphocarididae	5659	Lowry & Stoddart, 1997	Primary	8975	2009-01-01 00:00:00
Cyphocaris	5660	Boeck, 1871	Primary	8976	2009-01-01 00:00:00
Caprellidea	5661	unknown	Primary	8977	2009-01-01 00:00:00
whale-lice	5661	unknown	Common	8978	2009-01-01 00:00:00
skeleton-shrimp	5661	(n.o.d.c.)	Common	8979	2009-01-01 00:00:00
Caprelloidea	5662	unknown	Primary	8980	2009-01-01 00:00:00
Caprellidae	5663	unknown	Primary	8981	2009-01-01 00:00:00
Caprella	5664	guilding,1824	Primary	8982	2009-01-01 00:00:00
Isopoda	5665	unknown	Primary	8983	2009-01-01 00:00:00
pillbug	5665	unknown	Common	8984	2009-01-01 00:00:00
isopod	5665	(n.o.d.c.)	Common	8985	2009-01-01 00:00:00
Flabellifera	5666	unknown	Primary	8986	2009-01-01 00:00:00
Cirolanoidea	5667	unknown	Primary	8987	2009-01-01 00:00:00
Anuropidae	5668	unknown	Primary	8988	2009-01-01 00:00:00
Anuropus	5669	unknown	Primary	8989	2009-01-01 00:00:00
Anuropus bathpelagicus	5670	menzies and dow 1958	Primary	8990	2009-01-01 00:00:00
Asellota	5671	Latreille, 1803	Primary	8991	2009-01-01 00:00:00
Ischnomesidae	5672	Hansen, 1916	Primary	8992	2009-01-01 00:00:00
Janiroidea	5673	unknown	Primary	8993	2009-01-01 00:00:00
Munnopsidae	5674	sars, 1869	Primary	8994	2009-01-01 00:00:00
spider	5674	unknown	Common	8995	2009-01-01 00:00:00
Munnopsinae	5675	Sars, 1869	Primary	8996	2009-01-01 00:00:00
Munnopsis	5676	Sars, 1861	Primary	8997	2009-01-01 00:00:00
Munnopsis typica	5677	G. O. Sars, 1861	Primary	8998	2009-01-01 00:00:00
Munnopsis abyssalis	5678	Menzies and George, 1972	Primary	8999	2009-01-01 00:00:00
Acanthamunnopsis	5679	Schultz, 1978	Primary	9000	2009-01-01 00:00:00
somersaulting-spider-isopod	5679	unknown	Common	9001	2009-01-01 00:00:00
Acanthamunnopsis milleri	5680	Wilson, 1982	Primary	9002	2009-01-01 00:00:00
Paramunnopsis	5681	Hansen, 1916	Primary	9003	2009-01-01 00:00:00
Munnopsoides	5682	Tattersall, 1905	Primary	9004	2009-01-01 00:00:00
Eurycopinae	5683	Hansen, 1916	Primary	9005	2009-01-01 00:00:00
Eurycope	5684	Sars, 1864	Primary	9006	2009-01-01 00:00:00
Bathyopsurinae	5685	Wolff, 1962	Primary	9007	2009-01-01 00:00:00
Bathyopsurus	5686	Nordenstam, 1955	Primary	9008	2009-01-01 00:00:00
Paropsurus	5687	Wolff, 1962	Primary	9009	2009-01-01 00:00:00
Paropsurus giganteus	5688	Wolff, 1962	Primary	9010	2009-01-01 00:00:00
Munnopsurus	5689	Richardson, 1909	Primary	9011	2009-01-01 00:00:00
Munneurycope	5690	Stephensen, 1913	Primary	9012	2009-01-01 00:00:00
feather-foot-spider-isopod	5690	unknown	Common	9013	2009-01-01 00:00:00
Munneurycope murrayi	5691	Walker, 1903	Primary	9014	2009-01-01 00:00:00
Storthyngura	5692	Vanhoffen, 1914	Primary	9015	2009-01-01 00:00:00
Storthyngura pulchra	5693	unknown	Primary	9016	2009-01-01 00:00:00
Valvifera	5694	unknown	Primary	9017	2009-01-01 00:00:00
Hoplocarida	5695	Calman, 1904	Primary	9018	2009-01-01 00:00:00
Stomatopoda	5696	Latreille, 1817	Primary	9019	2009-01-01 00:00:00
Squilloidea	5697	unknown	Primary	9020	2009-01-01 00:00:00
Squillidae	5698	Latreille, 1802	Primary	9021	2009-01-01 00:00:00
Squilla	5699	Fabricius, 1793	Primary	9022	2009-01-01 00:00:00
Squilla biformis	5700	Bigelow. 1891	Primary	9023	2009-01-01 00:00:00
Branchiopoda	5701	unknown	Primary	9024	2009-01-01 00:00:00
branchiopod	5701	unknown	Common	9025	2009-01-01 00:00:00
Cladocera	5702	unknown	Primary	9026	2009-01-01 00:00:00
Maxillopoda	5703	unknown	Primary	9027	2009-01-01 00:00:00
Cirripedia	5704	unknown	Primary	9028	2009-01-01 00:00:00
barnacle	5704	(n.o.d.c.)	Common	9029	2009-01-01 00:00:00
Thoracica	5705	unknown	Primary	9030	2009-01-01 00:00:00
Lepadomorpha	5706	unknown	Primary	9031	2009-01-01 00:00:00
Scalpelloidea	5707	unknown	Primary	9032	2009-01-01 00:00:00
Scalpellidae	5708	unknown	Primary	9033	2009-01-01 00:00:00
Scalpellum	5709	leach,1817	Primary	9034	2009-01-01 00:00:00
deepsea-barnacle	5709	unknown	Common	9035	2009-01-01 00:00:00
Lepadidoidea	5710	unknown	Primary	9036	2009-01-01 00:00:00
Lepadidae	5711	unknown	Primary	9037	2009-01-01 00:00:00
Lepas	5712	linnaeus,1758	Primary	9038	2009-01-01 00:00:00
pelagic-barnacle	5712	unknown	Common	9039	2009-01-01 00:00:00
Copepoda	5713	unknown	Primary	9040	2009-01-01 00:00:00
copepod	5713	(n.o.d.c.)	Common	9041	2009-01-01 00:00:00
Neocopepoda	5714	Huys and Boxshall, 1991	Primary	9042	2009-01-01 00:00:00
Podoplea	5715	Giesbrecht, 1882	Primary	9043	2009-01-01 00:00:00
Poecilostomatoida	5716	Thorell, 1859	Primary	9044	2009-01-01 00:00:00
Sapphirinidae	5717	Thorell, 1860	Primary	9045	2009-01-01 00:00:00
Sapphirina	5718	J.V. Thompson, 1829	Primary	9046	2009-01-01 00:00:00
Gymnoplea	5719	Giesbrecht, 1882	Primary	9047	2009-01-01 00:00:00
Calanoida	5720	G.O. Sars, 1903	Primary	9048	2009-01-01 00:00:00
Calanidae	5721	dana, 1849	Primary	9049	2009-01-01 00:00:00
Megacalanidae	5722	Sewell, 1947	Primary	9050	2009-01-01 00:00:00
Megacalanus	5723	Wolfenden, 1904	Primary	9051	2009-01-01 00:00:00
Amphascandria	5724	unknown	Primary	9052	2009-01-01 00:00:00
Heterarthrandria	5725	unknown	Primary	9053	2009-01-01 00:00:00
Metridiidae 2	5726	unknown	Primary	9054	2009-01-01 00:00:00
copepod-Metridiidae-family	5726	unknown	Common	9055	2009-01-01 00:00:00
Metridinidae	5726	Sars, 1902	Synonym	9056	2009-01-01 00:00:00
Gaussia	5727	wolfenden, 1905	Primary	9057	2009-01-01 00:00:00
Gaussia-copepod	5727	unknown	Common	9058	2009-01-01 00:00:00
Gaussia princeps	5728	(t. scott, 1894)	Primary	9059	2009-01-01 00:00:00
Aetideidae	5729	Giesbrecht, 1893	Primary	9060	2009-01-01 00:00:00
Euchirella	5730	Giesbrecht, 1888	Primary	9061	2009-01-01 00:00:00
Euchirella bitumida	5731	With, 1915	Primary	9062	2009-01-01 00:00:00
Euchaetidae	5732	Giesbrecht, 1893	Primary	9063	2009-01-01 00:00:00
Euchaeta	5733	Philippi, 1843	Primary	9064	2009-01-01 00:00:00
Ostracoda	5734	latreille, 1806	Primary	9065	2009-01-01 00:00:00
ostracod	5734	(n.o.d.c.)	Common	9066	2009-01-01 00:00:00
Myodocopida	5735	unknown	Primary	9067	2009-01-01 00:00:00
Myodocopina	5736	unknown	Primary	9068	2009-01-01 00:00:00
Cypridinacea	5737	unknown	Primary	9069	2009-01-01 00:00:00
Cypridinidae	5738	unknown	Primary	9070	2009-01-01 00:00:00
Gigantocypris	5739	unknown	Primary	9071	2009-01-01 00:00:00
Gigantocypris agassizii	5740	unknown	Primary	9072	2009-01-01 00:00:00
giant-ostracod	5740	unknown	Common	9073	2009-01-01 00:00:00
Gigantocypris dracontovalis	5741	Cannon, 1940	Primary	9074	2009-01-01 00:00:00
Chelicerata	5742	unknown	Primary	9075	2009-01-01 00:00:00
Pycnogonida	5743	unknown	Primary	9076	2009-01-01 00:00:00
sea-spider	5743	(n.o.d.c.)	Common	9077	2009-01-01 00:00:00
Pantopoda	5744	unknown	Primary	9078	2009-01-01 00:00:00
Ammotheidae	5745	unknown	Primary	9079	2009-01-01 00:00:00
Ammothea	5746	unknown	Primary	9080	2009-01-01 00:00:00
Ammothea verenae	5747	Child, 1988	Primary	9081	2009-01-01 00:00:00
Cnidaria	5748	(hatschek, 1888)	Primary	9082	2009-01-01 00:00:00
Coelenterata	5748	unknown	Synonym	9083	2009-01-01 00:00:00
coelenterate	5748	unknown	Common	9084	2009-01-01 00:00:00
cnidarian	5748	(n.o.d.c.)	Common	9085	2009-01-01 00:00:00
Anthozoa	5749	ehrenberg, 1834	Primary	9086	2009-01-01 00:00:00
flower-animal	5749	unknown	Common	9087	2009-01-01 00:00:00
coral	5749	(n.o.d.c.)	Common	9088	2009-01-01 00:00:00
Ceriantipatharia	5750	unknown	Primary	9089	2009-01-01 00:00:00
Ceriantharia	5751	unknown	Primary	9090	2009-01-01 00:00:00
tube-anemone	5751	unknown	Common	9091	2009-01-01 00:00:00
tube-dwelling-anemone	5751	amer. fisheries society, 1991	Common	9092	2009-01-01 00:00:00
Cerianthidae	5752	unknown	Primary	9093	2009-01-01 00:00:00
burrowing-anemone	5752	unknown	Common	9094	2009-01-01 00:00:00
Pachycerianthus	5753	unknown	Primary	9095	2009-01-01 00:00:00
pachycerianthus	5753	unknown	Synonym	9096	2009-01-01 00:00:00
Cerianthus	5754	delle chiaje, 1830	Primary	9097	2009-01-01 00:00:00
cerianthus	5754	delle chiaje, 1830	Synonym	9098	2009-01-01 00:00:00
Penicilaria	5755	Hartog, 1977	Primary	9099	2009-01-01 00:00:00
Arachnactidae	5756	McMurrich, 1910	Primary	9100	2009-01-01 00:00:00
arachnactidae	5756	McMurrich, 1910	Synonym	9101	2009-01-01 00:00:00
Arachnactis	5757	Sars, 1846	Primary	9102	2009-01-01 00:00:00
arachnactis	5757	Sars, 1846	Synonym	9103	2009-01-01 00:00:00
Ceriantharia sp. 1	5758	unknown	Primary	9104	2009-01-01 00:00:00
Ceriantharia sp. 2	5759	unknown	Primary	9105	2009-01-01 00:00:00
Ceriantharia sp. 3	5760	unknown	Primary	9106	2009-01-01 00:00:00
Hexacorallia	5761	de blainville, 1830	Primary	9107	2009-01-01 00:00:00
Zoantharia	5761	de blainville, 1830	Synonym	9108	2009-01-01 00:00:00
Antipatharia	5762	milne edwatds & haime, 1857	Primary	9109	2009-01-01 00:00:00
thorny-coral	5762	unknown	Common	9110	2009-01-01 00:00:00
black-coral	5762	amer. fisheries society, 1991	Common	9111	2009-01-01 00:00:00
Antipathida	5763	unknown	Primary	9112	2009-01-01 00:00:00
antipathida	5763	unknown	Synonym	9113	2009-01-01 00:00:00
Heterotainiales	5764	unknown	Primary	9114	2009-01-01 00:00:00
heterotainiales	5764	unknown	Synonym	9115	2009-01-01 00:00:00
Antipathes	5765	milne edwards and haime, 1857	Primary	9116	2009-01-01 00:00:00
antipathes	5765	milne edwards and haime, 1857	Synonym	9117	2009-01-01 00:00:00
Cladopathidae	5766	Brook, 1889	Primary	9118	2009-01-01 00:00:00
cladopathidae	5766	Brook, 1889	Synonym	9119	2009-01-01 00:00:00
Trissopathes	5767	unknown	Primary	9120	2009-01-01 00:00:00
trissopathes	5767	unknown	Synonym	9121	2009-01-01 00:00:00
Trissopathes pseudotristicha	5768	Opresko, 2003	Primary	9122	2009-01-01 00:00:00
trissopathes-pseudotristicha	5768	Opresko, 2003	Synonym	9123	2009-01-01 00:00:00
Schizopathidae	5769	unknown	Primary	9124	2009-01-01 00:00:00
Bathypathes	5770	unknown	Primary	9125	2009-01-01 00:00:00
Umbellapathes	5771	unknown	Primary	9126	2009-01-01 00:00:00
Lillipathes	5772	unknown	Primary	9127	2009-01-01 00:00:00
Dendropathes	5773	unknown	Primary	9128	2009-01-01 00:00:00
Parantipathes	5774	unknown	Primary	9129	2009-01-01 00:00:00
Actiniaria	5775	unknown	Primary	9130	2009-01-01 00:00:00
anemone	5775	amer. fisheries society, 1991	Common	9131	2009-01-01 00:00:00
Nyantheae	5776	Carlgren, 1899	Primary	9132	2009-01-01 00:00:00
nynantheae	5776	unknown	Synonym	9133	2009-01-01 00:00:00
Thenaria	5777	unknown	Primary	9134	2009-01-01 00:00:00
Hormathiidae	5778	unknown	Primary	9135	2009-01-01 00:00:00
Actinauge	5779	Verrill, 1883	Primary	9136	2009-01-01 00:00:00
Actinauge abyssorum	5780	Carlgren, 1934	Primary	9137	2009-01-01 00:00:00
Liponematidae	5781	unknown	Primary	9138	2009-01-01 00:00:00
Liponema	5782	hertwig, 1882	Primary	9139	2009-01-01 00:00:00
pompom-anemone	5782	unknown	Common	9140	2009-01-01 00:00:00
liponema	5782	hertwig, 1882	Synonym	9141	2009-01-01 00:00:00
Liponema brevicornis	5783	mcmurrich, 1893	Primary	9142	2009-01-01 00:00:00
liponema-brevicornis	5783	mcmurrich, 1893	Synonym	9143	2009-01-01 00:00:00
Actinostolidae	5784	unknown	Primary	9144	2009-01-01 00:00:00
actinostolid-anemone	5784	unknown	Common	9145	2009-01-01 00:00:00
Stomphia	5785	unknown	Primary	9146	2009-01-01 00:00:00
Stomphia coccinea	5786	(o. f. muller, 1776)	Primary	9147	2009-01-01 00:00:00
swimming-anemone	5786	amer. fisheries society, 1991	Common	9148	2009-01-01 00:00:00
stomphia-coccinea	5786	(o. f. muller, 1776)	Synonym	9149	2009-01-01 00:00:00
Stomphia didemon	5787	siebert, 1973	Primary	9150	2009-01-01 00:00:00
cowardly-anemone	5787	amer. fisheries society, 1991	Common	9151	2009-01-01 00:00:00
stomphia-didemon	5787	siebert, 1973	Synonym	9152	2009-01-01 00:00:00
Actinostola	5788	verrill, 1883	Primary	9153	2009-01-01 00:00:00
apple-anemone	5788	unknown	Common	9154	2009-01-01 00:00:00
actinostola	5788	verrill, 1883	Synonym	9155	2009-01-01 00:00:00
Mesomyaria	5789	Stephenson, 1921	Primary	9156	2009-01-01 00:00:00
mesomyaria	5789	Stephenson, 1921	Synonym	9157	2009-01-01 00:00:00
Actinoscyphiidae	5790	Stephenson, 1920	Primary	9158	2009-01-01 00:00:00
actinoscyphiidae	5790	Stephenson, 1920	Synonym	9159	2009-01-01 00:00:00
Actinoscyphia	5791	Stephenson, 1920	Primary	9160	2009-01-01 00:00:00
actinoscyphia	5791	Stephenson, 1920	Synonym	9161	2009-01-01 00:00:00
Metridiidae	5792	unknown	Primary	9162	2009-01-01 00:00:00
anemone-metridiidae-family	5792	unknown	Common	9163	2009-01-01 00:00:00
metridiidae	5792	unknown	Synonym	9164	2009-01-01 00:00:00
Metridium	5793	oken, 1815	Primary	9165	2009-01-01 00:00:00
metridium	5793	oken, 1815	Synonym	9166	2009-01-01 00:00:00
Metridium senile	5794	(linnaeus, 1767)	Primary	9167	2009-01-01 00:00:00
clonal-plumose-anemone	5794	amer. fisheries society, 1991	Common	9168	2009-01-01 00:00:00
metridium-senile	5794	(linnaeus, 1767)	Synonym	9169	2009-01-01 00:00:00
Metridium farcimen	5795	Tilesius, 1809	Primary	9170	2009-01-01 00:00:00
metridium-giganteum	5795	unknown	Synonym	9171	2009-01-01 00:00:00
metridium-farcimen	5795	Tilesius, 1809	Synonym	9172	2009-01-01 00:00:00
Endomyaria	5796	Stephenson, 1921	Primary	9173	2009-01-01 00:00:00
Actiniidae	5797	unknown	Primary	9174	2009-01-01 00:00:00
cribrinidae	5797	unknown	Synonym	9175	2009-01-01 00:00:00
actiniidae	5797	unknown	Synonym	9176	2009-01-01 00:00:00
Tealia	5798	unknown	Primary	9177	2009-01-01 00:00:00
tealia	5798	unknown	Synonym	9178	2009-01-01 00:00:00
Urticina	5799	unknown	Primary	9179	2009-01-01 00:00:00
urticina	5799	unknown	Synonym	9180	2009-01-01 00:00:00
Dofleinia	5800	Wassilieff, 1908	Primary	9181	2009-01-01 00:00:00
dofleinia	5800	Wassilieff, 1908	Synonym	9182	2009-01-01 00:00:00
Bolocera	5801	unknown	Primary	9183	2009-01-01 00:00:00
bolocera	5801	unknown	Synonym	9184	2009-01-01 00:00:00
Bathyphellidae	5802	Carlgren, 1932	Primary	9185	2009-01-01 00:00:00
Bathyphellia	5803	Carlgren, 1932	Primary	9186	2009-01-01 00:00:00
Bathyphellia australis	5804	Dunn, 1983	Primary	9187	2009-01-01 00:00:00
Athenaria	5805	Carlgren, 1899	Primary	9188	2009-01-01 00:00:00
Edwardsiidae	5806	Andres, 1881	Primary	9189	2009-01-01 00:00:00
Edwardsia	5807	unknown	Primary	9190	2009-01-01 00:00:00
Endocoelantheae	5808	Carlgren, 1925	Primary	9191	2009-01-01 00:00:00
Actinernidae	5809	Stephenson, 1922	Primary	9192	2009-01-01 00:00:00
actinernidae	5809	Stephenson, 1922	Synonym	9193	2009-01-01 00:00:00
Actinernus	5810	Verrill, 1879	Primary	9194	2009-01-01 00:00:00
Actiniaria sp. 1	5811	unknown	Primary	9195	2009-01-01 00:00:00
Actiniaria sp. 3	5812	unknown	Primary	9196	2009-01-01 00:00:00
Actiniaria sp. 4	5813	unknown	Primary	9197	2009-01-01 00:00:00
Actiniaria sp. 2	5814	unknown	Primary	9198	2009-01-01 00:00:00
Scleractinia	5815	bourne, 1900	Primary	9199	2009-01-01 00:00:00
true-coral	5815	unknown	Common	9200	2009-01-01 00:00:00
stony-coral	5815	(n.o.d.c.)	Common	9201	2009-01-01 00:00:00
Dendrophylliina	5816	vaughan and wells, 1943	Primary	9202	2009-01-01 00:00:00
dendrophylliina	5816	vaughan and wells, 1943	Synonym	9203	2009-01-01 00:00:00
Dendrophylliidae	5817	gray, 1847	Primary	9204	2009-01-01 00:00:00
dendrophylliidae	5817	gray, 1847	Synonym	9205	2009-01-01 00:00:00
Balanophyllia	5818	wood,1844	Primary	9206	2009-01-01 00:00:00
balanophyllia	5818	wood,1844	Synonym	9207	2009-01-01 00:00:00
Balanophyllia elegans	5819	verrill, 1864	Primary	9208	2009-01-01 00:00:00
balanophyllia-elegans	5819	verrill, 1864	Synonym	9209	2009-01-01 00:00:00
Caryophylliina	5820	vaughan and wells, 1943	Primary	9210	2009-01-01 00:00:00
cup-coral	5820	unknown	Common	9211	2009-01-01 00:00:00
caryophylliina	5820	vaughan and wells, 1943	Synonym	9212	2009-01-01 00:00:00
Caryophylliicae	5821	unknown	Primary	9213	2009-01-01 00:00:00
caryophylliicae	5821	unknown	Synonym	9214	2009-01-01 00:00:00
Caryophylliidae	5822	gray, 1847	Primary	9215	2009-01-01 00:00:00
eusmiliidae	5822	unknown	Synonym	9216	2009-01-01 00:00:00
caryophylliidae	5822	gray, 1847	Synonym	9217	2009-01-01 00:00:00
Paracyathus	5823	milne-edwards & haime,1848	Primary	9218	2009-01-01 00:00:00
paracyathus	5823	milne-edwards & haime,1848	Synonym	9219	2009-01-01 00:00:00
Paracyathus stearnsi	5824	verrill, 1869	Primary	9220	2009-01-01 00:00:00
paracyathus-stearnsi	5824	verrill, 1869	Synonym	9221	2009-01-01 00:00:00
Caryophyllia	5825	unknown	Primary	9222	2009-01-01 00:00:00
Caryophyllia diomedeae	5826	unknown	Primary	9223	2009-01-01 00:00:00
Flabellidae	5827	unknown	Primary	9224	2009-01-01 00:00:00
Javania	5828	unknown	Primary	9225	2009-01-01 00:00:00
Javania cailleti	5829	unknown	Primary	9226	2009-01-01 00:00:00
Fungiidae	5830	Dana, 1846	Primary	9227	2009-01-01 00:00:00
fungiidae	5830	Dana, 1846	Synonym	9228	2009-01-01 00:00:00
Fungiacyathus	5831	Sars, 1872	Primary	9229	2009-01-01 00:00:00
fungiacyathus	5831	Sars, 1872	Synonym	9230	2009-01-01 00:00:00
Zoanthidea	5832	unknown	Primary	9231	2009-01-01 00:00:00
zoanthid	5832	amer. fisheries society, 1991	Common	9232	2009-01-01 00:00:00
Epizoanthidae	5833	Gray, 1867	Primary	9233	2009-01-01 00:00:00
Epizoanthus 	5834	Gray, 1867	Primary	9234	2009-01-01 00:00:00
Epizoanthus stellaris	5835	Hertwig, 1888	Primary	9235	2009-01-01 00:00:00
Corallimorpharia	5836	Stephenson, 1937	Primary	9236	2009-01-01 00:00:00
Corallimorphidae	5837	unknown	Primary	9237	2009-01-01 00:00:00
Corallimorphus	5838	Mosley, 1877	Primary	9238	2009-01-01 00:00:00
Corallimorphus profundus	5839	moseley, 1877	Primary	9239	2009-01-01 00:00:00
club-tipped-anemone	5839	unknown	Common	9240	2009-01-01 00:00:00
corallimorphus-profundus	5839	moseley, 1877	Synonym	9241	2009-01-01 00:00:00
Corallimorphus pilatus	5840	unknown	Primary	9242	2009-01-01 00:00:00
corallimorphus-pilatus	5840	unknown	Synonym	9243	2009-01-01 00:00:00
Corynactis	5841	allman, 1846	Primary	9244	2009-01-01 00:00:00
Corynactis californica	5842	carlgren, 1936	Primary	9245	2009-01-01 00:00:00
strawberry-anemone	5842	unknown	Common	9246	2009-01-01 00:00:00
Octocorallia	5843	dana	Primary	9247	2009-01-01 00:00:00
Alcyonaria	5843	dana	Synonym	9248	2009-01-01 00:00:00
Alcyonacea	5844	lamouroux, 1894	Primary	9249	2009-01-01 00:00:00
soft-coral	5844	amer. fisheries society, 1991	Common	9250	2009-01-01 00:00:00
Alcyoniidae	5845	lamouroux, 1812	Primary	9251	2009-01-01 00:00:00
true-soft-coral	5845	(n.o.d.c.)	Common	9252	2009-01-01 00:00:00
alcyoniidae	5845	lamouroux, 1812	Synonym	9253	2009-01-01 00:00:00
Anthomastus	5846	verrill, 1878	Primary	9254	2009-01-01 00:00:00
anthomastus	5846	verrill, 1878	Synonym	9255	2009-01-01 00:00:00
Anthomastus ritteri	5847	nutting, 1909	Primary	9256	2009-01-01 00:00:00
anthomastus-ritteri	5847	nutting, 1909	Synonym	9257	2009-01-01 00:00:00
Anthomastus-ritteri	5847	nutting, 1909	Synonym	9258	2009-01-01 00:00:00
Anthomastus robustus	5848	unknown	Primary	9259	2009-01-01 00:00:00
Clavularidae	5849	unknown	Primary	9260	2009-01-01 00:00:00
clavularidae	5849	unknown	Synonym	9261	2009-01-01 00:00:00
Telestula	5850	nutting, 1909	Primary	9262	2009-01-01 00:00:00
telesto	5850	unknown	Synonym	9263	2009-01-01 00:00:00
telestula	5850	nutting, 1909	Synonym	9264	2009-01-01 00:00:00
Clavularia	5851	de Blainville, 1830	Primary	9265	2009-01-01 00:00:00
Clavularia grandiflora	5852	Nutting, 1908	Primary	9266	2009-01-01 00:00:00
Nephtheidae	5853	\N	Primary	9267	2009-01-01 00:00:00
Gorgonacea	5854	unknown	Primary	9268	2009-01-01 00:00:00
sea-fan	5854	unknown	Common	9269	2009-01-01 00:00:00
gorgonian	5854	(n.o.d.c.)	Common	9270	2009-01-01 00:00:00
small pink gorgonian	5855	unknown	Primary	9271	2009-01-01 00:00:00
white gorgonian	5856	unknown	Primary	9272	2009-01-01 00:00:00
light pink bushy gorgonian	5857	unknown	Primary	9273	2009-01-01 00:00:00
Scleraxonia	5858	Studer, 1887	Primary	9274	2009-01-01 00:00:00
Paragorgiidae	5859	unknown	Primary	9275	2009-01-01 00:00:00
Paragorgia	5860	unknown	Primary	9276	2009-01-01 00:00:00
Paragorgia arborea	5861	(linnaeus 1758)	Primary	9277	2009-01-01 00:00:00
paragorgia-pacifica	5861	verrill 1922	Synonym	9278	2009-01-01 00:00:00
peppermint-gorgonian	5861	unknown	Common	9279	2009-01-01 00:00:00
Coralliidae	5862	unknown	Primary	9280	2009-01-01 00:00:00
Corallium	5863	Cuvier, 1798	Primary	9281	2009-01-01 00:00:00
gold gorgonian	5864	unknown	Primary	9282	2009-01-01 00:00:00
Acanthogorgiidae	5865	unknown	Primary	9283	2009-01-01 00:00:00
Acanthogorgia	5866	unknown	Primary	9284	2009-01-01 00:00:00
Holaxonia	5867	studer, 1887	Primary	9285	2009-01-01 00:00:00
Primnoidae	5868	unknown	Primary	9286	2009-01-01 00:00:00
Narella	5869	Gray, 1870	Primary	9287	2009-01-01 00:00:00
Narella bowersi	5870	Cairns	Primary	9288	2009-01-01 00:00:00
Parastenella	5871	Versluys, 1906	Primary	9289	2009-01-01 00:00:00
Parastenella ramosa	5872	Studer, 1894	Primary	9290	2009-01-01 00:00:00
Parastenella gymnogaster	5873	Cairns	Primary	9291	2009-01-01 00:00:00
Calyptrophora	5874	\N	Primary	9292	2009-01-01 00:00:00
Calyptrophora antilla	5875	Cairns	Primary	9293	2009-01-01 00:00:00
Calyptrophora bayeri	5876	Cairns	Primary	9294	2009-01-01 00:00:00
Calyptrophora laevispinosa	5877	Cairns	Primary	9295	2009-01-01 00:00:00
Plexauridae	5878	unknown	Primary	9296	2009-01-01 00:00:00
Swiftia	5879	unknown	Primary	9297	2009-01-01 00:00:00
Swiftia kofoidi	5880	(nutting 1909)	Primary	9298	2009-01-01 00:00:00
red-sea-fan	5880	unknown	Common	9299	2009-01-01 00:00:00
Swiftia simplex	5881	unknown	Primary	9300	2009-01-01 00:00:00
Plexaura	5882	lamouroux,1812	Primary	9301	2009-01-01 00:00:00
Isididae	5883	Lamouroux, 1812	Primary	9302	2009-01-01 00:00:00
bamboo-coral	5883	unknown	Common	9303	2009-01-01 00:00:00
Isidella	5884	unknown	Primary	9304	2009-01-01 00:00:00
isidella	5884	unknown	Synonym	9305	2009-01-01 00:00:00
Keratoisis	5885	Wright, 1869	Primary	9306	2009-01-01 00:00:00
Acanella	5886	Gray, 1870	Primary	9307	2009-01-01 00:00:00
acanella	5886	Gray, 1870	Synonym	9308	2009-01-01 00:00:00
Lepidisis	5887	Verrill, 1883	Primary	9309	2009-01-01 00:00:00
lepidisis	5887	Verrill, 1883	Synonym	9310	2009-01-01 00:00:00
Psammogorgia	5888	verrill, 1868	Primary	9311	2009-01-01 00:00:00
Euplexaura	5889	unknown	Primary	9312	2009-01-01 00:00:00
Chrysogorgiidae	5890	unknown	Primary	9313	2009-01-01 00:00:00
Iridogorgia	5891	Verrill, 1883	Primary	9314	2009-01-01 00:00:00
iridogorgia	5891	Verrill, 1883	Synonym	9315	2009-01-01 00:00:00
Metallogorgia	5892	Versluys, 1902	Primary	9316	2009-01-01 00:00:00
metallogorgia	5892	Versluys, 1902	Synonym	9317	2009-01-01 00:00:00
Chrysogorgia	5893	unknown	Primary	9318	2009-01-01 00:00:00
Chrysogorgia pinnata	5894	Cairns	Primary	9319	2009-01-01 00:00:00
Chrysogorgia monticola	5895	Cairns	Primary	9320	2009-01-01 00:00:00
Pennatulacea	5896	verrill, 1865	Primary	9321	2009-01-01 00:00:00
sea-pen	5896	unknown	Common	9322	2009-01-01 00:00:00
sea-pansy	5896	(n.o.d.c.)	Common	9323	2009-01-01 00:00:00
Subselliflorae	5897	unknown	Primary	9324	2009-01-01 00:00:00
Virgulariidae	5898	unknown	Primary	9325	2009-01-01 00:00:00
Stylatula	5899	unknown	Primary	9326	2009-01-01 00:00:00
Stylatula elongata	5900	verrill, 1864	Primary	9327	2009-01-01 00:00:00
slender-sea-pen	5900	amer. fisheries society, 1991	Common	9328	2009-01-01 00:00:00
Acanthoptilum	5901	Kölliker, 1870	Primary	9329	2009-01-01 00:00:00
Virgularia	5902	Lamarck, 1816	Primary	9330	2009-01-01 00:00:00
Pennatulidae	5903	unknown	Primary	9331	2009-01-01 00:00:00
Ptilosarcus	5904	unknown	Primary	9332	2009-01-01 00:00:00
ptilosarcus	5904	unknown	Synonym	9333	2009-01-01 00:00:00
Ptilosarcus gurneyi	5905	gray, 1860	Primary	9334	2009-01-01 00:00:00
ptilosarcus-gurneyi	5905	gray, 1860	Synonym	9335	2009-01-01 00:00:00
Pennatula	5906	unknown	Primary	9336	2009-01-01 00:00:00
pennatula	5906	unknown	Synonym	9337	2009-01-01 00:00:00
Pennatula phosphorea californica	5907	unknown	Primary	9338	2009-01-01 00:00:00
pennatula-phosphorea-californica	5907	unknown	Synonym	9339	2009-01-01 00:00:00
Pennatula aculeata	5908	Danielssen, 1860	Primary	9340	2009-01-01 00:00:00
Pennatula murrayi	5909	Kolliker, 1880	Primary	9341	2009-01-01 00:00:00
Halipteridae	5910	Williams, 1995	Primary	9342	2009-01-01 00:00:00
Halipteris	5911	unknown	Primary	9343	2009-01-01 00:00:00
Halipteris californica	5912	(Moroff, 1902)	Primary	9344	2009-01-01 00:00:00
Sessiliflorae	5913	Kuekenthal, 1915	Primary	9345	2009-01-01 00:00:00
Anthoptilidae	5914	unknown	Primary	9346	2009-01-01 00:00:00
Anthoptilum	5915	unknown	Primary	9347	2009-01-01 00:00:00
Anthoptilum grandiflorum	5916	(Verrill 1882)	Primary	9348	2009-01-01 00:00:00
Anthoptilum murrayi	5917	Kölliker, 1880	Primary	9349	2009-01-01 00:00:00
Umbellulidae	5918	unknown	Primary	9350	2009-01-01 00:00:00
Umbellula	5919	cuvier, 1798	Primary	9351	2009-01-01 00:00:00
umbellula	5919	cuvier, 1798	Synonym	9352	2009-01-01 00:00:00
Umbellula lindahli	5920	kolliker, 1874	Primary	9353	2009-01-01 00:00:00
umbellula-lindahli	5920	kolliker, 1874	Synonym	9354	2009-01-01 00:00:00
Umbellula magniflora	5921	unknown	Primary	9355	2009-01-01 00:00:00
umbellula-magniflora	5921	unknown	Synonym	9356	2009-01-01 00:00:00
Protoptilidae	5922	Kölliker, 1872	Primary	9357	2009-01-01 00:00:00
Distichoptilum	5923	unknown	Primary	9358	2009-01-01 00:00:00
distichoptilum	5923	unknown	Synonym	9359	2009-01-01 00:00:00
Distichoptilum gracile	5924	unknown	Primary	9360	2009-01-01 00:00:00
distichoptilum-gracile	5924	unknown	Synonym	9361	2009-01-01 00:00:00
Protoptilum	5925	Kölliker, 1872	Primary	9362	2009-01-01 00:00:00
Protoptilum sp.1	5926	\N	Primary	9363	2009-01-01 00:00:00
Kophobelemnidae	5927	unknown	Primary	9364	2009-01-01 00:00:00
Kophobelemnon	5928	Asbjørnsen, 1856	Primary	9365	2009-01-01 00:00:00
kophobelemnon	5928	Asbjørnsen, 1856	Synonym	9366	2009-01-01 00:00:00
Kophobelemnon sp. 1	5929	\N	Primary	9367	2009-01-01 00:00:00
Kophobelemnon biflorum	5930	Pasternak, 1960	Primary	9368	2009-01-01 00:00:00
Stachyptilidae	5931	unknown	Primary	9369	2009-01-01 00:00:00
Stachyptiilidae	5931	unknown	Synonym	9370	2009-01-01 00:00:00
Stachyptilum	5932	unknown	Primary	9371	2009-01-01 00:00:00
stachyptilum	5932	unknown	Synonym	9372	2009-01-01 00:00:00
Stachyptilum superbum	5933	Studer, 1894	Primary	9373	2009-01-01 00:00:00
stachyptilum superbum	5933	Studer, 1894	Synonym	9374	2009-01-01 00:00:00
Funiculinidae 	5934	\N	Primary	9375	2009-01-01 00:00:00
Funiculina	5935	Lamarck, 1816	Primary	9376	2009-01-01 00:00:00
Pennatulacea sp.1	5936	unknown	Primary	9377	2009-01-01 00:00:00
Pennatulacea sp.3	5937	unknown	Primary	9378	2009-01-01 00:00:00
Funiculina-Halipteris complex	5938	\N	Primary	9379	2009-01-01 00:00:00
Scyphozoa	5939	unknown	Primary	9380	2009-01-01 00:00:00
jellyfish	5939	unknown	Common	9381	2009-01-01 00:00:00
cup-animal	5939	(n.o.d.c.)	Common	9382	2009-01-01 00:00:00
Coronatae	5940	unknown	Primary	9383	2009-01-01 00:00:00
crown-jelly	5940	amer. fisheries society, 1991	Common	9384	2009-01-01 00:00:00
cone-medusae	5940	unknown	Common	9385	2009-01-01 00:00:00
coronate-medusae	5940	unknown	Common	9386	2009-01-01 00:00:00
Paraphyllinidae	5941	unknown	Primary	9387	2009-01-01 00:00:00
paraphyllinidae	5941	unknown	Synonym	9388	2009-01-01 00:00:00
Paraphyllina	5942	maas, 1903	Primary	9389	2009-01-01 00:00:00
paraphyllina	5942	maas, 1903	Synonym	9390	2009-01-01 00:00:00
Paraphyllina ransoni	5943	russell, 1956	Primary	9391	2009-01-01 00:00:00
paraphyllina-ransoni	5943	russell, 1956	Synonym	9392	2009-01-01 00:00:00
Nausithoidae	5944	unknown	Primary	9393	2009-01-01 00:00:00
nausithoidae	5944	unknown	Synonym	9394	2009-01-01 00:00:00
Nausithoe	5945	unknown	Primary	9395	2009-01-01 00:00:00
nausithoe	5945	unknown	Synonym	9396	2009-01-01 00:00:00
Nausithoe rubra	5946	Vanhoffen, 1902	Primary	9397	2009-01-01 00:00:00
nausithoe-rubra	5946	Vanhoffen, 1902	Synonym	9398	2009-01-01 00:00:00
Nausithoe atlantica	5947	Broch, 1914	Primary	9399	2009-01-01 00:00:00
nausithoe-atlantica	5947	Broch, 1914	Synonym	9400	2009-01-01 00:00:00
Periphyllidae	5948	unknown	Primary	9401	2009-01-01 00:00:00
periphyllidae	5948	unknown	Synonym	9402	2009-01-01 00:00:00
Periphyllopsis	5949	vanhoeffen, 1900	Primary	9403	2009-01-01 00:00:00
periphyllopsis	5949	vanhoeffen, 1900	Synonym	9404	2009-01-01 00:00:00
Periphyllopsis galatheae	5950	Kramp, 1959	Primary	9405	2009-01-01 00:00:00
periphyllopsis-galatheae	5950	Kramp, 1959	Synonym	9406	2009-01-01 00:00:00
Periphylla	5951	haeckel, 1880	Primary	9407	2009-01-01 00:00:00
periphylla	5951	haeckel, 1880	Synonym	9408	2009-01-01 00:00:00
Periphylla periphylla	5952	(peron and lesueur, 1809)	Primary	9409	2009-01-01 00:00:00
periphylla-periphylla	5952	(peron and lesueur, 1809)	Synonym	9410	2009-01-01 00:00:00
Atollidae	5953	unknown	Primary	9411	2009-01-01 00:00:00
atollidae	5953	unknown	Synonym	9412	2009-01-01 00:00:00
Atolla	5954	haeckel, 1880	Primary	9413	2009-01-01 00:00:00
atolla	5954	haeckel, 1880	Synonym	9414	2009-01-01 00:00:00
Atolla wyvillei	5955	haeckel, 1880	Primary	9415	2009-01-01 00:00:00
atolla-wyvillei	5955	haeckel, 1880	Synonym	9416	2009-01-01 00:00:00
Atolla vanhoeffeni	5956	(russell 1957)	Primary	9417	2009-01-01 00:00:00
atolla-vanhoeffeni	5956	(russell 1957)	Synonym	9418	2009-01-01 00:00:00
Atorellidae	5957	\N	Primary	9419	2009-01-01 00:00:00
Atorella	5958	Vanhöffen, 1902	Primary	9420	2009-01-01 00:00:00
Semaeostomeae	5959	unknown	Primary	9421	2009-01-01 00:00:00
semaeostomae	5959	unknown	Synonym	9422	2009-01-01 00:00:00
semaeostomeae	5959	unknown	Synonym	9423	2009-01-01 00:00:00
Pelagiidae	5960	unknown	Primary	9424	2009-01-01 00:00:00
pelagiidae	5960	unknown	Synonym	9425	2009-01-01 00:00:00
Pelagia	5961	person and lesueur, 1809	Primary	9426	2009-01-01 00:00:00
pelagia	5961	person and lesueur, 1809	Synonym	9427	2009-01-01 00:00:00
Pelagia noctiluca	5962	(forsskal, 1775)	Primary	9428	2009-01-01 00:00:00
purplestriped-jelly	5962	amer. fisheries society, 1991	Common	9429	2009-01-01 00:00:00
pelagia-noctiluca	5962	(forsskal, 1775)	Synonym	9430	2009-01-01 00:00:00
Chrysaora	5963	peron and lesueur,1810	Primary	9431	2009-01-01 00:00:00
chrysaora	5963	peron and lesueur,1810	Synonym	9432	2009-01-01 00:00:00
Chrysaora quinquecirrha	5964	(desor, 1848)	Primary	9433	2009-01-01 00:00:00
chrysaora-quinquecirrha	5964	(desor, 1848)	Synonym	9434	2009-01-01 00:00:00
Chrysaora fuscescens	5965	unknown	Primary	9435	2009-01-01 00:00:00
sea-nettle	5965	unknown	Common	9436	2009-01-01 00:00:00
chrysaora-fuscescens	5965	unknown	Synonym	9437	2009-01-01 00:00:00
Chrysaora melanaster	5966	brandt, 1835	Primary	9438	2009-01-01 00:00:00
chrysaora-melanaster	5966	brandt, 1835	Synonym	9439	2009-01-01 00:00:00
Chrysaora colorata	5967	Russell, 1964	Primary	9440	2009-01-01 00:00:00
Pelagia colorata	5967		Synonym	9441	2009-01-01 00:00:00
Purple-striped Jelly	5967		Common	9442	2009-01-01 00:00:00
Ulmaridae	5968	unknown	Primary	9443	2009-01-01 00:00:00
ulmariidae	5968	unknown	Synonym	9444	2009-01-01 00:00:00
ulmaridae	5968	unknown	Synonym	9445	2009-01-01 00:00:00
Poraliinae	5969	unknown	Primary	9446	2009-01-01 00:00:00
poraliinae	5969	unknown	Synonym	9447	2009-01-01 00:00:00
Poralia	5970	vanhoeffen, 1902	Primary	9448	2009-01-01 00:00:00
poralia	5970	vanhoeffen, 1902	Synonym	9449	2009-01-01 00:00:00
Poralia rufescens	5971	vanhoffen, 1902	Primary	9450	2009-01-01 00:00:00
poralia-rufescens	5971	vanhoffen, 1902	Synonym	9451	2009-01-01 00:00:00
Aureliinae	5972	unknown	Primary	9452	2009-01-01 00:00:00
aureliinae	5972	unknown	Synonym	9453	2009-01-01 00:00:00
Aurelia	5973	person and lesueur, 1809	Primary	9454	2009-01-01 00:00:00
aurelia	5973	person and lesueur, 1809	Synonym	9455	2009-01-01 00:00:00
Aurelia aurita	5974	(linnaeus, 1758)	Primary	9456	2009-01-01 00:00:00
moon-jelly	5974	amer. fisheries society, 1991	Common	9457	2009-01-01 00:00:00
aurelia-aurita	5974	(linnaeus, 1758)	Synonym	9458	2009-01-01 00:00:00
Deepstariinae	5975	unknown	Primary	9459	2009-01-01 00:00:00
deepstariinae	5975	unknown	Synonym	9460	2009-01-01 00:00:00
Deepstaria	5976	unknown	Primary	9461	2009-01-01 00:00:00
deepstaria	5976	unknown	Synonym	9462	2009-01-01 00:00:00
Deepstaria reticulum	5977	unknown	Primary	9463	2009-01-01 00:00:00
deepstaria-reticulum	5977	unknown	Synonym	9464	2009-01-01 00:00:00
Deepstaria enigmatica	5978	russell,1967	Primary	9465	2009-01-01 00:00:00
deepstaria-enigmatica	5978	russell,1967	Synonym	9466	2009-01-01 00:00:00
Sthenoniinae	5979	unknown	Primary	9467	2009-01-01 00:00:00
sthenoniinae	5979	unknown	Synonym	9468	2009-01-01 00:00:00
Phacellophora	5980	unknown	Primary	9469	2009-01-01 00:00:00
phacellophora	5980	unknown	Synonym	9470	2009-01-01 00:00:00
Phacellophora camtschatica	5981	brandt 1835	Primary	9471	2009-01-01 00:00:00
eggyolk-jelly	5981	unknown	Common	9472	2009-01-01 00:00:00
fried-egg-jelly	5981	unknown	Common	9473	2009-01-01 00:00:00
phacellophora-camtschatica	5981	brandt 1835	Synonym	9474	2009-01-01 00:00:00
Tiburoniinae	5982	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay	Primary	9475	2009-01-01 00:00:00
tiburoniinae	5982	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay	Synonym	9476	2009-01-01 00:00:00
Tiburonia	5983	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	Primary	9477	2009-01-01 00:00:00
tiburonia	5983	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	Synonym	9478	2009-01-01 00:00:00
Tiburonia granrojo	5984	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	Primary	9479	2009-01-01 00:00:00
gumdrop	5984	unknown	Common	9480	2009-01-01 00:00:00
big-ugly	5984	unknown	Common	9481	2009-01-01 00:00:00
big-red	5984	unknown	Common	9482	2009-01-01 00:00:00
tiburonia-granrojo	5984	G. I. Matsumoto , K. A. Raskoff and D. J. Lindsay, 2003	Synonym	9483	2009-01-01 00:00:00
Stygiomedusinae	5985	unknown	Primary	9484	2009-01-01 00:00:00
stygiomedusinae	5985	unknown	Synonym	9485	2009-01-01 00:00:00
Stygiomedusa fabulosa	5986	Russell, 1959	Primary	9486	2009-01-01 00:00:00
stygiomedusa-fabulosa	5986	Russell, 1959	Synonym	9487	2009-01-01 00:00:00
Stellamedusinae	5987	Raskoff and Matsumoto, 2004	Primary	9488	2009-01-01 00:00:00
stellamedusinae	5987	Raskoff and Matsumoto, 2004	Synonym	9489	2009-01-01 00:00:00
Stellamedusa	5988	unknown	Primary	9490	2009-01-01 00:00:00
stellamedusa	5988	unknown	Synonym	9491	2009-01-01 00:00:00
Stellamedusa ventana	5989	Raskoff and Matsumoto, 2004	Primary	9492	2009-01-01 00:00:00
Bumpy	5989	Raskoff and Matsumoto, 2004	Common	9493	2009-01-01 00:00:00
stellamedusa ventana	5989	Raskoff and Matsumoto, 2004	Synonym	9494	2009-01-01 00:00:00
Cyaneidae	5990	unknown	Primary	9495	2009-01-01 00:00:00
cyaneidae	5990	unknown	Synonym	9496	2009-01-01 00:00:00
Cyanea	5991	person and lesueur, 1809	Primary	9497	2009-01-01 00:00:00
cyanea	5991	person and lesueur, 1809	Synonym	9498	2009-01-01 00:00:00
Cyanea capillata	5992	(linnaeus, 1758)	Primary	9499	2009-01-01 00:00:00
lion-mane	5992	amer. fisheries society, 1991	Common	9500	2009-01-01 00:00:00
cyanea-capillata	5992	(linnaeus, 1758)	Synonym	9501	2009-01-01 00:00:00
Cubozoa	5993	unknown	Primary	9502	2009-01-01 00:00:00
box-jelly	5993	unknown	Common	9503	2009-01-01 00:00:00
sea-wasp	5993	unknown	Common	9504	2009-01-01 00:00:00
Medusae	5994	unknown	Primary	9505	2009-01-01 00:00:00
jelly, unidentified from Hydrozoa or Scyphozoa	5994	MBARI-only designation	Common	9506	2009-01-01 00:00:00
Hydrozoa	5995	Owen, 1843	Primary	9507	2009-01-01 00:00:00
hydrozoan	5995	amer. fisheries society, 1991	Common	9508	2009-01-01 00:00:00
hydroid	5995	unknown	Common	9509	2009-01-01 00:00:00
hydralike-animal	5995	(n.o.d.c.)	Common	9510	2009-01-01 00:00:00
Hydromedusae	5996	unknown	Primary	9511	2009-01-01 00:00:00
Leptolida	5996		Common	9512	2009-01-01 00:00:00
Anthomedusae	5997	unknown	Primary	9513	2009-01-01 00:00:00
athecate-hydroid	5997	unknown	Common	9514	2009-01-01 00:00:00
Anthoathecatae	5997		Synonym	9515	2009-01-01 00:00:00
Polyorchidae	5998	unknown	Primary	9516	2009-01-01 00:00:00
Scrippsia	5999	torrey, 1909	Primary	9517	2009-01-01 00:00:00
scrippsia	5999	torrey, 1909	Synonym	9518	2009-01-01 00:00:00
Scrippsia pacifica	6000	torrey, 1909	Primary	9519	2009-01-01 00:00:00
scrippsia-pacifica	6000	torrey, 1909	Synonym	9520	2009-01-01 00:00:00
Polyorchis	6001	unknown	Primary	9521	2009-01-01 00:00:00
polyorchis	6001	unknown	Synonym	9522	2009-01-01 00:00:00
Myriothelidae	6002	unknown	Primary	9523	2009-01-01 00:00:00
Myriothela	6003	sars, 1851	Primary	9524	2009-01-01 00:00:00
myriothela	6003	sars, 1851	Synonym	9525	2009-01-01 00:00:00
Bougainvilliidae	6004	Lütken, 1850	Primary	9526	2009-01-01 00:00:00
Chiarella	6005	Maas, 1897	Primary	9527	2009-01-01 00:00:00
chiarella	6005	Maas, 1897	Synonym	9528	2009-01-01 00:00:00
Chiarella centripetalis	6006	Mass, 1897	Primary	9529	2009-01-01 00:00:00
Capitata	6007	unknown	Primary	9530	2009-01-01 00:00:00
Corynoidea	6008	unknown	Primary	9531	2009-01-01 00:00:00
corynoidea	6008	unknown	Synonym	9532	2009-01-01 00:00:00
Corynidae	6009	unknown	Primary	9533	2009-01-01 00:00:00
corynidae	6009	unknown	Synonym	9534	2009-01-01 00:00:00
Sarsia	6010	lesson, 1843	Primary	9535	2009-01-01 00:00:00
sarsia	6010	lesson, 1843	Synonym	9536	2009-01-01 00:00:00
Tubularoidea	6011	unknown	Primary	9537	2009-01-01 00:00:00
tubularoidea	6011	unknown	Synonym	9538	2009-01-01 00:00:00
Velellidae	6012	unknown	Primary	9539	2009-01-01 00:00:00
velellidae	6012	unknown	Synonym	9540	2009-01-01 00:00:00
Velella	6013	unknown	Primary	9541	2009-01-01 00:00:00
velella	6013	unknown	Synonym	9542	2009-01-01 00:00:00
Velella velella	6014	(linnaeus, 1758)	Primary	9543	2009-01-01 00:00:00
by-the-wind-sailor	6014	amer. fisheries society, 1991	Common	9544	2009-01-01 00:00:00
velella-velella	6014	(linnaeus, 1758)	Synonym	9545	2009-01-01 00:00:00
Corymorphidae	6015	unknown	Primary	9546	2009-01-01 00:00:00
corymorphidae	6015	unknown	Synonym	9547	2009-01-01 00:00:00
Euphysa	6016	forbes, 1848	Primary	9548	2009-01-01 00:00:00
euphysa	6016	forbes, 1848	Synonym	9549	2009-01-01 00:00:00
Euphysa japonica	6017	Maas, 1909	Primary	9550	2009-01-01 00:00:00
Euphysa flammea	6018	Linko, 1904	Primary	9551	2009-01-01 00:00:00
Euphysora	6019	unknown	Primary	9552	2009-01-01 00:00:00
euphysora	6019	unknown	Synonym	9553	2009-01-01 00:00:00
Euphysora valdiviae	6020	(kramp 1968)	Primary	9554	2009-01-01 00:00:00
euphysora-valdiviae	6020	(kramp 1968)	Synonym	9555	2009-01-01 00:00:00
Euphysora gigantea	6021	unknown	Primary	9556	2009-01-01 00:00:00
Tubularidae	6022	unknown	Primary	9557	2009-01-01 00:00:00
tubularidae	6022	unknown	Synonym	9558	2009-01-01 00:00:00
Tubularia	6023	linnaeus,1758	Primary	9559	2009-01-01 00:00:00
tubularia	6023	linnaeus,1758	Synonym	9560	2009-01-01 00:00:00
Hydractinia	6024	unknown	Primary	9561	2009-01-01 00:00:00
hydractinia	6024	unknown	Synonym	9562	2009-01-01 00:00:00
Filifera	6025	unknown	Primary	9563	2009-01-01 00:00:00
Pandeidae	6026	unknown	Primary	9564	2009-01-01 00:00:00
pandeidae	6026	unknown	Synonym	9565	2009-01-01 00:00:00
Neoturris	6027	unknown	Primary	9566	2009-01-01 00:00:00
neoturris	6027	unknown	Synonym	9567	2009-01-01 00:00:00
Neoturris breviconis	6028	unknown	Primary	9568	2009-01-01 00:00:00
neoturris-breviconis	6028	unknown	Synonym	9569	2009-01-01 00:00:00
Pandea	6029	unknown	Primary	9570	2009-01-01 00:00:00
pandea	6029	unknown	Synonym	9571	2009-01-01 00:00:00
Pandea rubra	6030	(bigelow 1913)	Primary	9572	2009-01-01 00:00:00
pandea-rubra	6030	(bigelow 1913)	Synonym	9573	2009-01-01 00:00:00
Leuckartiara	6031	hartlaub, 1914	Primary	9574	2009-01-01 00:00:00
leuckartiara	6031	hartlaub, 1914	Synonym	9575	2009-01-01 00:00:00
Merga	6032	unknown	Primary	9576	2009-01-01 00:00:00
merga	6032	unknown	Synonym	9577	2009-01-01 00:00:00
Merga reesi	6033	unknown	Primary	9578	2009-01-01 00:00:00
merga-reesi	6033	unknown	Synonym	9579	2009-01-01 00:00:00
Merga-reesi	6033	unknown	Synonym	9580	2009-01-01 00:00:00
Annatiara	6034	unknown	Primary	9581	2009-01-01 00:00:00
annatiara	6034	unknown	Synonym	9582	2009-01-01 00:00:00
Annatiara affinis	6035	unknown	Primary	9583	2009-01-01 00:00:00
annatiara-affinis	6035	unknown	Synonym	9584	2009-01-01 00:00:00
Calycopsidae	6036	unknown	Primary	9585	2009-01-01 00:00:00
Eumedusa	6037	unknown	Primary	9586	2009-01-01 00:00:00
Calycopsis	6038	fewkes, 1882	Primary	9587	2009-01-01 00:00:00
Sibogita	6038	unknown	Synonym	9588	2009-01-01 00:00:00
Calycopsis simulans	6039	Bigelow, 1909	Primary	9589	2009-01-01 00:00:00
Bythotiara	6040	Gunther, 1903	Primary	9590	2009-01-01 00:00:00
Bythotiara dolioeques	6041	Raskoff and Robison, 2005	Primary	9591	2009-01-01 00:00:00
Bythotiara depressa	6042	Naumov, 1960	Primary	9592	2009-01-01 00:00:00
Hydractiniidae	6043	Agassiz, 1862	Primary	9593	2009-01-01 00:00:00
Trachymedusae	6044	unknown	Primary	9594	2009-01-01 00:00:00
Geryoniidae	6045	unknown	Primary	9595	2009-01-01 00:00:00
Liriope	6046	unknown	Primary	9596	2009-01-01 00:00:00
liriope	6046	unknown	Synonym	9597	2009-01-01 00:00:00
Liriope tetraphylla	6047	unknown	Primary	9598	2009-01-01 00:00:00
liriope-tetraphylla	6047	unknown	Synonym	9599	2009-01-01 00:00:00
Geryonia	6048	Peron and Lesueur, 1809	Primary	9600	2009-01-01 00:00:00
geryonia	6048	Peron and Lesueur, 1809	Synonym	9601	2009-01-01 00:00:00
Geryonia proboscidalis	6049	Forsskal, 1775	Primary	9602	2009-01-01 00:00:00
geryonia-proboscidalis	6049	Forsskal, 1775	Synonym	9603	2009-01-01 00:00:00
Rhopalonematidae	6050	unknown	Primary	9604	2009-01-01 00:00:00
Arctapodema	6051	dall, 1907	Primary	9605	2009-01-01 00:00:00
Colobonema	6052	vanhoffen, 1902	Primary	9606	2009-01-01 00:00:00
Colobonema sericeum	6053	vanhoffen, 1902	Primary	9607	2009-01-01 00:00:00
colobonema-sericeum	6053	vanhoffen, 1902	Synonym	9608	2009-01-01 00:00:00
Aglantha	6054	Haeckel, 1879	Primary	9609	2009-01-01 00:00:00
Aglantha digitalis	6055	O. F. Mueller, 1776	Primary	9610	2009-01-01 00:00:00
aglantha-digitalis	6055	O. F. Mueller, 1776	Synonym	9611	2009-01-01 00:00:00
Voragonema	6056	naumov, 1971	Primary	9612	2009-01-01 00:00:00
Voragonema pedunculata	6057	unknown	Primary	9613	2009-01-01 00:00:00
benthocodon-pedunculata	6057	unknown	Synonym	9614	2009-01-01 00:00:00
voragonema-pedunculata	6057	unknown	Synonym	9615	2009-01-01 00:00:00
Voragonema laciniata	6058	unknown	Primary	9616	2009-01-01 00:00:00
voragonema-laciniata	6058	unknown	Synonym	9617	2009-01-01 00:00:00
Rhopalonema	6059	gegenbaur, 1856	Primary	9618	2009-01-01 00:00:00
Rhopalonema funerarium	6060	Vanhoffen, 1902	Primary	9619	2009-01-01 00:00:00
Tetrorchis	6061	bigelow, 1909	Primary	9620	2009-01-01 00:00:00
Tetrorchis erythrogaster	6062	bigelow, 1909	Primary	9621	2009-01-01 00:00:00
tetrorchis-erythrogaster	6062	bigelow, 1909	Synonym	9622	2009-01-01 00:00:00
Crossota	6063	vanhoffen, 1902	Primary	9623	2009-01-01 00:00:00
Crossota alba	6064	unknown	Primary	9624	2009-01-01 00:00:00
crossota-alba	6064	unknown	Synonym	9625	2009-01-01 00:00:00
Crossota millsae	6065	Thuesen, 2003	Primary	9626	2009-01-01 00:00:00
crossota-millsae	6065	Thuesen, 2003	Synonym	9627	2009-01-01 00:00:00
Crossota rufobrunnea	6066	unknown	Primary	9628	2009-01-01 00:00:00
crossota-rufobrunnea	6066	unknown	Synonym	9629	2009-01-01 00:00:00
Crossota pedunculata	6067	bigelow, 1913	Primary	9630	2009-01-01 00:00:00
crossota-pedunculata	6067	bigelow, 1913	Synonym	9631	2009-01-01 00:00:00
Pantachogon	6068	Maas, 1893	Primary	9632	2009-01-01 00:00:00
Pantachogon haeckeli	6069	unknown	Primary	9633	2009-01-01 00:00:00
pantachogon-haeckeli	6069	unknown	Synonym	9634	2009-01-01 00:00:00
Benthocodon	6070	unknown	Primary	9635	2009-01-01 00:00:00
Benthocodon hiatus	6071	unknown	Primary	9636	2009-01-01 00:00:00
benthocodon-hiatus	6071	unknown	Synonym	9637	2009-01-01 00:00:00
Vampyrocrossota	6072	unknown	Primary	9638	2009-01-01 00:00:00
Vampyrocrossota childressi	6073	unknown	Primary	9639	2009-01-01 00:00:00
vampyrocrossota childressi	6073	unknown	Synonym	9640	2009-01-01 00:00:00
LRJ complex	6074	\N	Primary	9641	2009-01-01 00:00:00
Ptychogastriidae	6075	unknown	Primary	9642	2009-01-01 00:00:00
Ptychogastria	6076	allman, 1878	Primary	9643	2009-01-01 00:00:00
ptychogastria	6076	allman, 1878	Synonym	9644	2009-01-01 00:00:00
Ptychogastria polaris	6077	allman, 1878	Primary	9645	2009-01-01 00:00:00
benthic-jelly	6077	unknown	Common	9646	2009-01-01 00:00:00
ptychogastria-polaris	6077	allman, 1878	Synonym	9647	2009-01-01 00:00:00
Halicreatidae	6078	unknown	Primary	9648	2009-01-01 00:00:00
Botrynema	6079	unknown	Primary	9649	2009-01-01 00:00:00
botrynema	6079	unknown	Synonym	9650	2009-01-01 00:00:00
Botrynema brucei	6080	Browne, 1908	Primary	9651	2009-01-01 00:00:00
botrynema-brucei	6080	Browne, 1908	Synonym	9652	2009-01-01 00:00:00
Haliscera	6081	vanhoeffen, 1902	Primary	9653	2009-01-01 00:00:00
single-dot-medusa	6081	unknown	Common	9654	2009-01-01 00:00:00
double-dot-medusa	6081	unknown	Common	9655	2009-01-01 00:00:00
haliscera	6081	vanhoeffen, 1902	Synonym	9656	2009-01-01 00:00:00
Haliscera bigelowi	6082	Kramp, 1947	Primary	9657	2009-01-01 00:00:00
haliscera-bigelowi	6082	Kramp, 1947	Synonym	9658	2009-01-01 00:00:00
Haliscera conica	6083	Vanhoeffen, 1902	Primary	9659	2009-01-01 00:00:00
haliscera-conica	6083	Vanhoeffen, 1902	Synonym	9660	2009-01-01 00:00:00
Halitrephes	6084	unknown	Primary	9661	2009-01-01 00:00:00
Halitrephes maasi	6085	unknown	Primary	9662	2009-01-01 00:00:00
	6085	H. B. Bigelow, 1909	Synonym	9663	2009-01-01 00:00:00
Halicreas	6086	fewkws, 1882	Primary	9664	2009-01-01 00:00:00
halicreas	6086	fewkws, 1882	Synonym	9665	2009-01-01 00:00:00
Halicreas minimum	6087	fewkes, 1882	Primary	9666	2009-01-01 00:00:00
halicreas-minimum	6087	fewkes, 1882	Synonym	9667	2009-01-01 00:00:00
Amphigona	6088	unknown	Primary	9668	2009-01-01 00:00:00
Amphigona apicata	6089	unknown	Primary	9669	2009-01-01 00:00:00
amphigona-apicata	6089	unknown	Synonym	9670	2009-01-01 00:00:00
Leptomedusae	6090	unknown	Primary	9671	2009-01-01 00:00:00
thecate-hydroid	6090	unknown	Common	9672	2009-01-01 00:00:00
Tiaropsidae	6091	unknown	Primary	9673	2009-01-01 00:00:00
tiaropsidae	6091	unknown	Synonym	9674	2009-01-01 00:00:00
Tiaropsidium	6092	unknown	Primary	9675	2009-01-01 00:00:00
tiaropsidium	6092	unknown	Synonym	9676	2009-01-01 00:00:00
Tiaropsidium kelseyi	6093	torrey 1909	Primary	9677	2009-01-01 00:00:00
tiaropsidium-kelseyi	6093	torrey 1909	Synonym	9678	2009-01-01 00:00:00
Phialellidae	6094	unknown	Primary	9679	2009-01-01 00:00:00
phialellidae	6094	unknown	Synonym	9680	2009-01-01 00:00:00
Phialella	6095	browne, 1902	Primary	9681	2009-01-01 00:00:00
phialella	6095	browne, 1902	Synonym	9682	2009-01-01 00:00:00
Dipleurosomatidae	6096	unknown	Primary	9683	2009-01-01 00:00:00
Dipleurosoma	6097	unknown	Primary	9684	2009-01-01 00:00:00
dipleurosoma	6097	unknown	Synonym	9685	2009-01-01 00:00:00
Dipleurosoma typicum	6098	unknown	Primary	9686	2009-01-01 00:00:00
dipleurosoma-typicum	6098	unknown	Synonym	9687	2009-01-01 00:00:00
Campanulinidae	6099	unknown	Primary	9688	2009-01-01 00:00:00
Campulinidae	6099	unknown	Synonym	9689	2009-01-01 00:00:00
Eutima	6100	mccrady, 1857	Primary	9690	2009-01-01 00:00:00
eutima	6100	mccrady, 1857	Synonym	9691	2009-01-01 00:00:00
Laodiceidae	6101	unknown	Primary	9692	2009-01-01 00:00:00
Ptychogena	6102	a. agassiz, 1865	Primary	9693	2009-01-01 00:00:00
ptychogena	6102	a. agassiz, 1865	Synonym	9694	2009-01-01 00:00:00
Ptychogena lactea	6103	a. agassiz, 1865	Primary	9695	2009-01-01 00:00:00
ptychogena-lactea	6103	a. agassiz, 1865	Synonym	9696	2009-01-01 00:00:00
Plumulariidae	6104	unknown	Primary	9697	2009-01-01 00:00:00
plumulariidae	6104	unknown	Synonym	9698	2009-01-01 00:00:00
Aglaophenia	6105	lamouroux,1812	Primary	9699	2009-01-01 00:00:00
aglaophenia	6105	lamouroux,1812	Synonym	9700	2009-01-01 00:00:00
Aequoreidae	6106	unknown	Primary	9701	2009-01-01 00:00:00
aequoreidae	6106	unknown	Synonym	9702	2009-01-01 00:00:00
Aequorea	6107	peron and lesueur, 1809	Primary	9703	2009-01-01 00:00:00
aequorea	6107	peron and lesueur, 1809	Synonym	9704	2009-01-01 00:00:00
Aequorea victoria	6108	(murbach and shearer, 1902)	Primary	9705	2009-01-01 00:00:00
water-jellyfish	6108	amer. fisheries society, 1991	Common	9706	2009-01-01 00:00:00
aequorea-victoria	6108	(murbach and shearer, 1902)	Synonym	9707	2009-01-01 00:00:00
Aequorea aequorea	6109	(forsskal, 1775)	Primary	9708	2009-01-01 00:00:00
medusa-aequorea	6109	forsskal, 1775	Synonym	9709	2009-01-01 00:00:00
aequorea-aequorea	6109	(forsskal, 1775)	Synonym	9710	2009-01-01 00:00:00
Campanulariidae	6110	unknown	Primary	9711	2009-01-01 00:00:00
campanulariidae	6110	unknown	Synonym	9712	2009-01-01 00:00:00
Phialidium	6111	unknown	Primary	9713	2009-01-01 00:00:00
phialidium	6111	unknown	Synonym	9714	2009-01-01 00:00:00
Tiarannidae	6112	unknown	Primary	9715	2009-01-01 00:00:00
tiarannidae	6112	unknown	Synonym	9716	2009-01-01 00:00:00
Chromatonema	6113	fewkes, 1882	Primary	9717	2009-01-01 00:00:00
chromatonema	6113	fewkes, 1882	Synonym	9718	2009-01-01 00:00:00
Chromatonema rubrum	6114	Fewkes, 1882	Primary	9719	2009-01-01 00:00:00
Modeeria	6115	unknown	Primary	9720	2009-01-01 00:00:00
modeeria	6115	unknown	Synonym	9721	2009-01-01 00:00:00
Modeeria rotunda	6116	(Quoy and Gaimard, 1827)	Primary	9722	2009-01-01 00:00:00
tiaranna-rotunda	6116	unknown	Synonym	9723	2009-01-01 00:00:00
modeeria-rotunda	6116	(Quoy and Gaimard, 1827)	Synonym	9724	2009-01-01 00:00:00
Tiaranna	6117	Hartlaub, 1913	Primary	9725	2009-01-01 00:00:00
tiaranna	6117	Hartlaub, 1913	Synonym	9726	2009-01-01 00:00:00
Mitrocomidae	6118	unknown	Primary	9727	2009-01-01 00:00:00
mitrocomidae	6118	unknown	Synonym	9728	2009-01-01 00:00:00
Mitrocoma	6119	haeckel, 1864	Primary	9729	2009-01-01 00:00:00
mitrocoma	6119	haeckel, 1864	Synonym	9730	2009-01-01 00:00:00
Mitrocoma cellularia	6120	(a. agassiz, 1865)	Primary	9731	2009-01-01 00:00:00
cross-jellyfish	6120	amer. fisheries society, 1991	Common	9732	2009-01-01 00:00:00
mitrocoma-cellularia	6120	(a. agassiz, 1865)	Synonym	9733	2009-01-01 00:00:00
Octogonade	6121	zoja, 1896	Primary	9734	2009-01-01 00:00:00
octogonade	6121	zoja, 1896	Synonym	9735	2009-01-01 00:00:00
Octogonade mediterranea	6122	zoja, 1896	Primary	9736	2009-01-01 00:00:00
octogonade-mediterranea	6122	zoja, 1896	Synonym	9737	2009-01-01 00:00:00
Earleria	6123	(Szépligeti, 1896)	Primary	9738	2009-01-01 00:00:00
Foersteria	6123	unknown	Synonym	9739	2009-01-01 00:00:00
Earleria purpurea	6124	(Foerster, 1923)	Primary	9740	2009-01-01 00:00:00
Foersteria purpurea	6124	unknown	Synonym	9741	2009-01-01 00:00:00
Eutimidae	6125	unknown	Primary	9742	2009-01-01 00:00:00
Tima	6126	eschscholtz, 1829	Primary	9743	2009-01-01 00:00:00
tima	6126	eschscholtz, 1829	Synonym	9744	2009-01-01 00:00:00
Eirenidae	6127	unknown	Primary	9745	2009-01-01 00:00:00
Eutonina	6128	unknown	Primary	9746	2009-01-01 00:00:00
eutonina	6128	unknown	Synonym	9747	2009-01-01 00:00:00
Eutonina indicans	6129	unknown	Primary	9748	2009-01-01 00:00:00
eutonina-indicans	6129	unknown	Synonym	9749	2009-01-01 00:00:00
Narcomedusae	6130	unknown	Primary	9750	2009-01-01 00:00:00
Aeginidae	6131	unknown	Primary	9751	2009-01-01 00:00:00
aeginidae	6131	unknown	Synonym	9752	2009-01-01 00:00:00
Aegina	6132	eschscholtz, 1829	Primary	9753	2009-01-01 00:00:00
Aegina citrea	6133	eschscholtz, 1829	Primary	9754	2009-01-01 00:00:00
Aegina rosea	6134	unknown	Primary	9755	2009-01-01 00:00:00
Solmundella	6135	haeckel, 1879	Primary	9756	2009-01-01 00:00:00
solmundella	6135	haeckel, 1879	Synonym	9757	2009-01-01 00:00:00
Solmundella bitentaculata	6136	(quoy and gaimard, 1833)	Primary	9758	2009-01-01 00:00:00
solmundella-bitentaculata	6136	(quoy and gaimard, 1833)	Synonym	9759	2009-01-01 00:00:00
Aeginura	6137	unknown	Primary	9760	2009-01-01 00:00:00
Aeginura grimaldii	6138	maas, 1904	Primary	9761	2009-01-01 00:00:00
aeginura-grimaldii	6138	maas, 1904	Synonym	9762	2009-01-01 00:00:00
Solmarisidae	6139	unknown	Primary	9763	2009-01-01 00:00:00
Solmaris	6140	unknown	Primary	9764	2009-01-01 00:00:00
Pegantha	6141	unknown	Primary	9765	2009-01-01 00:00:00
Pegantha clara	6142	H. B. Bigelow, 1909	Primary	9766	2009-01-01 00:00:00
pegantha clara	6142	H. B. Bigelow, 1909	Synonym	9767	2009-01-01 00:00:00
Cuninidae	6143	unknown	Primary	9768	2009-01-01 00:00:00
cuninidae	6143	unknown	Synonym	9769	2009-01-01 00:00:00
Solmissus	6144	Haeckel, 1879	Primary	9770	2009-01-01 00:00:00
Solmissus incisa	6145	unknown	Primary	9771	2009-01-01 00:00:00
solmissus-incisus	6145	unknown	Synonym	9772	2009-01-01 00:00:00
solmissus-incisa	6145	unknown	Synonym	9773	2009-01-01 00:00:00
Solmissus marshalli	6146	a. agassiz and mayer, 1902	Primary	9774	2009-01-01 00:00:00
solmissus-marshalli	6146	a. agassiz and mayer, 1902	Synonym	9775	2009-01-01 00:00:00
Cunina	6147	unknown	Primary	9776	2009-01-01 00:00:00
cunina	6147	unknown	Synonym	9777	2009-01-01 00:00:00
Tetraplatia	6148	Busch, 1851	Primary	9778	2009-01-01 00:00:00
Tetraplatia volitans	6149	Busch, 1851	Primary	9779	2009-01-01 00:00:00
Milleporina	6150	unknown	Primary	9780	2009-01-01 00:00:00
fire-coral	6150	unknown	Common	9781	2009-01-01 00:00:00
millepore-hydrocoral	6150	unknown	Common	9782	2009-01-01 00:00:00
Hydroida	6151	unknown	Primary	9783	2009-01-01 00:00:00
purple hydroid	6152	unknown	Primary	9784	2009-01-01 00:00:00
purple-hydroid	6152	unknown	Synonym	9785	2009-01-01 00:00:00
Siphonophora	6153	eschscholtz, 1829	Primary	9786	2009-01-01 00:00:00
siphonophore	6153	unknown	Common	9787	2009-01-01 00:00:00
Calycophorae	6154	unknown	Primary	9788	2009-01-01 00:00:00
Hippopodiidae	6155	unknown	Primary	9789	2009-01-01 00:00:00
Vogtia	6156	unknown	Primary	9790	2009-01-01 00:00:00
vogtia	6156	unknown	Synonym	9791	2009-01-01 00:00:00
Vogtia spinosa	6157	keferstein and ehlers, 1861	Primary	9792	2009-01-01 00:00:00
vogtia-spinosa	6157	keferstein and ehlers, 1861	Synonym	9793	2009-01-01 00:00:00
Vogtia serrata	6158	moser, 1913	Primary	9794	2009-01-01 00:00:00
vogtia-serrata	6158	moser, 1913	Synonym	9795	2009-01-01 00:00:00
Vogtia pentacantha	6159	kolliker, 1853	Primary	9796	2009-01-01 00:00:00
vogtia-pentacantha	6159	kolliker, 1853	Synonym	9797	2009-01-01 00:00:00
Vogtia glabra	6160	bigelow, 1918	Primary	9798	2009-01-01 00:00:00
vogtia-glabra	6160	bigelow, 1918	Synonym	9799	2009-01-01 00:00:00
Hippopodius	6161	unknown	Primary	9800	2009-01-01 00:00:00
hippopodius	6161	unknown	Synonym	9801	2009-01-01 00:00:00
Hippopodius hippopus	6162	(forsskal 1776)	Primary	9802	2009-01-01 00:00:00
hippopodius-hippopus	6162	(forsskal 1776)	Synonym	9803	2009-01-01 00:00:00
Clausophyidae	6163	Totton, 1965	Primary	9804	2009-01-01 00:00:00
Chuniphyes	6164	Lens & van Riemsdijk, 1908	Primary	9805	2009-01-01 00:00:00
chuniphyes	6164	Lens & van Riemsdijk, 1908	Synonym	9806	2009-01-01 00:00:00
Chuniphyes multidentata	6165	Lens & van Riemsdijk, 1908	Primary	9807	2009-01-01 00:00:00
chuniphyes-multidentata	6165	Lens & van Riemsdijk, 1908	Synonym	9808	2009-01-01 00:00:00
Chuniphyes moserae	6166	Totton, 1954	Primary	9809	2009-01-01 00:00:00
chuniphyes moserae	6166	Totton, 1954	Synonym	9810	2009-01-01 00:00:00
Clausophyes	6167	unknown	Primary	9811	2009-01-01 00:00:00
clausophyes	6167	unknown	Synonym	9812	2009-01-01 00:00:00
Clausophyes moserae	6168	(Margulis 1988)	Primary	9813	2009-01-01 00:00:00
clausophyes moserae	6168	(Margulis 1988)	Synonym	9814	2009-01-01 00:00:00
Kephyes	6169	Pugh, 2006	Primary	9815	2009-01-01 00:00:00
Kephyes ovata	6170	Pugh, 2006	Primary	9816	2009-01-01 00:00:00
clausophyes ovata	6170	(Keferstein and Ehlers, 1860)	Synonym	9817	2009-01-01 00:00:00
Sphaeronectidae	6171	unknown	Primary	9818	2009-01-01 00:00:00
Sphaeronectes	6172	unknown	Primary	9819	2009-01-01 00:00:00
sphaeronectes	6172	unknown	Synonym	9820	2009-01-01 00:00:00
Sphaeronectes gracilis	6173	claus, 1873	Primary	9821	2009-01-01 00:00:00
sphaeronectes-gracilis	6173	claus, 1873	Synonym	9822	2009-01-01 00:00:00
Diphyidae	6174	unknown	Primary	9823	2009-01-01 00:00:00
Diphyinae	6175	unknown	Primary	9824	2009-01-01 00:00:00
diphyinae	6175	unknown	Synonym	9825	2009-01-01 00:00:00
Lensia	6176	totton, 1932	Primary	9826	2009-01-01 00:00:00
lensia	6176	totton, 1932	Synonym	9827	2009-01-01 00:00:00
Lensia conoidea	6177	unknown	Primary	9828	2009-01-01 00:00:00
lensia-conoidea	6177	unknown	Synonym	9829	2009-01-01 00:00:00
Lensia hostile	6178	Totton, 1941	Primary	9830	2009-01-01 00:00:00
lensia hostile	6178	Totton, 1941	Synonym	9831	2009-01-01 00:00:00
Lensia baryi	6179	Totton, 1965	Primary	9832	2009-01-01 00:00:00
Lensia achilles	6180	Totton, 1941	Primary	9833	2009-01-01 00:00:00
Muggiaea	6181	unknown	Primary	9834	2009-01-01 00:00:00
muggiaea	6181	unknown	Synonym	9835	2009-01-01 00:00:00
Prayidae	6182	unknown	Primary	9836	2009-01-01 00:00:00
Prayinae	6183	unknown	Primary	9837	2009-01-01 00:00:00
Desmophyes	6184	unknown	Primary	9838	2009-01-01 00:00:00
desmophyes	6184	unknown	Synonym	9839	2009-01-01 00:00:00
Desmophyes haematogaster	6185	(Pugh 1992)	Primary	9840	2009-01-01 00:00:00
desmophyes haematogaster	6185	(Pugh 1992)	Synonym	9841	2009-01-01 00:00:00
Desmophyes annectens	6186	Haeckel, 1888	Primary	9842	2009-01-01 00:00:00
Praya	6187	unknown	Primary	9843	2009-01-01 00:00:00
Praya dubia	6188	(quoy and gaimard, 1833)	Primary	9844	2009-01-01 00:00:00
praya-dubia	6188	(quoy and gaimard, 1833)	Synonym	9845	2009-01-01 00:00:00
Praya reticulata	6189	(h. b. bigelow, 1911)	Primary	9846	2009-01-01 00:00:00
praya-reticulata	6189	(h. b. bigelow, 1911)	Synonym	9847	2009-01-01 00:00:00
Rosacea	6190	unknown	Primary	9848	2009-01-01 00:00:00
rosacea	6190	unknown	Synonym	9849	2009-01-01 00:00:00
Rosacea cymbiformis	6191	delle Chiaje, 1822	Primary	9850	2009-01-01 00:00:00
Craseoa	6192	unknown	Primary	9851	2009-01-01 00:00:00
craseoa	6192	unknown	Synonym	9852	2009-01-01 00:00:00
Craseoa lathetica	6193	Pugh & Harbison, 1987	Primary	9853	2009-01-01 00:00:00
craseoa lathetica	6193	Pugh & Harbison, 1987	Synonym	9854	2009-01-01 00:00:00
Gymnopraia	6194	Haddock et al., 2005	Primary	9855	2009-01-01 00:00:00
Gymnopraia lapislazula	6195	Haddock et al., 2005	Primary	9856	2009-01-01 00:00:00
Lilyopsis	6196	unknown	Primary	9857	2009-01-01 00:00:00
Lilyopsis fluoracantha	6197	Haddock et al., 2005	Primary	9858	2009-01-01 00:00:00
Stephanophyes	6198	Chun, 1888	Primary	9859	2009-01-01 00:00:00
Stephanophyes superba	6199	Chun, 1888	Primary	9860	2009-01-01 00:00:00
Amphicaryoninae 	6200	\N	Primary	9861	2009-01-01 00:00:00
Maresearsia	6201	unknown	Primary	9862	2009-01-01 00:00:00
maresearsia	6201	unknown	Synonym	9863	2009-01-01 00:00:00
Maresearsia praeclara	6202	Totton, 1954	Primary	9864	2009-01-01 00:00:00
maresearsia praeclara	6202	Totton, 1954	Synonym	9865	2009-01-01 00:00:00
Amphicaryon	6203	Chun, 1888	Primary	9866	2009-01-01 00:00:00
Amphicaryon acaule	6204	Chun, 1888	Primary	9867	2009-01-01 00:00:00
Amphicaryon ernesti	6205	Totton, 1954	Primary	9868	2009-01-01 00:00:00
Amphicaryon peltifera	6206	(Haeckel, 1888)	Primary	9869	2009-01-01 00:00:00
Nectopyramidinae	6207	\N	Primary	9870	2009-01-01 00:00:00
Nectopyramis	6208	Bigelow, 1911	Primary	9871	2009-01-01 00:00:00
Nectopyramis natans	6209	(H. B. Bigelow, 1911)	Primary	9872	2009-01-01 00:00:00
nectopyramis natans	6209	(H. B. Bigelow, 1911)	Synonym	9873	2009-01-01 00:00:00
Nectopyramis thetis	6210	Bigelow, 1911	Primary	9874	2009-01-01 00:00:00
Nectadamas 	6211	Pugh, 1992	Primary	9875	2009-01-01 00:00:00
Nectadamas diomedeae	6212	H. B. Bigelow, 1911	Primary	9876	2009-01-01 00:00:00
Cystonectae	6213	unknown	Primary	9877	2009-01-01 00:00:00
Physaliidae	6214	unknown	Primary	9878	2009-01-01 00:00:00
physaliidae	6214	unknown	Synonym	9879	2009-01-01 00:00:00
Physalia	6215	unknown	Primary	9880	2009-01-01 00:00:00
physalia	6215	unknown	Synonym	9881	2009-01-01 00:00:00
Physalia physalis	6216	unknown	Primary	9882	2009-01-01 00:00:00
portuguese-man-of-war	6216	unknown	Common	9883	2009-01-01 00:00:00
physalia-physalis	6216	unknown	Synonym	9884	2009-01-01 00:00:00
Bathyphysa	6217	unknown	Primary	9885	2009-01-01 00:00:00
bathyphysa	6217	unknown	Synonym	9886	2009-01-01 00:00:00
Bathyphysa conifera	6218	Studer, 1878	Primary	9887	2009-01-01 00:00:00
Rhizophysidae	6219	unknown	Primary	9888	2009-01-01 00:00:00
rhizophysidae	6219	unknown	Synonym	9889	2009-01-01 00:00:00
Rhizophysa	6220	peron & leseur,1807	Primary	9890	2009-01-01 00:00:00
rhizophysa	6220	peron & leseur,1807	Synonym	9891	2009-01-01 00:00:00
Physonectae	6221	unknown	Primary	9892	2009-01-01 00:00:00
Physophorae	6221	unknown	Synonym	9893	2009-01-01 00:00:00
physonect	6221	unknown	Common	9894	2009-01-01 00:00:00
Physophoridae	6222	unknown	Primary	9895	2009-01-01 00:00:00
Physophora	6223	forskal, 1775	Primary	9896	2009-01-01 00:00:00
physophora	6223	forskal, 1775	Synonym	9897	2009-01-01 00:00:00
Physophora hydrostatica	6224	forsskal, 1775	Primary	9898	2009-01-01 00:00:00
physophora-hydrostatica	6224	forsskal, 1775	Synonym	9899	2009-01-01 00:00:00
Agalmidae	6225	unknown	Primary	9900	2009-01-01 00:00:00
Agalmatidae	6225	unknown	Synonym	9901	2009-01-01 00:00:00
Lychnagalma	6226	unknown	Primary	9902	2009-01-01 00:00:00
Lychnagalma vesicularia	6227	unknown	Primary	9903	2009-01-01 00:00:00
lychnagalma-vesicularia	6227	unknown	Synonym	9904	2009-01-01 00:00:00
Lychnagalma utricularia	6228	unknown	Primary	9905	2009-01-01 00:00:00
lychnagalma-utricularia	6228	unknown	Synonym	9906	2009-01-01 00:00:00
Nanomia	6229	unknown	Primary	9907	2009-01-01 00:00:00
Nanomia cara	6230	a. agassiz, 1865	Primary	9908	2009-01-01 00:00:00
Nanomia bijuga	6231	(delle chiaje, 1841)	Primary	9909	2009-01-01 00:00:00
Frillagalma	6232	unknown	Primary	9910	2009-01-01 00:00:00
Frillagalma vityazi	6233	Daniel, 1966	Primary	9911	2009-01-01 00:00:00
frillagalma-vityazi	6233	Daniel, 1966	Synonym	9912	2009-01-01 00:00:00
Halistemma	6234	unknown	Primary	9913	2009-01-01 00:00:00
Halistemma rubrum	6235	(vogt 1852)	Primary	9914	2009-01-01 00:00:00
halistemma-rubrum	6235	(vogt 1852)	Synonym	9915	2009-01-01 00:00:00
Nanomia 2	6236	unknown	Primary	9916	2009-01-01 00:00:00
nanomia-with-full-gastrozooid	6236	unknown	Common	9917	2009-01-01 00:00:00
nanomia-2	6236	unknown	Synonym	9918	2009-01-01 00:00:00
Agalma	6237	eschscholtz, 1825	Primary	9919	2009-01-01 00:00:00
Marrus	6238	unknown	Primary	9920	2009-01-01 00:00:00
Marrus claudanielis	6239	unknown	Primary	9921	2009-01-01 00:00:00
Marrus orthocanna	6240	Kramp, 1942	Primary	9922	2009-01-01 00:00:00
Cordagalma	6241	unknown	Primary	9923	2009-01-01 00:00:00
Stephanomia	6242	Peron and Lesueur, 1807	Primary	9924	2009-01-01 00:00:00
Stephanomia amphytridis 	6243	Lesueur and Petit, 1807	Primary	9925	2009-01-01 00:00:00
Pyrostephidae	6244	unknown	Primary	9926	2009-01-01 00:00:00
Bargmannia	6245	unknown	Primary	9927	2009-01-01 00:00:00
Bargmannia elongata	6246	Totton, 1954	Primary	9928	2009-01-01 00:00:00
bargmannia-elongata	6246	Totton, 1954	Synonym	9929	2009-01-01 00:00:00
Bargmannia lata	6247	Mapstone, 1998	Primary	9930	2009-01-01 00:00:00
bargmannia lata	6247	Mapstone, 1998	Synonym	9931	2009-01-01 00:00:00
Bargmannia amoena	6248	Pugh, 1999	Primary	9932	2009-01-01 00:00:00
bargmannia amoena	6248	Pugh, 1999	Synonym	9933	2009-01-01 00:00:00
Rhodaliidae	6249	unknown	Primary	9934	2009-01-01 00:00:00
Dromalia	6250	unknown	Primary	9935	2009-01-01 00:00:00
dromalia	6250	unknown	Synonym	9936	2009-01-01 00:00:00
Dromalia alexandri	6251	h. b. bigelow, 1911	Primary	9937	2009-01-01 00:00:00
benthic-siphonophore	6251	unknown	Common	9938	2009-01-01 00:00:00
dromalia-alexandri	6251	h. b. bigelow, 1911	Synonym	9939	2009-01-01 00:00:00
Thermopalia	6252	Pugh, 1983	Primary	9940	2009-01-01 00:00:00
Thermopalia taraxaca	6253	Pugh, 1983	Primary	9941	2009-01-01 00:00:00
Stephalia	6254	Haeckel, 1888	Primary	9942	2009-01-01 00:00:00
Stephalia dilata	6255	Bigelow, 1911	Primary	9943	2009-01-01 00:00:00
Apolemidae	6256	unknown	Primary	9944	2009-01-01 00:00:00
Apolemia	6257	unknown	Primary	9945	2009-01-01 00:00:00
apolemia	6257	unknown	Synonym	9946	2009-01-01 00:00:00
Apolemia uvaria	6258	(lesueur, 1815)	Primary	9947	2009-01-01 00:00:00
apolemia-uvaria	6258	(lesueur, 1815)	Synonym	9948	2009-01-01 00:00:00
Forskaliidae	6259	unknown	Primary	9949	2009-01-01 00:00:00
Forskalia	6260	unknown	Primary	9950	2009-01-01 00:00:00
forskalia	6260	unknown	Synonym	9951	2009-01-01 00:00:00
Forskalia tholoides	6261	haeckel, 1888	Primary	9952	2009-01-01 00:00:00
forskalia-tholoides	6261	haeckel, 1888	Synonym	9953	2009-01-01 00:00:00
Forskalia edwardsi	6262	kolliker, 1853	Primary	9954	2009-01-01 00:00:00
forskalia-edwardsi	6262	kolliker, 1853	Synonym	9955	2009-01-01 00:00:00
Forskalia formosa	6263	unknown	Primary	9956	2009-01-01 00:00:00
forskalia-formosa	6263	unknown	Synonym	9957	2009-01-01 00:00:00
Erennidae	6264	Pugh, 2001	Primary	9958	2009-01-01 00:00:00
Erenna	6265	Bedot, 1904	Primary	9959	2009-01-01 00:00:00
erenna	6265	unknown	Synonym	9960	2009-01-01 00:00:00
Erenna richardi	6266	bedot, 1904	Primary	9961	2009-01-01 00:00:00
erenna-richardi	6266	bedot, 1904	Synonym	9962	2009-01-01 00:00:00
Erenna cornuta	6267	unknown	Primary	9963	2009-01-01 00:00:00
Erenna laciniata	6268	Pugh, 2001	Primary	9964	2009-01-01 00:00:00
Resomiidae	6269	Pugh, 2006	Primary	9965	2009-01-01 00:00:00
Resomia	6270	Pugh, 2006	Primary	9966	2009-01-01 00:00:00
Stylasterina	6271	unknown	Primary	9967	2009-01-01 00:00:00
stylasterine-hydrocoral	6271	unknown	Common	9968	2009-01-01 00:00:00
Stylasteridae	6272	unknown	Primary	9969	2009-01-01 00:00:00
stylasteridae	6272	unknown	Synonym	9970	2009-01-01 00:00:00
Stylaster	6273	gray, 1831	Primary	9971	2009-01-01 00:00:00
allopora	6273	unknown	Synonym	9972	2009-01-01 00:00:00
stylaster	6273	gray, 1831	Synonym	9973	2009-01-01 00:00:00
Stylaster californicus	6274	(verrill,1866)	Primary	9974	2009-01-01 00:00:00
allopora-californica	6274	unknown	Synonym	9975	2009-01-01 00:00:00
california-hydrocoral	6274	amer. fisheries society, 1991	Common	9976	2009-01-01 00:00:00
stylaster-californicus	6274	(verrill,1866)	Synonym	9977	2009-01-01 00:00:00
Automedusa	6275	Lameere, 1920	Primary	9978	2009-01-01 00:00:00
Ctenophora	6276	unknown	Primary	9979	2009-01-01 00:00:00
comb-jelly	6276	(n.o.d.c.)	Common	9980	2009-01-01 00:00:00
Tentaculata	6277	unknown	Primary	9981	2009-01-01 00:00:00
tentaculata	6277	unknown	Synonym	9982	2009-01-01 00:00:00
Platyctenida	6278	unknown	Primary	9983	2009-01-01 00:00:00
platyctenida	6278	unknown	Synonym	9984	2009-01-01 00:00:00
Tjalfiellidae	6279	unknown	Primary	9985	2009-01-01 00:00:00
tjalfiellidae	6279	unknown	Synonym	9986	2009-01-01 00:00:00
Tjalfiella	6280	unknown	Primary	9987	2009-01-01 00:00:00
tjalfiella	6280	unknown	Synonym	9988	2009-01-01 00:00:00
Tjalfiella tristoma	6281	Mortensen, 1910	Primary	9989	2009-01-01 00:00:00
tjalfiella-tristoma	6281	Mortensen, 1910	Synonym	9990	2009-01-01 00:00:00
Lyroctenidae	6282	unknown	Primary	9991	2009-01-01 00:00:00
lyroctenidae	6282	unknown	Synonym	9992	2009-01-01 00:00:00
Lyrocteis	6283	unknown	Primary	9993	2009-01-01 00:00:00
lyrocteis	6283	unknown	Synonym	9994	2009-01-01 00:00:00
Cydippida	6284	unknown	Primary	9995	2009-01-01 00:00:00
cydippida	6284	unknown	Synonym	9996	2009-01-01 00:00:00
Mertensiidae	6285	unknown	Primary	9997	2009-01-01 00:00:00
mertensiidae	6285	unknown	Synonym	9998	2009-01-01 00:00:00
Charistephane	6286	unknown	Primary	9999	2009-01-01 00:00:00
charistephane	6286	unknown	Synonym	10000	2009-01-01 00:00:00
Charistephane fugiens	6287	unknown	Primary	10001	2009-01-01 00:00:00
millenium-falcon	6287	unknown	Common	10002	2009-01-01 00:00:00
charistephane-fugiens	6287	unknown	Synonym	10003	2009-01-01 00:00:00
Euplokamidae	6288	unknown	Primary	10004	2009-01-01 00:00:00
euplokamidae	6288	unknown	Synonym	10005	2009-01-01 00:00:00
Euplokamis	6289	unknown	Primary	10006	2009-01-01 00:00:00
euplokamis	6289	unknown	Synonym	10007	2009-01-01 00:00:00
Euplokamis dunlapae	6290	(mills 1987)	Primary	10008	2009-01-01 00:00:00
euplokamis-dunlapae	6290	(mills 1987)	Synonym	10009	2009-01-01 00:00:00
Haeckeliidae	6291	unknown	Primary	10010	2009-01-01 00:00:00
haeckeliidae	6291	unknown	Synonym	10011	2009-01-01 00:00:00
Haeckelia	6292	unknown	Primary	10012	2009-01-01 00:00:00
haeckelia	6292	unknown	Synonym	10013	2009-01-01 00:00:00
Haeckelia beehleri	6293	unknown	Primary	10014	2009-01-01 00:00:00
haeckelia-beehleri	6293	unknown	Synonym	10015	2009-01-01 00:00:00
Haeckelia rubra	6294	unknown	Primary	10016	2009-01-01 00:00:00
haeckelia-rubra	6294	unknown	Synonym	10017	2009-01-01 00:00:00
Pleurobrachiidae	6295	unknown	Primary	10018	2009-01-01 00:00:00
pleurobrachiidae	6295	unknown	Synonym	10019	2009-01-01 00:00:00
Hormiphora	6296	agassiz, 1860	Primary	10020	2009-01-01 00:00:00
hormiphora	6296	agassiz, 1860	Synonym	10021	2009-01-01 00:00:00
Hormiphora californiensis	6297	torrey, 1904	Primary	10022	2009-01-01 00:00:00
hormiphora-californiensis	6297	torrey, 1904	Synonym	10023	2009-01-01 00:00:00
Pleurobrachia	6298	fleming, 1821	Primary	10024	2009-01-01 00:00:00
pleurobrachia	6298	fleming, 1821	Synonym	10025	2009-01-01 00:00:00
Pleurobrachia pileus	6299	(muller, 1776)	Primary	10026	2009-01-01 00:00:00
sea-gooseberry	6299	amer. fisheries society, 1991	Common	10027	2009-01-01 00:00:00
pleurobrachia-pileus	6299	(muller, 1776)	Synonym	10028	2009-01-01 00:00:00
Bathyctenidae	6300	unknown	Primary	10029	2009-01-01 00:00:00
bathyctenidae	6300	unknown	Synonym	10030	2009-01-01 00:00:00
Aulacoctena	6301	unknown	Primary	10031	2009-01-01 00:00:00
aulacoctena	6301	unknown	Synonym	10032	2009-01-01 00:00:00
Bathyctena	6302	unknown	Primary	10033	2009-01-01 00:00:00
bathyctena	6302	unknown	Synonym	10034	2009-01-01 00:00:00
Bathyctena chuni	6303	(moser, 1909)	Primary	10035	2009-01-01 00:00:00
bathyctena-chuni	6303	(moser, 1909)	Synonym	10036	2009-01-01 00:00:00
Lampeidae	6304	unknown	Primary	10037	2009-01-01 00:00:00
lampeidae	6304	unknown	Synonym	10038	2009-01-01 00:00:00
Lampea	6305	unknown	Primary	10039	2009-01-01 00:00:00
lampea	6305	unknown	Synonym	10040	2009-01-01 00:00:00
Lampea pancerina	6306	unknown	Primary	10041	2009-01-01 00:00:00
lampea pancerina	6306	unknown	Synonym	10042	2009-01-01 00:00:00
Dryodoridae	6307	Harbison, 1996	Primary	10043	2009-01-01 00:00:00
Dryodora	6308	Agassiz, 1860	Primary	10044	2009-01-01 00:00:00
Dryodora glandiformis	6309	(Mertens, 1833)	Primary	10045	2009-01-01 00:00:00
Cestida	6310	unknown	Primary	10046	2009-01-01 00:00:00
cestida	6310	unknown	Synonym	10047	2009-01-01 00:00:00
Cestidae	6311	unknown	Primary	10048	2009-01-01 00:00:00
cestidae	6311	unknown	Synonym	10049	2009-01-01 00:00:00
Velamen	6312	krumbach, 1925	Primary	10050	2009-01-01 00:00:00
velamen	6312	krumbach, 1925	Synonym	10051	2009-01-01 00:00:00
Velamen parallelum	6313	fol, 1869	Primary	10052	2009-01-01 00:00:00
velamen-parallelum	6313	fol, 1869	Synonym	10053	2009-01-01 00:00:00
Cestum	6314	unknown	Primary	10054	2009-01-01 00:00:00
cestum	6314	unknown	Synonym	10055	2009-01-01 00:00:00
Cestum veneris	6315	lesueur, 1813	Primary	10056	2009-01-01 00:00:00
girdle-ctenophore	6315	unknown	Common	10057	2009-01-01 00:00:00
venus-girdle	6315	amer. fisheries society, 1991	Common	10058	2009-01-01 00:00:00
cestum-veneris	6315	lesueur, 1813	Synonym	10059	2009-01-01 00:00:00
Lobata	6316	unknown	Primary	10060	2009-01-01 00:00:00
lobate-ctenophore	6316	unknown	Common	10061	2009-01-01 00:00:00
lobata	6316	unknown	Synonym	10062	2009-01-01 00:00:00
Eurhamphaeidae	6317	unknown	Primary	10063	2009-01-01 00:00:00
eurhamphaeidae	6317	unknown	Synonym	10064	2009-01-01 00:00:00
Eurhamphaea	6318	unknown	Primary	10065	2009-01-01 00:00:00
eurhamphaea	6318	unknown	Synonym	10066	2009-01-01 00:00:00
Eurhamphaea vexilligera	6319	Gegenbaur, 1856	Primary	10067	2009-01-01 00:00:00
eurhamphaea-vexilligera	6319	Gegenbaur, 1856	Synonym	10068	2009-01-01 00:00:00
Bathocyroe	6320	madin and harbison, 1978	Primary	10069	2009-01-01 00:00:00
bathocyroe	6320	madin and harbison, 1978	Synonym	10070	2009-01-01 00:00:00
Bathocyroe fosteri	6321	madin and harbison, 1978	Primary	10071	2009-01-01 00:00:00
bathocyroe-fosteri	6321	madin and harbison, 1978	Synonym	10072	2009-01-01 00:00:00
Deiopeidae	6322	unknown	Primary	10073	2009-01-01 00:00:00
deiopeidae	6322	unknown	Synonym	10074	2009-01-01 00:00:00
Deiopea	6323	unknown	Primary	10075	2009-01-01 00:00:00
deiopea	6323	unknown	Synonym	10076	2009-01-01 00:00:00
Deiopea kaloktenota	6324	chun, 1879	Primary	10077	2009-01-01 00:00:00
deiopea-kaloktenota	6324	chun, 1879	Synonym	10078	2009-01-01 00:00:00
Ocyropsidae	6325	unknown	Primary	10079	2009-01-01 00:00:00
ocyropsidae	6325	unknown	Synonym	10080	2009-01-01 00:00:00
Ocyropsis	6326	unknown	Primary	10081	2009-01-01 00:00:00
ocyropsis	6326	unknown	Synonym	10082	2009-01-01 00:00:00
Ocyropsis crystallina	6327	Rang, 1826	Primary	10083	2009-01-01 00:00:00
ocyropsis-crystallina	6327	Rang, 1826	Synonym	10084	2009-01-01 00:00:00
Ocyropsis crystallina guttata	6328	Harbison and Miller, 1986	Primary	10085	2009-01-01 00:00:00
ocyropsis-crystallina-guttata	6328	Harbison and Miller, 1986	Synonym	10086	2009-01-01 00:00:00
Ocyropsis crystallina crystallina	6329	Rang, 1826	Primary	10087	2009-01-01 00:00:00
ocyropsis-crystallina-crystallina	6329	Rang, 1826	Synonym	10088	2009-01-01 00:00:00
Ocyropsis maculata	6330	Rang, 1826	Primary	10089	2009-01-01 00:00:00
ocyropsis-maculata	6330	Rang, 1826	Synonym	10090	2009-01-01 00:00:00
Ocyropsis maculata maculata	6331	Rang, 1826	Primary	10091	2009-01-01 00:00:00
ocyropsis-maculata-maculata	6331	Rang, 1826	Synonym	10092	2009-01-01 00:00:00
Ocyropsis maculata immaculata	6332	Harbison and Miller, 1986	Primary	10093	2009-01-01 00:00:00
ocyropsis-maculata-immaculata	6332	Harbison and Miller, 1986	Synonym	10094	2009-01-01 00:00:00
Bathocyroidae	6333	unknown	Primary	10095	2009-01-01 00:00:00
bathocyroidae	6333	unknown	Synonym	10096	2009-01-01 00:00:00
Leucotheidae	6334	unknown	Primary	10097	2009-01-01 00:00:00
leucotheidae	6334	unknown	Synonym	10098	2009-01-01 00:00:00
Leucothea	6335	mertens, 1833	Primary	10099	2009-01-01 00:00:00
leucothea	6335	mertens, 1833	Synonym	10100	2009-01-01 00:00:00
Leucothea pulchra	6336	unknown	Primary	10101	2009-01-01 00:00:00
leucothea-pulchra	6336	unknown	Synonym	10102	2009-01-01 00:00:00
Kiyohimeidae	6337	komai and tokioka, 1940	Primary	10103	2009-01-01 00:00:00
kiyohimeidae	6337	komai and tokioka, 1940	Synonym	10104	2009-01-01 00:00:00
Kiyohimea	6338	unknown	Primary	10105	2009-01-01 00:00:00
kiyohimea	6338	unknown	Synonym	10106	2009-01-01 00:00:00
Kiyohimea usagi	6339	unknown	Primary	10107	2009-01-01 00:00:00
kiyohimea-usagi	6339	unknown	Synonym	10108	2009-01-01 00:00:00
Lampoctenidae	6340	unknown	Primary	10109	2009-01-01 00:00:00
lampoctenidae	6340	unknown	Synonym	10110	2009-01-01 00:00:00
Lampocteis	6341	unknown	Primary	10111	2009-01-01 00:00:00
lampoctena	6341	unknown	Synonym	10112	2009-01-01 00:00:00
lampocteis	6341	unknown	Synonym	10113	2009-01-01 00:00:00
Lampocteis cruentiventer	6342	unknown	Primary	10114	2009-01-01 00:00:00
lampocteis-cruentiventer	6342	unknown	Synonym	10115	2009-01-01 00:00:00
Bolinopsidae	6343	unknown	Primary	10116	2009-01-01 00:00:00
bolinopsidae	6343	unknown	Synonym	10117	2009-01-01 00:00:00
Bolinopsis	6344	agassiz, 1860	Primary	10118	2009-01-01 00:00:00
bolinopsis	6344	agassiz, 1860	Synonym	10119	2009-01-01 00:00:00
Bolinopsis infundibulum	6345	(o. f. muller, 1776)	Primary	10120	2009-01-01 00:00:00
bolinopsis-infundibulum	6345	(o. f. muller, 1776)	Synonym	10121	2009-01-01 00:00:00
Thalassocalycida	6346	unknown	Primary	10122	2009-01-01 00:00:00
thalassocalycida	6346	unknown	Synonym	10123	2009-01-01 00:00:00
Thalassocalycidae	6347	unknown	Primary	10124	2009-01-01 00:00:00
thalassocalycidae	6347	unknown	Synonym	10125	2009-01-01 00:00:00
Thalassocalyce	6348	unknown	Primary	10126	2009-01-01 00:00:00
thalassocalyce	6348	unknown	Synonym	10127	2009-01-01 00:00:00
Thalassocalyce inconstans	6349	madin and harbison, 1978	Primary	10128	2009-01-01 00:00:00
thalassocalyce-inconstans	6349	madin and harbison, 1978	Synonym	10129	2009-01-01 00:00:00
Cydippida 2	6350	unknown	Primary	10130	2009-01-01 00:00:00
cydippida-red-colored	6350	unknown	Common	10131	2009-01-01 00:00:00
cydippida-2	6350	unknown	Synonym	10132	2009-01-01 00:00:00
Llyria	6351	unknown	Primary	10133	2009-01-01 00:00:00
llyria	6351	unknown	Synonym	10134	2009-01-01 00:00:00
Nuda	6352	unknown	Primary	10135	2009-01-01 00:00:00
nuda	6352	unknown	Synonym	10136	2009-01-01 00:00:00
Beroida	6353	unknown	Primary	10137	2009-01-01 00:00:00
beroida	6353	unknown	Synonym	10138	2009-01-01 00:00:00
Beroe	6354	gronovius, 1760	Primary	10139	2009-01-01 00:00:00
beroe	6354	gronovius, 1760	Synonym	10140	2009-01-01 00:00:00
Beroe forskalii	6355	milne edwards, 1841	Primary	10141	2009-01-01 00:00:00
beroe-forskalii	6355	milne edwards, 1841	Synonym	10142	2009-01-01 00:00:00
Beroe abyssicola	6356	mortensen, 1927	Primary	10143	2009-01-01 00:00:00
beroe-abyssicola	6356	mortensen, 1927	Synonym	10144	2009-01-01 00:00:00
Beroe cucumis	6357	(fabricius 1780)	Primary	10145	2009-01-01 00:00:00
beroe-cucumis	6357	(fabricius 1780)	Synonym	10146	2009-01-01 00:00:00
Beroe gracilis	6358	unknown	Primary	10147	2009-01-01 00:00:00
beroe gracilis	6358	unknown	Synonym	10148	2009-01-01 00:00:00
Intacta	6359	unknown	Primary	10149	2009-01-01 00:00:00
intacta	6359	unknown	Synonym	10150	2009-01-01 00:00:00
Platyhelminthes	6360	unknown	Primary	10151	2009-01-01 00:00:00
flatworm	6360	(n.o.d.c.)	Common	10152	2009-01-01 00:00:00
Turbellaria	6361	unknown	Primary	10153	2009-01-01 00:00:00
planarian	6361	(n.o.d.c.)	Common	10154	2009-01-01 00:00:00
turbellaria	6361	unknown	Synonym	10155	2009-01-01 00:00:00
Cestoda	6362	unknown	Primary	10156	2009-01-01 00:00:00
cestoda	6362	unknown	Synonym	10157	2009-01-01 00:00:00
Cestodaria	6363	unknown	Primary	10158	2009-01-01 00:00:00
cestodaria	6363	unknown	Synonym	10159	2009-01-01 00:00:00
Amphilinidea	6364	unknown	Primary	10160	2009-01-01 00:00:00
amphilinidea	6364	unknown	Synonym	10161	2009-01-01 00:00:00
Hemichordata	6365	unknown	Primary	10162	2009-01-01 00:00:00
hemichordate	6365	(n.o.d.c.)	Common	10163	2009-01-01 00:00:00
Pterobranchia	6366	unknown	Primary	10164	2009-01-01 00:00:00
pterobranch	6366	unknown	Common	10165	2009-01-01 00:00:00
Enteropneusta	6367	unknown	Primary	10166	2009-01-01 00:00:00
enteropneust	6367	unknown	Common	10167	2009-01-01 00:00:00
lophenteropneust	6367	unknown	Synonym	10168	2009-01-01 00:00:00
accorn-worm	6367	unknown	Common	10169	2009-01-01 00:00:00
Echiura	6368	unknown	Primary	10170	2009-01-01 00:00:00
spoon-worm	6368	unknown	Common	10171	2009-01-01 00:00:00
echiuran-worm	6368	unknown	Common	10172	2009-01-01 00:00:00
Echiuroidea	6368	unknown	Synonym	10173	2009-01-01 00:00:00
Echiurida	6368	unknown	Synonym	10174	2009-01-01 00:00:00
Echiuroinea	6369	unknown	Primary	10175	2009-01-01 00:00:00
echiuroinea	6369	unknown	Synonym	10176	2009-01-01 00:00:00
Echiuridae	6370	unknown	Primary	10177	2009-01-01 00:00:00
echiuridae	6370	unknown	Synonym	10178	2009-01-01 00:00:00
Bonelliidae	6371	unknown	Primary	10179	2009-01-01 00:00:00
bonelliidae	6371	unknown	Synonym	10180	2009-01-01 00:00:00
Xenopneusta	6372	unknown	Primary	10181	2009-01-01 00:00:00
xenopneusta	6372	unknown	Synonym	10182	2009-01-01 00:00:00
Urechidae	6373	unknown	Primary	10183	2009-01-01 00:00:00
urechidae	6373	unknown	Synonym	10184	2009-01-01 00:00:00
Urechis	6374	unknown	Primary	10185	2009-01-01 00:00:00
fat-inkeeper-worm	6374	unknown	Common	10186	2009-01-01 00:00:00
innkeeper-worm	6374	unknown	Common	10187	2009-01-01 00:00:00
urechis	6374	unknown	Synonym	10188	2009-01-01 00:00:00
Urechis caupo	6375	unknown	Primary	10189	2009-01-01 00:00:00
urechis-caupo	6375	unknown	Synonym	10190	2009-01-01 00:00:00
Heteromyota	6376	unknown	Primary	10191	2009-01-01 00:00:00
heteromyota	6376	unknown	Synonym	10192	2009-01-01 00:00:00
Ikedaidae	6377	unknown	Primary	10193	2009-01-01 00:00:00
ikedaidae	6377	unknown	Synonym	10194	2009-01-01 00:00:00
Ikeda	6378	unknown	Primary	10195	2009-01-01 00:00:00
ikeda	6378	unknown	Synonym	10196	2009-01-01 00:00:00
Annelida	6379	unknown	Primary	10197	2009-01-01 00:00:00
worm	6379	unknown	Common	10198	2009-01-01 00:00:00
annelid	6379	(n.o.d.c.)	Common	10199	2009-01-01 00:00:00
Polychaeta	6380	unknown	Primary	10200	2009-01-01 00:00:00
polychaete-worm	6380	unknown	Common	10201	2009-01-01 00:00:00
polychaete	6380	unknown	Common	10202	2009-01-01 00:00:00
paddle-footed-annelid	6380	(n.o.d.c.)	Common	10203	2009-01-01 00:00:00
Palpata	6381	unknown	Primary	10204	2009-01-01 00:00:00
Aciculata	6382	unknown	Primary	10205	2009-01-01 00:00:00
Amphinomida	6383	unknown	Primary	10206	2009-01-01 00:00:00
Amphinomidae	6384	nodc	Primary	10207	2009-01-01 00:00:00
amphinomid-worm	6384	unknown	Common	10208	2009-01-01 00:00:00
Phyllodocida	6385	unknown	Primary	10209	2009-01-01 00:00:00
Pisionidae	6386	unknown	Primary	10210	2009-01-01 00:00:00
Nautiliniellidae	6387	unknown	Primary	10211	2009-01-01 00:00:00
Sigalionidae	6388	unknown	Primary	10212	2009-01-01 00:00:00
Acoetidae	6389	unknown	Primary	10213	2009-01-01 00:00:00
Lacydoniidae	6390	unknown	Primary	10214	2009-01-01 00:00:00
Ichthyotomidae	6391	unknown	Primary	10215	2009-01-01 00:00:00
Pontodoridae	6392	unknown	Primary	10216	2009-01-01 00:00:00
Pontodora	6393	unknown	Primary	10217	2009-01-01 00:00:00
Pontodora pelagica	6394	greef 1879	Primary	10218	2009-01-01 00:00:00
Iospilidae	6395	unknown	Primary	10219	2009-01-01 00:00:00
Nereididae	6396	unknown	Primary	10220	2009-01-01 00:00:00
Nereis	6397	unknown	Primary	10221	2009-01-01 00:00:00
Nereis sandersi	6398	Blake, 1985	Primary	10222	2009-01-01 00:00:00
Lopadorhynchidae	6399	unknown	Primary	10223	2009-01-01 00:00:00
Pelagobia	6400	unknown	Primary	10224	2009-01-01 00:00:00
Pelagobia longicirrata	6401	(Greef, 1879)	Primary	10225	2009-01-01 00:00:00
Lopadorrhynchus	6402	unknown	Primary	10226	2009-01-01 00:00:00
Nephtydae	6403	unknown	Primary	10227	2009-01-01 00:00:00
Aglaophamus	6404	unknown	Primary	10228	2009-01-01 00:00:00
Aglaophamus paucilamellata	6405	Fauchald, 1972	Primary	10229	2009-01-01 00:00:00
Nephtys	6406	unknown	Primary	10230	2009-01-01 00:00:00
Nephtys cornuta	6407	Berkeley and Berkeley, 1945	Primary	10231	2009-01-01 00:00:00
Tomopteridae	6408	unknown	Primary	10232	2009-01-01 00:00:00
Tomopteris	6409	unknown	Primary	10233	2009-01-01 00:00:00
Tomopteris nisseni	6410	unknown	Primary	10234	2009-01-01 00:00:00
red-gut-tomopterid	6410	unknown	Common	10235	2009-01-01 00:00:00
Tomopteris septentrionalis	6411	steenstrup	Primary	10236	2009-01-01 00:00:00
Alciopidae	6412	unknown	Primary	10237	2009-01-01 00:00:00
alciopid-worm	6412	unknown	Common	10238	2009-01-01 00:00:00
Vanadis	6413	unknown	Primary	10239	2009-01-01 00:00:00
Torrea	6414	unknown	Primary	10240	2009-01-01 00:00:00
Rhynchonerella	6415	unknown	Primary	10241	2009-01-01 00:00:00
Alciopa	6416	unknown	Primary	10242	2009-01-01 00:00:00
Alciopa reynaudii	6417	audouin & milne	Primary	10243	2009-01-01 00:00:00
Naiades	6418	unknown	Primary	10244	2009-01-01 00:00:00
Pilargidae	6419	unknown	Primary	10245	2009-01-01 00:00:00
Phyllodocidae	6420	unknown	Primary	10246	2009-01-01 00:00:00
Sige	6421	unknown	Primary	10247	2009-01-01 00:00:00
Sige brunnea	6422	(Fauchald, 1972)	Primary	10248	2009-01-01 00:00:00
Hesionidae	6423	unknown	Primary	10249	2009-01-01 00:00:00
Pholoidae	6424	unknown	Primary	10250	2009-01-01 00:00:00
Glyceridae	6425	unknown	Primary	10251	2009-01-01 00:00:00
Glycera	6426	unknown	Primary	10252	2009-01-01 00:00:00
Glycera branchiopoda	6427	unknown	Primary	10253	2009-01-01 00:00:00
Paralacydoniidae	6428	unknown	Primary	10254	2009-01-01 00:00:00
Syllidae	6429	unknown	Primary	10255	2009-01-01 00:00:00
Eulepethidae	6430	unknown	Primary	10256	2009-01-01 00:00:00
Goniadidae	6431	unknown	Primary	10257	2009-01-01 00:00:00
Chrysopetalidae	6432	unknown	Primary	10258	2009-01-01 00:00:00
Vigtorniella	6433	unknown	Primary	10259	2009-01-01 00:00:00
Polynoidae	6434	unknown	Primary	10260	2009-01-01 00:00:00
scale-worm	6434	unknown	Common	10261	2009-01-01 00:00:00
Subadyte	6435	unknown	Primary	10262	2009-01-01 00:00:00
Subadyte mexicana	6436	Fauchald, 1972	Primary	10263	2009-01-01 00:00:00
Branchinotogluminae	6437	Pettibone, 1985	Primary	10264	2009-01-01 00:00:00
Branchinotogluma	6438	Pettibone, 1985	Primary	10265	2009-01-01 00:00:00
Branchinotogluma species	6439	unknown	Primary	10266	2009-01-01 00:00:00
Sphaerodoridae	6440	unknown	Primary	10267	2009-01-01 00:00:00
Aphroditidae	6441	unknown	Primary	10268	2009-01-01 00:00:00
Laetmonice	6442	Kinberg, 1855	Primary	10269	2009-01-01 00:00:00
Typhloscolecidae	6443	Uljanin, 1878	Primary	10270	2009-01-01 00:00:00
Travisiopsis	6444	Levinsen, 1885	Primary	10271	2009-01-01 00:00:00
Eunicida	6445	unknown	Primary	10272	2009-01-01 00:00:00
Onuphidae	6446	unknown	Primary	10273	2009-01-01 00:00:00
Onuphis	6447	unknown	Primary	10274	2009-01-01 00:00:00
Onuphis affinis	6448	Hilbig, 1995	Primary	10275	2009-01-01 00:00:00
Paradiopatra	6449	Ehlers, 1887	Primary	10276	2009-01-01 00:00:00
Eunicidae	6450	unknown	Primary	10277	2009-01-01 00:00:00
Lumbrineridae	6451	unknown	Primary	10278	2009-01-01 00:00:00
Lumbrineris	6452	unknown	Primary	10279	2009-01-01 00:00:00
Lumbrineris californiensis	6453	Hartman, 1944	Primary	10280	2009-01-01 00:00:00
Lumbrineris bicirrata	6454	unknown	Primary	10281	2009-01-01 00:00:00
Eurphrosinidae	6455	unknown	Primary	10282	2009-01-01 00:00:00
Oenonidae	6456	unknown	Primary	10283	2009-01-01 00:00:00
Hartmaniellidae	6457	unknown	Primary	10284	2009-01-01 00:00:00
Dorvilleidae	6458	unknown	Primary	10285	2009-01-01 00:00:00
Canalipalpata	6459	unknown	Primary	10286	2009-01-01 00:00:00
Sabellida	6460	unknown	Primary	10287	2009-01-01 00:00:00
Serpulidae	6461	unknown	Primary	10288	2009-01-01 00:00:00
Salmacina	6462	unknown	Primary	10289	2009-01-01 00:00:00
Sabellidae	6463	unknown	Primary	10290	2009-01-01 00:00:00
Myxicola	6464	unknown	Primary	10291	2009-01-01 00:00:00
Euchone	6465	Malmgren, 1866	Primary	10292	2009-01-01 00:00:00
Sabellariidae	6466	unknown	Primary	10293	2009-01-01 00:00:00
Oweniidae	6467	unknown	Primary	10294	2009-01-01 00:00:00
Siboglinidae	6468	Caullery, 1914	Primary	10295	2009-01-01 00:00:00
Frenulata	6468	unknown	Common	10296	2009-01-01 00:00:00
Monilifera	6468	unknown	Common	10297	2009-01-01 00:00:00
Pogonophora	6468	unknown	Synonym	10298	2009-01-01 00:00:00
Vestimentifera	6468	unknown	Synonym	10299	2009-01-01 00:00:00
Osedax	6469	Rousse, Goffredi, and Vrijenhoek 2004	Primary	10300	2009-01-01 00:00:00
Polybrachia	6470	unknown	Primary	10301	2009-01-01 00:00:00
Oasisia	6471	Jones, 1985	Primary	10302	2009-01-01 00:00:00
Oasisia alvinae	6472	Jones, 1985	Primary	10303	2009-01-01 00:00:00
Riftia	6473	Jones, 1981	Primary	10304	2009-01-01 00:00:00
Riftia pachyptila	6474	Jones, 1981	Primary	10305	2009-01-01 00:00:00
Ridgeia	6475	unknown	Primary	10306	2009-01-01 00:00:00
Ridgeia piscesae	6476	Jones, 1985	Primary	10307	2009-01-01 00:00:00
Tevnia	6477	unknown	Primary	10308	2009-01-01 00:00:00
Lamellibrachia	6478	unknown	Primary	10309	2009-01-01 00:00:00
Escarpia	6479	unknown	Primary	10310	2009-01-01 00:00:00
Escarpia spicata	6480	Jones, 1985	Primary	10311	2009-01-01 00:00:00
Spirorbinae	6481	unknown	Primary	10312	2009-01-01 00:00:00
Spirorbis	6482	daudin,1800	Primary	10313	2009-01-01 00:00:00
Spionida	6483	unknown	Primary	10314	2009-01-01 00:00:00
Poecilochaetidae	6484	unknown	Primary	10315	2009-01-01 00:00:00
Magelonidae	6485	unknown	Primary	10316	2009-01-01 00:00:00
Unispionidae	6486	unknown	Primary	10317	2009-01-01 00:00:00
Chaetopteridae	6487	unknown	Primary	10318	2009-01-01 00:00:00
Phyllochaetopterus	6488	unknown	Primary	10319	2009-01-01 00:00:00
Phyllochaetopterus limicolus	6489	Hartman, 1960	Primary	10320	2009-01-01 00:00:00
Chaetopterus	6490	Cuvier, 1827	Primary	10321	2009-01-01 00:00:00
Chaetopterus pugaporcinus	6491	Osborn et al, 2007	Primary	10322	2009-01-01 00:00:00
Apistobranchidae	6492	unknown	Primary	10323	2009-01-01 00:00:00
Longosomatidae	6493	unknown	Primary	10324	2009-01-01 00:00:00
Spionidae	6494	unknown	Primary	10325	2009-01-01 00:00:00
Prionospio	6495	unknown	Primary	10326	2009-01-01 00:00:00
Spiophanes	6496	unknown	Primary	10327	2009-01-01 00:00:00
Spiophanes pallidus	6497	unknown	Primary	10328	2009-01-01 00:00:00
Trochochaetidae	6498	unknown	Primary	10329	2009-01-01 00:00:00
Terebellida	6499	unknown	Primary	10330	2009-01-01 00:00:00
Terebellidae	6500	unknown	Primary	10331	2009-01-01 00:00:00
Terebella	6501	unknown	Primary	10332	2009-01-01 00:00:00
Terebella californica	6502	unknown	Primary	10333	2009-01-01 00:00:00
Amphitrite	6503	unknown	Primary	10334	2009-01-01 00:00:00
Alvinellidae	6504	Desbruyeres and Laubier, 1986	Primary	10335	2009-01-01 00:00:00
Alvinellinae	6505	Desbruyeres and Laubier, Oceanol. Acta, 3(3), 267-274, 1980	Primary	10336	2009-01-01 00:00:00
Alvinella	6506	Desbruyeres and Laubier, Oceanol. Acta, 3(3), 267-274, 1980	Primary	10337	2009-01-01 00:00:00
Alvinella pompejana	6507	Desbruyeres and Laubier, 1980	Primary	10338	2009-01-01 00:00:00
Alvinella caudata	6508	Desbruyeres and Laubier, 1985	Primary	10339	2009-01-01 00:00:00
Paralvinella	6509	Desbruyeres and Laubier, 1982	Primary	10340	2009-01-01 00:00:00
Paralvinella palmiformis	6510	DesbruyËres & Laubier, 1985	Primary	10341	2009-01-01 00:00:00
Paralvinella grasslei	6511	Desbruyeres and Laubier, 1982	Primary	10342	2009-01-01 00:00:00
Paralvinella bactericola	6512	Desbruyeres and Laubier, 1991	Primary	10343	2009-01-01 00:00:00
Trichobranchidae	6513	unknown	Primary	10344	2009-01-01 00:00:00
Terebellides	6514	unknown	Primary	10345	2009-01-01 00:00:00
Terebellides kobei	6515	(Williams, 1984)	Primary	10346	2009-01-01 00:00:00
Flotidae	6516	unknown	Primary	10347	2009-01-01 00:00:00
Flota	6517	unknown	Primary	10348	2009-01-01 00:00:00
Flota vitjasi	6518	Buzhinskaja, 1977	Primary	10349	2009-01-01 00:00:00
Flota flabelligerida	6519	Hartman, 1967	Primary	10350	2009-01-01 00:00:00
Flabelligeridae	6520	unknown	Primary	10351	2009-01-01 00:00:00
Brada	6521	unknown	Primary	10352	2009-01-01 00:00:00
Sternaspidae	6522	unknown	Primary	10353	2009-01-01 00:00:00
Cirratulidae	6523	unknown	Primary	10354	2009-01-01 00:00:00
Chaetozone	6524	unknown	Primary	10355	2009-01-01 00:00:00
Chaetozone harmanae	6525	Blake, 1995	Primary	10356	2009-01-01 00:00:00
Aphelochaeta	6526	unknown	Primary	10357	2009-01-01 00:00:00
Aphelochaeta monilaris	6527	Hartman, 1960	Primary	10358	2009-01-01 00:00:00
Dodecaceria	6528	unknown	Primary	10359	2009-01-01 00:00:00
Monticellina	6529	unknown	Primary	10360	2009-01-01 00:00:00
Monticellina tesselata	6530	(Hartman, 1960)	Primary	10361	2009-01-01 00:00:00
Ctenodrilidae	6531	unknown	Primary	10362	2009-01-01 00:00:00
Poeobiidae	6532	unknown	Primary	10363	2009-01-01 00:00:00
Poeobius	6533	unknown	Primary	10364	2009-01-01 00:00:00
Poeobius meseres	6534	unknown	Primary	10365	2009-01-01 00:00:00
butt-worm	6534	unknown	Common	10366	2009-01-01 00:00:00
poeobius-meseres	6534	unknown	Synonym	10367	2009-01-01 00:00:00
Poeobius 2	6535	unknown	Primary	10368	2009-01-01 00:00:00
Poeobius-with-mucous-string	6535	unknown	Common	10369	2009-01-01 00:00:00
Fauveliopsidae	6536	unknown	Primary	10370	2009-01-01 00:00:00
Ampharetidae	6537	unknown	Primary	10371	2009-01-01 00:00:00
Anobothrus bimaculatus	6538	unknown	Primary	10372	2009-01-01 00:00:00
Anobothrus	6539	unknown	Primary	10373	2009-01-01 00:00:00
Eclysippe	6540	(eliason 1955)	Primary	10374	2009-01-01 00:00:00
Amphisamytha	6541	Hessle, 1917	Primary	10375	2009-01-01 00:00:00
Amphisamytha galapagensis	6542	Zottoli, 1983	Primary	10376	2009-01-01 00:00:00
Acrocirridae	6543	unknown	Primary	10377	2009-01-01 00:00:00
Chauvinelia	6544	unknown	Primary	10378	2009-01-01 00:00:00
Pectinariidae	6545	unknown	Primary	10379	2009-01-01 00:00:00
Pectinaria	6546	unknown	Primary	10380	2009-01-01 00:00:00
Pectinaria californiensis	6547	unknown	Primary	10381	2009-01-01 00:00:00
Scolecida	6548	unknown	Primary	10382	2009-01-01 00:00:00
Cossuridae	6549	unknown	Primary	10383	2009-01-01 00:00:00
Cossura	6550	unknown	Primary	10384	2009-01-01 00:00:00
Paraonidae	6551	unknown	Primary	10385	2009-01-01 00:00:00
Levinsenia	6552	unknown	Primary	10386	2009-01-01 00:00:00
Levinsenia gracilis	6553	(Tauber, 1879)	Primary	10387	2009-01-01 00:00:00
Aricidea	6554	unknown	Primary	10388	2009-01-01 00:00:00
Aricidea antennata	6555	Annenkova, 1934	Primary	10389	2009-01-01 00:00:00
Arenicolidae	6556	unknown	Primary	10390	2009-01-01 00:00:00
Questidae	6557	unknown	Primary	10391	2009-01-01 00:00:00
Maldanidae	6558	unknown	Primary	10392	2009-01-01 00:00:00
Maldane	6559	unknown	Primary	10393	2009-01-01 00:00:00
Maldane cristata	6560	unknown	Primary	10394	2009-01-01 00:00:00
Nicomache	6561	Malmgren, 1865	Primary	10395	2009-01-01 00:00:00
Nicomache species	6562	unknown	Primary	10396	2009-01-01 00:00:00
Rhodine	6563	unknown	Primary	10397	2009-01-01 00:00:00
Rhodine bitorquata	6564	unknown	Primary	10398	2009-01-01 00:00:00
Opheliidae	6565	unknown	Primary	10399	2009-01-01 00:00:00
Capitellidae	6566	unknown	Primary	10400	2009-01-01 00:00:00
Scalibregmatidae	6567	unknown	Primary	10401	2009-01-01 00:00:00
Scalibregma	6568	unknown	Primary	10402	2009-01-01 00:00:00
Orbiniidae	6569	unknown	Primary	10403	2009-01-01 00:00:00
Hirudinea	6570	unknown	Primary	10404	2009-01-01 00:00:00
true-leech	6570	unknown	Common	10405	2009-01-01 00:00:00
Oligochaeta	6571	unknown	Primary	10406	2009-01-01 00:00:00
Mollusca	6572	unknown	Primary	10407	2009-01-01 00:00:00
Gastropoda	6573	Cuvier,1797	Primary	10408	2009-01-01 00:00:00
snail	6573	unknown	Common	10409	2009-01-01 00:00:00
slug	6573	unknown	Common	10410	2009-01-01 00:00:00
gastropod	6573	(n.o.d.c.)	Common	10411	2009-01-01 00:00:00
Prosobranchia	6574	unknown	Primary	10412	2009-01-01 00:00:00
streptoneura	6574	unknown	Synonym	10413	2009-01-01 00:00:00
Mesogastropoda	6575	thiele, 1925	Primary	10414	2009-01-01 00:00:00
Eulimidae	6576	unknown	Primary	10415	2009-01-01 00:00:00
eulimidae	6576	unknown	Synonym	10416	2009-01-01 00:00:00
Asterophila	6577	unknown	Primary	10417	2009-01-01 00:00:00
asterophila	6577	unknown	Synonym	10418	2009-01-01 00:00:00
Asterophila rathbunasteri	6578	waren and lewis, 1994	Primary	10419	2009-01-01 00:00:00
asterophila-rathbunasteri	6578	waren and lewis, 1994	Synonym	10420	2009-01-01 00:00:00
Provannidae	6579	unknown	Primary	10421	2009-01-01 00:00:00
provannidae	6579	unknown	Synonym	10422	2009-01-01 00:00:00
Provanna	6580	Dall, 1918	Primary	10423	2009-01-01 00:00:00
provanna	6580	Dall, 1918	Synonym	10424	2009-01-01 00:00:00
Provanna species	6581	unknown	Primary	10425	2009-01-01 00:00:00
provanna-species	6581	unknown	Synonym	10426	2009-01-01 00:00:00
Vermetidae	6582	unknown	Primary	10427	2009-01-01 00:00:00
tube-snail	6582	unknown	Common	10428	2009-01-01 00:00:00
vermetidae	6582	unknown	Synonym	10429	2009-01-01 00:00:00
Serpulorbis	6583	unknown	Primary	10430	2009-01-01 00:00:00
worm-snail	6583	unknown	Common	10431	2009-01-01 00:00:00
serpulorbis	6583	unknown	Synonym	10432	2009-01-01 00:00:00
Serpulorbis squamiger	6584	unknown	Primary	10433	2009-01-01 00:00:00
serpulorbis-squamiger	6584	unknown	Synonym	10434	2009-01-01 00:00:00
Heteropoda	6585	unknown	Primary	10435	2009-01-01 00:00:00
heteropod	6585	unknown	Common	10436	2009-01-01 00:00:00
heteropoda	6585	unknown	Synonym	10437	2009-01-01 00:00:00
Atlantacea	6586	unknown	Primary	10438	2009-01-01 00:00:00
atlantacea	6586	unknown	Synonym	10439	2009-01-01 00:00:00
Pterotracheidae	6587	unknown	Primary	10440	2009-01-01 00:00:00
pterotracheidae	6587	unknown	Synonym	10441	2009-01-01 00:00:00
Pterotrachea	6588	unknown	Primary	10442	2009-01-01 00:00:00
pterotrachea	6588	unknown	Synonym	10443	2009-01-01 00:00:00
Carinariidae	6589	blainville, 1818	Primary	10444	2009-01-01 00:00:00
carinariidae	6589	blainville, 1818	Synonym	10445	2009-01-01 00:00:00
Carinaria	6590	lamarck, 1801	Primary	10446	2009-01-01 00:00:00
carinaria	6590	lamarck, 1801	Synonym	10447	2009-01-01 00:00:00
Carinaria cristata	6591	(linnaeus, 1767)	Primary	10448	2009-01-01 00:00:00
carinaria-cristata	6591	(linnaeus, 1767)	Synonym	10449	2009-01-01 00:00:00
Carinaria japonica	6592	unknown	Primary	10450	2009-01-01 00:00:00
carinaria-japonica	6592	unknown	Synonym	10451	2009-01-01 00:00:00
Archaeogastropoda	6593	thiele,1925	Primary	10452	2009-01-01 00:00:00
Fissurellacea	6594	unknown	Primary	10453	2009-01-01 00:00:00
Fissurellidae	6595	fleming, 1822	Primary	10454	2009-01-01 00:00:00
keyhole-limpet	6595	unknown	Common	10455	2009-01-01 00:00:00
fissurellidae	6595	fleming, 1822	Synonym	10456	2009-01-01 00:00:00
Lepetodriloidea	6596	unknown	Primary	10457	2009-01-01 00:00:00
Lepetodrilidae	6597	unknown	Primary	10458	2009-01-01 00:00:00
lepetodrilidae	6597	unknown	Synonym	10459	2009-01-01 00:00:00
Lepetodrilus	6598	Mclean, 1988	Primary	10460	2009-01-01 00:00:00
lepetodrilus	6598	Mclean, 1988	Synonym	10461	2009-01-01 00:00:00
Lepetodrilus species	6599	unknown	Primary	10462	2009-01-01 00:00:00
lepetodrilus-species	6599	unknown	Synonym	10463	2009-01-01 00:00:00
Trochacea	6600	unknown	Primary	10464	2009-01-01 00:00:00
Trochidae	6601	rafinesque, 1815	Primary	10465	2009-01-01 00:00:00
trochidae	6601	rafinesque, 1815	Synonym	10466	2009-01-01 00:00:00
Bathybembix	6602	crosse, 1893	Primary	10467	2009-01-01 00:00:00
bathybembix	6602	crosse, 1893	Synonym	10468	2009-01-01 00:00:00
Bathybembix bairdii	6603	(dall, 1889)	Primary	10469	2009-01-01 00:00:00
bathybembix-bairdii	6603	(dall, 1889)	Synonym	10470	2009-01-01 00:00:00
Calliostoma	6604	swainson, 1840	Primary	10471	2009-01-01 00:00:00
calliostoma	6604	swainson, 1840	Synonym	10472	2009-01-01 00:00:00
Calliostoma platinum	6605	dall, 1890	Primary	10473	2009-01-01 00:00:00
silvery-topsnail	6605	amer. mal. soc., 1989	Common	10474	2009-01-01 00:00:00
calliostoma-platinum	6605	dall, 1890	Synonym	10475	2009-01-01 00:00:00
Lepetelloidea	6606	unknown	Primary	10476	2009-01-01 00:00:00
Pyropeltidae	6607	unknown	Primary	10477	2009-01-01 00:00:00
pyropeltidae	6607	unknown	Synonym	10478	2009-01-01 00:00:00
Pyropelta	6608	Mclean and Haszprunar, 1987	Primary	10479	2009-01-01 00:00:00
pyropelta	6608	Mclean and Haszprunar, 1987	Synonym	10480	2009-01-01 00:00:00
Pyropelta corymba	6609	McLean and Haszprunar, 1987	Primary	10481	2009-01-01 00:00:00
pyropelta-corymba	6609	McLean and Haszprunar, 1987	Synonym	10482	2009-01-01 00:00:00
Pyropelta species	6610	unknown	Primary	10483	2009-01-01 00:00:00
pyropelta-species	6610	unknown	Synonym	10484	2009-01-01 00:00:00
Docoglossa	6611	unknown	Primary	10485	2009-01-01 00:00:00
Patellacea	6612	unknown	Primary	10486	2009-01-01 00:00:00
true-limpet	6612	unknown	Common	10487	2009-01-01 00:00:00
patellacea	6612	unknown	Synonym	10488	2009-01-01 00:00:00
Cocculinidae	6613	unknown	Primary	10489	2009-01-01 00:00:00
cocculinidae	6613	unknown	Synonym	10490	2009-01-01 00:00:00
Cocculina	6614	unknown	Primary	10491	2009-01-01 00:00:00
lepeta	6614	unknown	Synonym	10492	2009-01-01 00:00:00
cocculina	6614	unknown	Synonym	10493	2009-01-01 00:00:00
Acmeidae	6615	unknown	Primary	10494	2009-01-01 00:00:00
acmeidae	6615	unknown	Synonym	10495	2009-01-01 00:00:00
Haliotidae	6616	rafinesque, 1815	Primary	10496	2009-01-01 00:00:00
Haliotis	6617	linnaeus,1758	Primary	10497	2009-01-01 00:00:00
haliotis	6617	linnaeus,1758	Synonym	10498	2009-01-01 00:00:00
Haliotis rufescens	6618	swainson, 1822	Primary	10499	2009-01-01 00:00:00
red-abalone	6618	amer. mal. soc., 1989	Common	10500	2009-01-01 00:00:00
haliotis-rufescens	6618	swainson, 1822	Synonym	10501	2009-01-01 00:00:00
Nudibranchia	6619	Cuvier,1817	Primary	10502	2009-01-01 00:00:00
nudibranch	6619	(n.o.d.c.)	Common	10503	2009-01-01 00:00:00
Dendronotoida	6620		Primary	10504	2009-01-01 00:00:00
dendronotoida	6620		Synonym	10505	2009-01-01 00:00:00
Tritoniidae	6621	menke,1828	Primary	10506	2009-01-01 00:00:00
tritoniidae	6621	menke,1828	Synonym	10507	2009-01-01 00:00:00
Tochuina	6622	oldner,1963	Primary	10508	2009-01-01 00:00:00
tochuina	6622	oldner,1963	Synonym	10509	2009-01-01 00:00:00
Tochuina tetraquetra	6623	(pullas,1788)	Primary	10510	2009-01-01 00:00:00
giant-orange-tochui	6623	amer. mal. soc., 1989	Common	10511	2009-01-01 00:00:00
tochuina-tetraquetra	6623	(pullas,1788)	Synonym	10512	2009-01-01 00:00:00
Tritonia	6624	cuvier,1797	Primary	10513	2009-01-01 00:00:00
tritonia	6624	cuvier,1797	Synonym	10514	2009-01-01 00:00:00
Tritonia diomedea	6625	bergh,1894	Primary	10515	2009-01-01 00:00:00
rosy-tritonia	6625	amer. mal. soc., 1989	Common	10516	2009-01-01 00:00:00
tritonia-diomedea	6625	bergh,1894	Synonym	10517	2009-01-01 00:00:00
Tritonia festiva	6626	unknown	Primary	10518	2009-01-01 00:00:00
Phylliroidae	6627	Menke, 1830	Primary	10519	2009-01-01 00:00:00
phylliroidae	6627	Menke, 1830	Synonym	10520	2009-01-01 00:00:00
Phylliroe	6628	Peron and Lesueur, 1810	Primary	10521	2009-01-01 00:00:00
phylliroe	6628	Peron and Lesueur, 1810	Synonym	10522	2009-01-01 00:00:00
Doridoidea	6629	rafinesque,1815	Primary	10523	2009-01-01 00:00:00
Bathydoridae	6630	unknown	Primary	10524	2009-01-01 00:00:00
Bathydoris aioca	6631	unknown	Primary	10525	2009-01-01 00:00:00
Eolidoidea	6632	unknown	Primary	10526	2009-01-01 00:00:00
eolidoidea	6632	unknown	Synonym	10527	2009-01-01 00:00:00
Nudibranchia sp.1	6633	unknown	Primary	10528	2009-01-01 00:00:00
nudibranchia sp.1	6633	unknown	Synonym	10529	2009-01-01 00:00:00
Doridacea	6634	\N	Primary	10530	2009-01-01 00:00:00
Polyceratidae	6635	\N	Primary	10531	2009-01-01 00:00:00
Polyceridae	6635	Alder and Hancock, 1845	Synonym	10532	2009-01-01 00:00:00
Polycera	6636	Cuvier, 1817	Primary	10533	2009-01-01 00:00:00
Polycera tricolor	6637	Robilliard, 1971	Primary	10534	2009-01-01 00:00:00
Three-color polycera	6637	Robilliard, 1971	Common	10535	2009-01-01 00:00:00
Opisthobranchia	6638	unknown	Primary	10536	2009-01-01 00:00:00
opisthobranch	6638	(n.o.d.c.)	Common	10537	2009-01-01 00:00:00
Notaspidea	6639	unknown	Primary	10538	2009-01-01 00:00:00
notaspidea	6639	unknown	Synonym	10539	2009-01-01 00:00:00
Pleurobranchiacea	6640	unknown	Primary	10540	2009-01-01 00:00:00
pleurobranchiacea	6640	unknown	Synonym	10541	2009-01-01 00:00:00
Pleurobranchidae	6641	unknown	Primary	10542	2009-01-01 00:00:00
pleurobranchidae	6641	unknown	Synonym	10543	2009-01-01 00:00:00
Pleurobranchaea	6642	leue,1813	Primary	10544	2009-01-01 00:00:00
pleurobranchaea	6642	leue,1813	Synonym	10545	2009-01-01 00:00:00
Pleurobranchaea californica	6643	macfarland,1966	Primary	10546	2009-01-01 00:00:00
pleurobranchaea-californica	6643	macfarland,1966	Synonym	10547	2009-01-01 00:00:00
Pteropoda	6644	unknown	Primary	10548	2009-01-01 00:00:00
pteropoda	6644	unknown	Synonym	10549	2009-01-01 00:00:00
Gymnosomata	6645	blainville,1824	Primary	10550	2009-01-01 00:00:00
naked-pteropod	6645	unknown	Common	10551	2009-01-01 00:00:00
gymnosomata	6645	blainville,1824	Synonym	10552	2009-01-01 00:00:00
Clionidae	6646	rafinesque,1815	Primary	10553	2009-01-01 00:00:00
clionidae	6646	rafinesque,1815	Synonym	10554	2009-01-01 00:00:00
Clione	6647	pallas,1774	Primary	10555	2009-01-01 00:00:00
clione	6647	pallas,1774	Synonym	10556	2009-01-01 00:00:00
Clione limacina	6648	(phipps,1774)	Primary	10557	2009-01-01 00:00:00
clione-limacina	6648	(phipps,1774)	Synonym	10558	2009-01-01 00:00:00
Thecosomata	6649	Blainville, 1824	Primary	10559	2009-01-01 00:00:00
shelled-pteropod	6649	unknown	Common	10560	2009-01-01 00:00:00
thecosomata	6649	Blainville, 1824	Synonym	10561	2009-01-01 00:00:00
Pseudothecosomata	6650	Boss, in Parker,1982	Primary	10562	2009-01-01 00:00:00
pseudothecosomata	6650	Boss, in Parker,1982	Synonym	10563	2009-01-01 00:00:00
Cymbuliidae	6651	Gray, 1840	Primary	10564	2009-01-01 00:00:00
cymbuliidae	6651	Gray, 1840	Synonym	10565	2009-01-01 00:00:00
Cymbulia	6652	Peron and Lesueur, 1810	Primary	10566	2009-01-01 00:00:00
cymbulia	6652	Peron and Lesueur, 1810	Synonym	10567	2009-01-01 00:00:00
Gleba	6653	Forskal, 1776	Primary	10568	2009-01-01 00:00:00
gleba	6653	Forskal, 1776	Synonym	10569	2009-01-01 00:00:00
Corolla	6654	Dall, 1871	Primary	10570	2009-01-01 00:00:00
corolla	6654	Dall, 1871	Synonym	10571	2009-01-01 00:00:00
Patellogastropoda	6655	unknown	Primary	10572	2009-01-01 00:00:00
Lepetopsina	6656	Mclean, 1990	Primary	10573	2009-01-01 00:00:00
Lepetopsacea	6657	Mclean, 1990	Primary	10574	2009-01-01 00:00:00
Neolepetopsidae	6658	Mclean, 1990	Primary	10575	2009-01-01 00:00:00
Neolepetopsis	6659	Mclean, 1990	Primary	10576	2009-01-01 00:00:00
Neolepetopsis species	6660	unknown	Primary	10577	2009-01-01 00:00:00
Paralepetopsis	6661	Mclean, 1990	Primary	10578	2009-01-01 00:00:00
Paralepetopsis species	6662	unknown	Primary	10579	2009-01-01 00:00:00
Eulepetopsis	6663	Mclean, 1990	Primary	10580	2009-01-01 00:00:00
Eulepetopsis species	6664	unknown	Primary	10581	2009-01-01 00:00:00
Nacellina	6665	Lindberg, 1998	Primary	10582	2009-01-01 00:00:00
Neogastropoda	6666	unknown	Primary	10583	2009-01-01 00:00:00
stenoglossa	6666	unknown	Synonym	10584	2009-01-01 00:00:00
Rachiglossa	6667	unknown	Primary	10585	2009-01-01 00:00:00
Muricacea	6668	unknown	Primary	10586	2009-01-01 00:00:00
Neptunidae	6669	unknown	Primary	10587	2009-01-01 00:00:00
neptunidae	6669	unknown	Synonym	10588	2009-01-01 00:00:00
Buccinacea	6670	unknown	Primary	10589	2009-01-01 00:00:00
Buccinidae	6671	Rafinesque, 1813	Primary	10590	2009-01-01 00:00:00
Colus	6672	roding,1798	Primary	10591	2009-01-01 00:00:00
colus	6672	roding,1798	Synonym	10592	2009-01-01 00:00:00
Neptunea	6673	roding,1798	Primary	10593	2009-01-01 00:00:00
neptunea	6673	roding,1798	Synonym	10594	2009-01-01 00:00:00
Neptunea amianta	6674	dall, 1890	Primary	10595	2009-01-01 00:00:00
neptunea-amianta	6674	dall, 1890	Synonym	10596	2009-01-01 00:00:00
Mohnia vernalis	6675	Dall, 1913	Primary	10597	2009-01-01 00:00:00
Buccinidae sp. 1	6676	\N	Primary	10598	2009-01-01 00:00:00
Neptunea/Buccinum Complex	6677	\N	Primary	10599	2009-01-01 00:00:00
Columbellacea	6678	unknown	Primary	10600	2009-01-01 00:00:00
Columbellidae	6679	unknown	Primary	10601	2009-01-01 00:00:00
columbellidae	6679	unknown	Synonym	10602	2009-01-01 00:00:00
Amphissa	6680	unknown	Primary	10603	2009-01-01 00:00:00
amphissa	6680	unknown	Synonym	10604	2009-01-01 00:00:00
Amphissa bicolor	6681	unknown	Primary	10605	2009-01-01 00:00:00
amphissa-bicolor	6681	unknown	Synonym	10606	2009-01-01 00:00:00
Mitrella	6682	risso,1826	Primary	10607	2009-01-01 00:00:00
mitrella	6682	risso,1826	Synonym	10608	2009-01-01 00:00:00
Astyris	6683	H. Adams and A. Adams, 1853	Primary	10609	2009-01-01 00:00:00
astyris	6683	H. Adams and A. Adams, 1853	Synonym	10610	2009-01-01 00:00:00
Astyris permodesta	6684	unknown	Primary	10611	2009-01-01 00:00:00
mitrella-permodesta	6684	unknown	Synonym	10612	2009-01-01 00:00:00
astyris-permodesta	6684	unknown	Synonym	10613	2009-01-01 00:00:00
Gastropoda sp.2	6685	unknown	Primary	10614	2009-01-01 00:00:00
Gastropoda sp.3	6686	unknown	Primary	10615	2009-01-01 00:00:00
Polyplacophora	6687	unknown	Primary	10616	2009-01-01 00:00:00
Amphineura	6687	unknown	Synonym	10617	2009-01-01 00:00:00
Loricata	6687	schumacher, 1817	Synonym	10618	2009-01-01 00:00:00
Neoloricata	6688	n.o.d.c.	Primary	10619	2009-01-01 00:00:00
chiton	6688	unknown	Common	10620	2009-01-01 00:00:00
neoloricata	6688	n.o.d.c.	Synonym	10621	2009-01-01 00:00:00
Scaphopoda	6689	bronn,1862	Primary	10622	2009-01-01 00:00:00
tusk-shell	6689	(n.o.d.c.)	Common	10623	2009-01-01 00:00:00
Bivalvia	6690	linnaeus,1758	Primary	10624	2009-01-01 00:00:00
pelecypoda	6690	goldfuss,1920	Synonym	10625	2009-01-01 00:00:00
clam	6690	unknown	Common	10626	2009-01-01 00:00:00
bivalve	6690	(n.o.d.c.)	Common	10627	2009-01-01 00:00:00
Nuculoidea	6691	dall,1889	Primary	10628	2009-01-01 00:00:00
Praenuculidae	6692	mcalester,1969	Primary	10629	2009-01-01 00:00:00
Nuculanidae	6693	meek,1864	Primary	10630	2009-01-01 00:00:00
Nuculana	6694	link,1807	Primary	10631	2009-01-01 00:00:00
Nuculana grasslei	6695	Allen, 1993	Primary	10632	2009-01-01 00:00:00
Heterodonta	6696	unknown	Primary	10633	2009-01-01 00:00:00
Veneroida	6697	unknown	Primary	10634	2009-01-01 00:00:00
Lucinoidea	6698	Fleming, 1828	Primary	10635	2009-01-01 00:00:00
Thyasiridae	6699	Dall, 1901	Primary	10636	2009-01-01 00:00:00
Conchocele	6700	Gabb, 1866	Primary	10637	2009-01-01 00:00:00
Conchocele disjuncta	6701	Gabb, 1866	Primary	10638	2009-01-01 00:00:00
Conchocele species	6702	unknown	Primary	10639	2009-01-01 00:00:00
Conchocele bisecta	6703	Conrad, 1849	Primary	10640	2009-01-01 00:00:00
giant-cleftclam	6703	unknown	Common	10641	2009-01-01 00:00:00
Glossacea	6704	unknown	Primary	10642	2009-01-01 00:00:00
Vesicomyidae	6705	dall and simpson,1901	Primary	10643	2009-01-01 00:00:00
cold-seep-clam	6705	unknown	Common	10644	2009-01-01 00:00:00
vesicomyid-clam	6705	unknown	Common	10645	2009-01-01 00:00:00
Vesicomya	6706	dall,1886	Primary	10646	2009-01-01 00:00:00
Calyptogena	6707	dall,1891	Primary	10647	2009-01-01 00:00:00
Calyptogena pacifica	6708	Dall,1891	Primary	10648	2009-01-01 00:00:00
Calyptogena packardana	6709	Barry, Kochevar, Baxter & Harrold, 1997	Primary	10649	2009-01-01 00:00:00
Calyptogena magnifica	6710	Boss and Turner, 1980	Primary	10650	2009-01-01 00:00:00
Calyptogena kilmeri	6711	Bernard, 1974	Primary	10651	2009-01-01 00:00:00
Calyptogena elongata	6712	W.H. Dall, 1916	Primary	10652	2009-01-01 00:00:00
Calyptogena ovalis	6713	W.H. Dall, 1896	Primary	10653	2009-01-01 00:00:00
Vesicomya ovalis	6713	W.H. Dall, 1896	Synonym	10654	2009-01-01 00:00:00
Calyptogena stearnsii	6714	unknownW.H. Dall, 1895	Primary	10655	2009-01-01 00:00:00
Vesicomya stearnsii	6714	unknownW.H. Dall, 1895	Synonym	10656	2009-01-01 00:00:00
Calyptogena gigas	6715	W.H. Dall, 1896	Primary	10657	2009-01-01 00:00:00
Vesicomya gigas	6715	W.H. Dall, 1896	Synonym	10658	2009-01-01 00:00:00
Ectenagena	6716	unknown	Primary	10659	2009-01-01 00:00:00
Ectenagena extenta 	6717	Krylova & Moskalev, 1996	Primary	10660	2009-01-01 00:00:00
Protobranchia	6718	unknown	Primary	10661	2009-01-01 00:00:00
Nuculoida	6719	unknown	Primary	10662	2009-01-01 00:00:00
Nuculanacea	6720	unknown	Primary	10663	2009-01-01 00:00:00
Yoldiidae	6721	unknown	Primary	10664	2009-01-01 00:00:00
Yoldia	6722	moller,1842	Primary	10665	2009-01-01 00:00:00
Yoldia montereyensis	6723	unknown	Primary	10666	2009-01-01 00:00:00
Yoldia beringiana	6724	unknown	Primary	10667	2009-01-01 00:00:00
Solemyoida	6725	dall,1889	Primary	10668	2009-01-01 00:00:00
Solemyacea	6726	unknown	Primary	10669	2009-01-01 00:00:00
Solemyidae	6727	H. and A. Adams,1857	Primary	10670	2009-01-01 00:00:00
Solemya	6728	lamarck,1818	Primary	10671	2009-01-01 00:00:00
Lamellibranchia	6729	unknown	Primary	10672	2009-01-01 00:00:00
Pteriomorphia	6730	beurlen,1944	Primary	10673	2009-01-01 00:00:00
filibranchia	6730	unknown	Synonym	10674	2009-01-01 00:00:00
Ostreoida	6731	unknown	Primary	10675	2009-01-01 00:00:00
Ostreidae	6732	unknown	Primary	10676	2009-01-01 00:00:00
true-oyster	6732	unknown	Common	10677	2009-01-01 00:00:00
oyster	6732	unknown	Common	10678	2009-01-01 00:00:00
Pectinacea	6733	unknown	Primary	10679	2009-01-01 00:00:00
Pectinidae	6734	rafinesque,1815	Primary	10680	2009-01-01 00:00:00
scallop	6734		Common	10681	2009-01-01 00:00:00
Hinnites	6735	defrance,1821	Primary	10682	2009-01-01 00:00:00
Chlamys	6736	roding,1798	Primary	10683	2009-01-01 00:00:00
Mytiloida	6737	unknown	Primary	10684	2009-01-01 00:00:00
Limoida	6738	unknown	Primary	10685	2009-01-01 00:00:00
Limacea	6739	unknown	Primary	10686	2009-01-01 00:00:00
Limidae	6740	rafinesque,1815	Primary	10687	2009-01-01 00:00:00
Lima	6741	bruguierre,1797	Primary	10688	2009-01-01 00:00:00
Acesta	6742	H. and A. Adams, 1858	Primary	10689	2009-01-01 00:00:00
Acesta mori	6743	unknown	Primary	10690	2009-01-01 00:00:00
Acesta sphoni	6744	(L. G. Hertlein, 1963)	Primary	10691	2009-01-01 00:00:00
Arcoida	6745	stoliczka,1871	Primary	10692	2009-01-01 00:00:00
Aplacophora	6746	unknown	Primary	10693	2009-01-01 00:00:00
Cephalopoda	6747	cuvier,1797	Primary	10694	2009-01-01 00:00:00
Nautiloidea	6748	unknown	Primary	10695	2009-01-01 00:00:00
nautiloidea	6748	unknown	Synonym	10696	2009-01-01 00:00:00
Coleoidea	6749	unknown	Primary	10697	2009-01-01 00:00:00
coleoidea	6749	unknown	Synonym	10698	2009-01-01 00:00:00
Octopodiformes	6750	unknown	Primary	10699	2009-01-01 00:00:00
octobrachia	6750	unknown	Synonym	10700	2009-01-01 00:00:00
Octopoda	6751	unknown	Primary	10701	2009-01-01 00:00:00
Incirrata	6752	unknown	Primary	10702	2009-01-01 00:00:00
incirrina	6752	unknown	Synonym	10703	2009-01-01 00:00:00
Octopodidae	6753	unknown	Primary	10704	2009-01-01 00:00:00
octopus-family	6753	unknown	Common	10705	2009-01-01 00:00:00
Graneledoninae	6754	voss, 1988	Primary	10706	2009-01-01 00:00:00
Graneledone	6755	joubin, 1918	Primary	10707	2009-01-01 00:00:00
Graneledone boreopacifica	6756	nesis, 1982	Primary	10708	2009-01-01 00:00:00
Graneledone pacifica	6756	Voss and Pearcy, 1990	Synonym	10709	2009-01-01 00:00:00
Thaumeledone	6757	robson, 1930	Primary	10710	2009-01-01 00:00:00
thaumeledone	6757	robson, 1930	Synonym	10711	2009-01-01 00:00:00
Eledoninae	6758	grimpe, 1921	Primary	10712	2009-01-01 00:00:00
Octopodinae	6759	grimpe, 1921	Primary	10713	2009-01-01 00:00:00
Octopus	6760	unknown	Primary	10714	2009-01-01 00:00:00
Octopus rubescens	6761	unknown	Primary	10715	2009-01-01 00:00:00
red-octopus	6761	amer. mal. soc., 1989	Common	10716	2009-01-01 00:00:00
octopus-rubescens	6761	unknown	Synonym	10717	2009-01-01 00:00:00
Enteroctopus	6762	Rochebrune/Mabille, 1889	Primary	10718	2009-01-01 00:00:00
Enteroctopus dofleini	6763	Wülker, 1910	Primary	10719	2009-01-01 00:00:00
octopus-dofleini	6763	unknown	Synonym	10720	2009-01-01 00:00:00
north-pacific-giant-octopus	6763	unknown	Common	10721	2009-01-01 00:00:00
Bathypolypodinae	6764	robson, 1929	Primary	10722	2009-01-01 00:00:00
bathypolypodinae	6764	robson, 1929	Synonym	10723	2009-01-01 00:00:00
Benthoctopus	6765	unknown	Primary	10724	2009-01-01 00:00:00
Benthoctopus profundorum	6766	Robson, 1932	Primary	10725	2009-01-01 00:00:00
Benthoctopus leioderma	6767	(Berry, 1911)	Primary	10726	2009-01-01 00:00:00
Polypus leioderma	6767	Berry, 1911	Synonym	10727	2009-01-01 00:00:00
Octopus leioderma	6767	(Berry, 1911)	Synonym	10728	2009-01-01 00:00:00
Benthoctopus abruptus	6768	(Sasaki, 1920)	Primary	10729	2009-01-01 00:00:00
Benthoctopus robustus	6769	Voss and Pearcy, 1990	Primary	10730	2009-01-01 00:00:00
Benthoctopus sp. A	6770	\N	Primary	10731	2009-01-01 00:00:00
Vitreledonellidae	6771	unknown	Primary	10732	2009-01-01 00:00:00
Vitreledonella	6772	joubin, 1918	Primary	10733	2009-01-01 00:00:00
clear-octopus	6772	unknown	Common	10734	2009-01-01 00:00:00
vitreledonella	6772	joubin, 1918	Synonym	10735	2009-01-01 00:00:00
Vitreledonella richardi	6773	unknown	Primary	10736	2009-01-01 00:00:00
vitreledonella-richardi	6773	unknown	Synonym	10737	2009-01-01 00:00:00
Bolitaenidae	6774	unknown	Primary	10738	2009-01-01 00:00:00
Japetella	6775	unknown	Primary	10739	2009-01-01 00:00:00
japetella	6775	unknown	Synonym	10740	2009-01-01 00:00:00
Japetella diaphana	6776	unknown	Primary	10741	2009-01-01 00:00:00
japetella-diaphana	6776	unknown	Synonym	10742	2009-01-01 00:00:00
Bolitaena	6777	unknown	Primary	10743	2009-01-01 00:00:00
bolitaena	6777	unknown	Synonym	10744	2009-01-01 00:00:00
Cirrata	6778	unknown	Primary	10745	2009-01-01 00:00:00
cirrina	6778	unknown	Synonym	10746	2009-01-01 00:00:00
Cirroteuthidae	6779	unknown	Primary	10747	2009-01-01 00:00:00
cirroteuthidae	6779	unknown	Synonym	10748	2009-01-01 00:00:00
Cirroteuthis	6780	unknown	Primary	10749	2009-01-01 00:00:00
cirroteuthis	6780	unknown	Synonym	10750	2009-01-01 00:00:00
Stauroteuthidae	6781	Grimpe, 1916	Primary	10751	2009-01-01 00:00:00
stauroteuthidae	6781	Grimpe, 1916	Synonym	10752	2009-01-01 00:00:00
Stauroteuthis	6782	Verrill, 1879	Primary	10753	2009-01-01 00:00:00
stauroteuthis	6782	Verrill, 1879	Synonym	10754	2009-01-01 00:00:00
Opisthoteuthidae	6783	unknown	Primary	10755	2009-01-01 00:00:00
opisthoteuthidae	6783	unknown	Synonym	10756	2009-01-01 00:00:00
Opisthoteuthis	6784	unknown	Primary	10757	2009-01-01 00:00:00
opisthoteuthis	6784	unknown	Synonym	10758	2009-01-01 00:00:00
Opisthoteuthis californiana	6785	unknown	Primary	10759	2009-01-01 00:00:00
opisthoteuthis-californiana	6785	unknown	Synonym	10760	2009-01-01 00:00:00
Opisthoteuthis agassizi	6786	unknown	Primary	10761	2009-01-01 00:00:00
flapjack-octopus	6786	unknown	Common	10762	2009-01-01 00:00:00
opisthoteuthis-agassizi	6786	unknown	Synonym	10763	2009-01-01 00:00:00
Grimpoteuthis	6787	unknown	Primary	10764	2009-01-01 00:00:00
Vampyromorpha	6788	unknown	Primary	10765	2009-01-01 00:00:00
vampyromorphida	6788	unknown	Synonym	10766	2009-01-01 00:00:00
vampyromorpha	6788	unknown	Synonym	10767	2009-01-01 00:00:00
Vampyroteuthidae	6789	unknown	Primary	10768	2009-01-01 00:00:00
vampyroteuthidae	6789	unknown	Synonym	10769	2009-01-01 00:00:00
Vampyroteuthis	6790	unknown	Primary	10770	2009-01-01 00:00:00
vampire-squid	6790	unknown	Common	10771	2009-01-01 00:00:00
vampyroteuthis	6790	unknown	Synonym	10772	2009-01-01 00:00:00
Vampyroteuthis infernalis	6791	unknown	Primary	10773	2009-01-01 00:00:00
Decapodiformes	6792	Young et al., 1998	Primary	10774	2009-01-01 00:00:00
Sepiolida	6793	Fioroni, 1981	Primary	10775	2009-01-01 00:00:00
Sepiolidae	6794	Leach, 1817	Primary	10776	2009-01-01 00:00:00
Rossiinae	6795	Appellˆf, 1898	Primary	10777	2009-01-01 00:00:00
Rossia	6796	Owen, 1834	Primary	10778	2009-01-01 00:00:00
Rossia pacifica	6797	Berry, 1911	Primary	10779	2009-01-01 00:00:00
eastern-pacific-bobtail-squid	6797	unknown	Common	10780	2009-01-01 00:00:00
northern-pacific-bobtail-squid	6797	unknown	Common	10781	2009-01-01 00:00:00
Teuthoidea	6798	unknown	Primary	10782	2009-01-01 00:00:00
squid	6798	unknown	Common	10783	2009-01-01 00:00:00
Decapoda-2	6798	unknown	Synonym	10784	2009-01-01 00:00:00
Teuthida	6798	unknown	Synonym	10785	2009-01-01 00:00:00
Theudoidea	6798	unknown	Synonym	10786	2009-01-01 00:00:00
Myopsida	6799	Naef, 1916	Primary	10787	2009-01-01 00:00:00
Loliginidae	6800	lesueur,1821	Primary	10788	2009-01-01 00:00:00
Doryteuthis	6801	Naef, 1912	Primary	10789	2009-01-01 00:00:00
Loligo	6801	schneider,1784	Synonym	10790	2009-01-01 00:00:00
Doryteuthis opalescens	6802	\N	Primary	10791	2009-01-01 00:00:00
california-market-squid	6802	amer. mal. soc., 1989	Common	10792	2009-01-01 00:00:00
Loligo opalescens	6802	Berry,1911	Synonym	10793	2009-01-01 00:00:00
Pholidoteuthidae	6803	unknown	Primary	10794	2009-01-01 00:00:00
pholidoteuthidae	6803	unknown	Synonym	10795	2009-01-01 00:00:00
Pholidoteuthis	6804	unknown	Primary	10796	2009-01-01 00:00:00
pholidoteuthis	6804	unknown	Synonym	10797	2009-01-01 00:00:00
Pholidoteuthis boschmai	6805	unknown	Primary	10798	2009-01-01 00:00:00
pholidoteuthis-boschmai	6805	unknown	Synonym	10799	2009-01-01 00:00:00
Oegopsida	6806	orbigny,1839	Primary	10800	2009-01-01 00:00:00
Octopoteuthidae	6807	unknown	Primary	10801	2009-01-01 00:00:00
octopus-squid-family	6807	unknown	Common	10802	2009-01-01 00:00:00
Octopoteuthis	6808	ruppell,1844	Primary	10803	2009-01-01 00:00:00
octopoteuthis	6808	ruppell,1844	Synonym	10804	2009-01-01 00:00:00
Octopoteuthis deletron	6809	(young 1972)	Primary	10805	2009-01-01 00:00:00
octopoteuthis-deletron	6809	(young 1972)	Synonym	10806	2009-01-01 00:00:00
Onychoteuthidae	6810	gray,1847	Primary	10807	2009-01-01 00:00:00
Onychoteuthis	6811	lichtenstein,1818	Primary	10808	2009-01-01 00:00:00
onychoteuthis	6811	lichtenstein,1818	Synonym	10809	2009-01-01 00:00:00
Onychoteuthis borealijaponica	6812	okada, 1927	Primary	10810	2009-01-01 00:00:00
boreal-clubhook-squid	6812	amer. mal. soc., 1989	Common	10811	2009-01-01 00:00:00
onychoteuthis-borealijaponica	6812	okada, 1927	Synonym	10812	2009-01-01 00:00:00
Moroteuthis	6813	verrill,1881	Primary	10813	2009-01-01 00:00:00
moroteuthis	6813	verrill,1881	Synonym	10814	2009-01-01 00:00:00
Moroteuthis robusta	6814	(verrill,1876)	Primary	10815	2009-01-01 00:00:00
robust-clubhook-squid	6814	amer. mal. soc., 1989	Common	10816	2009-01-01 00:00:00
moroteuthis-robusta	6814	(verrill,1876)	Synonym	10817	2009-01-01 00:00:00
Histioteuthidae	6815	unknown	Primary	10818	2009-01-01 00:00:00
Histioteuthis	6816	unknown	Primary	10819	2009-01-01 00:00:00
Histioteuthis dofleini	6817	unknown	Primary	10820	2009-01-01 00:00:00
Histioteuthis heteropsis	6818	unknown	Primary	10821	2009-01-01 00:00:00
cockeyed-squid	6818	unknown	Common	10822	2009-01-01 00:00:00
histioteuthis-heteropsis	6818	unknown	Synonym	10823	2009-01-01 00:00:00
Gonatidae	6819	hoyle,1886	Primary	10824	2009-01-01 00:00:00
Berryteuthis	6820	unknown	Primary	10825	2009-01-01 00:00:00
Berryteuthis anonychus	6821	pearcy and voss, 1963	Primary	10826	2009-01-01 00:00:00
Gonatus	6822	gray,1849	Primary	10827	2009-01-01 00:00:00
Gonatus onyx	6823	young,1972	Primary	10828	2009-01-01 00:00:00
black-eyed-squid	6823	unknown	Common	10829	2009-01-01 00:00:00
clawed-armhook-squid	6823	amer. mal. soc., 1989	Common	10830	2009-01-01 00:00:00
gonatus-onyx	6823	young,1972	Synonym	10831	2009-01-01 00:00:00
Gonatus berryi	6824	Naef, 1923	Primary	10832	2009-01-01 00:00:00
Gonatus pyros	6825	Young, 1972	Primary	10833	2009-01-01 00:00:00
Gonatopsis	6826	unknown	Primary	10834	2009-01-01 00:00:00
Gonatopsis borealis	6827	unknown	Primary	10835	2009-01-01 00:00:00
gonatopsis borealis	6827	unknown	Synonym	10836	2009-01-01 00:00:00
Architeuthidae	6828	pfeffer,1900	Primary	10837	2009-01-01 00:00:00
Architeuthis	6829	steenstrup,1857	Primary	10838	2009-01-01 00:00:00
giant-squid	6829	unknown	Common	10839	2009-01-01 00:00:00
architeuthis	6829	steenstrup,1857	Synonym	10840	2009-01-01 00:00:00
Architeuthis martensi	6830	unknown	Primary	10841	2009-01-01 00:00:00
architeuthis-martensi	6830	unknown	Synonym	10842	2009-01-01 00:00:00
Cranchiidae	6831	unknown	Primary	10843	2009-01-01 00:00:00
lightbulb-squid	6831	unknown	Common	10844	2009-01-01 00:00:00
cockatoo-squid	6831	unknown	Common	10845	2009-01-01 00:00:00
Teuthowenia	6832	unknown	Primary	10846	2009-01-01 00:00:00
teuthowenia	6832	unknown	Synonym	10847	2009-01-01 00:00:00
Teuthowenia megalops	6833	chun, 1910	Primary	10848	2009-01-01 00:00:00
cranchia-megalops	6833	unknown	Synonym	10849	2009-01-01 00:00:00
teuthowenia-megalops	6833	chun, 1910	Synonym	10850	2009-01-01 00:00:00
Galiteuthis	6834	unknown	Primary	10851	2009-01-01 00:00:00
galiteuthis	6834	unknown	Synonym	10852	2009-01-01 00:00:00
Galiteuthis phyllura	6835	unknown	Primary	10853	2009-01-01 00:00:00
galiteuthis-phyllura	6835	unknown	Synonym	10854	2009-01-01 00:00:00
Taoninae	6836	unknown	Primary	10855	2009-01-01 00:00:00
taoninae	6836	unknown	Synonym	10856	2009-01-01 00:00:00
Helicocranchia	6837	(Massy, 1907)	Primary	10857	2009-01-01 00:00:00
helicocranchia	6837	(Massy, 1907)	Synonym	10858	2009-01-01 00:00:00
Belonella	6838	lane, 1957	Primary	10859	2009-01-01 00:00:00
belonella	6838	lane, 1957	Synonym	10860	2009-01-01 00:00:00
Belonella borealis	6839	unknown	Primary	10861	2009-01-01 00:00:00
belonella-borealis	6839	unknown	Synonym	10862	2009-01-01 00:00:00
Taonius	6840	unknown	Primary	10863	2009-01-01 00:00:00
taonius	6840	unknown	Synonym	10864	2009-01-01 00:00:00
Taonius pavo	6841	unknown	Primary	10865	2009-01-01 00:00:00
taonius pavo	6841	unknown	Synonym	10866	2009-01-01 00:00:00
Taonius borealis	6842	unknown	Primary	10867	2009-01-01 00:00:00
taonius borealis	6842	unknown	Synonym	10868	2009-01-01 00:00:00
Cranchia	6843	Leach, 1817	Primary	10869	2009-01-01 00:00:00
Cranchia scabra	6844	Leach, 1817	Primary	10870	2009-01-01 00:00:00
Chiroteuthidae	6845	unknown	Primary	10871	2009-01-01 00:00:00
Chiroteuthis	6846	unknown	Primary	10872	2009-01-01 00:00:00
lance-squid	6846	unknown	Common	10873	2009-01-01 00:00:00
swordfish-squid	6846	unknown	Common	10874	2009-01-01 00:00:00
Chiroteuthis calyx	6847	unknown	Primary	10875	2009-01-01 00:00:00
chiroteuthis-calyx	6847	unknown	Synonym	10876	2009-01-01 00:00:00
Planctoteuthis	6848	Pfeffer, 1912	Primary	10877	2009-01-01 00:00:00
planctoteuthis	6848	Pfeffer, 1912	Synonym	10878	2009-01-01 00:00:00
Planctoteuthis oligobessa	6849	Young, 1972	Primary	10879	2009-01-01 00:00:00
planctoteuthis oligobessa	6849	Young, 1972	Synonym	10880	2009-01-01 00:00:00
Planctoteuthis danae	6850	Joubin, 1931	Primary	10881	2009-01-01 00:00:00
planctoteuthis danae	6850	Joubin, 1931	Synonym	10882	2009-01-01 00:00:00
Grimalditeuthis	6851	unknown	Primary	10883	2009-01-01 00:00:00
Bathyteuthidae	6852	unknown	Primary	10884	2009-01-01 00:00:00
Bathyteuthis	6853	unknown	Primary	10885	2009-01-01 00:00:00
Bathyteuthis berryi	6854	Roper, 1968	Primary	10886	2009-01-01 00:00:00
Bathyteuthis abyssicola	6855	Hoyle, 1885	Primary	10887	2009-01-01 00:00:00
Benthoteuthis	6855		Synonym	10888	2009-01-01 00:00:00
Ommastrephidae	6856	unknown	Primary	10889	2009-01-01 00:00:00
Dosidicus	6857	unknown	Primary	10890	2009-01-01 00:00:00
dosidicus	6857	unknown	Synonym	10891	2009-01-01 00:00:00
Dosidicus gigas	6858	d’Orbigny, 1835	Primary	10892	2009-01-01 00:00:00
humboldt-squid	6858	unknown	Common	10893	2009-01-01 00:00:00
dosidicus-gigas	6858	unknown	Synonym	10894	2009-01-01 00:00:00
Magnapinnidae	6859	Vecchione and Young, 1998	Primary	10895	2009-01-01 00:00:00
Magnapinna	6860	Vecchione and Young, 1998	Primary	10896	2009-01-01 00:00:00
magnapinna	6860	Vecchione and Young, 1998	Synonym	10897	2009-01-01 00:00:00
Magnapinna pacifica	6861	Vecchione and Young, 1998	Primary	10898	2009-01-01 00:00:00
magnapinna pacifica	6861	Vecchione and Young, 1998	Synonym	10899	2009-01-01 00:00:00
Enoploteuthidae	6862	Pfeffer, 1900	Primary	10900	2009-01-01 00:00:00
Abraliopsis	6863	Joubin, 1896	Primary	10901	2009-01-01 00:00:00
abraliopsis	6863	Joubin, 1896	Synonym	10902	2009-01-01 00:00:00
Ancistrocheiridae	6864	Pfeffer, 1912	Primary	10903	2009-01-01 00:00:00
Ancistrocheirus	6865	Gray, 1849	Primary	10904	2009-01-01 00:00:00
Ancistrocheirus lesueurii 	6866	Orbigny, 1842	Primary	10905	2009-01-01 00:00:00
Mastigoteuthidae	6867	Verrill, 1881	Primary	10906	2009-01-01 00:00:00
Mastigoteuthis	6868	Verrill, 1881	Primary	10907	2009-01-01 00:00:00
Brachiopoda	6869	unknown	Primary	10908	2009-01-01 00:00:00
lamp-shell	6869	(n.o.d.c)	Common	10909	2009-01-01 00:00:00
Articulata	6870	unknown	Primary	10910	2009-01-01 00:00:00
Heteropora	6871	de blainville, 1830	Primary	10911	2009-01-01 00:00:00
Rhynchonellida	6872	unknown	Primary	10912	2009-01-01 00:00:00
Cancellothyrididae	6873	unknown	Primary	10913	2009-01-01 00:00:00
Terebratulina	6874	unknown	Primary	10914	2009-01-01 00:00:00
Laqueidae	6875	unknown	Primary	10915	2009-01-01 00:00:00
Laqueus	6876	unknown	Primary	10916	2009-01-01 00:00:00
Laqueus vancouveriensis	6877	unknown	Primary	10917	2009-01-01 00:00:00
Laqueus californianus	6878	unknown	Primary	10918	2009-01-01 00:00:00
Protista	6879	unknown	Primary	10919	2009-01-01 00:00:00
protist	6879	unknown	Synonym	10920	2009-01-01 00:00:00
Protozoa	6880	unknown	Primary	10921	2009-01-01 00:00:00
Sarcodina	6881	unknown	Primary	10922	2009-01-01 00:00:00
Rhizopoda	6882	unknown	Primary	10923	2009-01-01 00:00:00
rhizopodea	6882	unknown	Synonym	10924	2009-01-01 00:00:00
Lobosea	6883	unknown	Primary	10925	2009-01-01 00:00:00
amoebae	6883	unknown	Common	10926	2009-01-01 00:00:00
lobosea	6883	unknown	Synonym	10927	2009-01-01 00:00:00
Granuloreticulosea	6884	unknown	Primary	10928	2009-01-01 00:00:00
granuloreticulosea	6884	unknown	Synonym	10929	2009-01-01 00:00:00
Foraminiferida	6885	unknown	Primary	10930	2009-01-01 00:00:00
foram	6885	unknown	Common	10931	2009-01-01 00:00:00
foraminiferida	6885	unknown	Synonym	10932	2009-01-01 00:00:00
Rotaliina	6886	unknown	Primary	10933	2009-01-01 00:00:00
rotaliina	6886	unknown	Synonym	10934	2009-01-01 00:00:00
Globigerinoidea	6887	unknown	Primary	10935	2009-01-01 00:00:00
globigerinoidea	6887	unknown	Synonym	10936	2009-01-01 00:00:00
Globigerinidae	6888	unknown	Primary	10937	2009-01-01 00:00:00
globigerinidae	6888	unknown	Synonym	10938	2009-01-01 00:00:00
Hastigerininae	6889	unknown	Primary	10939	2009-01-01 00:00:00
hastigerininae	6889	unknown	Synonym	10940	2009-01-01 00:00:00
Hastigerinella	6890	unknown	Primary	10941	2009-01-01 00:00:00
hastigerina	6890	unknown	Synonym	10942	2009-01-01 00:00:00
hastigerinella	6890	unknown	Synonym	10943	2009-01-01 00:00:00
Hastigerinella digitata	6891	unknown	Primary	10944	2009-01-01 00:00:00
hastigerinopsis-digitiformans	6891	unknown	Synonym	10945	2009-01-01 00:00:00
puffball-foram	6891	unknown	Common	10946	2009-01-01 00:00:00
hastigerinella-digitata	6891	unknown	Synonym	10947	2009-01-01 00:00:00
Allogromiina	6892	unknown	Primary	10948	2009-01-01 00:00:00
allogromiina	6892	unknown	Synonym	10949	2009-01-01 00:00:00
Allogromiidae	6893	unknown	Primary	10950	2009-01-01 00:00:00
allogromiidae	6893	unknown	Synonym	10951	2009-01-01 00:00:00
Bathysiphon	6894	unknown	Primary	10952	2009-01-01 00:00:00
benthic	6894	unknown	Common	10953	2009-01-01 00:00:00
bathysiphon	6894	unknown	Synonym	10954	2009-01-01 00:00:00
Xenophyophorea	6895	unknown	Primary	10955	2009-01-01 00:00:00
xenophyophorea	6895	unknown	Synonym	10956	2009-01-01 00:00:00
Psamminida	6896	unknown	Primary	10957	2009-01-01 00:00:00
psamminida	6896	unknown	Synonym	10958	2009-01-01 00:00:00
Psamminidae	6897	unknown	Primary	10959	2009-01-01 00:00:00
psamminidae	6897	unknown	Synonym	10960	2009-01-01 00:00:00
Actinopoda	6898	unknown	Primary	10961	2009-01-01 00:00:00
Heliozoa	6899	unknown	Primary	10962	2009-01-01 00:00:00
Acantharea	6900	unknown	Primary	10963	2009-01-01 00:00:00
acantharia	6900	unknown	Common	10964	2009-01-01 00:00:00
Radiolaria	6901	unknown	Primary	10965	2009-01-01 00:00:00
Polycystina	6902	unknown	Primary	10966	2009-01-01 00:00:00
Nassellaria	6903	unknown	Primary	10967	2009-01-01 00:00:00
nassellaria	6903	unknown	Synonym	10968	2009-01-01 00:00:00
Cannobotryidae	6904	unknown	Primary	10969	2009-01-01 00:00:00
cannobotryidae	6904	unknown	Synonym	10970	2009-01-01 00:00:00
Theoperidae	6905	unknown	Primary	10971	2009-01-01 00:00:00
theoperidae	6905	unknown	Synonym	10972	2009-01-01 00:00:00
Spyridae	6906	unknown	Primary	10973	2009-01-01 00:00:00
spyridae	6906	unknown	Synonym	10974	2009-01-01 00:00:00
Artostrobiidae	6907	unknown	Primary	10975	2009-01-01 00:00:00
artostrobiidae	6907	unknown	Synonym	10976	2009-01-01 00:00:00
Pterocorythidae	6908	unknown	Primary	10977	2009-01-01 00:00:00
pterocorythidae	6908	unknown	Synonym	10978	2009-01-01 00:00:00
Plagoniidae	6909	unknown	Primary	10979	2009-01-01 00:00:00
plagoniidae	6909	unknown	Synonym	10980	2009-01-01 00:00:00
Collodaria	6910	unknown	Primary	10981	2009-01-01 00:00:00
collodaria	6910	unknown	Synonym	10982	2009-01-01 00:00:00
Collozoida	6911	unknown	Primary	10983	2009-01-01 00:00:00
collozoida	6911	unknown	Synonym	10984	2009-01-01 00:00:00
Collozoum	6912	unknown	Primary	10985	2009-01-01 00:00:00
collozoum	6912	unknown	Synonym	10986	2009-01-01 00:00:00
Thalassosphaerida	6913	unknown	Primary	10987	2009-01-01 00:00:00
thalassosphaerida	6913	unknown	Synonym	10988	2009-01-01 00:00:00
Thalassosphaera	6914	unknown	Primary	10989	2009-01-01 00:00:00
thalassosphaera	6914	unknown	Synonym	10990	2009-01-01 00:00:00
Thalassicollida	6915	unknown	Primary	10991	2009-01-01 00:00:00
thalassicollida	6915	unknown	Synonym	10992	2009-01-01 00:00:00
Thalassicolla	6916	unknown	Primary	10993	2009-01-01 00:00:00
thalassicolla	6916	unknown	Synonym	10994	2009-01-01 00:00:00
Sphaerozoidae	6917	unknown	Primary	10995	2009-01-01 00:00:00
sphaerozoidae	6917	unknown	Synonym	10996	2009-01-01 00:00:00
Sphaerozoum	6918	unknown	Primary	10997	2009-01-01 00:00:00
sphaerozoum	6918	unknown	Synonym	10998	2009-01-01 00:00:00
Raphidozoum	6919	unknown	Primary	10999	2009-01-01 00:00:00
raphidozoum	6919	unknown	Synonym	11000	2009-01-01 00:00:00
Spumellaria	6920	unknown	Primary	11001	2009-01-01 00:00:00
spumellaria	6920	unknown	Synonym	11002	2009-01-01 00:00:00
Sphaerellaria	6921	unknown	Primary	11003	2009-01-01 00:00:00
sphaerellaria	6921	unknown	Synonym	11004	2009-01-01 00:00:00
Collosphaerida	6922	unknown	Primary	11005	2009-01-01 00:00:00
collosphaerida	6922	unknown	Synonym	11006	2009-01-01 00:00:00
Siphonosphaera	6923	unknown	Primary	11007	2009-01-01 00:00:00
siphonosphaera	6923	unknown	Synonym	11008	2009-01-01 00:00:00
Collosphaera	6924	unknown	Primary	11009	2009-01-01 00:00:00
collosphaera	6924	unknown	Synonym	11010	2009-01-01 00:00:00
Acrosphaera	6925	unknown	Primary	11011	2009-01-01 00:00:00
acrosphaera	6925	unknown	Synonym	11012	2009-01-01 00:00:00
Solenosphaera	6926	unknown	Primary	11013	2009-01-01 00:00:00
solenosphaera	6926	unknown	Synonym	11014	2009-01-01 00:00:00
Phacodiscidae	6927	unknown	Primary	11015	2009-01-01 00:00:00
phacodiscidae	6927	unknown	Synonym	11016	2009-01-01 00:00:00
Actinommidae	6928	unknown	Primary	11017	2009-01-01 00:00:00
actinommidae	6928	unknown	Synonym	11018	2009-01-01 00:00:00
Pyloniidae	6929	unknown	Primary	11019	2009-01-01 00:00:00
pyloniidae	6929	unknown	Synonym	11020	2009-01-01 00:00:00
Spongodiscidae	6930	unknown	Primary	11021	2009-01-01 00:00:00
spongodiscidae	6930	unknown	Synonym	11022	2009-01-01 00:00:00
Coccodiscidae	6931	unknown	Primary	11023	2009-01-01 00:00:00
coccodiscidae	6931	unknown	Synonym	11024	2009-01-01 00:00:00
Phaeodaria	6932	unknown	Primary	11025	2009-01-01 00:00:00
phaeodarian	6932	unknown	Common	11026	2009-01-01 00:00:00
Phaeogromia	6933	unknown	Primary	11027	2009-01-01 00:00:00
Tuscaroridae	6934	unknown	Primary	11028	2009-01-01 00:00:00
tuscaroridae	6934	unknown	Synonym	11029	2009-01-01 00:00:00
Tuscarilla	6935	unknown	Primary	11030	2009-01-01 00:00:00
Tuscarilla nationalis	6936	unknown	Primary	11031	2009-01-01 00:00:00
Tuscarilla similis	6937	\N	Primary	11032	2009-01-01 00:00:00
Tuscarilla campanella	6938	Haecker, 1908	Primary	11033	2009-01-01 00:00:00
Tuscarora	6939	unknown	Primary	11034	2009-01-01 00:00:00
tuscarora	6939	unknown	Synonym	11035	2009-01-01 00:00:00
Tuscarantha	6940	unknown	Primary	11036	2009-01-01 00:00:00
Tuscarantha luciae	6941	unknown	Primary	11037	2009-01-01 00:00:00
tuscarantha-luciae	6941	unknown	Synonym	11038	2009-01-01 00:00:00
Tuscarantha braueri	6942	Haecker, 1908	Primary	11039	2009-01-01 00:00:00
Tuscaridium	6943	unknown	Primary	11040	2009-01-01 00:00:00
star-radiolarian	6943	Sherlock and Haddock	Common	11041	2009-01-01 00:00:00
tuscaridium	6943	unknown	Synonym	11042	2009-01-01 00:00:00
Tuscaridium cygneum	6944	unknown	Primary	11043	2009-01-01 00:00:00
Tuscaretta	6945	unknown	Primary	11044	2009-01-01 00:00:00
tuscaretta	6945	unknown	Synonym	11045	2009-01-01 00:00:00
Tuscaretta globosa	6946	unknown	Primary	11046	2009-01-01 00:00:00
tuscaretta-globosa	6946	unknown	Synonym	11047	2009-01-01 00:00:00
Circoporidae	6947	unknown	Primary	11048	2009-01-01 00:00:00
circoporidae	6947	unknown	Synonym	11049	2009-01-01 00:00:00
Medusettidae	6948	unknown	Primary	11050	2009-01-01 00:00:00
medusettidae	6948	unknown	Synonym	11051	2009-01-01 00:00:00
Nationaletta	6949	unknown	Primary	11052	2009-01-01 00:00:00
nationaletta	6949	unknown	Synonym	11053	2009-01-01 00:00:00
Medusetta	6950	unknown	Primary	11054	2009-01-01 00:00:00
medusetta	6950	unknown	Synonym	11055	2009-01-01 00:00:00
Planktonetta	6951	unknown	Primary	11056	2009-01-01 00:00:00
planktonetta	6951	unknown	Synonym	11057	2009-01-01 00:00:00
Euphysetta	6952	unknown	Primary	11058	2009-01-01 00:00:00
euphysetta	6952	unknown	Synonym	11059	2009-01-01 00:00:00
Atlanticellidae	6953	unknown	Primary	11060	2009-01-01 00:00:00
atlanticellidae	6953	unknown	Synonym	11061	2009-01-01 00:00:00
Challengeridae	6954	unknown	Primary	11062	2009-01-01 00:00:00
challengeridae	6954	unknown	Synonym	11063	2009-01-01 00:00:00
Castanellidae	6955	unknown	Primary	11064	2009-01-01 00:00:00
castanellidae	6955	unknown	Synonym	11065	2009-01-01 00:00:00
Porospathidae	6956	unknown	Primary	11066	2009-01-01 00:00:00
porospathidae	6956	unknown	Synonym	11067	2009-01-01 00:00:00
Lirellidae	6957	unknown	Primary	11068	2009-01-01 00:00:00
lirellidae	6957	unknown	Synonym	11069	2009-01-01 00:00:00
Phaeoconchia	6958	unknown	Primary	11070	2009-01-01 00:00:00
Coelodendridae	6959	unknown	Primary	11071	2009-01-01 00:00:00
coelodendridae	6959	unknown	Synonym	11072	2009-01-01 00:00:00
Coleographis	6960	unknown	Primary	11073	2009-01-01 00:00:00
coleographis	6960	unknown	Synonym	11074	2009-01-01 00:00:00
Concharidae	6961	unknown	Primary	11075	2009-01-01 00:00:00
concharidae	6961	unknown	Synonym	11076	2009-01-01 00:00:00
Phaeosphaeria	6962	unknown	Primary	11077	2009-01-01 00:00:00
Cannosphaeridae	6963	unknown	Primary	11078	2009-01-01 00:00:00
cannosphaeridae	6963	unknown	Synonym	11079	2009-01-01 00:00:00
Aulosphaeridae	6964	unknown	Primary	11080	2009-01-01 00:00:00
aulosphaeridae	6964	unknown	Synonym	11081	2009-01-01 00:00:00
Aulosphaera	6965	unknown	Primary	11082	2009-01-01 00:00:00
aulosphaera	6965	unknown	Synonym	11083	2009-01-01 00:00:00
Sagosphaeridae	6966	unknown	Primary	11084	2009-01-01 00:00:00
sagosphaeridae	6966	unknown	Synonym	11085	2009-01-01 00:00:00
Phaeocystina	6967	unknown	Primary	11086	2009-01-01 00:00:00
Astracanthidae	6968	unknown	Primary	11087	2009-01-01 00:00:00
astracanthidae	6968	unknown	Synonym	11088	2009-01-01 00:00:00
Phaeodinidae	6969	unknown	Primary	11089	2009-01-01 00:00:00
phaeodinidae	6969	unknown	Synonym	11090	2009-01-01 00:00:00
Phaeodina	6970	unknown	Primary	11091	2009-01-01 00:00:00
phaeodina	6970	unknown	Synonym	11092	2009-01-01 00:00:00
Pharyngelidae	6971	unknown	Primary	11093	2009-01-01 00:00:00
pharyngelidae	6971	unknown	Synonym	11094	2009-01-01 00:00:00
Aulacanthidae	6972	unknown	Primary	11095	2009-01-01 00:00:00
aulacanthidae	6972	unknown	Synonym	11096	2009-01-01 00:00:00
Chromista	6973	unknown	Primary	11097	2009-01-01 00:00:00
stramenopile	6973	unknown	Synonym	11098	2009-01-01 00:00:00
Chrysophyta	6974	unknown	Primary	11099	2009-01-01 00:00:00
golden-brown-algae	6974	(n.o.d.c.)	Common	11100	2009-01-01 00:00:00
Chrysophyceae	6975	unknown	Primary	11101	2009-01-01 00:00:00
chrysophyceae	6975	unknown	Synonym	11102	2009-01-01 00:00:00
Bacillariophyta	6976	unknown	Primary	11103	2009-01-01 00:00:00
Bacillariophyceae	6977	unknown	Primary	11104	2009-01-01 00:00:00
diatom	6977	unknown	Common	11105	2009-01-01 00:00:00
bacillariophyceae	6977	unknown	Synonym	11106	2009-01-01 00:00:00
Phaeophycophyta	6978	unknown	Primary	11107	2009-01-01 00:00:00
Phaeophyta	6978	unknown	Synonym	11108	2009-01-01 00:00:00
brown-algae	6978	(n.o.d.c.)	Common	11109	2009-01-01 00:00:00
Phaeophyceae	6979	unknown	Primary	11110	2009-01-01 00:00:00
phaeophyceae	6979	unknown	Synonym	11111	2009-01-01 00:00:00
Fucales	6980	unknown	Primary	11112	2009-01-01 00:00:00
fucales	6980	unknown	Synonym	11113	2009-01-01 00:00:00
Fucaceae	6981	unknown	Primary	11114	2009-01-01 00:00:00
rockweed	6981	unknown	Common	11115	2009-01-01 00:00:00
fucaceae	6981	unknown	Synonym	11116	2009-01-01 00:00:00
Hesperophycus	6982	unknown	Primary	11117	2009-01-01 00:00:00
hesperophycus	6982	unknown	Synonym	11118	2009-01-01 00:00:00
Fucus	6983	unknown	Primary	11119	2009-01-01 00:00:00
fucus	6983	unknown	Synonym	11120	2009-01-01 00:00:00
Pelvetiopsis	6984	unknown	Primary	11121	2009-01-01 00:00:00
pelvetiopsis	6984	unknown	Synonym	11122	2009-01-01 00:00:00
Cystoseiraceae	6985	unknown	Primary	11123	2009-01-01 00:00:00
cystoseiraceae	6985	unknown	Synonym	11124	2009-01-01 00:00:00
Cystoseira	6986	unknown	Primary	11125	2009-01-01 00:00:00
cystoseira	6986	unknown	Synonym	11126	2009-01-01 00:00:00
Cystoseira osmundacea	6987	turn.	Primary	11127	2009-01-01 00:00:00
cystoseira-osmundacea	6987	turn.	Synonym	11128	2009-01-01 00:00:00
Dictyotales	6988	unknown	Primary	11129	2009-01-01 00:00:00
dictyotales	6988	unknown	Synonym	11130	2009-01-01 00:00:00
Dictyotaceae	6989	unknown	Primary	11131	2009-01-01 00:00:00
dictyotaceae	6989	unknown	Synonym	11132	2009-01-01 00:00:00
Dictyota	6990	unknown	Primary	11133	2009-01-01 00:00:00
dictyota	6990	unknown	Synonym	11134	2009-01-01 00:00:00
Dictyota binghamiae	6991	unknown	Primary	11135	2009-01-01 00:00:00
dictyota-binghamiae	6991	unknown	Synonym	11136	2009-01-01 00:00:00
Desmarestiales	6992	unknown	Primary	11137	2009-01-01 00:00:00
desmarestiales	6992	unknown	Synonym	11138	2009-01-01 00:00:00
Desmarestiaceae	6993	unknown	Primary	11139	2009-01-01 00:00:00
desmarestiaceae	6993	unknown	Synonym	11140	2009-01-01 00:00:00
Desmarestia	6994	unknown	Primary	11141	2009-01-01 00:00:00
desmarestia	6994	unknown	Synonym	11142	2009-01-01 00:00:00
Desmarestia tabacoides	6995	unknown	Primary	11143	2009-01-01 00:00:00
desmarestia-tabacoides	6995	unknown	Synonym	11144	2009-01-01 00:00:00
Desmarestia ligulata	6996	unknown	Primary	11145	2009-01-01 00:00:00
desmarestia-ligulata	6996	unknown	Synonym	11146	2009-01-01 00:00:00
Desmarestia kurilensis	6997	unknown	Primary	11147	2009-01-01 00:00:00
desmarestia-kurilensis	6997	unknown	Synonym	11148	2009-01-01 00:00:00
Laminariales	6998	unknown	Primary	11149	2009-01-01 00:00:00
kelp	6998	unknown	Common	11150	2009-01-01 00:00:00
laminariales	6998	unknown	Synonym	11151	2009-01-01 00:00:00
Alariaceae	6999	unknown	Primary	11152	2009-01-01 00:00:00
alariaceae	6999	unknown	Synonym	11153	2009-01-01 00:00:00
Pterygophora	7000	unknown	Primary	11154	2009-01-01 00:00:00
pterygophora	7000	unknown	Synonym	11155	2009-01-01 00:00:00
Pterygophora californica	7001	ruprecht,1852	Primary	11156	2009-01-01 00:00:00
pterygophora-californica	7001	ruprecht,1852	Synonym	11157	2009-01-01 00:00:00
Eisenia	7002	unknown	Primary	11158	2009-01-01 00:00:00
eisenia	7002	unknown	Synonym	11159	2009-01-01 00:00:00
Eisenia arborea	7003	areschoug,1876	Primary	11160	2009-01-01 00:00:00
eisenia-arborea	7003	areschoug,1876	Synonym	11161	2009-01-01 00:00:00
Egregia	7004	unknown	Primary	11162	2009-01-01 00:00:00
egregia	7004	unknown	Synonym	11163	2009-01-01 00:00:00
Egregia menziesii	7005	(turner)areschoug	Primary	11164	2009-01-01 00:00:00
featherboa-kelp	7005	unknown	Common	11165	2009-01-01 00:00:00
egregia-menziesii	7005	(turner)areschoug	Synonym	11166	2009-01-01 00:00:00
Alaria	7006	unknown	Primary	11167	2009-01-01 00:00:00
alaria	7006	unknown	Synonym	11168	2009-01-01 00:00:00
Alaria marginata	7007	Postals and Ruprecht	Primary	11169	2009-01-01 00:00:00
alaria-marginata	7007	Postals and Ruprecht	Synonym	11170	2009-01-01 00:00:00
Laminariaceae	7008	unknown	Primary	11171	2009-01-01 00:00:00
laminariaceae	7008	unknown	Synonym	11172	2009-01-01 00:00:00
Pleurophycus	7009	unknown	Primary	11173	2009-01-01 00:00:00
pleurophycus	7009	unknown	Synonym	11174	2009-01-01 00:00:00
Pleurophycus gardneri	7010	unknown	Primary	11175	2009-01-01 00:00:00
pleurophycus-gardneri	7010	unknown	Synonym	11176	2009-01-01 00:00:00
Laminaria	7011	unknown	Primary	11177	2009-01-01 00:00:00
laminaria	7011	unknown	Synonym	11178	2009-01-01 00:00:00
Laminaria setchellii	7012	unknown	Primary	11179	2009-01-01 00:00:00
laminaria-setchellii	7012	unknown	Synonym	11180	2009-01-01 00:00:00
Lessoniaceae	7013	unknown	Primary	11181	2009-01-01 00:00:00
lessoniaceae	7013	unknown	Synonym	11182	2009-01-01 00:00:00
Nereocystis	7014	unknown	Primary	11183	2009-01-01 00:00:00
nereocystis	7014	unknown	Synonym	11184	2009-01-01 00:00:00
Nereocystis luetkeana	7015	(mertens) postals and ruprecht	Primary	11185	2009-01-01 00:00:00
nereocystis-luetkeanus	7015	unknown	Synonym	11186	2009-01-01 00:00:00
bull-kelp	7015	unknown	Common	11187	2009-01-01 00:00:00
nereocystis-luetkeana	7015	(mertens) postals and ruprecht	Synonym	11188	2009-01-01 00:00:00
Dictyoneurum	7016	unknown	Primary	11189	2009-01-01 00:00:00
dictyoneurum	7016	unknown	Synonym	11190	2009-01-01 00:00:00
Dictyoneurum californicum	7017	ruprecht	Primary	11191	2009-01-01 00:00:00
dictyoneurum-californicum	7017	ruprecht	Synonym	11192	2009-01-01 00:00:00
Postelsia	7018	unknown	Primary	11193	2009-01-01 00:00:00
postelsia	7018	unknown	Synonym	11194	2009-01-01 00:00:00
Postelsia palmaeformis	7019	ruprecht	Primary	11195	2009-01-01 00:00:00
sea-palm	7019	unknown	Common	11196	2009-01-01 00:00:00
postelsia-palmaeformis	7019	ruprecht	Synonym	11197	2009-01-01 00:00:00
Dictyoneuropsis	7020	unknown	Primary	11198	2009-01-01 00:00:00
dictyoneuropsis	7020	unknown	Synonym	11199	2009-01-01 00:00:00
Dictyoneuropsis reticulata	7021	(saunders)smith	Primary	11200	2009-01-01 00:00:00
dictyoneuropsis-reticulata	7021	(saunders)smith	Synonym	11201	2009-01-01 00:00:00
Macrocystis	7022	unknown	Primary	11202	2009-01-01 00:00:00
macrocystis	7022	unknown	Synonym	11203	2009-01-01 00:00:00
Macrocystis integrifolia	7023	bory	Primary	11204	2009-01-01 00:00:00
macrocystis-integrifolia	7023	bory	Synonym	11205	2009-01-01 00:00:00
Macrocystis pyrifera	7024	(linnaeus)agardh	Primary	11206	2009-01-01 00:00:00
giant-kelp	7024	unknown	Common	11207	2009-01-01 00:00:00
macrocystis-pyrifera	7024	(linnaeus)agardh	Synonym	11208	2009-01-01 00:00:00
Fungi	7025	\N	Primary	11209	2009-01-01 00:00:00
Archaea	7026	unknown	Primary	11210	2009-01-01 00:00:00
geological feature	7027	unknown	Primary	11211	2009-01-01 00:00:00
friable	7028	unknown	Primary	11212	2009-01-01 00:00:00
rock float	7029	unknown	Primary	11213	2009-01-01 00:00:00
angular	7030	unknown	Primary	11214	2009-01-01 00:00:00
fill	7031	unknown	Primary	11215	2009-01-01 00:00:00
imbricated	7032	unknown	Primary	11216	2009-01-01 00:00:00
sorting	7033	unknown	Primary	11217	2009-01-01 00:00:00
orientation	7034	unknown	Primary	11218	2009-01-01 00:00:00
cleavage	7035	unknown	Primary	11219	2009-01-01 00:00:00
wall	7036	unknown	Primary	11220	2009-01-01 00:00:00
dip-face	7037	unknown	Primary	11221	2009-01-01 00:00:00
planar fabric	7038	unknown	Primary	11222	2009-01-01 00:00:00
outcrop	7039	unknown	Primary	11223	2009-01-01 00:00:00
dip	7040	unknown	Primary	11224	2009-01-01 00:00:00
matrix	7041	unknown	Primary	11225	2009-01-01 00:00:00
interbedded	7042	unknown	Primary	11226	2009-01-01 00:00:00
tumuli	7043	unknown	Primary	11227	2009-01-01 00:00:00
offset	7044	unknown	Primary	11228	2009-01-01 00:00:00
lag deposit	7045	unknown	Primary	11229	2009-01-01 00:00:00
antiform	7046	unknown	Primary	11230	2009-01-01 00:00:00
uncomformity	7047	unknown	Primary	11231	2009-01-01 00:00:00
contact	7048	unknown	Primary	11232	2009-01-01 00:00:00
clast	7049	unknown	Primary	11233	2009-01-01 00:00:00
synform	7050	unknown	Primary	11234	2009-01-01 00:00:00
deformation	7051	unknown	Primary	11235	2009-01-01 00:00:00
rounded	7052	unknown	Primary	11236	2009-01-01 00:00:00
chaotic bedding	7053	unknown	Primary	11237	2009-01-01 00:00:00
depositional surface	7054	unknown	Primary	11238	2009-01-01 00:00:00
undercut	7055	unknown	Primary	11239	2009-01-01 00:00:00
slide headwall	7056	unknown	Primary	11240	2009-01-01 00:00:00
brecciated	7057	unknown	Primary	11241	2009-01-01 00:00:00
shear zone	7058	unknown	Primary	11242	2009-01-01 00:00:00
linear structure	7059	unknown	Primary	11243	2009-01-01 00:00:00
talus cone	7060	unknown	Primary	11244	2009-01-01 00:00:00
strata	7061	unknown	Primary	11245	2009-01-01 00:00:00
debrite	7062	unknown	Primary	11246	2009-01-01 00:00:00
rock unit	7063	unknown	Primary	11247	2009-01-01 00:00:00
soft sediment deformation	7064	unknown	Primary	11248	2009-01-01 00:00:00
volcanic bomb	7065	unknown	Primary	11249	2009-01-01 00:00:00
cross-section	7066	unknown	Primary	11250	2009-01-01 00:00:00
slide scarp	7067	unknown	Primary	11251	2009-01-01 00:00:00
scour surface	7068	unknown	Primary	11252	2009-01-01 00:00:00
traverse	7069	unknown	Primary	11253	2009-01-01 00:00:00
hydrothermal alteration	7070	unknown	Primary	11254	2009-01-01 00:00:00
alteration	7071	unknown	Primary	11255	2009-01-01 00:00:00
normal fault	7072	unknown	Primary	11256	2009-01-01 00:00:00
pillow toe	7073	unknown	Primary	11257	2009-01-01 00:00:00
extension cracks	7074	unknown	Primary	11258	2009-01-01 00:00:00
undercut ledge	7075	unknown	Primary	11259	2009-01-01 00:00:00
bimodal	7076	unknown	Primary	11260	2009-01-01 00:00:00
stratigraphic section	7077	unknown	Primary	11261	2009-01-01 00:00:00
cemented	7078	unknown	Primary	11262	2009-01-01 00:00:00
tension fracture	7079	unknown	Primary	11263	2009-01-01 00:00:00
bar	7080	unknown	Primary	11264	2009-01-01 00:00:00
jointing	7081	unknown	Primary	11265	2009-01-01 00:00:00
substrate composition	7082	unknown	Primary	11266	2009-01-01 00:00:00
rock	7083	unknown	Primary	11267	2009-01-01 00:00:00
consolidated	7083	unknown	Synonym	11268	2009-01-01 00:00:00
dropstone	7084	unknown	Primary	11269	2009-01-01 00:00:00
erratic-stone	7084	unknown	Synonym	11270	2009-01-01 00:00:00
metamorphic rock	7085	unknown	Primary	11271	2009-01-01 00:00:00
metamorphic-rock	7085	unknown	Synonym	11272	2009-01-01 00:00:00
Quartzite	7086	unknown	Primary	11273	2009-01-01 00:00:00
quartzite	7086	unknown	Synonym	11274	2009-01-01 00:00:00
shale	7087	unknown	Primary	11275	2009-01-01 00:00:00
Amphibolite	7088	unknown	Primary	11276	2009-01-01 00:00:00
amphibolite	7088	unknown	Synonym	11277	2009-01-01 00:00:00
Marble	7089	unknown	Primary	11278	2009-01-01 00:00:00
marble	7089	unknown	Synonym	11279	2009-01-01 00:00:00
Metavolcanic	7090	unknown	Primary	11280	2009-01-01 00:00:00
metavolcanic	7090	unknown	Synonym	11281	2009-01-01 00:00:00
Greenstone	7091	unknown	Primary	11282	2009-01-01 00:00:00
greenstone	7091	unknown	Synonym	11283	2009-01-01 00:00:00
Schist	7092	unknown	Primary	11284	2009-01-01 00:00:00
schist	7092	unknown	Synonym	11285	2009-01-01 00:00:00
Gneiss	7093	unknown	Primary	11286	2009-01-01 00:00:00
gneiss	7093	unknown	Synonym	11287	2009-01-01 00:00:00
Argillite	7094	unknown	Primary	11288	2009-01-01 00:00:00
argillite	7094	unknown	Synonym	11289	2009-01-01 00:00:00
Metagraywacke	7095	unknown	Primary	11290	2009-01-01 00:00:00
metagraywacke	7095	unknown	Synonym	11291	2009-01-01 00:00:00
slate	7096	unknown	Primary	11292	2009-01-01 00:00:00
mineral	7097	unknown	Primary	11293	2009-01-01 00:00:00
Feldspar	7098	unknown	Primary	11294	2009-01-01 00:00:00
feldspar	7098	unknown	Synonym	11295	2009-01-01 00:00:00
Plagioclase	7099	unknown	Primary	11296	2009-01-01 00:00:00
plagioclase	7099	unknown	Synonym	11297	2009-01-01 00:00:00
Sulfate mineral	7100	unknown	Primary	11298	2009-01-01 00:00:00
sulfate-mineral	7100	unknown	Synonym	11299	2009-01-01 00:00:00
sulfate mineral	7100	unknown	Synonym	11300	2009-01-01 00:00:00
Anhydrite	7101	unknown	Primary	11301	2009-01-01 00:00:00
anhydrite	7101	unknown	Synonym	11302	2009-01-01 00:00:00
Barite	7102	unknown	Primary	11303	2009-01-01 00:00:00
barite	7102	unknown	Synonym	11304	2009-01-01 00:00:00
silicate	7103	unknown	Primary	11305	2009-01-01 00:00:00
Amphibole	7104	unknown	Primary	11306	2009-01-01 00:00:00
amphibole	7104	unknown	Synonym	11307	2009-01-01 00:00:00
Olivine	7105	unknown	Primary	11308	2009-01-01 00:00:00
olivine	7105	unknown	Synonym	11309	2009-01-01 00:00:00
iron oxide	7106	unknown	Primary	11310	2009-01-01 00:00:00
iron-oxide	7106	unknown	Synonym	11311	2009-01-01 00:00:00
Silica	7107	unknown	Primary	11312	2009-01-01 00:00:00
silica	7107	unknown	Synonym	11313	2009-01-01 00:00:00
Manganese oxide	7108	unknown	Primary	11314	2009-01-01 00:00:00
manganese-oxide	7108	unknown	Synonym	11315	2009-01-01 00:00:00
manganese oxide	7108	unknown	Synonym	11316	2009-01-01 00:00:00
Sulfide mineral	7109	unknown	Primary	11317	2009-01-01 00:00:00
sulfide-mineral	7109	unknown	Synonym	11318	2009-01-01 00:00:00
sulfide mineral	7109	unknown	Synonym	11319	2009-01-01 00:00:00
sulfide	7110	unknown	Primary	11320	2009-01-01 00:00:00
sphalerite	7111	unknown	Primary	11321	2009-01-01 00:00:00
pyrite	7112	unknown	Primary	11322	2009-01-01 00:00:00
chalcopyrite	7113	unknown	Primary	11323	2009-01-01 00:00:00
marcasite	7114	unknown	Primary	11324	2009-01-01 00:00:00
pyrrhotite	7115	unknown	Primary	11325	2009-01-01 00:00:00
High Magnesium Calcite	7116	unknown	Primary	11326	2009-01-01 00:00:00
high-magnesium-calcite	7116	unknown	Synonym	11327	2009-01-01 00:00:00
high magnesium calcite	7116	unknown	Synonym	11328	2009-01-01 00:00:00
Pyroxene	7117	unknown	Primary	11329	2009-01-01 00:00:00
pyroxene	7117	unknown	Synonym	11330	2009-01-01 00:00:00
carbonate mineral	7118	unknown	Primary	11331	2009-01-01 00:00:00
carbonate-mineral	7118	unknown	Synonym	11332	2009-01-01 00:00:00
low magnesium calcite	7119	unknown	Primary	11333	2009-01-01 00:00:00
low-magnesium-calcite	7119	unknown	Synonym	11334	2009-01-01 00:00:00
Aragonite	7120	unknown	Primary	11335	2009-01-01 00:00:00
aragonite	7120	unknown	Synonym	11336	2009-01-01 00:00:00
Calcite	7121	unknown	Primary	11337	2009-01-01 00:00:00
calcite	7121	unknown	Synonym	11338	2009-01-01 00:00:00
Zeolite	7122	unknown	Primary	11339	2009-01-01 00:00:00
zeolite	7122	unknown	Synonym	11340	2009-01-01 00:00:00
Gypsum	7123	unknown	Primary	11341	2009-01-01 00:00:00
gypsum	7123	unknown	Synonym	11342	2009-01-01 00:00:00
Dolomite	7124	unknown	Primary	11343	2009-01-01 00:00:00
dolomite	7124	unknown	Synonym	11344	2009-01-01 00:00:00
Biotite	7125	unknown	Primary	11345	2009-01-01 00:00:00
biotite	7125	unknown	Synonym	11346	2009-01-01 00:00:00
Quartz	7126	unknown	Primary	11347	2009-01-01 00:00:00
quartz	7126	unknown	Synonym	11348	2009-01-01 00:00:00
Orthoclase	7127	unknown	Primary	11349	2009-01-01 00:00:00
orthoclase	7127	unknown	Synonym	11350	2009-01-01 00:00:00
Clinopyroxene	7128	unknown	Primary	11351	2009-01-01 00:00:00
clinopyroxene	7128	unknown	Synonym	11352	2009-01-01 00:00:00
Epidote	7129	unknown	Primary	11353	2009-01-01 00:00:00
epidote	7129	unknown	Synonym	11354	2009-01-01 00:00:00
Spinel	7130	unknown	Primary	11355	2009-01-01 00:00:00
spinel	7130	unknown	Synonym	11356	2009-01-01 00:00:00
Chlorite	7131	unknown	Primary	11357	2009-01-01 00:00:00
chlorite	7131	unknown	Synonym	11358	2009-01-01 00:00:00
sedimentary rock	7132	unknown	Primary	11359	2009-01-01 00:00:00
deposit	7132	unknown	Synonym	11360	2009-01-01 00:00:00
sedimentary-rock	7132	unknown	Synonym	11361	2009-01-01 00:00:00
graywacke	7133	unknown	Primary	11362	2009-01-01 00:00:00
chert	7134	unknown	Primary	11363	2009-01-01 00:00:00
diatomaceous-rock	7134	unknown	Synonym	11364	2009-01-01 00:00:00
conglomerate	7135	unknown	Primary	11365	2009-01-01 00:00:00
phosphorite	7136	unknown	Primary	11366	2009-01-01 00:00:00
carbonate	7137	unknown	Primary	11367	2009-01-01 00:00:00
biogenic carbonate	7138	unknown	Primary	11368	2009-01-01 00:00:00
limestone	7138	unknown	Common	11369	2009-01-01 00:00:00
biogenic-carbonate	7138	unknown	Synonym	11370	2009-01-01 00:00:00
detrital carbonate	7139	unknown	Primary	11371	2009-01-01 00:00:00
detrital-carbonate	7139	unknown	Synonym	11372	2009-01-01 00:00:00
carbonate sandstone	7140	unknown	Primary	11373	2009-01-01 00:00:00
carbonate-sandstone	7140	unknown	Synonym	11374	2009-01-01 00:00:00
reef coral	7141	unknown	Primary	11375	2009-01-01 00:00:00
reef-coral	7141	unknown	Synonym	11376	2009-01-01 00:00:00
authigenic carbonate	7142	unknown	Primary	11377	2009-01-01 00:00:00
authigenic-carbonate	7142	unknown	Synonym	11378	2009-01-01 00:00:00
Manganese crust	7143	unknown	Primary	11379	2009-01-01 00:00:00
manganese-crust	7143	unknown	Synonym	11380	2009-01-01 00:00:00
manganese crust	7143	unknown	Synonym	11381	2009-01-01 00:00:00
Monterey Formation	7144	unknown	Primary	11382	2009-01-01 00:00:00
monterey-formation	7144	unknown	Synonym	11383	2009-01-01 00:00:00
monterey formation	7144	unknown	Synonym	11384	2009-01-01 00:00:00
Purisima Formation	7145	unknown	Primary	11385	2009-01-01 00:00:00
purisima-formation	7145	unknown	Synonym	11386	2009-01-01 00:00:00
purisima formation	7145	unknown	Synonym	11387	2009-01-01 00:00:00
mineral deposit	7146	unknown	Primary	11388	2009-01-01 00:00:00
mineral-deposit	7146	unknown	Synonym	11389	2009-01-01 00:00:00
mudstone	7147	unknown	Primary	11390	2009-01-01 00:00:00
porcellanite	7148	unknown	Primary	11391	2009-01-01 00:00:00
sandstone	7149	unknown	Primary	11392	2009-01-01 00:00:00
Arkosic sandstone	7150	unknown	Primary	11393	2009-01-01 00:00:00
arkosic-sandstone	7150	unknown	Synonym	11394	2009-01-01 00:00:00
arkosic sandstone	7150	unknown	Synonym	11395	2009-01-01 00:00:00
radiolarite	7151	unknown	Primary	11396	2009-01-01 00:00:00
siltstone	7152	unknown	Primary	11397	2009-01-01 00:00:00
breccia	7153	unknown	Primary	11398	2009-01-01 00:00:00
Vaqueros Formation	7154	unknown	Primary	11399	2009-01-01 00:00:00
vaqueros-formation	7154	unknown	Synonym	11400	2009-01-01 00:00:00
vaqueros formation	7154	unknown	Synonym	11401	2009-01-01 00:00:00
claystone	7155	unknown	Primary	11402	2009-01-01 00:00:00
salt	7156	unknown	Primary	11403	2009-01-01 00:00:00
gas hydrate	7157	unknown	Primary	11404	2009-01-01 00:00:00
clathrate	7157	unknown	Synonym	11405	2009-01-01 00:00:00
gas-hydrate	7157	unknown	Synonym	11406	2009-01-01 00:00:00
Carbon dioxide hydrate	7158	unknown	Primary	11407	2009-01-01 00:00:00
carbon-dioxide-hydrate	7158	unknown	Synonym	11408	2009-01-01 00:00:00
carbonm dioxide hydrate	7158	unknown	Synonym	11409	2009-01-01 00:00:00
Methane hydrate	7159	unknown	Primary	11410	2009-01-01 00:00:00
methane-hydrate	7159	unknown	Synonym	11411	2009-01-01 00:00:00
methane hydrate	7159	unknown	Synonym	11412	2009-01-01 00:00:00
detrital	7160	unknown	Primary	11413	2009-01-01 00:00:00
fragmental	7160	unknown	Common	11414	2009-01-01 00:00:00
hydrothermal crust	7161	unknown	Primary	11415	2009-01-01 00:00:00
hydrothermal-crust	7161	unknown	Synonym	11416	2009-01-01 00:00:00
igneous rock	7162	unknown	Primary	11417	2009-01-01 00:00:00
igneous-rock	7162	unknown	Synonym	11418	2009-01-01 00:00:00
volcanic rock	7163	unknown	Primary	11419	2009-01-01 00:00:00
extrusive	7163	unknown	Synonym	11420	2009-01-01 00:00:00
volcanic-rock	7163	unknown	Synonym	11421	2009-01-01 00:00:00
Limu o Pele	7164	unknown	Primary	11422	2009-01-01 00:00:00
limu-o-pele	7164	unknown	Synonym	11423	2009-01-01 00:00:00
limu o Pele	7164	unknown	Synonym	11424	2009-01-01 00:00:00
Basaltic lava	7165	unknown	Primary	11425	2009-01-01 00:00:00
basaltic-lava	7165	unknown	Synonym	11426	2009-01-01 00:00:00
basaltic lava	7165	unknown	Synonym	11427	2009-01-01 00:00:00
Hawaiite	7166	unknown	Primary	11428	2009-01-01 00:00:00
hawaiite	7166	unknown	Synonym	11429	2009-01-01 00:00:00
Alkalic Basalt	7167	unknown	Primary	11430	2009-01-01 00:00:00
alkalic-basalt	7167	unknown	Synonym	11431	2009-01-01 00:00:00
alkalic basalt	7167	unknown	Synonym	11432	2009-01-01 00:00:00
Picrite	7168	unknown	Primary	11433	2009-01-01 00:00:00
picrite	7168	unknown	Synonym	11434	2009-01-01 00:00:00
Mugearite	7169	unknown	Primary	11435	2009-01-01 00:00:00
mugearite	7169	unknown	Synonym	11436	2009-01-01 00:00:00
Trachyte	7170	unknown	Primary	11437	2009-01-01 00:00:00
trachyte	7170	unknown	Synonym	11438	2009-01-01 00:00:00
Basalt	7171	unknown	Primary	11439	2009-01-01 00:00:00
basalt	7171	unknown	Synonym	11440	2009-01-01 00:00:00
Tholeiite	7172	unknown	Primary	11441	2009-01-01 00:00:00
tholeitic-basalt	7172	unknown	Synonym	11442	2009-01-01 00:00:00
tholeitic basalt	7172	unknown	Synonym	11443	2009-01-01 00:00:00
Tholeitic Basalt	7172	unknown	Synonym	11444	2009-01-01 00:00:00
Benmoreite	7173	\N	Primary	11445	2009-01-01 00:00:00
Andesite	7174	unknown	Primary	11446	2009-01-01 00:00:00
andesite	7174	unknown	Synonym	11447	2009-01-01 00:00:00
Pepperite	7175	unknown	Primary	11448	2009-01-01 00:00:00
pepperite	7175	unknown	Synonym	11449	2009-01-01 00:00:00
Dacite	7176	unknown	Primary	11450	2009-01-01 00:00:00
dacite	7176	unknown	Synonym	11451	2009-01-01 00:00:00
Rhyolite	7177	unknown	Primary	11452	2009-01-01 00:00:00
rhyolite	7177	unknown	Synonym	11453	2009-01-01 00:00:00
Pillow lava	7178	unknown	Primary	11454	2009-01-01 00:00:00
pillow-lava	7178	unknown	Synonym	11455	2009-01-01 00:00:00
pillow lava	7178	unknown	Synonym	11456	2009-01-01 00:00:00
Volcaniclastic	7179	unknown	Primary	11457	2009-01-01 00:00:00
volcaniclastic	7179	unknown	Synonym	11458	2009-01-01 00:00:00
ash	7180	unknown	Primary	11459	2009-01-01 00:00:00
volcanic breccia	7181	unknown	Primary	11460	2009-01-01 00:00:00
volcanic-breccia	7181	unknown	Synonym	11461	2009-01-01 00:00:00
volcanic sandstone	7182	unknown	Primary	11462	2009-01-01 00:00:00
volcanic-sandstone	7182	unknown	Synonym	11463	2009-01-01 00:00:00
Hyaloclastite	7183	unknown	Primary	11464	2009-01-01 00:00:00
hyaloclastite	7183	unknown	Synonym	11465	2009-01-01 00:00:00
Volcanic siltstone	7184	unknown	Primary	11466	2009-01-01 00:00:00
Volcanic-siltstone	7184	unknown	Synonym	11467	2009-01-01 00:00:00
Volcanic mudstone	7185	unknown	Primary	11468	2009-01-01 00:00:00
Volcanic-mudstone	7185	unknown	Synonym	11469	2009-01-01 00:00:00
pumice	7186	unknown	Primary	11470	2009-01-01 00:00:00
Volcaniclastite	7187	unknown	Primary	11471	2009-01-01 00:00:00
volcaniclastite	7187	unknown	Synonym	11472	2009-01-01 00:00:00
volcanic siltstone	7188	unknown	Primary	11473	2009-01-01 00:00:00
volcanic-siltstone	7188	unknown	Synonym	11474	2009-01-01 00:00:00
glass	7189	unknown	Primary	11475	2009-01-01 00:00:00
glass inclusion	7190	unknown	Primary	11476	2009-01-01 00:00:00
glass-inclusion	7190	unknown	Synonym	11477	2009-01-01 00:00:00
Silicic volcanic	7191	unknown	Primary	11478	2009-01-01 00:00:00
silicic-volcanic	7191	unknown	Synonym	11479	2009-01-01 00:00:00
silicic volcanic	7191	unknown	Synonym	11480	2009-01-01 00:00:00
Ophiolite	7192	unknown	Primary	11481	2009-01-01 00:00:00
ophiolite	7192	unknown	Synonym	11482	2009-01-01 00:00:00
plutonic rock	7193	unknown	Primary	11483	2009-01-01 00:00:00
intrusive	7193	unknown	Synonym	11484	2009-01-01 00:00:00
plutonic-rock	7193	unknown	Synonym	11485	2009-01-01 00:00:00
Diabase	7194	unknown	Primary	11486	2009-01-01 00:00:00
diabase	7194	unknown	Synonym	11487	2009-01-01 00:00:00
Granodiorite	7195	unknown	Primary	11488	2009-01-01 00:00:00
granodiorite	7195	unknown	Synonym	11489	2009-01-01 00:00:00
Granite	7196	unknown	Primary	11490	2009-01-01 00:00:00
granite	7196	unknown	Synonym	11491	2009-01-01 00:00:00
Gabbro	7197	unknown	Primary	11492	2009-01-01 00:00:00
gabbro	7197	unknown	Synonym	11493	2009-01-01 00:00:00
Peridotite	7198	unknown	Primary	11494	2009-01-01 00:00:00
peridotite	7198	unknown	Synonym	11495	2009-01-01 00:00:00
Diorite	7199	unknown	Primary	11496	2009-01-01 00:00:00
diorite	7199	unknown	Synonym	11497	2009-01-01 00:00:00
Pegmatite	7200	unknown	Primary	11498	2009-01-01 00:00:00
pegmatite	7200	unknown	Synonym	11499	2009-01-01 00:00:00
Xenolith	7201	unknown	Primary	11500	2009-01-01 00:00:00
xenolith	7201	unknown	Synonym	11501	2009-01-01 00:00:00
lherzolite	7202	unknown	Primary	11502	2009-01-01 00:00:00
water	7203	unknown	Primary	11503	2009-01-01 00:00:00
fresh water	7204	unknown	Primary	11504	2009-01-01 00:00:00
fresh-water	7204	unknown	Synonym	11505	2009-01-01 00:00:00
pore water	7205	unknown	Primary	11506	2009-01-01 00:00:00
pore-water	7205	unknown	Synonym	11507	2009-01-01 00:00:00
benthic boundary layer	7206	unknown	Primary	11508	2009-01-01 00:00:00
benthic-boundary-layer	7206	unknown	Synonym	11509	2009-01-01 00:00:00
surface water	7207	unknown	Primary	11510	2009-01-01 00:00:00
surface-water	7207	unknown	Synonym	11511	2009-01-01 00:00:00
vent fluid	7208	unknown	Primary	11512	2009-01-01 00:00:00
vent-fluid	7208	unknown	Synonym	11513	2009-01-01 00:00:00
oxygen minimum zone	7209	unknown	Primary	11514	2009-01-01 00:00:00
omz	7209	unknown	Common	11515	2009-01-01 00:00:00
oxygen-minimum-zone	7209	unknown	Synonym	11516	2009-01-01 00:00:00
ice	7210	unknown	Primary	11517	2009-01-01 00:00:00
sediment	7211	unknown	Primary	11518	2009-01-01 00:00:00
unconsolidated	7211	unknown	Synonym	11519	2009-01-01 00:00:00
pebble	7212	unknown	Primary	11520	2009-01-01 00:00:00
cobble	7213	unknown	Primary	11521	2009-01-01 00:00:00
shell hash	7214	unknown	Primary	11522	2009-01-01 00:00:00
shell-hash	7214	unknown	Synonym	11523	2009-01-01 00:00:00
mud	7215	unknown	Primary	11524	2009-01-01 00:00:00
sand	7216	unknown	Primary	11525	2009-01-01 00:00:00
clay	7217	unknown	Primary	11526	2009-01-01 00:00:00
hydrothermal clay	7218	unknown	Primary	11527	2009-01-01 00:00:00
hydrothermal-clay	7218	unknown	Synonym	11528	2009-01-01 00:00:00
collapse structure	7219	unknown	Primary	11529	2009-01-01 00:00:00
talus chute	7220	unknown	Primary	11530	2009-01-01 00:00:00
linear fabric	7221	unknown	Primary	11531	2009-01-01 00:00:00
vesicular	7222	unknown	Primary	11532	2009-01-01 00:00:00
eroded surface	7223	unknown	Primary	11533	2009-01-01 00:00:00
geological morphology	7224	unknown	Primary	11534	2009-01-01 00:00:00
mud ball	7225	unknown	Primary	11535	2009-01-01 00:00:00
channel	7226	unknown	Primary	11536	2009-01-01 00:00:00
burrow	7227	unknown	Primary	11537	2009-01-01 00:00:00
scarp	7228	unknown	Primary	11538	2009-01-01 00:00:00
fault scarp	7229	unknown	Primary	11539	2009-01-01 00:00:00
fault-scarp	7229	unknown	Synonym	11540	2009-01-01 00:00:00
slump scarp	7230	unknown	Primary	11541	2009-01-01 00:00:00
slump-scarp	7230	unknown	Synonym	11542	2009-01-01 00:00:00
chimney	7231	unknown	Primary	11543	2009-01-01 00:00:00
track	7232	unknown	Primary	11544	2009-01-01 00:00:00
pinnacle	7233	unknown	Primary	11545	2009-01-01 00:00:00
ripples	7234	unknown	Primary	11546	2009-01-01 00:00:00
column	7235	unknown	Primary	11547	2009-01-01 00:00:00
slope	7236	unknown	Primary	11548	2009-01-01 00:00:00
stalagmite	7237	unknown	Primary	11549	2009-01-01 00:00:00
nodule	7238	unknown	Primary	11550	2009-01-01 00:00:00
Siderite nodule	7239	unknown	Primary	11551	2009-01-01 00:00:00
siderite-nodule	7239	unknown	Synonym	11552	2009-01-01 00:00:00
siderite nodule	7239	unknown	Synonym	11553	2009-01-01 00:00:00
Manganese nodule	7240	unknown	Primary	11554	2009-01-01 00:00:00
manganese-nodule	7240	unknown	Synonym	11555	2009-01-01 00:00:00
manganese nodule	7240	unknown	Synonym	11556	2009-01-01 00:00:00
gas vent	7241	unknown	Primary	11557	2009-01-01 00:00:00
joint	7242	unknown	Primary	11558	2009-01-01 00:00:00
seep	7243	unknown	Primary	11559	2009-01-01 00:00:00
continental margin	7244	unknown	Primary	11560	2009-01-01 00:00:00
continental rise	7245	unknown	Primary	11561	2009-01-01 00:00:00
shelf break	7246	unknown	Primary	11562	2009-01-01 00:00:00
continental slope	7247	unknown	Primary	11563	2009-01-01 00:00:00
continental shelf	7248	unknown	Primary	11564	2009-01-01 00:00:00
slickenside	7249	unknown	Primary	11565	2009-01-01 00:00:00
Abyssal plain	7250	unknown	Primary	11566	2009-01-01 00:00:00
slide	7251	unknown	Primary	11567	2009-01-01 00:00:00
valley	7252	unknown	Primary	11568	2009-01-01 00:00:00
submarine canyon	7253	unknown	Primary	11569	2009-01-01 00:00:00
slab	7254	unknown	Primary	11570	2009-01-01 00:00:00
vein	7255	unknown	Primary	11571	2009-01-01 00:00:00
pit	7256	unknown	Primary	11572	2009-01-01 00:00:00
slump	7257	unknown	Primary	11573	2009-01-01 00:00:00
bubbles	7258	unknown	Primary	11574	2009-01-01 00:00:00
mud volcano	7259	unknown	Primary	11575	2009-01-01 00:00:00
platform	7260	unknown	Primary	11576	2009-01-01 00:00:00
coating	7261	unknown	Primary	11577	2009-01-01 00:00:00
slope break	7262	unknown	Primary	11578	2009-01-01 00:00:00
fossil	7263	unknown	Primary	11579	2009-01-01 00:00:00
lava form	7264	unknown	Primary	11580	2009-01-01 00:00:00
lobate flow	7265	unknown	Primary	11581	2009-01-01 00:00:00
tumulus	7266	unknown	Primary	11582	2009-01-01 00:00:00
pillow bud	7267	unknown	Primary	11583	2009-01-01 00:00:00
lava flow	7268	unknown	Primary	11584	2009-01-01 00:00:00
hornito	7269	unknown	Primary	11585	2009-01-01 00:00:00
lava ring	7270	unknown	Primary	11586	2009-01-01 00:00:00
sheet flow	7271	unknown	Primary	11587	2009-01-01 00:00:00
sheet-flow	7271	unknown	Synonym	11588	2009-01-01 00:00:00
folded flow	7272	unknown	Primary	11589	2009-01-01 00:00:00
folded-flow	7272	unknown	Synonym	11590	2009-01-01 00:00:00
ropy flow	7273	unknown	Primary	11591	2009-01-01 00:00:00
ropy-flow	7273	unknown	Synonym	11592	2009-01-01 00:00:00
pahoehoe	7274	unknown	Primary	11593	2009-01-01 00:00:00
lava tube	7275	unknown	Primary	11594	2009-01-01 00:00:00
sill	7276	unknown	Primary	11595	2009-01-01 00:00:00
dike	7277	unknown	Primary	11596	2009-01-01 00:00:00
drainback	7278	unknown	Primary	11597	2009-01-01 00:00:00
lava pond	7279	unknown	Primary	11598	2009-01-01 00:00:00
drained pillow	7280	unknown	Primary	11599	2009-01-01 00:00:00
lava pillar	7281	unknown	Primary	11600	2009-01-01 00:00:00
shield	7282	unknown	Primary	11601	2009-01-01 00:00:00
lava channel	7283	unknown	Primary	11602	2009-01-01 00:00:00
skylight	7284	unknown	Primary	11603	2009-01-01 00:00:00
columnar jointed outcrop	7285	unknown	Primary	11604	2009-01-01 00:00:00
collapse pit	7286	unknown	Primary	11605	2009-01-01 00:00:00
aa	7287	unknown	Primary	11606	2009-01-01 00:00:00
a`a	7287	unknown	Common	11607	2009-01-01 00:00:00
spatter	7288	unknown	Primary	11608	2009-01-01 00:00:00
pillow	7289	unknown	Primary	11609	2009-01-01 00:00:00
drained lobe	7290	unknown	Primary	11610	2009-01-01 00:00:00
caldera	7291	unknown	Primary	11611	2009-01-01 00:00:00
crater	7292	unknown	Primary	11612	2009-01-01 00:00:00
scoria	7293	unknown	Primary	11613	2009-01-01 00:00:00
cinder	7294	unknown	Primary	11614	2009-01-01 00:00:00
pumice	7295	unknown	Primary	11615	2009-01-01 00:00:00
crack	7296	unknown	Primary	11616	2009-01-01 00:00:00
crevice	7297	unknown	Primary	11617	2009-01-01 00:00:00
pockmark	7298	unknown	Primary	11618	2009-01-01 00:00:00
boulder	7299	unknown	Primary	11619	2009-01-01 00:00:00
fracture	7300	unknown	Primary	11620	2009-01-01 00:00:00
fault	7301	unknown	Primary	11621	2009-01-01 00:00:00
thrust fault	7302	unknown	Primary	11622	2009-01-01 00:00:00
trench	7303	unknown	Primary	11623	2009-01-01 00:00:00
ridge	7304	unknown	Primary	11624	2009-01-01 00:00:00
ledge	7305	unknown	Primary	11625	2009-01-01 00:00:00
delta	7306	unknown	Primary	11626	2009-01-01 00:00:00
fan	7306	unknown	Common	11627	2009-01-01 00:00:00
chute	7307	unknown	Primary	11628	2009-01-01 00:00:00
depression	7308	unknown	Primary	11629	2009-01-01 00:00:00
rockwall	7309	unknown	Primary	11630	2009-01-01 00:00:00
ridge crest	7310	unknown	Primary	11631	2009-01-01 00:00:00
benthos	7311	unknown	Primary	11632	2009-01-01 00:00:00
groove 2	7312	unknown	Primary	11633	2009-01-01 00:00:00
groove-on-geological-feature	7312	unknown	Common	11634	2009-01-01 00:00:00
seamount	7313	unknown	Primary	11635	2009-01-01 00:00:00
field	7314	unknown	Primary	11636	2009-01-01 00:00:00
field of view 36	7315	unknown	Primary	11637	2009-01-01 00:00:00
field of view 24	7316	unknown	Primary	11638	2009-01-01 00:00:00
field of view 30	7317	unknown	Primary	11639	2009-01-01 00:00:00
field of view 39	7318	unknown	Primary	11640	2009-01-01 00:00:00
fissure	7319	unknown	Primary	11641	2009-01-01 00:00:00
shelf	7320	unknown	Primary	11642	2009-01-01 00:00:00
gully	7321	unknown	Primary	11643	2009-01-01 00:00:00
crust	7322	unknown	Primary	11644	2009-01-01 00:00:00
canyon	7323	unknown	Primary	11645	2009-01-01 00:00:00
hill	7324	unknown	Primary	11646	2009-01-01 00:00:00
fracture zone	7325	unknown	Primary	11647	2009-01-01 00:00:00
cave	7326	unknown	Primary	11648	2009-01-01 00:00:00
ravine	7327	unknown	Primary	11649	2009-01-01 00:00:00
bedding	7328	unknown	Primary	11650	2009-01-01 00:00:00
plain	7329	unknown	Primary	11651	2009-01-01 00:00:00
mound	7330	unknown	Primary	11652	2009-01-01 00:00:00
block	7331	unknown	Primary	11653	2009-01-01 00:00:00
Mid-ocean ridge	7332	unknown	Primary	11654	2009-01-01 00:00:00
Ridge flank	7333	unknown	Primary	11655	2009-01-01 00:00:00
Axial valley	7334	unknown	Primary	11656	2009-01-01 00:00:00
gravel	7335	unknown	Primary	11657	2009-01-01 00:00:00
hole	7336	unknown	Primary	11658	2009-01-01 00:00:00
pothole	7337	unknown	Primary	11659	2009-01-01 00:00:00
corehole	7338	unknown	Primary	11660	2009-01-01 00:00:00
talus	7339	unknown	Primary	11661	2009-01-01 00:00:00
pavement	7340	unknown	Primary	11662	2009-01-01 00:00:00
flange	7341	unknown	Primary	11663	2009-01-01 00:00:00
rock outcrop	7342	unknown	Primary	11664	2009-01-01 00:00:00
hydrothermal vent	7343	unknown	Primary	11665	2009-01-01 00:00:00
Black Smoker	7344	unknown	Primary	11666	2009-01-01 00:00:00
inactive spire	7345	unknown	Primary	11667	2009-01-01 00:00:00
clear shimmering vent	7346	unknown	Primary	11668	2009-01-01 00:00:00
White Smoker	7347	unknown	Primary	11669	2009-01-01 00:00:00
cliff	7348	unknown	Primary	11670	2009-01-01 00:00:00
concretion	7349	unknown	Primary	11671	2009-01-01 00:00:00
rubble	7350	unknown	Primary	11672	2009-01-01 00:00:00
spring	7351	unknown	Primary	11673	2009-01-01 00:00:00
volcanic glass	7352	unknown	Primary	11674	2009-01-01 00:00:00
strike	7353	unknown	Primary	11675	2009-01-01 00:00:00
columnar jointing	7354	unknown	Primary	11676	2009-01-01 00:00:00
fold	7355	unknown	Primary	11677	2009-01-01 00:00:00
bed thickness	7356	unknown	Primary	11678	2009-01-01 00:00:00
chemical	7357	unknown	Primary	11679	2009-01-01 00:00:00
hydrocarbon	7358	unknown	Primary	11680	2009-01-01 00:00:00
bitumen	7359	unknown	Primary	11681	2009-01-01 00:00:00
tar-ball	7359	unknown	Common	11682	2009-01-01 00:00:00
tar	7359	unknown	Common	11683	2009-01-01 00:00:00
petroleum	7360	unknown	Primary	11684	2009-01-01 00:00:00
oil	7360	unknown	Common	11685	2009-01-01 00:00:00
gas	7361	unknown	Primary	11686	2009-01-01 00:00:00
natural gas	7362	unknown	Primary	11687	2009-01-01 00:00:00
air	7363	unknown	Primary	11688	2009-01-01 00:00:00
carbon dioxide	7364	unknown	Primary	11689	2009-01-01 00:00:00
hydrogen sulfide	7365	unknown	Primary	11690	2009-01-01 00:00:00
methane	7366	unknown	Primary	11691	2009-01-01 00:00:00
CO2 liquid	7367	unknown	Primary	11692	2009-01-01 00:00:00
boundary	7368	unknown	Primary	11693	2009-01-01 00:00:00
temperature	7369	unknown	Primary	11694	2009-01-01 00:00:00
organism part	7370	unknown	Primary	11695	2009-01-01 00:00:00
body	7371	unknown	Primary	11696	2009-01-01 00:00:00
carapace	7372	unknown	Primary	11697	2009-01-01 00:00:00
siphon	7373	unknown	Primary	11698	2009-01-01 00:00:00
ink	7374	unknown	Primary	11699	2009-01-01 00:00:00
zooid	7375	unknown	Primary	11700	2009-01-01 00:00:00
pouch	7376	unknown	Primary	11701	2009-01-01 00:00:00
shell	7377	unknown	Primary	11702	2009-01-01 00:00:00
appendage	7378	unknown	Primary	11703	2009-01-01 00:00:00
spine	7379	unknown	Primary	11704	2009-01-01 00:00:00
manubrium	7380	unknown	Primary	11705	2009-01-01 00:00:00
nose	7381	unknown	Primary	11706	2009-01-01 00:00:00
bristle	7382	unknown	Primary	11707	2009-01-01 00:00:00
inner filter	7383	unknown	Primary	11708	2009-01-01 00:00:00
stipe	7384	unknown	Primary	11709	2009-01-01 00:00:00
arm	7385	unknown	Primary	11710	2009-01-01 00:00:00
bract	7386	unknown	Primary	11711	2009-01-01 00:00:00
blade	7387	unknown	Primary	11712	2009-01-01 00:00:00
stalk	7388	unknown	Primary	11713	2009-01-01 00:00:00
tube	7389	unknown	Primary	11714	2009-01-01 00:00:00
swimming bell	7390	unknown	Primary	11715	2009-01-01 00:00:00
swimming-bell	7390	unknown	Synonym	11716	2009-01-01 00:00:00
papillae	7391	unknown	Primary	11717	2009-01-01 00:00:00
spicule	7392	unknown	Primary	11718	2009-01-01 00:00:00
fin ray	7393	unknown	Primary	11719	2009-01-01 00:00:00
filament	7394	unknown	Primary	11720	2009-01-01 00:00:00
peduncle	7395	unknown	Primary	11721	2009-01-01 00:00:00
test	7396	unknown	Primary	11722	2009-01-01 00:00:00
groove	7397	unknown	Primary	11723	2009-01-01 00:00:00
groove-on-marine-organism	7397	unknown	Common	11724	2009-01-01 00:00:00
cheliped	7398	unknown	Primary	11725	2009-01-01 00:00:00
paxillae	7399	unknown	Primary	11726	2009-01-01 00:00:00
notochord	7400	unknown	Primary	11727	2009-01-01 00:00:00
lobe	7401	unknown	Primary	11728	2009-01-01 00:00:00
gastrozooid	7402	unknown	Primary	11729	2009-01-01 00:00:00
filter	7403	unknown	Primary	11730	2009-01-01 00:00:00
operculum	7404	unknown	Primary	11731	2009-01-01 00:00:00
rhinophore	7405	unknown	Primary	11732	2009-01-01 00:00:00
eggs	7406	unknown	Primary	11733	2009-01-01 00:00:00
chromatophore	7407	unknown	Primary	11734	2009-01-01 00:00:00
conard	7408	unknown	Primary	11735	2009-01-01 00:00:00
antenna	7409	unknown	Primary	11736	2009-01-01 00:00:00
ghost tail	7410	unknown	Primary	11737	2009-01-01 00:00:00
beak	7411	unknown	Primary	11738	2009-01-01 00:00:00
eggcase	7412	unknown	Primary	11739	2009-01-01 00:00:00
nectosome	7413	unknown	Primary	11740	2009-01-01 00:00:00
mucous string	7414	unknown	Primary	11741	2009-01-01 00:00:00
interradial arc	7415	unknown	Primary	11742	2009-01-01 00:00:00
skeleton	7416	unknown	Primary	11743	2009-01-01 00:00:00
head	7417	unknown	Primary	11744	2009-01-01 00:00:00
polyp	7418	unknown	Primary	11745	2009-01-01 00:00:00
gut	7419	unknown	Primary	11746	2009-01-01 00:00:00
ear	7420	unknown	Primary	11747	2009-01-01 00:00:00
shell fragment	7421	unknown	Primary	11748	2009-01-01 00:00:00
shell-fragment	7421	unknown	Synonym	11749	2009-01-01 00:00:00
tubefeet	7422	unknown	Primary	11750	2009-01-01 00:00:00
ink sac	7423	unknown	Primary	11751	2009-01-01 00:00:00
disk	7424	unknown	Primary	11752	2009-01-01 00:00:00
tentacle	7425	unknown	Primary	11753	2009-01-01 00:00:00
pedicellaria	7426	unknown	Primary	11754	2009-01-01 00:00:00
osculum	7427	unknown	Primary	11755	2009-01-01 00:00:00
foot	7428	unknown	Primary	11756	2009-01-01 00:00:00
larvacean house	7429	unknown	Primary	11757	2009-01-01 00:00:00
pneumatophore	7430	unknown	Primary	11758	2009-01-01 00:00:00
madreporite	7431	unknown	Primary	11759	2009-01-01 00:00:00
crop	7432	unknown	Primary	11760	2009-01-01 00:00:00
aperture	7433	unknown	Primary	11761	2009-01-01 00:00:00
leg	7434	unknown	Primary	11762	2009-01-01 00:00:00
nematocyst	7435	unknown	Primary	11763	2009-01-01 00:00:00
float	7436	unknown	Primary	11764	2009-01-01 00:00:00
photophore	7437	unknown	Primary	11765	2009-01-01 00:00:00
lophophore	7438	unknown	Primary	11766	2009-01-01 00:00:00
cerata	7439	unknown	Primary	11767	2009-01-01 00:00:00
bell	7440	unknown	Primary	11768	2009-01-01 00:00:00
holdfast	7441	unknown	Primary	11769	2009-01-01 00:00:00
molt	7442	unknown	Primary	11770	2009-01-01 00:00:00
mouth	7443	unknown	Primary	11771	2009-01-01 00:00:00
comb plates	7444	unknown	Primary	11772	2009-01-01 00:00:00
lateral line	7445	unknown	Primary	11773	2009-01-01 00:00:00
lateral-line	7445	unknown	Synonym	11774	2009-01-01 00:00:00
bone	7446	unknown	Primary	11775	2009-01-01 00:00:00
nectophore	7447	unknown	Primary	11776	2009-01-01 00:00:00
outer filter	7448	unknown	Primary	11777	2009-01-01 00:00:00
outer-filter	7448	unknown	Synonym	11778	2009-01-01 00:00:00
pincer	7449	unknown	Primary	11779	2009-01-01 00:00:00
gonads	7450	unknown	Primary	11780	2009-01-01 00:00:00
auricle	7451	unknown	Primary	11781	2009-01-01 00:00:00
claw	7452	unknown	Primary	11782	2009-01-01 00:00:00
clasper	7453	unknown	Primary	11783	2009-01-01 00:00:00
seta	7454	unknown	Primary	11784	2009-01-01 00:00:00
whale carcass	7455	unknown	Primary	11785	2009-01-01 00:00:00
whale-carcass	7455	unknown	Synonym	11786	2009-01-01 00:00:00
palpon	7456	unknown	Primary	11787	2009-01-01 00:00:00
mantle	7457	unknown	Primary	11788	2009-01-01 00:00:00
lure	7458	unknown	Primary	11789	2009-01-01 00:00:00
gills	7459	unknown	Primary	11790	2009-01-01 00:00:00
sucker row	7460	unknown	Primary	11791	2009-01-01 00:00:00
sucker-row	7460	unknown	Synonym	11792	2009-01-01 00:00:00
radial canal	7461	unknown	Primary	11793	2009-01-01 00:00:00
radial-canal	7461	unknown	Synonym	11794	2009-01-01 00:00:00
eye	7462	unknown	Primary	11795	2009-01-01 00:00:00
ball	7463	unknown	Primary	11796	2009-01-01 00:00:00
rostrum	7464	unknown	Primary	11797	2009-01-01 00:00:00
fin	7465	unknown	Primary	11798	2009-01-01 00:00:00
muscle	7466	unknown	Primary	11799	2009-01-01 00:00:00
parapodium	7467	unknown	Primary	11800	2009-01-01 00:00:00
fecal material	7468	unknown	Primary	11801	2009-01-01 00:00:00
parasite	7469	unknown	Primary	11802	2009-01-01 00:00:00
bead	7470	unknown	Primary	11803	2009-01-01 00:00:00
ramp	7471	unknown	Primary	11804	2009-01-01 00:00:00
scale	7472	unknown	Primary	11805	2009-01-01 00:00:00
tooth	7473	unknown	Primary	11806	2009-01-01 00:00:00
segment	7474	unknown	Primary	11807	2009-01-01 00:00:00
tail	7475	unknown	Primary	11808	2009-01-01 00:00:00
hood	7476	unknown	Primary	11809	2009-01-01 00:00:00
biological structure	7477	unknown	Primary	11810	2009-01-01 00:00:00
marine snow	7478	unknown	Primary	11811	2009-01-01 00:00:00
zooplankton	7479	unknown	Primary	11812	2009-01-01 00:00:00
particulate	7480	unknown	Primary	11813	2009-01-01 00:00:00
plankton	7481	unknown	Primary	11814	2009-01-01 00:00:00
mung	7482	unknown	Primary	11815	2009-01-01 00:00:00
sinker	7483	unknown	Primary	11816	2009-01-01 00:00:00
Bathochordaeus sinker	7484	unknown	Primary	11817	2009-01-01 00:00:00
Redhead sinker	7485	unknown	Primary	11818	2009-01-01 00:00:00
fecal pellet	7486	unknown	Primary	11819	2009-01-01 00:00:00
Polychaeta tube	7487	unknown	Primary	11820	2009-01-01 00:00:00
polychaete-tube	7487	unknown	Synonym	11821	2009-01-01 00:00:00
polychaeta tube	7487	unknown	Synonym	11822	2009-01-01 00:00:00
bacterial mat	7488	unknown	Primary	11823	2009-01-01 00:00:00
amphipod tube mat	7489	unknown	Primary	11824	2009-01-01 00:00:00
bioturbation	7490	unknown	Primary	11825	2009-01-01 00:00:00
equipment	7491	unknown	Primary	11826	2009-01-01 00:00:00
Clathrate Bucket	7492	unknown	Primary	11827	2009-01-01 00:00:00
Benthic Instrument Node	7493	unknown	Primary	11828	2009-01-01 00:00:00
BIN	7493	unknown	Synonym	11829	2009-01-01 00:00:00
TPC	7494	unknown	Primary	11830	2009-01-01 00:00:00
temperature, pressure, conductivity sensor	7494	unknown	Synonym	11831	2009-01-01 00:00:00
Wax-corer	7495	unknown	Primary	11832	2009-01-01 00:00:00
site marker	7496	unknown	Primary	11833	2009-01-01 00:00:00
Dissolution Ball	7497	unknown	Primary	11834	2009-01-01 00:00:00
Odor Pump	7498	unknown	Primary	11835	2009-01-01 00:00:00
Remote Instrument Node	7499	unknown	Primary	11836	2009-01-01 00:00:00
RIN	7499		Synonym	11837	2009-01-01 00:00:00
Glass Suction Sampler	7500	unknown	Primary	11838	2009-01-01 00:00:00
Push Corer	7501	unknown	Primary	11839	2009-01-01 00:00:00
Vibracorer	7502	unknown	Primary	11840	2009-01-01 00:00:00
Vibrapeeper	7503	unknown	Primary	11841	2009-01-01 00:00:00
benthic barrel	7504	unknown	Primary	11842	2009-01-01 00:00:00
Phyllospadix Settlement Rake	7505	unknown	Primary	11843	2009-01-01 00:00:00
cylinder	7506	unknown	Primary	11844	2009-01-01 00:00:00
Biology box	7507	unknown	Primary	11845	2009-01-01 00:00:00
Bubble Meter	7508	unknown	Primary	11846	2009-01-01 00:00:00
Chemoattractant	7509	unknown	Primary	11847	2009-01-01 00:00:00
Communications Cage	7510	unknown	Primary	11848	2009-01-01 00:00:00
housing	7511	unknown	Primary	11849	2009-01-01 00:00:00
beaker	7512	unknown	Primary	11850	2009-01-01 00:00:00
Impact Glass Sampler	7513	unknown	Primary	11851	2009-01-01 00:00:00
tether	7514	unknown	Primary	11852	2009-01-01 00:00:00
bottom mount	7515	unknown	Primary	11853	2009-01-01 00:00:00
Thermocouple Array	7516	unknown	Primary	11854	2009-01-01 00:00:00
structured light	7517	unknown	Primary	11855	2009-01-01 00:00:00
Hydrate Pressure Vessel	7518	unknown	Primary	11856	2009-01-01 00:00:00
caisson	7519	unknown	Primary	11857	2009-01-01 00:00:00
video mosaic	7520	unknown	Primary	11858	2009-01-01 00:00:00
seismometer	7521	unknown	Primary	11859	2009-01-01 00:00:00
guralp-seismometer	7522	unknown	Primary	11860	2009-01-01 00:00:00
seismonument	7523	unknown	Primary	11861	2009-01-01 00:00:00
Bio tube	7524	unknown	Primary	11862	2009-01-01 00:00:00
colander	7525	unknown	Primary	11863	2009-01-01 00:00:00
drill	7526	unknown	Primary	11864	2009-01-01 00:00:00
Core Water Sampler	7527	unknown	Primary	11865	2009-01-01 00:00:00
pH meter	7528	unknown	Primary	11866	2009-01-01 00:00:00
Tiltmeter	7529	unknown	Primary	11867	2009-01-01 00:00:00
magnetometer	7530	unknown	Primary	11868	2009-01-01 00:00:00
Sandbox	7531	unknown	Primary	11869	2009-01-01 00:00:00
Hydrate Exposure Vessel II	7532	unknown	Primary	11870	2009-01-01 00:00:00
CO2 Delivery Box	7533	unknown	Primary	11871	2009-01-01 00:00:00
ship	7534	unknown	Primary	11872	2009-01-01 00:00:00
Western Flyer	7535	unknown	Primary	11873	2009-01-01 00:00:00
Point Lobos	7536	unknown	Primary	11874	2009-01-01 00:00:00
CO2 Exposure Vessel	7537	unknown	Primary	11875	2009-01-01 00:00:00
Pulnix	7538	unknown	Primary	11876	2009-01-01 00:00:00
In Situ Ultraviolet Spectrophotometer	7539	unknown	Primary	11877	2009-01-01 00:00:00
ISUS	7539		Synonym	11878	2009-01-01 00:00:00
Chemical Scanner	7540	unknown	Primary	11879	2009-01-01 00:00:00
Peeper	7541	unknown	Primary	11880	2009-01-01 00:00:00
Radium Sampler	7542	unknown	Primary	11881	2009-01-01 00:00:00
CTD pH Meter Platform	7543	unknown	Primary	11882	2009-01-01 00:00:00
Osmo Analyzer	7544	unknown	Primary	11883	2009-01-01 00:00:00
Savonius Rotor	7545	unknown	Primary	11884	2009-01-01 00:00:00
lights	7546	unknown	Primary	11885	2009-01-01 00:00:00
CTD pH Meter Cage	7547	unknown	Primary	11886	2009-01-01 00:00:00
Temperature Gradient Probe	7548	unknown	Primary	11887	2009-01-01 00:00:00
Conductivity Probe	7549	unknown	Primary	11888	2009-01-01 00:00:00
cage	7550	unknown	Primary	11889	2009-01-01 00:00:00
Cable-laying toolsled	7551	unknown	Primary	11890	2009-01-01 00:00:00
CO2 Delivery System	7552	unknown	Primary	11891	2009-01-01 00:00:00
external battery pack	7553	unknown	Primary	11892	2009-01-01 00:00:00
Exclusion Cage	7554	unknown	Primary	11893	2009-01-01 00:00:00
Clam Raceway	7555	unknown	Primary	11894	2009-01-01 00:00:00
High Temperature Probe	7556	unknown	Primary	11895	2009-01-01 00:00:00
Hydrate Observatory I	7557	unknown	Primary	11896	2009-01-01 00:00:00
drawer	7558	unknown	Primary	11897	2009-01-01 00:00:00
CTD	7559	unknown	Primary	11898	2009-01-01 00:00:00
SPS4	7560	unknown	Primary	11899	2009-01-01 00:00:00
mooring	7561	unknown	Primary	11900	2009-01-01 00:00:00
benthic mooring	7562	unknown	Primary	11901	2009-01-01 00:00:00
Niskin	7563	unknown	Primary	11902	2009-01-01 00:00:00
Laser Raman	7564	unknown	Primary	11903	2009-01-01 00:00:00
swing arm	7565	unknown	Primary	11904	2009-01-01 00:00:00
hose	7566	unknown	Primary	11905	2009-01-01 00:00:00
Dye Injector	7567	unknown	Primary	11906	2009-01-01 00:00:00
piezometer	7568	unknown	Primary	11907	2009-01-01 00:00:00
Acoustic Doppler Current Profiler	7569	unknown	Primary	11908	2009-01-01 00:00:00
ADCP	7569	unknown	Synonym	11909	2009-01-01 00:00:00
fry scoop	7570	unknown	Primary	11910	2009-01-01 00:00:00
resin block	7571	unknown	Primary	11911	2009-01-01 00:00:00
Gas-tight Water Sampler	7572	unknown	Primary	11912	2009-01-01 00:00:00
gauge	7573	unknown	Primary	11913	2009-01-01 00:00:00
probe	7574	unknown	Primary	11914	2009-01-01 00:00:00
lead line	7575	unknown	Primary	11915	2009-01-01 00:00:00
Brachiopod basket	7576	unknown	Primary	11916	2009-01-01 00:00:00
Miniature Temperature Recorder	7577	unknown	Primary	11917	2009-01-01 00:00:00
MTR	7577		Synonym	11918	2009-01-01 00:00:00
Go-Flo  Bottle	7578	unknown	Primary	11919	2009-01-01 00:00:00
iris	7579	unknown	Primary	11920	2009-01-01 00:00:00
sonar	7580	unknown	Primary	11921	2009-01-01 00:00:00
crane	7581	unknown	Primary	11922	2009-01-01 00:00:00
Loran	7582	unknown	Primary	11923	2009-01-01 00:00:00
CO2 Monitor Box	7583	unknown	Primary	11924	2009-01-01 00:00:00
Seewald Gas Tight Sampler	7584	unknown	Primary	11925	2009-01-01 00:00:00
sediment trap	7585	unknown	Primary	11926	2009-01-01 00:00:00
Lexan Top Hat	7586	unknown	Primary	11927	2009-01-01 00:00:00
Acoustic Current Meter	7587	unknown	Primary	11928	2009-01-01 00:00:00
ACM	7587	unknown	Synonym	11929	2009-01-01 00:00:00
battery cage	7588	unknown	Primary	11930	2009-01-01 00:00:00
tow	7589	unknown	Primary	11931	2009-01-01 00:00:00
filtration device	7590	unknown	Primary	11932	2009-01-01 00:00:00
Heat Flow Probe	7591	unknown	Primary	11933	2009-01-01 00:00:00
dock	7592	unknown	Primary	11934	2009-01-01 00:00:00
Brachiopod Settlement Block	7593	unknown	Primary	11935	2009-01-01 00:00:00
pH probe	7594	unknown	Primary	11936	2009-01-01 00:00:00
Gas  Sampler I	7595	unknown	Primary	11937	2009-01-01 00:00:00
drill bit	7596	unknown	Primary	11938	2009-01-01 00:00:00
dustpan	7597	unknown	Primary	11939	2009-01-01 00:00:00
Box corer	7598	unknown	Primary	11940	2009-01-01 00:00:00
line	7599	unknown	Primary	11941	2009-01-01 00:00:00
knife	7600	unknown	Primary	11942	2009-01-01 00:00:00
PVC pipe	7601	unknown	Primary	11943	2009-01-01 00:00:00
Gas Sampler II	7602	unknown	Primary	11944	2009-01-01 00:00:00
connector cover	7603	unknown	Primary	11945	2009-01-01 00:00:00
compass	7604	unknown	Primary	11946	2009-01-01 00:00:00
drop weight	7605	unknown	Primary	11947	2009-01-01 00:00:00
trawl mark	7606	unknown	Primary	11948	2009-01-01 00:00:00
trawl	7606	unknown	Synonym	11949	2009-01-01 00:00:00
Hydrate Synthesis Chamber	7607	unknown	Primary	11950	2009-01-01 00:00:00
settlement trap	7608	unknown	Primary	11951	2009-01-01 00:00:00
connector	7609	unknown	Primary	11952	2009-01-01 00:00:00
Larval Tray	7610	unknown	Primary	11953	2009-01-01 00:00:00
Hydrate Bucket I	7611	unknown	Primary	11954	2009-01-01 00:00:00
cable	7612	unknown	Primary	11955	2009-01-01 00:00:00
elevator	7613	unknown	Primary	11956	2009-01-01 00:00:00
Transmissometer	7614	unknown	Primary	11957	2009-01-01 00:00:00
beacon	7615	unknown	Primary	11958	2009-01-01 00:00:00
Osmo Flow Meter	7616	unknown	Primary	11959	2009-01-01 00:00:00
metal scoop	7617	unknown	Primary	11960	2009-01-01 00:00:00
camera-transport	7618	unknown	Primary	11961	2009-01-01 00:00:00
ROV	7619	unknown	Primary	11962	2009-01-01 00:00:00
Tiburon	7620	unknown	Primary	11963	2009-01-01 00:00:00
Ventana	7621	unknown	Primary	11964	2009-01-01 00:00:00
fiber optic cable	7622	unknown	Primary	11965	2009-01-01 00:00:00
Sinking Ball	7623	unknown	Primary	11966	2009-01-01 00:00:00
softball	7624	unknown	Primary	11967	2009-01-01 00:00:00
Larval Incubation Chamber	7625	unknown	Primary	11968	2009-01-01 00:00:00
manipulator	7626	unknown	Primary	11969	2009-01-01 00:00:00
mongo	7627	unknown	Primary	11970	2009-01-01 00:00:00
schilling-arm	7628	unknown	Primary	11971	2009-01-01 00:00:00
donk	7629	unknown	Primary	11972	2009-01-01 00:00:00
kraft-raptor	7630	unknown	Primary	11973	2009-01-01 00:00:00
dongo	7631	unknown	Primary	11974	2009-01-01 00:00:00
vibraclaw	7632	unknown	Primary	11975	2009-01-01 00:00:00
end-effector	7633	unknown	Primary	11976	2009-01-01 00:00:00
tweezers	7634	unknown	Primary	11977	2009-01-01 00:00:00
clamshell	7635	unknown	Primary	11978	2009-01-01 00:00:00
current meter	7636	unknown	Primary	11979	2009-01-01 00:00:00
Hydroscat2	7637	unknown	Primary	11980	2009-01-01 00:00:00
hydroscat2	7637	unknown	Synonym	11981	2009-01-01 00:00:00
corral	7638	unknown	Primary	11982	2009-01-01 00:00:00
CO2 Corral	7639	unknown	Primary	11983	2009-01-01 00:00:00
co2-corral	7639	unknown	Synonym	11984	2009-01-01 00:00:00
back deck	7640	unknown	Primary	11985	2009-01-01 00:00:00
canister	7641	unknown	Primary	11986	2009-01-01 00:00:00
GPS	7642	unknown	Primary	11987	2009-01-01 00:00:00
Acoustic Probe	7643	unknown	Primary	11988	2009-01-01 00:00:00
data logger	7644	unknown	Primary	11989	2009-01-01 00:00:00
L Cheapo	7645	unknown	Primary	11990	2009-01-01 00:00:00
l-cheapo	7645	unknown	Synonym	11991	2009-01-01 00:00:00
Geosense	7646	unknown	Primary	11992	2009-01-01 00:00:00
geosense	7646	unknown	Synonym	11993	2009-01-01 00:00:00
Bubble Chamber	7647	unknown	Primary	11994	2009-01-01 00:00:00
Hopper with Glass Marbles	7648	unknown	Primary	11995	2009-01-01 00:00:00
quiver	7649	unknown	Primary	11996	2009-01-01 00:00:00
Detritus Sampler	7650	unknown	Primary	11997	2009-01-01 00:00:00
Odor Pumping Rig	7651	unknown	Primary	11998	2009-01-01 00:00:00
Multi Corer	7652	unknown	Primary	11999	2009-01-01 00:00:00
GIS map	7653	unknown	Primary	12000	2009-01-01 00:00:00
High Temperature Recorder	7654	unknown	Primary	12001	2009-01-01 00:00:00
hobo	7654	unknown	Synonym	12002	2009-01-01 00:00:00
lasers	7655	unknown	Primary	12003	2009-01-01 00:00:00
Odor Plume Experiment	7656	unknown	Primary	12004	2009-01-01 00:00:00
Titanium Major Water Sampler	7657	unknown	Primary	12005	2009-01-01 00:00:00
Methane Sensor	7658	unknown	Primary	12006	2009-01-01 00:00:00
trap	7659	unknown	Primary	12007	2009-01-01 00:00:00
Suction Sampler	7660	unknown	Primary	12008	2009-01-01 00:00:00
Homerpro	7661	unknown	Primary	12009	2009-01-01 00:00:00
quadrat	7662	unknown	Primary	12010	2009-01-01 00:00:00
field of view	7663	unknown	Primary	12011	2009-01-01 00:00:00
Waffle Stomper	7664	unknown	Primary	12012	2009-01-01 00:00:00
cable tracker	7665	unknown	Primary	12013	2009-01-01 00:00:00
latch	7666	unknown	Primary	12014	2009-01-01 00:00:00
Benthic Respiration Chamber	7667	unknown	Primary	12015	2009-01-01 00:00:00
adhesive	7668	unknown	Primary	12016	2009-01-01 00:00:00
sizing	7669	unknown	Primary	12017	2009-01-01 00:00:00
Osmo Sampler	7670	unknown	Primary	12018	2009-01-01 00:00:00
tubing	7671	unknown	Primary	12019	2009-01-01 00:00:00
Hydrate Exposure Vessel I	7672	unknown	Primary	12020	2009-01-01 00:00:00
cable spool	7673	unknown	Primary	12021	2009-01-01 00:00:00
Clam dumper	7674	unknown	Primary	12022	2009-01-01 00:00:00
camera	7675	unknown	Primary	12023	2009-01-01 00:00:00
time-lapse camera	7676	unknown	Primary	12024	2009-01-01 00:00:00
sit camera	7677	unknown	Primary	12025	2009-01-01 00:00:00
sit-camera	7677	unknown	Synonym	12026	2009-01-01 00:00:00
main-camera	7678	unknown	Primary	12027	2009-01-01 00:00:00
Aux camera	7679	unknown	Primary	12028	2009-01-01 00:00:00
still-photo camera	7680	unknown	Primary	12029	2009-01-01 00:00:00
still-photo-camera	7680	unknown	Synonym	12030	2009-01-01 00:00:00
Bioluminescent Camera	7681	unknown	Primary	12031	2009-01-01 00:00:00
color bars	7682	unknown	Primary	12032	2009-01-01 00:00:00
calibrator	7683	unknown	Primary	12033	2009-01-01 00:00:00
Water-lift	7684	unknown	Primary	12034	2009-01-01 00:00:00
ISUS Lander	7685	unknown	Primary	12035	2009-01-01 00:00:00
Sinking Chamber	7686	unknown	Primary	12036	2009-01-01 00:00:00
Hydrate Bucket II	7687	unknown	Primary	12037	2009-01-01 00:00:00
pH Pod	7688	unknown	Primary	12038	2009-01-01 00:00:00
label	7689	unknown	Primary	12039	2009-01-01 00:00:00
graduated cylinder	7690	unknown	Primary	12040	2009-01-01 00:00:00
reamer	7691	unknown	Primary	12041	2009-01-01 00:00:00
Hydrate Observatory II	7692	unknown	Primary	12042	2009-01-01 00:00:00
Benthos spheres	7693	unknown	Primary	12043	2009-01-01 00:00:00
shackle	7694	unknown	Primary	12044	2009-01-01 00:00:00
anchor	7695	unknown	Primary	12045	2009-01-01 00:00:00
Particle Injector	7696	unknown	Primary	12046	2009-01-01 00:00:00
Bioluminescent screen	7697	unknown	Primary	12047	2009-01-01 00:00:00
control	7698	unknown	Primary	12048	2009-01-01 00:00:00
ROV-matable Connector	7699	unknown	Primary	12049	2009-01-01 00:00:00
grid	7700	unknown	Primary	12050	2009-01-01 00:00:00
scoop bag	7701	unknown	Primary	12051	2009-01-01 00:00:00
Moonpool	7702	unknown	Primary	12052	2009-01-01 00:00:00
Hydraulic Push Corer	7703	unknown	Primary	12053	2009-01-01 00:00:00
Bullseye level	7704	unknown	Primary	12054	2009-01-01 00:00:00
cutter	7705	unknown	Primary	12055	2009-01-01 00:00:00
sediment probe	7706	unknown	Primary	12056	2009-01-01 00:00:00
Eddy Correlation Sensor	7707	unknown	Primary	12057	2009-01-01 00:00:00
Benthic Respiration System	7708	unknown	Primary	12058	2009-01-01 00:00:00
BRS	7708		Synonym	12059	2009-01-01 00:00:00
Plume Particle Sampler	7709	unknown	Primary	12060	2009-01-01 00:00:00
fish trap	7710	unknown	Primary	12061	2009-01-01 00:00:00
Mclane Profiler	7711	unknown	Primary	12062	2009-01-01 00:00:00
Hydrate Cylinder	7712	unknown	Primary	12063	2009-01-01 00:00:00
Eddy Flux Package	7713	unknown	Primary	12064	2009-01-01 00:00:00
Emergence Trap	7714	unknown	Primary	12065	2009-01-01 00:00:00
pH Profiler	7715	unknown	Primary	12066	2009-01-01 00:00:00
Meiofaunal Growth Chamber	7716	unknown	Primary	12067	2009-01-01 00:00:00
seafloor fuel cell	7717	unknown	Primary	12068	2009-01-01 00:00:00
flow meter	7718	unknown	Primary	12069	2009-01-01 00:00:00
ROV Marker Tool	7719	unknown	Primary	12070	2009-01-01 00:00:00
penetrometer	7720	unknown	Primary	12071	2009-01-01 00:00:00
Extensometer	7721	unknown	Primary	12072	2009-01-01 00:00:00
MARS Node Mockup	7722	unknown	Primary	12073	2009-01-01 00:00:00
Benthic Rover	7723	unknown	Primary	12074	2009-01-01 00:00:00
Larval Sampler	7724	unknown	Primary	12075	2009-01-01 00:00:00
Eye-in-the-Sea	7725	\N	Primary	12076	2009-01-01 00:00:00
EITS	7725		Synonym	12077	2009-01-01 00:00:00
Bonetree	7726		Primary	12078	2009-01-01 00:00:00
Midwater Respirometry System	7727	\N	Primary	12079	2009-01-01 00:00:00
MRS	7727		Synonym	12080	2009-01-01 00:00:00
MARS Node	7728	\N	Primary	12081	2009-01-01 00:00:00
sulfide flux sensor	7729	\N	Primary	12082	2009-01-01 00:00:00
Self Triggering Event Detector	7730		Primary	12083	2009-01-01 00:00:00
STED	7730		Synonym	12084	2009-01-01 00:00:00
Ink Dispenser	7731		Primary	12085	2009-01-01 00:00:00
Benthic Flux Chamber	7732	\N	Primary	12086	2009-01-01 00:00:00
Lagrangian sediment trap	7733		Primary	12087	2009-01-01 00:00:00
Benthic Flux Lander	7734	\N	Primary	12088	2009-01-01 00:00:00
Hydrate Experiment	7735	\N	Primary	12089	2009-01-01 00:00:00
Free Ocean CO2 Experiment	7736	\N	Primary	12090	2009-01-01 00:00:00
FOCE	7736		Synonym	12091	2009-01-01 00:00:00
Test Tank	7737	\N	Primary	12092	2009-01-01 00:00:00
miscellany	7738	unknown	Primary	12093	2009-01-01 00:00:00
bait	7739	unknown	Primary	12094	2009-01-01 00:00:00
launch	7740	unknown	Primary	12095	2009-01-01 00:00:00
shipwreck	7741	unknown	Primary	12096	2009-01-01 00:00:00
recovery	7742	unknown	Primary	12097	2009-01-01 00:00:00
human	7743	unknown	Primary	12098	2009-01-01 00:00:00
Reisenbichler	7744	unknown	Primary	12099	2009-01-01 00:00:00
reisenbichler	7744	unknown	Synonym	12100	2009-01-01 00:00:00
Davis, Alice	7745	unknown	Primary	12101	2009-01-01 00:00:00
davis-alice	7745	unknown	Synonym	12102	2009-01-01 00:00:00
Conway	7746	unknown	Primary	12103	2009-01-01 00:00:00
conway	7746	unknown	Synonym	12104	2009-01-01 00:00:00
McNutt	7747	unknown	Primary	12105	2009-01-01 00:00:00
mcnutt	7747	unknown	Synonym	12106	2009-01-01 00:00:00
Stakes	7748	unknown	Primary	12107	2009-01-01 00:00:00
stakes	7748	unknown	Synonym	12108	2009-01-01 00:00:00
Rodgers	7749	unknown	Primary	12109	2009-01-01 00:00:00
Walz, K.	7749	unknown	Synonym	12110	2009-01-01 00:00:00
Clague	7750	unknown	Primary	12111	2009-01-01 00:00:00
clague	7750	unknown	Synonym	12112	2009-01-01 00:00:00
last-name	7751	unknown	Primary	12113	2009-01-01 00:00:00
Robison	7752	unknown	Primary	12114	2009-01-01 00:00:00
robison	7752	unknown	Synonym	12115	2009-01-01 00:00:00
Whaling	7753	unknown	Primary	12116	2009-01-01 00:00:00
whaling	7753	unknown	Synonym	12117	2009-01-01 00:00:00
Connor	7754	unknown	Primary	12118	2009-01-01 00:00:00
connor	7754	unknown	Synonym	12119	2009-01-01 00:00:00
Orange	7755	unknown	Primary	12120	2009-01-01 00:00:00
orange	7755	unknown	Synonym	12121	2009-01-01 00:00:00
Barry	7756	unknown	Primary	12122	2009-01-01 00:00:00
barry	7756	unknown	Synonym	12123	2009-01-01 00:00:00
Schlining	7757	unknown	Primary	12124	2009-01-01 00:00:00
schlining	7757	unknown	Synonym	12125	2009-01-01 00:00:00
Hunt	7758	unknown	Primary	12126	2009-01-01 00:00:00
hunt	7758	unknown	Synonym	12127	2009-01-01 00:00:00
Paull	7759	unknown	Primary	12128	2009-01-01 00:00:00
paull	7759	unknown	Synonym	12129	2009-01-01 00:00:00
Dawe	7760	unknown	Primary	12130	2009-01-01 00:00:00
dawe	7760	unknown	Synonym	12131	2009-01-01 00:00:00
Greene	7761	unknown	Primary	12132	2009-01-01 00:00:00
greene	7761	unknown	Synonym	12133	2009-01-01 00:00:00
Silver	7762	unknown	Primary	12134	2009-01-01 00:00:00
silver	7762	unknown	Synonym	12135	2009-01-01 00:00:00
McFarlane	7763	unknown	Primary	12136	2009-01-01 00:00:00
mcfarlane	7763	unknown	Synonym	12137	2009-01-01 00:00:00
Jacobsen Stout	7764	unknown	Primary	12138	2009-01-01 00:00:00
jacobsen stout	7764	unknown	Synonym	12139	2009-01-01 00:00:00
Pugh, Phil	7765	\N	Primary	12140	2009-01-01 00:00:00
Haddock	7766	\N	Primary	12141	2009-01-01 00:00:00
Thuesen, Erik	7767	\N	Primary	12142	2009-01-01 00:00:00
Hopcroft, Russ	7768	\N	Primary	12143	2009-01-01 00:00:00
Bush, Stephanie	7769	\N	Primary	12144	2009-01-01 00:00:00
interpretation	7770	unknown	Primary	12145	2009-01-01 00:00:00
wood	7771	unknown	Primary	12146	2009-01-01 00:00:00
sequence	7772	unknown	Primary	12147	2009-01-01 00:00:00
trash	7773	unknown	Primary	12148	2009-01-01 00:00:00
clothing	7774	unknown	Primary	12149	2009-01-01 00:00:00
tire	7775	unknown	Primary	12150	2009-01-01 00:00:00
glass trash	7776	unknown	Primary	12151	2009-01-01 00:00:00
glass-trash	7776	unknown	Synonym	12152	2009-01-01 00:00:00
net	7777	unknown	Primary	12153	2009-01-01 00:00:00
can	7778	unknown	Primary	12154	2009-01-01 00:00:00
container	7779	unknown	Primary	12155	2009-01-01 00:00:00
Macon	7780	\N	Primary	12156	2009-01-01 00:00:00
USS Macon	7780		Synonym	12157	2009-01-01 00:00:00
Sparrowhawk	7781		Primary	12158	2009-01-01 00:00:00
sparrowhawk	7781	\N	Synonym	12159	2009-01-01 00:00:00
sky-hook	7782	\N	Primary	12160	2009-01-01 00:00:00
Maybach Engine	7783		Primary	12161	2009-01-01 00:00:00
maybach-engine	7783	\N	Synonym	12162	2009-01-01 00:00:00
ocean	7784	unknown	Primary	12163	2009-01-01 00:00:00
Pacific	7785	unknown	Primary	12164	2009-01-01 00:00:00
pacific	7785	unknown	Synonym	12165	2009-01-01 00:00:00
Atlantic	7786	unknown	Primary	12166	2009-01-01 00:00:00
atlantic	7786	unknown	Synonym	12167	2009-01-01 00:00:00
Southern	7787	unknown	Primary	12168	2009-01-01 00:00:00
southern	7787	unknown	Synonym	12169	2009-01-01 00:00:00
definition	7788	unknown	Primary	12170	2009-01-01 00:00:00
\.


--
-- Data for Name: expdmergestatus; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY expdmergestatus (videoarchivesetid_fk, mergedate, isnavigationedited, statusmessage, videoframecount, ismerged, datesource) FROM stdin;
\.


--
-- Data for Name: history; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY history (id, conceptdelegateid_fk, processeddtg, creationdtg, description, creatorname, processorname, field, oldvalue, newvalue, action, comment, approved, last_updated_time) FROM stdin;
\.


--
-- Data for Name: linkrealization; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY linkrealization (id, parentlinkrealization, conceptdelegateid_fk, linkname, toconcept, linkvalue, last_updated_time) FROM stdin;
3	3919	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=155799	2009-01-01 00:00:00
4	3921	\N	taxonomy-reference	self	Hayward, P.J.; Ryland, J.S. (Ed.) (1990). The marine fauna of the British Isles and North-West Europe: 1. Introduction and protozoans to arthropods. Clarendon Press: Oxford, UK. ISBN 0-19-857356-1. 627 pp.	2009-01-01 00:00:00
5	3922	\N	dsg-web-reference	self	http://www.marinespecies.org/aphia.php?p=taxdetails&id=152299	2009-01-01 00:00:00
6	3923	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=206807	2009-01-01 00:00:00
7	3925	\N	dsg-literature-reference	self	Winston, Judith E., & Beaulieu, Stace E., 1999.  Striatodoma dorothea (Order Cheilostomatida: Family Tessaradomidae), a new genus and species of bryozoan from deep water off California. Proceedings of the Biological Society of Washington, 112: 313-318.	2009-01-01 00:00:00
8	3942	\N	dsg-web-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=160632	2009-01-01 00:00:00
9	3943	\N	dsg-literature-reference	self	Van Soest, R.W.M. (2001). Porifera, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 85	2009-01-01 00:00:00
10	3943	\N	consulting-taxonomist	self	Henry Reiswig	2009-01-01 00:00:00
11	3943	\N	dsg-web-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=131684	2009-01-01 00:00:00
12	3944	\N	dsg-web-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=132096	2009-01-01 00:00:00
13	3944	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
14	3944	\N	consulting-taxonomist	self	Stace Beaulieu/Henry Reiswig	2009-01-01 00:00:00
15	3944	\N	dsg-description	self	spicule column is like a twisted rope	2009-01-01 00:00:00
16	3944	\N	taxonomy-reference	self	Van Soest, R.W.M. (2001). Porifera, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 85	2009-01-01 00:00:00
17	3945	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
18	3945	\N	dsg-description	self	single stalked spicule column (twisted), typically with epizoanthids growing on them	2009-01-01 00:00:00
19	3945	\N	consulting-taxonomist	self	Stace Beaulieu/Henry Reiswig	2009-01-01 00:00:00
20	3946	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
21	3946	\N	taxonomy-reference	self	Hooper, J.N.A.; Van Soest, R.W.M. (Ed.) (2002). Systema Porifera: a guide to the classification of Sponges. Kluwer Academic/Plenum Publishers: New York, NY (USA). ISBN 0-306-47260-0. xix, 1-1101, 1103-1706 (2 volumes) pp.	2009-01-01 00:00:00
22	3946	\N	dsg-web-reference	self	http://www.marinespecies.org/aphia.php?p=taxdetails&id=171508	2009-01-01 00:00:00
23	3946	\N	dsg-description	self	looks like Hyalonema sp. A, except that the top is more fluted and flower petal-like, typically with epizoanthids growing on them	2009-01-01 00:00:00
24	3947	\N	taxonomy-reference	self	Van Soest, R.W.M. (2001). Porifera, in: Costello, M.J. et al. (Ed.) (2001). European register of marine species: a check-list of the marine species in Europe and a bibliography of guides to their identification. Collection Patrimoines Naturels, 50: pp. 85	2009-01-01 00:00:00
25	3957	\N	dsg-description	self	beige-white, many oscula, spicules underneath point straight down	2009-01-01 00:00:00
26	3957	\N	consulting-taxonomist	self	Henry Reiswig, University of Victoria, BC	2009-01-01 00:00:00
27	3957	\N	relative-shape	self	flat	2009-01-01 00:00:00
28	3958	\N	taxonomy-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=131694	2009-01-01 00:00:00
29	3961	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=659234	2009-01-01 00:00:00
30	3965	\N	consulting-taxonomist	self	Henry Reiswig, University of Victoria, BC	2009-01-01 00:00:00
31	3965	\N	relative-shape	self	flat	2009-01-01 00:00:00
32	3965	\N	dsg-description	self	blue-white, few oscula, spicules underneath point outward (fringe)	2009-01-01 00:00:00
33	3966	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
34	3966	\N	dsg-description	self	epizoic; attaches to the dead stalks of Hyalonema spp.	2009-01-01 00:00:00
35	3966	\N	consulting-taxonomist	self	Stace Beaulieu/Henry Reiswig	2009-01-01 00:00:00
36	3966	\N	taxonomy-reference	self	Hooper, J.N.A.; Van Soest, R.W.M. (Ed.) (2002). Systema Porifera: a guide to the classification of Sponges. Kluwer Academic/Plenum Publishers: New York, NY (USA). ISBN 0-306-47260-0. xix, 1-1101, 1103-1706 (2 volumes) pp.	2009-01-01 00:00:00
37	3966	\N	dsg-web-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=172033	2009-01-01 00:00:00
38	3967	\N	dsg-description	self	large, bucket-shaped; long vertical spicule fringe at base	2009-01-01 00:00:00
39	3967	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
40	3967	\N	consulting-taxonomist	self	Henry Reiswig	2009-01-01 00:00:00
41	3978	\N	taxonomy-reference	self	Hooper, J.N.A.; Van Soest, R.W.M. (Ed.) (2002). Systema Porifera: a guide to the classification of Sponges. Kluwer Academic/Plenum Publishers: New York, NY (USA). ISBN 0-306-47260-0. xix, 1-1101, 1103-1706 (2 volumes) pp.	2009-01-01 00:00:00
42	3985	\N	dsg-description	self	multiple stalks of non-twisted spicule columns, pointed	2009-01-01 00:00:00
43	3986	\N	dsg-description	self	multiple stalks of non-twisted spicule columns, ball-shaped	2009-01-01 00:00:00
44	3987	\N	taxonomy-former-or-unaccepted-name	self	Sclerospongiae	2009-01-01 00:00:00
45	3987	\N	dsg-web-reference	self	http://www.marinespecies.org/porifera/porifera.php?p=taxdetails&id=164811	2009-01-01 00:00:00
46	3989	\N	taxonomy-reference	self	Hooper, J.N.A.; Van Soest, R.W.M. (Ed.) (2002). Systema Porifera: a guide to the classification of Sponges. Kluwer Academic/Plenum Publishers: New York, NY (USA). ISBN 0-306-47260-0. xix, 1-1101, 1103-1706 (2 volumes) pp. (look up in IMIS)	2009-01-01 00:00:00
47	3997	\N	taxonomy-reference	self	Hajdu, E.; Vacelet, J. 2002. Family Cladorhizidae Dendy, 1922. Pp. 636-641. In Hooper, J. N. A. & Van Soest, R. W. M. (ed.) Systema Porifera. A guide to the classification of sponges. 1 (Kluwer Academic/ Plenum Publishers: New York, Boston, Dordrecht, Lon	2009-01-01 00:00:00
48	4017	\N	taxonomy-former-or-unaccepted-name	self	Leucosoleniida	2009-01-01 00:00:00
49	4023	\N	dsg-description	self	frond, leaf-like sponge	2009-01-01 00:00:00
50	4075	\N	dsg-description	self	A golden, green-colored Tromikosoma sp. with white triangles on the ends of the spines vs. purple ones which are T. panamense.	2009-01-01 00:00:00
51	4098	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
52	4099	\N	dsg-web-reference	self	http://www.marbef.org/data/aphia.php?p=taxdetails&id=124752	2009-01-01 00:00:00
53	4099	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
54	4111	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
55	4111	\N	consulting-taxonomist	self	January 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
56	4112	\N	dsg-web-reference	self	http://www.marbef.org/data/aphia.php?p=taxdetails&id=123193	2009-01-01 00:00:00
57	4112	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian	2009-01-01 00:00:00
58	4113	\N	dsg-web-reference	self	http://www.marbef.org/data/aphia.php?p=taxdetails&id=123526	2009-01-01 00:00:00
59	4113	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian	2009-01-01 00:00:00
60	4124	\N	dsg-web-reference	self	http://www.marbef.org/data/aphia.php?p=taxdetails&id=123464	2009-01-01 00:00:00
61	4124	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
62	4125	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=158363	2009-01-01 00:00:00
63	4125	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
64	4126	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
65	4126	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=158366	2009-01-01 00:00:00
66	4127	\N	consulting-taxonomist	self	July 2007 David Pawson, Smithsonian Natural History Museum 	2009-01-01 00:00:00
67	4127	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=158372	2009-01-01 00:00:00
68	4171	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
69	4171	\N	dsg-description	self	this is a placeholder name only- all annotations look morphologically similar to each other, but may be a different genus	2009-01-01 00:00:00
70	4172	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
71	4172	\N	dsg-literature-reference	self	Royal British Columbia Museum - Sea Stars of British Columbia, Southeast Alaska and Puget Sound - Philip Lambert 2000	2009-01-01 00:00:00
72	4172	\N	dsg-description	self	this is a placeholder name only- all annotations look morphologically similar to each other, but may be a different genus	2009-01-01 00:00:00
73	4174	\N	consulting-taxonomist	self	Chris Mah	2009-01-01 00:00:00
74	4185	\N	dsg-literature-reference	self	Blake, James A. Taxonomic atlas of the benthic Fauna of the Santa Maria Basin and Western Santa Barbara Channel Volume 14. 305pp.	2009-01-01 00:00:00
75	4208	\N	dsg-depth-distribution	self	256-2904 m	2009-01-01 00:00:00
76	4268	\N	consulting-taxonomist	self	Christopher Mah, March 2008	2009-01-01 00:00:00
77	4268	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
78	4418	\N	consulting-taxonomist	self	Robert Lea	2009-01-01 00:00:00
79	4418	\N	dsg-literature-reference	self	Cohen, Daniel M., Tadashi Inada, Tomio Iwamoto, and Nadia Scialabba , 1990.     Gadiform Fishes of the World (Order Gadiformes): An Annotated and Illustrated Catalogue of Cods, Hakes, Grenadiers and other Gadiform Fishes Known to Date. FAO Fisheries Synop	2009-01-01 00:00:00
80	4418	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
81	4438	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
82	4438	\N	consulting-taxonomist	self	Jeff Drazen	2009-01-01 00:00:00
83	4442	\N	dsg-description	self	may not be distinguishable from C. armatus on video	2009-01-01 00:00:00
84	4442	\N	consulting-taxonomist	self	Jeff Drazen	2009-01-01 00:00:00
85	4443	\N	dsg-description	self	may not be distinguishable from C. yaquinae on video	2009-01-01 00:00:00
86	4443	\N	consulting-taxonomist	self	Jeff Drazen	2009-01-01 00:00:00
87	4444	\N	dsg-description	self	These two species cannot be reliably distinguished from each other on video.	2009-01-01 00:00:00
88	4444	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
89	4444	\N	consulting-taxonomist	self	Jeff Drazen, University of Hawaii	2009-01-01 00:00:00
90	4507	\N	consulting-taxonomist	self	Dan Cohen	2009-01-01 00:00:00
91	4507	\N	dsg-range	self	Gulf Of California	2009-01-01 00:00:00
92	4688	\N	taxonomy-reference	self	http://www.fishbase.org/Summary/FamilySummary.cfm?id=560	2009-01-01 00:00:00
93	4690	\N	dsg-range	self	Hawaii	2009-01-01 00:00:00
94	4690	\N	taxonomy-reference	self	http://www.fishbase.org/Summary/speciesSummary.php?ID=9136&genusname=Bathypterois&speciesname=grallator	2009-01-01 00:00:00
95	4691	\N	dsg-range	self	Hawaii	2009-01-01 00:00:00
96	4918	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
97	4920	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
98	4920	\N	dsg-description	self	note that this species and the Slender Sole (Lyopsetta exilis) will look very similar on video	2009-01-01 00:00:00
99	4936	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
100	4938	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
101	4939	\N	dsg-literature-reference	self	Nelson et al. 2004, Common and scientific names of fishes of the United States, Mexico, and Canada	2009-01-01 00:00:00
102	4939	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
103	4941	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
104	4941	\N	dsg-description	self	note that this species and the Rex Sole (Glyptocephalus zacharis) will look very similar on video	2009-01-01 00:00:00
105	4941	\N	nil	nil	nil	2009-01-01 00:00:00
106	4950	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
107	4950	\N	nil	nil	nil	2009-01-01 00:00:00
108	4956	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
109	4956	\N	nil	nil	nil	2009-01-01 00:00:00
110	5028	\N	dsg-literature-reference	self	nil	2009-01-01 00:00:00
111	5087	\N	dsg-spatial-distribution	self	Gulf of Alaska to central Baja	2009-01-01 00:00:00
112	5087	\N	dsg-literature-reference	self	Love, M.S., Yoklavich, M., and Thorsteinson, L. 2002. The rockfishes of the northeast Pacific. University of\nCalifornia Press, Berkeley, Los Angeles, London.	2009-01-01 00:00:00
113	5087	\N	dsg-description	self	no defined bars or stripes, large eyes, concave forehead, commonly sit on the seafloor with the tail tucked beside the body.  Split nose rarely visible. 	2009-01-01 00:00:00
114	5087	\N	surface-color	self	red	2009-01-01 00:00:00
115	5087	\N	dsg-habitat	self	soft sediment	2009-01-01 00:00:00
116	5087	\N	dsg-commercial-use	self	active trawl fishery Washington to central California	2009-01-01 00:00:00
117	5087	\N	surface-color	self	white	2009-01-01 00:00:00
118	5087	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=166716	2009-01-01 00:00:00
119	5087	\N	dsg-depth-distribution	self	91-795 m	2009-01-01 00:00:00
120	5087	\N	dsg-reproduction	self	juveniles are pelagic	2009-01-01 00:00:00
121	5087	\N	dsg-size	self	to 46 cm (18.4 in)	2009-01-01 00:00:00
122	5087	\N	dsg-anecdote	self	Can live at to at least 86 years old.	2009-01-01 00:00:00
123	5093	\N	dsg-description	self	large fish- can look much different that picutres in Love et. al	2009-01-01 00:00:00
124	5108	\N	dsg-literature-reference	self	Orr, J. and S. Hawkins. 2006. Systematics of Sebastes aleutianus: morphological evidence for the resurrection of Sebastes melanostictus. In 14th Western Groundfish Conference, Newport, OR, January 30 – February 3, 2006.	2009-01-01 00:00:00
125	5108	\N	dsg-description	self	Jay Orr and others found the Rougheye in Alaska to be complex and that there were two genetically distinct types (going under the name of aleutianus).  The second type was determined to be Seb. melanostictus, Blackspotted Rockfish.  The two species are co	2009-01-01 00:00:00
126	5140	\N	dsg-description	self	These two species cannot be reliably distinguished from each other on video. 	2009-01-01 00:00:00
127	5366	\N	dsg-size	self	to 50 cm	2009-01-01 00:00:00
128	5366	\N	dsg-web-reference	self	http://www.fishbase.org/Summary/speciesSummary.php?ID=784&genusname=Apristurus&speciesname=spongiceps	2009-01-01 00:00:00
129	5366	\N	dsg-spatial-distribution	self	rare	2009-01-01 00:00:00
130	5366	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=159997	2009-01-01 00:00:00
131	5366	\N	nil	nil	nil	2009-01-01 00:00:00
132	5366	\N	dsg-depth-distribution	self	572-1482 m	2009-01-01 00:00:00
133	5366	\N	dsg-range	self	Hawaii and south Pacific	2009-01-01 00:00:00
134	5400	\N	consulting-taxonomist	self	David Ebert	2009-01-01 00:00:00
135	5401	\N	consulting-taxonomist	self	David Ebert	2009-01-01 00:00:00
136	5406	\N	taxonomy-former-name	self	Raja abyssicola	2009-01-01 00:00:00
137	5408	\N	taxonomy-former-name	self	Raja kincaidii	2009-01-01 00:00:00
138	5410	\N	consulting-taxonomist	self	David Ebert, Moss Landing Marine Laboratories 	2009-01-01 00:00:00
139	5410	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
140	5411	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
141	5411	\N	consulting-taxonomist	self	David Ebert, Moss Landing Marine Laboratories	2009-01-01 00:00:00
142	5412	\N	consulting-taxonomist	self	David Ebert, Moss Landing Marine Laboratories 	2009-01-01 00:00:00
143	5412	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
144	5413	\N	consulting-taxonomist	self	David Ebert, Moss Landing Marine Laboratories 	2009-01-01 00:00:00
145	5413	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
146	5444	\N	dsg-description	self	Salp chain often seen tightly coiled like an `ammo belt` (as per L. Madin)	2009-01-01 00:00:00
147	5590	\N	dsg-literature-reference	self	Molecular phylogeny of the East Pacific squat lobsters of the genus Munidopsis (Decapoda: Galatheidae) with the descriptions of seven new species. Jones, WJoe Macpherson, Enrique. Journal of crustacean biology [J. Crust. Biol.]. Vol. 27, no. 3, pp. 477-50	2009-01-01 00:00:00
148	5590	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
149	5590	\N	dsg-description	self	Multiple species of Munidopsis have been identified along the Pacific coast; these may not be distinguishable on video	2009-01-01 00:00:00
150	5603	\N	dsg-range	self	Unalaska, Alaska to San Diego, California	2009-01-01 00:00:00
151	5603	\N	dsg-literature-reference	self	Butler, T.H. 1964. Growth, reproduction and distribution of Pandalid shrimp in British Columbia. J.Fish.Res.Bd.Canada. 21(6):1403–1452. 	2009-01-01 00:00:00
152	5603	\N	dsg-size	self	30 cm maximum total length	2009-01-01 00:00:00
153	5603	\N	dsg-reproduction	self	Off the coast of central California the majority of gravid females are found September through March	2009-01-01 00:00:00
154	5603	\N	dsg-literature-reference	self	Schlining, K.L. 1999. The spot prawn (Pandalus platyceros Brandt 1851) resource in Carmel Submarine Canyon, California: Aspects of fisheries and habitat associations. M.S. Thesis, California State University, Stanislaus.	2009-01-01 00:00:00
155	5603	\N	dsg-literature-reference	self	Butler, T.H. 1970. Synopsis of biological data on the prawn Pandalus platyceros Brandt, 1851. FAO Fish. Synopsis 95:1289–1315. 	2009-01-01 00:00:00
156	5603	\N	dsg-depth-distribution	self	4 to 487 m	2009-01-01 00:00:00
157	5688	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
158	5688	\N	consulting-taxonomist	self	Karen Osborn	2009-01-01 00:00:00
159	5688	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=546230	2009-01-01 00:00:00
160	5779	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52666	2009-01-01 00:00:00
161	5779	\N	dsg-web-reference	self	http://hercules.kgs.ku.edu/hexacoral/dev/supraspecific_detail.cfm?genusname=Actinauge	2009-01-01 00:00:00
162	5780	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=611644	2009-01-01 00:00:00
163	5780	\N	taxonomy-reference	self	See image of identified organisim in Beaulieu, SE, 2001 Life on glass houses: sponge stalk communities in the deep sea, Marine Biology 138:803-817	2009-01-01 00:00:00
164	5802	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52807	2009-01-01 00:00:00
165	5803	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=611372	2009-01-01 00:00:00
166	5804	\N	comment	self	previsously ID'd from Station M samples per Henry Ruhl	2009-01-01 00:00:00
167	5804	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
168	5835	\N	consulting-taxonomist	self	Timothy D. Swain  Department of Biological Science, Florida State University  	2009-01-01 00:00:00
169	5835	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
170	5835	\N	taxonomy-reference	self	Beaulieu, S E, 2001 Life on glass houses; sponge stalk communities in the deep sea, Marine Biology, 138:803-817	2009-01-01 00:00:00
171	5861	\N	dsg-description	self	Multibranced. Branches, large, fluffy and thick. Color is usually white to pink, looking more whte when polyps are withdrawn; occasionally reddish, possibly in deep living individuals. Branches may have bulbous ends.	2009-01-01 00:00:00
172	5880	\N	dsg-description	self	Densely branched. Branches thin, delicate. Color rusty red.	2009-01-01 00:00:00
173	5883	\N	dsg-description	self	Large and shaggy appearance. Branches moderate thickness. Color creamy with brown-yellow, sometimes orange hue. Long tendrils of unknown function found at base of stalk. Polyps contract and expand, but do not withdraw completely.	2009-01-01 00:00:00
174	5885	\N	taxonomy-reference	self	Grigg, R.W. 1974. Distribution and abundance of precious corals in Hawaii. Proceedings of the Second International Symposium on Coral Reefs. Vol.2.	2009-01-01 00:00:00
175	5885	\N	taxonomy-reference	self	Grasshoff, M. 1981.(Deep-water Gorgonaria, Pennatularia and Antipatharia of Biscay Bay. Results of French expeditions Biogas, Polygas, Geomanche, Incal, Noratlante, and cruises of Thalassa . 2. Taxonomic studies.). Bulletin du Museum national d'Histoire n	2009-01-01 00:00:00
176	5908	\N	consulting-taxonomist	self	July 2007 Emily Dolan, DEEPSEAS group, National Oceanographic Centre, Southampton	2009-01-01 00:00:00
177	5909	\N	consulting-taxonomist	self	July 2007 Emily Dolan, DEEPSEAS group, National Oceanographic Centre, Southampton	2009-01-01 00:00:00
178	5911	\N	dsg-depth-distribution	self	under 800 m (but indistinguishable from Funicula between 600-800 m)	2009-01-01 00:00:00
179	5912	\N	dsg-depth-distribution	self	under 800 m (but indistinguishable from Funicula between 600-800 m)	2009-01-01 00:00:00
180	5926	\N	consulting-taxonomist	self	July 2007 Emily Dolan, DEEPSEAS group, National Oceanographic Centre, Southampton	2009-01-01 00:00:00
181	5928	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52360	2009-01-01 00:00:00
182	5929	\N	consulting-taxonomist	self	July 2007 Emily Dolan, DEEPSEAS group, National Oceanographic Centre, Southampton	2009-01-01 00:00:00
183	5929	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52360	2009-01-01 00:00:00
184	5930	\N	consulting-taxonomist	self	July 2007 Emily Dolan, DEEPSEAS group, National Oceanographic Centre, Southampton	2009-01-01 00:00:00
185	5935	\N	dsg-depth-distribution	self	over 800 m	2009-01-01 00:00:00
186	5935	\N	taxonomy-reference	self	Gary Williams, California Academy of Sciences	2009-01-01 00:00:00
187	5935	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=52367	2009-01-01 00:00:00
188	5938	\N	consulting-taxonomist	self	Gary Williams, California Academy of Sciences, 2008	2009-01-01 00:00:00
189	5938	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
190	5938	\N	dsg-depth-distribution	self	601 - 800 m	2009-01-01 00:00:00
191	5938	\N	dsg-description	self	Funiculina and Halipteris look the same on video and have overlapping depth ranges	2009-01-01 00:00:00
192	6074	\N	dsg-description	self	includes otherwise unidentifiable "little red jellies" in the genera Benthocodon, Voragonema, and Crossota	2009-01-01 00:00:00
193	6170	\N	consulting-taxonomist	self	Phil Pugh	2009-01-01 00:00:00
194	6270	\N	taxonomy-former-or-unaccepted-name	self	Moseria	2009-01-01 00:00:00
195	6442	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
196	6442	\N	consulting-taxonomist	self	Leslie Harris	2009-01-01 00:00:00
197	6449	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
198	6449	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=66242	2009-01-01 00:00:00
199	6449	\N	consulting-taxonomist	self	Station M samples (PULSE)	2009-01-01 00:00:00
200	6465	\N	taxonomy-reference	self	Greg Rouse	2009-01-01 00:00:00
201	6465	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=68091	2009-01-01 00:00:00
202	6465	\N	dsg-habitat	self	muddy seafloor	2009-01-01 00:00:00
203	6465	\N	dsg-literature-reference	self	ID'd by taxonomist Greg Rouse	2009-01-01 00:00:00
204	6468	\N	dsg-habitat	self	These worms are found in the cold seep and hydrothermal vent communities around the world.	2009-01-01 00:00:00
205	6468	\N	taxonomy-reference	self	Barry, J.P., H.G. Greene, D.L. Orange, C.H. Baxter, B.H. Robison, R.E. Kochevar, J.W. Nybakken, D.L. Reed, and C.M. McHugh. 1996. Biologic and geologic characteristics of cold seeps in Monterey Bay, California.	2009-01-01 00:00:00
206	6468	\N	dsg-anecdote	self	n Monterey Bay, a few individuals of vestimentiferan worms (Lamellibrachia sp.) have been found at Clam Field site at a depth around 900 m (Barry et al. 1996). One individual vestimentiferan worm, located on a rock covered with bacteria and adjacent to a 	2009-01-01 00:00:00
207	6468	\N	dsg-description	self	They contain chemosynthetic bacterial symbionts within their bodies that convert energy from the sulphide- and methane-rich waters, supplying nutrition to the host worm.	2009-01-01 00:00:00
208	6491	\N	dsg-description	self	exhibits a combination of larval and adult characteristics	2009-01-01 00:00:00
209	6491	\N	dsg-literature-reference	self	Osborn, K.J., G.R. Rouse, S.K. Goffredi, & B.H. Robison. 2007. Description and relationships of an unusual pelagic polychaete Chaetopterus pugaporcinus (Annelida, Chaetopteridae). The Biological Bulletin. 212: 43-59.	2009-01-01 00:00:00
210	6491	\N	dsg-habitat	self	adults in this family are typically benthic or tubiculous	2009-01-01 00:00:00
211	6491	\N	dsg-size	self	10 to 21 mm total length	2009-01-01 00:00:00
212	6491	\N	dsg-anecdote	self	may possibly be feeding on sinking marine "snow" particles caught in mucous web	2009-01-01 00:00:00
213	6491	\N	dsg-depth-distribution	self	875 to 1221 m in Monterey Bay	2009-01-01 00:00:00
214	6491	\N	dsg-habitat	self	mesopelagic	2009-01-01 00:00:00
215	6491	\N	nil	nil	nil	2009-01-01 00:00:00
216	6491	\N	nil	nil	nil	2009-01-01 00:00:00
217	6491	\N	dsg-description	self	capable of producing blue and green bioluminescence	2009-01-01 00:00:00
218	6631	\N	consulting-taxonomist	self	Angel Valdez	2009-01-01 00:00:00
219	6631	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
220	6665	\N	taxonomy-reference	self	Bouchet, P. & Rocroi J-P (2005) Classification and Nomenclator of Gastropod Families. Malacologia 47(1-2) 1-397.	2009-01-01 00:00:00
221	6676	\N	consulting-taxonomist	self	Jim MClean	2009-01-01 00:00:00
222	6676	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
223	6676	\N	dsg-description	self	Undescribed species.  See L. Kuhnz.  Often covered in zoanthids.	2009-01-01 00:00:00
224	6677	\N	dsg-description	self	These two genera cannot be reliably distinguished from each other on video.	2009-01-01 00:00:00
225	6677	\N	consulting-taxonomist	self	Anders Waren	2009-01-01 00:00:00
226	6755	\N	dsg-literature-reference	self	Nesis, K. 1982	2009-01-01 00:00:00
227	6756	\N	dsg-range	self	occur in all oceans of the world	2009-01-01 00:00:00
228	6756	\N	dsg-web-reference	self	http://tolweb.org/Octopodidae/20194	2009-01-01 00:00:00
229	6756	\N	dsg-web-reference	self	http://www.cephbase.utmb.edu/	2009-01-01 00:00:00
230	6756	\N	dsg-description	self	G. boreopacifica and G. pacifica may be two different species	2009-01-01 00:00:00
231	6756	\N	dsg-locomotion	self	primarily move by crawling over the substrate.  Also capable of swimming via jet propulsion and/or pumping the arms and flared webs	2009-01-01 00:00:00
232	6756	\N	dsg-habitat	self	found in habitats ranging from intertidal reefs to the deep sea	2009-01-01 00:00:00
233	6756	\N	dsg-description	self	one sucker row, skin tuberculate (warty) or granular; funnel may be visible	2009-01-01 00:00:00
234	6756	\N	consulting-taxonomist	self	Janet Voight	2009-01-01 00:00:00
235	6756	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
236	6756	\N	dsg-literature-reference	self	Nesis, K. 1982	2009-01-01 00:00:00
237	6763	\N	dsg-web-reference	self	http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&search_value=557227	2009-01-01 00:00:00
238	6763	\N	dsg-web-reference	self	http://www.cephdev.utmb.edu/spdb/speciesc.cfm?CephID=524	2009-01-01 00:00:00
239	6763	\N	dsg-literature-reference	self	Ecological studies of Octopus dofleini (Wueller) on the west coast of British Columbia. Hartwick, B. Journal of Shellfish Research. Vol. 4, no. 1, pp. 91. 1984.	2009-01-01 00:00:00
240	6763	\N	consulting-taxonomist	self	Janet Voight	2009-01-01 00:00:00
241	6763	\N	dsg-literature-reference	self	Distribution and abundance of the early life stages of octopus, Octopus dofleini Wuelker, 1910 in the North Pacific. Kubodera, T. Bulletin of Marine Science. Vol. 49, no. 1-2, pp. 235-243. 1991.	2009-01-01 00:00:00
242	6763	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
243	6763	\N	dsg-literature-reference	self	Some aspects of diet and foraging behavior of Octopus dofleini (Wuelker, 1910) in its northernmost range. Vincent, TLS; Scheel, D; Hough, KR. Marine Ecology [Mar. Ecol.]. Vol. 19, no. 1, pp. 13-29. 1998.	2009-01-01 00:00:00
244	6767	\N	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
245	6767	\N	dsg-description	self	Funnel may not be visible, medium to short arms, smooth skin, larger eyes than B. robustus,  pinkish-tan, web and arms darker	2009-01-01 00:00:00
246	6769	\N	dsg-description	self	two sucker rows, funnel may be visible, medium to short arms, smooth skin, small eyes; eyes do not protrude, pale pinkish	2009-01-01 00:00:00
247	6769	\N	nil	nil	nil	2009-01-01 00:00:00
248	6769	\N	consulting-taxonomist	self	Janet Voight	2009-01-01 00:00:00
249	6769	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
250	6769	\N	dsg-description	self	very likely B. robustus per J. Voight; see Voss and Pearcy, 1990	2009-01-01 00:00:00
251	6770	\N	consulting-taxonomist	self	Janet Voight	2009-01-01 00:00:00
252	6782	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
253	6785	\N	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
254	6787	\N	consulting-taxonomist	self	Eric Hochberg, Santa Barbara Museum of Natural History	2009-01-01 00:00:00
255	6787	\N	dsg-description	self	Most species of Grimpoteuthis are poorly known. They are somewhat less compressed in the anterior-posterior axis than are members of Opisthoteuthis and they generally have relatively larger fins. Species are closely associated with the deep-ocean floor an	2009-01-01 00:00:00
256	6787	\N	dsg-range	self	cosmopolitan	2009-01-01 00:00:00
257	6787	\N	dsg-web-reference	self	http://tolweb.org/Grimpoteuthis	2009-01-01 00:00:00
258	6787	\N	dsg-description	self	our species has been identified to genus.  It may be a new species.	2009-01-01 00:00:00
259	6787	\N	dsg-literature-reference	self	Robson, 1932	2009-01-01 00:00:00
260	6787	\N	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
261	6787	\N	dsg-locomotion	self	Grimpoteuthis are often seen sitting on the ocean floor and swimming with its fins just above the ocean floor. Some species are very delicate and may be entirely benthopelagic.	2009-01-01 00:00:00
262	6787	\N	dsg-habitat	self	Species appear to be associated with the deep ocean floor in all oceans of the world.	2009-01-01 00:00:00
263	6791	\N	surface-color	self	red	2009-01-01 00:00:00
264	6824	\N	dsg-web-reference	self	http://www.tolweb.org/Gonatus_berryi/19773	2009-01-01 00:00:00
265	6868	\N	taxonomy-reference	self	http://www.tolweb.org/Mastigoteuthidae/19453	2009-01-01 00:00:00
266	7494	\N	comment	self	Temperature, pressure, conductivity sensor.	2009-01-01 00:00:00
\.


--
-- Data for Name: linktemplate; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY linktemplate (id, conceptdelegateid_fk, linkname, toconcept, linkvalue, last_updated_time) FROM stdin;
869	7370	relative-placement	self	anal	2009-01-01 00:00:00
870	7370	relative-placement	self	lateral	2009-01-01 00:00:00
871	7370	relative-placement	self	right	2009-01-01 00:00:00
872	7370	relative-placement	self	pectoral	2009-01-01 00:00:00
873	7374	relative-shape	self	rope	2009-01-01 00:00:00
874	7374	relative-shape	self	cloud	2009-01-01 00:00:00
875	7374	relative-shape	self	pseudomorph	2009-01-01 00:00:00
876	7491	calibrated	self	0	2009-01-01 00:00:00
877	7491	state	self	off	2009-01-01 00:00:00
878	7491	state	self	on	2009-01-01 00:00:00
879	7491	retrieved	equipment	nil	2009-01-01 00:00:00
880	7534	recorded-knots	self	0	2009-01-01 00:00:00
881	7534	recorded-x-vessel-reference-point	self	0	2009-01-01 00:00:00
882	7534	recorded-latitude	self	0	2009-01-01 00:00:00
883	7534	recorded-relative-wind-speed	self	0	2009-01-01 00:00:00
884	7534	recorded-course-made-good	self	0	2009-01-01 00:00:00
885	7534	recorded-longitude	self	0	2009-01-01 00:00:00
886	7534	recorded-y-vessel-reference-point	self	0	2009-01-01 00:00:00
887	7534	recorded-relative-wind-direction	self	0	2009-01-01 00:00:00
888	7534	recorded-device	self	0	2009-01-01 00:00:00
889	7534	recorded-speed-made-good	self	0	2009-01-01 00:00:00
890	7534	recorded-gyro	self	0	2009-01-01 00:00:00
891	7580	observed-contact	self	0	2009-01-01 00:00:00
892	7618	direction	self	endtransect	2009-01-01 00:00:00
893	7618	direction-status	self	abort	2009-01-01 00:00:00
894	7618	direction	self	stationary	2009-01-01 00:00:00
895	7618	direction	self	starttransect	2009-01-01 00:00:00
896	7618	direction	self	cruise	2009-01-01 00:00:00
897	7618	direction	self	ascend	2009-01-01 00:00:00
898	7618	direction	self	launch	2009-01-01 00:00:00
899	7618	direction	self	descend	2009-01-01 00:00:00
900	7618	direction-status	self	resume	2009-01-01 00:00:00
901	7618	direction	self	transect	2009-01-01 00:00:00
902	7619	recorded-buoy-frequency	self	0	2009-01-01 00:00:00
903	7619	recorded-pinger-z	self	0	2009-01-01 00:00:00
904	7619	recorded-salinity	self	0	2009-01-01 00:00:00
905	7619	recorded-x-vessel-reference-point	self	0	2009-01-01 00:00:00
906	7619	recorded-longitude	self	0	2009-01-01 00:00:00
907	7619	recorded-y-vessel-reference-point	self	0	2009-01-01 00:00:00
908	7619	recorded-sound-speed	self	0	2009-01-01 00:00:00
909	7619	recorded-depth	self	0	2009-01-01 00:00:00
910	7619	recorded-eastings	self	0	2009-01-01 00:00:00
911	7619	retrieved-equipment	self	nil	2009-01-01 00:00:00
912	7619	recorded-irradiance-4pi	self	0	2009-01-01 00:00:00
913	7619	recorded-latitude	self	0	2009-01-01 00:00:00
914	7619	recorded-northings	self	0	2009-01-01 00:00:00
915	7619	recorded-altitude	self	0	2009-01-01 00:00:00
916	7619	recorded-light-transmission	self	0	2009-01-01 00:00:00
470	3734	dsg-literature-reference	self	nil	2009-01-01 00:00:00
471	3734	dsg-glossary-definition	self	nil	2009-01-01 00:00:00
472	3734	dsg-climate	self	nil	2009-01-01 00:00:00
473	3734	media-caption	self	nil	2009-01-01 00:00:00
474	3734	dsg-anecdote	self	nil	2009-01-01 00:00:00
475	3734	dsg-range	self	arctic	2009-01-01 00:00:00
476	3734	naming-history	self	nil	2009-01-01 00:00:00
477	3734	dsg-web-reference	self	nil	2009-01-01 00:00:00
478	3734	media-icon	self	nil	2009-01-01 00:00:00
479	3734	comment	self	nil	2009-01-01 00:00:00
480	3734	dsg-range	self	cosmopolitan	2009-01-01 00:00:00
481	3734	dsg-video-identifiability	self	provisional	2009-01-01 00:00:00
482	3734	dsg-video-identifiability	self	unconfirmed	2009-01-01 00:00:00
483	3734	dsg-spatial-distribution	self	nil	2009-01-01 00:00:00
484	3734	dsg-habitat	self	nil	2009-01-01 00:00:00
485	3734	dsg-range	self	atlantic	2009-01-01 00:00:00
486	3734	dsg-depth-distribution	self	nil	2009-01-01 00:00:00
487	3734	dsg-conservation	self	nil	2009-01-01 00:00:00
488	3734	usage-embargo-specifications	self	nil	2009-01-01 00:00:00
489	3734	dsg-description	self	nil	2009-01-01 00:00:00
490	3734	dsg-size	self	nil	2009-01-01 00:00:00
491	3734	comment	human	nil	2009-01-01 00:00:00
492	3734	dsg-commercial-use	self	nil	2009-01-01 00:00:00
493	3734	dsg-range	self	nil	2009-01-01 00:00:00
494	3734	dsg-range	self	antarctic	2009-01-01 00:00:00
495	3734	video-lab-only-comment	self	nil	2009-01-01 00:00:00
496	3734	dsg-range	self	pacific	2009-01-01 00:00:00
497	3734	media-image	self	nil	2009-01-01 00:00:00
498	3734	media-video	self	nil	2009-01-01 00:00:00
499	3734	dsg-reproduction	self	nil	2009-01-01 00:00:00
500	3734	dsg-video-identifiability	self	certain	2009-01-01 00:00:00
501	3734	usage-embargo-expiration	self	nil	2009-01-01 00:00:00
502	3734	audio-comment	self	nil	2009-01-01 00:00:00
503	3734	media-primary-image	self	nil	2009-01-01 00:00:00
504	3734	dsg-locomotion	self	nil	2009-01-01 00:00:00
505	3823	site	self	crushmore	2009-01-01 00:00:00
506	3823	site	self	mud-volcano	2009-01-01 00:00:00
507	3823	site	self	soquel	2009-01-01 00:00:00
508	3823	rov-dive	ROV	ventana	2009-01-01 00:00:00
509	3823	rov-dive	ship	pt-lobos	2009-01-01 00:00:00
510	3823	dive-type	self	nil	2009-01-01 00:00:00
511	3823	launch-localtime	self	nil	2009-01-01 00:00:00
512	3823	site	self	cliff-base	2009-01-01 00:00:00
513	3823	wetttime	self	nil	2009-01-01 00:00:00
514	3823	site	self	seismo	2009-01-01 00:00:00
515	3823	title	self	nil	2009-01-01 00:00:00
516	3823	site	self	robeys-site	2009-01-01 00:00:00
517	3823	site	self	c4c5	2009-01-01 00:00:00
518	3823	rov-dive	ROV	tiburon	2009-01-01 00:00:00
519	3823	dive-date-julian	self	nil	2009-01-01 00:00:00
520	3823	identifier	self	nil	2009-01-01 00:00:00
521	3823	tape-format	self	beta	2009-01-01 00:00:00
522	3823	type	self	nil	2009-01-01 00:00:00
523	3823	dive-date	self	nil	2009-01-01 00:00:00
524	3823	site	self	nil	2009-01-01 00:00:00
525	3823	site	self	meander	2009-01-01 00:00:00
526	3823	site	self	clamfield-south	2009-01-01 00:00:00
527	3823	chief-scientist	self	nil	2009-01-01 00:00:00
528	3823	dive-number	self	nil	2009-01-01 00:00:00
529	3823	rov-dive-note	self	nil	2009-01-01 00:00:00
530	3823	rov-dive	ship	western-flyer	2009-01-01 00:00:00
531	3823	tape-format	self	vhs	2009-01-01 00:00:00
532	3823	expedition-number	self	nil	2009-01-01 00:00:00
533	3823	recovery-localtime	self	nil	2009-01-01 00:00:00
534	3823	site	self	invert-ridge	2009-01-01 00:00:00
535	3824	lighting	self	no-lights	2009-01-01 00:00:00
536	3824	relative-length	self	medium	2009-01-01 00:00:00
537	3824	sampled-by-certainty	self	maybe	2009-01-01 00:00:00
538	3824	water-quality	self	clear	2009-01-01 00:00:00
539	3824	length-feet	self	0	2009-01-01 00:00:00
540	3824	relative-placement	self	posterior	2009-01-01 00:00:00
541	3824	surface-color	self	bioluminescent	2009-01-01 00:00:00
542	3824	image-quality	self	poor	2009-01-01 00:00:00
543	3824	shape-geometry	self	polygon	2009-01-01 00:00:00
544	3824	surface-pattern	self	mesh	2009-01-01 00:00:00
545	3824	sitting-in	physical object	nil	2009-01-01 00:00:00
546	3824	perspective	self	hidden	2009-01-01 00:00:00
547	3824	population-density	self	moderate	2009-01-01 00:00:00
548	3824	rotating	nil	nil	2009-01-01 00:00:00
549	3824	relative-size	self	medium	2009-01-01 00:00:00
550	3824	shape-geometry	self	tube	2009-01-01 00:00:00
551	3824	life-stage	self	juvenile	2009-01-01 00:00:00
552	3824	deployed-by	equipment	nil	2009-01-01 00:00:00
553	3824	colliding-with	physical object	nil	2009-01-01 00:00:00
554	3824	relative-placement	self	dorsal	2009-01-01 00:00:00
555	3824	identity-uid	self	0	2009-01-01 00:00:00
556	3824	image-quality	self	good	2009-01-01 00:00:00
557	3824	relative-placement	self	proximal	2009-01-01 00:00:00
558	3824	shape-geometry	self	oval	2009-01-01 00:00:00
559	3824	shape-geometry	self	mat	2009-01-01 00:00:00
560	3824	surface-texture	self	hummocky	2009-01-01 00:00:00
561	3824	surface-pattern	self	mottled	2009-01-01 00:00:00
562	3824	lighting	self	over-exposed	2009-01-01 00:00:00
563	3824	contacts	physical object	nil	2009-01-01 00:00:00
564	3824	sampled-by	equipment	nil	2009-01-01 00:00:00
565	3824	turning-around	nil	nil	2009-01-01 00:00:00
566	3824	life-stage	self	decomposed	2009-01-01 00:00:00
567	3824	surface-texture	self	fine	2009-01-01 00:00:00
568	3824	broken	nil	nil	2009-01-01 00:00:00
569	3824	relative-placement	self	shallow	2009-01-01 00:00:00
570	3824	holding	physical object	nil	2009-01-01 00:00:00
571	3824	age-seconds	self	0	2009-01-01 00:00:00
572	3824	age-months	self	0	2009-01-01 00:00:00
573	3824	fail	nil	nil	2009-01-01 00:00:00
574	3824	display-mode	self	auxiliary-camera	2009-01-01 00:00:00
575	3824	relative-placement	self	axis	2009-01-01 00:00:00
576	3824	identity-certainty	self	maybe	2009-01-01 00:00:00
577	3824	relative-shape	self	pointed	2009-01-01 00:00:00
578	3824	posture	self	oblique	2009-01-01 00:00:00
579	3824	surface-color	self	red	2009-01-01 00:00:00
580	3824	shape-arrangement	self	jumbled	2009-01-01 00:00:00
581	3824	shape-geometry	self	angular	2009-01-01 00:00:00
582	3824	pitted	nil	nil	2009-01-01 00:00:00
583	3824	shape-arrangement	self	bedded	2009-01-01 00:00:00
584	3824	surface-pattern	self	spotted	2009-01-01 00:00:00
585	3824	shape-geometry	self	bowl	2009-01-01 00:00:00
586	3824	length-centimeters	self	0	2009-01-01 00:00:00
587	3824	relative-placement	self	left	2009-01-01 00:00:00
588	3824	age-years	self	0	2009-01-01 00:00:00
589	3824	life-stage	self	young	2009-01-01 00:00:00
590	3824	surface-pattern	self	layered	2009-01-01 00:00:00
591	3824	surface-texture	self	coarse	2009-01-01 00:00:00
592	3824	relative-shape	self	rounded	2009-01-01 00:00:00
593	3824	perspective	self	close-up	2009-01-01 00:00:00
594	3824	surface-color	self	dark	2009-01-01 00:00:00
595	3824	posture	self	erect	2009-01-01 00:00:00
596	3824	relative-placement	self	encrusting	2009-01-01 00:00:00
597	3824	diving	nil	nil	2009-01-01 00:00:00
598	3824	trying	nil	nil	2009-01-01 00:00:00
599	3824	life-stage	self	dying	2009-01-01 00:00:00
600	3824	relative-placement	self	middle	2009-01-01 00:00:00
601	3824	lying-atop	physical object	nil	2009-01-01 00:00:00
602	3824	relative-placement	self	parallel	2009-01-01 00:00:00
603	3824	surface-texture	self	granular	2009-01-01 00:00:00
604	3824	life-stage	self	larval	2009-01-01 00:00:00
605	3824	relative-size	self	large	2009-01-01 00:00:00
606	3824	surface-color	self	transparent	2009-01-01 00:00:00
607	3824	relative-shape	self	thick	2009-01-01 00:00:00
608	3824	surface-color	self	grey	2009-01-01 00:00:00
609	3824	catching	physical object	nil	2009-01-01 00:00:00
610	3824	connecting	physical object	nil	2009-01-01 00:00:00
611	3824	surface-pattern	self	solid	2009-01-01 00:00:00
612	3824	display-mode	self	overlay	2009-01-01 00:00:00
613	3824	relative-placement	self	underside	2009-01-01 00:00:00
614	3824	population-density	self	dense	2009-01-01 00:00:00
615	3824	shape-geometry	self	cone	2009-01-01 00:00:00
616	3824	shape-geometry	self	non-geniculate	2009-01-01 00:00:00
617	3824	composed-of	physical object	nil	2009-01-01 00:00:00
618	3824	changing	nil	nil	2009-01-01 00:00:00
619	3824	shape-arrangement	self	encrusting	2009-01-01 00:00:00
620	3824	shape-geometry	self	square	2009-01-01 00:00:00
621	3824	relative-placement	self	lateral	2009-01-01 00:00:00
622	3824	performing	behavior	nil	2009-01-01 00:00:00
623	3824	surface-color	self	amber	2009-01-01 00:00:00
624	3824	relative-shape	self	inflated	2009-01-01 00:00:00
625	3824	surface-color	self	beige	2009-01-01 00:00:00
626	3824	perspective	self	overview	2009-01-01 00:00:00
627	3824	life-stage	self	dead	2009-01-01 00:00:00
628	3824	disconnecting	physical object	nil	2009-01-01 00:00:00
629	3824	lighting	self	ambient-light	2009-01-01 00:00:00
630	3824	display-mode	self	Coolpix	2009-01-01 00:00:00
631	3824	water-quality	self	turbid-green	2009-01-01 00:00:00
632	3824	stowed	physical object	nil	2009-01-01 00:00:00
633	3824	shape-geometry	self	geniculate	2009-01-01 00:00:00
634	3824	life-stage	self	adult	2009-01-01 00:00:00
635	3824	shape-geometry	self	crust	2009-01-01 00:00:00
636	3824	shape-geometry	self	film	2009-01-01 00:00:00
637	3824	lighting	self	under-exposed	2009-01-01 00:00:00
638	3824	shape-arrangement	self	flexible	2009-01-01 00:00:00
639	3824	near	physical object	nil	2009-01-01 00:00:00
640	3824	water-quality	self	murky	2009-01-01 00:00:00
641	3824	surface-color	self	yellow	2009-01-01 00:00:00
642	3824	relative-shape	self	skinny	2009-01-01 00:00:00
643	3824	life-stage	self	baby	2009-01-01 00:00:00
644	3824	surface-texture	self	hard	2009-01-01 00:00:00
645	3824	surface-pattern	self	fibrous	2009-01-01 00:00:00
646	3824	surface-texture	self	vesicular	2009-01-01 00:00:00
647	3824	relative-placement	self	apex	2009-01-01 00:00:00
648	3824	surface-color	self	blue	2009-01-01 00:00:00
649	3824	relative-placement	self	low	2009-01-01 00:00:00
650	3824	perspective	self	partly-hidden	2009-01-01 00:00:00
651	3824	relative-shape	self	elongate	2009-01-01 00:00:00
652	3824	retrieved-by	equipment	nil	2009-01-01 00:00:00
653	3824	identity-certainty	self	unusual	2009-01-01 00:00:00
654	3824	relative-placement	self	right	2009-01-01 00:00:00
655	3824	hanging	nil	nil	2009-01-01 00:00:00
656	3824	relative-placement	self	inner	2009-01-01 00:00:00
657	3824	surface-texture	self	smooth	2009-01-01 00:00:00
658	3824	image-quality	self	out-of-focus	2009-01-01 00:00:00
659	3824	population-quantity	self	999	2009-01-01 00:00:00
660	3824	relative-placement	self	deep	2009-01-01 00:00:00
661	3824	posture	self	horizontal	2009-01-01 00:00:00
662	3824	shape-arrangement	self	jointed	2009-01-01 00:00:00
663	3824	life-stage	self	gravid	2009-01-01 00:00:00
664	3824	grabbing	physical object	nil	2009-01-01 00:00:00
665	3824	relative-shape	self	bulbous	2009-01-01 00:00:00
666	3824	extending	physical object	nil	2009-01-01 00:00:00
667	3824	cutting	nil	nil	2009-01-01 00:00:00
668	3824	shape-geometry	self	vermiform	2009-01-01 00:00:00
669	3824	surface-pattern	self	shimmering	2009-01-01 00:00:00
670	3824	identity-certainty	self	definite	2009-01-01 00:00:00
671	3824	surface-color	self	orange	2009-01-01 00:00:00
672	3824	changing	object	color	2009-01-01 00:00:00
673	3824	image-quality	self	selects	2009-01-01 00:00:00
674	3824	sample-reference	self	0	2009-01-01 00:00:00
675	3824	forming	nil	nil	2009-01-01 00:00:00
676	3824	relative-length	self	long	2009-01-01 00:00:00
677	3824	relative-shape	self	uniform	2009-01-01 00:00:00
678	3824	shape-arrangement	self	lobed	2009-01-01 00:00:00
679	3824	touching	physical object	nil	2009-01-01 00:00:00
680	3824	shape-geometry	self	irregular-form	2009-01-01 00:00:00
681	3824	surface-color	self	black	2009-01-01 00:00:00
682	3824	held-by	equipment	nil	2009-01-01 00:00:00
683	3824	relative-shape	self	flat	2009-01-01 00:00:00
684	3824	shape-geometry	self	concretion	2009-01-01 00:00:00
685	3824	posture	self	open	2009-01-01 00:00:00
686	3824	water-quality	self	sediment-cloudy	2009-01-01 00:00:00
687	3824	life-stage	self	old	2009-01-01 00:00:00
688	3824	shape-geometry	self	trumpet	2009-01-01 00:00:00
689	3824	shape-geometry	self	basket	2009-01-01 00:00:00
690	3824	relative-placement	self	centered	2009-01-01 00:00:00
691	3824	perspective	self	wide-shot	2009-01-01 00:00:00
692	3824	shape-arrangement	self	truncated	2009-01-01 00:00:00
693	3824	on	physical object	nil	2009-01-01 00:00:00
694	3824	shape-arrangement	self	folded	2009-01-01 00:00:00
695	3824	population-density	self	sparse	2009-01-01 00:00:00
696	3824	relative-placement	self	aboral	2009-01-01 00:00:00
697	3824	shape-arrangement	self	convoluted	2009-01-01 00:00:00
698	3824	within	physical object	nil	2009-01-01 00:00:00
699	3824	upon	physical object	nil	2009-01-01 00:00:00
700	3824	relative-placement	self	surface	2009-01-01 00:00:00
701	3824	relative-placement	self	anterior	2009-01-01 00:00:00
702	3824	moving	nil	nil	2009-01-01 00:00:00
703	3824	perspective	self	distant	2009-01-01 00:00:00
704	3824	overhanging	physical object	nil	2009-01-01 00:00:00
705	3824	surface-texture	self	soft	2009-01-01 00:00:00
706	3824	surface-texture	self	fleshy	2009-01-01 00:00:00
707	3824	identity-certainty	self	new	2009-01-01 00:00:00
708	3824	surface-texture	self	gelatinous	2009-01-01 00:00:00
709	3824	surface-color	self	brown	2009-01-01 00:00:00
710	3824	surface-color	self	purple	2009-01-01 00:00:00
711	3824	surface-pattern	self	barred	2009-01-01 00:00:00
712	3824	relative-placement	self	distal	2009-01-01 00:00:00
713	3824	surface-color	self	green	2009-01-01 00:00:00
714	3824	surface-color	self	translucent	2009-01-01 00:00:00
715	3824	floating	nil	nil	2009-01-01 00:00:00
716	3824	relative-size	self	small	2009-01-01 00:00:00
717	3824	shape-geometry	self	goiter	2009-01-01 00:00:00
718	3824	buried	nil	nil	2009-01-01 00:00:00
719	3824	relative-placement	self	margin	2009-01-01 00:00:00
720	3824	posture	self	flytrap	2009-01-01 00:00:00
721	3824	testing	nil	nil	2009-01-01 00:00:00
722	3824	attaching-to	physical object	nil	2009-01-01 00:00:00
723	3824	relative-shape	self	fat	2009-01-01 00:00:00
724	3824	surface-texture	self	rough	2009-01-01 00:00:00
725	3824	surface-texture	self	spiny	2009-01-01 00:00:00
726	3824	dropped-by	physical object	nil	2009-01-01 00:00:00
727	3824	shape-geometry	self	round	2009-01-01 00:00:00
728	3824	display-mode	self	time-code	2009-01-01 00:00:00
729	3824	hollow	nil	nil	2009-01-01 00:00:00
730	3824	posture	self	vertical	2009-01-01 00:00:00
731	3824	shape-geometry	self	stellate	2009-01-01 00:00:00
732	3824	state	self	full	2009-01-01 00:00:00
733	3824	under	physical object	nil	2009-01-01 00:00:00
734	3824	posture	self	closed	2009-01-01 00:00:00
735	3824	identity-reference	self	0	2009-01-01 00:00:00
736	3824	drifting	nil	nil	2009-01-01 00:00:00
737	3824	surface-pattern	self	striped	2009-01-01 00:00:00
738	3824	caught-in	physical object	nil	2009-01-01 00:00:00
739	3824	shape-geometry	self	plate	2009-01-01 00:00:00
740	3824	relative-placement	self	ventral	2009-01-01 00:00:00
741	3824	outside	physical object	nil	2009-01-01 00:00:00
742	3824	shape-arrangement	self	branched	2009-01-01 00:00:00
743	3824	display-mode	self	shore-link	2009-01-01 00:00:00
744	3824	relative-placement	self	high	2009-01-01 00:00:00
745	3824	relative-shape	self	steep	2009-01-01 00:00:00
746	3824	life-stage	self	alive	2009-01-01 00:00:00
747	3824	contains	physical object	nil	2009-01-01 00:00:00
748	3824	shape-arrangement	self	draped	2009-01-01 00:00:00
749	3824	shape-geometry	self	chimney	2009-01-01 00:00:00
750	3824	arranging	physical object	nil	2009-01-01 00:00:00
751	3824	bubbling	nil	nil	2009-01-01 00:00:00
752	3824	relative-length	self	short	2009-01-01 00:00:00
753	3824	life-stage	self	eroded	2009-01-01 00:00:00
754	3824	obscuring	physical object	nil	2009-01-01 00:00:00
755	3824	population-quantity	self	nil	2009-01-01 00:00:00
756	3824	shape-geometry	self	sheet	2009-01-01 00:00:00
757	3824	part-of	physical object	nil	2009-01-01 00:00:00
758	3824	shape-arrangement	self	chain	2009-01-01 00:00:00
759	3824	surface-color	self	pink	2009-01-01 00:00:00
760	3824	surface-texture	self	lumpy	2009-01-01 00:00:00
761	3824	relative-placement	self	oral	2009-01-01 00:00:00
762	3824	length-meters	self	0	2009-01-01 00:00:00
763	3824	surface-color	self	silver	2009-01-01 00:00:00
764	3824	shape-geometry	self	fan	2009-01-01 00:00:00
765	3824	over	physical object	nil	2009-01-01 00:00:00
766	3824	shape-geometry	self	vase	2009-01-01 00:00:00
767	3824	population-aggregation	self	nil	2009-01-01 00:00:00
768	3824	age-days	self	0	2009-01-01 00:00:00
769	3824	shape-geometry	self	bagpipe	2009-01-01 00:00:00
770	3824	unattaching	nil	nil	2009-01-01 00:00:00
771	3824	habitat	self	nil	2009-01-01 00:00:00
772	3824	surface-color	self	white	2009-01-01 00:00:00
773	3824	relative-shape	self	blunt	2009-01-01 00:00:00
774	3824	relative-placement	self	unusual	2009-01-01 00:00:00
775	3824	identity-certainty	self	unknown	2009-01-01 00:00:00
776	3824	surface-pattern	self	counter-shaded	2009-01-01 00:00:00
777	3824	relative-shape	self	narrow	2009-01-01 00:00:00
778	3824	damaged	nil	nil	2009-01-01 00:00:00
779	3824	surface-texture	self	shaggy	2009-01-01 00:00:00
780	3824	state	self	empty	2009-01-01 00:00:00
781	3824	shape-arrangement	self	forked	2009-01-01 00:00:00
782	3824	collapsed	nil	nil	2009-01-01 00:00:00
783	3825	respiring	nil	nil	2009-01-01 00:00:00
784	3825	retracting	physical object	nil	2009-01-01 00:00:00
785	3825	retreating	nil	nil	2009-01-01 00:00:00
786	3825	free-swimming	nil	nil	2009-01-01 00:00:00
787	3825	swimming	nil	nil	2009-01-01 00:00:00
788	3825	kissing	physical object	nil	2009-01-01 00:00:00
789	3825	jetting	nil	nil	2009-01-01 00:00:00
790	3825	eating	physical object	nil	2009-01-01 00:00:00
791	3825	curled-around-by	physical object	nil	2009-01-01 00:00:00
792	3825	feeding-mechanism	self	filter-feeding	2009-01-01 00:00:00
793	3825	regenerating	physical object	nil	2009-01-01 00:00:00
794	3825	identity-gender	self	male	2009-01-01 00:00:00
795	3825	swimming-up	nil	nil	2009-01-01 00:00:00
796	3825	taxonomy-type-specimen	self	nil	2009-01-01 00:00:00
797	3825	hanging	nil	nil	2009-01-01 00:00:00
798	3825	excreting	nil	nil	2009-01-01 00:00:00
799	3825	feeding-association-mutualism-with	marine organism	nil	2009-01-01 00:00:00
800	3825	feeding-association-host-to	marine organism	nil	2009-01-01 00:00:00
801	3825	population-dispersal	self	colony	2009-01-01 00:00:00
802	3825	drifting	nil	nil	2009-01-01 00:00:00
803	3825	population-dispersal	self	shoal	2009-01-01 00:00:00
804	3825	j-posing	nil	nil	2009-01-01 00:00:00
805	3825	jettisoning	physical object	nil	2009-01-01 00:00:00
806	3825	curling	nil	nil	2009-01-01 00:00:00
807	3825	burrowing	nil	nil	2009-01-01 00:00:00
808	3825	bioluminescing	nil	nil	2009-01-01 00:00:00
809	3825	consulting-taxonomist	self	nil	2009-01-01 00:00:00
810	3825	feeding-association-prey-of	marine organism	nil	2009-01-01 00:00:00
811	3825	spawning	nil	nil	2009-01-01 00:00:00
812	3825	puckering	nil	nil	2009-01-01 00:00:00
813	3825	taxonomy-unpublished-name	self	nil	2009-01-01 00:00:00
814	3825	trailing	physical object	nil	2009-01-01 00:00:00
815	3825	feeding	nil	nil	2009-01-01 00:00:00
816	3825	population-dispersal	self	community	2009-01-01 00:00:00
817	3825	curling-around	physical object	nil	2009-01-01 00:00:00
818	3825	inking	nil	nil	2009-01-01 00:00:00
819	3825	taxonomist-assessment	self	nil	2009-01-01 00:00:00
820	3825	pulsing	nil	nil	2009-01-01 00:00:00
821	3825	inhabiting	physical object	nil	2009-01-01 00:00:00
822	3825	waving	physical object	nil	2009-01-01 00:00:00
823	3825	crawling	nil	nil	2009-01-01 00:00:00
824	3825	mating	nil	nil	2009-01-01 00:00:00
825	3825	feeding-association-symbiotic-with	marine organism	nil	2009-01-01 00:00:00
826	3825	schooling	nil	nil	2009-01-01 00:00:00
827	3825	population-dispersal	self	individual	2009-01-01 00:00:00
828	3825	sitting	nil	nil	2009-01-01 00:00:00
829	3825	taxonomy-rank	self	domain	2009-01-01 00:00:00
830	3825	escaping	nil	nil	2009-01-01 00:00:00
831	3825	pursuing	physical object	nil	2009-01-01 00:00:00
832	3825	feeding-association-commensal-with	marine organism	nil	2009-01-01 00:00:00
833	3825	population-dispersal	self	school	2009-01-01 00:00:00
834	3825	reproducing	nil	nil	2009-01-01 00:00:00
835	3825	feeding-mechanism	self	active-predation	2009-01-01 00:00:00
836	3825	taxonomy-reference	self	nil	2009-01-01 00:00:00
837	3825	raiding	nil	nil	2009-01-01 00:00:00
838	3825	feeding-association-predator-of	marine organism	nil	2009-01-01 00:00:00
839	3825	identity-gender	self	female	2009-01-01 00:00:00
840	3825	swimming-down	nil	nil	2009-01-01 00:00:00
841	3825	taxonomy-former-or-unaccepted-name	self	nil	2009-01-01 00:00:00
842	3825	swarming	nil	nil	2009-01-01 00:00:00
843	3825	feeding-association-parasitized-by	marine organism	nil	2009-01-01 00:00:00
844	3825	walking	nil	nil	2009-01-01 00:00:00
845	3825	fishing	nil	nil	2009-01-01 00:00:00
846	6756		self	nil	2009-01-01 00:00:00
847	7027	active	nil	nil	2009-01-01 00:00:00
848	7027	bioturbated	nil	nil	2009-01-01 00:00:00
849	7027	clastic	nil	nil	2009-01-01 00:00:00
850	7369	foobaring	self	nil	2009-01-01 00:00:00
851	7370	eating	nil	nil	2009-01-01 00:00:00
852	7370	relative-placement	self	inner	2009-01-01 00:00:00
853	7370	relative-placement	self	caudal	2009-01-01 00:00:00
854	7370	relative-placement	self	pelvic	2009-01-01 00:00:00
855	7370	relative-placement	self	axial	2009-01-01 00:00:00
856	7370	relative-placement	self	distal	2009-01-01 00:00:00
857	7370	relative-placement	self	apical	2009-01-01 00:00:00
858	7370	relative-placement	self	middle	2009-01-01 00:00:00
859	7370	relative-placement	self	marginal	2009-01-01 00:00:00
860	7370	relative-placement	self	ventral	2009-01-01 00:00:00
861	7370	relative-placement	self	left	2009-01-01 00:00:00
862	7370	relative-placement	self	aboral	2009-01-01 00:00:00
863	7370	relative-placement	self	oral	2009-01-01 00:00:00
864	7370	relative-placement	self	dorsal	2009-01-01 00:00:00
865	7370	relative-placement	self	high	2009-01-01 00:00:00
866	7370	relative-placement	self	low	2009-01-01 00:00:00
867	7370	relative-placement	self	proximal	2009-01-01 00:00:00
868	7370	relative-placement	self	surface	2009-01-01 00:00:00
917	7619	recorded-roll	self	0	2009-01-01 00:00:00
918	7619	recorded-pinger-x	self	0	2009-01-01 00:00:00
919	7619	recorded-sigma-theta	self	0	2009-01-01 00:00:00
920	7619	recorded-heading	self	0	2009-01-01 00:00:00
921	7619	deployed	equipment	nil	2009-01-01 00:00:00
922	7619	recorded-dynamic-height	self	0	2009-01-01 00:00:00
923	7619	recorded-pitch	self	0	2009-01-01 00:00:00
924	7619	recorded-condensation	self	0	2009-01-01 00:00:00
925	7619	colliding-with	physical object	nil	2009-01-01 00:00:00
926	7619	recorded-temperature	self	0	2009-01-01 00:00:00
927	7619	recorded-potential-temperature	self	0	2009-01-01 00:00:00
928	7619	recorded-irradiance-cos	self	0	2009-01-01 00:00:00
929	7619	recorded-pinger-y	self	0	2009-01-01 00:00:00
930	7619	recorded-gyro	self	0	2009-01-01 00:00:00
931	7619	recorded-sigma-t	self	0	2009-01-01 00:00:00
932	7675	recorded-day-sec	self	0	2009-01-01 00:00:00
933	7675	recorded-iris	self	0	2009-01-01 00:00:00
934	7675	computed-delta-error	self	00:00:00:00	2009-01-01 00:00:00
935	7675	computed-delta-error	self	0	2009-01-01 00:00:00
936	7675	recorded-utc	self	0	2009-01-01 00:00:00
937	7675	recorded-field-width	self	0	2009-01-01 00:00:00
938	7675	recorded-date-time	self	0	2009-01-01 00:00:00
939	7675	recorded-focus	self	0	2009-01-01 00:00:00
940	7675	recorded-field-width	self	0.0	2009-01-01 00:00:00
941	7675	recorded-zoom	self	0	2009-01-01 00:00:00
942	7675	recorded-timecode	self	00:00:00:00	2009-01-01 00:00:00
943	7675	tag	nil	nil	2009-01-01 00:00:00
944	7675	still-image	self	nil	2009-01-01 00:00:00
945	7770	interpreter-username	self	nil	2009-01-01 00:00:00
946	7770	interpreted-time-unix	self	nil	2009-01-01 00:00:00
\.


--
-- Data for Name: media; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY media (id, conceptdelegateid_fk, url, mediatype, primarymedia, credit, caption, last_updated_time) FROM stdin;
\.


--
-- Data for Name: observation; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY observation (id, videoframeid_fk, observationdtg, observer, conceptname, notes, last_updated_time, x, y) FROM stdin;
\.


--
-- Data for Name: physicaldata; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY physicaldata (id, videoframeid_fk, depth, temperature, salinity, oxygen, light, latitude, longitude, logdtg, last_updated_time) FROM stdin;
\.


--
-- Data for Name: prefs; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY prefs (nodename, prefkey, prefvalue) FROM stdin;
\.


--
-- Data for Name: sectioninfo; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY sectioninfo (id, conceptdelegateid_fk, header, label, information) FROM stdin;
\.


--
-- Data for Name: uniqueid; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY uniqueid (tablename, nextid) FROM stdin;
Concept	7789
ConceptName	12171
ConceptDelegate	7789
LinkTemplate	947
LinkRealization	267
History	1
SectionInfo	1
Media	1
VideoArchiveSet	1
CameraPlatformDeployment	1
VideoArchive	1
VideoFrame	1
CameraData	1
PhysicalData	1
Observation	1
Association	1
UserAccount	1
Artifact	1
UserName	2
\.


--
-- Data for Name: usage; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY usage (id, conceptdelegateid_fk, embargoexpirationdate, specification, last_updated_time) FROM stdin;
\.


--
-- Data for Name: useraccount; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY useraccount (id, username, password, role, last_updated_time, affiliation, firstname, lastname, email) FROM stdin;
2	helkaf	C/P46AgjesESfATp0kvIOrQ6upicLxCr	Admin	2016-03-10 16:57:52.969644				
\.


--
-- Data for Name: videoarchive; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY videoarchive (id, videoarchivesetid_fk, tapenumber, starttimecode, videoarchivename, last_updated_time) FROM stdin;
\.


--
-- Data for Name: videoarchiveset; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY videoarchiveset (id, trackingnumber, shipname, platformname, formatcode, startdtg, enddtg, last_updated_time) FROM stdin;
\.


--
-- Data for Name: videoframe; Type: TABLE DATA; Schema: public; Owner: varsuser
--

COPY videoframe (id, recordeddtg, tapetimecode, hdtimecode, insequence, displacer, displacedtg, videoarchiveid_fk, last_updated_time) FROM stdin;
\.


--
-- Name: artifact_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY artifact
    ADD CONSTRAINT artifact_pk PRIMARY KEY (id);


--
-- Name: association_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY association
    ADD CONSTRAINT association_pk PRIMARY KEY (id);


--
-- Name: cameradata_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY cameradata
    ADD CONSTRAINT cameradata_pk PRIMARY KEY (id);


--
-- Name: cameradeployment_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY cameraplatformdeployment
    ADD CONSTRAINT cameradeployment_pk PRIMARY KEY (id);


--
-- Name: concept_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY concept
    ADD CONSTRAINT concept_pk PRIMARY KEY (id);


--
-- Name: conceptdelegate_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY conceptdelegate
    ADD CONSTRAINT conceptdelegate_pk PRIMARY KEY (id);


--
-- Name: conceptname_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY conceptname
    ADD CONSTRAINT conceptname_pk PRIMARY KEY (id);


--
-- Name: expdmergestatus_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY expdmergestatus
    ADD CONSTRAINT expdmergestatus_pk PRIMARY KEY (videoarchivesetid_fk);


--
-- Name: history_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY history
    ADD CONSTRAINT history_pk PRIMARY KEY (id);


--
-- Name: linkrealization_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY linkrealization
    ADD CONSTRAINT linkrealization_pk PRIMARY KEY (id);


--
-- Name: linktemplate_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY linktemplate
    ADD CONSTRAINT linktemplate_pk PRIMARY KEY (id);


--
-- Name: media_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY media
    ADD CONSTRAINT media_pk PRIMARY KEY (id);


--
-- Name: observation_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY observation
    ADD CONSTRAINT observation_pk PRIMARY KEY (id);


--
-- Name: physicaldata_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY physicaldata
    ADD CONSTRAINT physicaldata_pk PRIMARY KEY (id);


--
-- Name: sectioninfo_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY sectioninfo
    ADD CONSTRAINT sectioninfo_pk PRIMARY KEY (id);


--
-- Name: uc_physicaldata_fk1; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY physicaldata
    ADD CONSTRAINT uc_physicaldata_fk1 UNIQUE (videoframeid_fk);

ALTER TABLE physicaldata CLUSTER ON uc_physicaldata_fk1;


--
-- Name: uc_useraccount_username; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY useraccount
    ADD CONSTRAINT uc_useraccount_username UNIQUE (username);


--
-- Name: uc_videoarchivename; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY videoarchive
    ADD CONSTRAINT uc_videoarchivename UNIQUE (videoarchivename);


--
-- Name: uc_videoframeid_fk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY cameradata
    ADD CONSTRAINT uc_videoframeid_fk UNIQUE (videoframeid_fk);


--
-- Name: usage_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY usage
    ADD CONSTRAINT usage_pk PRIMARY KEY (id);


--
-- Name: useraccount_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY useraccount
    ADD CONSTRAINT useraccount_pk PRIMARY KEY (id);


--
-- Name: videoarchive_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY videoarchive
    ADD CONSTRAINT videoarchive_pk PRIMARY KEY (id);


--
-- Name: videoarchiveset_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY videoarchiveset
    ADD CONSTRAINT videoarchiveset_pk PRIMARY KEY (id);


--
-- Name: videoframe_pk; Type: CONSTRAINT; Schema: public; Owner: varsuser; Tablespace: 
--

ALTER TABLE ONLY videoframe
    ADD CONSTRAINT videoframe_pk PRIMARY KEY (id);


--
-- Name: idx_artifact_ck; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE UNIQUE INDEX idx_artifact_ck ON artifact USING btree (conceptdelegateid_fk, groupid, artifactid, version, classifier);


--
-- Name: idx_artifact_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_artifact_fk1 ON artifact USING btree (conceptdelegateid_fk);


--
-- Name: idx_artifact_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_artifact_lut ON artifact USING btree (last_updated_time);


--
-- Name: idx_association_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_association_fk1 ON association USING btree (observationid_fk);


--
-- Name: idx_association_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_association_lut ON association USING btree (last_updated_time);


--
-- Name: idx_association_toconcept; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_association_toconcept ON association USING btree (toconcept);


--
-- Name: idx_cameradata_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_cameradata_fk1 ON cameradata USING btree (videoframeid_fk);


--
-- Name: idx_cameradata_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_cameradata_lut ON cameradata USING btree (last_updated_time);


--
-- Name: idx_cameradeployment_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_cameradeployment_fk1 ON cameraplatformdeployment USING btree (videoarchivesetid_fk);


--
-- Name: idx_cameraplatformdeployment_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_cameraplatformdeployment_lut ON cameraplatformdeployment USING btree (last_updated_time);


--
-- Name: idx_concept_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_concept_fk1 ON concept USING btree (parentconceptid_fk);


--
-- Name: idx_concept_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_concept_lut ON concept USING btree (last_updated_time);


--
-- Name: idx_conceptdelegate_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_conceptdelegate_fk1 ON conceptdelegate USING btree (conceptid_fk);


--
-- Name: idx_conceptdelegate_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_conceptdelegate_lut ON conceptdelegate USING btree (last_updated_time);


--
-- Name: idx_conceptname_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_conceptname_fk1 ON conceptname USING btree (conceptid_fk);


--
-- Name: idx_conceptname_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_conceptname_lut ON conceptname USING btree (last_updated_time);


--
-- Name: idx_conceptname_name; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_conceptname_name ON conceptname USING btree (conceptname);


--
-- Name: idx_history_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_history_fk1 ON history USING btree (conceptdelegateid_fk);


--
-- Name: idx_history_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_history_lut ON history USING btree (last_updated_time);


--
-- Name: idx_linkrealization_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_linkrealization_fk1 ON linkrealization USING btree (conceptdelegateid_fk);


--
-- Name: idx_linkrealization_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_linkrealization_lut ON linkrealization USING btree (last_updated_time);


--
-- Name: idx_linktemplate_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_linktemplate_fk1 ON linktemplate USING btree (conceptdelegateid_fk);


--
-- Name: idx_linktemplate_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_linktemplate_lut ON linktemplate USING btree (last_updated_time);


--
-- Name: idx_media_lut; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_media_lut ON media USING btree (last_updated_time);


--
-- Name: idx_observation_conceptname; Type: INDEX; Schema: public; Owner: varsuser; Tablespace: 
--

CREATE INDEX idx_observation_conceptname ON observation USING btree (conceptname);


--
-- Name: idx_observation_fk1; Type: INDEX; Schema: public; Owner: varsuser; Tables