/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.mbari.expd.CameraDatum;
import org.mbari.expd.CameraDatumDAO;
import org.mbari.expd.CtdDatum;
import org.mbari.expd.CtdDatumDAO;
import org.mbari.expd.Dive;
import org.mbari.expd.NavigationDatum;
import org.mbari.expd.NavigationDatumDAO;
import org.mbari.expd.UberDatum;
import org.mbari.expd.UberDatumDAO;
import org.mbari.expd.jdbc.UberDatumImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberDatumDAOImpl
implements UberDatumDAO {
    private final CameraDatumDAO cameraDatumDAO;
    private final NavigationDatumDAO navigationDatumDAO;
    private final CtdDatumDAO ctdDatumDAO;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public UberDatumDAOImpl(CameraDatumDAO cameraDatumDAO, NavigationDatumDAO navigationDatumDAO, CtdDatumDAO ctdDatumDAO) {
        this.cameraDatumDAO = cameraDatumDAO;
        this.navigationDatumDAO = navigationDatumDAO;
        this.ctdDatumDAO = ctdDatumDAO;
    }

    public List<UberDatum> fetchData(Dive dive, boolean isHD, double toleranceSec) {
        ArrayList<UberDatum> data = new ArrayList<UberDatum>();
        List navigationData = this.navigationDatumDAO.fetchBestNavigationData(dive);
        if (navigationData == null || navigationData.isEmpty()) {
            this.log.warn("No navigation data was found for: " + dive.getRovName() + " #" + dive.getDiveNumber());
            return data;
        }
        List dates = navigationData.stream().map(NavigationDatum::getDate).collect(Collectors.toList());
        List ctdData = this.ctdDatumDAO.fetchCtdData(dive, dates, toleranceSec);
        List cameraData = this.cameraDatumDAO.fetchCameraData(dive, dates, toleranceSec, Boolean.valueOf(isHD));
        for (int i = 0; i < dates.size(); ++i) {
            NavigationDatum nav = navigationData.size() == dates.size() ? (NavigationDatum)navigationData.get(i) : null;
            CtdDatum ctd = ctdData.size() == dates.size() ? (CtdDatum)ctdData.get(i) : null;
            CameraDatum cam = cameraData.size() == dates.size() ? (CameraDatum)cameraData.get(i) : null;
            data.add(new UberDatumImpl(cam, nav, ctd));
        }
        return data;
    }

    public List<UberDatum> fetchCtdData(Dive dive, double toleranceSec) {
        List ctdData = this.ctdDatumDAO.fetchCtdData(dive);
        ArrayList<Date> dates = new ArrayList<Date>(ctdData.size());
        for (CtdDatum ctdDatum : ctdData) {
            dates.add(ctdDatum.getDate());
        }
        List navigationData = this.navigationDatumDAO.fetchNavigationData(dive, dates, toleranceSec);
        ArrayList<UberDatum> data = new ArrayList<UberDatum>(ctdData.size());
        for (int i = 0; i < dates.size(); ++i) {
            data.add(new UberDatumImpl(null, (NavigationDatum)navigationData.get(i), (CtdDatum)ctdData.get(i)));
        }
        return data;
    }
}

