/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.ShipNavigationDatum;
import org.mbari.expd.ShipNavigationDatumDAO;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.ShipNavigationDatumImpl;
import org.mbari.sql.QueryFunction;

public class ShipNavigationDatumDAOImpl
extends BaseDAOImpl
implements ShipNavigationDatumDAO {
    public static final String SELECT_COLUMNS = " DatetimeGMT, Latitude, Longitude, Heading";

    public List<ShipNavigationDatum> fetchBetweenDates(String ship, Date start, Date end) {
        String table = ShipNavigationDatumDAOImpl.resolveShipTablePrefix(ship) + "RawNavData";
        String sql = "SELECT  DatetimeGMT, Latitude, Longitude, Heading FROM " + table + " WHERE DatetimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(start) + "' AND '" + DATE_FORMAT_UTC.format(end) + "'";
        return (List)this.executeQueryFunction(sql, new LoadDateFunction(ship));
    }

    private class LoadDateFunction
    implements QueryFunction<List<ShipNavigationDatum>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        private final String ship;

        private LoadDateFunction(String ship) {
            this.ship = ship;
        }

        public List<ShipNavigationDatum> apply(ResultSet resultSet) throws SQLException {
            ArrayList<ShipNavigationDatum> data = new ArrayList<ShipNavigationDatum>();
            while (resultSet.next()) {
                Timestamp date = resultSet.getTimestamp(1, this.calendar);
                Double latitude = resultSet.getDouble(2);
                Double longitude = resultSet.getDouble(3);
                Double heading = resultSet.getDouble(4);
                data.add(new ShipNavigationDatumImpl(date, heading, latitude, longitude, this.ship));
            }
            return data;
        }
    }
}

