/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.Dive;
import org.mbari.expd.NavigationDatum;
import org.mbari.expd.NavigationDatumDAO;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.NavigationDatumImpl;
import org.mbari.expd.math.NearestNeighbor;
import org.mbari.sql.QueryFunction;

public class NavigationDatumDAOImpl
extends BaseDAOImpl
implements NavigationDatumDAO {
    public static final String SELECT_COLUMNS = " DatetimeGMT, Latitude, Longitude, Pressure, Depth, Altitude, Heading, Pitch, Roll, ShipLatitude, ShipLongitude, ShipHeading, QCFlag ";

    public List<NavigationDatum> fetchRawNavigationData(Dive dive) {
        String prefix = NavigationDatumDAOImpl.resolveRovTablePrefix(dive.getRovName());
        String tableRaw = prefix + "RawNavData";
        String sql = "SELECT  DatetimeGMT, Latitude, Longitude, Pressure, Depth, Altitude, Heading, Pitch, Roll, ShipLatitude, ShipLongitude, ShipHeading, QCFlag  FROM " + tableRaw + " WHERE DatetimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(dive.getStartDate()) + "' AND '" + DATE_FORMAT_UTC.format(dive.getEndDate()) + "' ORDER BY DatetimeGMT";
        List data = (List)this.executeQueryFunction(sql, new LoadDataFunction(dive.getRovName()));
        data.stream().forEach(navigationDatum -> ((NavigationDatumImpl)navigationDatum).setEdited(Boolean.FALSE));
        return data;
    }

    public List<NavigationDatum> fetchEditedNavigationData(Dive dive) {
        String prefix = NavigationDatumDAOImpl.resolveRovTablePrefix(dive.getRovName());
        String tableEdited = prefix + "CleanNavData";
        String sql = "SELECT  DatetimeGMT, Latitude, Longitude, Pressure, Depth, Altitude, Heading, Pitch, Roll, ShipLatitude, ShipLongitude, ShipHeading, QCFlag  FROM " + tableEdited + " WHERE DatetimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(dive.getStartDate()) + "' AND '" + DATE_FORMAT_UTC.format(dive.getEndDate()) + "' ORDER BY DatetimeGMT";
        List data = (List)this.executeQueryFunction(sql, new LoadDataFunction(dive.getRovName()));
        data.stream().forEach(navigationDatum -> ((NavigationDatumImpl)navigationDatum).setEdited(Boolean.TRUE));
        return data;
    }

    public List<NavigationDatum> fetchNavigationData(Dive dive, List<Date> dates, double toleranceSec) {
        double[] times = dates.stream().mapToDouble(d -> (double)d.getTime() / 1000.0).toArray();
        List<NavigationDatum> editedNavData = this.fetchEditedNavigationData(dive);
        boolean hasMissing = editedNavData.isEmpty();
        List<Object> data = new ArrayList<NavigationDatum>();
        if (!editedNavData.isEmpty()) {
            double[] editedNavTimes = editedNavData.stream().mapToDouble(d -> (double)d.getDate().getTime() / 1000.0).toArray();
            int[] idx = NearestNeighbor.apply((double[])editedNavTimes, (double[])times, (double)toleranceSec);
            data = NearestNeighbor.collate(editedNavData, (int[])idx);
            for (int i = 0; i < idx.length; ++i) {
                boolean bl = hasMissing = idx[i] == -1;
                if (hasMissing) break;
            }
        }
        if (hasMissing) {
            data = new ArrayList<Object>(Collections.nCopies(dates.size(), null));
            List<NavigationDatum> rawNavData = this.fetchRawNavigationData(dive);
            if (rawNavData != null && !rawNavData.isEmpty()) {
                double[] rawNavTimes = rawNavData.stream().mapToDouble(d -> (double)d.getDate().getTime() / 1000.0).toArray();
                int[] idx2 = NearestNeighbor.apply((double[])rawNavTimes, (double[])times, (double)toleranceSec);
                List rawData = NearestNeighbor.collate(rawNavData, (int[])idx2);
                for (int i = 0; i < data.size(); ++i) {
                    if (data.get(i) != null) continue;
                    data.set(i, rawData.get(i));
                }
            }
        }
        return data;
    }

    public List<NavigationDatum> fetchBestNavigationData(Dive dive) {
        List<NavigationDatum> data = this.fetchEditedNavigationData(dive);
        if (data.isEmpty()) {
            data = this.fetchRawNavigationData(dive);
        }
        return data;
    }

    private class LoadDataFunction
    implements QueryFunction<List<NavigationDatum>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        private final String platformName;

        public LoadDataFunction(String platformName) {
            this.platformName = platformName;
        }

        public List<NavigationDatum> apply(ResultSet resultSet) throws SQLException {
            ArrayList<NavigationDatum> data = new ArrayList<NavigationDatum>();
            while (resultSet.next()) {
                Timestamp date = resultSet.getTimestamp(1, this.calendar);
                Double latitude = resultSet.getDouble(2);
                Double longitude = resultSet.getDouble(3);
                Float pressure = Float.valueOf(resultSet.getFloat(4));
                Float depth = Float.valueOf(resultSet.getFloat(5));
                Float altitude = Float.valueOf(resultSet.getFloat(6));
                Float heading = Float.valueOf(resultSet.getFloat(7));
                Float pitch = Float.valueOf(resultSet.getFloat(8));
                Float roll = Float.valueOf(resultSet.getFloat(9));
                Double shipLatitude = resultSet.getDouble(10);
                Double shipLongitude = resultSet.getDouble(11);
                Float shipHeading = Float.valueOf(resultSet.getFloat(12));
                Boolean qcFlag = resultSet.getBoolean(13);
                data.add(new NavigationDatumImpl(this.platformName, altitude, date, depth, pressure, heading, latitude, longitude, pitch, qcFlag, roll, shipHeading, shipLatitude, shipLongitude));
            }
            return data;
        }
    }
}

