/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.Dive;
import org.mbari.expd.Expedition;
import org.mbari.expd.ExpeditionDAO;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.ExpeditionImpl;
import org.mbari.sql.QueryFunction;

public class ExpeditionDAOImpl
extends BaseDAOImpl
implements ExpeditionDAO {
    private final String SELECT_COLUMNS = "e.ExpeditionID, e.Accomplishments, e.ExpdChiefScientist, e.EndDtg, e.EquipmentDesc, e.OperatorComments, e.Participants, e.PlannedTrackDesc, e.ExpdPrincipalInvestigator, e.Purpose, e.RegionDesc, e.ScheduledEndDtg, e.ScheduledStartDtg, e.SciObjectivesMet, e.ScientistComments, e.ShipSeqNum,  e.ShipName, e.StartDtg, e.UpdatedBy";
    private final String FROM_STATEMENT = "FROM Expedition AS e";
    private final QueryFunction<List<Expedition>> queryFunction = new LoadExpdFunction();

    public Collection<Expedition> findByDive(Dive dive) {
        String sql = "SELECT e.ExpeditionID, e.Accomplishments, e.ExpdChiefScientist, e.EndDtg, e.EquipmentDesc, e.OperatorComments, e.Participants, e.PlannedTrackDesc, e.ExpdPrincipalInvestigator, e.Purpose, e.RegionDesc, e.ScheduledEndDtg, e.ScheduledStartDtg, e.SciObjectivesMet, e.ScientistComments, e.ShipSeqNum,  e.ShipName, e.StartDtg, e.UpdatedBy FROM Expedition AS e WHERE e.startDtg <= '" + DATE_FORMAT_UTC.format(dive.getStartDate()) + "' AND e.endDtg >= '" + DATE_FORMAT_UTC.format(dive.getEndDate()) + "'";
        Collection possibleMatches = (Collection)this.executeQueryFunction(sql, this.queryFunction);
        ArrayList<Expedition> exactMatches = new ArrayList<Expedition>();
        Collection<String> shipNames = ExpeditionDAOImpl.resolveShipByRov(dive.getRovName());
        possibleMatches.stream().filter(e -> shipNames.contains(e.getShipName())).forEach(exactMatches::add);
        return exactMatches;
    }

    public Collection<Expedition> findAll() {
        String sql = "SELECT e.ExpeditionID, e.Accomplishments, e.ExpdChiefScientist, e.EndDtg, e.EquipmentDesc, e.OperatorComments, e.Participants, e.PlannedTrackDesc, e.ExpdPrincipalInvestigator, e.Purpose, e.RegionDesc, e.ScheduledEndDtg, e.ScheduledStartDtg, e.SciObjectivesMet, e.ScientistComments, e.ShipSeqNum,  e.ShipName, e.StartDtg, e.UpdatedBy FROM Expedition AS e";
        return (Collection)this.executeQueryFunction(sql, this.queryFunction);
    }

    private class LoadExpdFunction
    implements QueryFunction<List<Expedition>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));

        private LoadExpdFunction() {
        }

        public List<Expedition> apply(ResultSet resultSet) throws SQLException {
            ArrayList<Expedition> expeditions = new ArrayList<Expedition>();
            while (resultSet.next()) {
                Integer expdId = resultSet.getInt(1);
                String accomplishments = resultSet.getString(2);
                String chiefScientist = resultSet.getString(3);
                Timestamp endDate = resultSet.getTimestamp(4, this.calendar);
                String equipDesc = resultSet.getString(5);
                String operatorComments = resultSet.getString(6);
                String participants = resultSet.getString(7);
                String trackDesc = resultSet.getString(8);
                String pi = resultSet.getString(9);
                String purpose = resultSet.getString(10);
                String regionDesc = resultSet.getString(11);
                Timestamp sEndDate = resultSet.getTimestamp(12, this.calendar);
                Timestamp sStartDate = resultSet.getTimestamp(13, this.calendar);
                String objectivesMet = resultSet.getString(14);
                String sciComments = resultSet.getString(15);
                Integer shipSeqNum = resultSet.getInt(16);
                String shipName = resultSet.getString(17);
                Timestamp startDate = resultSet.getTimestamp(18, this.calendar);
                String updatedBy = resultSet.getString(19);
                expeditions.add(new ExpeditionImpl(expdId, accomplishments, chiefScientist, endDate, equipDesc, operatorComments, participants, trackDesc, pi, purpose, regionDesc, sEndDate, sStartDate, objectivesMet, sciComments, shipSeqNum, BaseDAOImpl.resolveFullShipName(shipName), startDate, updatedBy));
            }
            return expeditions;
        }
    }
}

