/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.Dive;
import org.mbari.expd.DiveDAO;
import org.mbari.expd.Expedition;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.DiveImpl;
import org.mbari.geometry.Envelope;
import org.mbari.sql.QueryFunction;

public class DiveDAOImpl
extends BaseDAOImpl
implements DiveDAO {
    private final String SELECT_COLUMNS = "d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude";
    private final String FROM_STATEMENT = "FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid";
    private final QueryFunction<List<Dive>> queryFunction = new LoadDiveFunction();

    public Collection<Dive> findByPlatformAndTrackingNumber(String platform, Integer trackingNumber) {
        GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        String numberString = trackingNumber.toString();
        Integer year = new Integer(numberString.substring(0, 4));
        Integer dayOfYear = new Integer(numberString.substring(4, 7));
        utcCalendar.set(1, year);
        utcCalendar.set(6, dayOfYear);
        utcCalendar.set(11, 0);
        utcCalendar.set(12, 0);
        utcCalendar.set(13, 0);
        String startDate = DATE_FORMAT_UTC.format(utcCalendar.getTime());
        utcCalendar.set(11, 23);
        utcCalendar.set(12, 59);
        utcCalendar.set(13, 59);
        String endDate = DATE_FORMAT_UTC.format(utcCalendar.getTime());
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE DiveStartDtg BETWEEN '" + startDate + "' AND '" + endDate + "' AND d.rovname = '" + DiveDAOImpl.toShortRovName(platform) + "' ORDER BY d.divenumber";
        return (Collection)this.executeQueryFunction(sql, this.queryFunction);
    }

    public Dive findByPlatformAndDiveNumber(String platform, Integer diveNumber) {
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE d.rovname = '" + DiveDAOImpl.toShortRovName(platform) + "' AND d.divenumber = " + diveNumber;
        List dives = (List)this.executeQueryFunction(sql, new LoadDiveFunction());
        return dives.size() > 0 ? (Dive)dives.get(0) : null;
    }

    public Collection<Dive> findByPlatform(String platform) {
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE d.rovname = '" + DiveDAOImpl.toShortRovName(platform) + "' ORDER BY d.divenumber";
        return (Collection)this.executeQueryFunction(sql, this.queryFunction);
    }

    public Collection<Dive> findAllWithinEnvelope(Envelope<Double> envelope) {
        String sql = "SELECT d.rovname AS RovName, d.divenumber AS DiveNumber FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE ds.avgrovlat BETWEEN " + envelope.getMinimum().getY() + " AND " + envelope.getMaximum().getY() + " AND ds.avgrovlon BETWEEN " + envelope.getMinimum().getX() + " AND " + envelope.getMaximum().getX() + " ORDER BY d.divestartdtg";
        QueryFunction queryFunction = resultSet -> {
            ArrayList<Dive> dives = new ArrayList<Dive>();
            while (resultSet.next()) {
                Integer diveNumber;
                String platform = DiveDAOImpl.resolveFullRovName(resultSet.getString(1));
                Dive dive = this.findByPlatformAndDiveNumber(platform, diveNumber = Integer.valueOf(resultSet.getInt(2)));
                if (dive == null) continue;
                dives.add(dive);
            }
            return dives;
        };
        return (Collection)this.executeQueryFunction(sql, queryFunction);
    }

    public Collection<Dive> findAll() {
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid ORDER BY d.divenumber";
        return (Collection)this.executeQueryFunction(sql, this.queryFunction);
    }

    public Dive findByPlatformAndDate(String platform, Date date) {
        String utc = DATE_FORMAT_UTC.format(date);
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE d.rovname = '" + DiveDAOImpl.toShortRovName(platform) + "' AND d.divestartdtg < '" + utc + "' AND d.diveenddtg > '" + utc + "'";
        List dives = (List)this.executeQueryFunction(sql, this.queryFunction);
        return dives.size() > 0 ? (Dive)dives.get(0) : null;
    }

    public Collection<Dive> findAllByExpedition(Expedition expedition) {
        Collection<String> rovNames = DiveDAOImpl.resolveRovByShip(expedition.getShipName());
        Collection shortRovNames = Collections2.transform(rovNames, input -> "'" + DiveDAOImpl.toShortRovName(input) + "'");
        String s = Joiner.on((String)", ").join((Iterable)shortRovNames);
        String start = DATE_FORMAT_UTC.format(expedition.getStartDate());
        String end = DATE_FORMAT_UTC.format(expedition.getEndDate());
        String sql = "SELECT d.diveid AS DiveID, d.rovname AS RovName, d.divenumber AS DiveNumber, d.divestartdtg AS DiveStartDtg, d.diveenddtg AS DiveEndDtg, d.divechiefscientist AS DiveChiefScientist, d.BriefAccomplishments, ds.avgrovlat AS Latitude, ds.avgrovlon AS Longitude FROM DiveSummary ds RIGHT OUTER JOIN Dive d ON d.DiveID = ds.diveid WHERE d.rovname in (" + s + ") AND d.DiveStartDtg BETWEEN '" + start + "' AND '" + end + "' AND d.DiveEndDtg BETWEEN '" + start + "' AND '" + end + "'";
        return (Collection)this.executeQueryFunction(sql, this.queryFunction);
    }

    private class LoadDiveFunction
    implements QueryFunction<List<Dive>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));

        private LoadDiveFunction() {
        }

        public List<Dive> apply(ResultSet resultSet) throws SQLException {
            ArrayList<Dive> dives = new ArrayList<Dive>();
            while (resultSet.next()) {
                Integer diveId = resultSet.getInt(1);
                String rovName = BaseDAOImpl.resolveFullRovName(resultSet.getString(2));
                Integer diveNumber = resultSet.getInt(3);
                Timestamp startDate = resultSet.getTimestamp(4, this.calendar);
                Timestamp endDate = resultSet.getTimestamp(5, this.calendar);
                String chiefScientist = resultSet.getString(6);
                String briefAccomplishments = resultSet.getString(7);
                Double latitude = resultSet.getDouble(8);
                Double longitude = resultSet.getDouble(9);
                dives.add(new DiveImpl(diveId, rovName, diveNumber, startDate, endDate, chiefScientist, briefAccomplishments, latitude, longitude));
            }
            return dives;
        }
    }
}

