/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.util.Date;
import org.mbari.expd.CtdDatum;

public class CtdDatumImpl
implements CtdDatum {
    private final String platformName;
    private final Date date;
    private final Float temperature;
    private final Float salinity;
    private Float oxygen;
    private final Float oxygen1;
    private final Integer oxygen1Flag;
    private final Float oxygen2;
    private final Integer oxygen2Flag;
    private final Float lightTransmission;
    private final Float pressure;

    public CtdDatumImpl(String platformName, Date date, Float temperature, Float salinity, Float oxygen1, Integer oxygen1Flag, Float oxygen2, Integer oxygen2Flag, Float lightTransmission, Float pressure) {
        this.platformName = platformName;
        this.date = date;
        this.temperature = temperature;
        this.salinity = salinity;
        this.oxygen1 = oxygen1;
        this.oxygen1Flag = oxygen1Flag;
        this.oxygen2 = oxygen2;
        this.oxygen2Flag = oxygen2Flag;
        this.lightTransmission = lightTransmission;
        this.pressure = pressure;
    }

    public Float getPressure() {
        return this.pressure;
    }

    public Date getDate() {
        return this.date;
    }

    public Float getLightTransmission() {
        return this.lightTransmission;
    }

    public Float getOxygen() {
        if (this.oxygen == null) {
            Float f = this.oxygen = this.oxygen1Flag >= this.oxygen2Flag ? this.oxygen1 : this.oxygen2;
            if (this.oxygen1Flag == 0 && this.oxygen2Flag == 0) {
                this.oxygen = null;
            }
        }
        return this.oxygen;
    }

    public Float getOxygen1() {
        return this.oxygen1;
    }

    public Integer getOxygen1Flag() {
        return this.oxygen1Flag;
    }

    public Float getOxygen2() {
        return this.oxygen2;
    }

    public Integer getOxygen2Flag() {
        return this.oxygen2Flag;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public Float getSalinity() {
        return this.salinity;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CtdDatumImpl other = (CtdDatumImpl)obj;
        if (this.platformName == null ? other.platformName != null : !this.platformName.equals(other.platformName)) {
            return false;
        }
        return this.date == other.date || this.date != null && this.date.equals(other.date);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.platformName != null ? this.platformName.hashCode() : 0);
        hash = 97 * hash + (this.date != null ? this.date.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(platformName = " + this.platformName + ", date = " + this.date + ")";
    }
}

