/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.CtdDatum;
import org.mbari.expd.CtdDatumDAO;
import org.mbari.expd.Dive;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.CtdDatumImpl;
import org.mbari.expd.math.NearestNeighbor;
import org.mbari.sql.QueryFunction;

public class CtdDatumDAOImpl
extends BaseDAOImpl
implements CtdDatumDAO {
    public static final String SELECT_COLUMNS = " DatetimeGMT, t, s, o2, o2Flag, o2alt, o2altFlag, light, p ";

    public List<CtdDatum> fetchCtdData(Dive dive) {
        String prefix = CtdDatumDAOImpl.resolveRovTablePrefix(dive.getRovName());
        String table = prefix + "RovctdData";
        String preSql = "SELECT  DatetimeGMT, t, s, o2, o2Flag, o2alt, o2altFlag, light, p  FROM ";
        String postSql = " WHERE DatetimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(dive.getStartDate()) + "' AND '" + DATE_FORMAT_UTC.format(dive.getEndDate()) + "' ORDER BY DatetimeGMT";
        String sql = preSql + table + postSql;
        List data = (List)this.executeQueryFunction(sql, new LoadDataFunction(dive.getRovName()));
        if (data.isEmpty()) {
            table = prefix + "RovctdBinData";
            sql = preSql + table + postSql;
            data = (List)this.executeQueryFunction(sql, new LoadDataFunction(dive.getRovName()));
        }
        return data;
    }

    public List<CtdDatum> fetchCtdData(Dive dive, List<Date> dates, double toleranceSec) {
        List<CtdDatum> ctdData = this.fetchCtdData(dive);
        if (!ctdData.isEmpty()) {
            double[] ctdTimes = ctdData.stream().mapToDouble(d -> (double)d.getDate().getTime() / 1000.0).toArray();
            double[] times = dates.stream().mapToDouble(d -> (double)d.getTime() / 1000.0).toArray();
            int[] idx = NearestNeighbor.apply((double[])ctdTimes, (double[])times, (double)toleranceSec);
            return NearestNeighbor.collate(ctdData, (int[])idx);
        }
        return ctdData;
    }

    private class LoadDataFunction
    implements QueryFunction<List<CtdDatum>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        private final String platformName;

        public LoadDataFunction(String platformName) {
            this.platformName = platformName;
        }

        public List<CtdDatum> apply(ResultSet resultSet) throws SQLException {
            ArrayList<CtdDatum> data = new ArrayList<CtdDatum>();
            while (resultSet.next()) {
                Integer o2Flag = resultSet.getInt(5);
                Float o2 = Float.valueOf(resultSet.getFloat(4));
                Integer o2AltFlag = resultSet.getInt(7);
                Float o2Alt = Float.valueOf(resultSet.getFloat(6));
                Timestamp date = resultSet.getTimestamp(1, this.calendar);
                Float temperature = Float.valueOf(resultSet.getFloat(2));
                Float salinity = Float.valueOf(resultSet.getFloat(3));
                Float light = Float.valueOf(resultSet.getFloat(8));
                Float pressure = Float.valueOf(resultSet.getFloat(9));
                data.add(new CtdDatumImpl(this.platformName, date, temperature, salinity, o2, o2Flag, o2Alt, o2AltFlag, light, pressure));
            }
            return data;
        }
    }
}

