/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.mbari.expd.CameraDatum;
import org.mbari.expd.CameraDatumDAO;
import org.mbari.expd.Dive;
import org.mbari.expd.jdbc.BaseDAOImpl;
import org.mbari.expd.jdbc.CameraDatumImpl;
import org.mbari.expd.math.NearestNeighbor;
import org.mbari.math.Matlib;
import org.mbari.movie.Timecode;
import org.mbari.movie.VideoTime;
import org.mbari.movie.VideoTimeBean;
import org.mbari.sql.QueryFunction;

public class CameraDatumDAOImpl
extends BaseDAOImpl
implements CameraDatumDAO {
    public static final String SELECT_COLUMNS = " DateTimeGMT, betaTimecode, hdTimecode, mainFocus, mainZoom, mainIris ";
    public static final String SELECT_COLUMNS_DOC_RICKETTS = " DateTimeGMT, betaTimecode, hdTimecode, focusVolts, zoomVolts, irisVolts ";

    public List<CameraDatum> fetchCameraData(Dive dive, Boolean isHD) {
        String table = CameraDatumDAOImpl.resolveRovTablePrefix(dive.getRovName()) + "CamlogData";
        String tc = isHD != false ? "hdTimecode" : "betaTimecode";
        String columns = table.startsWith("Doc") ? SELECT_COLUMNS_DOC_RICKETTS : SELECT_COLUMNS;
        String sql = "SELECT " + columns + " FROM " + table + " WHERE DateTimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(dive.getStartDate()) + "' AND '" + DATE_FORMAT_UTC.format(dive.getEndDate()) + "' AND " + tc + " IS NOT NULL ORDER BY DateTimeGMT";
        return (List)this.executeQueryFunction(sql, new LoadDataFunction(dive.getRovName()));
    }

    public List<CameraDatum> findAllNearDate(String platform, Date date, int millisecTolerance) {
        Date startDate = new Date(date.getTime() - (long)millisecTolerance);
        Date endDate = new Date(date.getTime() + (long)millisecTolerance);
        return this.findAllBetweenDates(platform, startDate, endDate);
    }

    public List<CameraDatum> fetchCameraData(Dive dive, List<Date> dates, double toleranceSec, Boolean isHD) {
        List<CameraDatum> cameraData = this.fetchCameraData(dive, isHD);
        if (!cameraData.isEmpty()) {
            double[] cameraTimes = cameraData.stream().mapToDouble(d -> (double)d.getDate().getTime() / 1000.0).toArray();
            double[] times = dates.stream().mapToDouble(d -> (double)d.getTime() / 1000.0).toArray();
            int[] idx = NearestNeighbor.apply((double[])cameraTimes, (double[])times, (double)toleranceSec);
            return NearestNeighbor.collate(cameraData, (int[])idx);
        }
        return cameraData;
    }

    public List<CameraDatum> findAllBetweenDates(String platform, Date startDate, Date endDate) {
        String table = CameraDatumDAOImpl.resolveRovTablePrefix(platform) + "CamlogData";
        String columns = table.startsWith("Doc") ? SELECT_COLUMNS_DOC_RICKETTS : SELECT_COLUMNS;
        String sql = "SELECT " + columns + " FROM " + table + " WHERE DateTimeGMT BETWEEN '" + DATE_FORMAT_UTC.format(startDate) + "' AND '" + DATE_FORMAT_UTC.format(endDate) + "' ORDER BY DateTimeGMT";
        return (List)this.executeQueryFunction(sql, new LoadDataFunction(platform));
    }

    public VideoTime interpolateTimecodeToDate(String cameraIdentifier, Date date, int millisecTolerance, double frameRate) {
        List<CameraDatum> cameraData = this.findAllNearDate(cameraIdentifier, date, millisecTolerance);
        VideoTimeBean returnTapeTime = null;
        if (cameraData.size() > 1) {
            Collections.sort(cameraData, (o1, o2) -> o1.getDate().compareTo(o2.getDate()));
            BigDecimal[] dates = new BigDecimal[cameraData.size()];
            BigDecimal[] frames = new BigDecimal[cameraData.size()];
            for (int i = 0; i < cameraData.size(); ++i) {
                CameraDatum cameraDatum = cameraData.get(i);
                dates[i] = new BigDecimal(cameraDatum.getDate().getTime());
                Timecode timecode = new Timecode(cameraDatum.getTimecode(), frameRate);
                frames[i] = new BigDecimal(timecode.getFrames());
            }
            BigDecimal[] iFrame = Matlib.interpolate((BigDecimal[])dates, (BigDecimal[])frames, (BigDecimal[])new BigDecimal[]{new BigDecimal(date.getTime())});
            if (iFrame != null && iFrame.length > 0 && iFrame[0] != null) {
                Timecode timecode = new Timecode(iFrame[0].doubleValue(), frameRate);
                returnTapeTime = new VideoTimeBean(date, timecode.toString());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Interpolated timecode at " + date + " is " + timecode + " using frameRate of " + frameRate + "[fps]");
                }
            }
        }
        return returnTapeTime;
    }

    private class LoadDataFunction
    implements QueryFunction<List<CameraDatum>> {
        private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        private final String platformName;

        public LoadDataFunction(String platformName) {
            this.platformName = platformName;
        }

        public List<CameraDatum> apply(ResultSet resultSet) throws SQLException {
            ArrayList<CameraDatum> data = new ArrayList<CameraDatum>();
            while (resultSet.next()) {
                Timestamp date = resultSet.getTimestamp(1, this.calendar);
                String timecode = resultSet.getString(2);
                String alternativeTimecode = resultSet.getString(3);
                Float focus = Float.valueOf(resultSet.getFloat(4));
                Float zoom = Float.valueOf(resultSet.getFloat(5));
                Float iris = Float.valueOf(resultSet.getFloat(6));
                data.add(new CameraDatumImpl(this.platformName, date, timecode, alternativeTimecode, focus, zoom, iris));
            }
            return data;
        }
    }
}

